/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.abolish.service.impl;

import cn.hutool.core.date.DateTime;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.tender.abolish.bean.WasteEntity;
import com.ejianc.business.tender.abolish.mapper.WasteMapper;
import com.ejianc.business.tender.abolish.service.IWasteService;
import com.ejianc.business.tender.abolish.vo.WasteBidTbVO;
import com.ejianc.business.tender.abolish.vo.WasteTbVO;
import com.ejianc.business.tender.abolish.vo.WasteVO;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentExpertEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentPicketageEntity;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentExpertService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteDetailService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.equipment.service.IEquipmentPicketageService;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteDetailVO;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingDetailEntity;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingDetailService;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.other.bean.OtherDocumentEntity;
import com.ejianc.business.tender.other.bean.OtherDocumentExpertEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.bean.OtherPicketageEntity;
import com.ejianc.business.tender.other.service.IOtherDocumentExpertService;
import com.ejianc.business.tender.other.service.IOtherDocumentService;
import com.ejianc.business.tender.other.service.IOtherInviteDetailService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.service.IOtherPicketageService;
import com.ejianc.business.tender.other.vo.OtherInviteDetailVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentEntity;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentExpertEntity;
import com.ejianc.business.tender.prosub.bean.ProsubInviteEntity;
import com.ejianc.business.tender.prosub.bean.ProsubPicketageEntity;
import com.ejianc.business.tender.prosub.service.IProsubDocumentExpertService;
import com.ejianc.business.tender.prosub.service.IProsubDocumentService;
import com.ejianc.business.tender.prosub.service.IProsubInviteDetailService;
import com.ejianc.business.tender.prosub.service.IProsubInviteService;
import com.ejianc.business.tender.prosub.service.IProsubPicketageService;
import com.ejianc.business.tender.prosub.vo.ProsubInviteVO;
import com.ejianc.business.tender.rent.bean.RentDocumentEntity;
import com.ejianc.business.tender.rent.bean.RentDocumentExpertEntity;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.bean.RentPicketageEntity;
import com.ejianc.business.tender.rent.service.IRentDocumentExpertService;
import com.ejianc.business.tender.rent.service.IRentDocumentService;
import com.ejianc.business.tender.rent.service.IRentInviteDetailService;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rent.service.IRentPicketageService;
import com.ejianc.business.tender.rent.vo.RentInviteDetailVO;
import com.ejianc.business.tender.rmat.bean.RmatDocumentEntity;
import com.ejianc.business.tender.rmat.bean.RmatDocumentExpertEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.bean.RmatPicketageEntity;
import com.ejianc.business.tender.rmat.service.IRmatDocumentExpertService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentService;
import com.ejianc.business.tender.rmat.service.IRmatInviteDetailService;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.rmat.service.IRmatPicketageService;
import com.ejianc.business.tender.rmat.vo.RmatInviteDetailVO;
import com.ejianc.business.tender.stuff.bean.StuffDocumentEntity;
import com.ejianc.business.tender.stuff.bean.StuffDocumentExpertEntity;
import com.ejianc.business.tender.stuff.bean.StuffInviteEntity;
import com.ejianc.business.tender.stuff.bean.StuffPicketageEntity;
import com.ejianc.business.tender.stuff.service.IStuffDocumentExpertService;
import com.ejianc.business.tender.stuff.service.IStuffDocumentService;
import com.ejianc.business.tender.stuff.service.IStuffInviteDetailService;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.stuff.service.IStuffPicketageService;
import com.ejianc.business.tender.stuff.vo.StuffInviteDetailVO;
import com.ejianc.business.tender.stuff.vo.TenderStageEnum;
import com.ejianc.business.tender.sub.bean.SubDocumentEntity;
import com.ejianc.business.tender.sub.bean.SubDocumentExpertEntity;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.bean.SubPicketageEntity;
import com.ejianc.business.tender.sub.service.ISubDocumentExpertService;
import com.ejianc.business.tender.sub.service.ISubDocumentService;
import com.ejianc.business.tender.sub.service.ISubInviteDetailService;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.sub.service.ISubPicketageService;
import com.ejianc.business.tender.sub.vo.SubInviteDetailVO;
import com.ejianc.business.tender.sub.vo.SubInviteVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.SendMsgUtils;
import com.ejianc.business.tender.util.TreeNodeBUtil;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="wasteService")
public class WasteServiceImpl
extends BaseServiceImpl<WasteMapper, WasteEntity>
implements IWasteService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Integer ABOLISH_TYPE_0 = 0;
    private static final Integer ABOLISH_TYPE_2 = 2;
    private static final Integer BID_FLAG = 0;
    private static final Integer PUBLISH_FLAG_YES = 0;
    private static final Integer PUBLISH_FLAG_NO = 1;
    private static final Integer WIN_BID_TYPE_2 = 2;
    private static final String OUT_REASON = "\u5df2\u5e9f\u6807";
    private static final Integer PURCHASE_TYPE_0 = 0;
    private static final Integer PURCHASE_TYPE_1 = 1;
    private static final String SEND_MAP_KEY_SUBJECT = "subject";
    private static final String SEND_MAP_KEY_CONTENT = "content";
    @Value(value="${gysUrl.updateBidOutUrl}")
    private String updateBidOutUrl;
    @Value(value="${gysUrl.winbidSavesUrl}")
    private String winbidSavesUrl;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IStuffInviteDetailService stuffInviteDetailService;
    @Autowired
    private ISubInviteDetailService subInviteDetailService;
    @Autowired
    private IProsubInviteDetailService prosubInviteDetailService;
    @Autowired
    private IEquipmentInviteDetailService equipmentInviteDetailService;
    @Autowired
    private IRentInviteDetailService rentInviteDetailService;
    @Autowired
    private IRmatInviteDetailService rmatInviteDetailService;
    @Autowired
    private IOtherInviteDetailService otherInviteDetailService;
    @Autowired
    private IStuffInviteService stuffInviteService;
    @Autowired
    private ISubInviteService subInviteService;
    @Autowired
    private IProsubInviteService prosubInviteService;
    @Autowired
    private IEquipmentInviteService equipmentInviteService;
    @Autowired
    private IRentInviteService rentInviteService;
    @Autowired
    private IRmatInviteService rmatInviteService;
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private IStuffDocumentService stuffDocumentService;
    @Autowired
    private ISubDocumentService subDocumentService;
    @Autowired
    private IProsubDocumentService prosubDocumentService;
    @Autowired
    private IEquipmentDocumentService equipmentDocumentService;
    @Autowired
    private IRentDocumentService rentDocumentService;
    @Autowired
    private IRmatDocumentService rmatDocumentService;
    @Autowired
    private IOtherDocumentService otherDocumentService;
    @Autowired
    private IStuffPicketageService stuffPicketageService;
    @Autowired
    private ISubPicketageService subPicketageService;
    @Autowired
    private IProsubPicketageService prosubPicketageService;
    @Autowired
    private IEquipmentPicketageService equipmentPicketageService;
    @Autowired
    private IRentPicketageService rentPicketageService;
    @Autowired
    private IRmatPicketageService rmatPicketageService;
    @Autowired
    private IOtherPicketageService otherPicketageService;
    @Autowired
    private IStuffDocumentExpertService stuffDocumentExpertService;
    @Autowired
    private ISubDocumentExpertService subDocumentExpertService;
    @Autowired
    private IProsubDocumentExpertService prosubDocumentExpertService;
    @Autowired
    private IEquipmentDocumentExpertService equipmentDocumentExpertService;
    @Autowired
    private IRentDocumentExpertService rentDocumentExpertService;
    @Autowired
    private IRmatDocumentExpertService rmatDocumentExpertService;
    @Autowired
    private IOtherDocumentExpertService otherDocumentExpertService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IExpertEvaluatingService IExpertEvaluatingService;
    @Autowired
    private IExpertEvaluatingDetailService IExpertEvaluatingDetailService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IPushMessageApi pushMessageApi;

    @Override
    public WasteVO saveOrUpdateByVo(WasteVO saveOrUpdateVO) {
        WasteEntity entity = (WasteEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, WasteEntity.class));
        this.checkWaste(saveOrUpdateVO);
        super.saveOrUpdate((Object)entity, false);
        WasteVO vo = this.copyWasteBean(entity);
        this.updateInvite(vo.getTenderId(), vo.getTenderStage(), vo.getType(), true);
        return vo;
    }

    @Override
    public void deleteByListVo(List<WasteVO> voList) {
        List idList = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", idList));
        List entityList = super.queryList(param);
        for (WasteEntity entity : entityList) {
            this.updateInvite(entity.getTenderId(), entity.getTenderStage(), entity.getType(), false);
        }
        super.removeByIds(idList, true);
    }

    @Override
    public WasteVO selectWasteVo(Long tenderId) {
        WasteVO vo;
        QueryParam param = new QueryParam();
        param.getParams().put("tenderId", new Parameter("eq", (Object)tenderId));
        List wasteEntityList = super.queryList(param);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)wasteEntityList)) {
            vo = new WasteVO();
            param.getOrderMap().put("createTime", "desc");
            List processEntityList = this.processService.queryList(param);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)processEntityList)) {
                ProcessEntity processEntity = (ProcessEntity)((Object)processEntityList.get(0));
                vo.setStageId(processEntity.getId());
                vo.setType(processEntity.getType());
            }
            this.initWasteVo(vo, tenderId);
        } else {
            WasteEntity entity = (WasteEntity)((Object)wasteEntityList.get(0));
            vo = this.copyWasteBean(entity);
        }
        return vo;
    }

    @Override
    public WasteVO queryDetailById(Long id) {
        WasteEntity entity = (WasteEntity)((Object)super.selectById((Serializable)id));
        if (entity == null || entity.getId() == 0L) {
            return new WasteVO();
        }
        return this.copyWasteBean(entity);
    }

    @Override
    public void updateGysByWaste(Long id) {
        WasteEntity wasteEntity = (WasteEntity)((Object)super.selectById((Serializable)id));
        WasteTbVO tbVO = new WasteTbVO();
        tbVO.setSourceId(this.objToString(wasteEntity.getTenderId()));
        tbVO.setType(ABOLISH_TYPE_2);
        tbVO.setOutReason(OUT_REASON);
        tbVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        String paramJson = JSON.toJSONString((Object)tbVO);
        this.sendPostReq(this.updateBidOutUrl, paramJson);
    }

    @Override
    public WasteVO publishWaste(Long id) {
        WasteEntity wasteEntity = (WasteEntity)((Object)super.selectById((Serializable)id));
        wasteEntity.setPublishFlag(PUBLISH_FLAG_YES);
        super.updateById((Object)wasteEntity);
        WasteBidTbVO wasteBidTbVO = new WasteBidTbVO();
        wasteBidTbVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u5e9f\u6807\u516c\u544a");
        wasteBidTbVO.setSourceId(this.objToString(wasteEntity.getTenderId()));
        wasteBidTbVO.setTendentId(wasteEntity.getTenantId());
        wasteBidTbVO.setSourceProjectId(this.objToString(wasteEntity.getProjectId()));
        wasteBidTbVO.setProjectName(wasteEntity.getProjectName());
        wasteBidTbVO.setProjectCode(wasteEntity.getProjectCode());
        wasteBidTbVO.setSourceOrgId(this.objToString(wasteEntity.getOrgId()));
        wasteBidTbVO.setOrgName(wasteEntity.getOrgName());
        wasteBidTbVO.setSourceUnitId(this.objToString(wasteEntity.getUnitId()));
        wasteBidTbVO.setUnitName(wasteEntity.getUnitName());
        wasteBidTbVO.setMemo(wasteEntity.getMemo());
        wasteBidTbVO.setContent(wasteEntity.getContent());
        wasteBidTbVO.setWinbidType(WIN_BID_TYPE_2);
        wasteBidTbVO.setType(CommonUtils.getGysType(wasteEntity.getType()));
        wasteBidTbVO.setTenderName(wasteEntity.getTenderName());
        wasteBidTbVO.setTenderType(wasteEntity.getTenderType());
        wasteBidTbVO.setSourceEmployeeId(this.objToString(wasteEntity.getEmployeeId()));
        wasteBidTbVO.setEmployeeName(wasteEntity.getEmployeeName());
        wasteBidTbVO.setEmployeeMobile(wasteEntity.getEmployeeMobile());
        if (0 == wasteEntity.getType()) {
            StuffInviteEntity stuffInviteEntity = (StuffInviteEntity)((Object)this.stuffInviteService.selectById(wasteEntity.getTenderId()));
            wasteBidTbVO.setPurchaseType(this.objToString(stuffInviteEntity.getPurchaseType()));
            wasteBidTbVO.setPurchaseName(stuffInviteEntity.getPurchaseName());
        }
        wasteBidTbVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        wasteBidTbVO.setNoticeWinbidTime(wasteEntity.getApplyTime());
        ArrayList<WasteBidTbVO> bidTbVOList = new ArrayList<WasteBidTbVO>();
        bidTbVOList.add(wasteBidTbVO);
        String paramJson = JSON.toJSONString(bidTbVOList);
        this.sendPostReq(this.winbidSavesUrl, paramJson);
        return this.copyWasteBean(wasteEntity);
    }

    @Override
    public void sendMsgByWaste(Integer type, Long tenderId) {
        ArrayList<String> userList = new ArrayList<String>();
        HashMap<String, String> sendMap = new HashMap<String, String>();
        if (0 == type) {
            this.pickSendStuffMsg(tenderId, userList, sendMap);
        } else if (1 == type) {
            this.pickSendSubMsg(tenderId, userList, sendMap);
        } else if (6 == type) {
            this.pickSendProsubMsg(tenderId, userList, sendMap);
        } else if (2 == type) {
            this.pickSendEquipmentMsg(tenderId, userList, sendMap);
        } else if (3 == type) {
            this.pickSendRentMsg(tenderId, userList, sendMap);
        } else if (4 == type) {
            this.pickSendRmatMsg(tenderId, userList, sendMap);
        } else if (5 == type) {
            this.pickSendOtherMsg(tenderId, userList, sendMap);
        } else {
            throw new BusinessException("\u4e0d\u5b58\u5728\u62db\u6807\u7acb\u9879\u7c7b\u578b[" + type + "]");
        }
        this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u4e13\u5bb6:>----------" + userList);
        if (CollectionUtils.isNotEmpty(userList) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(sendMap)) {
            String subject = (String)sendMap.get(SEND_MAP_KEY_SUBJECT);
            String content = (String)sendMap.get(SEND_MAP_KEY_CONTENT);
            this.logger.info("\u53d1\u9001\u4fe1\u606f\u7684\u5185\u5bb9:>----------" + content);
            new SendMsgUtils().sendSysMsg(userList, subject, content, this.pushMessageApi);
        }
    }

    @Override
    public void updateExpertEvaluatingByWaste(Long tenderId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("invite_id", new Parameter("eq", (Object)tenderId));
        List expertEvaluatingEntityList = this.IExpertEvaluatingService.queryList(queryParam, false);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)expertEvaluatingEntityList)) {
            UpdateWrapper wraper = new UpdateWrapper();
            ((UpdateWrapper)wraper.set((Object)"gather_status", (Object)1)).eq((Object)"invite_id", (Object)tenderId);
            this.IExpertEvaluatingService.update((Wrapper)wraper);
            List evaluationIdList = expertEvaluatingEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            UpdateWrapper detailWraper = new UpdateWrapper();
            ((UpdateWrapper)detailWraper.set((Object)"evaluation_state", (Object)2)).in((Object)"evaluation_id", evaluationIdList);
            this.IExpertEvaluatingDetailService.update((Wrapper)detailWraper);
            this.logger.info("\u5e9f\u6807\u751f\u6548\uff0c\u5c06\u8bc4\u6807\u72b6\u6001\u4fee\u6539\u4e3a\u5df2\u5931\u6548\uff0c\u6c47\u603b\u72b6\u6001\u6539\u4e3a\u5df2\u6c47\u603b");
        }
    }

    private void pickSendStuffMsg(Long tenderId, List<String> userList, Map<String, String> sendMap) {
        StuffInviteEntity stuffInviteEntity = (StuffInviteEntity)((Object)this.stuffInviteService.selectById(tenderId));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("invite_id", new Parameter("eq", (Object)tenderId));
        if (TenderStageEnum.DOCUMENT_STATE.getTenderTypeCode().equals(stuffInviteEntity.getTenderStage()) || TenderStageEnum.COMPETITIVE_NEGOTIATION_STATE.getTenderTypeCode().equals(stuffInviteEntity.getTenderStage()) || TenderStageEnum.SINGLE_STATE.getTenderTypeCode().equals(stuffInviteEntity.getTenderStage()) || TenderStageEnum.URGENT_STATE.getTenderTypeCode().equals(stuffInviteEntity.getTenderStage())) {
            Long documentId;
            List stuffInviteExpertEntityList;
            List stuffDocumentEntityList = this.stuffDocumentService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)stuffDocumentEntityList) && CollectionUtils.isNotEmpty((Collection)(stuffInviteExpertEntityList = this.stuffDocumentExpertService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_id", (Object)(documentId = ((StuffDocumentEntity)((Object)stuffDocumentEntityList.get(0))).getId()))).eq((Object)"dr", (Object)0))))) {
                List expertList = stuffInviteExpertEntityList.stream().filter(p -> p.getExpertId() != null).map(StuffDocumentExpertEntity::getExpertId).map(String::valueOf).collect(Collectors.toList());
                userList.addAll(expertList);
            }
        } else {
            this.pickCommonSendMsg(queryParam, userList);
        }
        String name = stuffInviteEntity.getPurchaseType() == 0 ? stuffInviteEntity.getProjectName() : stuffInviteEntity.getOrgName();
        String subject = stuffInviteEntity.getUnitName() + "\u62db\u6807\u7684" + name + OUT_REASON;
        String content = stuffInviteEntity.getUnitName() + "\u62db\u6807\u7684" + name + OUT_REASON;
        sendMap.put(SEND_MAP_KEY_SUBJECT, subject);
        sendMap.put(SEND_MAP_KEY_CONTENT, content);
    }

    private void pickSendSubMsg(Long tenderId, List<String> userList, Map<String, String> sendMap) {
        SubInviteEntity subInviteEntity = (SubInviteEntity)((Object)this.subInviteService.selectById(tenderId));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("invite_id", new Parameter("eq", (Object)tenderId));
        if (TenderStageEnum.DOCUMENT_STATE.getTenderTypeCode().equals(subInviteEntity.getTenderStage()) || TenderStageEnum.COMPETITIVE_NEGOTIATION_STATE.getTenderTypeCode().equals(subInviteEntity.getTenderStage()) || TenderStageEnum.SINGLE_STATE.getTenderTypeCode().equals(subInviteEntity.getTenderStage()) || TenderStageEnum.URGENT_STATE.getTenderTypeCode().equals(subInviteEntity.getTenderStage())) {
            Long documentId;
            List subInviteExpertEntityList;
            List subDocumentEntityList = this.subDocumentService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)subDocumentEntityList) && CollectionUtils.isNotEmpty((Collection)(subInviteExpertEntityList = this.subDocumentExpertService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_id", (Object)(documentId = ((SubDocumentEntity)((Object)subDocumentEntityList.get(0))).getId()))).eq((Object)"dr", (Object)0))))) {
                List expertList = subInviteExpertEntityList.stream().filter(p -> p.getExpertId() != null).map(SubDocumentExpertEntity::getExpertId).map(String::valueOf).collect(Collectors.toList());
                userList.addAll(expertList);
            }
        } else {
            this.pickCommonSendMsg(queryParam, userList);
        }
        String name = subInviteEntity.getProjectName();
        String subject = subInviteEntity.getUnitName() + "\u62db\u6807\u7684" + name + OUT_REASON;
        String content = subInviteEntity.getUnitName() + "\u62db\u6807\u7684" + name + OUT_REASON;
        sendMap.put(SEND_MAP_KEY_SUBJECT, subject);
        sendMap.put(SEND_MAP_KEY_CONTENT, content);
    }

    private void pickSendProsubMsg(Long tenderId, List<String> userList, Map<String, String> sendMap) {
        ProsubInviteEntity prosubInviteEntity = (ProsubInviteEntity)((Object)this.prosubInviteService.selectById(tenderId));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("invite_id", new Parameter("eq", (Object)tenderId));
        if (TenderStageEnum.DOCUMENT_STATE.getTenderTypeCode().equals(prosubInviteEntity.getTenderStage()) || TenderStageEnum.COMPETITIVE_NEGOTIATION_STATE.getTenderTypeCode().equals(prosubInviteEntity.getTenderStage()) || TenderStageEnum.SINGLE_STATE.getTenderTypeCode().equals(prosubInviteEntity.getTenderStage()) || TenderStageEnum.URGENT_STATE.getTenderTypeCode().equals(prosubInviteEntity.getTenderStage())) {
            Long documentId;
            List prosubInviteExpertEntityList;
            List prosubDocumentEntityList = this.prosubDocumentService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)prosubDocumentEntityList) && CollectionUtils.isNotEmpty((Collection)(prosubInviteExpertEntityList = this.prosubDocumentExpertService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_id", (Object)(documentId = ((ProsubDocumentEntity)((Object)prosubDocumentEntityList.get(0))).getId()))).eq((Object)"dr", (Object)0))))) {
                List expertList = prosubInviteExpertEntityList.stream().filter(p -> p.getExpertId() != null).map(ProsubDocumentExpertEntity::getExpertId).map(String::valueOf).collect(Collectors.toList());
                userList.addAll(expertList);
            }
        } else {
            this.pickCommonSendMsg(queryParam, userList);
        }
        String name = prosubInviteEntity.getProjectName();
        String subject = prosubInviteEntity.getUnitName() + "\u62db\u6807\u7684" + name + OUT_REASON;
        String content = prosubInviteEntity.getUnitName() + "\u62db\u6807\u7684" + name + OUT_REASON;
        sendMap.put(SEND_MAP_KEY_SUBJECT, subject);
        sendMap.put(SEND_MAP_KEY_CONTENT, content);
    }

    private void pickSendEquipmentMsg(Long tenderId, List<String> userList, Map<String, String> sendMap) {
        EquipmentInviteEntity equipmentInviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(tenderId));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("invite_id", new Parameter("eq", (Object)tenderId));
        if (TenderStageEnum.DOCUMENT_STATE.getTenderTypeCode().equals(equipmentInviteEntity.getTenderStage()) || TenderStageEnum.COMPETITIVE_NEGOTIATION_STATE.getTenderTypeCode().equals(equipmentInviteEntity.getTenderStage()) || TenderStageEnum.SINGLE_STATE.getTenderTypeCode().equals(equipmentInviteEntity.getTenderStage()) || TenderStageEnum.URGENT_STATE.getTenderTypeCode().equals(equipmentInviteEntity.getTenderStage())) {
            Long documentId;
            List equipmentInviteExpertEntityList;
            List equipmentDocumentEntityList = this.equipmentDocumentService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)equipmentDocumentEntityList) && CollectionUtils.isNotEmpty((Collection)(equipmentInviteExpertEntityList = this.equipmentDocumentExpertService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_id", (Object)(documentId = ((EquipmentDocumentEntity)((Object)equipmentDocumentEntityList.get(0))).getId()))).eq((Object)"dr", (Object)0))))) {
                List expertList = equipmentInviteExpertEntityList.stream().filter(p -> p.getExpertId() != null).map(EquipmentDocumentExpertEntity::getExpertId).map(String::valueOf).collect(Collectors.toList());
                userList.addAll(expertList);
            }
        } else {
            this.pickCommonSendMsg(queryParam, userList);
        }
        String name = equipmentInviteEntity.getProjectName();
        String subject = equipmentInviteEntity.getUnitName() + "\u62db\u6807\u7684" + name + OUT_REASON;
        String content = equipmentInviteEntity.getUnitName() + "\u62db\u6807\u7684" + name + OUT_REASON;
        sendMap.put(SEND_MAP_KEY_SUBJECT, subject);
        sendMap.put(SEND_MAP_KEY_CONTENT, content);
    }

    private void pickSendRentMsg(Long tenderId, List<String> userList, Map<String, String> sendMap) {
        RentInviteEntity rentInviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(tenderId));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("invite_id", new Parameter("eq", (Object)tenderId));
        if (TenderStageEnum.DOCUMENT_STATE.getTenderTypeCode().equals(rentInviteEntity.getTenderStage()) || TenderStageEnum.COMPETITIVE_NEGOTIATION_STATE.getTenderTypeCode().equals(rentInviteEntity.getTenderStage()) || TenderStageEnum.SINGLE_STATE.getTenderTypeCode().equals(rentInviteEntity.getTenderStage()) || TenderStageEnum.URGENT_STATE.getTenderTypeCode().equals(rentInviteEntity.getTenderStage())) {
            Long documentId;
            List rentInviteExpertEntityList;
            List rentDocumentEntityList = this.rentDocumentService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)rentDocumentEntityList) && CollectionUtils.isNotEmpty((Collection)(rentInviteExpertEntityList = this.rentDocumentExpertService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_id", (Object)(documentId = ((RentDocumentEntity)((Object)rentDocumentEntityList.get(0))).getId()))).eq((Object)"dr", (Object)0))))) {
                List expertList = rentInviteExpertEntityList.stream().filter(p -> p.getExpertId() != null).map(RentDocumentExpertEntity::getExpertId).map(String::valueOf).collect(Collectors.toList());
                userList.addAll(expertList);
            }
        } else {
            this.pickCommonSendMsg(queryParam, userList);
        }
        String name = rentInviteEntity.getProjectName();
        String subject = rentInviteEntity.getUnitName() + "\u62db\u6807\u7684" + name + OUT_REASON;
        String content = rentInviteEntity.getUnitName() + "\u62db\u6807\u7684" + name + OUT_REASON;
        sendMap.put(SEND_MAP_KEY_SUBJECT, subject);
        sendMap.put(SEND_MAP_KEY_CONTENT, content);
    }

    private void pickSendRmatMsg(Long tenderId, List<String> userList, Map<String, String> sendMap) {
        RmatInviteEntity rmatInviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(tenderId));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("invite_id", new Parameter("eq", (Object)tenderId));
        if (TenderStageEnum.DOCUMENT_STATE.getTenderTypeCode().equals(rmatInviteEntity.getTenderStage()) || TenderStageEnum.COMPETITIVE_NEGOTIATION_STATE.getTenderTypeCode().equals(rmatInviteEntity.getTenderStage()) || TenderStageEnum.SINGLE_STATE.getTenderTypeCode().equals(rmatInviteEntity.getTenderStage()) || TenderStageEnum.URGENT_STATE.getTenderTypeCode().equals(rmatInviteEntity.getTenderStage())) {
            Long documentId;
            List rmatInviteExpertEntityList;
            List rmatDocumentEntityList = this.rmatDocumentService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)rmatDocumentEntityList) && CollectionUtils.isNotEmpty((Collection)(rmatInviteExpertEntityList = this.rmatDocumentExpertService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_id", (Object)(documentId = ((RmatDocumentEntity)((Object)rmatDocumentEntityList.get(0))).getId()))).eq((Object)"dr", (Object)0))))) {
                List expertList = rmatInviteExpertEntityList.stream().filter(p -> p.getExpertId() != null).map(RmatDocumentExpertEntity::getExpertId).map(String::valueOf).collect(Collectors.toList());
                userList.addAll(expertList);
            }
        } else {
            this.pickCommonSendMsg(queryParam, userList);
        }
        String name = rmatInviteEntity.getProjectName();
        String subject = rmatInviteEntity.getUnitName() + "\u62db\u6807\u7684" + name + OUT_REASON;
        String content = rmatInviteEntity.getUnitName() + "\u62db\u6807\u7684" + name + OUT_REASON;
        sendMap.put(SEND_MAP_KEY_SUBJECT, subject);
        sendMap.put(SEND_MAP_KEY_CONTENT, content);
    }

    private void pickSendOtherMsg(Long tenderId, List<String> userList, Map<String, String> sendMap) {
        OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(tenderId));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("invite_id", new Parameter("eq", (Object)tenderId));
        if (TenderStageEnum.DOCUMENT_STATE.getTenderTypeCode().equals(otherInviteEntity.getTenderStage()) || TenderStageEnum.COMPETITIVE_NEGOTIATION_STATE.getTenderTypeCode().equals(otherInviteEntity.getTenderStage()) || TenderStageEnum.SINGLE_STATE.getTenderTypeCode().equals(otherInviteEntity.getTenderStage()) || TenderStageEnum.URGENT_STATE.getTenderTypeCode().equals(otherInviteEntity.getTenderStage())) {
            Long documentId;
            List otherInviteExpertEntityList;
            List otherDocumentEntityList = this.otherDocumentService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)otherDocumentEntityList) && CollectionUtils.isNotEmpty((Collection)(otherInviteExpertEntityList = this.otherDocumentExpertService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_id", (Object)(documentId = ((OtherDocumentEntity)((Object)otherDocumentEntityList.get(0))).getId()))).eq((Object)"dr", (Object)0))))) {
                List expertList = otherInviteExpertEntityList.stream().filter(p -> p.getExpertId() != null).map(OtherDocumentExpertEntity::getExpertId).map(String::valueOf).collect(Collectors.toList());
                userList.addAll(expertList);
            }
        } else {
            this.pickCommonSendMsg(queryParam, userList);
        }
        String name = otherInviteEntity.getProjectName();
        String subject = otherInviteEntity.getUnitName() + "\u62db\u6807\u7684" + name + OUT_REASON;
        String content = otherInviteEntity.getUnitName() + "\u62db\u6807\u7684" + name + OUT_REASON;
        sendMap.put(SEND_MAP_KEY_SUBJECT, subject);
        sendMap.put(SEND_MAP_KEY_CONTENT, content);
    }

    private void pickCommonSendMsg(QueryParam queryParam, List<String> userList) {
        Long evaluationId;
        List expertEvaluatingDetailEntityList;
        List expertEvaluatingEntityList = this.IExpertEvaluatingService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)expertEvaluatingEntityList) && CollectionUtils.isNotEmpty((Collection)(expertEvaluatingDetailEntityList = this.IExpertEvaluatingDetailService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"evaluation_id", (Object)(evaluationId = ((ExpertEvaluatingEntity)((Object)expertEvaluatingEntityList.get(0))).getId()))).eq((Object)"dr", (Object)0))))) {
            List expertList = expertEvaluatingDetailEntityList.stream().filter(p -> p.getExpertId() != null).map(ExpertEvaluatingDetailEntity::getExpertId).map(String::valueOf).collect(Collectors.toList());
            userList.addAll(expertList);
        }
    }

    private List<StuffInviteDetailVO> queryInviteDetailByWaste(Long tenderId) {
        if (null == tenderId || tenderId == 0L) {
            return new ArrayList<StuffInviteDetailVO>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("inviteId", new Parameter("eq", (Object)tenderId));
        List list = this.stuffInviteDetailService.queryList(param);
        return BeanMapper.mapList((Iterable)list, StuffInviteDetailVO.class);
    }

    private List<SubInviteDetailVO> querySubInviteDetailByWaste(Long tenderId) {
        if (null == tenderId || tenderId == 0L) {
            return new ArrayList<SubInviteDetailVO>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("inviteId", new Parameter("eq", (Object)tenderId));
        List list = this.subInviteDetailService.queryList(param);
        return BeanMapper.mapList((Iterable)list, SubInviteDetailVO.class);
    }

    private List<EquipmentInviteDetailVO> queryEquipmentInviteDetailByWaste(Long tenderId) {
        if (null == tenderId || tenderId == 0L) {
            return new ArrayList<EquipmentInviteDetailVO>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("inviteId", new Parameter("eq", (Object)tenderId));
        List list = this.equipmentInviteDetailService.queryList(param);
        return BeanMapper.mapList((Iterable)list, EquipmentInviteDetailVO.class);
    }

    private List<RentInviteDetailVO> queryRentInviteDetailByWaste(Long tenderId) {
        if (null == tenderId || tenderId == 0L) {
            return new ArrayList<RentInviteDetailVO>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("inviteId", new Parameter("eq", (Object)tenderId));
        List list = this.rentInviteDetailService.queryList(param);
        return BeanMapper.mapList((Iterable)list, RentInviteDetailVO.class);
    }

    private List<RmatInviteDetailVO> queryRmatInviteDetailByWaste(Long tenderId) {
        if (null == tenderId || tenderId == 0L) {
            return new ArrayList<RmatInviteDetailVO>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("inviteId", new Parameter("eq", (Object)tenderId));
        List list = this.rmatInviteDetailService.queryList(param);
        return BeanMapper.mapList((Iterable)list, RmatInviteDetailVO.class);
    }

    private List<OtherInviteDetailVO> queryOtherInviteDetailByWaste(Long tenderId) {
        if (null == tenderId || tenderId == 0L) {
            return new ArrayList<OtherInviteDetailVO>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("inviteId", new Parameter("eq", (Object)tenderId));
        List list = this.otherInviteDetailService.queryList(param);
        return BeanMapper.mapList((Iterable)list, OtherInviteDetailVO.class);
    }

    private void updateInvite(Long tenderId, Integer tenderStage, Integer type, boolean addFlag) {
        if (0 == type) {
            this.updateInviteByWaste(tenderId, tenderStage, addFlag);
        } else if (1 == type) {
            this.updateSubInviteByWaste(tenderId, tenderStage, addFlag);
        } else if (6 == type) {
            this.updateProsubInviteByWaste(tenderId, tenderStage, addFlag);
        } else if (2 == type) {
            this.updateEquipmentInviteByWaste(tenderId, tenderStage, addFlag);
        } else if (3 == type) {
            this.updateRentInviteByWaste(tenderId, tenderStage, addFlag);
        } else if (4 == type) {
            this.updateRmatInviteByWaste(tenderId, tenderStage, addFlag);
        } else if (5 == type) {
            this.updateOtherInviteByWaste(tenderId, tenderStage, addFlag);
        } else {
            throw new BusinessException("\u4e0d\u5b58\u5728\u62db\u6807\u7acb\u9879\u7c7b\u578b[" + type + "]");
        }
    }

    private void updateInviteByWaste(Long tenderId, Integer tenderStage, boolean addFlag) {
        StuffInviteEntity stuffInviteEntity = (StuffInviteEntity)((Object)this.stuffInviteService.selectById(tenderId));
        if (stuffInviteEntity != null && stuffInviteEntity.getId() != 0L) {
            Integer abolishType = stuffInviteEntity.getAbolishType();
            if (addFlag && (abolishType == null || ABOLISH_TYPE_0.equals(abolishType))) {
                this.stuffInviteService.updateAbolishType(this.objToString(tenderId), ABOLISH_TYPE_2);
                this.stuffInviteService.updateTenderStage(this.objToString(tenderId), TenderStageEnum.WASTE_STATE.getTenderTypeCode());
            }
            if (!addFlag && ABOLISH_TYPE_2.equals(abolishType)) {
                this.stuffInviteService.updateAbolishType(this.objToString(tenderId), ABOLISH_TYPE_0);
                this.stuffInviteService.updateTenderStage(this.objToString(tenderId), tenderStage);
            }
        }
    }

    private void updateSubInviteByWaste(Long tenderId, Integer tenderStage, boolean addFlag) {
        SubInviteEntity subInviteEntity = (SubInviteEntity)((Object)this.subInviteService.selectById(tenderId));
        if (subInviteEntity != null && subInviteEntity.getId() != 0L) {
            Integer abolishType = subInviteEntity.getAbolishType();
            if (addFlag && (abolishType == null || ABOLISH_TYPE_0.equals(abolishType))) {
                this.subInviteService.updateAbolishType(this.objToString(tenderId), ABOLISH_TYPE_2);
                this.subInviteService.updateTenderStage(this.objToString(tenderId), TenderStageEnum.WASTE_STATE.getTenderTypeCode());
            }
            if (!addFlag && ABOLISH_TYPE_2.equals(abolishType)) {
                this.subInviteService.updateAbolishType(this.objToString(tenderId), ABOLISH_TYPE_0);
                this.subInviteService.updateTenderStage(this.objToString(tenderId), tenderStage);
            }
        }
    }

    private void updateProsubInviteByWaste(Long tenderId, Integer tenderStage, boolean addFlag) {
        ProsubInviteEntity prosubInviteEntity = (ProsubInviteEntity)((Object)this.prosubInviteService.selectById(tenderId));
        if (prosubInviteEntity != null && prosubInviteEntity.getId() != 0L) {
            Integer abolishType = prosubInviteEntity.getAbolishType();
            if (addFlag && (abolishType == null || ABOLISH_TYPE_0.equals(abolishType))) {
                this.prosubInviteService.updateAbolishType(this.objToString(tenderId), ABOLISH_TYPE_2);
                this.prosubInviteService.updateTenderStage(this.objToString(tenderId), TenderStageEnum.WASTE_STATE.getTenderTypeCode());
            }
            if (!addFlag && ABOLISH_TYPE_2.equals(abolishType)) {
                this.prosubInviteService.updateAbolishType(this.objToString(tenderId), ABOLISH_TYPE_0);
                this.prosubInviteService.updateTenderStage(this.objToString(tenderId), tenderStage);
            }
        }
    }

    private void updateEquipmentInviteByWaste(Long tenderId, Integer tenderStage, boolean addFlag) {
        EquipmentInviteEntity equipmentInviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(tenderId));
        if (equipmentInviteEntity != null && equipmentInviteEntity.getId() != 0L) {
            Integer abolishType = equipmentInviteEntity.getAbolishType();
            if (addFlag && (abolishType == null || ABOLISH_TYPE_0.equals(abolishType))) {
                this.equipmentInviteService.updateAbolishType(this.objToString(tenderId), ABOLISH_TYPE_2);
                this.equipmentInviteService.updateTenderStage(this.objToString(tenderId), TenderStageEnum.WASTE_STATE.getTenderTypeCode());
            }
            if (!addFlag && ABOLISH_TYPE_2.equals(abolishType)) {
                this.equipmentInviteService.updateAbolishType(this.objToString(tenderId), ABOLISH_TYPE_0);
                this.equipmentInviteService.updateTenderStage(this.objToString(tenderId), tenderStage);
            }
        }
    }

    private void updateRentInviteByWaste(Long tenderId, Integer tenderStage, boolean addFlag) {
        RentInviteEntity rentInviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(tenderId));
        if (rentInviteEntity != null && rentInviteEntity.getId() != 0L) {
            Integer abolishType = rentInviteEntity.getAbolishType();
            if (addFlag && (abolishType == null || ABOLISH_TYPE_0.equals(abolishType))) {
                this.rentInviteService.updateAbolishType(this.objToString(tenderId), ABOLISH_TYPE_2);
                this.rentInviteService.updateTenderStage(this.objToString(tenderId), TenderStageEnum.WASTE_STATE.getTenderTypeCode());
            }
            if (!addFlag && ABOLISH_TYPE_2.equals(abolishType)) {
                this.rentInviteService.updateAbolishType(this.objToString(tenderId), ABOLISH_TYPE_0);
                this.rentInviteService.updateTenderStage(this.objToString(tenderId), tenderStage);
            }
        }
    }

    private void updateRmatInviteByWaste(Long tenderId, Integer tenderStage, boolean addFlag) {
        RmatInviteEntity rmatInviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(tenderId));
        if (rmatInviteEntity != null && rmatInviteEntity.getId() != 0L) {
            Integer abolishType = rmatInviteEntity.getAbolishType();
            if (addFlag && (abolishType == null || ABOLISH_TYPE_0.equals(abolishType))) {
                this.rmatInviteService.updateAbolishType(this.objToString(tenderId), ABOLISH_TYPE_2);
                this.rmatInviteService.updateTenderStage(this.objToString(tenderId), TenderStageEnum.WASTE_STATE.getTenderTypeCode());
            }
            if (!addFlag && ABOLISH_TYPE_2.equals(abolishType)) {
                this.rmatInviteService.updateAbolishType(this.objToString(tenderId), ABOLISH_TYPE_0);
                this.rmatInviteService.updateTenderStage(this.objToString(tenderId), tenderStage);
            }
        }
    }

    private void updateOtherInviteByWaste(Long tenderId, Integer tenderStage, boolean addFlag) {
        OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(tenderId));
        if (otherInviteEntity != null && otherInviteEntity.getId() != 0L) {
            Integer abolishType = otherInviteEntity.getAbolishType();
            if (addFlag && (abolishType == null || ABOLISH_TYPE_0.equals(abolishType))) {
                this.otherInviteService.updateAbolishType(this.objToString(tenderId), ABOLISH_TYPE_2);
                this.otherInviteService.updateTenderStage(this.objToString(tenderId), TenderStageEnum.WASTE_STATE.getTenderTypeCode());
            }
            if (!addFlag && ABOLISH_TYPE_2.equals(abolishType)) {
                this.otherInviteService.updateAbolishType(this.objToString(tenderId), ABOLISH_TYPE_0);
                this.otherInviteService.updateTenderStage(this.objToString(tenderId), tenderStage);
            }
        }
    }

    private void initWasteVo(WasteVO vo, Long tenderId) {
        if (0 == vo.getType()) {
            this.initStuffWasteVo(vo, tenderId);
        } else if (1 == vo.getType()) {
            this.initSubWasteVo(vo, tenderId);
        } else if (6 == vo.getType()) {
            this.initProsubWasteVo(vo, tenderId);
        } else if (2 == vo.getType()) {
            this.initEquipmentWasteVo(vo, tenderId);
        } else if (3 == vo.getType()) {
            this.initRentWasteVo(vo, tenderId);
        } else if (4 == vo.getType()) {
            this.initRmatWasteVo(vo, tenderId);
        } else if (5 == vo.getType()) {
            this.initOtherWasteVo(vo, tenderId);
        } else {
            throw new BusinessException("\u4e0d\u5b58\u5728\u62db\u6807\u7acb\u9879\u7c7b\u578b[" + vo.getType() + "]");
        }
    }

    private void initStuffWasteVo(WasteVO vo, Long tenderId) {
        StuffInviteEntity stuffInviteEntity = (StuffInviteEntity)((Object)this.stuffInviteService.selectById(tenderId));
        if (stuffInviteEntity != null) {
            vo.setPurchaseId(stuffInviteEntity.getPurchaseId());
            vo.setPurchaseName(stuffInviteEntity.getPurchaseName());
            vo.setPurchaseType(stuffInviteEntity.getPurchaseType());
            vo.setPurchaseTypeName(this.getPurchaseTypeNameByType(stuffInviteEntity.getPurchaseType()));
            vo.setProjectId(stuffInviteEntity.getProjectId());
            vo.setProjectName(stuffInviteEntity.getProjectName());
            vo.setProjectCode(stuffInviteEntity.getProjectCode());
            vo.setTenderId(stuffInviteEntity.getId());
            vo.setTenderName(stuffInviteEntity.getTenderName());
            vo.setTenderType(stuffInviteEntity.getTenderType());
            vo.setTenderStage(stuffInviteEntity.getTenderStage());
            vo.setOrgId(stuffInviteEntity.getOrgId());
            vo.setOrgName(stuffInviteEntity.getOrgName());
            vo.setParentOrgId(stuffInviteEntity.getParentOrgId());
            vo.setParentOrgName(stuffInviteEntity.getParentOrgName());
            vo.setPublishFlag(PUBLISH_FLAG_NO);
            vo.setApplyTime((Date)new DateTime());
            vo.setStuffInviteDetailList(BeanMapper.mapList(stuffInviteEntity.getStuffDetail(), StuffInviteDetailVO.class));
        }
    }

    private void initSubWasteVo(WasteVO vo, Long tenderId) {
        SubInviteEntity subInviteEntity = (SubInviteEntity)((Object)this.subInviteService.selectById(tenderId));
        if (subInviteEntity != null) {
            vo.setPurchaseType(subInviteEntity.getPurchaseType());
            vo.setPurchaseTypeName(this.getPurchaseTypeNameByType(subInviteEntity.getPurchaseType()));
            vo.setProjectId(subInviteEntity.getProjectId());
            vo.setProjectName(subInviteEntity.getProjectName());
            vo.setProjectCode(subInviteEntity.getProjectCode());
            vo.setTenderId(subInviteEntity.getId());
            vo.setTenderName(subInviteEntity.getTenderName());
            vo.setTenderType(subInviteEntity.getTenderType());
            vo.setTenderStage(subInviteEntity.getTenderStage());
            vo.setOrgId(subInviteEntity.getOrgId());
            vo.setOrgName(subInviteEntity.getOrgName());
            vo.setParentOrgId(subInviteEntity.getParentOrgId());
            vo.setParentOrgName(subInviteEntity.getParentOrgName());
            vo.setPublishFlag(PUBLISH_FLAG_NO);
            vo.setApplyTime((Date)new DateTime());
            SubInviteVO subInviteVO = (SubInviteVO)BeanMapper.map((Object)((Object)subInviteEntity), SubInviteVO.class);
            vo.setSubInviteDetailList(TreeNodeBUtil.buildTree((List)subInviteVO.getSubDetailRecord()));
        }
    }

    private void initProsubWasteVo(WasteVO vo, Long tenderId) {
        ProsubInviteEntity prosubInviteEntity = (ProsubInviteEntity)((Object)this.prosubInviteService.selectById(tenderId));
        if (prosubInviteEntity != null) {
            vo.setPurchaseType(prosubInviteEntity.getPurchaseType());
            vo.setPurchaseTypeName(this.getPurchaseTypeNameByType(prosubInviteEntity.getPurchaseType()));
            vo.setProjectId(prosubInviteEntity.getProjectId());
            vo.setProjectName(prosubInviteEntity.getProjectName());
            vo.setProjectCode(prosubInviteEntity.getProjectCode());
            vo.setTenderId(prosubInviteEntity.getId());
            vo.setTenderName(prosubInviteEntity.getTenderName());
            vo.setTenderType(prosubInviteEntity.getTenderType());
            vo.setTenderStage(prosubInviteEntity.getTenderStage());
            vo.setOrgId(prosubInviteEntity.getOrgId());
            vo.setOrgName(prosubInviteEntity.getOrgName());
            vo.setParentOrgId(prosubInviteEntity.getParentOrgId());
            vo.setParentOrgName(prosubInviteEntity.getParentOrgName());
            vo.setPublishFlag(PUBLISH_FLAG_NO);
            vo.setApplyTime((Date)new DateTime());
            ProsubInviteVO prosubInviteVO = (ProsubInviteVO)BeanMapper.map((Object)((Object)prosubInviteEntity), ProsubInviteVO.class);
            vo.setProsubInviteDetailList(TreeNodeBUtil.buildTree((List)prosubInviteVO.getSubDetailRecord()));
        }
    }

    private void initEquipmentWasteVo(WasteVO vo, Long tenderId) {
        EquipmentInviteEntity equipmentInviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(tenderId));
        if (equipmentInviteEntity != null) {
            vo.setPurchaseType(equipmentInviteEntity.getPurchaseType());
            vo.setPurchaseTypeName(this.getPurchaseTypeNameByType(equipmentInviteEntity.getPurchaseType()));
            vo.setProjectId(equipmentInviteEntity.getProjectId());
            vo.setProjectName(equipmentInviteEntity.getProjectName());
            vo.setProjectCode(equipmentInviteEntity.getProjectCode());
            vo.setTenderId(equipmentInviteEntity.getId());
            vo.setTenderName(equipmentInviteEntity.getTenderName());
            vo.setTenderType(equipmentInviteEntity.getTenderType());
            vo.setTenderStage(equipmentInviteEntity.getTenderStage());
            vo.setOrgId(equipmentInviteEntity.getOrgId());
            vo.setOrgName(equipmentInviteEntity.getOrgName());
            vo.setParentOrgId(equipmentInviteEntity.getParentOrgId());
            vo.setParentOrgName(equipmentInviteEntity.getParentOrgName());
            vo.setPublishFlag(PUBLISH_FLAG_NO);
            vo.setApplyTime((Date)new DateTime());
            vo.setEquipmentInviteDetailList(BeanMapper.mapList(equipmentInviteEntity.getEquipmentDetail(), EquipmentInviteDetailVO.class));
        }
    }

    private void initRentWasteVo(WasteVO vo, Long tenderId) {
        RentInviteEntity rentInviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(tenderId));
        if (rentInviteEntity != null) {
            vo.setPurchaseType(rentInviteEntity.getPurchaseType());
            vo.setPurchaseTypeName(this.getPurchaseTypeNameByType(rentInviteEntity.getPurchaseType()));
            vo.setProjectId(rentInviteEntity.getProjectId());
            vo.setProjectName(rentInviteEntity.getProjectName());
            vo.setProjectCode(rentInviteEntity.getProjectCode());
            vo.setTenderId(rentInviteEntity.getId());
            vo.setTenderName(rentInviteEntity.getTenderName());
            vo.setTenderType(rentInviteEntity.getTenderType());
            vo.setTenderStage(rentInviteEntity.getTenderStage());
            vo.setOrgId(rentInviteEntity.getOrgId());
            vo.setOrgName(rentInviteEntity.getOrgName());
            vo.setParentOrgId(rentInviteEntity.getParentOrgId());
            vo.setParentOrgName(rentInviteEntity.getParentOrgName());
            vo.setPublishFlag(PUBLISH_FLAG_NO);
            vo.setApplyTime((Date)new DateTime());
            vo.setRentInviteDetailList(BeanMapper.mapList(rentInviteEntity.getRentDetail(), RentInviteDetailVO.class));
        }
    }

    private void initRmatWasteVo(WasteVO vo, Long tenderId) {
        RmatInviteEntity rmatInviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(tenderId));
        if (rmatInviteEntity != null) {
            vo.setPurchaseType(rmatInviteEntity.getPurchaseType());
            vo.setPurchaseTypeName(this.getPurchaseTypeNameByType(rmatInviteEntity.getPurchaseType()));
            vo.setProjectId(rmatInviteEntity.getProjectId());
            vo.setProjectName(rmatInviteEntity.getProjectName());
            vo.setProjectCode(rmatInviteEntity.getProjectCode());
            vo.setTenderId(rmatInviteEntity.getId());
            vo.setTenderName(rmatInviteEntity.getTenderName());
            vo.setTenderType(rmatInviteEntity.getTenderType());
            vo.setTenderStage(rmatInviteEntity.getTenderStage());
            vo.setOrgId(rmatInviteEntity.getOrgId());
            vo.setOrgName(rmatInviteEntity.getOrgName());
            vo.setParentOrgId(rmatInviteEntity.getParentOrgId());
            vo.setParentOrgName(rmatInviteEntity.getParentOrgName());
            vo.setPublishFlag(PUBLISH_FLAG_NO);
            vo.setApplyTime((Date)new DateTime());
            vo.setRmatInviteDetailList(BeanMapper.mapList(rmatInviteEntity.getRmatDetail(), RmatInviteDetailVO.class));
        }
    }

    private void initOtherWasteVo(WasteVO vo, Long tenderId) {
        OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(tenderId));
        if (otherInviteEntity != null) {
            vo.setPurchaseType(otherInviteEntity.getPurchaseType());
            vo.setPurchaseTypeName(this.getPurchaseTypeNameByType(otherInviteEntity.getPurchaseType()));
            vo.setProjectId(otherInviteEntity.getProjectId());
            vo.setProjectName(otherInviteEntity.getProjectName());
            vo.setProjectCode(otherInviteEntity.getProjectCode());
            vo.setTenderId(otherInviteEntity.getId());
            vo.setTenderName(otherInviteEntity.getTenderName());
            vo.setTenderType(otherInviteEntity.getTenderType());
            vo.setTenderStage(otherInviteEntity.getTenderStage());
            vo.setOrgId(otherInviteEntity.getOrgId());
            vo.setOrgName(otherInviteEntity.getOrgName());
            vo.setParentOrgId(otherInviteEntity.getParentOrgId());
            vo.setParentOrgName(otherInviteEntity.getParentOrgName());
            vo.setPublishFlag(PUBLISH_FLAG_NO);
            vo.setApplyTime((Date)new DateTime());
            vo.setOtherInviteDetailList(BeanMapper.mapList(otherInviteEntity.getOtherDetail(), OtherInviteDetailVO.class));
        }
    }

    private void deleteProcess(Long billId, Long tenderId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billId", new Parameter("eq", (Object)billId));
        queryParam.getParams().put("tenderId", new Parameter("eq", (Object)tenderId));
        List processEntityList = this.processService.queryList(queryParam);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)processEntityList)) {
            List idList = processEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            this.processService.removeByIds(idList);
        }
    }

    private WasteVO copyWasteBean(WasteEntity entity) {
        String tenderTypeName;
        switch (entity.getTenderType()) {
            case 0: {
                tenderTypeName = "\u5e73\u53f0\u516c\u5f00\u62db\u6807";
                break;
            }
            case 1: {
                tenderTypeName = "\u9080\u8bf7\u62db\u6807";
                break;
            }
            case 2: {
                tenderTypeName = "\u8be2\u4ef7";
                break;
            }
            case 3: {
                tenderTypeName = "\u7ade\u4e89\u6027\u8c08\u5224";
                break;
            }
            case 4: {
                tenderTypeName = "\u5355\u4e00\u6765\u6e90";
                break;
            }
            case 5: {
                tenderTypeName = "\u7d27\u6025\u62db\u6807";
                break;
            }
            default: {
                tenderTypeName = null;
            }
        }
        WasteVO vo = (WasteVO)BeanMapper.map((Object)((Object)entity), WasteVO.class);
        vo.setTenderTypeName(tenderTypeName);
        if (0 == vo.getType()) {
            vo.setStuffInviteDetailList(this.queryInviteDetailByWaste(entity.getTenderId()));
        } else if (1 == vo.getType()) {
            SubInviteEntity subInviteEntity = (SubInviteEntity)((Object)this.subInviteService.selectById(vo.getTenderId()));
            SubInviteVO subInviteVO = (SubInviteVO)BeanMapper.map((Object)((Object)subInviteEntity), SubInviteVO.class);
            vo.setSubInviteDetailList(TreeNodeBUtil.buildTree((List)subInviteVO.getSubDetailRecord()));
        } else if (6 == vo.getType()) {
            ProsubInviteEntity prosubInviteEntity = (ProsubInviteEntity)((Object)this.prosubInviteService.selectById(vo.getTenderId()));
            ProsubInviteVO prosubInviteVO = (ProsubInviteVO)BeanMapper.map((Object)((Object)prosubInviteEntity), ProsubInviteVO.class);
            vo.setProsubInviteDetailList(TreeNodeBUtil.buildTree((List)prosubInviteVO.getSubDetailRecord()));
        } else if (2 == vo.getType()) {
            vo.setEquipmentInviteDetailList(this.queryEquipmentInviteDetailByWaste(entity.getTenderId()));
        } else if (3 == vo.getType()) {
            vo.setRentInviteDetailList(this.queryRentInviteDetailByWaste(entity.getTenderId()));
        } else if (4 == vo.getType()) {
            vo.setRmatInviteDetailList(this.queryRmatInviteDetailByWaste(entity.getTenderId()));
        } else if (5 == vo.getType()) {
            vo.setOtherInviteDetailList(this.queryOtherInviteDetailByWaste(entity.getTenderId()));
        } else {
            throw new BusinessException("\u4e0d\u5b58\u5728\u62db\u6807\u7acb\u9879\u7c7b\u578b[" + vo.getType() + "]");
        }
        vo.setPurchaseTypeName(this.getPurchaseTypeNameByType(entity.getPurchaseType()));
        return vo;
    }

    private String getPurchaseTypeNameByType(Integer purchaseType) {
        String purchaseTypeName;
        switch (purchaseType) {
            case 0: {
                purchaseTypeName = "\u9879\u76ee\u91c7\u8d2d";
                break;
            }
            case 1: {
                purchaseTypeName = "\u516c\u53f8\u91c7\u8d2d";
                break;
            }
            default: {
                purchaseTypeName = null;
            }
        }
        return purchaseTypeName;
    }

    private void sendPostReq(String url, String paramJson) {
        CommonResponse response = null;
        try {
            this.logger.info("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u53d1\u9001\u53c2\u6570\uff1a{}", (Object)paramJson);
            response = this.systemDataPushService.exchangeDataWithUniversal(url, RequestMethod.POST, paramJson, this.appId, this.appSecret, this.appHost);
            if (!response.isSuccess()) {
                throw new BusinessException("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u62a5\u9519\uff1a" + response.getMsg());
            }
            this.logger.info("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", response.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u62a5\u9519\uff1a" + e.getMessage());
        }
    }

    private String objToString(Object obj) {
        if (obj == null) {
            return null;
        }
        return String.valueOf(obj);
    }

    private void checkWaste(WasteVO vo) {
        Long tenderId = vo.getTenderId();
        QueryParam param = new QueryParam();
        param.getParams().put("inviteId", new Parameter("eq", (Object)tenderId));
        if (0 == vo.getType()) {
            this.checkStuffWaste(param);
        } else if (1 == vo.getType()) {
            this.checkSubWaste(param);
        } else if (6 == vo.getType()) {
            this.checkProsubWaste(param);
        } else if (2 == vo.getType()) {
            this.checkEquipmentWaste(param);
        } else if (3 == vo.getType()) {
            this.checkRentWaste(param);
        } else if (4 == vo.getType()) {
            this.checkRmatWaste(param);
        } else if (5 == vo.getType()) {
            this.checkOtherWaste(param);
        } else {
            throw new BusinessException("\u4e0d\u5b58\u5728\u62db\u6807\u7acb\u9879\u7c7b\u578b[" + vo.getType() + "]");
        }
    }

    private void checkStuffWaste(QueryParam param) {
        List stuffDocumentEntityList = this.stuffDocumentService.queryList(param);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)stuffDocumentEntityList) || !BID_FLAG.equals(((StuffDocumentEntity)((Object)stuffDocumentEntityList.get(0))).getBidFlag())) {
            this.logger.error("\u5f53\u524d\u9879\u76ee\u672a\u5f00\u6807\uff0c\u65e0\u6cd5\u8fdb\u884c\u5e9f\u6807\uff01");
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u672a\u5f00\u6807\uff01");
        }
        List stuffPicketageEntityList = this.stuffPicketageService.queryList(param);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)stuffPicketageEntityList)) {
            Integer stuffState = ((StuffPicketageEntity)((Object)stuffPicketageEntityList.get(0))).getBillState();
            if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(stuffState) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(stuffState)) {
                this.logger.error("\u5f53\u524d\u9879\u76ee\u5df2\u5b9a\u6807\uff0c\u65e0\u6cd5\u8fdb\u884c\u5e9f\u6807\uff01");
                throw new BusinessException("\u5f53\u524d\u9879\u76ee\u5df2\u5b9a\u6807\uff01");
            }
        }
    }

    private void checkSubWaste(QueryParam param) {
        List subDocumentEntityList = this.subDocumentService.queryList(param);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)subDocumentEntityList) || !BID_FLAG.equals(((SubDocumentEntity)((Object)subDocumentEntityList.get(0))).getBidFlag())) {
            this.logger.error("\u5f53\u524d\u9879\u76ee\u672a\u5f00\u6807\uff0c\u65e0\u6cd5\u8fdb\u884c\u5e9f\u6807\uff01");
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u672a\u5f00\u6807\uff01");
        }
        List subPicketageEntityList = this.subPicketageService.queryList(param);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)subPicketageEntityList)) {
            Integer stuffState = ((SubPicketageEntity)((Object)subPicketageEntityList.get(0))).getBillState();
            if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(stuffState) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(stuffState)) {
                this.logger.error("\u5f53\u524d\u9879\u76ee\u5df2\u5b9a\u6807\uff0c\u65e0\u6cd5\u8fdb\u884c\u5e9f\u6807\uff01");
                throw new BusinessException("\u5f53\u524d\u9879\u76ee\u5df2\u5b9a\u6807\uff01");
            }
        }
    }

    private void checkProsubWaste(QueryParam param) {
        List prosubDocumentEntityList = this.prosubDocumentService.queryList(param);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)prosubDocumentEntityList) || !BID_FLAG.equals(((ProsubDocumentEntity)((Object)prosubDocumentEntityList.get(0))).getBidFlag())) {
            this.logger.error("\u5f53\u524d\u9879\u76ee\u672a\u5f00\u6807\uff0c\u65e0\u6cd5\u8fdb\u884c\u5e9f\u6807\uff01");
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u672a\u5f00\u6807\uff01");
        }
        List prosubPicketageEntityList = this.prosubPicketageService.queryList(param);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)prosubPicketageEntityList)) {
            Integer stuffState = ((ProsubPicketageEntity)((Object)prosubPicketageEntityList.get(0))).getBillState();
            if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(stuffState) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(stuffState)) {
                this.logger.error("\u5f53\u524d\u9879\u76ee\u5df2\u5b9a\u6807\uff0c\u65e0\u6cd5\u8fdb\u884c\u5e9f\u6807\uff01");
                throw new BusinessException("\u5f53\u524d\u9879\u76ee\u5df2\u5b9a\u6807\uff01");
            }
        }
    }

    private void checkEquipmentWaste(QueryParam param) {
        List equipmentDocumentEntityList = this.equipmentDocumentService.queryList(param);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)equipmentDocumentEntityList) || !BID_FLAG.equals(((EquipmentDocumentEntity)((Object)equipmentDocumentEntityList.get(0))).getBidFlag())) {
            this.logger.error("\u5f53\u524d\u9879\u76ee\u672a\u5f00\u6807\uff0c\u65e0\u6cd5\u8fdb\u884c\u5e9f\u6807\uff01");
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u672a\u5f00\u6807\uff01");
        }
        List equipmentPicketageEntityList = this.equipmentPicketageService.queryList(param);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)equipmentPicketageEntityList)) {
            Integer stuffState = ((EquipmentPicketageEntity)((Object)equipmentPicketageEntityList.get(0))).getBillState();
            if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(stuffState) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(stuffState)) {
                this.logger.error("\u5f53\u524d\u9879\u76ee\u5df2\u5b9a\u6807\uff0c\u65e0\u6cd5\u8fdb\u884c\u5e9f\u6807\uff01");
                throw new BusinessException("\u5f53\u524d\u9879\u76ee\u5df2\u5b9a\u6807\uff01");
            }
        }
    }

    private void checkRentWaste(QueryParam param) {
        List rentDocumentEntityList = this.rentDocumentService.queryList(param);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)rentDocumentEntityList) || !BID_FLAG.equals(((RentDocumentEntity)((Object)rentDocumentEntityList.get(0))).getBidFlag())) {
            this.logger.error("\u5f53\u524d\u9879\u76ee\u672a\u5f00\u6807\uff0c\u65e0\u6cd5\u8fdb\u884c\u5e9f\u6807\uff01");
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u672a\u5f00\u6807\uff01");
        }
        List rentPicketageEntityList = this.rentPicketageService.queryList(param);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)rentPicketageEntityList)) {
            Integer stuffState = ((RentPicketageEntity)((Object)rentPicketageEntityList.get(0))).getBillState();
            if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(stuffState) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(stuffState)) {
                this.logger.error("\u5f53\u524d\u9879\u76ee\u5df2\u5b9a\u6807\uff0c\u65e0\u6cd5\u8fdb\u884c\u5e9f\u6807\uff01");
                throw new BusinessException("\u5f53\u524d\u9879\u76ee\u5df2\u5b9a\u6807\uff01");
            }
        }
    }

    private void checkRmatWaste(QueryParam param) {
        List rmatDocumentEntityList = this.rmatDocumentService.queryList(param);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)rmatDocumentEntityList) || !BID_FLAG.equals(((RmatDocumentEntity)((Object)rmatDocumentEntityList.get(0))).getBidFlag())) {
            this.logger.error("\u5f53\u524d\u9879\u76ee\u672a\u5f00\u6807\uff0c\u65e0\u6cd5\u8fdb\u884c\u5e9f\u6807\uff01");
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u672a\u5f00\u6807\uff01");
        }
        List rmatPicketageEntityList = this.rmatPicketageService.queryList(param);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)rmatPicketageEntityList)) {
            Integer stuffState = ((RmatPicketageEntity)((Object)rmatPicketageEntityList.get(0))).getBillState();
            if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(stuffState) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(stuffState)) {
                this.logger.error("\u5f53\u524d\u9879\u76ee\u5df2\u5b9a\u6807\uff0c\u65e0\u6cd5\u8fdb\u884c\u5e9f\u6807\uff01");
                throw new BusinessException("\u5f53\u524d\u9879\u76ee\u5df2\u5b9a\u6807\uff01");
            }
        }
    }

    private void checkOtherWaste(QueryParam param) {
        List otherDocumentEntityList = this.otherDocumentService.queryList(param);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)otherDocumentEntityList) || !BID_FLAG.equals(((OtherDocumentEntity)((Object)otherDocumentEntityList.get(0))).getBidFlag())) {
            this.logger.error("\u5f53\u524d\u9879\u76ee\u672a\u5f00\u6807\uff0c\u65e0\u6cd5\u8fdb\u884c\u5e9f\u6807\uff01");
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u672a\u5f00\u6807\uff01");
        }
        List otherPicketageEntityList = this.otherPicketageService.queryList(param);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)otherPicketageEntityList)) {
            Integer stuffState = ((OtherPicketageEntity)((Object)otherPicketageEntityList.get(0))).getBillState();
            if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(stuffState) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(stuffState)) {
                this.logger.error("\u5f53\u524d\u9879\u76ee\u5df2\u5b9a\u6807\uff0c\u65e0\u6cd5\u8fdb\u884c\u5e9f\u6807\uff01");
                throw new BusinessException("\u5f53\u524d\u9879\u76ee\u5df2\u5b9a\u6807\uff01");
            }
        }
    }
}

