/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.equipment.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.equipment.bean.EquipmentBidDetailEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentBidEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentBidSupplierEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSellEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSupplierEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentNoticeEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentPicketageEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentPicketageSupplierEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentWinnoticeEntity;
import com.ejianc.business.tender.equipment.mapper.EquipmentBidMapper;
import com.ejianc.business.tender.equipment.service.IEquipmentBidDetailService;
import com.ejianc.business.tender.equipment.service.IEquipmentBidService;
import com.ejianc.business.tender.equipment.service.IEquipmentBidSupplierService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentSellService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentSupplierService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.equipment.service.IEquipmentNoticeService;
import com.ejianc.business.tender.equipment.service.IEquipmentPicketageService;
import com.ejianc.business.tender.equipment.service.IEquipmentPicketageSupplierService;
import com.ejianc.business.tender.equipment.service.IEquipmentWinnoticeService;
import com.ejianc.business.tender.equipment.vo.EquipmentBidDetailVO;
import com.ejianc.business.tender.equipment.vo.EquipmentBidSupplierVO;
import com.ejianc.business.tender.equipment.vo.EquipmentBidVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentSellVO;
import com.ejianc.business.tender.equipment.vo.EquipmentPicketageSupplierVO;
import com.ejianc.business.tender.equipment.vo.EquipmentPicketageVO;
import com.ejianc.business.tender.equipment.vo.EquipmentWinbidDetailVO;
import com.ejianc.business.tender.equipment.vo.EquipmentWinbidVO;
import com.ejianc.business.tender.equipment.vo.TenderStageEnum;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="equipmentBidService")
public class EquipmentBidServiceImpl
extends BaseServiceImpl<EquipmentBidMapper, EquipmentBidEntity>
implements IEquipmentBidService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IEquipmentPicketageService equipmentPicketageService;
    @Autowired
    private IEquipmentNoticeService equipmentNoticeService;
    @Autowired
    private IEquipmentWinnoticeService equipmentWinnoticeService;
    @Autowired
    private IEquipmentDocumentService equipmentDocumentService;
    @Autowired
    private IEquipmentInviteService equipmentInviteService;
    @Autowired
    private IEquipmentBidDetailService equipmentBidDetailService;
    @Autowired
    private IEquipmentDocumentSellService equipmentDocumentSellService;
    @Autowired
    private IEquipmentBidSupplierService equipmentBidSupplierService;
    @Autowired
    private IEquipmentDocumentSupplierService equipmentDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IEquipmentPicketageSupplierService equipmentPicketageSupplierService;
    @Autowired
    private IOrgApi iOrgApi;
    @Value(value="${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value(value="${gysUrl.winbidSavesUrl}")
    private String winbidSavesUrl;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-bid-code";

    @Override
    public EquipmentBidVO saveBid(Long picketageId) {
        EquipmentBidEntity entity = new EquipmentBidEntity();
        entity.setPicketageId(picketageId);
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        EquipmentPicketageEntity equipmentPicketageEntity = (EquipmentPicketageEntity)((Object)this.equipmentPicketageService.selectById(picketageId));
        EquipmentInviteEntity inviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(equipmentPicketageEntity.getInviteId()));
        entity.setInviteId(equipmentPicketageEntity.getInviteId());
        entity.setBidName(inviteEntity.getTenderName());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        super.saveOrUpdate((Object)entity, false);
        EquipmentBidVO vo = (EquipmentBidVO)BeanMapper.map((Object)((Object)entity), EquipmentBidVO.class);
        equipmentPicketageEntity.setBidId(entity.getId());
        this.equipmentPicketageService.updateById((Object)equipmentPicketageEntity);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(EquipmentDocumentSellEntity::getDocumentId, (Object)equipmentPicketageEntity.getDocumentId());
        lambdaSell.eq(EquipmentDocumentSellEntity::getTenderFlag, (Object)1);
        List sellList = this.equipmentDocumentSellService.list((Wrapper)lambdaSell);
        List equipmentDocumentSellVOS = BeanMapper.mapList((Iterable)sellList, EquipmentDocumentSellVO.class);
        Map<Long, List<EquipmentDocumentSellVO>> sellMap = equipmentDocumentSellVOS.stream().collect(Collectors.groupingBy(EquipmentDocumentSellVO::getSupplierId));
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(EquipmentDocumentSupplierEntity::getDocumentId, (Object)equipmentPicketageEntity.getDocumentId());
        lambdaSupplier.eq(EquipmentDocumentSupplierEntity::getTalkNum, (Object)0);
        List supplierList = this.equipmentDocumentSupplierService.list((Wrapper)lambdaSupplier);
        Map supplierEntityMap = supplierList.stream().collect(Collectors.toMap(EquipmentDocumentSupplierEntity::getSupplierId, Function.identity()));
        ArrayList supplierVOList = new ArrayList();
        ArrayList equipmentBidDetailEntityList = new ArrayList();
        sellMap.forEach((key, value) -> {
            EquipmentBidSupplierVO equipmentBidSupplierVO = new EquipmentBidSupplierVO();
            equipmentBidSupplierVO.setSupplierId(key);
            equipmentBidSupplierVO.setSupplierName(((EquipmentDocumentSellVO)value.stream().findFirst().get()).getSupplierName());
            EquipmentDocumentSupplierEntity equipmentDocumentSupplierEntity = (EquipmentDocumentSupplierEntity)((Object)((Object)supplierEntityMap.get(key)));
            equipmentBidSupplierVO.setLinkName(equipmentDocumentSupplierEntity.getLinkName());
            equipmentBidSupplierVO.setSupplierMobile(equipmentDocumentSupplierEntity.getLinkMobile());
            equipmentBidSupplierVO.setId(Long.valueOf(IdWorker.getId()));
            BigDecimal tenderMoneyTax = BigDecimal.ZERO;
            BigDecimal tenderMoney = BigDecimal.ZERO;
            for (EquipmentDocumentSellVO equipmentDocumentSellVO : value) {
                tenderMoneyTax = tenderMoneyTax.add(equipmentDocumentSellVO.getTenderMoneyTax() == null ? BigDecimal.ZERO : equipmentDocumentSellVO.getTenderMoneyTax());
                tenderMoney = tenderMoney.add(equipmentDocumentSellVO.getTenderMoney() == null ? BigDecimal.ZERO : equipmentDocumentSellVO.getTenderMoney());
                EquipmentBidDetailEntity equipmentBidDetailEntity = (EquipmentBidDetailEntity)((Object)((Object)BeanMapper.map((Object)equipmentDocumentSellVO, EquipmentBidDetailEntity.class)));
                equipmentBidDetailEntity.setMoney(equipmentDocumentSellVO.getTenderMoney());
                equipmentBidDetailEntity.setMoneyTax(equipmentDocumentSellVO.getTenderMoneyTax());
                equipmentBidDetailEntity.setId(null);
                equipmentBidDetailEntity.setBidSupplierId(equipmentBidSupplierVO.getId());
                equipmentBidDetailEntity.setBidId(entity.getId());
                equipmentBidDetailEntityList.add(equipmentBidDetailEntity);
            }
            equipmentBidSupplierVO.setMoneyTax(tenderMoneyTax);
            equipmentBidSupplierVO.setMoney(tenderMoney);
            equipmentBidSupplierVO.setBidId(entity.getId());
            supplierVOList.add(equipmentBidSupplierVO);
        });
        List equipmentBidSupplierEntities = BeanMapper.mapList(supplierVOList, EquipmentBidSupplierEntity.class);
        this.equipmentBidSupplierService.saveBatch(equipmentBidSupplierEntities);
        this.equipmentBidDetailService.saveBatch(equipmentBidDetailEntityList);
        String tenderUnitNum = "";
        List<EquipmentBidDetailEntity> bidDetailEntityList = ((EquipmentBidMapper)this.baseMapper).selectBidSupplier(entity.getId());
        for (EquipmentBidDetailEntity equipmentBidDetailEntity : bidDetailEntityList) {
            EquipmentBidSupplierEntity supplierEntity = (EquipmentBidSupplierEntity)((Object)this.equipmentBidSupplierService.selectById(equipmentBidDetailEntity.getBidSupplierId()));
            BigDecimal sumNum = equipmentBidDetailEntity.getTenderNum().setScale(4, 4);
            String name = supplierEntity.getSupplierName() + "(" + sumNum + "),";
            tenderUnitNum = tenderUnitNum + name;
        }
        if (tenderUnitNum.length() > 1) {
            tenderUnitNum = tenderUnitNum.substring(0, tenderUnitNum.length() - 1);
        }
        inviteEntity.setTenderUnitNum(tenderUnitNum);
        this.equipmentInviteService.saveOrUpdate((Object)inviteEntity);
        EquipmentBidVO equipmentBidVO = (EquipmentBidVO)BeanMapper.map((Object)((Object)entity), EquipmentBidVO.class);
        return equipmentBidVO;
    }

    @Override
    public EquipmentBidVO queryDetail(Long bidId) {
        EquipmentBidEntity equipmentBidEntity = (EquipmentBidEntity)((Object)super.selectById((Serializable)bidId));
        EquipmentBidVO equipmentBidVO = (EquipmentBidVO)BeanMapper.map((Object)((Object)equipmentBidEntity), EquipmentBidVO.class);
        List equipmentBidDetailList = equipmentBidVO.getEquipmentBidDetailList();
        Map<Long, List<EquipmentBidDetailVO>> detailMap = equipmentBidDetailList.stream().collect(Collectors.groupingBy(EquipmentBidDetailVO::getBidSupplierId));
        List equipmentBidSupplierList = equipmentBidVO.getEquipmentBidSupplierList();
        for (EquipmentBidSupplierVO equipmentBidSupplierVO : equipmentBidSupplierList) {
            equipmentBidSupplierVO.setEquipmentBidDetailList(detailMap.get(equipmentBidSupplierVO.getId()));
        }
        equipmentBidVO.setEquipmentBidSupplierList(equipmentBidSupplierList);
        return equipmentBidVO;
    }

    @Override
    @Transactional
    public EquipmentBidVO publishBid(EquipmentBidVO saveorUpdateVO) {
        EquipmentBidEntity entity = (EquipmentBidEntity)((Object)super.selectById((Serializable)saveorUpdateVO.getId()));
        entity.setBidContent(saveorUpdateVO.getBidContent());
        entity.setBidName(saveorUpdateVO.getBidName());
        entity.setPublishFlag(0);
        entity.setBillState(1);
        EquipmentBidVO vo = (EquipmentBidVO)BeanMapper.map((Object)((Object)entity), EquipmentBidVO.class);
        EquipmentInviteEntity equipmentInviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(entity.getInviteId()));
        EquipmentWinbidVO winbidVO = new EquipmentWinbidVO();
        winbidVO.setSourceId(Long.toString(entity.getInviteId()));
        winbidVO.setBillCode(equipmentInviteEntity.getBillCode());
        if (winbidVO.getPurchaseType() == null || winbidVO.getPurchaseType() == 1) {
            winbidVO.setSourceProjectId(null);
        } else {
            winbidVO.setSourceProjectId(Long.toString(equipmentInviteEntity.getProjectId()));
        }
        winbidVO.setProjectName(equipmentInviteEntity.getProjectName());
        winbidVO.setProjectCode(equipmentInviteEntity.getProjectCode());
        winbidVO.setSourceOrgId(Long.toString(equipmentInviteEntity.getOrgId()));
        winbidVO.setOrgName(equipmentInviteEntity.getOrgName());
        winbidVO.setUnitName(equipmentInviteEntity.getUnitName());
        winbidVO.setSourceUnitId(Long.toString(equipmentInviteEntity.getUnitId()));
        winbidVO.setType("PURCHASE");
        winbidVO.setTenderName(equipmentInviteEntity.getTenderName());
        winbidVO.setTenderType(equipmentInviteEntity.getTenderType());
        winbidVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        LambdaQueryWrapper lambdaDoc = Wrappers.lambdaQuery();
        lambdaDoc.eq(EquipmentDocumentEntity::getInviteId, (Object)entity.getInviteId());
        EquipmentDocumentEntity equipmentDocumentEntity = (EquipmentDocumentEntity)((Object)this.equipmentDocumentService.getOne((Wrapper)lambdaDoc));
        winbidVO.setNoticeBidTime(equipmentDocumentEntity.getBidTime());
        winbidVO.setNoticeWinbidTime(new Date());
        if (equipmentInviteEntity.getTenderType() == 2 || equipmentInviteEntity.getTenderType() == 3 || equipmentInviteEntity.getTenderType() == 4 || equipmentInviteEntity.getTenderType() == 5) {
            winbidVO.setSourceEmployeeId(Long.toString(equipmentDocumentEntity.getEmployeeId()));
            winbidVO.setEmployeeName(equipmentDocumentEntity.getEmployeeName());
            winbidVO.setEmployeeMobile(equipmentDocumentEntity.getEmployeeMobile());
            winbidVO.setPurchaseType(equipmentDocumentEntity.getPurchaseType());
        } else {
            LambdaQueryWrapper lambdaNotice = Wrappers.lambdaQuery();
            lambdaNotice.eq(EquipmentNoticeEntity::getInviteId, (Object)entity.getInviteId());
            EquipmentNoticeEntity noticeEntity = (EquipmentNoticeEntity)((Object)this.equipmentNoticeService.getOne((Wrapper)lambdaNotice));
            winbidVO.setSourceEmployeeId(Long.toString(noticeEntity.getEmployeeId()));
            winbidVO.setEmployeeName(noticeEntity.getEmployeeName());
            winbidVO.setEmployeeMobile(noticeEntity.getEmployeeMobile());
            winbidVO.setPurchaseType(noticeEntity.getPurchaseType());
        }
        EquipmentBidVO equipmentBidVO = this.queryDetail(entity.getId());
        List equipmentBidSupplierList = equipmentBidVO.getEquipmentBidSupplierList();
        ArrayList<EquipmentWinbidVO> winbidVOList = new ArrayList<EquipmentWinbidVO>();
        for (EquipmentBidSupplierVO equipmentBidSupplierVO : equipmentBidSupplierList) {
            EquipmentWinbidVO winbidVONew = (EquipmentWinbidVO)BeanMapper.map((Object)winbidVO, EquipmentWinbidVO.class);
            SupplierDTO supplierVO = (SupplierDTO)this.shareSupplierApi.queryById(equipmentBidSupplierVO.getSupplierId()).getData();
            winbidVONew.setTenantId(supplierVO.getTenant());
            winbidVONew.setWinbidMoneyTax(equipmentBidSupplierVO.getMoneyTax());
            winbidVONew.setWinbidMoney(equipmentBidSupplierVO.getMoney());
            winbidVONew.setContent(equipmentBidVO.getBidContent());
            winbidVONew.setWinbidType(Integer.valueOf(0));
            List equipmentBidDetailList = equipmentBidSupplierVO.getEquipmentBidDetailList();
            HashMap<String, List> map = new HashMap<String, List>();
            for (EquipmentBidDetailVO equipmentBidDetailVO : equipmentBidDetailList) {
                String s = null;
                if (equipmentBidDetailVO.getMaterialId() == null) {
                    s = equipmentBidDetailVO.getMaterialTypeId().toString() + equipmentBidDetailVO.getRate() + equipmentBidDetailVO.getSchemeId();
                }
                if (equipmentBidDetailVO.getMaterialId() != null) {
                    s = equipmentBidDetailVO.getMaterialId().toString() + equipmentBidDetailVO.getMaterialTypeId().toString() + equipmentBidDetailVO.getRate() + equipmentBidDetailVO.getSchemeId();
                }
                if (map.containsKey(s)) {
                    List equipmentBidDetailVOS = (List)map.get(s);
                    equipmentBidDetailVOS.add(equipmentBidDetailVO);
                    map.put(s, equipmentBidDetailVOS);
                    continue;
                }
                ArrayList<EquipmentBidDetailVO> equipmentBidDetailVOList = new ArrayList<EquipmentBidDetailVO>();
                equipmentBidDetailVOList.add(equipmentBidDetailVO);
                map.put(s, equipmentBidDetailVOList);
            }
            ArrayList winbidDetailVOList = new ArrayList();
            map.forEach((key, value) -> {
                BigDecimal tenderNum = BigDecimal.ZERO;
                BigDecimal money = BigDecimal.ZERO;
                BigDecimal moneyTax = BigDecimal.ZERO;
                BigDecimal tax = BigDecimal.ZERO;
                for (EquipmentBidDetailVO equipmentBidDetailVOLast : value) {
                    tenderNum = tenderNum.add(equipmentBidDetailVOLast.getTenderNum() == null ? BigDecimal.ZERO : equipmentBidDetailVOLast.getTenderNum());
                    money = money.add(equipmentBidDetailVOLast.getMoney() == null ? BigDecimal.ZERO : equipmentBidDetailVOLast.getMoney());
                    moneyTax = moneyTax.add(equipmentBidDetailVOLast.getMoneyTax() == null ? BigDecimal.ZERO : equipmentBidDetailVOLast.getMoneyTax());
                    tax = tax.add(equipmentBidDetailVOLast.getSellTax() == null ? BigDecimal.ZERO : equipmentBidDetailVOLast.getSellTax());
                }
                EquipmentBidDetailVO first = (EquipmentBidDetailVO)value.stream().findFirst().get();
                EquipmentWinbidDetailVO winbidDetailVO = new EquipmentWinbidDetailVO();
                winbidDetailVO.setSourceId(Long.toString(entity.getInviteId()));
                winbidDetailVO.setSourceMaterialId(Long.toString(first.getMaterialId()));
                winbidDetailVO.setMaterialName(first.getMaterialName());
                winbidDetailVO.setMaterialCode(first.getMaterialCode());
                winbidDetailVO.setSourceMaterialTypeId(Long.toString(first.getMaterialTypeId()));
                winbidDetailVO.setMaterialTypeName(first.getMaterialTypeName());
                winbidDetailVO.setUnit(first.getUnit());
                winbidDetailVO.setSpec(first.getSpec());
                winbidDetailVO.setBrand(first.getMaterialBrand());
                winbidDetailVO.setSupplierBrand(first.getBrand());
                winbidDetailVO.setPrice(first.getPrice());
                winbidDetailVO.setPriceTax(first.getPriceTax());
                winbidDetailVO.setMoney(money);
                winbidDetailVO.setMoneyTax(moneyTax);
                winbidDetailVO.setTax(tax);
                winbidDetailVO.setCalculateType(first.getCalculateType());
                winbidDetailVO.setMemo(first.getMaterialMemo());
                winbidDetailVO.setSupplierMemo(first.getMemo());
                winbidDetailVO.setMoney(money);
                winbidDetailVO.setRate(first.getRate());
                winbidDetailVO.setTenderNum(tenderNum);
                winbidDetailVO.setNum(first.getNum());
                winbidDetailVOList.add(winbidDetailVO);
            });
            winbidVONew.setPurchaseWinbidDetailList(winbidDetailVOList);
            winbidVOList.add(winbidVONew);
        }
        String stringFb = JSONObject.toJSONString(winbidVOList);
        this.logger.info("\u63a8\u9001\u4f9b\u65b9\u4e2d\u6807\u4fe1\u606f:" + stringFb);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.winbidSavesUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u4e2d\u6807\u540c\u6b65\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(vo.getId());
    }

    @Override
    public EquipmentBidVO queryDbDetail(Long picketage) {
        return null;
    }

    @Override
    public EquipmentBidVO nextPaper(Long winnoticeId) {
        EquipmentBidEntity entity = new EquipmentBidEntity();
        EquipmentWinnoticeEntity equipmentWinnoticeEntity = (EquipmentWinnoticeEntity)((Object)this.equipmentWinnoticeService.selectById(winnoticeId));
        EquipmentInviteEntity equipmentInviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(equipmentWinnoticeEntity.getInviteId()));
        entity.setInviteId(equipmentWinnoticeEntity.getInviteId());
        entity.setBidName(equipmentInviteEntity.getTenderName());
        entity.setPurchaseType(equipmentInviteEntity.getPurchaseType());
        entity.setWinnoticeId(winnoticeId);
        super.saveOrUpdate((Object)entity, false);
        equipmentWinnoticeEntity.setNextFlag(1);
        this.equipmentWinnoticeService.updateById((Object)equipmentWinnoticeEntity);
        equipmentInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        this.equipmentInviteService.updateById((Object)equipmentInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("equipment/winLetter");
        this.processService.saveOrUpdate((Object)processEntity);
        EquipmentBidVO equipmentBidVO = (EquipmentBidVO)BeanMapper.map((Object)((Object)entity), EquipmentBidVO.class);
        return equipmentBidVO;
    }

    @Override
    public List<EquipmentPicketageSupplierVO> querySupplierList(Long picketageId) {
        EquipmentBidEntity equipmentBidEntity = (EquipmentBidEntity)((Object)super.selectById((Serializable)picketageId));
        EquipmentWinnoticeEntity equipmentWinnoticeEntity = (EquipmentWinnoticeEntity)((Object)this.equipmentWinnoticeService.selectById(equipmentBidEntity.getWinnoticeId()));
        LambdaQueryWrapper lambdaSupplierList = Wrappers.lambdaQuery();
        lambdaSupplierList.eq(EquipmentPicketageSupplierEntity::getPicketageId, (Object)equipmentWinnoticeEntity.getPicketageId());
        List listSupplier = this.equipmentPicketageSupplierService.list((Wrapper)lambdaSupplierList);
        List equipmentPicketageSupplierVOS = BeanMapper.mapList((Iterable)listSupplier, EquipmentPicketageSupplierVO.class);
        return equipmentPicketageSupplierVOS;
    }

    @Override
    @Transactional
    public EquipmentPicketageVO insertProcess(Long picketageId) {
        EquipmentPicketageEntity equipmentPicketageEntity = (EquipmentPicketageEntity)((Object)this.equipmentPicketageService.selectById(picketageId));
        EquipmentInviteEntity equipmentInviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(equipmentPicketageEntity.getInviteId()));
        equipmentInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        this.equipmentInviteService.updateById((Object)equipmentInviteEntity);
        equipmentPicketageEntity.setBidStatus(1);
        this.equipmentPicketageService.updateById((Object)equipmentPicketageEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(equipmentPicketageEntity.getBidId());
        processEntity.setBillName(TenderStageEnum.BID_NOTICE_STATE.getDescription());
        processEntity.setTenderId(equipmentInviteEntity.getId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("equipment/winLetter");
        this.processService.saveOrUpdate((Object)processEntity);
        EquipmentPicketageVO equipmentPicketageVO = (EquipmentPicketageVO)BeanMapper.map((Object)((Object)equipmentPicketageEntity), EquipmentPicketageVO.class);
        return equipmentPicketageVO;
    }

    @Override
    public List<EquipmentPicketageSupplierVO> querySupplierDetail(Long id) {
        EquipmentBidEntity equipmentBidEntity = (EquipmentBidEntity)((Object)super.selectById((Serializable)id));
        return this.equipmentPicketageService.querySupplierList(equipmentBidEntity.getPicketageId());
    }
}

