/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.equipment.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.common.vo.SupplyFileVo;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentDetailEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentExpertEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentRecordEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSchemeEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSellEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSupplierDetailEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSupplierEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteDetailEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteSupplierEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentNoticeEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentNoticeSupplierEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentTalkEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentTalkRecordEntity;
import com.ejianc.business.tender.equipment.mapper.EquipmentDocumentMapper;
import com.ejianc.business.tender.equipment.mapper.EquipmentDocumentSellMapper;
import com.ejianc.business.tender.equipment.mapper.EquipmentDocumentSupplierDetailMapper;
import com.ejianc.business.tender.equipment.mapper.EquipmentDocumentSupplierMapper;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentDetailService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentExpertService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentRecordService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentSchemeService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentSellService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentSupplierDetailService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentSupplierService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.equipment.service.IEquipmentNoticeService;
import com.ejianc.business.tender.equipment.service.IEquipmentNoticeSupplierService;
import com.ejianc.business.tender.equipment.service.IEquipmentTalkRecordService;
import com.ejianc.business.tender.equipment.service.IEquipmentTalkService;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentDetailVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentRecordVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentSchemeVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentSellVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentSupplierSellVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentSupplierTbVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentSupplierVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentVO;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteDetailRecordVO;
import com.ejianc.business.tender.equipment.vo.EquipmentNoticeDetailTbVO;
import com.ejianc.business.tender.equipment.vo.EquipmentNoticeSupplierDetailTbVO;
import com.ejianc.business.tender.equipment.vo.EquipmentNoticeSupplierTbVO;
import com.ejianc.business.tender.equipment.vo.EquipmentNoticeSupplierVO;
import com.ejianc.business.tender.equipment.vo.EquipmentSupplierSellSchemeDetailVO;
import com.ejianc.business.tender.equipment.vo.EquipmentSupplierSellSchemeVO;
import com.ejianc.business.tender.equipment.vo.EquipmentSupplierSellVO;
import com.ejianc.business.tender.equipment.vo.EquipmentTalkVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.util.SendMsgUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

@Service(value="equipmentDocumentService")
public class EquipmentDocumentServiceImpl
extends BaseServiceImpl<EquipmentDocumentMapper, EquipmentDocumentEntity>
implements IEquipmentDocumentService {
    @Autowired
    private IEquipmentDocumentSupplierService equipmentDocumentSupplierService;
    @Autowired
    private EquipmentDocumentSupplierDetailMapper supplierDetailMapper;
    @Autowired
    private EquipmentDocumentSupplierMapper supplierMapper;
    @Autowired
    private IEquipmentDocumentSchemeService equipmentDocumentSchemeService;
    @Autowired
    private IEquipmentDocumentSellService equipmentDocumentSellService;
    @Autowired
    private EquipmentDocumentSellMapper equipmentDocumentSellMapper;
    @Autowired
    private IEquipmentDocumentRecordService equipmentDocumentRecordService;
    @Autowired
    private IEquipmentDocumentDetailService equipmentDocumentDetailService;
    @Autowired
    private IEquipmentTalkService equipmentTalkService;
    @Autowired
    private IEquipmentTalkRecordService equipmentTalkRecordService;
    @Autowired
    private IEquipmentInviteService equipmentInviteService;
    @Autowired
    private IEquipmentDocumentExpertService documentExpertService;
    @Autowired
    private IEquipmentDocumentSupplierDetailService supplierDetailService;
    @Autowired
    private IEquipmentDocumentSupplierDetailService documentSupplierDetailService;
    @Autowired
    private IEquipmentDocumentService service;
    @Autowired
    private IProcessService processService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IEquipmentNoticeService equipmentNoticeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value(value="${gysUrl.delFileUrl}")
    private String delFileUrl;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Value(value="${gysUrl.saveWjUrl}")
    private String saveWjUrl;
    @Value(value="${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value(value="${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value(value="${gysUrl.updateSupStatusUrl}")
    private String updateSupStatusUrl;
    @Value(value="${gysUrl.addFileUrl}")
    private String addFileUrl;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000001";
    private static final String BILL_TYPE = "BT211119000000003";
    private static final String SOURCE_TYPE = "documentBill02";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "invite-document-code";
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IEquipmentNoticeSupplierService equipmentNoticeSupplierService;

    @Override
    @Transactional
    public EquipmentDocumentVO publishDocument(Long id) {
        CommonResponse stringCommonResponses;
        EquipmentDocumentEntity equipmentDocumentEntity = (EquipmentDocumentEntity)((Object)super.selectById((Serializable)id));
        equipmentDocumentEntity.setPublishFlag(0);
        super.updateById((Object)equipmentDocumentEntity);
        EquipmentDocumentSupplierTbVO equipmentDocumentSupplierTbVO = new EquipmentDocumentSupplierTbVO();
        equipmentDocumentSupplierTbVO.setSourceId(equipmentDocumentEntity.getInviteId().toString());
        equipmentDocumentSupplierTbVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u62db\u6807\u6587\u4ef6");
        equipmentDocumentSupplierTbVO.setNoticeType(Integer.valueOf(1));
        equipmentDocumentSupplierTbVO.setProjectLinkName(equipmentDocumentEntity.getProjectLinkName());
        equipmentDocumentSupplierTbVO.setProjectLinkPhone(equipmentDocumentEntity.getProjectLinkPhone());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(equipmentDocumentEntity.getOfferStartTime());
        equipmentDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(equipmentDocumentEntity.getOfferEndTime());
        equipmentDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        equipmentDocumentSupplierTbVO.setContent(equipmentDocumentEntity.getDocumentContent());
        equipmentDocumentSupplierTbVO.setBrandFlag(equipmentDocumentEntity.getBrandFlag());
        equipmentDocumentSupplierTbVO.setMemo(equipmentDocumentEntity.getMemo());
        equipmentDocumentSupplierTbVO.setTenderName(equipmentDocumentEntity.getDocumentName());
        CommonResponse stringCommonResponse = this.proSupplierApi.getEjcCloudSystemCode();
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u62db\u6807\u6587\u4ef6\u83b7\u53d6systemId\u5931\u8d25" + stringCommonResponse.getMsg());
        }
        equipmentDocumentSupplierTbVO.setSystemId((String)stringCommonResponse.getData());
        CommonResponse zbwjFile = this.attachmentApi.queryListBySourceId(equipmentDocumentEntity.getId(), BILL_TYPE, SOURCE_TYPE, null);
        String zbwjIds = null;
        List<Object> zbwjAttachIdList = new ArrayList();
        if (zbwjFile.isSuccess()) {
            List data = (List)zbwjFile.getData();
            zbwjAttachIdList = data.stream().map(AttachmentVO::getId).collect(Collectors.toList());
            zbwjIds = zbwjAttachIdList.stream().map(p -> String.valueOf(p)).collect(Collectors.joining(","));
        }
        HashMap<String, String> fileMap = new HashMap<String, String>();
        fileMap.put("fileIds", zbwjIds);
        String zbwjFileByte = null;
        try {
            zbwjFileByte = ReferHttpClientUtils.getAndHeader((String)(this.BASE_HOST + "ejc-file-web/attachment/batchdownflow"), fileMap);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONObject jsonZbwj = JSON.parseObject(zbwjFileByte);
        Map zbwjParam = (Map)JSONObject.parseObject((String)jsonZbwj.toJSONString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        String dataZbwj = (String)zbwjParam.get("data");
        JSONObject zbwListJson = JSON.parseObject((String)dataZbwj);
        Map zbwjMap = (Map)JSONObject.parseObject((String)zbwListJson.toJSONString(), (TypeReference)new TypeReference<Map<String, byte[]>>(){}, (Feature[])new Feature[0]);
        HashMap streamMap = new HashMap();
        zbwjMap.forEach((key, value) -> streamMap.put(key, new ByteArrayInputStream((byte[])value)));
        String stringFb = JSONObject.toJSONString((Object)equipmentDocumentSupplierTbVO);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("noticeEntity", stringFb);
        HashMap files = null;
        if (!streamMap.isEmpty()) {
            files = new HashMap();
            files.put("file", streamMap);
        }
        if (!(stringCommonResponses = this.systemDataPushService.exchangeDataAndFilesWithUniversal(this.saveWjUrl, params, files, this.appId, this.appSecret, this.appHost)).isSuccess()) {
            throw new BusinessException("\u62db\u6807\u6587\u4ef6\u53d1\u5e03\u63a8\u9001\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponses.getMsg());
        }
        EquipmentDocumentVO equipmentDocumentVO = this.queryDetail(id);
        return equipmentDocumentVO;
    }

    @Override
    public EquipmentDocumentVO bidDocument(Long id) {
        EquipmentDocumentEntity equipmentDocumentEntity = (EquipmentDocumentEntity)((Object)super.selectById((Serializable)id));
        equipmentDocumentEntity.setBidFlag(0);
        equipmentDocumentEntity.setBidTime(new Date());
        super.updateById((Object)equipmentDocumentEntity);
        EquipmentDocumentVO equipmentDocumentVO = this.queryDetail(id);
        List entityList = this.documentExpertService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_id", (Object)equipmentDocumentVO.getId())).eq((Object)"dr", (Object)0));
        for (EquipmentDocumentExpertEntity entity : entityList) {
            ArrayList<String> messageType = new ArrayList<String>();
            messageType.add("sys");
            ArrayList<String> sender = new ArrayList<String>();
            sender.add(entity.getExpertId() + "");
            String name = equipmentDocumentVO.getPurchaseType() == 0 ? equipmentDocumentVO.getProjectName() : equipmentDocumentVO.getOrgName();
            this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u4e13\u5bb6:>----------" + sender);
            String subject = entity.getExpertName() + "\u4e13\u5bb6\u60a8\u597d\uff0c" + name + "\u5df2\u5f00\u6807\uff0c\u540e\u7eed\u7684\u8bc4\u6807\u5f00\u59cb\u65f6\u95f4\u6211\u4eec\u4f1a\u4ee5\u77ed\u4fe1+\u6d88\u606f\u7684\u5f62\u5f0f\u901a\u77e5\u60a8\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\uff0c\u907f\u514d\u9057\u5fd8";
            String content = entity.getExpertName() + "\u4e13\u5bb6\u60a8\u597d\uff0c" + name + "\u5df2\u5f00\u6807\uff0c\u540e\u7eed\u7684\u8bc4\u6807\u5f00\u59cb\u65f6\u95f4\u6211\u4eec\u4f1a\u4ee5\u77ed\u4fe1+\u6d88\u606f\u7684\u5f62\u5f0f\u901a\u77e5\u60a8\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\uff0c\u907f\u514d\u9057\u5fd8";
            this.logger.info("\u53d1\u9001\u4fe1\u606f\u7684\u5185\u5bb9:>----------" + content);
            new SendMsgUtils().sendSysMsg(sender, subject, content, this.pushMessageApi);
        }
        return equipmentDocumentVO;
    }

    @Override
    public EquipmentDocumentVO queryDetail(Long id) {
        return this.queryDocDetail(id, 0);
    }

    @Override
    public EquipmentDocumentVO queryDetail1(Long id, Integer num) {
        return this.queryDocDetail(id, num);
    }

    @Override
    public EquipmentDocumentVO queryDetailNum(Long id) {
        EquipmentDocumentSchemeEntity equipmentDocumentSchemeEntity = (EquipmentDocumentSchemeEntity)((Object)this.equipmentDocumentSchemeService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_id", (Object)id)).orderByDesc((Object)"talk_num")).get(0));
        return this.queryDocDetail(id, equipmentDocumentSchemeEntity.getTalkNum());
    }

    @Override
    @Transactional
    public Boolean supplierPushSell(HttpServletRequest request, MultipartFile file) {
        this.logger.info("\u8fdb\u5165\u62a5\u4ef7\u63a5\u53e3request-{},file-{}", (Object)request, (Object)file);
        String notice = request.getParameter("bjNoticeVO");
        this.logger.info("\u5b9e\u4f53\u4fe1\u606f-{}", (Object)notice);
        EquipmentSupplierSellVO pushVO = (EquipmentSupplierSellVO)JSON.parseObject((String)notice, (TypeReference)new TypeReference<EquipmentSupplierSellVO>(){}, (Feature[])new Feature[0]);
        EquipmentInviteEntity equipmentInviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(Long.valueOf(Long.parseLong(pushVO.getSourceId()))));
        Integer tenderStage = equipmentInviteEntity.getTenderStage();
        Integer talkNum = null;
        if (tenderStage == 3 || tenderStage == 6 || tenderStage == 8 || tenderStage == 9 || tenderStage == 10) {
            talkNum = 0;
        }
        if (tenderStage == 7) {
            LambdaQueryWrapper lambdaTalk = Wrappers.lambdaQuery();
            lambdaTalk.eq(EquipmentTalkEntity::getInviteId, (Object)Long.parseLong(pushVO.getSourceId()));
            EquipmentTalkEntity equipmentTalkEntity = (EquipmentTalkEntity)((Object)this.equipmentTalkService.getOne((Wrapper)lambdaTalk));
            talkNum = equipmentTalkEntity.getTalkNum();
        }
        long sourceSupplierId = Long.parseLong(pushVO.getSourceSupplierId());
        SupplierDTO supplierVO = (SupplierDTO)this.shareSupplierApi.queryById(Long.valueOf(sourceSupplierId)).getData();
        Long inviteId = Long.parseLong(pushVO.getSourceId());
        LambdaQueryWrapper lambdaDocument = Wrappers.lambdaQuery();
        lambdaDocument.eq(EquipmentDocumentEntity::getInviteId, (Object)inviteId);
        EquipmentDocumentEntity equipmentDocumentEntity = (EquipmentDocumentEntity)((Object)((EquipmentDocumentMapper)this.baseMapper).selectOne((Wrapper)lambdaDocument));
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(EquipmentDocumentSupplierEntity::getSupplierId, (Object)sourceSupplierId);
        lambdaSupplier.eq(EquipmentDocumentSupplierEntity::getDocumentId, (Object)equipmentDocumentEntity.getId());
        lambdaSupplier.eq(EquipmentDocumentSupplierEntity::getTalkNum, (Object)talkNum);
        EquipmentDocumentSupplierEntity equipmentDocumentSupplierEntity = (EquipmentDocumentSupplierEntity)((Object)this.equipmentDocumentSupplierService.getOne((Wrapper)lambdaSupplier));
        Long documentSupplierId = null;
        if (equipmentDocumentSupplierEntity != null) {
            equipmentDocumentSupplierEntity.setOfferTime(new Date());
            equipmentDocumentSupplierEntity.setLinkName(pushVO.getEmployeeName());
            equipmentDocumentSupplierEntity.setLinkMobile(pushVO.getEmployeeMobile());
            equipmentDocumentSupplierEntity.setTaxMemo(pushVO.getInvoiceNote());
            this.equipmentDocumentSupplierService.updateById((Object)equipmentDocumentSupplierEntity);
            documentSupplierId = equipmentDocumentSupplierEntity.getId();
            LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
            lambdaScheme.eq(EquipmentDocumentSchemeEntity::getDocumentSupplierId, (Object)equipmentDocumentSupplierEntity.getId());
            this.equipmentDocumentSchemeService.remove((Wrapper)lambdaScheme);
        }
        if (equipmentDocumentSupplierEntity == null) {
            EquipmentDocumentSupplierEntity equipmentDocumentSupplierEntityAdd = new EquipmentDocumentSupplierEntity();
            equipmentDocumentSupplierEntityAdd.setSupplierName(supplierVO.getName());
            equipmentDocumentSupplierEntityAdd.setSupplierId(sourceSupplierId);
            equipmentDocumentSupplierEntityAdd.setSupplierTenantId(supplierVO.getTenant());
            equipmentDocumentSupplierEntityAdd.setLinkName(pushVO.getEmployeeName());
            equipmentDocumentSupplierEntityAdd.setLinkMobile(pushVO.getEmployeeMobile());
            equipmentDocumentSupplierEntityAdd.setTaxMemo(pushVO.getInvoiceNote());
            equipmentDocumentSupplierEntityAdd.setOfferTime(new Date());
            equipmentDocumentSupplierEntityAdd.setDocumentId(equipmentDocumentEntity.getId());
            equipmentDocumentSupplierEntityAdd.setTalkNum(talkNum);
            this.equipmentDocumentSupplierService.save((Object)equipmentDocumentSupplierEntityAdd);
            documentSupplierId = equipmentDocumentSupplierEntityAdd.getId();
        }
        List schemeList = pushVO.getPurchaseSchemeList();
        ArrayList<EquipmentDocumentSchemeEntity> equipmentDocumentSchemeEntityArrayList = new ArrayList<EquipmentDocumentSchemeEntity>();
        ArrayList<EquipmentDocumentSellVO> equipmentDocumentSellVOList = new ArrayList<EquipmentDocumentSellVO>();
        for (EquipmentSupplierSellSchemeVO supplierSellSchemeVO : schemeList) {
            EquipmentDocumentSchemeEntity equipmentDocumentSchemeEntity = new EquipmentDocumentSchemeEntity();
            equipmentDocumentSchemeEntity.setDocumentSupplierId(documentSupplierId);
            equipmentDocumentSchemeEntity.setDocumentId(equipmentDocumentEntity.getId());
            equipmentDocumentSchemeEntity.setSupplierId(sourceSupplierId);
            equipmentDocumentSchemeEntity.setSupplierTenantId(supplierVO.getTenant());
            equipmentDocumentSchemeEntity.setSupplierName(supplierVO.getName());
            equipmentDocumentSchemeEntity.setSchemeName(supplierSellSchemeVO.getSchemeName());
            equipmentDocumentSchemeEntity.setMoney(supplierSellSchemeVO.getMoney());
            equipmentDocumentSchemeEntity.setMoneyTax(supplierSellSchemeVO.getMoneyTax());
            equipmentDocumentSchemeEntity.setTalkNum(talkNum);
            equipmentDocumentSchemeEntity.setId(IdWorker.getId());
            equipmentDocumentSchemeEntity.setPassFlag(1);
            equipmentDocumentSchemeEntityArrayList.add(equipmentDocumentSchemeEntity);
            List schemeDetailList = supplierSellSchemeVO.getPurchaseSchemeDetailList();
            for (EquipmentSupplierSellSchemeDetailVO supplierSellSchemeDetailVO : schemeDetailList) {
                EquipmentDocumentSellVO equipmentDocumentSellVO = new EquipmentDocumentSellVO();
                equipmentDocumentSellVO.setSchemeId(equipmentDocumentSchemeEntity.getId());
                equipmentDocumentSellVO.setDocumentId(equipmentDocumentEntity.getId());
                equipmentDocumentSellVO.setSupplierId(Long.valueOf(sourceSupplierId));
                equipmentDocumentSellVO.setSupplierTenantId(supplierVO.getTenant());
                equipmentDocumentSellVO.setSupplierName(supplierVO.getName());
                equipmentDocumentSellVO.setMaterialId(Long.valueOf(Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialId())));
                equipmentDocumentSellVO.setMaterialName(supplierSellSchemeDetailVO.getMaterialName());
                equipmentDocumentSellVO.setMaterialCode(supplierSellSchemeDetailVO.getMaterialCode());
                equipmentDocumentSellVO.setMaterialTypeId(Long.valueOf(Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialTypeId())));
                equipmentDocumentSellVO.setMaterialTypeName(supplierSellSchemeDetailVO.getMaterialTypeName());
                equipmentDocumentSellVO.setUnit(supplierSellSchemeDetailVO.getUnit());
                equipmentDocumentSellVO.setSpec(supplierSellSchemeDetailVO.getSpec());
                equipmentDocumentSellVO.setRate(supplierSellSchemeDetailVO.getRate());
                equipmentDocumentSellVO.setDetailRate(supplierSellSchemeDetailVO.getDetailRate());
                equipmentDocumentSellVO.setPrice(supplierSellSchemeDetailVO.getPrice());
                equipmentDocumentSellVO.setPriceTax(supplierSellSchemeDetailVO.getPriceTax());
                equipmentDocumentSellVO.setSchemeName(supplierSellSchemeVO.getSchemeName());
                equipmentDocumentSellVO.setMaterialBrand(supplierSellSchemeDetailVO.getBrand());
                equipmentDocumentSellVO.setBrand(supplierSellSchemeDetailVO.getSupplierBrand());
                equipmentDocumentSellVO.setMemo(supplierSellSchemeDetailVO.getSupplierMemo());
                equipmentDocumentSellVO.setMaterialMemo(supplierSellSchemeDetailVO.getMemo());
                equipmentDocumentSellVO.setCalculateType(supplierSellSchemeDetailVO.getCalculateType());
                equipmentDocumentSellVO.setReferFlag(Integer.valueOf(2));
                equipmentDocumentSellVO.setPassFlag(Integer.valueOf(1));
                equipmentDocumentSellVO.setTalkNum(talkNum);
                equipmentDocumentSellVOList.add(equipmentDocumentSellVO);
            }
        }
        this.equipmentDocumentSchemeService.saveBatch(equipmentDocumentSchemeEntityArrayList);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(EquipmentDocumentSellEntity::getSupplierId, (Object)sourceSupplierId);
        lambdaSell.eq(EquipmentDocumentSellEntity::getTalkNum, (Object)talkNum);
        lambdaSell.eq(EquipmentDocumentSellEntity::getDocumentId, (Object)equipmentDocumentEntity.getId());
        this.equipmentDocumentSellService.remove((Wrapper)lambdaSell);
        LambdaQueryWrapper lambdaDetail = Wrappers.lambdaQuery();
        lambdaDetail.eq(EquipmentDocumentDetailEntity::getDocumentId, (Object)equipmentDocumentEntity.getId());
        List equipmentDocumentDetailList = this.equipmentDocumentDetailService.list((Wrapper)lambdaDetail);
        ArrayList<EquipmentDocumentSellEntity> equipmentDocumentSellEntityArrayList = new ArrayList<EquipmentDocumentSellEntity>();
        for (EquipmentDocumentDetailEntity equipmentDocumentDetailEntity : equipmentDocumentDetailList) {
            for (EquipmentDocumentSellVO equipmentDocumentSellVO : equipmentDocumentSellVOList) {
                EquipmentDocumentSellEntity equipmentDocumentSellEntity;
                if (equipmentDocumentDetailEntity.getMaterialId() != null && equipmentDocumentDetailEntity.getMaterialTypeId().equals(equipmentDocumentSellVO.getMaterialTypeId()) && equipmentDocumentDetailEntity.getMaterialId().equals(equipmentDocumentSellVO.getMaterialId()) && equipmentDocumentDetailEntity.getRate().equals(equipmentDocumentSellVO.getDetailRate())) {
                    equipmentDocumentSellEntity = (EquipmentDocumentSellEntity)((Object)BeanMapper.map((Object)equipmentDocumentSellVO, EquipmentDocumentSellEntity.class));
                    equipmentDocumentSellEntity.setDetailId(equipmentDocumentDetailEntity.getId());
                    equipmentDocumentSellEntity.setProjectId(equipmentDocumentDetailEntity.getDetailProjectId());
                    equipmentDocumentSellEntity.setProjectName(equipmentDocumentDetailEntity.getDetailProjectName());
                    equipmentDocumentSellEntity.setNum(equipmentDocumentDetailEntity.getNum());
                    equipmentDocumentSellEntity.setMoney(equipmentDocumentDetailEntity.getNum().multiply(equipmentDocumentSellEntity.getPrice()));
                    equipmentDocumentSellEntity.setMoneyTax(equipmentDocumentDetailEntity.getNum().multiply(equipmentDocumentSellEntity.getPriceTax()));
                    equipmentDocumentSellEntity.setSellTax(equipmentDocumentSellEntity.getMoneyTax().subtract(equipmentDocumentSellEntity.getMoney()));
                    equipmentDocumentSellEntityArrayList.add(equipmentDocumentSellEntity);
                }
                if (equipmentDocumentDetailEntity.getMaterialId() != null || !equipmentDocumentDetailEntity.getMaterialTypeId().equals(equipmentDocumentSellVO.getMaterialTypeId()) || !equipmentDocumentDetailEntity.getRate().equals(equipmentDocumentSellVO.getDetailRate())) continue;
                equipmentDocumentSellEntity = (EquipmentDocumentSellEntity)((Object)BeanMapper.map((Object)equipmentDocumentSellVO, EquipmentDocumentSellEntity.class));
                equipmentDocumentSellEntity.setDetailId(equipmentDocumentDetailEntity.getId());
                equipmentDocumentSellEntity.setProjectId(equipmentDocumentDetailEntity.getDetailProjectId());
                equipmentDocumentSellEntity.setProjectName(equipmentDocumentDetailEntity.getDetailProjectName());
                equipmentDocumentSellEntity.setNum(equipmentDocumentDetailEntity.getNum());
                equipmentDocumentSellEntity.setMoney(equipmentDocumentDetailEntity.getNum().multiply(equipmentDocumentSellEntity.getPrice()));
                equipmentDocumentSellEntity.setMoneyTax(equipmentDocumentDetailEntity.getNum().multiply(equipmentDocumentSellEntity.getPriceTax()));
                equipmentDocumentSellEntity.setSellTax(equipmentDocumentSellEntity.getMoneyTax().subtract(equipmentDocumentSellEntity.getMoney()));
                equipmentDocumentSellEntityArrayList.add(equipmentDocumentSellEntity);
            }
        }
        this.equipmentDocumentSellService.saveBatch(equipmentDocumentSellEntityArrayList);
        if (documentSupplierId != null) {
            this.logger.info("\u5220\u9664\u4f9b\u5e94\u5546[{}]\u9644\u4ef6\u4fe1\u606f\uff0cbillType[{}]\uff0csourceType[supplierFileType]", (Object)documentSupplierId, (Object)BILL_SUPPLIER_TYPE);
            CommonResponse attachmentResponse = this.attachmentApi.queryListBySourceId(documentSupplierId, BILL_SUPPLIER_TYPE, "supplierFileType", null);
            List attachmentVOList = (List)attachmentResponse.getData();
            if (CollectionUtils.isNotEmpty((Collection)attachmentVOList)) {
                this.logger.info("\u5f00\u59cb\u5220\u9664\u9644\u4ef6\u4fe1\u606f-----");
                String ids = attachmentVOList.stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
                CommonResponse deleteResponse = this.attachmentApi.delete(ids);
                this.logger.info("\u5220\u9664\u6587\u4ef6\u7ed3\u675f\uff0c\u5220\u9664\u7ed3\u679c\uff1a{}", deleteResponse.getData());
            }
        }
        List pzList = pushVO.getSupplyFileList();
        this.logger.info("\u62a5\u540d\u6587\u4ef6:{}", (Object)JSONObject.toJSONString((Object)pzList));
        if (CollectionUtils.isNotEmpty((Collection)pzList)) {
            ArrayList<AttachmentVO> list = new ArrayList<AttachmentVO>();
            for (SupplyFileVo e : pzList) {
                AttachmentVO attachmentVO = new AttachmentVO();
                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
                attachmentVO.setSourceId(documentSupplierId);
                attachmentVO.setSourceType("supplierFileType");
                attachmentVO.setFilePath(e.getFilePath());
                attachmentVO.setOnlinePath(e.getFilePath());
                attachmentVO.setFileName(e.getFileName());
                attachmentVO.setId(e.getFileId());
                list.add(attachmentVO);
                this.logger.info("\u4fdd\u5b58\u6587\u4ef6\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)attachmentVO));
            }
            CommonResponse stringCommonResponse = this.attachmentApi.insertBatch(list);
            this.logger.info(request + "\u62a5\u540d\u6587\u4ef6\u4e0a\u4f20\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
        }
        return true;
    }

    @Override
    public String uploadById(Long attachId, Long inviteId) {
        HashMap<String, String> fileMap = new HashMap<String, String>();
        fileMap.put("fileIds", Long.toString(attachId));
        String wjFileByte = null;
        try {
            wjFileByte = ReferHttpClientUtils.getAndHeader((String)(this.BASE_HOST + "ejc-file-web/attachment/batchdownflow"), fileMap);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONObject jsonwj = JSON.parseObject(wjFileByte);
        Map zbwjParam = (Map)JSONObject.parseObject((String)jsonwj.toJSONString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        String datawj = (String)zbwjParam.get("data");
        JSONObject wListJson = JSON.parseObject((String)datawj);
        Map wjMap = (Map)JSONObject.parseObject((String)wListJson.toJSONString(), (TypeReference)new TypeReference<Map<String, byte[]>>(){}, (Feature[])new Feature[0]);
        HashMap streamMap = new HashMap();
        wjMap.forEach((key, value) -> streamMap.put(key, new ByteArrayInputStream((byte[])value)));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sourceId", Long.toString(inviteId));
        HashMap headers = new HashMap();
        HashMap files = new HashMap();
        files.put("file", streamMap);
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataAndFilesWithUniversal(this.addFileUrl, params, files, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u9644\u4ef6\u6279\u91cf\u4fee\u6539\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return null;
    }

    @Override
    public String deleteFileById(Long sourceId, List<String> fileNames) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceId", sourceId);
        map.put("fileNames", fileNames);
        String stringInfo = JSONObject.toJSONString(map);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.delFileUrl, RequestMethod.POST, stringInfo, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u9644\u52a0\u6279\u91cf\u5220\u9664\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + response.getMsg());
        }
        return "\u540c\u6b65\u6210\u529f";
    }

    @Override
    public EquipmentDocumentSupplierSellVO getSupplierSchemeDetailDb(Long schemeId, Long documentId) {
        EquipmentDocumentEntity equipmentDocumentEntity = (EquipmentDocumentEntity)((Object)super.selectById((Serializable)documentId));
        EquipmentDocumentSupplierSellVO equipmentDocumentSupplierSellVO = new EquipmentDocumentSupplierSellVO();
        EquipmentDocumentSchemeEntity equipmentDocumentSchemeEntity = (EquipmentDocumentSchemeEntity)((Object)this.equipmentDocumentSchemeService.selectById(schemeId));
        EquipmentDocumentSupplierEntity equipmentDocumentSupplierEntity = (EquipmentDocumentSupplierEntity)((Object)this.equipmentDocumentSupplierService.selectById(equipmentDocumentSchemeEntity.getDocumentSupplierId()));
        Long supplierDetailId = equipmentDocumentSupplierEntity.getId();
        equipmentDocumentSupplierSellVO.setLinkName(equipmentDocumentSupplierEntity.getLinkName());
        equipmentDocumentSupplierSellVO.setSupplierName(equipmentDocumentSupplierEntity.getSupplierName());
        equipmentDocumentSupplierSellVO.setLinkMobile(equipmentDocumentSupplierEntity.getLinkMobile());
        equipmentDocumentSupplierSellVO.setOfferTime(equipmentDocumentSupplierEntity.getOfferTime());
        equipmentDocumentSupplierSellVO.setTaxMemo(equipmentDocumentSupplierEntity.getTaxMemo());
        equipmentDocumentSupplierSellVO.setPurchaseType(equipmentDocumentEntity.getPurchaseType());
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(EquipmentDocumentSchemeEntity::getDocumentSupplierId, (Object)supplierDetailId);
        List equipmentDocumentSchemeEntityList = this.equipmentDocumentSchemeService.list((Wrapper)lambdaScheme);
        List equipmentDocumentSchemeVOList = BeanMapper.mapList((Iterable)equipmentDocumentSchemeEntityList, EquipmentDocumentSchemeVO.class);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(EquipmentDocumentSellEntity::getDocumentId, (Object)equipmentDocumentSupplierEntity.getDocumentId());
        List equipmentDocumentSellEntityList = this.equipmentDocumentSellService.list((Wrapper)lambdaSell);
        List equipmentDocumentSellVOList = BeanMapper.mapList((Iterable)equipmentDocumentSellEntityList, EquipmentDocumentSellVO.class);
        Map<Long, List<EquipmentDocumentSellVO>> sellMap = equipmentDocumentSellVOList.stream().collect(Collectors.groupingBy(EquipmentDocumentSellVO::getSchemeId));
        for (EquipmentDocumentSchemeVO equipmentDocumentSchemeVO : equipmentDocumentSchemeVOList) {
            List<EquipmentDocumentSellVO> equipmentDocumentSellVOS = sellMap.get(equipmentDocumentSchemeVO.getId());
            equipmentDocumentSchemeVO.setEquipmentDocumentSellList(equipmentDocumentSellVOS);
        }
        equipmentDocumentSupplierSellVO.setEquipmentDocumentSchemeList(equipmentDocumentSchemeVOList);
        Map<String, Object> fileInfo = this.getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                equipmentDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                equipmentDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }
        return equipmentDocumentSupplierSellVO;
    }

    @Override
    public EquipmentDocumentVO saveOrUpdates(EquipmentDocumentVO saveorUpdateVO) {
        EquipmentDocumentEntity entity = (EquipmentDocumentEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, EquipmentDocumentEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        EquipmentDocumentVO vo = (EquipmentDocumentVO)BeanMapper.map((Object)((Object)entity), EquipmentDocumentVO.class);
        EquipmentInviteEntity subInviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(entity.getInviteId()));
        List subInviteDetailRecordVOS = BeanMapper.mapList(subInviteEntity.getEquipmentDetailRecord(), EquipmentInviteDetailRecordVO.class);
        vo.setEquipmentDetailRecord(subInviteDetailRecordVOS);
        return vo;
    }

    @Override
    public EquipmentDocumentVO queryDocDetail(Long id, Integer talkNum) {
        EquipmentDocumentEntity entity = (EquipmentDocumentEntity)((Object)super.selectById((Serializable)id));
        EquipmentDocumentVO equipmentDocumentVO = (EquipmentDocumentVO)BeanMapper.map((Object)((Object)entity), EquipmentDocumentVO.class);
        equipmentDocumentVO.setEquipmentDocumentSchemeList(null);
        equipmentDocumentVO.setEquipmentDocumentSellList(null);
        if (equipmentDocumentVO.getNoticeId() != null) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(EquipmentNoticeSupplierEntity::getNoticeId, (Object)entity.getNoticeId());
            wrapper.ne(EquipmentNoticeSupplierEntity::getState, (Object)1);
            List list = this.equipmentNoticeSupplierService.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List noticeSupplierVOS = BeanMapper.mapList((Iterable)list, EquipmentNoticeSupplierVO.class);
                Map<Object, Object> documentSupplierVOMap = new HashMap();
                if (CollectionUtils.isNotEmpty((Collection)equipmentDocumentVO.getEquipmentDocumentSupplierList())) {
                    documentSupplierVOMap = equipmentDocumentVO.getEquipmentDocumentSupplierList().stream().filter(t -> t.getSupplierId() != null).collect(Collectors.toMap(EquipmentDocumentSupplierVO::getSupplierId, item -> item, (v1, v2) -> v2));
                }
                for (EquipmentNoticeSupplierVO noticeSupplier : noticeSupplierVOS) {
                    if (documentSupplierVOMap.containsKey(noticeSupplier.getSupplierId())) {
                        noticeSupplier.setDocumentType(Integer.valueOf(0));
                        continue;
                    }
                    noticeSupplier.setDocumentType(Integer.valueOf(1));
                }
                equipmentDocumentVO.setEquipmentDocumentSupplierDetail(noticeSupplierVOS);
            }
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(EquipmentDocumentSupplierEntity::getDocumentId, (Object)id);
        lambda.eq(EquipmentDocumentSupplierEntity::getTalkNum, (Object)talkNum);
        List supplierList = this.equipmentDocumentSupplierService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)supplierList)) {
            List equipmentDocumentSupplierVOS = BeanMapper.mapList((Iterable)supplierList, EquipmentDocumentSupplierVO.class);
            LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
            lambdaScheme.eq(EquipmentDocumentSchemeEntity::getDocumentId, (Object)id);
            lambdaScheme.eq(EquipmentDocumentSchemeEntity::getTalkNum, (Object)talkNum);
            lambdaScheme.orderByAsc(EquipmentDocumentSchemeEntity::getSchemeName);
            List schemeList = this.equipmentDocumentSchemeService.list((Wrapper)lambdaScheme);
            Map<Long, List<EquipmentDocumentSchemeEntity>> schemeMap = schemeList.stream().collect(Collectors.groupingBy(EquipmentDocumentSchemeEntity::getDocumentSupplierId));
            if (entity.getBidFlag() == 0) {
                for (EquipmentDocumentSupplierVO equipmentDocumentSupplierEntity : equipmentDocumentSupplierVOS) {
                    List<EquipmentDocumentSchemeEntity> equipmentDocumentSchemeEntities = schemeMap.get(equipmentDocumentSupplierEntity.getId());
                    String schemeMoney = "";
                    for (EquipmentDocumentSchemeEntity equipmentDocumentSchemeEntity : equipmentDocumentSchemeEntities) {
                        schemeMoney = schemeMoney + equipmentDocumentSchemeEntity.getSchemeName() + ":" + equipmentDocumentSchemeEntity.getMoneyTax().setScale(2, 5) + "\u5143;";
                    }
                    int length = schemeMoney.length();
                    String schemeMoneyNew = schemeMoney.substring(0, length - 1);
                    equipmentDocumentSupplierEntity.setSchemeMoney(schemeMoneyNew);
                }
                if (CollectionUtils.isNotEmpty((Collection)equipmentDocumentSupplierVOS)) {
                    List data;
                    List attachIds = equipmentDocumentSupplierVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
                    HashMap map = new HashMap();
                    map.put("sourceIds", attachIds);
                    JSONObject itemJSONObj = JSONObject.parseObject((String)JSON.toJSONString(map));
                    CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(itemJSONObj);
                    if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)listCommonResponse.getData()))) {
                        Map attacMap = data.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                        for (EquipmentDocumentSupplierVO equipmentDocumentSupplierVO : equipmentDocumentSupplierVOS) {
                            AttachmentVO attachmentVO = (AttachmentVO)attacMap.get(equipmentDocumentSupplierVO.getId());
                            if (attachmentVO == null) continue;
                            equipmentDocumentSupplierVO.setAttachId(attachmentVO.getId());
                            equipmentDocumentSupplierVO.setFileName(attachmentVO.getFileName());
                        }
                    }
                }
            }
            equipmentDocumentVO.setEquipmentDocumentSupplierList(equipmentDocumentSupplierVOS);
            equipmentDocumentVO.setEquipmentDocumentSupplierSchemeList(equipmentDocumentSupplierVOS);
            List equipmentDocumentDetailList = equipmentDocumentVO.getEquipmentDocumentDetailList();
            LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
            lambdaSell.eq(EquipmentDocumentSellEntity::getDocumentId, (Object)id);
            lambdaSell.eq(EquipmentDocumentSellEntity::getTalkNum, (Object)talkNum);
            lambdaSell.orderByAsc(EquipmentDocumentSellEntity::getSupplierId);
            lambdaSell.orderByAsc(EquipmentDocumentSellEntity::getSchemeName);
            List sellList = this.equipmentDocumentSellService.list((Wrapper)lambdaSell);
            if (CollectionUtils.isNotEmpty((Collection)sellList)) {
                List equipmentDocumentSellVOS = BeanMapper.mapList((Iterable)sellList, EquipmentDocumentSellVO.class);
                for (Object equipmentDocumentSellVO : equipmentDocumentSellVOS) {
                    if (entity.getBidFlag() == 1) {
                        equipmentDocumentSellVO.setPrice(null);
                        equipmentDocumentSellVO.setPriceTax(null);
                        equipmentDocumentSellVO.setMoney(null);
                        equipmentDocumentSellVO.setMoneyTax(null);
                        equipmentDocumentSellVO.setSellTax(null);
                        equipmentDocumentSellVO.setTenderNum(null);
                        equipmentDocumentSellVO.setTenderMoney(null);
                        equipmentDocumentSellVO.setTenderFlag(null);
                    }
                    if (entity.getBidFlag() != 0) continue;
                    equipmentDocumentSellVO.setTenderNum(null);
                    equipmentDocumentSellVO.setTenderMoney(null);
                    equipmentDocumentSellVO.setTenderFlag(null);
                }
                Map<Long, List<EquipmentDocumentSellVO>> sellMap = equipmentDocumentSellVOS.stream().collect(Collectors.groupingBy(EquipmentDocumentSellVO::getDetailId));
                for (EquipmentDocumentDetailVO equipmentDocumentDetailVO : equipmentDocumentDetailList) {
                    ArrayList documentSupplierVOS = new ArrayList();
                    List<EquipmentDocumentSellVO> equipmentDocumentSellEntities = sellMap.get(equipmentDocumentDetailVO.getId());
                    Map<Long, List<EquipmentDocumentSellVO>> sellDetailMap = equipmentDocumentSellEntities.stream().collect(Collectors.groupingBy(EquipmentDocumentSellVO::getSupplierId));
                    sellDetailMap.forEach((key, value) -> {
                        EquipmentDocumentSupplierVO equipmentDocumentSupplierVO = new EquipmentDocumentSupplierVO();
                        equipmentDocumentSupplierVO.setSupplierId(key);
                        EquipmentDocumentSellVO equipmentDocumentSellVO = (EquipmentDocumentSellVO)value.stream().findFirst().get();
                        equipmentDocumentSupplierVO.setSupplierName(equipmentDocumentSellVO.getSupplierName());
                        equipmentDocumentSupplierVO.setEquipmentDocumentSellVOList(value);
                        documentSupplierVOS.add(equipmentDocumentSupplierVO);
                    });
                    equipmentDocumentDetailVO.setEquipmentDocumentSupplierVOList(documentSupplierVOS);
                }
                List equipmentDocumentDetailSellList = equipmentDocumentVO.getEquipmentDocumentDetailList();
                equipmentDocumentVO.setEquipmentDocumentDetailSellList(equipmentDocumentDetailSellList);
            }
        }
        return equipmentDocumentVO;
    }

    @Override
    public List<EquipmentDocumentSellVO> getSchemeDetail(EquipmentDocumentSellVO equipmentDocumentSellVO) {
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(EquipmentDocumentSellEntity::getSupplierId, (Object)equipmentDocumentSellVO.getSupplierId());
        lambdaSell.eq(EquipmentDocumentSellEntity::getDocumentId, (Object)equipmentDocumentSellVO.getDocumentId());
        lambdaSell.eq(EquipmentDocumentSellEntity::getSchemeId, (Object)equipmentDocumentSellVO.getSchemeId());
        List list = this.equipmentDocumentSellService.list((Wrapper)lambdaSell);
        List equipmentDocumentSellVOList = BeanMapper.mapList((Iterable)list, EquipmentDocumentSellVO.class);
        return equipmentDocumentSellVOList;
    }

    @Override
    public EquipmentDocumentSupplierSellVO getSupplierSchemeDetail(Long supplierDetailId, Long documentId) {
        EquipmentDocumentEntity equipmentDocumentEntity = (EquipmentDocumentEntity)((Object)super.selectById((Serializable)documentId));
        EquipmentDocumentSupplierSellVO equipmentDocumentSupplierSellVO = new EquipmentDocumentSupplierSellVO();
        EquipmentDocumentSupplierEntity equipmentDocumentSupplierEntity = (EquipmentDocumentSupplierEntity)((Object)this.equipmentDocumentSupplierService.selectById(supplierDetailId));
        equipmentDocumentSupplierSellVO.setLinkName(equipmentDocumentSupplierEntity.getLinkName());
        equipmentDocumentSupplierSellVO.setSupplierId(equipmentDocumentSupplierEntity.getSupplierId());
        equipmentDocumentSupplierSellVO.setSupplierName(equipmentDocumentSupplierEntity.getSupplierName());
        equipmentDocumentSupplierSellVO.setLinkMobile(equipmentDocumentSupplierEntity.getLinkMobile());
        equipmentDocumentSupplierSellVO.setOfferTime(equipmentDocumentSupplierEntity.getOfferTime());
        equipmentDocumentSupplierSellVO.setTaxMemo(equipmentDocumentSupplierEntity.getTaxMemo());
        equipmentDocumentSupplierSellVO.setPurchaseType(equipmentDocumentEntity.getPurchaseType());
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(EquipmentDocumentSchemeEntity::getDocumentSupplierId, (Object)supplierDetailId);
        List equipmentDocumentSchemeEntityList = this.equipmentDocumentSchemeService.list((Wrapper)lambdaScheme);
        List equipmentDocumentSchemeVOList = BeanMapper.mapList((Iterable)equipmentDocumentSchemeEntityList, EquipmentDocumentSchemeVO.class);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(EquipmentDocumentSellEntity::getDocumentId, (Object)equipmentDocumentSupplierEntity.getDocumentId());
        List equipmentDocumentSellEntityList = this.equipmentDocumentSellService.list((Wrapper)lambdaSell);
        List equipmentDocumentSellVOList = BeanMapper.mapList((Iterable)equipmentDocumentSellEntityList, EquipmentDocumentSellVO.class);
        Map<Long, List<EquipmentDocumentSellVO>> sellMap = equipmentDocumentSellVOList.stream().collect(Collectors.groupingBy(EquipmentDocumentSellVO::getSchemeId));
        for (EquipmentDocumentSchemeVO equipmentDocumentSchemeVO : equipmentDocumentSchemeVOList) {
            List<EquipmentDocumentSellVO> equipmentDocumentSellVOS = sellMap.get(equipmentDocumentSchemeVO.getId());
            equipmentDocumentSchemeVO.setEquipmentDocumentSellList(equipmentDocumentSellVOS);
        }
        equipmentDocumentSupplierSellVO.setEquipmentDocumentSchemeList(equipmentDocumentSchemeVOList);
        Map<String, Object> fileInfo = this.getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                equipmentDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                equipmentDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }
        return equipmentDocumentSupplierSellVO;
    }

    @Override
    @Transactional
    public EquipmentDocumentVO extendDocument(EquipmentDocumentRecordVO equipmentDocumentRecordVO) {
        EquipmentDocumentRecordEntity equipmentDocumentRecordEntity = (EquipmentDocumentRecordEntity)((Object)BeanMapper.map((Object)equipmentDocumentRecordVO, EquipmentDocumentRecordEntity.class));
        this.equipmentDocumentRecordService.save((Object)equipmentDocumentRecordEntity);
        EquipmentDocumentEntity equipmentDocumentEntity = (EquipmentDocumentEntity)((Object)super.selectById((Serializable)equipmentDocumentRecordVO.getDocumentId()));
        equipmentDocumentEntity.setOfferEndTime(equipmentDocumentRecordVO.getNewTime());
        boolean b = super.updateById((Object)equipmentDocumentEntity);
        EquipmentSupplierSellVO supplierSellVO = new EquipmentSupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(equipmentDocumentEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(equipmentDocumentRecordVO.getNewTime());
        String stringFb = JSONObject.toJSONString((Object)supplierSellVO);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.updateTimeUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u62db\u6807\u6587\u4ef6\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        EquipmentDocumentVO equipmentDocumentVO = this.queryDetail(equipmentDocumentRecordVO.getDocumentId());
        return equipmentDocumentVO;
    }

    @Override
    public EquipmentDocumentSupplierSellVO getSupplierSchemeTalkDetail(Long supplierDetailId, Long talkId) {
        EquipmentTalkEntity equipmentTalkEntity = (EquipmentTalkEntity)((Object)this.equipmentTalkService.selectById(talkId));
        Integer talkNum = equipmentTalkEntity.getTalkNum();
        if (equipmentTalkEntity.getPublishFlag() == 1) {
            talkNum = talkNum - 1;
        }
        ArrayList<EquipmentTalkVO> talkVOArrayList = new ArrayList<EquipmentTalkVO>();
        String name = null;
        for (int a = 0; a <= talkNum; ++a) {
            EquipmentTalkVO equipmentTalkVO = new EquipmentTalkVO();
            equipmentTalkVO.setTalkNum(Integer.valueOf(a));
            name = a == 0 ? "\u9996\u6b21\u62a5\u4ef7" : "\u7b2c" + a + "\u8f6e\u62a5\u4ef7";
            equipmentTalkVO.setTalkNumName(name);
            talkVOArrayList.add(equipmentTalkVO);
        }
        EquipmentDocumentSupplierSellVO equipmentDocumentSupplierSellVO = new EquipmentDocumentSupplierSellVO();
        EquipmentDocumentSupplierEntity equipmentDocumentSupplierEntity = (EquipmentDocumentSupplierEntity)((Object)this.equipmentDocumentSupplierService.selectById(supplierDetailId));
        equipmentDocumentSupplierSellVO.setLinkName(equipmentDocumentSupplierEntity.getLinkName());
        equipmentDocumentSupplierSellVO.setLinkMobile(equipmentDocumentSupplierEntity.getLinkMobile());
        equipmentDocumentSupplierSellVO.setOfferTime(equipmentDocumentSupplierEntity.getOfferTime());
        equipmentDocumentSupplierSellVO.setTaxMemo(equipmentDocumentSupplierEntity.getTaxMemo());
        equipmentDocumentSupplierSellVO.setSupplierName(equipmentDocumentSupplierEntity.getSupplierName());
        for (EquipmentTalkVO equipmentTalkVO : talkVOArrayList) {
            LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
            lambdaScheme.eq(EquipmentDocumentSchemeEntity::getDocumentId, (Object)equipmentDocumentSupplierEntity.getDocumentId());
            lambdaScheme.eq(EquipmentDocumentSchemeEntity::getSupplierId, (Object)equipmentDocumentSupplierEntity.getSupplierId());
            lambdaScheme.eq(EquipmentDocumentSchemeEntity::getTalkNum, (Object)equipmentTalkVO.getTalkNum());
            List equipmentDocumentSchemeEntityList = this.equipmentDocumentSchemeService.list((Wrapper)lambdaScheme);
            if (CollectionUtils.isEmpty((Collection)equipmentDocumentSchemeEntityList)) continue;
            List equipmentDocumentSchemeVOList = BeanMapper.mapList((Iterable)equipmentDocumentSchemeEntityList, EquipmentDocumentSchemeVO.class);
            List schemePkList = equipmentDocumentSchemeVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
            lambdaSell.in(EquipmentDocumentSellEntity::getSchemeId, schemePkList);
            List equipmentDocumentSellEntityList = this.equipmentDocumentSellService.list((Wrapper)lambdaSell);
            List equipmentDocumentSellVOList = BeanMapper.mapList((Iterable)equipmentDocumentSellEntityList, EquipmentDocumentSellVO.class);
            Map<Long, List<EquipmentDocumentSellVO>> sellMap = equipmentDocumentSellVOList.stream().collect(Collectors.groupingBy(EquipmentDocumentSellVO::getSchemeId));
            for (EquipmentDocumentSchemeVO equipmentDocumentSchemeVO : equipmentDocumentSchemeVOList) {
                List<EquipmentDocumentSellVO> equipmentDocumentSellVOS = sellMap.get(equipmentDocumentSchemeVO.getId());
                equipmentDocumentSchemeVO.setEquipmentDocumentSellList(equipmentDocumentSellVOS);
            }
            equipmentTalkVO.setEquipmentDocumentSchemeList(equipmentDocumentSchemeVOList);
        }
        equipmentDocumentSupplierSellVO.setEquipmentTalkVOList(talkVOArrayList);
        Map<String, Object> fileInfo = this.getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                equipmentDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                equipmentDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }
        return equipmentDocumentSupplierSellVO;
    }

    private Map<String, Object> getFileInfo(Long sourceId) {
        AttachmentVO attachmentVO;
        List data;
        HashMap<String, Object> map = new HashMap<String, Object>();
        CommonResponse attachResponse = this.attachmentApi.queryListBySourceId(sourceId, BILL_SUPPLIER_TYPE, "supplierFileType", null);
        if (attachResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)attachResponse.getData())) && (attachmentVO = (AttachmentVO)data.stream().findFirst().get()) != null) {
            map.put("fileName", attachmentVO.getFileName());
            map.put("attachId", attachmentVO.getId());
        }
        return map;
    }

    @Override
    public EquipmentDocumentVO publishManyDocument(Long id) throws InvocationTargetException, IllegalAccessException {
        EquipmentDocumentEntity equipmentDocumentEntity = (EquipmentDocumentEntity)((Object)super.selectById((Serializable)id));
        equipmentDocumentEntity.setPublishFlag(0);
        super.updateById((Object)equipmentDocumentEntity);
        EquipmentNoticeSupplierTbVO equipmentNoticeSupplierTbVO = new EquipmentNoticeSupplierTbVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        equipmentNoticeSupplierTbVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u62db\u6807\u6587\u4ef6");
        equipmentNoticeSupplierTbVO.setSourceId(equipmentDocumentEntity.getInviteId().toString());
        EquipmentInviteEntity inviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(equipmentDocumentEntity.getInviteId()));
        if (equipmentDocumentEntity.getTenderType() == 2) {
            equipmentNoticeSupplierTbVO.setNoticeType(Integer.valueOf(2));
        } else {
            equipmentNoticeSupplierTbVO.setNoticeType(Integer.valueOf(3));
        }
        if (equipmentDocumentEntity.getPurchaseType() == 1) {
            equipmentNoticeSupplierTbVO.setSourceProjectId(null);
            equipmentNoticeSupplierTbVO.setProjectName(null);
            equipmentNoticeSupplierTbVO.setProjectCode(null);
        } else {
            equipmentNoticeSupplierTbVO.setSourceProjectId(equipmentDocumentEntity.getProjectId().toString());
            equipmentNoticeSupplierTbVO.setProjectName(equipmentDocumentEntity.getProjectName());
            equipmentNoticeSupplierTbVO.setProjectCode(equipmentDocumentEntity.getProjectCode());
        }
        equipmentNoticeSupplierTbVO.setSourceOrgId(equipmentDocumentEntity.getOrgId().toString());
        equipmentNoticeSupplierTbVO.setOrgName(equipmentDocumentEntity.getOrgName());
        equipmentNoticeSupplierTbVO.setSourceUnitId(equipmentDocumentEntity.getUnitId().toString());
        equipmentNoticeSupplierTbVO.setUnitName(equipmentDocumentEntity.getUnitName());
        equipmentNoticeSupplierTbVO.setMemo(equipmentDocumentEntity.getMemo());
        equipmentNoticeSupplierTbVO.setType("PURCHASE");
        equipmentNoticeSupplierTbVO.setTenderName(equipmentDocumentEntity.getDocumentName());
        equipmentNoticeSupplierTbVO.setTenderType(equipmentDocumentEntity.getTenderType());
        equipmentNoticeSupplierTbVO.setPurchaseType(equipmentDocumentEntity.getPurchaseType().toString());
        equipmentNoticeSupplierTbVO.setPurchaseName(equipmentDocumentEntity.getPurchaseName());
        equipmentNoticeSupplierTbVO.setSourceEmployeeId(equipmentDocumentEntity.getEmployeeId().toString());
        equipmentNoticeSupplierTbVO.setEmployeeName(equipmentDocumentEntity.getEmployeeName());
        equipmentNoticeSupplierTbVO.setEmployeeMobile(equipmentDocumentEntity.getEmployeeMobile());
        equipmentNoticeSupplierTbVO.setValueType(equipmentDocumentEntity.getValueType());
        equipmentNoticeSupplierTbVO.setContent(equipmentDocumentEntity.getDocumentContent());
        equipmentNoticeSupplierTbVO.setOfferStartTime(sdf.format(equipmentDocumentEntity.getOfferStartTime()));
        equipmentNoticeSupplierTbVO.setOfferEndTime(sdf.format(equipmentDocumentEntity.getOfferEndTime()));
        equipmentNoticeSupplierTbVO.setBrandFlag(equipmentDocumentEntity.getBrandFlag());
        equipmentNoticeSupplierTbVO.setProjectLinkName(equipmentDocumentEntity.getProjectLinkName());
        equipmentNoticeSupplierTbVO.setProjectLinkPhone(equipmentDocumentEntity.getProjectLinkPhone());
        equipmentNoticeSupplierTbVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        equipmentNoticeSupplierTbVO.setMaterialContentId(inviteEntity.getPurchaseId());
        equipmentNoticeSupplierTbVO.setMaterialContent(inviteEntity.getPurchaseName());
        ArrayList<Object> equipmentNoticeDetailVOS = new ArrayList<Object>();
        List<EquipmentDocumentDetailVO> documentDetailEntityList = ((EquipmentDocumentMapper)this.baseMapper).selectSumDetail(equipmentDocumentEntity.getId());
        for (EquipmentDocumentDetailVO equipmentDocumentDetailEntity : documentDetailEntityList) {
            EquipmentNoticeDetailTbVO equipmentNoticeDetailTbVO = new EquipmentNoticeDetailTbVO();
            BeanUtils.copyProperties((Object)equipmentNoticeDetailTbVO, (Object)equipmentDocumentDetailEntity);
            equipmentNoticeDetailTbVO.setNum(equipmentDocumentDetailEntity.getSumNum());
            equipmentNoticeDetailTbVO.setMoney(equipmentDocumentDetailEntity.getSumMoney());
            equipmentNoticeDetailTbVO.setMoneyTax(equipmentDocumentDetailEntity.getSumMoneyTax());
            equipmentNoticeDetailTbVO.setSourceId(equipmentDocumentEntity.getInviteId().toString());
            equipmentNoticeDetailTbVO.setSourceMaterialId(equipmentDocumentDetailEntity.getMaterialId() == null ? null : equipmentDocumentDetailEntity.getMaterialId().toString());
            equipmentNoticeDetailTbVO.setSourceMaterialTypeId(equipmentDocumentDetailEntity.getMaterialTypeId().toString());
            equipmentNoticeDetailVOS.add(equipmentNoticeDetailTbVO);
        }
        equipmentNoticeSupplierTbVO.setPurchaseDetailList(equipmentNoticeDetailVOS);
        if (equipmentDocumentEntity.getTenderType() != 2) {
            List detailEntityList = this.supplierDetailService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EquipmentDocumentSupplierDetailEntity::getInviteId, (Object)equipmentDocumentEntity.getInviteId())).eq(BaseEntity::getDr, (Object)0));
            ArrayList<EquipmentNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<EquipmentNoticeSupplierDetailTbVO>();
            for (EquipmentDocumentSupplierDetailEntity supplierDetailEntity : detailEntityList) {
                EquipmentNoticeSupplierDetailTbVO equipmentNoticeSupplierDetailTbVO = new EquipmentNoticeSupplierDetailTbVO();
                equipmentNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
                equipmentNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
                equipmentNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));
                supplierDetailTbVOList.add(equipmentNoticeSupplierDetailTbVO);
            }
            equipmentNoticeSupplierTbVO.setApplyList(supplierDetailTbVOList);
        }
        String stringFb = JSONObject.toJSONString((Object)equipmentNoticeSupplierTbVO);
        CommonResponse response = null;
        try {
            response = this.systemDataPushService.exchangeDataWithUniversal(this.saveOrUpdateUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
            if (!response.isSuccess()) {
                throw new BusinessException("\u62db\u6807\u6587\u4ef6\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + response.getMsg());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u62db\u6807\u6587\u4ef6\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + response.getMsg());
        }
        return this.queryDetail(id);
    }

    @Override
    public CommonResponse delSupplier(Long id) {
        EquipmentDocumentEntity equipmentDocumentEntity = (EquipmentDocumentEntity)((Object)((EquipmentDocumentMapper)this.baseMapper).selectById(id));
        List equipmentDocumentSupplierList = this.supplierMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_id", (Object)equipmentDocumentEntity.getId())).eq((Object)"dr", (Object)0));
        List supplierDetailList = this.supplierDetailMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"invite_id", (Object)equipmentDocumentEntity.getInviteId())).eq((Object)"dr", (Object)0));
        ArrayList oldIds = new ArrayList();
        ArrayList newIds = new ArrayList();
        equipmentDocumentSupplierList.stream().forEach(it -> oldIds.add(it.getSupplierId()));
        supplierDetailList.stream().forEach(it -> newIds.add(it.getSupplierId()));
        List newId = newIds.stream().filter(it -> !oldIds.contains(it)).collect(Collectors.toList());
        List newRequestList = supplierDetailList.stream().filter(it -> newId.contains(it.getSupplierId())).collect(Collectors.toList());
        ArrayList<EquipmentNoticeSupplierDetailTbVO> signVOList = new ArrayList<EquipmentNoticeSupplierDetailTbVO>();
        for (EquipmentDocumentSupplierDetailEntity supplierDetailEntity : newRequestList) {
            EquipmentNoticeSupplierDetailTbVO equipmentNoticeSupplierDetailTbVO = new EquipmentNoticeSupplierDetailTbVO();
            equipmentNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
            equipmentNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
            equipmentNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));
            equipmentNoticeSupplierDetailTbVO.setOutReason("\u8d85\u65f6\u672a\u62a5\u4ef7");
            signVOList.add(equipmentNoticeSupplierDetailTbVO);
        }
        this.logger.info("\u5254\u9664\u7684\u4f9b\u5e94\u5546" + JSON.toJSONString(signVOList));
        CommonResponse response = null;
        try {
            response = this.systemDataPushService.exchangeDataWithUniversal(this.saveOrUpdateUrl, RequestMethod.POST, JSON.toJSONString(signVOList), this.appId, this.appSecret, this.appHost);
            if (!response.isSuccess()) {
                return CommonResponse.error((String)("\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25\uff0c" + response.getMsg()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u5254\u9664\u4f9b\u5e94\u5546\u6210\u529f");
    }

    @Override
    public EquipmentDocumentVO saveManyDocument(Long id) {
        EquipmentDocumentEntity equipmentDocumentEntity = new EquipmentDocumentEntity();
        EquipmentInviteEntity inviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(id));
        equipmentDocumentEntity.setInviteId(inviteEntity.getId());
        equipmentDocumentEntity.setDocumentName(inviteEntity.getTenderName());
        if (inviteEntity.getPurchaseType() == 0) {
            equipmentDocumentEntity.setProjectId(inviteEntity.getProjectId());
            equipmentDocumentEntity.setProjectName(inviteEntity.getProjectName());
            equipmentDocumentEntity.setProjectCode(inviteEntity.getProjectCode());
        }
        equipmentDocumentEntity.setPurchaseId(inviteEntity.getPurchaseId());
        equipmentDocumentEntity.setPurchaseName(inviteEntity.getPurchaseName());
        equipmentDocumentEntity.setPurchaseType(inviteEntity.getPurchaseType());
        equipmentDocumentEntity.setOrgId(inviteEntity.getOrgId());
        equipmentDocumentEntity.setOrgName(inviteEntity.getOrgName());
        equipmentDocumentEntity.setParentOrgId(inviteEntity.getParentOrgId());
        equipmentDocumentEntity.setParentOrgName(inviteEntity.getParentOrgName());
        equipmentDocumentEntity.setValueType(inviteEntity.getValueType());
        equipmentDocumentEntity.setUnitId(inviteEntity.getUnitId());
        equipmentDocumentEntity.setUnitName(inviteEntity.getUnitName());
        equipmentDocumentEntity.setTenderType(inviteEntity.getTenderType());
        equipmentDocumentEntity.setBidFlag(1);
        equipmentDocumentEntity.setPublishFlag(1);
        equipmentDocumentEntity.setNextFlag(1);
        List<EquipmentInviteDetailEntity> equipmentNoticeDetailList = inviteEntity.getEquipmentDetail();
        List equipmentDocumentDetailList = BeanMapper.mapList(equipmentNoticeDetailList, EquipmentDocumentDetailEntity.class);
        for (EquipmentDocumentDetailEntity equipmentDocumentDetailEntity : equipmentDocumentDetailList) {
            equipmentDocumentDetailEntity.setId(null);
        }
        equipmentDocumentEntity.setEquipmentDocumentDetailList(equipmentDocumentDetailList);
        List<EquipmentInviteSupplierEntity> supplierDetailList = inviteEntity.getSupplierDetail();
        List equipmentDocumentSupplierDetailVOS = BeanMapper.mapList(supplierDetailList, EquipmentDocumentSupplierDetailEntity.class);
        for (EquipmentDocumentSupplierDetailEntity equipmentDocumentSupplierDetailVO : equipmentDocumentSupplierDetailVOS) {
            equipmentDocumentSupplierDetailVO.setId(null);
            this.documentSupplierDetailService.saveOrUpdate((Object)equipmentDocumentSupplierDetailVO);
        }
        this.service.saveOrUpdate((Object)equipmentDocumentEntity, false);
        ProcessEntity processEntity = new ProcessEntity();
        switch (inviteEntity.getTenderType()) {
            case 3: {
                inviteEntity.setTenderStage(6);
                processEntity.setBillName("\u7ade\u4e89\u6027\u8c08\u5224");
                break;
            }
            case 4: {
                inviteEntity.setTenderStage(8);
                processEntity.setBillName("\u5355\u4e00\u6765\u6e90");
                break;
            }
            case 5: {
                inviteEntity.setTenderStage(9);
                processEntity.setBillName("\u7d27\u6025\u62db\u6807");
                break;
            }
            case 2: {
                inviteEntity.setTenderStage(10);
                processEntity.setBillName("\u8be2\u4ef7\u516c\u544a");
            }
        }
        this.equipmentInviteService.updateById((Object)inviteEntity);
        processEntity.setBillId(equipmentDocumentEntity.getId());
        processEntity.setTenderId(id);
        processEntity.setType(2);
        processEntity.setFrontendUrl("equipment/fourJzDyJjXj");
        this.processService.saveOrUpdate((Object)processEntity);
        EquipmentDocumentVO vo = (EquipmentDocumentVO)BeanMapper.map((Object)((Object)equipmentDocumentEntity), EquipmentDocumentVO.class);
        return vo;
    }

    @Override
    public EquipmentDocumentSupplierSellVO getSupplierSchemeDetailTalk(Long supplierDetailId, Long talkId) {
        EquipmentTalkRecordEntity equipmentTalkRecordEntity = (EquipmentTalkRecordEntity)((Object)this.equipmentTalkRecordService.selectById(talkId));
        Integer talkNum = equipmentTalkRecordEntity.getTalkNum();
        if (equipmentTalkRecordEntity.getPublishFlag() == 1) {
            talkNum = talkNum - 1;
        }
        EquipmentDocumentSupplierSellVO equipmentDocumentSupplierSellVO = new EquipmentDocumentSupplierSellVO();
        EquipmentDocumentSupplierEntity equipmentDocumentSupplierEntity = (EquipmentDocumentSupplierEntity)((Object)this.equipmentDocumentSupplierService.selectById(supplierDetailId));
        equipmentDocumentSupplierSellVO.setLinkName(equipmentDocumentSupplierEntity.getLinkName());
        equipmentDocumentSupplierSellVO.setLinkMobile(equipmentDocumentSupplierEntity.getLinkMobile());
        equipmentDocumentSupplierSellVO.setOfferTime(equipmentDocumentSupplierEntity.getOfferTime());
        equipmentDocumentSupplierSellVO.setTaxMemo(equipmentDocumentSupplierEntity.getTaxMemo());
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(EquipmentDocumentSchemeEntity::getDocumentSupplierId, (Object)supplierDetailId);
        List equipmentDocumentSchemeEntityList = this.equipmentDocumentSchemeService.list((Wrapper)lambdaScheme);
        List equipmentDocumentSchemeVOList = BeanMapper.mapList((Iterable)equipmentDocumentSchemeEntityList, EquipmentDocumentSchemeVO.class);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(EquipmentDocumentSellEntity::getDocumentId, (Object)equipmentDocumentSupplierEntity.getDocumentId());
        lambdaSell.eq(EquipmentDocumentSellEntity::getTalkNum, (Object)talkNum);
        List equipmentDocumentSellEntityList = this.equipmentDocumentSellService.list((Wrapper)lambdaSell);
        List equipmentDocumentSellVOList = BeanMapper.mapList((Iterable)equipmentDocumentSellEntityList, EquipmentDocumentSellVO.class);
        Map<Long, List<EquipmentDocumentSellVO>> sellMap = equipmentDocumentSellVOList.stream().collect(Collectors.groupingBy(EquipmentDocumentSellVO::getSchemeId));
        for (EquipmentDocumentSchemeVO equipmentDocumentSchemeVO : equipmentDocumentSchemeVOList) {
            List<EquipmentDocumentSellVO> equipmentDocumentSellVOS = sellMap.get(equipmentDocumentSchemeVO.getId());
            equipmentDocumentSchemeVO.setEquipmentDocumentSellList(equipmentDocumentSellVOS);
        }
        equipmentDocumentSupplierSellVO.setEquipmentDocumentSchemeList(equipmentDocumentSchemeVOList);
        Map<String, Object> fileInfo = this.getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                equipmentDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                equipmentDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }
        return equipmentDocumentSupplierSellVO;
    }

    @Override
    public EquipmentDocumentVO saveDocument(Long noticeId) {
        EquipmentDocumentEntity entity = new EquipmentDocumentEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        EquipmentNoticeEntity equipmentNoticeEntity = (EquipmentNoticeEntity)((Object)this.equipmentNoticeService.selectById(noticeId));
        EquipmentInviteEntity equipmentInvite = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(equipmentNoticeEntity.getInviteId()));
        List<EquipmentInviteDetailEntity> equipmentInviteDetailList = equipmentInvite.getEquipmentDetail();
        List equipmentDocumentDetailList = BeanMapper.mapList(equipmentInviteDetailList, EquipmentDocumentDetailEntity.class);
        for (EquipmentDocumentDetailEntity equipmentDocumentDetailEntity : equipmentDocumentDetailList) {
            equipmentDocumentDetailEntity.setId(null);
        }
        entity.setEquipmentDocumentDetailList(equipmentDocumentDetailList);
        entity.setProjectId(equipmentNoticeEntity.getProjectId());
        entity.setNoticeId(noticeId);
        entity.setProjectName(equipmentNoticeEntity.getProjectName());
        entity.setOrgId(equipmentNoticeEntity.getOrgId());
        entity.setOrgName(equipmentNoticeEntity.getOrgName());
        entity.setParentOrgId(equipmentNoticeEntity.getParentOrgId());
        entity.setParentOrgName(equipmentNoticeEntity.getParentOrgName());
        entity.setProjectCode(equipmentNoticeEntity.getProjectCode());
        entity.setDocumentName(equipmentNoticeEntity.getNoticeName());
        entity.setEmployeeId(equipmentNoticeEntity.getEmployeeId());
        entity.setEmployeeName(equipmentNoticeEntity.getEmployeeName());
        entity.setEmployeeMobile(equipmentNoticeEntity.getEmployeeMobile());
        entity.setInviteId(equipmentNoticeEntity.getInviteId());
        entity.setPurchaseId(equipmentNoticeEntity.getPurchaseId());
        entity.setPurchaseName(equipmentNoticeEntity.getPurchaseName());
        entity.setPurchaseType(equipmentNoticeEntity.getPurchaseType());
        entity.setTenderType(equipmentNoticeEntity.getTenderType());
        EquipmentInviteEntity equipmentInviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(equipmentNoticeEntity.getInviteId()));
        entity.setValueType(equipmentInviteEntity.getValueType());
        entity.setBidFlag(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        this.service.saveOrUpdate((Object)entity, false);
        equipmentInviteEntity.setTenderStage(3);
        this.equipmentInviteService.updateById((Object)equipmentInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u62db\u6807\u6587\u4ef6");
        processEntity.setTenderId(equipmentNoticeEntity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("equipment/document");
        this.processService.saveOrUpdate((Object)processEntity);
        EquipmentDocumentVO vo = (EquipmentDocumentVO)BeanMapper.map((Object)((Object)entity), EquipmentDocumentVO.class);
        return vo;
    }

    @Override
    public CommonResponse<Boolean> checkExpertNum(Long documentId) {
        List expertEntityList = this.documentExpertService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EquipmentDocumentExpertEntity::getDocumentId, (Object)documentId)).eq(BaseEntity::getDr, (Object)0));
        int totalNum = expertEntityList.size();
        if (totalNum < 3) {
            return CommonResponse.error((String)"\u6240\u9009\u4e13\u5bb6\u6570\u91cf\u81f3\u5c11\u4e3a3\u4eba\uff01", (Object)false);
        }
        if (totalNum % 2 == 0) {
            return CommonResponse.error((String)"\u6240\u9009\u4e13\u5bb6\u6570\u91cf\u5fc5\u987b\u4e3a\u5355\u6570\uff01", (Object)false);
        }
        int departmentExpertNum = (int)expertEntityList.stream().filter(entity -> "\u96c6\u56e2".equals(entity.getExpertFromName())).count();
        int projectExpertNum = (int)expertEntityList.stream().filter(entity -> "\u9879\u76ee".equals(entity.getExpertFromName())).count();
        int trueDepartmentExpertNum = (int)Math.ceil((double)totalNum * 1.0 / 3.0);
        int trueProjectExpertNum = totalNum - trueDepartmentExpertNum;
        if (departmentExpertNum != trueDepartmentExpertNum || projectExpertNum != trueProjectExpertNum) {
            return CommonResponse.error((String)("\u6240\u9009\u4e13\u5bb6\u6570\u91cf\u4e0d\u7b26\u5408\u8981\u6c42\uff01\u96c6\u56e2\u4e13\u5bb6" + trueDepartmentExpertNum + "\u4e2a,\u9879\u76ee\u4e13\u5bb6" + trueProjectExpertNum + "\u4e2a\uff01"), (Object)false);
        }
        return CommonResponse.success((String)"\u4e13\u5bb6\u9009\u53d6\u6210\u529f\uff01", (Object)true);
    }
}

