/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.mapper.ExpertRecordMapper;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.other.bean.OtherDocumentEntity;
import com.ejianc.business.tender.other.bean.OtherDocumentSchemeEntity;
import com.ejianc.business.tender.other.bean.OtherDocumentSellEntity;
import com.ejianc.business.tender.other.bean.OtherDocumentSupplierEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.bean.OtherPicketageEntity;
import com.ejianc.business.tender.other.bean.OtherPicketageSupplierEntity;
import com.ejianc.business.tender.other.bean.OtherTalkEntity;
import com.ejianc.business.tender.other.mapper.OtherDocumentSchemeMapper;
import com.ejianc.business.tender.other.mapper.OtherPicketageMapper;
import com.ejianc.business.tender.other.service.IOtherDocumentSchemeService;
import com.ejianc.business.tender.other.service.IOtherDocumentSellService;
import com.ejianc.business.tender.other.service.IOtherDocumentService;
import com.ejianc.business.tender.other.service.IOtherDocumentSupplierService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.service.IOtherPicketageService;
import com.ejianc.business.tender.other.service.IOtherPicketageSupplierService;
import com.ejianc.business.tender.other.service.IOtherTalkService;
import com.ejianc.business.tender.other.vo.OtherDocumentDetailVO;
import com.ejianc.business.tender.other.vo.OtherDocumentSellVO;
import com.ejianc.business.tender.other.vo.OtherDocumentVO;
import com.ejianc.business.tender.other.vo.OtherPicketageSupplierVO;
import com.ejianc.business.tender.other.vo.OtherPicketageVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="otherPicketageService")
public class OtherPicketageServiceImpl
extends BaseServiceImpl<OtherPicketageMapper, OtherPicketageEntity>
implements IOtherPicketageService {
    private static final String BILL_CODE = "invite-picketage-code";
    @Autowired
    private IExpertEvaluatingService IExpertEvaluatingService;
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private IOtherDocumentService otherDocumentService;
    @Autowired
    private IOtherDocumentSellService otherDocumentSellService;
    @Autowired
    private IOtherDocumentSchemeService otherDocumentSchemeService;
    @Autowired
    private IOtherDocumentSupplierService otherDocumentSupplierService;
    @Autowired
    private OtherDocumentSchemeMapper schemeMapper;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IOtherTalkService otherTalkService;
    @Autowired
    private IOtherPicketageSupplierService otherPicketageSupplierService;
    @Autowired
    private ExpertRecordMapper recordMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    public OtherPicketageVO savePicketage(Long evaluationId) {
        OtherPicketageEntity entity = new OtherPicketageEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        ExpertEvaluatingEntity otherEvaluationEntity = (ExpertEvaluatingEntity)((Object)this.IExpertEvaluatingService.selectById(evaluationId));
        OtherInviteEntity inviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(otherEvaluationEntity.getInviteId()));
        OtherDocumentEntity otherDocumentEntity = (OtherDocumentEntity)((Object)this.otherDocumentService.selectById(otherEvaluationEntity.getDocumentId()));
        entity.setPicketageName(inviteEntity.getTenderName() + "\u5b9a\u6807");
        entity.setEmployeeId(otherDocumentEntity.getEmployeeId());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setEmployeeName(otherDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(otherDocumentEntity.getEmployeeMobile());
        entity.setValueType(otherDocumentEntity.getValueType());
        OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(otherDocumentEntity.getInviteId()));
        entity.setPurchaseId(otherInviteEntity.getPurchaseId());
        entity.setPurchaseName(otherInviteEntity.getPurchaseName());
        entity.setDocumentId(otherEvaluationEntity.getDocumentId());
        entity.setEvaluationId(otherEvaluationEntity.getId());
        entity.setInviteId(otherEvaluationEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(this.sessionManager.getUserContext().getEmployeeName());
        String mobilePhone = ((EmployeeVO)this.employeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone();
        entity.setTrusteesPhone(mobilePhone);
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode((Integer)inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(5));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate((Object)entity, false);
        OtherPicketageVO vo = (OtherPicketageVO)BeanMapper.map((Object)((Object)entity), OtherPicketageVO.class);
        otherInviteEntity.setTenderStage(5);
        this.otherInviteService.updateById((Object)otherInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u5b9a\u6807");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("other/picketage");
        this.processService.saveOrUpdate((Object)processEntity);
        List<OtherDocumentSchemeEntity> schemeList = this.schemeMapper.selectSupplier(otherDocumentEntity.getId());
        for (OtherDocumentSchemeEntity schemeEntity : schemeList) {
            BigDecimal score = this.recordMapper.selectScore(schemeEntity.getId(), schemeEntity.getSupplierId(), otherDocumentEntity.getId());
            Boolean scoreBoolean = this.schemeMapper.updateScore(schemeEntity.getId(), schemeEntity.getSupplierId(), otherDocumentEntity.getId(), score);
            if (scoreBoolean.booleanValue()) continue;
            throw new BusinessException("\u56de\u5199\u65b9\u6848\u5f97\u5206\u5931\u8d25!");
        }
        return vo;
    }

    @Override
    @Transactional
    public OtherPicketageVO queryDetail(Long id) {
        OtherPicketageEntity otherPicketageEntity = (OtherPicketageEntity)((Object)super.selectById((Serializable)id));
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(OtherDocumentSupplierEntity::getDocumentId, (Object)otherPicketageEntity.getDocumentId());
        List supplieotherityList = this.otherDocumentSupplierService.list((Wrapper)lambdaSupplier);
        List talkNumList = supplieotherityList.stream().map(OtherDocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
        Integer talkNumMax = (Integer)talkNumList.stream().max(Integer::compareTo).get();
        OtherDocumentEntity entity = (OtherDocumentEntity)((Object)this.otherDocumentService.selectById(otherPicketageEntity.getDocumentId()));
        OtherDocumentVO otherDocumentVO = (OtherDocumentVO)BeanMapper.map((Object)((Object)entity), OtherDocumentVO.class);
        List otherDocumentDetailList = otherDocumentVO.getOtherDocumentDetailList();
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(OtherDocumentSellEntity::getDocumentId, (Object)otherPicketageEntity.getDocumentId());
        lambdaSell.eq(OtherDocumentSellEntity::getTalkNum, (Object)talkNumMax);
        lambdaSell.eq(OtherDocumentSellEntity::getPassFlag, (Object)1);
        lambdaSell.orderByAsc(OtherDocumentSellEntity::getSupplierId);
        lambdaSell.orderByAsc(OtherDocumentSellEntity::getSchemeName);
        List sellList = this.otherDocumentSellService.list((Wrapper)lambdaSell);
        List otherDocumentSellVOS = BeanMapper.mapList((Iterable)sellList, OtherDocumentSellVO.class);
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(OtherDocumentSchemeEntity::getDocumentId, (Object)otherPicketageEntity.getDocumentId());
        lambdaScheme.eq(OtherDocumentSchemeEntity::getTalkNum, (Object)talkNumMax);
        lambdaScheme.orderByAsc(OtherDocumentSchemeEntity::getSchemeName);
        List schemeList = this.otherDocumentSchemeService.list((Wrapper)lambdaScheme);
        for (OtherDocumentSchemeEntity otherDocumentSchemeEntity : schemeList) {
            for (OtherDocumentSellVO otherDocumentSellVO : otherDocumentSellVOS) {
                if (!otherDocumentSellVO.getSchemeId().equals(otherDocumentSchemeEntity.getId())) continue;
                otherDocumentSellVO.setScore(otherDocumentSchemeEntity.getScore());
            }
        }
        OtherDocumentSellVO otherDocumentSellFirst = (OtherDocumentSellVO)otherDocumentSellVOS.stream().findFirst().get();
        if (otherDocumentSellFirst.getScore() == null) {
            otherDocumentSellVOS.sort(Comparator.comparing(BaseVO::getCreateTime).reversed());
        }
        if (otherDocumentSellFirst.getScore() != null) {
            otherDocumentSellVOS.sort(Comparator.comparing(OtherDocumentSellVO::getScore).reversed());
        }
        Map<Long, List<OtherDocumentSellVO>> sellMap = otherDocumentSellVOS.stream().collect(Collectors.groupingBy(OtherDocumentSellVO::getDetailId));
        for (OtherDocumentDetailVO otherDocumentDetailVO : otherDocumentDetailList) {
            List<OtherDocumentSellVO> otherDocumentSellEntities = sellMap.get(otherDocumentDetailVO.getId());
            otherDocumentDetailVO.setOtherDocumentSellVOList(otherDocumentSellEntities);
        }
        OtherPicketageVO otherPicketageVO = (OtherPicketageVO)BeanMapper.map((Object)((Object)otherPicketageEntity), OtherPicketageVO.class);
        otherPicketageVO.setOtherDocumentDetailList(otherDocumentDetailList);
        if (otherDocumentSellFirst.getScore() == null) {
            otherPicketageVO.setScoreStatus(Integer.valueOf(1));
        }
        if (otherDocumentSellFirst.getScore() != null) {
            otherPicketageVO.setScoreStatus(Integer.valueOf(0));
        }
        return otherPicketageVO;
    }

    @Override
    public OtherPicketageVO saveOrUpdates(OtherPicketageVO saveorUpdateVO) {
        OtherPicketageEntity entity = (OtherPicketageEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OtherPicketageEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(OtherPicketageSupplierEntity::getPicketageId, (Object)entity.getId());
        this.otherPicketageSupplierService.remove((Wrapper)lambdaSupplier);
        List picketageSupplierList = saveorUpdateVO.getPicketageSupplierList();
        for (OtherPicketageSupplierVO otherPicketageSupplierVO : picketageSupplierList) {
            otherPicketageSupplierVO.setTenderFlag(Integer.valueOf(0));
        }
        List otherPicketageSupplierList = BeanMapper.mapList((Iterable)picketageSupplierList, OtherPicketageSupplierEntity.class);
        this.otherPicketageSupplierService.saveBatch(otherPicketageSupplierList);
        List otherDocumentDetailList = saveorUpdateVO.getOtherDocumentDetailList();
        ArrayList documentSellVOArrayList = new ArrayList();
        for (OtherDocumentDetailVO otherDocumentDetailVO : otherDocumentDetailList) {
            documentSellVOArrayList.addAll(otherDocumentDetailVO.getOtherDocumentSellVOList());
        }
        List otherDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList, OtherDocumentSellEntity.class);
        this.otherDocumentSellService.saveOrUpdateBatch(otherDocumentSellEntityList);
        OtherPicketageVO otherPicketageVO = this.queryDetail(saveorUpdateVO.getId());
        return otherPicketageVO;
    }

    @Override
    public OtherPicketageVO saveManyPicketage(Long documentId) {
        OtherPicketageEntity entity = new OtherPicketageEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        OtherDocumentEntity documentEntity = (OtherDocumentEntity)((Object)this.otherDocumentService.selectById(documentId));
        documentEntity.setNextFlag(0);
        this.otherDocumentService.saveOrUpdate((Object)documentEntity);
        LambdaQueryWrapper lambdaTalk = Wrappers.lambdaQuery();
        lambdaTalk.eq(OtherTalkEntity::getBillId, (Object)documentId);
        OtherTalkEntity otherTalkEntity = (OtherTalkEntity)((Object)this.otherTalkService.getOne((Wrapper)lambdaTalk));
        if (otherTalkEntity != null) {
            otherTalkEntity.setNextFlag(0);
            this.otherTalkService.updateById((Object)otherTalkEntity);
        }
        OtherDocumentEntity otherDocumentEntity = (OtherDocumentEntity)((Object)this.otherDocumentService.selectById(documentId));
        OtherInviteEntity inviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(otherDocumentEntity.getInviteId()));
        entity.setPicketageName(inviteEntity.getTenderName() + "\u5b9a\u6807");
        entity.setEmployeeId(otherDocumentEntity.getEmployeeId());
        entity.setEmployeeName(otherDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(otherDocumentEntity.getEmployeeMobile());
        entity.setValueType(otherDocumentEntity.getValueType());
        OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(otherDocumentEntity.getInviteId()));
        entity.setPurchaseId(otherInviteEntity.getPurchaseId());
        entity.setPurchaseName(otherInviteEntity.getPurchaseName());
        entity.setPurchaseType(otherInviteEntity.getPurchaseType());
        entity.setDocumentId(documentId);
        entity.setInviteId(otherDocumentEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(this.sessionManager.getUserContext().getEmployeeName());
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode((Integer)inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(0));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate((Object)entity, false);
        OtherPicketageVO vo = (OtherPicketageVO)BeanMapper.map((Object)((Object)entity), OtherPicketageVO.class);
        otherInviteEntity.setTenderStage(5);
        this.otherInviteService.updateById((Object)otherInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u5b9a\u6807");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("other/picketage");
        this.processService.saveOrUpdate((Object)processEntity);
        return vo;
    }

    @Override
    public List<OtherPicketageSupplierVO> querySupplierList(Long picketageId) {
        OtherPicketageEntity otherPicketageEntity = (OtherPicketageEntity)((Object)super.selectById((Serializable)picketageId));
        List<OtherPicketageSupplierEntity> picketageSupplierList = otherPicketageEntity.getPicketageSupplierList();
        List list = BeanMapper.mapList(picketageSupplierList, OtherPicketageSupplierVO.class);
        return list;
    }

    @Override
    public OtherPicketageVO saveSupplierBatch(OtherPicketageVO saveorUpdateVO) {
        OtherPicketageEntity stuffPicketageEntity = (OtherPicketageEntity)((Object)super.selectById((Serializable)saveorUpdateVO.getId()));
        List<OtherPicketageSupplierEntity> picketageSupplierList = stuffPicketageEntity.getPicketageSupplierList();
        if (CollectionUtils.isNotEmpty(picketageSupplierList)) {
            return this.queryDetail(saveorUpdateVO.getId());
        }
        List otherPicketageSupplierEntities = BeanMapper.mapList((Iterable)saveorUpdateVO.getPicketageSupplierList(), OtherPicketageSupplierEntity.class);
        for (OtherPicketageSupplierEntity otherPicketageSupplierEntity : otherPicketageSupplierEntities) {
            otherPicketageSupplierEntity.setTenderFlag(0);
        }
        this.otherPicketageSupplierService.saveBatch(otherPicketageSupplierEntities);
        List otherDocumentDetailList = saveorUpdateVO.getOtherDocumentDetailList();
        ArrayList documentSellVOArrayList = new ArrayList();
        for (OtherDocumentDetailVO otherDocumentDetailVO : otherDocumentDetailList) {
            documentSellVOArrayList.addAll(otherDocumentDetailVO.getOtherDocumentSellVOList());
        }
        List otherDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList, OtherDocumentSellEntity.class);
        this.otherDocumentSellService.saveOrUpdateBatch(otherDocumentSellEntityList);
        return this.queryDetail(saveorUpdateVO.getId());
    }
}

