/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.rent.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.bean.RentInviteSupplierEntity;
import com.ejianc.business.tender.rent.bean.RentNoticeEntity;
import com.ejianc.business.tender.rent.bean.RentNoticeSupplierDetailEntity;
import com.ejianc.business.tender.rent.mapper.RentNoticeDetailMapper;
import com.ejianc.business.tender.rent.mapper.RentNoticeMapper;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rent.service.IRentInviteSupplierService;
import com.ejianc.business.tender.rent.service.IRentNoticeService;
import com.ejianc.business.tender.rent.service.IRentNoticeSupplierDetailService;
import com.ejianc.business.tender.rent.service.IRentNoticeSupplierService;
import com.ejianc.business.tender.rent.vo.RentNoticeDetailTbVO;
import com.ejianc.business.tender.rent.vo.RentNoticeDetailVO;
import com.ejianc.business.tender.rent.vo.RentNoticeSupplierDetailTbVO;
import com.ejianc.business.tender.rent.vo.RentNoticeSupplierTbVO;
import com.ejianc.business.tender.rent.vo.RentNoticeSupplierVO;
import com.ejianc.business.tender.rent.vo.RentNoticeVO;
import com.ejianc.business.tender.util.SMS;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.tools.ant.util.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="rentNoticeService")
public class RentNoticeServiceImpl
extends BaseServiceImpl<RentNoticeMapper, RentNoticeEntity>
implements IRentNoticeService {
    @Value(value="${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IRentNoticeSupplierDetailService noticeSupplierDetailService;
    @Autowired
    private RentNoticeDetailMapper rentNoticeDetailMapper;
    @Autowired
    private IRentNoticeSupplierService supplierService;
    @Autowired
    private IRentInviteService inviteService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IRentInviteSupplierService inviteSupplierService;
    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Override
    public void updateEndTime(Long noticeId, Date newTime) {
        ((RentNoticeMapper)this.baseMapper).updateEndTime(noticeId, newTime);
    }

    @Override
    @Transactional
    public CommonResponse publish(RentNoticeVO rentNoticeVO) throws InvocationTargetException, IllegalAccessException {
        RentNoticeEntity rentNoticeEntity = (RentNoticeEntity)((Object)((RentNoticeMapper)this.baseMapper).selectById(rentNoticeVO.getId()));
        RentInviteEntity inviteEntity = (RentInviteEntity)((Object)this.inviteService.selectById(rentNoticeEntity.getInviteId()));
        rentNoticeEntity.setPublishFlag(0);
        ((RentNoticeMapper)this.baseMapper).updateById((Object)rentNoticeEntity);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        RentNoticeSupplierTbVO rentNoticeSupplierTbVO = new RentNoticeSupplierTbVO();
        BeanUtils.copyProperties((Object)rentNoticeSupplierTbVO, (Object)((Object)rentNoticeEntity));
        rentNoticeSupplierTbVO.setNoticeStartTime(sdf.format(rentNoticeEntity.getNoticeStartTime()));
        rentNoticeSupplierTbVO.setNoticeEndTime(sdf.format(rentNoticeEntity.getNoticeEndTime()));
        rentNoticeSupplierTbVO.setNoticeType(Integer.valueOf(0));
        if (rentNoticeEntity.getPurchaseType() == 1) {
            rentNoticeSupplierTbVO.setSourceProjectId(null);
        } else {
            rentNoticeSupplierTbVO.setSourceProjectId(rentNoticeEntity.getProjectId().toString());
        }
        rentNoticeSupplierTbVO.setSourceId(rentNoticeEntity.getInviteId().toString());
        rentNoticeSupplierTbVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u62db\u6807\u516c\u544a");
        rentNoticeSupplierTbVO.setSourceOrgId(rentNoticeEntity.getOrgId().toString());
        rentNoticeSupplierTbVO.setSourceUnitId(rentNoticeEntity.getUnitId().toString());
        rentNoticeSupplierTbVO.setType("RENT");
        rentNoticeSupplierTbVO.setTenderName(rentNoticeEntity.getNoticeName());
        rentNoticeSupplierTbVO.setSourceEmployeeId(rentNoticeEntity.getEmployeeId().toString());
        rentNoticeSupplierTbVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        rentNoticeSupplierTbVO.setMaterialContentId(inviteEntity.getPurchaseId());
        rentNoticeSupplierTbVO.setMaterialContent(inviteEntity.getPurchaseName());
        rentNoticeSupplierTbVO.setId(null);
        rentNoticeSupplierTbVO.setCreateTime(null);
        rentNoticeSupplierTbVO.setUpdateTime(null);
        rentNoticeSupplierTbVO.setCreateUserCode(null);
        rentNoticeSupplierTbVO.setUpdateUserCode(null);
        rentNoticeSupplierTbVO.setSyncEsFlag(null);
        rentNoticeSupplierTbVO.setVersion(null);
        rentNoticeSupplierTbVO.setTenantId(null);
        rentNoticeSupplierTbVO.setDr(null);
        List<RentNoticeDetailVO> noticeDetailEntityList = this.rentNoticeDetailMapper.selectSumDetail(rentNoticeVO.getId());
        ArrayList<Object> rentNoticeDetailVOS = new ArrayList<Object>();
        for (RentNoticeDetailVO rentNoticeDetailEntity : noticeDetailEntityList) {
            RentNoticeDetailTbVO rentNoticeDetailTbVO = new RentNoticeDetailTbVO();
            BeanUtils.copyProperties((Object)rentNoticeDetailTbVO, (Object)rentNoticeDetailEntity);
            rentNoticeDetailTbVO.setNum(rentNoticeDetailEntity.getSumNum());
            rentNoticeDetailTbVO.setMoney(rentNoticeDetailEntity.getSumMoney());
            rentNoticeDetailTbVO.setMoneyTax(rentNoticeDetailEntity.getSumMoneyTax());
            rentNoticeDetailTbVO.setSourceId(rentNoticeEntity.getInviteId().toString());
            rentNoticeDetailTbVO.setSourceMaterialId(rentNoticeDetailEntity.getMaterialId() == null ? null : rentNoticeDetailEntity.getMaterialId().toString());
            rentNoticeDetailTbVO.setSourceMaterialTypeId(rentNoticeDetailEntity.getMaterialTypeId() == null ? null : rentNoticeDetailEntity.getMaterialTypeId().toString());
            rentNoticeDetailVOS.add(rentNoticeDetailTbVO);
        }
        rentNoticeSupplierTbVO.setRentDetailList(rentNoticeDetailVOS);
        if (rentNoticeVO.getTenderType() == 1) {
            List detailEntityList = this.noticeSupplierDetailService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RentNoticeSupplierDetailEntity::getInviteId, (Object)rentNoticeEntity.getInviteId())).eq(BaseEntity::getDr, (Object)0));
            ArrayList<RentNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<RentNoticeSupplierDetailTbVO>();
            for (RentNoticeSupplierDetailEntity supplierDetailEntity : detailEntityList) {
                RentNoticeSupplierDetailTbVO rentNoticeSupplierDetailTbVO = new RentNoticeSupplierDetailTbVO();
                rentNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
                rentNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
                rentNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));
                supplierDetailTbVOList.add(rentNoticeSupplierDetailTbVO);
            }
            rentNoticeSupplierTbVO.setApplyList(supplierDetailTbVOList);
        }
        CommonResponse response = null;
        try {
            response = this.systemDataPushService.exchangeDataWithUniversal(this.saveOrUpdateUrl, RequestMethod.POST, JSON.toJSONString((Object)rentNoticeSupplierTbVO), this.appId, this.appSecret, this.appHost);
            if (rentNoticeEntity.getTenderType() == 1) {
                List detailEntityList = this.inviteSupplierService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RentInviteSupplierEntity::getInviteId, (Object)rentNoticeEntity.getInviteId())).eq(BaseEntity::getDr, (Object)0));
                ArrayList supplierDetailTbVOList = new ArrayList();
                for (RentInviteSupplierEntity supplierDetailEntity : detailEntityList) {
                    String mobile = supplierDetailEntity.getMobile();
                    String url = "https://test.17elian.com/sso/login?service=https%3A%2F%2Ftest.17elian.com%2Fportal%2Fsso%2Flogin";
                    String context = "\u9080\u8bf7\u60a8\u53c2\u52a0[" + rentNoticeEntity.getProjectName() + "]\u4e3e\u884c\u7684\u6295\u6807\u62a5\u540d,";
                    context = context + "\u62a5\u540d\u622a\u6b62\u65e5\u671f\uff1a" + DateUtils.format((Date)rentNoticeEntity.getNoticeEndTime(), (String)"yyyy-MM-dd hh:mm:ss") + ";";
                    context = context + "\u62db\u6807\u8054\u7cfb\u4eba\uff1a" + rentNoticeEntity.getEmployeeName() + ";";
                    context = context + "\u8054\u7cfb\u65b9\u5f0f\uff1a" + rentNoticeEntity.getEmployeeMobile() + ";";
                    context = context + "\u8be6\u60c5\u8bf7\u767b\u5f55\u7cfb\u7edf\u8fdb\u884c\u67e5\u770b" + url;
                    String end = " \u3010\u90d1\u5dde\u4e00\u5efa\u3011";
                    context = context + end;
                    if (mobile == null) continue;
                    SMS.setSendSms((String)mobile, (String)context);
                }
            }
            if (!response.isSuccess()) {
                return CommonResponse.error((String)("\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25\uff0c" + response.getMsg()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u516c\u544a\u4fe1\u606f\u63a8\u9001\u6210\u529f");
    }

    @Override
    public Long selectNotice(String sourceId) {
        return ((RentNoticeEntity)((Object)((RentNoticeMapper)this.baseMapper).selectOne((Wrapper)new LambdaQueryWrapper().eq(RentNoticeEntity::getInviteId, (Object)sourceId)))).getId();
    }

    @Override
    public boolean selectFile(RentNoticeVO vo) {
        List noticeSupplierEntityList = this.supplierService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"notice_id", (Object)vo.getId())).eq((Object)"dr", (Object)0));
        List rentNoticeSupplierVOS = BeanMapper.mapList((Iterable)noticeSupplierEntityList, RentNoticeSupplierVO.class);
        if (CollectionUtils.isNotEmpty((Collection)rentNoticeSupplierVOS)) {
            List data;
            List attachIds = rentNoticeSupplierVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            HashMap map = new HashMap();
            map.put("sourceIds", attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject((String)JSON.toJSONString(map));
            CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)listCommonResponse.getData()))) {
                Map<Long, List<AttachmentVO>> attacMap = data.stream().collect(Collectors.groupingBy(AttachmentVO::getSourceId));
                for (RentNoticeSupplierVO rentNoticeSupplierVO : rentNoticeSupplierVOS) {
                    List<AttachmentVO> attachmentVOList = attacMap.get(rentNoticeSupplierVO.getId());
                    if (attachmentVOList != null) {
                        ArrayList list = new ArrayList();
                        for (AttachmentVO attachmentVO : attachmentVOList) {
                            HashMap<String, Object> hashMap = new HashMap<String, Object>();
                            hashMap.put("attachId", attachmentVO.getId());
                            hashMap.put("name", attachmentVO.getFileName());
                            list.add(hashMap);
                        }
                        rentNoticeSupplierVO.setFile(list);
                        continue;
                    }
                    rentNoticeSupplierVO.setAttachId(null);
                    rentNoticeSupplierVO.setFileName(null);
                }
            }
            vo.setNoticeSupplierDetail(rentNoticeSupplierVOS);
        }
        return true;
    }
}

