/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.stuff.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.material.api.IMaterialBatchPlanApi;
import com.ejianc.business.promaterial.contract.api.IPromaterialContractApi;
import com.ejianc.business.promaterial.plan.api.IBatPlanApi;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.stuff.bean.StuffInviteDetailBidderEntity;
import com.ejianc.business.tender.stuff.bean.StuffInviteDetailRecordEntity;
import com.ejianc.business.tender.stuff.bean.StuffInviteEntity;
import com.ejianc.business.tender.stuff.bean.StuffPicketageEntity;
import com.ejianc.business.tender.stuff.service.IStuffInviteDetailRecordService;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.stuff.service.IStuffPicketageRefsupplierService;
import com.ejianc.business.tender.stuff.service.IStuffPicketageService;
import com.ejianc.business.tender.stuff.vo.StuffInviteDetailBidderVO;
import com.ejianc.business.tender.stuff.vo.StuffInviteDetailRecordVO;
import com.ejianc.business.tender.stuff.vo.StuffInviteVO;
import com.ejianc.business.tender.stuff.vo.TenderStageEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"stuffInvite"})
public class StuffInviteController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "TENDER_STUFF";
    private static final String CONDITION_PROJECT_ID = "projectId";
    private static final String CONDITION_ORG_ID = "orgId";
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IStuffInviteService service;
    @Autowired
    private IStuffInviteDetailRecordService detailRecordService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IBatPlanApi batPlanApi;
    @Autowired
    private IStuffPicketageService picketageService;
    @Autowired
    private IStuffPicketageRefsupplierService refsupplierService;
    @Autowired
    private IPromaterialContractApi contractApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMaterialBatchPlanApi materialBatchPlanApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<StuffInviteVO> saveOrUpdate(@RequestBody StuffInviteVO saveorUpdateVO) {
        List inviteIdList;
        List planIdList;
        CommonResponse response;
        CommonResponse response2;
        List oldPlanIdList;
        List stuffInviteDetailList = saveorUpdateVO.getStuffDetailRecord();
        ArrayList<StuffInviteDetailBidderEntity> bidderEntityList = new ArrayList<StuffInviteDetailBidderEntity>();
        if (CollectionUtils.isNotEmpty((Collection)stuffInviteDetailList)) {
            for (StuffInviteDetailRecordVO stuffInviteDetailVO : stuffInviteDetailList) {
                List bidderList;
                if (stuffInviteDetailVO.getId() == null) {
                    long id = IdWorker.getId();
                    stuffInviteDetailVO.setId(Long.valueOf(id));
                }
                if (!CollectionUtils.isNotEmpty((Collection)(bidderList = stuffInviteDetailVO.getStuffDetailBidder()))) continue;
                for (StuffInviteDetailBidderVO bidderVO : bidderList) {
                    bidderVO.setInviteDetailId(stuffInviteDetailVO.getId());
                    StuffInviteDetailBidderEntity bidderEntity = (StuffInviteDetailBidderEntity)((Object)BeanMapper.map((Object)bidderVO, StuffInviteDetailBidderEntity.class));
                    bidderEntityList.add(bidderEntity);
                }
            }
        }
        StuffInviteEntity entity = (StuffInviteEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, StuffInviteEntity.class));
        if (CollectionUtils.isNotEmpty(bidderEntityList)) {
            entity.setStuffDetailBidder(bidderEntityList);
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty(oldPlanIdList = this.detailRecordService.list((Wrapper)new LambdaQueryWrapper().eq(StuffInviteDetailRecordEntity::getInviteId, (Object)saveorUpdateVO.getId())).stream().map(StuffInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct().collect(Collectors.toList())) && !(response2 = this.batPlanApi.updateBatPlanQuote(oldPlanIdList, BatPlanEnum.PLAN_STATE_WAIT.getPlanState(), Integer.valueOf(0))).isSuccess()) {
            throw new BusinessException("\u4fee\u6539\u6279\u6b21\u8ba1\u5212\u72b6\u6001\u5931\u8d25" + response2.getMsg());
        }
        entity.setSignStatus(TenderSignStatusEnum.\u672a\u7b7e\u8ba2.getCode());
        if (entity.getEstablishType() == 0) {
            entity.setTenderMoney(entity.getStuffDetailRecord().stream().map(StuffInviteDetailRecordEntity::getMoneyTax).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        this.service.saveOrUpdate((Object)entity, false);
        StuffInviteVO vo = (StuffInviteVO)BeanMapper.map((Object)((Object)entity), StuffInviteVO.class);
        List stuffInviteDetailVOList = vo.getStuffDetailRecord();
        List stuffInviteDetailBidderVOList = vo.getStuffDetailBidder();
        if (CollectionUtils.isNotEmpty((Collection)stuffInviteDetailBidderVOList)) {
            Map<Long, List<StuffInviteDetailBidderVO>> bidderMap = stuffInviteDetailBidderVOList.stream().collect(Collectors.groupingBy(StuffInviteDetailBidderVO::getInviteDetailId));
            if (CollectionUtils.isNotEmpty((Collection)stuffInviteDetailVOList)) {
                for (StuffInviteDetailRecordVO stuffInviteDetailVO : stuffInviteDetailVOList) {
                    List<StuffInviteDetailBidderVO> stuffInviteDetailBidderVOS = bidderMap.get(stuffInviteDetailVO.getId());
                    if (!CollectionUtils.isNotEmpty(stuffInviteDetailBidderVOS)) continue;
                    stuffInviteDetailVO.setStuffDetailBidder(stuffInviteDetailBidderVOS);
                }
            }
        }
        if (!(response = this.batPlanApi.updateBatPlanQuote(planIdList = entity.getStuffDetailRecord().stream().map(StuffInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct().collect(Collectors.toList()), BatPlanEnum.PLAN_STATE_EXEC.getPlanState(), Integer.valueOf(0))).isSuccess()) {
            throw new BusinessException("\u4fee\u6539\u6279\u6b21\u8ba1\u5212\u72b6\u6001\u5931\u8d25" + response.getMsg());
        }
        if (entity.getEstablishType() == 1 && CollectionUtils.isNotEmpty(inviteIdList = entity.getStuffDetailRecord().stream().map(StuffInviteDetailRecordEntity::getPlanId).distinct().collect(Collectors.toList()))) {
            UpdateWrapper wrapper = new UpdateWrapper();
            ((UpdateWrapper)wrapper.set((Object)"occupy_state", (Object)1)).in((Object)"id", inviteIdList);
            this.service.update((Wrapper)wrapper);
        }
        if (!this.processService.selectByBillId(entity.getId())) {
            ProcessEntity processEntity = new ProcessEntity();
            processEntity.setBillId(entity.getId());
            if (vo.getEstablishType() == 1) {
                processEntity.setBillName("\u5b9a\u6807\u7acb\u9879");
            } else {
                processEntity.setBillName("\u62db\u6807\u7acb\u9879");
            }
            processEntity.setTenderId(entity.getId());
            processEntity.setType(0);
            processEntity.setFrontendUrl("stuff/invite/card");
            this.processService.saveOrUpdate((Object)processEntity);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<StuffInviteVO> queryDetail(Long id) {
        StuffInviteEntity entity = (StuffInviteEntity)((Object)this.service.selectById(id));
        StuffInviteVO vo = (StuffInviteVO)BeanMapper.map((Object)((Object)entity), StuffInviteVO.class);
        List stuffInviteDetailVOList = vo.getStuffDetailRecord();
        List stuffInviteDetailBidderVOList = vo.getStuffDetailBidder();
        if (CollectionUtils.isNotEmpty((Collection)stuffInviteDetailBidderVOList)) {
            Map<Long, List<StuffInviteDetailBidderVO>> bidderMap = stuffInviteDetailBidderVOList.stream().collect(Collectors.groupingBy(StuffInviteDetailBidderVO::getInviteDetailId));
            if (CollectionUtils.isNotEmpty((Collection)stuffInviteDetailVOList)) {
                for (StuffInviteDetailRecordVO stuffInviteDetailVO : stuffInviteDetailVOList) {
                    List<StuffInviteDetailBidderVO> stuffInviteDetailBidderVOS = bidderMap.get(stuffInviteDetailVO.getId());
                    if (!CollectionUtils.isNotEmpty(stuffInviteDetailBidderVOS)) continue;
                    stuffInviteDetailVO.setStuffDetailBidder(stuffInviteDetailBidderVOS);
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StuffInviteVO> vos) {
        List idList = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        for (Long inviteId : idList) {
            List inviteIdList;
            StuffInviteEntity inviteEntity = (StuffInviteEntity)((Object)this.service.selectById(inviteId));
            List planIdList = this.detailRecordService.list((Wrapper)new LambdaQueryWrapper().eq(StuffInviteDetailRecordEntity::getInviteId, (Object)inviteId)).stream().map(StuffInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct().collect(Collectors.toList());
            CommonResponse response = this.batPlanApi.updateBatPlanQuote(planIdList, BatPlanEnum.PLAN_STATE_WAIT.getPlanState(), Integer.valueOf(0));
            if (!response.isSuccess()) {
                throw new BusinessException("\u4fee\u6539\u6279\u6b21\u8ba1\u5212\u72b6\u6001\u5931\u8d25" + response.getMsg());
            }
            if (inviteEntity.getEstablishType() != 1 || !CollectionUtils.isNotEmpty(inviteIdList = this.detailRecordService.list((Wrapper)new LambdaQueryWrapper().eq(StuffInviteDetailRecordEntity::getInviteId, (Object)inviteId)).stream().map(StuffInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct().collect(Collectors.toList()))) continue;
            UpdateWrapper wrapper = new UpdateWrapper();
            ((UpdateWrapper)wrapper.set((Object)"occupy_state", (Object)0)).in((Object)"id", inviteIdList);
            this.service.update((Wrapper)wrapper);
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        this.processService.remove((Wrapper)new LambdaQueryWrapper().in(ProcessEntity::getBillId, (Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList())));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<StuffInviteVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("tenderName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("purchaseTypeName");
        fuzzyFields.add("tenderStage");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter isMyOrder = (Parameter)param.getParams().get("isMyOrder");
        if (null != isMyOrder && isMyOrder.getValue().toString().contains("0") && isMyOrder.getValue().toString().contains("1")) {
            param.getParams().remove("employeeId");
        } else if (null != isMyOrder && isMyOrder.getValue().toString().contains("0")) {
            param.getParams().put("employeeId", new Parameter("eq", (Object)Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        } else if (null != isMyOrder && isMyOrder.getValue().toString().contains("1")) {
            param.getParams().put("employeeId", new Parameter("ne", (Object)Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        }
        param.getParams().remove("isMyOrder");
        param.getParams().put(CONDITION_ORG_ID, new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), StuffInviteVO.class));
        for (StuffInviteVO record : pageData.getRecords()) {
            if (record.getTenderType() != null) {
                switch (record.getTenderType()) {
                    case 0: {
                        record.setTenderTypeName("\u5e73\u53f0\u516c\u5f00\u62db\u6807");
                        break;
                    }
                    case 1: {
                        record.setTenderTypeName("\u9080\u8bf7\u62db\u6807");
                        break;
                    }
                    case 2: {
                        record.setTenderTypeName("\u8be2\u4ef7");
                        break;
                    }
                    case 3: {
                        record.setTenderTypeName("\u7ade\u4e89\u6027\u8c08\u5224");
                        break;
                    }
                    case 4: {
                        record.setTenderTypeName("\u5355\u4e00\u6765\u6e90");
                        break;
                    }
                    case 5: {
                        record.setTenderTypeName("\u7d27\u6025\u62db\u6807");
                    }
                }
                switch (record.getSignStatus()) {
                    case 0: {
                        record.setSignStatusName("\u672a\u7b7e\u8ba2");
                        break;
                    }
                    case 1: {
                        record.setSignStatusName("\u90e8\u5206\u7b7e\u8ba2");
                        break;
                    }
                    case 2: {
                        record.setSignStatusName("\u5168\u90e8\u5df2\u7b7e");
                        break;
                    }
                    case 3: {
                        record.setSignStatusName("\u5df2\u5173\u95ed");
                    }
                }
            }
            record.setEstablishTypeName(record.getEstablishType() == 0 ? "\u62db\u6807\u7acb\u9879" : "\u5b9a\u6807\u7acb\u9879");
            record.setPurchaseTypeName(record.getPurchaseType() == 0 ? "\u9879\u76ee\u91c7\u8d2d" : "\u5355\u4f4d\u91c7\u8d2d");
            record.setTenderStageName(TenderStageEnum.getEnumByStateCode((Integer)record.getTenderStage()).getDescription());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        fuzzyFields.add("tenderName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("employeeName");
        param.getParams().put(CONDITION_ORG_ID, new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List voList = JSON.parseArray((String)JSON.toJSONString((Object)list), StuffInviteVO.class);
        for (StuffInviteVO stuffInviteVO : voList) {
            switch (stuffInviteVO.getTenderType()) {
                case 0: {
                    stuffInviteVO.setTenderTypeName("\u5e73\u53f0\u516c\u5f00\u62db\u6807");
                    break;
                }
                case 1: {
                    stuffInviteVO.setTenderTypeName("\u9080\u8bf7\u62db\u6807");
                    break;
                }
                case 2: {
                    stuffInviteVO.setTenderTypeName("\u8be2\u4ef7");
                    break;
                }
                case 3: {
                    stuffInviteVO.setTenderTypeName("\u7ade\u4e89\u6027\u8c08\u5224");
                    break;
                }
                case 4: {
                    stuffInviteVO.setTenderTypeName("\u5355\u4e00\u6765\u6e90");
                    break;
                }
                case 5: {
                    stuffInviteVO.setTenderTypeName("\u7d27\u6025\u62db\u6807");
                }
            }
            stuffInviteVO.setEstablishTypeName(stuffInviteVO.getEstablishType() == 0 ? "\u62db\u6807\u7acb\u9879" : "\u5b9a\u6807\u7acb\u9879");
            stuffInviteVO.setPurchaseTypeName(stuffInviteVO.getPurchaseType() == 0 ? "\u9879\u76ee\u91c7\u8d2d" : "\u5355\u4f4d\u91c7\u8d2d");
            stuffInviteVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)stuffInviteVO.getBillState()).getDescription());
            stuffInviteVO.setTenderStageName(TenderStageEnum.getEnumByStateCode((Integer)stuffInviteVO.getTenderStage()).getDescription());
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("\u6750\u6599\u7acb\u9879.xlsx", beans, response);
    }

    @RequestMapping(value={"/refStuffInviteData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<StuffInviteVO>> refStuffInviteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("tenderPlatform", new Parameter("eq", (Object)2));
        param.getParams().put("occupyState", new Parameter("eq", (Object)0));
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("tenderName");
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)CONDITION_PROJECT_ID)) {
                Long projectId = Long.parseLong(_con.get((Object)CONDITION_PROJECT_ID).toString());
                CommonResponse projectResponse = this.projectPoolApi.queryProjectIdsByParentProjectId(projectId);
                if (!projectResponse.isSuccess()) {
                    throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
                }
                param.getParams().put(CONDITION_PROJECT_ID, new Parameter("in", projectResponse.getData()));
            }
            if (_con.containsKey((Object)CONDITION_ORG_ID)) {
                Long orgId = Long.valueOf(_con.get((Object)CONDITION_ORG_ID).toString());
                CommonResponse orgResp = this.iOrgApi.getOneById(orgId);
                OrgVO orgVO = (OrgVO)orgResp.getData();
                if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgVO.getOrgType())) {
                    param.getParams().put(CONDITION_ORG_ID, new Parameter("eq", (Object)orgId));
                } else {
                    param.getParams().put(CONDITION_ORG_ID, new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                }
            }
            if (_con.containsKey((Object)"purchaseType")) {
                Integer purchaseType = _con.getInteger("purchaseType");
                param.getParams().put("purchaseType", new Parameter("eq", (Object)purchaseType));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), StuffInviteVO.class));
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List stuffInviteVOList = pageData.getRecords();
            List idList = stuffInviteVOList.stream().map(BaseVO::getId).map(String::valueOf).collect(Collectors.toList());
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("inviteId", new Parameter("in", idList));
            List detailEntityList = this.detailRecordService.queryList(detailParam);
            List detailVOList = BeanMapper.mapList((Iterable)detailEntityList, StuffInviteDetailRecordVO.class);
            HashMap detailMap = new HashMap();
            for (StuffInviteDetailRecordVO vo : detailVOList) {
                if (detailMap.containsKey(vo.getInviteId())) {
                    ((List)detailMap.get(vo.getInviteId())).add(vo);
                    continue;
                }
                ArrayList<StuffInviteDetailRecordVO> mapList = new ArrayList<StuffInviteDetailRecordVO>();
                mapList.add(vo);
                detailMap.put(vo.getInviteId(), mapList);
            }
            stuffInviteVOList.forEach(t -> t.setStuffDetailRecord((List)detailMap.get(t.getId())));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getAType"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, Object>> getAType(Long tenderId) {
        Map<String, Object> map = this.service.getAbolishType(tenderId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6d41/\u5e9f\u6807\u72b6\u6001\u6210\u529f\uff01", map);
    }

    @RequestMapping(value={"/detailExcelExport"}, method={RequestMethod.GET})
    @ResponseBody
    public void detailExcelExport(Long id, HttpServletResponse response) {
        StuffInviteVO stuffInviteVO = (StuffInviteVO)this.queryDetail(id).getData();
        List detailList = stuffInviteVO.getStuffDetailRecord();
        for (StuffInviteDetailRecordVO recordVO : detailList) {
            switch (recordVO.getCalculateType()) {
                case 0: {
                    recordVO.setCalculateTypeName("\u7406\u8ba1");
                    break;
                }
                case 1: {
                    recordVO.setCalculateTypeName("\u8fc7\u78c5");
                    break;
                }
                case 2: {
                    recordVO.setCalculateTypeName("\u70b9\u6570");
                }
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", detailList);
        ExcelExport.getInstance().export("stuffInviteDetail.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryContract"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<SignContractVo>> queryContract(@RequestBody StuffInviteVO inviteVO) {
        Long refId;
        if (inviteVO.getEstablishType() == 0) {
            StuffPicketageEntity picketageEntity = (StuffPicketageEntity)((Object)this.picketageService.list((Wrapper)new QueryWrapper().eq((Object)"invite_id", (Object)inviteVO.getId())).get(0));
            refId = picketageEntity.getId();
        } else {
            refId = inviteVO.getId();
        }
        this.logger.info("\u5b9a\u6807ID" + refId);
        List refsupplierList = this.refsupplierService.list((Wrapper)new QueryWrapper().eq((Object)"picketage_id", (Object)refId));
        List idList = refsupplierList.stream().map(BaseEntity::getId).map(String::valueOf).collect(Collectors.toList());
        this.logger.info("\u5b9a\u6807\u53c2\u7167ID" + JSONObject.toJSONString(idList));
        CommonResponse response = this.contractApi.queryContractByTargetResultId(idList);
        if (!response.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5408\u540c\u5931\u8d25" + response.getMsg());
        }
        ((List)response.getData()).forEach(t -> t.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)t.getBillState()).getDescription()));
        return CommonResponse.success((Object)response.getData());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/closeSignStatus"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse closeSignStatus(Long id) {
        StuffInviteEntity entity = (StuffInviteEntity)((Object)this.service.selectById(id));
        Long refId = null;
        Integer tenderStage = entity.getTenderStage();
        Integer establishType = entity.getEstablishType();
        if (!this.sessionManager.getUserContext().getEmployeeId().equals(entity.getEmployeeId())) throw new BusinessException("\u53ea\u6709\u62db\u6807\u7ecf\u529e\u4eba\u624d\u80fd\u5173\u95ed");
        if (entity.getSignStatus() != 0 && entity.getSignStatus() != 1) throw new BusinessException("\u4e0d\u7b26\u5408\u5173\u95ed\u6761\u4ef6");
        if (establishType == 0) {
            if (tenderStage == 5 || tenderStage == 13 || tenderStage == 14) {
                StuffPicketageEntity picketageEntity = (StuffPicketageEntity)((Object)this.picketageService.list((Wrapper)new QueryWrapper().eq((Object)"invite_id", (Object)id)).get(0));
                refId = picketageEntity.getId();
            }
        } else if (entity.getBillState() == 1 || entity.getBillState() == 3) {
            refId = id;
        }
        if (refId == null) throw new BusinessException("\u4e0d\u7b26\u5408\u5173\u95ed\u6761\u4ef6");
        this.logger.info("\u5b9a\u6807ID" + refId);
        List refsupplierList = this.refsupplierService.list((Wrapper)new QueryWrapper().eq((Object)"picketage_id", (Object)refId));
        if (!CollectionUtils.isNotEmpty((Collection)refsupplierList)) {
            throw new BusinessException("\u4e0d\u7b26\u5408\u5173\u95ed\u6761\u4ef6");
        }
        refsupplierList.forEach(t -> t.setSignStatus(TenderSignStatusEnum.\u5df2\u5173\u95ed.getCode()));
        this.refsupplierService.saveOrUpdateBatch(refsupplierList);
        entity.setSignStatus(TenderSignStatusEnum.\u5df2\u5173\u95ed.getCode());
        this.service.saveOrUpdate((Object)entity);
        return CommonResponse.success((String)"\u5173\u95ed\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/judgeEmployee"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> judgeEmployee(Long inviteId) {
        boolean flag = false;
        StuffInviteEntity entity = (StuffInviteEntity)((Object)this.service.selectById(inviteId));
        if (this.sessionManager.getUserContext().getEmployeeId().equals(entity.getEmployeeId())) {
            flag = true;
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)flag);
    }

    @RequestMapping(value={"/queryHistoryPrice"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialPriceHistoryApiVO>> queryHistoryPrice(@RequestBody Map<String, Object> param) {
        IPage<MaterialPriceHistoryApiVO> vos = this.service.queryHistoryPrice(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f!", vos);
    }
}

