package com.ejianc.business.tender.equipment.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.equipment.bean.EquipmentPicketageRefsupplierEntity;
import com.ejianc.business.tender.equipment.service.IEquipmentPicketageRefsupplierService;
import com.ejianc.business.tender.equipment.service.impl.EquipmentPicketageBpmServiceImpl;
import com.ejianc.business.tender.equipment.vo.EquipmentPicketageRefsupplierVO;
import com.ejianc.business.tender.equipment.bean.*;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentSellVO;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentSellService;
import com.ejianc.business.tender.equipment.service.IEquipmentPicketageService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteDetailBidderService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteDetailRecordService;
import com.ejianc.business.tender.other.bean.OtherPicketageRefsupplierEntity;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 定标供应商参照表(下游单据使用)
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("equipmentPicketageRefsupplier")
@Api(value = "定标供应商参照表(下游单据使用)", tags = {"定标供应商参照表(下游单据使用)"})
public class EquipmentPicketageRefsupplierController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private EquipmentPicketageBpmServiceImpl equipmentPicketageBpmService;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IEquipmentPicketageRefsupplierService service;
    @Autowired
    private IEquipmentPicketageService equipmentPicketageService;
    @Autowired
    private IEquipmentDocumentSellService equipmentDocumentSellService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEquipmentInviteDetailBidderService bidderService;
    @Autowired
    private IEquipmentInviteDetailRecordService recordService;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<EquipmentPicketageRefsupplierVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody EquipmentPicketageRefsupplierVO saveOrUpdateVO) {
    	EquipmentPicketageRefsupplierEntity entity = BeanMapper.map(saveOrUpdateVO, EquipmentPicketageRefsupplierEntity.class);
    	service.saveOrUpdate(entity, false);
    	EquipmentPicketageRefsupplierVO vo = BeanMapper.map(entity, EquipmentPicketageRefsupplierVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EquipmentPicketageRefsupplierVO> queryDetail(@RequestParam Long id) {
    	EquipmentPicketageRefsupplierEntity entity = service.selectById(id);
    	EquipmentPicketageRefsupplierVO vo = BeanMapper.map(entity, EquipmentPicketageRefsupplierVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }



    @ApiOperation("参照")
    @RequestMapping(value = "/refEquipmentsupplierData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<EquipmentPicketageRefsupplierVO>> refEquipmentsupplierData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("picketageName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //未占用状态
//        param.getParams().put("occupyFlag", new Parameter(QueryParam.EQ, 0));
        param.getOrderMap().put("picketageDate",QueryParam.DESC);
        //查询本下范围内日的合同
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        if(CollectionUtils.isNotEmpty(orgVOList)) {
            List<Long> ids = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, ids));
        }
        if(StringUtils.isNotEmpty(condition)){
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("purchaseType")) {
                Integer purchaseType = Integer.parseInt(conditionMap.get("purchaseType").toString());
                param.getParams().put("purchaseType", new Parameter(QueryParam.EQ, purchaseType));
            }
            if(null != conditionMap.get("categoryId")){
                Long categoryId = Long.parseLong(conditionMap.get("categoryId").toString());
                param.getParams().put("categoryId",new Parameter(QueryParam.EQ,categoryId));
            } else{
                //设备采购
                param.getParams().put("categoryId",new Parameter(QueryParam.EQ,Long.parseLong("1627870218070003713")));
            }
        }
        List<Integer> listStatus = new ArrayList<>();
        listStatus.add(TenderSignStatusEnum.未签订.getCode());
        listStatus.add(TenderSignStatusEnum.部分签订.getCode());

        param.getParams().put("signStatus", new Parameter(QueryParam.IN,listStatus));

        IPage<EquipmentPicketageRefsupplierEntity> page = service.queryPage(param,false);
        IPage<EquipmentPicketageRefsupplierVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<EquipmentPicketageRefsupplierEntity> records = page.getRecords();
        if (CollectionUtils.isNotEmpty(records)){
            for (EquipmentPicketageRefsupplierEntity equipmentPicketageRefsupplierEntity : records) {
                if (equipmentPicketageRefsupplierEntity.getPurchaseType() == 0) {
//                    (0-项目采购,1-单位采购)
                    equipmentPicketageRefsupplierEntity.setPurchaseTypeName("项目采购");
                }
                if (equipmentPicketageRefsupplierEntity.getPurchaseType() == 1) {
//                    (0-项目采购,1-单位采购)
                    equipmentPicketageRefsupplierEntity.setPurchaseTypeName("公司采购");
                }

            }
        }
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EquipmentPicketageRefsupplierVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    @ApiOperation("定标子表参照")
    @RequestMapping(value = "/refEquipmentDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<EquipmentDocumentSellVO>> refEquipmentDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Long id = null;

        if (StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("id")) {
                id = Long.valueOf(conditionMap.get("id").toString());
            }
        }
        EquipmentPicketageRefsupplierEntity equipmentPicketageRefsupplierEntity = service.selectById(id);
        Integer picketageFlag = equipmentPicketageRefsupplierEntity.getPicketageFlag();
        //定标类型0-流程定标,1-直接定标  区分数据源
        if (picketageFlag == 0) {
            EquipmentPicketageEntity equipmentPicketageEntity = equipmentPicketageService.selectById(equipmentPicketageRefsupplierEntity.getPicketageId());
            param.getParams().put("documentId", new Parameter(QueryParam.EQ, equipmentPicketageEntity.getDocumentId()));
            param.getParams().put("supplierId", new Parameter(QueryParam.EQ, equipmentPicketageRefsupplierEntity.getSupplierId()));
            param.getParams().put("projectId", new Parameter(QueryParam.EQ, equipmentPicketageRefsupplierEntity.getProjectId()));
            param.getParams().put("tenderFlag", new Parameter(QueryParam.EQ, 1));
            param.getParams().put("nums", new Parameter(QueryParam.SQL, "ifnull(sign_num,0) < tender_num"));
            IPage<EquipmentDocumentSellEntity> page = equipmentDocumentSellService.queryPage(param, false);
            IPage<EquipmentDocumentSellVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            List<EquipmentDocumentSellVO> equipmentDocumentSellVOList = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(page.getRecords())) {
                equipmentDocumentSellVOList = BeanMapper.mapList(page.getRecords(), EquipmentDocumentSellVO.class);
                for (EquipmentDocumentSellVO equipmentDocumentSellVO : equipmentDocumentSellVOList) {
                    BigDecimal tenderNum = equipmentDocumentSellVO.getTenderNum();
                    BigDecimal signNum = equipmentDocumentSellVO.getSignNum() == null ? BigDecimal.ZERO : equipmentDocumentSellVO.getSignNum();
                    equipmentDocumentSellVO.setSurplusNum(tenderNum.subtract(signNum));
                }

            }
            pageData.setRecords(equipmentDocumentSellVOList);
            return CommonResponse.success("查询参照数据成功！", pageData);
        }

        if (picketageFlag == 1) {
            List<EquipmentDocumentSellVO> equipmentDocumentSellVOS = new ArrayList<>();
            List<EquipmentInviteDetailBidderEntity> bidderEntityList1 = bidderService.list(new QueryWrapper<EquipmentInviteDetailBidderEntity>()
                    .eq("invite_id", equipmentPicketageRefsupplierEntity.getPicketageId())
                    .eq("supplier_id", equipmentPicketageRefsupplierEntity.getSupplierId())
                    .eq("dr", 0));
            List<EquipmentInviteDetailBidderEntity> bidderEntityList = bidderEntityList1.stream().filter(t -> t.getNum().compareTo(t.getSignNum() == null ? BigDecimal.ZERO : t.getSignNum()) > 0).collect(Collectors.toList());
            for (EquipmentInviteDetailBidderEntity bidderEntity : bidderEntityList) {
                EquipmentDocumentSellVO equipmentDocumentSellVO = new EquipmentDocumentSellVO();
                EquipmentInviteDetailRecordEntity recordEntity = recordService.selectById(bidderEntity.getInviteDetailId());
                equipmentDocumentSellVO.setId(bidderEntity.getId());
                equipmentDocumentSellVO.setProjectId(recordEntity.getDetailProjectId());
                equipmentDocumentSellVO.setProjectName(recordEntity.getDetailProjectName());
                equipmentDocumentSellVO.setMaterialId(recordEntity.getMaterialId());
                equipmentDocumentSellVO.setMaterialName(recordEntity.getMaterialName());
                equipmentDocumentSellVO.setMaterialCode(recordEntity.getMaterialCode());
                equipmentDocumentSellVO.setMaterialTypeId(recordEntity.getMaterialTypeId());
                equipmentDocumentSellVO.setMaterialTypeName(recordEntity.getMaterialTypeName());
                equipmentDocumentSellVO.setUnit(recordEntity.getUnit());
                equipmentDocumentSellVO.setSpec(recordEntity.getSpec());
                equipmentDocumentSellVO.setDetailId(bidderEntity.getId());
                equipmentDocumentSellVO.setSupplierId(bidderEntity.getSupplierId());
                equipmentDocumentSellVO.setSupplierName(bidderEntity.getSupplierName());
                equipmentDocumentSellVO.setBrand(bidderEntity.getBrand());
                equipmentDocumentSellVO.setPrice(bidderEntity.getPrice());
                equipmentDocumentSellVO.setPriceTax(bidderEntity.getTaxPrice());
                equipmentDocumentSellVO.setRate(bidderEntity.getTaxBidderRate());
                equipmentDocumentSellVO.setTenderNum(bidderEntity.getNum());
                equipmentDocumentSellVO.setTenderMoney(bidderEntity.getMoney());
                equipmentDocumentSellVO.setTenderMoneyTax(bidderEntity.getTaxMoney());
                equipmentDocumentSellVO.setSellTax(bidderEntity.getTaxBidder());
                equipmentDocumentSellVO.setSignNum(bidderEntity.getSignNum() == null ? BigDecimal.ZERO : bidderEntity.getSignNum());
                equipmentDocumentSellVO.setSurplusNum(bidderEntity.getNum().subtract(bidderEntity.getSignNum() == null ? BigDecimal.ZERO : bidderEntity.getSignNum()));
                equipmentDocumentSellVOS.add(equipmentDocumentSellVO);
            }
            IPage<EquipmentDocumentSellVO> pageDate = new Page<>(param.getPageIndex(), param.getPageSize(), equipmentDocumentSellVOS.size());
            // 进行分页处理
            pageDate.setRecords(equipmentDocumentSellVOS.stream().skip((long) (param.getPageIndex() - 1) * param.getPageSize())
                    .limit(param.getPageSize()).collect(Collectors.toList()));
            return CommonResponse.success("查询参照数据成功！", pageDate);
        }
        return null;
    }
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
}
