package com.ejianc.business.tender.equipment.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.equipment.bean.*;
import com.ejianc.business.tender.equipment.mapper.EquipmentBidMapper;
import com.ejianc.business.tender.equipment.service.*;
import com.ejianc.business.tender.equipment.vo.EquipmentBidVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.equipment.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 中标主表
 * 
 * @author generator
 * 
 */
@Service("equipmentBidService")
public class EquipmentBidServiceImpl extends BaseServiceImpl<EquipmentBidMapper, EquipmentBidEntity> implements IEquipmentBidService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IEquipmentPicketageService equipmentPicketageService;
    @Autowired
    private IEquipmentNoticeService equipmentNoticeService;
    @Autowired
    private IEquipmentWinnoticeService equipmentWinnoticeService;
    @Autowired
    private IEquipmentDocumentService equipmentDocumentService;
    @Autowired
    private IEquipmentInviteService equipmentInviteService;
    @Autowired
    private IEquipmentBidDetailService equipmentBidDetailService;
    @Autowired
    private IEquipmentDocumentSellService equipmentDocumentSellService;
    @Autowired
    private IEquipmentBidSupplierService equipmentBidSupplierService;
    @Autowired
    private IEquipmentDocumentSupplierService equipmentDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IEquipmentPicketageSupplierService equipmentPicketageSupplierService;
    @Autowired
    private IOrgApi iOrgApi;
    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;

    @Value("${gysUrl.winbidSavesUrl}")
    private String winbidSavesUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    private org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-bid-code";//此处需要根据实际修改
    @Override
    public EquipmentBidVO saveBid(Long picketageId) {
        EquipmentBidEntity entity = new EquipmentBidEntity();
        entity.setPicketageId(picketageId);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        EquipmentPicketageEntity equipmentPicketageEntity = equipmentPicketageService.selectById(picketageId);
        EquipmentInviteEntity inviteEntity = equipmentInviteService.selectById(equipmentPicketageEntity.getInviteId());
        entity.setInviteId(equipmentPicketageEntity.getInviteId());
        entity.setBidName(inviteEntity.getTenderName());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        super.saveOrUpdate(entity, false);
        EquipmentBidVO vo = BeanMapper.map(entity, EquipmentBidVO.class);

        //回写定标数据
//        equipmentPicketageEntity.setBidStatus(1);
        equipmentPicketageEntity.setBidId(entity.getId());
        equipmentPicketageService.updateById(equipmentPicketageEntity);

        //处理供应商信息
        //获取材料明细报价
        LambdaQueryWrapper<EquipmentDocumentSellEntity> lambdaSell = Wrappers.<EquipmentDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(EquipmentDocumentSellEntity::getDocumentId, equipmentPicketageEntity.getDocumentId());
        lambdaSell.eq(EquipmentDocumentSellEntity::getTenderFlag, 1);
        List<EquipmentDocumentSellEntity> sellList = equipmentDocumentSellService.list(lambdaSell);
        List<EquipmentDocumentSellVO> equipmentDocumentSellVOS = BeanMapper.mapList(sellList, EquipmentDocumentSellVO.class);
        Map<Long, List<EquipmentDocumentSellVO>> sellMap = equipmentDocumentSellVOS.stream().
                collect(Collectors.groupingBy(EquipmentDocumentSellVO::getSupplierId));

        //查看供应商信息
        LambdaQueryWrapper<EquipmentDocumentSupplierEntity> lambdaSupplier = Wrappers.<EquipmentDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(EquipmentDocumentSupplierEntity::getDocumentId, equipmentPicketageEntity.getDocumentId());
        lambdaSupplier.eq(EquipmentDocumentSupplierEntity::getTalkNum, 0);
        List<EquipmentDocumentSupplierEntity> supplierList = equipmentDocumentSupplierService.list(lambdaSupplier);
        Map<Long, EquipmentDocumentSupplierEntity> supplierEntityMap = supplierList.stream().collect(Collectors.toMap(EquipmentDocumentSupplierEntity::getSupplierId, Function.identity()));

        //遍历map,组合数据返回
        ArrayList<EquipmentBidSupplierVO> supplierVOList = new ArrayList<>();
        List<EquipmentBidDetailEntity> equipmentBidDetailEntityList = new ArrayList<>();
        sellMap.forEach((key,value) -> {
            EquipmentBidSupplierVO equipmentBidSupplierVO = new EquipmentBidSupplierVO();
            equipmentBidSupplierVO.setSupplierId(key);
            equipmentBidSupplierVO.setSupplierName(value.stream().findFirst().get().getSupplierName());
            EquipmentDocumentSupplierEntity equipmentDocumentSupplierEntity = supplierEntityMap.get(key);
            equipmentBidSupplierVO.setLinkName(equipmentDocumentSupplierEntity.getLinkName());
            equipmentBidSupplierVO.setSupplierMobile(equipmentDocumentSupplierEntity.getLinkMobile());
            equipmentBidSupplierVO.setId(IdWorker.getId());

            //汇总中标金额
            BigDecimal tenderMoneyTax = BigDecimal.ZERO;
            BigDecimal tenderMoney = BigDecimal.ZERO;

            for (EquipmentDocumentSellVO equipmentDocumentSellVO : value) {
                //汇总金额
                tenderMoneyTax = tenderMoneyTax
                        .add(equipmentDocumentSellVO.getTenderMoneyTax() == null ? BigDecimal.ZERO : equipmentDocumentSellVO
                                .getTenderMoneyTax());
                tenderMoney = tenderMoney
                        .add(equipmentDocumentSellVO.getTenderMoney() == null ? BigDecimal.ZERO : equipmentDocumentSellVO
                                .getTenderMoney());
                EquipmentBidDetailEntity equipmentBidDetailEntity = BeanMapper.map(equipmentDocumentSellVO, EquipmentBidDetailEntity.class);
                equipmentBidDetailEntity.setMoney(equipmentDocumentSellVO.getTenderMoney());
                equipmentBidDetailEntity.setMoneyTax(equipmentDocumentSellVO.getTenderMoneyTax());
                equipmentBidDetailEntity.setId(null);
                equipmentBidDetailEntity.setBidSupplierId(equipmentBidSupplierVO.getId());
                equipmentBidDetailEntity.setBidId(entity.getId());
                equipmentBidDetailEntityList.add(equipmentBidDetailEntity);

            }
            equipmentBidSupplierVO.setMoneyTax(tenderMoneyTax);
            equipmentBidSupplierVO.setMoney(tenderMoney);
            equipmentBidSupplierVO.setBidId(entity.getId());
            supplierVOList.add(equipmentBidSupplierVO);
        });

        //新增供应商
        List<EquipmentBidSupplierEntity> equipmentBidSupplierEntities = BeanMapper.mapList(supplierVOList, EquipmentBidSupplierEntity.class);
        equipmentBidSupplierService.saveBatch(equipmentBidSupplierEntities);
        equipmentBidDetailService.saveBatch(equipmentBidDetailEntityList);

        //回写中标供应商和数量
        String tenderUnitNum = "";
        //查询中标供应商
        List<EquipmentBidDetailEntity> bidDetailEntityList = baseMapper.selectBidSupplier(entity.getId());
        for (EquipmentBidDetailEntity equipmentBidDetailEntity : bidDetailEntityList) {
            EquipmentBidSupplierEntity supplierEntity = equipmentBidSupplierService.selectById(equipmentBidDetailEntity.getBidSupplierId());
            BigDecimal sumNum = equipmentBidDetailEntity.getTenderNum().setScale(4,BigDecimal.ROUND_HALF_UP);
            String name = supplierEntity.getSupplierName()+"("+sumNum+"),";
            tenderUnitNum += name;
        }
        if (tenderUnitNum.length() > 1) {
            tenderUnitNum = tenderUnitNum.substring(0,tenderUnitNum.length() -1);
        }
        inviteEntity.setTenderUnitNum(tenderUnitNum);
        equipmentInviteService.saveOrUpdate(inviteEntity);

        EquipmentBidVO equipmentBidVO = BeanMapper.map(entity, EquipmentBidVO.class);
        return equipmentBidVO;
    }

    @Override
    public EquipmentBidVO queryDetail(Long bidId) {
        EquipmentBidEntity equipmentBidEntity = super.selectById(bidId);
        EquipmentBidVO equipmentBidVO = BeanMapper.map(equipmentBidEntity, EquipmentBidVO.class);
        //组合数据
        List<EquipmentBidDetailVO> equipmentBidDetailList  = equipmentBidVO.getEquipmentBidDetailList();
        Map<Long, List<EquipmentBidDetailVO>> detailMap = equipmentBidDetailList.stream().
                collect(Collectors.groupingBy(EquipmentBidDetailVO::getBidSupplierId));
        List<EquipmentBidSupplierVO> equipmentBidSupplierList = equipmentBidVO.getEquipmentBidSupplierList();
        for (EquipmentBidSupplierVO equipmentBidSupplierVO : equipmentBidSupplierList){
            equipmentBidSupplierVO.setEquipmentBidDetailList(detailMap.get(equipmentBidSupplierVO.getId()));
        }
        equipmentBidVO.setEquipmentBidSupplierList(equipmentBidSupplierList);
        return equipmentBidVO;
//
    }
    @Transactional
    @Override
    public EquipmentBidVO publishBid(EquipmentBidVO saveorUpdateVO) {
        EquipmentBidEntity entity = super.selectById(saveorUpdateVO.getId());
        entity.setBidContent(saveorUpdateVO.getBidContent());
        entity.setBidName(saveorUpdateVO.getBidName());
        entity.setPublishFlag(0);
        entity.setBillState(1);
        EquipmentBidVO vo = BeanMapper.map(entity, EquipmentBidVO.class);


        //获取中标信息
        EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(entity.getInviteId());
        EquipmentWinbidVO winbidVO = new EquipmentWinbidVO();
        winbidVO.setSourceId(Long.toString(entity.getInviteId()));
        winbidVO.setBillCode(equipmentInviteEntity.getBillCode());
        if (winbidVO.getPurchaseType()==null || winbidVO.getPurchaseType()==1){
            winbidVO.setSourceProjectId(null);
        }else {
            winbidVO.setSourceProjectId(Long.toString(equipmentInviteEntity.getProjectId()));
        }
        winbidVO.setProjectName(equipmentInviteEntity.getProjectName());
        winbidVO.setProjectCode(equipmentInviteEntity.getProjectCode());
        winbidVO.setSourceOrgId(Long.toString(equipmentInviteEntity.getOrgId()));
        winbidVO.setOrgName(equipmentInviteEntity.getOrgName());
        winbidVO.setUnitName(equipmentInviteEntity.getUnitName());
        winbidVO.setSourceUnitId(Long.toString(equipmentInviteEntity.getUnitId()));
        winbidVO.setType("PURCHASE");
        winbidVO.setTenderName(equipmentInviteEntity.getTenderName());
        winbidVO.setTenderType(equipmentInviteEntity.getTenderType());
        winbidVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());

        LambdaQueryWrapper<EquipmentDocumentEntity> lambdaDoc = Wrappers.<EquipmentDocumentEntity>lambdaQuery();
        lambdaDoc.eq(EquipmentDocumentEntity::getInviteId, entity.getInviteId());
        EquipmentDocumentEntity equipmentDocumentEntity = equipmentDocumentService.getOne(lambdaDoc);
        winbidVO.setNoticeBidTime(equipmentDocumentEntity.getBidTime());
        winbidVO.setNoticeWinbidTime(new Date());

        if (equipmentInviteEntity.getTenderType()==2 || equipmentInviteEntity.getTenderType()==3 ||equipmentInviteEntity.getTenderType()==4 ||equipmentInviteEntity.getTenderType()==5){
            winbidVO.setSourceEmployeeId(Long.toString(equipmentDocumentEntity.getEmployeeId()));
            winbidVO.setEmployeeName(equipmentDocumentEntity.getEmployeeName());
            winbidVO.setEmployeeMobile(equipmentDocumentEntity.getEmployeeMobile());
            winbidVO.setPurchaseType(equipmentDocumentEntity.getPurchaseType());
        }else {
            //查询招标公告
            LambdaQueryWrapper<EquipmentNoticeEntity> lambdaNotice = Wrappers.<EquipmentNoticeEntity>lambdaQuery();
            lambdaNotice.eq(EquipmentNoticeEntity::getInviteId, entity.getInviteId());
            EquipmentNoticeEntity noticeEntity = equipmentNoticeService.getOne(lambdaNotice);
            winbidVO.setSourceEmployeeId(Long.toString(noticeEntity.getEmployeeId()));
            winbidVO.setEmployeeName(noticeEntity.getEmployeeName());
            winbidVO.setEmployeeMobile(noticeEntity.getEmployeeMobile());
            winbidVO.setPurchaseType(noticeEntity.getPurchaseType());
        }

        //处理供应商信息
        EquipmentBidVO equipmentBidVO = queryDetail(entity.getId());
        List<EquipmentBidSupplierVO> equipmentBidSupplierList = equipmentBidVO.getEquipmentBidSupplierList();
        //转换数据,推送供应商中标信息
        List<EquipmentWinbidVO> winbidVOList = new ArrayList<>();
        for (EquipmentBidSupplierVO equipmentBidSupplierVO : equipmentBidSupplierList){
            EquipmentWinbidVO winbidVONew = BeanMapper.map(winbidVO,EquipmentWinbidVO.class);
            SupplierDTO supplierVO = shareSupplierApi.queryById(equipmentBidSupplierVO.getSupplierId()).getData();
            winbidVONew.setTenantId(supplierVO.getTenant());
            winbidVONew.setWinbidMoneyTax(equipmentBidSupplierVO.getMoneyTax());
            winbidVONew.setWinbidMoney(equipmentBidSupplierVO.getMoney());
            winbidVONew.setContent(equipmentBidVO.getBidContent());
            winbidVONew.setWinbidType(0);

            List<EquipmentBidDetailVO> equipmentBidDetailList = equipmentBidSupplierVO.getEquipmentBidDetailList();
            Map<String,List<EquipmentBidDetailVO>> map = new HashMap<>();
            for (EquipmentBidDetailVO equipmentBidDetailVO : equipmentBidDetailList){
                String s = null;
                if (equipmentBidDetailVO.getMaterialId() == null){
                     s = equipmentBidDetailVO.getMaterialTypeId().toString()
                             + equipmentBidDetailVO.getRate() + equipmentBidDetailVO.getSchemeId();
                }
                if (equipmentBidDetailVO.getMaterialId() != null){
                     s = equipmentBidDetailVO.getMaterialId().toString() + equipmentBidDetailVO.getMaterialTypeId().toString()
                             + equipmentBidDetailVO.getRate() + equipmentBidDetailVO.getSchemeId();
                }
                if (map.containsKey(s)){
                    List<EquipmentBidDetailVO> equipmentBidDetailVOS = map.get(s);
                    equipmentBidDetailVOS.add(equipmentBidDetailVO);
                    map.put(s,equipmentBidDetailVOS);
                }else {
                    List<EquipmentBidDetailVO> equipmentBidDetailVOList = new ArrayList<>();
                    equipmentBidDetailVOList.add(equipmentBidDetailVO);
                    map.put(s,equipmentBidDetailVOList);
                }
            }
            //处理中标详情数据
            List<EquipmentWinbidDetailVO> winbidDetailVOList = new ArrayList<>();
            map.forEach((key,value) ->{
                BigDecimal tenderNum = BigDecimal.ZERO;
                BigDecimal money = BigDecimal.ZERO;
                BigDecimal moneyTax = BigDecimal.ZERO;
                BigDecimal tax = BigDecimal.ZERO;
                for (EquipmentBidDetailVO equipmentBidDetailVOLast : value){
                    tenderNum = tenderNum.add((equipmentBidDetailVOLast.getTenderNum() == null) ? BigDecimal.ZERO : equipmentBidDetailVOLast.getTenderNum());
                    money = money.add((equipmentBidDetailVOLast.getMoney() == null) ? BigDecimal.ZERO : equipmentBidDetailVOLast.getMoney());
                    moneyTax = moneyTax.add((equipmentBidDetailVOLast.getMoneyTax() == null) ? BigDecimal.ZERO : equipmentBidDetailVOLast.getMoneyTax());
                    tax = tax.add((equipmentBidDetailVOLast.getSellTax() == null) ? BigDecimal.ZERO : equipmentBidDetailVOLast.getSellTax());
                }
                EquipmentBidDetailVO first = value.stream().findFirst().get();
                EquipmentWinbidDetailVO winbidDetailVO = new EquipmentWinbidDetailVO();
                winbidDetailVO.setSourceId(Long.toString(entity.getInviteId()));
                winbidDetailVO.setSourceMaterialId(Long.toString(first.getMaterialId()));
                winbidDetailVO.setMaterialName(first.getMaterialName());
                winbidDetailVO.setMaterialCode(first.getMaterialCode());
                winbidDetailVO.setSourceMaterialTypeId(Long.toString(first.getMaterialTypeId()));
                winbidDetailVO.setMaterialTypeName(first.getMaterialTypeName());
                winbidDetailVO.setUnit(first.getUnit());
                winbidDetailVO.setSpec(first.getSpec());
                winbidDetailVO.setBrand(first.getMaterialBrand());
                winbidDetailVO.setSupplierBrand(first.getBrand());
                winbidDetailVO.setPrice(first.getPrice());
                winbidDetailVO.setPriceTax(first.getPriceTax());
                winbidDetailVO.setMoney(money);
                winbidDetailVO.setMoneyTax(moneyTax);
                winbidDetailVO.setTax(tax);
                winbidDetailVO.setCalculateType(first.getCalculateType());
                winbidDetailVO.setMemo(first.getMaterialMemo());
                winbidDetailVO.setSupplierMemo(first.getMemo());
                winbidDetailVO.setMoney(money);
                winbidDetailVO.setRate(first.getRate());
                winbidDetailVO.setTenderNum(tenderNum);
                winbidDetailVO.setNum(first.getNum());
                winbidDetailVOList.add(winbidDetailVO);
            });
            winbidVONew.setPurchaseWinbidDetailList(winbidDetailVOList);
            winbidVOList.add(winbidVONew);
        }
        String stringFb = JSONObject.toJSONString(winbidVOList);
        logger.info("推送供方中标信息:" +stringFb);
        //调用供方接口
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(winbidSavesUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("中标同步接口报错" + stringCommonResponse.getMsg());
        }

        return queryDetail(vo.getId());
    }

    @Override
    public EquipmentBidVO queryDbDetail(Long picketage) {

        return null;
    }

    @Override
    public EquipmentBidVO nextPaper(Long winnoticeId) {
        EquipmentBidEntity entity = new EquipmentBidEntity();
        EquipmentWinnoticeEntity equipmentWinnoticeEntity = equipmentWinnoticeService.selectById(winnoticeId);
        EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(equipmentWinnoticeEntity.getInviteId());
        entity.setInviteId(equipmentWinnoticeEntity.getInviteId());
        entity.setBidName(equipmentInviteEntity.getTenderName());
        entity.setPurchaseType(equipmentInviteEntity.getPurchaseType());
        entity.setWinnoticeId(winnoticeId);
        super.saveOrUpdate(entity, false);

        //回写中标公告状态
        equipmentWinnoticeEntity.setNextFlag(1);
        equipmentWinnoticeService.updateById(equipmentWinnoticeEntity);

        //回写招标阶段
        equipmentInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        equipmentInviteService.updateById(equipmentInviteEntity);

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("equipment/winLetter");
        processService.saveOrUpdate(processEntity);

        EquipmentBidVO equipmentBidVO = BeanMapper.map(entity, EquipmentBidVO.class);
        return equipmentBidVO;
    }

    @Override
    public List<EquipmentPicketageSupplierVO> querySupplierList(Long picketageId) {
        EquipmentBidEntity equipmentBidEntity = super.selectById(picketageId);

        EquipmentWinnoticeEntity equipmentWinnoticeEntity = equipmentWinnoticeService.selectById(equipmentBidEntity.getWinnoticeId());
        LambdaQueryWrapper<EquipmentPicketageSupplierEntity> lambdaSupplierList = Wrappers.lambdaQuery();
        lambdaSupplierList.eq(EquipmentPicketageSupplierEntity::getPicketageId,equipmentWinnoticeEntity.getPicketageId());
        List<EquipmentPicketageSupplierEntity> listSupplier = equipmentPicketageSupplierService.list(lambdaSupplierList);
        List<EquipmentPicketageSupplierVO> equipmentPicketageSupplierVOS = BeanMapper.mapList(listSupplier, EquipmentPicketageSupplierVO.class);

        return equipmentPicketageSupplierVOS;
    }
    @Transactional
    @Override
    public EquipmentPicketageVO insertProcess(Long picketageId) {

        EquipmentPicketageEntity equipmentPicketageEntity = equipmentPicketageService.selectById(picketageId);
        EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(equipmentPicketageEntity.getInviteId());
        //回写招标阶段
        equipmentInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        equipmentInviteService.updateById(equipmentInviteEntity);

        //回写定标数据
        equipmentPicketageEntity.setBidStatus(1);
        equipmentPicketageService.updateById(equipmentPicketageEntity);

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(equipmentPicketageEntity.getBidId());
        processEntity.setBillName(TenderStageEnum.BID_NOTICE_STATE.getDescription());
        processEntity.setTenderId(equipmentInviteEntity.getId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("equipment/winLetter");
        processService.saveOrUpdate(processEntity);
        EquipmentPicketageVO equipmentPicketageVO = BeanMapper.map(equipmentPicketageEntity, EquipmentPicketageVO.class);
        return equipmentPicketageVO;
    }

    @Override
    public List<EquipmentPicketageSupplierVO> querySupplierDetail(Long id) {
        EquipmentBidEntity equipmentBidEntity = super.selectById(id);
        return equipmentPicketageService.querySupplierList(equipmentBidEntity.getPicketageId());
    }
}
