package com.ejianc.business.tender.process.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.process.vo.ProcessVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tender.process.mapper.ProcessMapper;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;

import java.util.List;

/**
 * 流程表
 * 
 * @author generator
 * 
 */
@Service("processService")
public class ProcessServiceImpl extends BaseServiceImpl<ProcessMapper, ProcessEntity> implements IProcessService{

    @Override
    public List<ProcessVO> queryProcess(Long tenderId) {
        LambdaQueryWrapper<ProcessEntity> lambdachange = Wrappers.<ProcessEntity>lambdaQuery();
        lambdachange.eq(ProcessEntity::getTenderId,tenderId);
        lambdachange.orderByAsc(ProcessEntity::getCreateTime);
        return BeanMapper.mapList(super.list(lambdachange),ProcessVO.class);
    }

    @Override
    public boolean selectByBillId(Long id) {
        return baseMapper.selectByBillId(id)>0;
    }
}
