package com.ejianc.business.tender.prosub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.prosub.bean.*;
import com.ejianc.business.tender.prosub.mapper.ProsubWinnoticeMapper;
import com.ejianc.business.tender.prosub.service.*;
import com.ejianc.business.tender.prosub.vo.ProsubPicketageSupplierVO;
import com.ejianc.business.tender.prosub.vo.ProsubWinDetailVO;
import com.ejianc.business.tender.prosub.vo.ProsubWinVO;
import com.ejianc.business.tender.prosub.vo.ProsubWinnoticeVO;
import com.ejianc.business.tender.stuff.bean.StuffWinnoticeEntity;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.mapper.SubWinnoticeMapper;
import com.ejianc.business.tender.sub.vo.*;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 中标公告表
 * 
 * @author generator
 * 
 */
@Service("prosubWinnoticeService")
public class ProsubWinnoticeServiceImpl extends BaseServiceImpl<ProsubWinnoticeMapper, ProsubWinnoticeEntity> implements IProsubWinnoticeService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProsubPicketageService subPicketageService;
    @Autowired
    private IProsubNoticeService subNoticeService;
    @Autowired
    private IProsubDocumentService subDocumentService;
    @Autowired
    private IProsubInviteService subInviteService;
    @Autowired
    private IProsubBidDetailService subBidDetailService;
    @Autowired
    private IProsubDocumentSellService subDocumentSellService;
    @Autowired
    private IProsubBidSupplierService subBidSupplierService;
    @Autowired
    private IProsubDocumentSupplierService subDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private CacheManager cacheManager;
    @Value("${gysUrl.winSaveOrUpdateUrl}")
    private String winSaveOrUpdateUrl;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IProsubPicketageSupplierService subPicketageSupplierService;
    private static final String BILL_TYPE = "ZZYJ202302070003";//此处需要根据实际修改
    @Autowired
    private ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Transactional
    @Override
    public ProsubWinnoticeVO saveWinnotice(Long picketageId) {
        ProsubWinnoticeEntity entity = new ProsubWinnoticeEntity();
        entity.setPicketageId(picketageId);
        ProsubPicketageEntity subPicketageEntity = subPicketageService.selectById(picketageId);
        ProsubInviteEntity inviteEntity = subInviteService.selectById(subPicketageEntity.getInviteId());
        entity.setInviteId(subPicketageEntity.getInviteId());
        entity.setTitleName(inviteEntity.getTenderName()+"中标公告");
        entity.setInviteName(inviteEntity.getTenderName());
        entity.setUnitId(inviteEntity.getUnitId());
        entity.setUnitName(inviteEntity.getUnitName());

        //采购方式(0-项目采购,1-单位采购)
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setProjectCode(inviteEntity.getProjectCode());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());

        ProsubDocumentEntity subDocumentEntity = subDocumentService.selectById(subPicketageEntity.getDocumentId());
        entity.setEmployeeId(subDocumentEntity.getEmployeeId());
        entity.setEmployeeName(subDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(subDocumentEntity.getEmployeeMobile());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setSignFlag(0);//签章状态，未签章
        entity.setLineTypeName(CommonUtils.getTypeName(1));
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(inviteEntity.getTenderType()).getDescription());
        super.saveOrUpdate(entity, false);

        //回写定标数据
        subPicketageEntity.setWinnoticeStatus(1);
        subPicketageEntity.setWinnoticeId(entity.getId());
        subPicketageService.updateById(subPicketageEntity);
//回写定标子表数据
        List<ProsubPicketageSupplierEntity> picketageSupplierList = subPicketageEntity.getPicketageSupplierList();
        for (ProsubPicketageSupplierEntity subPicketageSupplierEntity : picketageSupplierList){
            subPicketageSupplierEntity.setWinnoticeId(entity.getId());
        }
        subPicketageSupplierService.updateBatchById(picketageSupplierList);
        //回写招标阶段
        inviteEntity.setTenderStage(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getTenderTypeCode());
        subInviteService.updateById(inviteEntity);

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(CommonUtils.TYPE_PROSUB);
        processEntity.setFrontendUrl("prosub/winnotice");
        processService.saveOrUpdate(processEntity);
        ProsubWinnoticeVO subWinnoticeVO = BeanMapper.map(entity, ProsubWinnoticeVO.class);
        return subWinnoticeVO;
    }

    @Override
    public ProsubWinnoticeVO queryDetail(Long id) {
        ProsubWinnoticeEntity subWinnoticeEntity = super.selectById(id);
        ProsubWinnoticeVO subWinnoticeVO = BeanMapper.map(subWinnoticeEntity, ProsubWinnoticeVO.class);
        ProsubPicketageEntity subPicketageEntity = subPicketageService.selectById(subWinnoticeEntity.getPicketageId());
        List<ProsubPicketageSupplierEntity> picketageSupplierList = subPicketageEntity.getPicketageSupplierList();
        List<ProsubPicketageSupplierVO> subPicketageSupplierList = BeanMapper.mapList(picketageSupplierList, ProsubPicketageSupplierVO.class);
        subWinnoticeVO.setPicketageSupplierList(subPicketageSupplierList);


        //处理签章附件信息
        if (subWinnoticeVO!=null) {
            Long id1 = subWinnoticeVO.getId();
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryListBySourceId(id1, BILL_TYPE, "tenderWinnotice", "");
            if (listCommonResponse.isSuccess()) {
                List<AttachmentVO> data = listCommonResponse.getData();
                if (CollectionUtils.isNotEmpty(data)) {
                    Map<Long, AttachmentVO> attacMap = data.stream().filter(s -> s.getSourceType().equals("tenderWinnotice")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));

                    AttachmentVO attachmentVO = attacMap.get(subWinnoticeVO.getId());
                    if (attachmentVO != null) {
                        subWinnoticeVO.setAttachId(attachmentVO.getId());
                        subWinnoticeVO.setFileName(attachmentVO.getFileName());
                        subWinnoticeVO.setFilePath(attachmentVO.getFilePath());
                    }

                }
            }
        }
        return subWinnoticeVO;
    }

    @Override
    public ProsubWinnoticeVO publishWinnotice(Long id) {
        
        //更新发布状态
        ProsubWinnoticeEntity subWinnoticeEntity = super.selectById(id);
        subWinnoticeEntity.setPublishFlag(0);
        super.updateById(subWinnoticeEntity);

        //回写定标数据
        ProsubPicketageEntity subPicketageEntity = subPicketageService.selectById(subWinnoticeEntity.getPicketageId());
        subPicketageEntity.setWinnoticeStatus(2);
        subPicketageService.updateById(subPicketageEntity);

        ProsubInviteEntity subInviteEntity = subInviteService.selectById(subPicketageEntity.getInviteId());

        //调用供方接口
        //调用第三方报名接口
        //推送供应商
        ProsubWinVO winVO = new ProsubWinVO();
        winVO.setSourceType("郑州一建中标公告");
        winVO.setSourceId(Long.toString(subWinnoticeEntity.getInviteId()));
        winVO.setBillCode(subInviteEntity.getBillCode());
        //采购方式(0-项目采购,1-单位采购)
        if (subInviteEntity.getPurchaseType() == 0){
            winVO.setSourceProjectId(Long.toString(subInviteEntity.getProjectId()));
            winVO.setProjectName(subInviteEntity.getProjectName());
            winVO.setProjectCode(subInviteEntity.getProjectCode());
        }

        if (subInviteEntity.getPurchaseType() == 1){
            winVO.setOrgName(subInviteEntity.getOrgName());
            winVO.setSourceOrgId(Long.toString(subInviteEntity.getOrgId()));

        }
        winVO.setSourceUnitId(Long.toString(subInviteEntity.getUnitId()));
        winVO.setUnitName(subInviteEntity.getUnitName());
        winVO.setType("MATERIAL");
        winVO.setTenderName(subInviteEntity.getTenderName());
        winVO.setTenderType(subInviteEntity.getTenderType());
        winVO.setSourceEmployeeId(Long.toString(subWinnoticeEntity.getEmployeeId()));
        winVO.setEmployeeName(subWinnoticeEntity.getEmployeeName());
        winVO.setEmployeeMobile(subWinnoticeEntity.getEmployeeMobile());
        winVO.setPurchaseType(subInviteEntity.getPurchaseType());
        winVO.setWinDate(subWinnoticeEntity.getWinDate());
        winVO.setWinTitle(subWinnoticeEntity.getTitleName());
        winVO.setStopDate(subWinnoticeEntity.getStopDate());
        winVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());


        //明细设置
        List<ProsubPicketageSupplierEntity> picketageSupplierList = subPicketageEntity.getPicketageSupplierList();
        List<ProsubWinDetailVO> winDetailVOS = new ArrayList<>();
        for (ProsubPicketageSupplierEntity subPicketageSupplierEntity : picketageSupplierList){
            ProsubWinDetailVO subWinDetailVO = new ProsubWinDetailVO();
            subWinDetailVO.setWinId(subWinnoticeEntity.getId());
            subWinDetailVO.setSupplierName(subPicketageSupplierEntity.getSupplierName());
            subWinDetailVO.setTenderFlag(subPicketageSupplierEntity.getTenderFlag());
            SupplierDTO supplierVO = shareSupplierApi.queryById(subPicketageSupplierEntity.getSupplierId()).getData();
            subWinDetailVO.setTenantId(supplierVO.getTenant());
            subWinDetailVO.setMoney(subPicketageSupplierEntity.getMoneyTax());
            winDetailVOS.add(subWinDetailVO);
        }
        winVO.setWinDetailList(winDetailVOS);
        String stringFb = JSONObject.toJSONString(winVO);
        logger.info("中标公告发布" + stringFb);
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(winSaveOrUpdateUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("中标公告同步供方接口报错" + stringCommonResponse.getMsg());
        }
        return queryDetail(id);
    }

    @Override
    public ProsubWinnoticeVO saveOrUpdates(ProsubWinnoticeEntity entity) {
        super.saveOrUpdate(entity,false);
        return queryDetail(entity.getId());
    }

    @Override
    public CommonResponse<String> changeStatus(Long billId, int status, String refCode) {
        //status   发起:3,  甲方-4  已签章
        //签章状态 未签章 -0,待签章-1,已签章-2
        ProsubWinnoticeEntity prosubWinnoticeEntity = super.selectById(billId);
        if(status == 5 || status == 6 || status == 7 || status == 8){
            prosubWinnoticeEntity.setSignFlag(0);
        }
        if(status == 2 || status == 3){
            prosubWinnoticeEntity.setSignFlag(1);
        }
        if(status == 4){
            prosubWinnoticeEntity.setSignFlag(2);
            // 先同步签章附件
            ContractVO cv = new ContractVO();
            cv.setContractId(prosubWinnoticeEntity.getId());
            cv.setContractName(prosubWinnoticeEntity.getTitleName());
            cv.setBillType(BILL_TYPE);
            cv.setSourceType("tenderWinnotice");
            ArrayList<ContractVO> cvs = new ArrayList<>();
            cvs.add(cv);

            CommonResponse<List<SignMgrPreviewVO>> signResp = signatureCommonApi.fetchSignedContract(cvs);
            if(!signResp.isSuccess()){
                throw new BusinessException("同步签章附件失败!");
            }
        }
        super.updateById(prosubWinnoticeEntity);

        return CommonResponse.success("更新成功!");
    }
}
