package com.ejianc.business.tender.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.mapper.ExpertRecordMapper;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rmat.vo.*;
import com.ejianc.business.tender.rmat.bean.*;
import com.ejianc.business.tender.rmat.mapper.RmatDocumentSchemeMapper;
import com.ejianc.business.tender.rmat.mapper.RmatPicketageMapper;
import com.ejianc.business.tender.rmat.service.*;
import com.ejianc.business.tender.stuff.bean.StuffDocumentSellEntity;
import com.ejianc.business.tender.stuff.bean.StuffPicketageEntity;
import com.ejianc.business.tender.stuff.bean.StuffPicketageSupplierEntity;
import com.ejianc.business.tender.stuff.vo.StuffDocumentDetailVO;
import com.ejianc.business.tender.stuff.vo.StuffDocumentSellVO;
import com.ejianc.business.tender.stuff.vo.StuffPicketageVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 定标主表
 * 
 * @author generator
 * 
 */
@Service("rmatPicketageService")
public class RmatPicketageServiceImpl extends BaseServiceImpl<RmatPicketageMapper, RmatPicketageEntity> implements IRmatPicketageService {
    private static final String BILL_CODE = "invite-picketage-code";//此处需要根据实际修改

    @Autowired
    private IExpertEvaluatingService IExpertEvaluatingService;
    @Autowired
    private IRmatInviteService rmatInviteService;
    @Autowired
    private IRmatDocumentService rmatDocumentService;
    @Autowired
    private IRmatDocumentSellService rmatDocumentSellService;
    @Autowired
    private IRmatDocumentSchemeService rmatDocumentSchemeService;
    @Autowired
    private IRmatDocumentSupplierService rmatDocumentSupplierService;
    @Autowired
    private RmatDocumentSchemeMapper schemeMapper;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IRmatTalkService rmatTalkService;
    @Autowired
    private IRmatPicketageSupplierService rmatPicketageSupplierService;
    @Autowired
    private ExpertRecordMapper recordMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    public RmatPicketageVO savePicketage(Long evaluationId) {

        RmatPicketageEntity entity = new RmatPicketageEntity();

        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //转换数据
        ExpertEvaluatingEntity rmatEvaluationEntity = IExpertEvaluatingService.selectById(evaluationId);
        RmatInviteEntity inviteEntity = rmatInviteService.selectById(rmatEvaluationEntity.getInviteId());
        RmatDocumentEntity rmatDocumentEntity = rmatDocumentService.selectById(rmatEvaluationEntity.getDocumentId());
        entity.setPicketageName(inviteEntity.getTenderName()+"定标");
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setEmployeeId(rmatDocumentEntity.getEmployeeId());
        entity.setEmployeeName(rmatDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(rmatDocumentEntity.getEmployeeMobile());
        entity.setValueType(rmatDocumentEntity.getValueType());
        RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(rmatDocumentEntity.getInviteId());
        entity.setPurchaseId(rmatInviteEntity.getPurchaseId());
        entity.setPurchaseName(rmatInviteEntity.getPurchaseName());
        entity.setDocumentId(rmatEvaluationEntity.getDocumentId());
        entity.setEvaluationId(rmatEvaluationEntity.getId());
        entity.setInviteId(rmatEvaluationEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(sessionManager.getUserContext().getEmployeeName());
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        entity.setTrusteesPhone(mobilePhone);
//材料-0,分包-1，设备采购-2,设备租赁-3,周转材租赁-4,其他-5
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(4));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate(entity, false);
        RmatPicketageVO vo = BeanMapper.map(entity, RmatPicketageVO.class);

        //回写招标阶段
        rmatInviteEntity.setTenderStage(5);
        rmatInviteService.updateById(rmatInviteEntity);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("定标");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("rmat/picketage");
        processService.saveOrUpdate(processEntity);

        //回写方案得分
        List<RmatDocumentSchemeEntity> schemeList = schemeMapper.selectSupplier(rmatDocumentEntity.getId());
        for (RmatDocumentSchemeEntity schemeEntity : schemeList) {
            BigDecimal score  = recordMapper.selectScore(schemeEntity.getId(),schemeEntity.getSupplierId(),rmatDocumentEntity.getId());
            Boolean scoreBoolean = schemeMapper.updateScore(schemeEntity.getId(), schemeEntity.getSupplierId(), rmatDocumentEntity.getId(), score);
            if (!scoreBoolean){
                throw new BusinessException("回写方案得分失败!");
            }
        }
        return vo;
    }
    @Transactional
    @Override
    public RmatPicketageVO queryDetail(Long id) {
        RmatPicketageEntity rmatPicketageEntity = super.selectById(id);
        //查询最大轮数
        LambdaQueryWrapper<RmatDocumentSupplierEntity> lambdaSupplier = Wrappers.<RmatDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(RmatDocumentSupplierEntity::getDocumentId, rmatPicketageEntity.getDocumentId());
        List<RmatDocumentSupplierEntity> suppliermatityList = rmatDocumentSupplierService.list(lambdaSupplier);
        List<Integer> talkNumList = suppliermatityList.stream().map(RmatDocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
        Integer talkNumMax = talkNumList.stream().max(Integer::compareTo).get();


        RmatDocumentEntity entity = rmatDocumentService.selectById(rmatPicketageEntity.getDocumentId());
        RmatDocumentVO rmatDocumentVO = BeanMapper.map(entity, RmatDocumentVO.class);
        //按材料查看报价
        List<RmatDocumentDetailVO> rmatDocumentDetailList = rmatDocumentVO.getRmatDocumentDetailList();
        //获取材料明细报价
        LambdaQueryWrapper<RmatDocumentSellEntity> lambdaSell = Wrappers.<RmatDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(RmatDocumentSellEntity::getDocumentId, rmatPicketageEntity.getDocumentId());
        lambdaSell.eq(RmatDocumentSellEntity::getTalkNum, talkNumMax);
        lambdaSell.eq(RmatDocumentSellEntity::getPassFlag, 1);
        lambdaSell.orderByAsc(RmatDocumentSellEntity::getSupplierId);
        lambdaSell.orderByAsc(RmatDocumentSellEntity::getSchemeName);
        List<RmatDocumentSellEntity> sellList = rmatDocumentSellService.list(lambdaSell);
        List<RmatDocumentSellVO> rmatDocumentSellVOS = BeanMapper.mapList(sellList, RmatDocumentSellVO.class);
        //查询所有方案
        LambdaQueryWrapper<RmatDocumentSchemeEntity> lambdaScheme = Wrappers.<RmatDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(RmatDocumentSchemeEntity::getDocumentId, rmatPicketageEntity.getDocumentId());
        lambdaScheme.eq(RmatDocumentSchemeEntity::getTalkNum, talkNumMax);
        lambdaScheme.orderByAsc(RmatDocumentSchemeEntity::getSchemeName);
        List<RmatDocumentSchemeEntity> schemeList = rmatDocumentSchemeService.list(lambdaScheme);
        for (RmatDocumentSchemeEntity rmatDocumentSchemeEntity : schemeList){
            for (RmatDocumentSellVO rmatDocumentSellVO : rmatDocumentSellVOS){
                if (rmatDocumentSellVO.getSchemeId().equals(rmatDocumentSchemeEntity.getId())){
                    rmatDocumentSellVO.setScore(rmatDocumentSchemeEntity.getScore());
                }

            }

        }

        //排序
        RmatDocumentSellVO rmatDocumentSellFirst = rmatDocumentSellVOS.stream().findFirst().get();
        if (rmatDocumentSellFirst.getScore() == null){
            rmatDocumentSellVOS.sort(Comparator.comparing(RmatDocumentSellVO::getCreateTime).reversed());
        }
        if (rmatDocumentSellFirst.getScore() != null){
            rmatDocumentSellVOS.sort(Comparator.comparing(RmatDocumentSellVO::getScore).reversed());
        }
        //根据物料详情主键分组
        Map<Long, List<RmatDocumentSellVO>> sellMap = rmatDocumentSellVOS.stream().
                collect(Collectors.groupingBy(RmatDocumentSellVO::getDetailId));
        for (RmatDocumentDetailVO rmatDocumentDetailVO : rmatDocumentDetailList){
            List<RmatDocumentSellVO> rmatDocumentSellEntities = sellMap.get(rmatDocumentDetailVO.getId());
            rmatDocumentDetailVO.setRmatDocumentSellVOList(rmatDocumentSellEntities);
        }

        RmatPicketageVO rmatPicketageVO = BeanMapper.map(rmatPicketageEntity, RmatPicketageVO.class);
        rmatPicketageVO.setRmatDocumentDetailList(rmatDocumentDetailList);
        if (rmatDocumentSellFirst.getScore() == null) {
            rmatPicketageVO.setScoreStatus(1);
        }
        if (rmatDocumentSellFirst.getScore() != null) {
            rmatPicketageVO.setScoreStatus(0);
        }

        RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(rmatPicketageVO.getInviteId());
        rmatPicketageVO.setRentType(rmatInviteEntity.getRentType());

        return rmatPicketageVO;

    }

    @Override
    public RmatPicketageVO saveOrUpdates(RmatPicketageVO saveorUpdateVO) {
        RmatPicketageEntity entity = BeanMapper.map(saveorUpdateVO, RmatPicketageEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity,false);

        //先删后增供应商定标数据
        LambdaQueryWrapper<RmatPicketageSupplierEntity> lambdaSupplier = Wrappers.<RmatPicketageSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(RmatPicketageSupplierEntity::getPicketageId,entity.getId());
        rmatPicketageSupplierService.remove(lambdaSupplier);
        List<RmatPicketageSupplierVO> picketageSupplierList = saveorUpdateVO.getPicketageSupplierList();
        for(RmatPicketageSupplierVO rmatPicketageSupplierVO : picketageSupplierList){
            rmatPicketageSupplierVO.setTenderFlag(0);
        }
        List<RmatPicketageSupplierEntity> rmatPicketageSupplierList = BeanMapper.mapList(picketageSupplierList, RmatPicketageSupplierEntity.class);
        rmatPicketageSupplierService.saveBatch(rmatPicketageSupplierList);

        //更新中标信息
        List<RmatDocumentDetailVO> rmatDocumentDetailList = saveorUpdateVO.getRmatDocumentDetailList();
        ArrayList<RmatDocumentSellVO> documentSellVOArrayList = new ArrayList<>();
//
        for (RmatDocumentDetailVO rmatDocumentDetailVO : rmatDocumentDetailList){
            documentSellVOArrayList.addAll(rmatDocumentDetailVO.getRmatDocumentSellVOList());
        }
        List<RmatDocumentSellEntity> rmatDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList, RmatDocumentSellEntity.class);
        rmatDocumentSellService.saveOrUpdateBatch(rmatDocumentSellEntityList);
        RmatPicketageVO rmatPicketageVO = queryDetail(saveorUpdateVO.getId());
        return rmatPicketageVO;
    }

    @Override
    public RmatPicketageVO saveManyPicketage(Long documentId) {
        RmatPicketageEntity entity = new RmatPicketageEntity();

        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //更新状态
        RmatDocumentEntity documentEntity = rmatDocumentService.selectById(documentId);
        documentEntity.setNextFlag(0);
        rmatDocumentService.saveOrUpdate(documentEntity);

        //更新洽商谈判状态
        LambdaQueryWrapper<RmatTalkEntity> lambdaTalk = Wrappers.<RmatTalkEntity>lambdaQuery();
        lambdaTalk.eq(RmatTalkEntity::getBillId, documentId);
        RmatTalkEntity rmatTalkEntity = rmatTalkService.getOne(lambdaTalk);
        if (rmatTalkEntity != null){
            rmatTalkEntity.setNextFlag(0);
            rmatTalkService.updateById(rmatTalkEntity);
        }

        //转换数据
        RmatDocumentEntity rmatDocumentEntity = rmatDocumentService.selectById(documentId);
        RmatInviteEntity inviteEntity = rmatInviteService.selectById(rmatDocumentEntity.getInviteId());
        entity.setPicketageName(inviteEntity.getTenderName()+"定标");
        entity.setEmployeeId(rmatDocumentEntity.getEmployeeId());
        entity.setEmployeeName(rmatDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(rmatDocumentEntity.getEmployeeMobile());
        entity.setValueType(rmatDocumentEntity.getValueType());
        RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(rmatDocumentEntity.getInviteId());
        entity.setPurchaseId(rmatInviteEntity.getPurchaseId());
        entity.setPurchaseName(rmatInviteEntity.getPurchaseName());
        entity.setPurchaseType(rmatInviteEntity.getPurchaseType());
        entity.setDocumentId(documentId);
        entity.setInviteId(rmatDocumentEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(sessionManager.getUserContext().getEmployeeName());
        //材料-0,分包-1，设备采购-2,设备租赁-3,周转材租赁-4,其他-5
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(0));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate(entity, false);
        RmatPicketageVO vo = BeanMapper.map(entity, RmatPicketageVO.class);

        //回写招标阶段
        rmatInviteEntity.setTenderStage(5);
        rmatInviteService.updateById(rmatInviteEntity);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("定标");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("rmat/picketage");
        processService.saveOrUpdate(processEntity);
        return vo;
    }

    @Override
    public List<RmatPicketageSupplierVO> querySupplierList(Long picketageId) {
        RmatPicketageEntity rmatPicketageEntity = super.selectById(picketageId);
        List<RmatPicketageSupplierEntity> picketageSupplierList = rmatPicketageEntity.getPicketageSupplierList();
        List<RmatPicketageSupplierVO> list = BeanMapper.mapList(picketageSupplierList, RmatPicketageSupplierVO.class);
        return list;
    }
    @Override
    public RmatPicketageVO saveSupplierBatch(RmatPicketageVO saveorUpdateVO) {
        RmatPicketageEntity rmatPicketageEntity = super.selectById(saveorUpdateVO.getId());
        List<RmatPicketageSupplierEntity> picketageSupplierList = rmatPicketageEntity.getPicketageSupplierList();
        if (CollectionUtils.isNotEmpty(picketageSupplierList)){
            return queryDetail(saveorUpdateVO.getId());
        }
        List<RmatPicketageSupplierEntity> rmatPicketageSupplierEntities = BeanMapper.mapList(saveorUpdateVO.getPicketageSupplierList(), RmatPicketageSupplierEntity.class);
        for (RmatPicketageSupplierEntity rmatPicketageSupplierEntity : rmatPicketageSupplierEntities){
            rmatPicketageSupplierEntity.setTenderFlag(0);
        }
        rmatPicketageSupplierService.saveBatch(rmatPicketageSupplierEntities);

        //更新中标信息
        List<RmatDocumentDetailVO> rmatDocumentDetailList = saveorUpdateVO.getRmatDocumentDetailList();
        ArrayList<RmatDocumentSellVO> documentSellVOArrayList = new ArrayList<>();
//
        for (RmatDocumentDetailVO rmatDocumentDetailVO : rmatDocumentDetailList){
            documentSellVOArrayList.addAll(rmatDocumentDetailVO.getRmatDocumentSellVOList());
        }
        List<RmatDocumentSellEntity> rmatDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList,RmatDocumentSellEntity.class);
        rmatDocumentSellService.saveOrUpdateBatch(rmatDocumentSellEntityList);

        return queryDetail(saveorUpdateVO.getId());
    }

}
