package com.ejianc.business.tender.stuff.service.impl;

import bsh.Primitive;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.tender.buildmaterial.service.ISystemRequestService;
import com.ejianc.business.tender.buildmaterial.vo.DetailBidReplyProductsVO;
import com.ejianc.business.tender.buildmaterial.vo.DetailBidVO;
import com.ejianc.business.tender.buildmaterial.vo.ProductsVO;
import com.ejianc.business.tender.common.vo.SupplyFileVo;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentNoticeEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentNoticeSupplierEntity;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentService;
import com.ejianc.business.tender.equipment.service.IEquipmentNoticeService;
import com.ejianc.business.tender.equipment.service.IEquipmentTalkService;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentSupplierVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentVO;
import com.ejianc.business.tender.equipment.vo.EquipmentTalkVO;
import com.ejianc.business.tender.other.bean.OtherDocumentEntity;
import com.ejianc.business.tender.other.bean.OtherNoticeEntity;
import com.ejianc.business.tender.other.bean.OtherNoticeSupplierEntity;
import com.ejianc.business.tender.other.service.IOtherDocumentService;
import com.ejianc.business.tender.other.service.IOtherNoticeService;
import com.ejianc.business.tender.other.service.IOtherTalkService;
import com.ejianc.business.tender.other.vo.OtherDocumentSupplierVO;
import com.ejianc.business.tender.other.vo.OtherDocumentVO;
import com.ejianc.business.tender.other.vo.OtherTalkVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentEntity;
import com.ejianc.business.tender.prosub.bean.ProsubNoticeEntity;
import com.ejianc.business.tender.prosub.bean.ProsubNoticeSupplierEntity;
import com.ejianc.business.tender.prosub.service.IProsubDocumentService;
import com.ejianc.business.tender.prosub.service.IProsubNoticeService;
import com.ejianc.business.tender.prosub.service.IProsubTalkService;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentSupplierVO;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentVO;
import com.ejianc.business.tender.prosub.vo.ProsubTalkVO;
import com.ejianc.business.tender.rent.bean.RentDocumentEntity;
import com.ejianc.business.tender.rent.bean.RentNoticeEntity;
import com.ejianc.business.tender.rent.bean.RentNoticeSupplierEntity;
import com.ejianc.business.tender.rent.service.IRentDocumentService;
import com.ejianc.business.tender.rent.service.IRentNoticeService;
import com.ejianc.business.tender.rent.service.IRentTalkService;
import com.ejianc.business.tender.rent.vo.RentDocumentSupplierVO;
import com.ejianc.business.tender.rent.vo.RentDocumentVO;
import com.ejianc.business.tender.rent.vo.RentTalkVO;
import com.ejianc.business.tender.rmat.bean.RmatDocumentEntity;
import com.ejianc.business.tender.rmat.bean.RmatNoticeEntity;
import com.ejianc.business.tender.rmat.bean.RmatNoticeSupplierEntity;
import com.ejianc.business.tender.rmat.service.IRmatDocumentService;
import com.ejianc.business.tender.rmat.service.IRmatNoticeService;
import com.ejianc.business.tender.rmat.service.IRmatTalkService;
import com.ejianc.business.tender.rmat.vo.RmatDocumentSupplierVO;
import com.ejianc.business.tender.rmat.vo.RmatDocumentVO;
import com.ejianc.business.tender.rmat.vo.RmatTalkVO;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.stuff.mapper.*;
import com.ejianc.business.tender.stuff.service.*;
import com.ejianc.business.tender.stuff.vo.*;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.service.ISubDocumentService;
import com.ejianc.business.tender.sub.service.ISubNoticeService;
import com.ejianc.business.tender.sub.service.ISubTalkService;
import com.ejianc.business.tender.sub.vo.*;
import com.ejianc.business.tender.util.MathUtil;
import com.ejianc.business.tender.util.SMS;
import com.ejianc.business.tender.util.SendMsgUtils;
import com.ejianc.business.tender.util.ThirdSystemUtils;
import com.ejianc.business.warn.api.IWarningApi;
import com.ejianc.foundation.bulidMaterialMdm.vo.UserVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.http.entity.ContentType;
import org.apache.xmlbeans.impl.piccolo.xml.DocumentEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.awt.print.Book;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 招标文件主表
 *
 * @author generator
 */
@Service("stuffDocumentService")
public class StuffDocumentServiceImpl extends BaseServiceImpl<StuffDocumentMapper, StuffDocumentEntity> implements IStuffDocumentService {
    @Autowired
    private IStuffDocumentSupplierService stuffDocumentSupplierService;
    @Autowired
    private StuffDocumentSupplierDetailMapper supplierDetailMapper;
    @Autowired
    private StuffDocumentSupplierMapper supplierMapper;
    @Autowired
    private IStuffDocumentSchemeService stuffDocumentSchemeService;
    @Autowired
    private IStuffDocumentSellService stuffDocumentSellService;
    @Autowired
    private StuffDocumentSellMapper stuffDocumentSellMapper;
    @Autowired
    private IStuffDocumentRecordService stuffDocumentRecordService;
    @Autowired
    private IStuffDocumentDetailService stuffDocumentDetailService;
    @Autowired
    private IStuffTalkService stuffTalkService;
    @Autowired
    private IStuffTalkRecordService stuffTalkRecordService;
    @Autowired
    private IStuffInviteService stuffInviteService;
    @Autowired
    private StuffNoticeMapper stuffNoticeMapper;
    @Autowired
    private IStuffDocumentExpertService documentExpertService;
    @Autowired
    private IStuffDocumentSupplierDetailService supplierDetailService;
    @Autowired
    private IStuffDocumentSupplierDetailService documentSupplierDetailService;
    @Autowired
    private IStuffDocumentService service;
    @Autowired
    private IProcessService processService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private IStuffNoticeService stuffNoticeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Autowired
    private IStuffCheckService stuffCheckService;
    @Autowired
    private IStuffPicketageSupplierService stuffPicketageSupplierService;

    @Value("${gysUrl.delFileUrl}")
    private String delFileUrl;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Value("${gysUrl.saveWjUrl}")
    private String saveWjUrl;
    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value("${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value("${gysUrl.updateSupStatusUrl}")
    private String updateSupStatusUrl;
    @Value("${gysUrl.addFileUrl}")
    private String addFileUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000004";
    private static final String BILL_TYPE = "BT211119000000003";
    private static final String SOURCE_TYPE = "documentBill02";

    private final Logger logger = LoggerFactory.getLogger(getClass());
    private static final String BILL_CODE = "invite-document-code";//此处需要根据实际修改

    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IStuffNoticeSupplierService stuffNoticeSupplierService;
    @Autowired
    private IProsubNoticeService prosubNoticeService;
    @Autowired
    private IRmatNoticeService rmatNoticeService;
    @Autowired
    private IRentNoticeService rentNoticeService;
    @Autowired
    private IOtherNoticeService otherNoticeService;
    @Autowired
    private IEquipmentNoticeService equipmentNoticeService;
    @Autowired
    private ISubNoticeService subNoticeService;
    @Autowired
    private IProsubDocumentService prosubDocumentService;
    @Autowired
    private IRmatDocumentService rmatDocumentService;
    @Autowired
    private IRentDocumentService rentDocumentService;
    @Autowired
    private IOtherDocumentService otherDocumentService;
    @Autowired
    private IEquipmentDocumentService equipmentDocumentService;
    @Autowired
    private ISubDocumentService subDocumentService;
    @Autowired
    private IProsubTalkService prosubTalkService;
    @Autowired
    private IRmatTalkService rmatTalkService;
    @Autowired
    private IRentTalkService rentTalkService;
    @Autowired
    private IOtherTalkService otherTalkService;
    @Autowired
    private IEquipmentTalkService equipmentTalkService;
    @Autowired
    private ISubTalkService subTalkService;

    @Autowired
    private ISystemRequestService systemRequestService;

    @Transactional
    @Override
    public StuffDocumentVO publishDocument(Long id) {
        //更新发布状态
        StuffDocumentEntity stuffDocumentEntity = super.selectById(id);
        stuffDocumentEntity.setPublishFlag(0);
        super.updateById(stuffDocumentEntity);

        //推送供应商
        StuffDocumentSupplierTbVO stuffDocumentSupplierTbVO = new StuffDocumentSupplierTbVO();
        stuffDocumentSupplierTbVO.setSourceId(stuffDocumentEntity.getInviteId().toString());
        stuffDocumentSupplierTbVO.setSourceType("郑州一建招标文件");
        stuffDocumentSupplierTbVO.setNoticeType(1);
        stuffDocumentSupplierTbVO.setProjectLinkName(stuffDocumentEntity.getProjectLinkName());
        stuffDocumentSupplierTbVO.setProjectLinkPhone(stuffDocumentEntity.getProjectLinkPhone());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(stuffDocumentEntity.getOfferStartTime());
        stuffDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(stuffDocumentEntity.getOfferEndTime());
        stuffDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        stuffDocumentSupplierTbVO.setContent(stuffDocumentEntity.getDocumentContent());
        stuffDocumentSupplierTbVO.setBrandFlag(stuffDocumentEntity.getBrandFlag());
        stuffDocumentSupplierTbVO.setMemo(stuffDocumentEntity.getMemo());
        stuffDocumentSupplierTbVO.setTenderName(stuffDocumentEntity.getDocumentName());
        //stuffDocumentSupplierTbVO.set
        CommonResponse<String> stringCommonResponse = proSupplierApi.getEjcCloudSystemCode();
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("招标文件获取systemId失败" + stringCommonResponse.getMsg());
        }
        stuffDocumentSupplierTbVO.setSystemId(stringCommonResponse.getData());

        //处理附件
        //查询招标文件
        CommonResponse<List<AttachmentVO>> zbwjFile = attachmentApi.queryListBySourceId(stuffDocumentEntity.getId(), BILL_TYPE, SOURCE_TYPE, null);
        String zbwjIds = null;
        List<Long> zbwjAttachIdList = new ArrayList<>();
        if (zbwjFile.isSuccess()) {
            List<AttachmentVO> data = zbwjFile.getData();
            zbwjAttachIdList = data.stream().map(AttachmentVO::getId).collect(Collectors.toList());
            zbwjIds = zbwjAttachIdList.stream().map(p -> String.valueOf(p)).collect(Collectors.joining(","));
        }

        Map<String, String> fileMap = new HashMap<>();
        fileMap.put("fileIds", zbwjIds);
        String zbwjFileByte = null;
        try {
            zbwjFileByte = ReferHttpClientUtils.getAndHeader(BASE_HOST + "ejc-file-web/attachment/batchdownflow", fileMap);
        } catch (GeneralSecurityException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        //招标文件stream处理
        JSONObject jsonZbwj = JSON.parseObject(zbwjFileByte);
        Map<String, String> zbwjParam = JSONObject.parseObject(jsonZbwj.toJSONString(), new TypeReference<Map<String, String>>() {
        });
        String dataZbwj = zbwjParam.get("data");
        JSONObject zbwListJson = JSON.parseObject(dataZbwj);
        Map<String, byte[]> zbwjMap = JSONObject.parseObject(zbwListJson.toJSONString(), new TypeReference<Map<String, byte[]>>() {
        });
        Map<String, InputStream> streamMap = new HashMap<>();
        zbwjMap.forEach((key, value) -> {
            streamMap.put(key, new ByteArrayInputStream(value));
        });

        String stringFb = JSONObject.toJSONString(stuffDocumentSupplierTbVO);
        Map<String, String> params = new HashMap<>();
        params.put("noticeEntity", stringFb);
        Map<String, Map<String, InputStream>> files = null;
        if (!streamMap.isEmpty()) {
            files = new HashMap<>();
            files.put("file", streamMap);
        }

        //推送供方
        CommonResponse<String> stringCommonResponses = systemDataPushService.exchangeDataAndFilesWithUniversal(saveWjUrl, params, files, appId, appSecret, appHost);
        if (!stringCommonResponses.isSuccess()) {
            throw new BusinessException("招标文件发布推送供方接口报错" + stringCommonResponses.getMsg());
        }
//        CommonResponse<String> stringCommonResponses = systemDataPushService.exchangeDataWithUniversal(saveWjUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
//        if(!stringCommonResponses.isSuccess()) {
//            throw new BusinessException("招标文件发布推送供方接口报错" + stringCommonResponses.getMsg());
//        }
//                try {
//
//            String s = new ThirdSystemUtils().postFile(tokenUrl, saveWjUrl, params, headers,zbwjMap,cacheManager);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }

        StuffDocumentVO stuffDocumentVO = queryDetail(id);
        return stuffDocumentVO;
    }


    @Override
    public StuffDocumentVO bidDocument(Long id) {
        //
        //更新开标状态
        StuffDocumentEntity stuffDocumentEntity = super.selectById(id);
        stuffDocumentEntity.setBidFlag(0);
        stuffDocumentEntity.setBidTime(new Date());
        super.updateById(stuffDocumentEntity);
        StuffDocumentVO stuffDocumentVO = queryDetail(id);
//        开标之后给专家发送微信+内部消息通知：xx专家您好，XXX（项目名称）已开标，后续的评标开始时间我们会以短信+消息
        List<StuffDocumentExpertEntity> entityList = documentExpertService.list(new QueryWrapper<StuffDocumentExpertEntity>().eq("document_id", stuffDocumentVO.getId()).eq("dr", 0));
        for (StuffDocumentExpertEntity entity : entityList) {
            //审批通过给专家发内部消息
            List<String> messageType = new ArrayList<>();
            //系统消息
            messageType.add("sys");
            //微信消息
            //messageType.add("weChat");
            List<String> sender = new ArrayList<>();
            sender.add(entity.getExpertId() + "");
            String name = stuffDocumentVO.getPurchaseType() == 0 ? stuffDocumentVO.getProjectName() : stuffDocumentVO.getOrgName();
            logger.info("发送信息给专家:>----------" + sender);
            String subject = entity.getExpertName() + "专家您好，" + name + "已开标，后续的评标开始时间我们会以短信+消息的形式通知您，请注意查看，避免遗忘";
            String content = entity.getExpertName() + "专家您好，" + name + "已开标，后续的评标开始时间我们会以短信+消息的形式通知您，请注意查看，避免遗忘";
            logger.info("发送信息的内容:>----------" + content);
            new SendMsgUtils().sendSysMsg(sender, subject, content, pushMessageApi);
        }

        zcwDetail(stuffDocumentEntity);


        return stuffDocumentVO;
    }

    @Override
    public StuffDocumentVO queryDetail(Long id) {
        return queryDocDetail(id, 0);
    }

    @Override
    public StuffDocumentVO queryDetail1(Long id, Integer num) {
        return queryDocDetail(id, num);
    }

    @Override
    public StuffDocumentVO queryDetailNum(Long id) {
        StuffDocumentSchemeEntity stuffDocumentSchemeEntity = stuffDocumentSchemeService.list(new QueryWrapper<StuffDocumentSchemeEntity>().eq("document_id", id).orderByDesc("talk_num")).get(0);
        return queryDocDetail(id, stuffDocumentSchemeEntity.getTalkNum());
    }

    @Transactional
    @Override
    public Boolean supplierPushSell(HttpServletRequest request, MultipartFile file) {

        logger.info("进入报价接口request-{},file-{}", request, file);
        String notice = request.getParameter("bjNoticeVO");
        logger.info("实体信息-{}", notice);
        SupplierSellVO pushVO = JSON.parseObject(notice, new TypeReference<SupplierSellVO>() {
        });

        //处理业务数据
        //noticeType,类型(0-公告，1-文件,2-询价,3-竞争性,4-洽商谈判
        //转换轮数
        StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(Long.parseLong(pushVO.getSourceId()));
        Integer tenderStage = stuffInviteEntity.getTenderStage();
        //招标阶段(3-招标文件,6-竞争性谈判文件,7-洽商谈判,8-单一来源文件,9-紧急文件,10-询价公告
        Integer talkNum = null;
        if (tenderStage == 3 || tenderStage == 6 || tenderStage == 8 || tenderStage == 9 || tenderStage == 10) {
            talkNum = 0;
        }
        if (tenderStage == 7) {
            //查询轮数
            LambdaQueryWrapper<StuffTalkEntity> lambdaTalk = Wrappers.<StuffTalkEntity>lambdaQuery();
            lambdaTalk.eq(StuffTalkEntity::getInviteId, Long.parseLong(pushVO.getSourceId()));
            StuffTalkEntity stuffTalkEntity = stuffTalkService.getOne(lambdaTalk);
            talkNum = stuffTalkEntity.getTalkNum();
        }

        //转换
        long sourceSupplierId = Long.parseLong(pushVO.getSourceSupplierId());
        SupplierDTO supplierVO = shareSupplierApi.queryById(sourceSupplierId).getData();

        //处理供应商信息
        Long inviteId = Long.parseLong(pushVO.getSourceId());
        LambdaQueryWrapper<StuffDocumentEntity> lambdaDocument = Wrappers.<StuffDocumentEntity>lambdaQuery();
        lambdaDocument.eq(StuffDocumentEntity::getInviteId, inviteId);
        StuffDocumentEntity stuffDocumentEntity = baseMapper.selectOne(lambdaDocument);
        //先删后增
        //根据供应商主键和招标文件主键查询供应商信息,判断新增和修改
        LambdaQueryWrapper<StuffDocumentSupplierEntity> lambdaSupplier = Wrappers.<StuffDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(StuffDocumentSupplierEntity::getSupplierId, sourceSupplierId);
        lambdaSupplier.eq(StuffDocumentSupplierEntity::getDocumentId, stuffDocumentEntity.getId());
        lambdaSupplier.eq(StuffDocumentSupplierEntity::getTalkNum, talkNum);
        StuffDocumentSupplierEntity stuffDocumentSupplierEntity = stuffDocumentSupplierService.getOne(lambdaSupplier);

        Long documentSupplierId = null;
        if (stuffDocumentSupplierEntity != null) {
            //更新供应商信息
            stuffDocumentSupplierEntity.setOfferTime(new Date());
            stuffDocumentSupplierEntity.setLinkName(pushVO.getEmployeeName());
            stuffDocumentSupplierEntity.setLinkMobile(pushVO.getEmployeeMobile());
            stuffDocumentSupplierEntity.setTaxMemo(pushVO.getInvoiceNote());
            stuffDocumentSupplierService.updateById(stuffDocumentSupplierEntity);
            documentSupplierId = stuffDocumentSupplierEntity.getId();

            //删除方案信息
            LambdaQueryWrapper<StuffDocumentSchemeEntity> lambdaScheme = Wrappers.<StuffDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(StuffDocumentSchemeEntity::getDocumentSupplierId, stuffDocumentSupplierEntity.getId());
            stuffDocumentSchemeService.remove(lambdaScheme);
        }
        if (stuffDocumentSupplierEntity == null) {
            //新增供应商信息
            StuffDocumentSupplierEntity stuffDocumentSupplierEntityAdd = new StuffDocumentSupplierEntity();
            stuffDocumentSupplierEntityAdd.setSupplierName(supplierVO.getName());
            stuffDocumentSupplierEntityAdd.setSupplierId(sourceSupplierId);
            stuffDocumentSupplierEntityAdd.setSupplierTenantId(supplierVO.getTenant());
            stuffDocumentSupplierEntityAdd.setLinkName(pushVO.getEmployeeName());
            stuffDocumentSupplierEntityAdd.setLinkMobile(pushVO.getEmployeeMobile());
            stuffDocumentSupplierEntityAdd.setTaxMemo(pushVO.getInvoiceNote());
            stuffDocumentSupplierEntityAdd.setOfferTime(new Date());
            stuffDocumentSupplierEntityAdd.setDocumentId(stuffDocumentEntity.getId());
            stuffDocumentSupplierEntityAdd.setTalkNum(talkNum);
            stuffDocumentSupplierService.save(stuffDocumentSupplierEntityAdd);
            documentSupplierId = stuffDocumentSupplierEntityAdd.getId();
        }

        //处理方案信息
        List<SupplierSellSchemeVO> schemeList = pushVO.getSchemeList();
        List<StuffDocumentSchemeEntity> stuffDocumentSchemeEntityArrayList = new ArrayList<>();
        //所有报价详情信息
        List<StuffDocumentSellVO> stuffDocumentSellVOList = new ArrayList<>();
        for (SupplierSellSchemeVO supplierSellSchemeVO : schemeList) {
            StuffDocumentSchemeEntity stuffDocumentSchemeEntity = new StuffDocumentSchemeEntity();
            stuffDocumentSchemeEntity.setDocumentSupplierId(documentSupplierId);
            stuffDocumentSchemeEntity.setDocumentId(stuffDocumentEntity.getId());
            stuffDocumentSchemeEntity.setSupplierId(sourceSupplierId);
            stuffDocumentSchemeEntity.setSupplierTenantId(supplierVO.getTenant());
            stuffDocumentSchemeEntity.setSupplierName(supplierVO.getName());
            stuffDocumentSchemeEntity.setSchemeName(supplierSellSchemeVO.getSchemeName());
            stuffDocumentSchemeEntity.setMoney(supplierSellSchemeVO.getMoney());
            stuffDocumentSchemeEntity.setMoneyTax(supplierSellSchemeVO.getMoneyTax());
            stuffDocumentSchemeEntity.setTalkNum(talkNum);
            stuffDocumentSchemeEntity.setId(IdWorker.getId());
            stuffDocumentSchemeEntity.setPassFlag(1);

            stuffDocumentSchemeEntityArrayList.add(stuffDocumentSchemeEntity);

            //处理报价详情与方案的关联关系
            List<SupplierSellSchemeDetailVO> schemeDetailList = supplierSellSchemeVO.getSchemeDetailList();
            for (SupplierSellSchemeDetailVO supplierSellSchemeDetailVO : schemeDetailList) {
                StuffDocumentSellVO stuffDocumentSellVO = new StuffDocumentSellVO();
//                stuffDocumentSellVO.setProjectId(stuffDocumentEntity.getProjectId());
//                stuffDocumentSellVO.setProjectName(stuffDocumentEntity.getProjectName());
                stuffDocumentSellVO.setSchemeId(stuffDocumentSchemeEntity.getId());
                stuffDocumentSellVO.setDocumentId(stuffDocumentEntity.getId());
                stuffDocumentSellVO.setSupplierId(sourceSupplierId);
                stuffDocumentSellVO.setSupplierTenantId(supplierVO.getTenant());
                stuffDocumentSellVO.setSupplierName(supplierVO.getName());
                stuffDocumentSellVO.setMaterialId(supplierSellSchemeDetailVO.getSourceMaterialId() != null ? Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialId()) : null);
                stuffDocumentSellVO.setMaterialName(supplierSellSchemeDetailVO.getMaterialName());
                stuffDocumentSellVO.setMaterialCode(supplierSellSchemeDetailVO.getMaterialCode());
                stuffDocumentSellVO.setMaterialTypeId(supplierSellSchemeDetailVO.getSourceMaterialTypeId() != null ? Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialTypeId()) : null);
                stuffDocumentSellVO.setMaterialTypeName(supplierSellSchemeDetailVO.getMaterialTypeName());
                stuffDocumentSellVO.setUnit(supplierSellSchemeDetailVO.getUnit());
                stuffDocumentSellVO.setSpec(supplierSellSchemeDetailVO.getSpec());
//                stuffDocumentSellVO.setNum(supplierSellSchemeDetailVO.getNum());
                stuffDocumentSellVO.setDetailRate(supplierSellSchemeDetailVO.getDetailRate());
                stuffDocumentSellVO.setRate(supplierSellSchemeDetailVO.getRate());
                stuffDocumentSellVO.setPrice(supplierSellSchemeDetailVO.getPrice());
                stuffDocumentSellVO.setPriceTax(supplierSellSchemeDetailVO.getPriceTax());
//                stuffDocumentSellVO.setMoney(supplierSellSchemeDetailVO.getMoney());
//                stuffDocumentSellVO.setMoneyTax(supplierSellSchemeDetailVO.getMoneyTax());
//                stuffDocumentSellVO.setSellTax(supplierSellSchemeDetailVO.getTax());
                stuffDocumentSellVO.setSchemeName(supplierSellSchemeVO.getSchemeName());
                stuffDocumentSellVO.setMaterialBrand(supplierSellSchemeDetailVO.getBrand());
                stuffDocumentSellVO.setBrand(supplierSellSchemeDetailVO.getSupplierBrand());
                stuffDocumentSellVO.setMemo(supplierSellSchemeDetailVO.getSupplierMemo());
                stuffDocumentSellVO.setMaterialMemo(supplierSellSchemeDetailVO.getMemo());
                stuffDocumentSellVO.setCalculateType(supplierSellSchemeDetailVO.getCalculateType());
                stuffDocumentSellVO.setReferFlag(2);
                stuffDocumentSellVO.setPassFlag(1);
                stuffDocumentSellVO.setTalkNum(talkNum);
                stuffDocumentSellVO.setInfoPrice(supplierSellSchemeDetailVO.getInfoPrice());//信息价
                stuffDocumentSellVO.setFallRate(supplierSellSchemeDetailVO.getFallRate());//下浮率
                stuffDocumentSellVO.setFallMny(supplierSellSchemeDetailVO.getFallMny());//下浮率

                stuffDocumentSellVOList.add(stuffDocumentSellVO);

            }

        }
        //新增方案
        stuffDocumentSchemeService.saveBatch(stuffDocumentSchemeEntityArrayList);

        //处理报价详情信息
        //删除报价信息
        LambdaQueryWrapper<StuffDocumentSellEntity> lambdaSell = Wrappers.<StuffDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(StuffDocumentSellEntity::getSupplierId, sourceSupplierId);
        lambdaSell.eq(StuffDocumentSellEntity::getTalkNum, talkNum);
        lambdaSell.eq(StuffDocumentSellEntity::getDocumentId, stuffDocumentEntity.getId());
        stuffDocumentSellService.remove(lambdaSell);

        //处理报价详情信息
        LambdaQueryWrapper<StuffDocumentDetailEntity> lambdaDetail = Wrappers.<StuffDocumentDetailEntity>lambdaQuery();
        lambdaDetail.eq(StuffDocumentDetailEntity::getDocumentId, stuffDocumentEntity.getId());
        List<StuffDocumentDetailEntity> stuffDocumentDetailList = stuffDocumentDetailService.list(lambdaDetail);

        List<StuffDocumentSellEntity> stuffDocumentSellEntityArrayList = new ArrayList<>();
        for (StuffDocumentDetailEntity stuffDocumentDetailEntity : stuffDocumentDetailList) {
            for (StuffDocumentSellVO stuffDocumentSellVO : stuffDocumentSellVOList) {
                //判断是否只有分类
                if (stuffDocumentDetailEntity.getMaterialId() != null) {
                    if (stuffInviteEntity.getPurchaseType() == 1) {
                        if (stuffDocumentDetailEntity.getMaterialTypeId().equals(stuffDocumentSellVO.getMaterialTypeId()) &&
                                stuffDocumentDetailEntity.getMaterialId().equals(stuffDocumentSellVO.getMaterialId()) &&
                                stuffDocumentDetailEntity.getRate().equals(stuffDocumentSellVO.getDetailRate())) {
                            StuffDocumentSellEntity stuffDocumentSellEntity = BeanMapper.map(stuffDocumentSellVO, StuffDocumentSellEntity.class);
                            stuffDocumentSellEntity.setDetailId(stuffDocumentDetailEntity.getId());
                            stuffDocumentSellEntity.setProjectId(stuffDocumentDetailEntity.getDetailProjectId());
                            stuffDocumentSellEntity.setProjectName(stuffDocumentDetailEntity.getDetailProjectName());
                            stuffDocumentSellEntity.setNum(stuffDocumentDetailEntity.getNum());
                            stuffDocumentSellEntity.setMoney(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPrice()));
                            stuffDocumentSellEntity.setMoneyTax(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPriceTax()));
                            stuffDocumentSellEntity.setSellTax(stuffDocumentSellEntity.getMoneyTax().subtract(stuffDocumentSellEntity.getMoney()));
                            // 备注拆分
                            stuffDocumentSellEntity.setMaterialMemo(stuffDocumentDetailEntity.getMemo());

                            stuffDocumentSellEntityArrayList.add(stuffDocumentSellEntity);
                        }
                    } else {
                        if (stuffDocumentDetailEntity.getMaterialTypeId().equals(stuffDocumentSellVO.getMaterialTypeId()) &&
                                stuffDocumentDetailEntity.getMaterialId().equals(stuffDocumentSellVO.getMaterialId()) &&
                                stuffDocumentDetailEntity.getCalculateType().equals(stuffDocumentSellVO.getCalculateType()) &&
                                stuffDocumentDetailEntity.getRate().equals(stuffDocumentSellVO.getDetailRate())) {
                            StuffDocumentSellEntity stuffDocumentSellEntity = BeanMapper.map(stuffDocumentSellVO, StuffDocumentSellEntity.class);
                            stuffDocumentSellEntity.setDetailId(stuffDocumentDetailEntity.getId());
                            stuffDocumentSellEntity.setProjectId(stuffDocumentDetailEntity.getDetailProjectId());
                            stuffDocumentSellEntity.setProjectName(stuffDocumentDetailEntity.getDetailProjectName());
                            stuffDocumentSellEntity.setNum(stuffDocumentDetailEntity.getNum());
                            stuffDocumentSellEntity.setMoney(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPrice()));
                            stuffDocumentSellEntity.setMoneyTax(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPriceTax()));
                            stuffDocumentSellEntity.setSellTax(stuffDocumentSellEntity.getMoneyTax().subtract(stuffDocumentSellEntity.getMoney()));
                            // 备注拆分
                            stuffDocumentSellEntity.setMaterialMemo(stuffDocumentDetailEntity.getMemo());
                            stuffDocumentSellEntityArrayList.add(stuffDocumentSellEntity);
                        }
                    }
                }
                if (stuffDocumentDetailEntity.getMaterialId() == null) {
                    if (stuffDocumentDetailEntity.getMaterialTypeId().equals(stuffDocumentSellVO.getMaterialTypeId()) &&
                            (stuffDocumentDetailEntity.getCalculateType() == null || stuffDocumentDetailEntity.getCalculateType().equals(stuffDocumentSellVO.getCalculateType())) &&
                            stuffDocumentDetailEntity.getRate().equals(stuffDocumentSellVO.getDetailRate())) {
                        StuffDocumentSellEntity stuffDocumentSellEntity = BeanMapper.map(stuffDocumentSellVO, StuffDocumentSellEntity.class);
                        stuffDocumentSellEntity.setDetailId(stuffDocumentDetailEntity.getId());
                        stuffDocumentSellEntity.setProjectId(stuffDocumentDetailEntity.getDetailProjectId());
                        stuffDocumentSellEntity.setProjectName(stuffDocumentDetailEntity.getDetailProjectName());
                        stuffDocumentSellEntity.setNum(stuffDocumentDetailEntity.getNum());
                        stuffDocumentSellEntity.setMoney(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPrice()));
                        stuffDocumentSellEntity.setMoneyTax(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPriceTax()));
                        stuffDocumentSellEntity.setSellTax(stuffDocumentSellEntity.getMoneyTax().subtract(stuffDocumentSellEntity.getMoney()));
                        // 备注拆分
                        stuffDocumentSellEntity.setMaterialMemo(stuffDocumentDetailEntity.getMemo());
                        stuffDocumentSellEntityArrayList.add(stuffDocumentSellEntity);
                    }
                }

            }

        }
        //新增报价信息
        stuffDocumentSellService.saveBatch(stuffDocumentSellEntityArrayList);

        //先删除附件
        if (documentSupplierId != null) {
            logger.info("删除供应商[{}]附件信息，billType[{}]，sourceType[supplierFileType]", documentSupplierId, BILL_SUPPLIER_TYPE);
//            CommonResponse<String> deleteRtn = attachmentApi.deleteFileByParam(documentSupplierId, BILL_SUPPLIER_TYPE,"supplierFileType");
            CommonResponse<List<AttachmentVO>> attachmentResponse = attachmentApi.queryListBySourceId(documentSupplierId, BILL_SUPPLIER_TYPE, "supplierFileType", null);
            List<AttachmentVO> attachmentVOList = attachmentResponse.getData();
            if (CollectionUtils.isNotEmpty(attachmentVOList)) {
                logger.info("开始删除附件信息-----");
                String ids = attachmentVOList.stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
                CommonResponse<String> deleteResponse = attachmentApi.delete(ids);
                logger.info("删除文件结束，删除结果：{}", deleteResponse.getData());
            }
        }
        //处理附件
//        if(file != null){
//            logger.info(request+"报价文件名称- {}",file.getOriginalFilename());
//            logger.info(request+"供应商表主键- {}",documentSupplierId);
//            Boolean upFlag = new ThirdSystemUtils().upFile(BASE_HOST,"supplierFileType",Long.toString(documentSupplierId),BILL_SUPPLIER_TYPE,file,request);
//            logger.info(request+"文件上传结果-{}",upFlag);
//        }
        List<SupplyFileVo> pzList = pushVO.getSupplyFileList();
        logger.info("报名文件:{}", JSONObject.toJSONString(pzList));
        if (CollectionUtils.isNotEmpty(pzList)) {
            List<AttachmentVO> list = new ArrayList<>();
            for (SupplyFileVo e : pzList) {
                AttachmentVO attachmentVO = new AttachmentVO();
                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
                attachmentVO.setSourceId(documentSupplierId);
                attachmentVO.setSourceType("supplierFileType");
                attachmentVO.setFilePath(e.getFilePath());
                attachmentVO.setOnlinePath(e.getFilePath());
                attachmentVO.setFileName(e.getFileName());
                attachmentVO.setId(e.getFileId());
                list.add(attachmentVO);
                logger.info("保存文件信息:{}", JSONObject.toJSONString(attachmentVO));
            }
            CommonResponse<String> stringCommonResponse = attachmentApi.insertBatch(list);
            logger.info(request + "报名文件上传结果-{}", JSONObject.toJSONString(stringCommonResponse));
        }
        return true;
    }


    @Transactional
    @Override
    public Boolean localPushSell(Map<String, Object> params, MultipartFile file) {

        logger.info("进入报价接口params-{}", params);
        String notice = JSON.toJSONString(params);
        logger.info("实体信息-{}", notice);
        SupplierSellVO pushVO = JSON.parseObject(notice, new TypeReference<SupplierSellVO>() {
        });
        JSONObject jsonObject = new JSONObject(params);
        String sourceSupplierName = jsonObject.getString("sourceSupplierName");
        String signEmployeeMobile = jsonObject.getString("signEmployeeMobile");
        String signEmployeeName = jsonObject.getString("signEmployeeName");
        //处理业务数据
        //noticeType,类型(0-公告，1-文件,2-询价,3-竞争性,4-洽商谈判
        //转换轮数
        StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(Long.parseLong(pushVO.getSourceId()));
        Integer tenderStage = stuffInviteEntity.getTenderStage();
        //招标阶段(3-招标文件,6-竞争性谈判文件,7-洽商谈判,8-单一来源文件,9-紧急文件,10-询价公告
        Integer talkNum = null;
        if (tenderStage == 3 || tenderStage == 6 || tenderStage == 8 || tenderStage == 9 || tenderStage == 10) {
            talkNum = 0;
        }
        if (tenderStage == 7) {
            //查询轮数
            LambdaQueryWrapper<StuffTalkEntity> lambdaTalk = Wrappers.<StuffTalkEntity>lambdaQuery();
            lambdaTalk.eq(StuffTalkEntity::getInviteId, Long.parseLong(pushVO.getSourceId()));
            StuffTalkEntity stuffTalkEntity = stuffTalkService.getOne(lambdaTalk);
            talkNum = stuffTalkEntity.getTalkNum();
        }

        long sourceSupplierId;
        SupplierDTO supplierVO = new SupplierDTO();

        if (pushVO.getSourceSupplierId() != null) {
            //转换
            sourceSupplierId = Long.parseLong(pushVO.getSourceSupplierId());
            supplierVO = shareSupplierApi.queryById(sourceSupplierId).getData();
        } else {
            sourceSupplierId = -1;
        }
        //处理供应商信息
        Long inviteId = Long.parseLong(pushVO.getSourceId());
        LambdaQueryWrapper<StuffDocumentEntity> lambdaDocument = Wrappers.<StuffDocumentEntity>lambdaQuery();
        lambdaDocument.eq(StuffDocumentEntity::getInviteId, inviteId);
        StuffDocumentEntity stuffDocumentEntity = baseMapper.selectOne(lambdaDocument);
        //先删后增
        //根据供应商主键和招标文件主键查询供应商信息,判断新增和修改
        LambdaQueryWrapper<StuffDocumentSupplierEntity> lambdaSupplier = Wrappers.<StuffDocumentSupplierEntity>lambdaQuery();

        /**如果手机端报价供应商不在库中**/
        if (sourceSupplierId != -1) {
            lambdaSupplier.eq(StuffDocumentSupplierEntity::getSupplierId, sourceSupplierId);
        } else {
            lambdaSupplier.eq(StuffDocumentSupplierEntity::getLinkMobile, signEmployeeMobile);
        }

        lambdaSupplier.eq(StuffDocumentSupplierEntity::getDocumentId, stuffDocumentEntity.getId());
        lambdaSupplier.eq(StuffDocumentSupplierEntity::getTalkNum, talkNum);
        StuffDocumentSupplierEntity stuffDocumentSupplierEntity = stuffDocumentSupplierService.getOne(lambdaSupplier);

        Long documentSupplierId = null;
        if (stuffDocumentSupplierEntity != null) {
            //更新供应商信息
            stuffDocumentSupplierEntity.setOfferTime(new Date());
            stuffDocumentSupplierEntity.setLinkName(signEmployeeName);
            stuffDocumentSupplierEntity.setLinkMobile(signEmployeeMobile);
            stuffDocumentSupplierEntity.setTaxMemo(pushVO.getInvoiceNote());
            stuffDocumentSupplierEntity.setIsMobile(2);
            stuffDocumentSupplierService.updateById(stuffDocumentSupplierEntity);
            /**
             * 处理手机端报价附件
             */
            CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                    String.valueOf(stuffDocumentEntity.getId()), "BT211119000000003", "mobilePush",
                    String.valueOf(stuffDocumentSupplierEntity.getId()), "BT202202000004", "supplierFileType");
            logger.info("手机端合同同步附件::::::::::::结果::" + JSONObject.toJSONString(response).toString());

            documentSupplierId = stuffDocumentSupplierEntity.getId();

            //删除方案信息
            LambdaQueryWrapper<StuffDocumentSchemeEntity> lambdaScheme = Wrappers.<StuffDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(StuffDocumentSchemeEntity::getDocumentSupplierId, stuffDocumentSupplierEntity.getId());
            stuffDocumentSchemeService.remove(lambdaScheme);
        }
        if (stuffDocumentSupplierEntity == null) {
            //新增供应商信息
            StuffDocumentSupplierEntity stuffDocumentSupplierEntityAdd = new StuffDocumentSupplierEntity();
            if (sourceSupplierId != -1) {
                stuffDocumentSupplierEntityAdd.setSupplierId(sourceSupplierId);
                stuffDocumentSupplierEntityAdd.setSupplierTenantId(supplierVO.getTenant());
                stuffDocumentSupplierEntityAdd.setSupplierName(sourceSupplierName);
                stuffDocumentSupplierEntityAdd.setIsMobile(1);
            } else {
                stuffDocumentSupplierEntityAdd.setSupplierName(sourceSupplierName);
            }
            stuffDocumentSupplierEntityAdd.setLinkName(signEmployeeName);
            stuffDocumentSupplierEntityAdd.setLinkMobile(signEmployeeMobile);
            stuffDocumentSupplierEntityAdd.setTaxMemo(pushVO.getInvoiceNote());
            stuffDocumentSupplierEntityAdd.setOfferTime(new Date());
            stuffDocumentSupplierEntityAdd.setDocumentId(stuffDocumentEntity.getId());
            stuffDocumentSupplierEntityAdd.setTalkNum(talkNum);
            stuffDocumentSupplierEntityAdd.setIsMobile(2);
            boolean save = stuffDocumentSupplierService.save(stuffDocumentSupplierEntityAdd);

            documentSupplierId = stuffDocumentSupplierEntityAdd.getId();
            /**
             * 处理手机端报价附件
             */
            CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                    String.valueOf(stuffDocumentEntity.getId()), "BT211119000000003", "mobilePush",
                    String.valueOf(documentSupplierId), "BT202202000004", "supplierFileType");
            logger.info("手机端合同同步附件::::::::::::结果::" + JSONObject.toJSONString(response).toString());

        }

        //处理方案信息
        List<SupplierSellSchemeVO> schemeList = pushVO.getSchemeList();
        List<StuffDocumentSchemeEntity> stuffDocumentSchemeEntityArrayList = new ArrayList<>();
        //所有报价详情信息
        List<StuffDocumentSellVO> stuffDocumentSellVOList = new ArrayList<>();
        for (SupplierSellSchemeVO supplierSellSchemeVO : schemeList) {
            StuffDocumentSchemeEntity stuffDocumentSchemeEntity = new StuffDocumentSchemeEntity();
            stuffDocumentSchemeEntity.setDocumentSupplierId(documentSupplierId);
            stuffDocumentSchemeEntity.setDocumentId(stuffDocumentEntity.getId());
            if (sourceSupplierId != -1) {
                stuffDocumentSchemeEntity.setSupplierId(sourceSupplierId);
                stuffDocumentSchemeEntity.setSupplierTenantId(supplierVO.getTenant());
                stuffDocumentSchemeEntity.setSupplierName(supplierVO.getName());
            } else {
                stuffDocumentSchemeEntity.setSupplierName(sourceSupplierName);
            }
            stuffDocumentSchemeEntity.setSchemeName(supplierSellSchemeVO.getSchemeName());
            stuffDocumentSchemeEntity.setMoney(supplierSellSchemeVO.getMoney());
            stuffDocumentSchemeEntity.setMoneyTax(supplierSellSchemeVO.getMoneyTax());
            stuffDocumentSchemeEntity.setTalkNum(talkNum);
            stuffDocumentSchemeEntity.setId(IdWorker.getId());
            stuffDocumentSchemeEntity.setPassFlag(1);
            stuffDocumentSchemeEntity.setIsMobile(1);

            stuffDocumentSchemeEntityArrayList.add(stuffDocumentSchemeEntity);

            //处理报价详情与方案的关联关系
            List<SupplierSellSchemeDetailVO> schemeDetailList = supplierSellSchemeVO.getSchemeDetailList();
            for (SupplierSellSchemeDetailVO supplierSellSchemeDetailVO : schemeDetailList) {
                StuffDocumentSellVO stuffDocumentSellVO = new StuffDocumentSellVO();
//                stuffDocumentSellVO.setProjectId(stuffDocumentEntity.getProjectId());
//                stuffDocumentSellVO.setProjectName(stuffDocumentEntity.getProjectName());
                stuffDocumentSellVO.setSchemeId(stuffDocumentSchemeEntity.getId());
                stuffDocumentSellVO.setDocumentId(stuffDocumentEntity.getId());
                if (sourceSupplierId != -1) {
                    stuffDocumentSellVO.setSupplierId(sourceSupplierId);
                    stuffDocumentSellVO.setSupplierTenantId(supplierVO.getTenant());
                    stuffDocumentSellVO.setSupplierName(supplierVO.getName());
                } else {
                    stuffDocumentSellVO.setLinkMobile(signEmployeeMobile);
                    stuffDocumentSellVO.setSupplierName(sourceSupplierName);
                }
                stuffDocumentSellVO.setMaterialId(supplierSellSchemeDetailVO.getSourceMaterialId() != null ? Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialId()) : null);
                stuffDocumentSellVO.setMaterialName(supplierSellSchemeDetailVO.getMaterialName());
                stuffDocumentSellVO.setMaterialCode(supplierSellSchemeDetailVO.getMaterialCode());
                stuffDocumentSellVO.setMaterialTypeId(supplierSellSchemeDetailVO.getSourceMaterialTypeId() != null ? Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialTypeId()) : null);
                stuffDocumentSellVO.setMaterialTypeName(supplierSellSchemeDetailVO.getMaterialTypeName());
                stuffDocumentSellVO.setUnit(supplierSellSchemeDetailVO.getUnit());
                stuffDocumentSellVO.setSpec(supplierSellSchemeDetailVO.getSpec());
//                stuffDocumentSellVO.setNum(supplierSellSchemeDetailVO.getNum());
                stuffDocumentSellVO.setDetailRate(supplierSellSchemeDetailVO.getDetailRate());
                stuffDocumentSellVO.setRate(supplierSellSchemeDetailVO.getRate());
                stuffDocumentSellVO.setPrice(supplierSellSchemeDetailVO.getPrice());
                stuffDocumentSellVO.setPriceTax(supplierSellSchemeDetailVO.getPriceTax());
//                stuffDocumentSellVO.setMoney(supplierSellSchemeDetailVO.getMoney());
//                stuffDocumentSellVO.setMoneyTax(supplierSellSchemeDetailVO.getMoneyTax());
//                stuffDocumentSellVO.setSellTax(supplierSellSchemeDetailVO.getTax());
                stuffDocumentSellVO.setSchemeName(supplierSellSchemeVO.getSchemeName());
                stuffDocumentSellVO.setMaterialBrand(supplierSellSchemeDetailVO.getBrand());
                stuffDocumentSellVO.setBrand(supplierSellSchemeDetailVO.getSupplierBrand());
                stuffDocumentSellVO.setMemo(supplierSellSchemeDetailVO.getSupplierMemo());
                stuffDocumentSellVO.setMaterialMemo(supplierSellSchemeDetailVO.getMemo());
                stuffDocumentSellVO.setCalculateType(supplierSellSchemeDetailVO.getCalculateType());
                stuffDocumentSellVO.setReferFlag(2);
                stuffDocumentSellVO.setPassFlag(1);
                stuffDocumentSellVO.setTalkNum(talkNum);
                stuffDocumentSellVO.setIsMobile(1);

                stuffDocumentSellVOList.add(stuffDocumentSellVO);

            }

        }
        //新增方案
        stuffDocumentSchemeService.saveBatch(stuffDocumentSchemeEntityArrayList);

        //处理报价详情信息
        //删除报价信息
        LambdaQueryWrapper<StuffDocumentSellEntity> lambdaSell = Wrappers.<StuffDocumentSellEntity>lambdaQuery();
        if (sourceSupplierId != -1) {
            lambdaSell.eq(StuffDocumentSellEntity::getSupplierId, sourceSupplierId);
        } else {
            lambdaSell.eq(StuffDocumentSellEntity::getLinkMobile, signEmployeeMobile);
        }
        lambdaSell.eq(StuffDocumentSellEntity::getTalkNum, talkNum);
        lambdaSell.eq(StuffDocumentSellEntity::getDocumentId, stuffDocumentEntity.getId());
        stuffDocumentSellService.remove(lambdaSell);

        //处理报价详情信息
        LambdaQueryWrapper<StuffDocumentDetailEntity> lambdaDetail = Wrappers.<StuffDocumentDetailEntity>lambdaQuery();
        lambdaDetail.eq(StuffDocumentDetailEntity::getDocumentId, stuffDocumentEntity.getId());
        List<StuffDocumentDetailEntity> stuffDocumentDetailList = stuffDocumentDetailService.list(lambdaDetail);

        List<StuffDocumentSellEntity> stuffDocumentSellEntityArrayList = new ArrayList<>();
        for (StuffDocumentDetailEntity stuffDocumentDetailEntity : stuffDocumentDetailList) {
            for (StuffDocumentSellVO stuffDocumentSellVO : stuffDocumentSellVOList) {
                //判断是否只有分类
                if (stuffDocumentDetailEntity.getMaterialId() != null) {
                    if (stuffInviteEntity.getPurchaseType() == 1) {//单位采购
                        if (stuffDocumentDetailEntity.getMaterialTypeId().equals(stuffDocumentSellVO.getMaterialTypeId()) &&
                                stuffDocumentDetailEntity.getMaterialId().equals(stuffDocumentSellVO.getMaterialId()) &&
                                stuffDocumentDetailEntity.getRate().compareTo(stuffDocumentSellVO.getDetailRate()) == 0) {
                            StuffDocumentSellEntity stuffDocumentSellEntity = BeanMapper.map(stuffDocumentSellVO, StuffDocumentSellEntity.class);
                            stuffDocumentSellEntity.setDetailId(stuffDocumentDetailEntity.getId());
                            stuffDocumentSellEntity.setProjectId(stuffDocumentDetailEntity.getDetailProjectId());
                            stuffDocumentSellEntity.setProjectName(stuffDocumentDetailEntity.getDetailProjectName());
                            stuffDocumentSellEntity.setNum(stuffDocumentDetailEntity.getNum());
                            stuffDocumentSellEntity.setMoney(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPrice()));
                            stuffDocumentSellEntity.setMoneyTax(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPriceTax()));
                            stuffDocumentSellEntity.setSellTax(stuffDocumentSellEntity.getMoneyTax().subtract(stuffDocumentSellEntity.getMoney()));
                            // 备注拆分
                            stuffDocumentSellEntity.setMaterialMemo(stuffDocumentDetailEntity.getMemo());
                            stuffDocumentSellEntity.setIsMobile(1);

                            stuffDocumentSellEntityArrayList.add(stuffDocumentSellEntity);
                        }
                    } else {
                        if (stuffDocumentDetailEntity.getMaterialTypeId().equals(stuffDocumentSellVO.getMaterialTypeId()) &&
                                stuffDocumentDetailEntity.getMaterialId().equals(stuffDocumentSellVO.getMaterialId()) &&
                                stuffDocumentDetailEntity.getCalculateType().equals(stuffDocumentSellVO.getCalculateType()) &&
                                stuffDocumentDetailEntity.getRate().compareTo(stuffDocumentSellVO.getDetailRate()) == 0) {
                            StuffDocumentSellEntity stuffDocumentSellEntity = BeanMapper.map(stuffDocumentSellVO, StuffDocumentSellEntity.class);
                            stuffDocumentSellEntity.setDetailId(stuffDocumentDetailEntity.getId());
                            stuffDocumentSellEntity.setProjectId(stuffDocumentDetailEntity.getDetailProjectId());
                            stuffDocumentSellEntity.setProjectName(stuffDocumentDetailEntity.getDetailProjectName());
                            stuffDocumentSellEntity.setNum(stuffDocumentDetailEntity.getNum());
                            stuffDocumentSellEntity.setMoney(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPrice()));
                            stuffDocumentSellEntity.setMoneyTax(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPriceTax()));
                            stuffDocumentSellEntity.setSellTax(stuffDocumentSellEntity.getMoneyTax().subtract(stuffDocumentSellEntity.getMoney()));
                            // 备注拆分
                            stuffDocumentSellEntity.setMaterialMemo(stuffDocumentDetailEntity.getMemo());
                            stuffDocumentSellEntity.setIsMobile(1);
                            stuffDocumentSellEntityArrayList.add(stuffDocumentSellEntity);
                        }
                    }
                }
                if (stuffDocumentDetailEntity.getMaterialId() == null) {
                    if (stuffDocumentDetailEntity.getMaterialTypeId().equals(stuffDocumentSellVO.getMaterialTypeId()) &&
                            (stuffDocumentDetailEntity.getCalculateType() == null || stuffDocumentDetailEntity.getCalculateType().equals(stuffDocumentSellVO.getCalculateType())) &&
                            stuffDocumentDetailEntity.getRate().compareTo(stuffDocumentSellVO.getDetailRate()) == 0) {
                        StuffDocumentSellEntity stuffDocumentSellEntity = BeanMapper.map(stuffDocumentSellVO, StuffDocumentSellEntity.class);
                        stuffDocumentSellEntity.setDetailId(stuffDocumentDetailEntity.getId());
                        stuffDocumentSellEntity.setProjectId(stuffDocumentDetailEntity.getDetailProjectId());
                        stuffDocumentSellEntity.setProjectName(stuffDocumentDetailEntity.getDetailProjectName());
                        stuffDocumentSellEntity.setNum(stuffDocumentDetailEntity.getNum());
                        stuffDocumentSellEntity.setMoney(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPrice()));
                        stuffDocumentSellEntity.setMoneyTax(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPriceTax()));
                        stuffDocumentSellEntity.setSellTax(stuffDocumentSellEntity.getMoneyTax().subtract(stuffDocumentSellEntity.getMoney()));
                        // 备注拆分
                        stuffDocumentSellEntity.setMaterialMemo(stuffDocumentDetailEntity.getMemo());
                        stuffDocumentSellEntity.setIsMobile(1);
                        stuffDocumentSellEntityArrayList.add(stuffDocumentSellEntity);
                    }
                }

            }

        }
        //新增报价信息
        stuffDocumentSellService.saveBatch(stuffDocumentSellEntityArrayList);

        //先删除附件
        if (documentSupplierId != null) {
            logger.info("删除供应商[{}]附件信息，billType[{}]，sourceType[supplierFileType]", documentSupplierId, BILL_SUPPLIER_TYPE);
//            CommonResponse<String> deleteRtn = attachmentApi.deleteFileByParam(documentSupplierId, BILL_SUPPLIER_TYPE,"supplierFileType");
            CommonResponse<List<AttachmentVO>> attachmentResponse = attachmentApi.queryListBySourceId(documentSupplierId, BILL_SUPPLIER_TYPE, "supplierFileType", null);
            List<AttachmentVO> attachmentVOList = attachmentResponse.getData();
            if (CollectionUtils.isNotEmpty(attachmentVOList)) {
                logger.info("开始删除附件信息-----");
                String ids = attachmentVOList.stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
                CommonResponse<String> deleteResponse = attachmentApi.delete(ids);
                logger.info("删除文件结束，删除结果：{}", deleteResponse.getData());
            }
        }
        //处理附件
//        if(file != null){
//            logger.info(request+"报价文件名称- {}",file.getOriginalFilename());
//            logger.info(request+"供应商表主键- {}",documentSupplierId);
//            Boolean upFlag = new ThirdSystemUtils().upFile(BASE_HOST,"supplierFileType",Long.toString(documentSupplierId),BILL_SUPPLIER_TYPE,file,request);
//            logger.info(request+"文件上传结果-{}",upFlag);
//        }
        //TODO
//        List<SupplyFileVo> pzList = pushVO.getSupplyFileList();
//        logger.info("报名文件:{}", JSONObject.toJSONString(pzList));
//        if (CollectionUtils.isNotEmpty(pzList)) {
//            List<AttachmentVO> list = new ArrayList<>();
//            for (SupplyFileVo e : pzList) {
//                AttachmentVO attachmentVO = new AttachmentVO();
//                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
//                attachmentVO.setSourceId(documentSupplierId);
//                attachmentVO.setSourceType("supplierFileType");
//                attachmentVO.setFilePath(e.getFilePath());
//                attachmentVO.setOnlinePath(e.getFilePath());
//                attachmentVO.setFileName(e.getFileName());
//                attachmentVO.setId(e.getFileId());
//                list.add(attachmentVO);
//                logger.info("保存文件信息:{}", JSONObject.toJSONString(attachmentVO));
//            }
//            CommonResponse<String> stringCommonResponse = attachmentApi.insertBatch(list);
//            logger.info(request + "报名文件上传结果-{}", JSONObject.toJSONString(stringCommonResponse));
//        }
        return true;
    }


    @Override
    public String uploadById(Long attachId, Long inviteId,String billFlag,Long billId) {
        Map<String, String> fileMap = new HashMap<>();
        fileMap.put("fileIds", Long.toString(attachId));
        String wjFileByte = null;
        try {
            wjFileByte = ReferHttpClientUtils.getAndHeader(BASE_HOST + "ejc-file-web/attachment/batchdownflow", fileMap);
        } catch (GeneralSecurityException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        //文件stream处理
        JSONObject jsonwj = JSON.parseObject(wjFileByte);
        Map<String, String> zbwjParam = JSONObject.parseObject(jsonwj.toJSONString(), new TypeReference<Map<String, String>>() {
        });
        String datawj = zbwjParam.get("data");
        JSONObject wListJson = JSON.parseObject(datawj);
        Map<String, byte[]> wjMap = JSONObject.parseObject(wListJson.toJSONString(), new TypeReference<Map<String, byte[]>>() {
        });
        Map<String, InputStream> streamMap = new HashMap<>();
        wjMap.forEach((key, value) -> {
            streamMap.put(key, new ByteArrayInputStream(value));
        });


        Map<String, String> params = new HashMap<>();
        params.put("sourceId", Long.toString(inviteId));
        Map<String, String> headers = new HashMap<>();
        Map<String, Map<String, InputStream>> files = new HashMap<>();
        files.put("file", streamMap);

        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataAndFilesWithUniversal(addFileUrl, params, files, appId, appSecret, appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("附件批量修改同步供方接口报错" + stringCommonResponse.getMsg());
        }
        /** 招标答疑附件上传后发送短信 --开始*/
        if (billId != null && billFlag != null) {
            //上传答疑附件时短信提醒
            String url = "https://xt.zzyjjt.com";
            Map<String, String> collect = new HashMap<>();
            String noticeName = "";
            if ("stuff".equals(billFlag)) {
                //材料
                StuffNoticeEntity stuffNoticeEntity = stuffNoticeService.selectById(billId);
                //发送短信
                List<StuffNoticeSupplierEntity> noticeSupplierDetail = stuffNoticeEntity.getNoticeSupplierDetail();
                collect = noticeSupplierDetail.stream().collect(Collectors.toMap(StuffNoticeSupplierEntity::getSupplierEmployeeMobile, StuffNoticeSupplierEntity::getSupplierName));
                noticeName = stuffNoticeEntity.getNoticeName();

            } else if ("prosub".equals(billFlag)) {
                //专业分包
                ProsubNoticeEntity prosubNoticeEntity = prosubNoticeService.selectById(billId);
                //发送短信
                List<ProsubNoticeSupplierEntity> noticeSupplierDetail = prosubNoticeEntity.getNoticeSupplierDetail();

                collect = noticeSupplierDetail.stream().collect(Collectors.toMap(ProsubNoticeSupplierEntity::getSupplierEmployeeMobile, ProsubNoticeSupplierEntity::getSupplierName));
                noticeName = prosubNoticeEntity.getNoticeName();

            } else if ("sub".equals(billFlag)) {
                //劳务分包
                SubNoticeEntity subNoticeEntity = subNoticeService.selectById(billId);
                //发送短信
                List<SubNoticeSupplierEntity> noticeSupplierDetail = subNoticeEntity.getNoticeSupplierDetail();

                collect = noticeSupplierDetail.stream().collect(Collectors.toMap(SubNoticeSupplierEntity::getSupplierEmployeeMobile, SubNoticeSupplierEntity::getSupplierName));
                noticeName = subNoticeEntity.getNoticeName();

            } else if ("rmat".equals(billFlag)) {
                //周转才
                RmatNoticeEntity rmatNoticeEntity = rmatNoticeService.selectById(billId);
                //发送短信
                List<RmatNoticeSupplierEntity> noticeSupplierDetail = rmatNoticeEntity.getNoticeSupplierDetail();

                collect = noticeSupplierDetail.stream().collect(Collectors.toMap(RmatNoticeSupplierEntity::getSupplierEmployeeMobile, RmatNoticeSupplierEntity::getSupplierName));
                noticeName = rmatNoticeEntity.getNoticeName();

            } else if ("rent".equals(billFlag)) {
                //设备租赁
                RentNoticeEntity rentNoticeEntity = rentNoticeService.selectById(billId);
                //发送短信
                List<RentNoticeSupplierEntity> noticeSupplierDetail = rentNoticeEntity.getNoticeSupplierDetail();

                collect = noticeSupplierDetail.stream().collect(Collectors.toMap(RentNoticeSupplierEntity::getSupplierEmployeeMobile, RentNoticeSupplierEntity::getSupplierName));
                noticeName = rentNoticeEntity.getNoticeName();

            } else if ("other".equals(billFlag)) {
                //其他
                OtherNoticeEntity otherNoticeEntity = otherNoticeService.selectById(billId);
                //发送短信
                List<OtherNoticeSupplierEntity> noticeSupplierDetail = otherNoticeEntity.getNoticeSupplierDetail();

                collect = noticeSupplierDetail.stream().collect(Collectors.toMap(OtherNoticeSupplierEntity::getSupplierEmployeeMobile, OtherNoticeSupplierEntity::getSupplierName));
                noticeName = otherNoticeEntity.getNoticeName();

            } else if ("equipment".equals(billFlag)) {
                //设配购置
                EquipmentNoticeEntity equipmentNoticeEntity = equipmentNoticeService.selectById(billId);
                //发送短信
                List<EquipmentNoticeSupplierEntity> noticeSupplierDetail = equipmentNoticeEntity.getNoticeSupplierDetail();

                collect = noticeSupplierDetail.stream().collect(Collectors.toMap(EquipmentNoticeSupplierEntity::getSupplierEmployeeMobile, EquipmentNoticeSupplierEntity::getSupplierName));
                noticeName = equipmentNoticeEntity.getNoticeName();

            }else if ("stuffdoc".equals(billFlag)) {
                //材料
                StuffDocumentEntity stuffDocumentEntity = service.selectById(billId);
                if (stuffDocumentEntity.getNoticeId() != null) {
                    StuffNoticeEntity stuffNoticeEntity = stuffNoticeService.selectById(billId);
                    //发送短信
                    List<StuffNoticeSupplierEntity> noticeSupplierDetail = stuffNoticeEntity.getNoticeSupplierDetail();
                    collect = noticeSupplierDetail.stream().collect(Collectors.toMap(StuffNoticeSupplierEntity::getSupplierEmployeeMobile, StuffNoticeSupplierEntity::getSupplierName));
                    noticeName = stuffNoticeEntity.getNoticeName();
                }
            } else if ("prosubdoc".equals(billFlag)) {
                //专业分包
                ProsubDocumentEntity prosubDocumentEntity = prosubDocumentService.selectById(billId);

                if (prosubDocumentEntity.getNoticeId() != null) {
                    ProsubNoticeEntity prosubNoticeEntity = prosubNoticeService.selectById(billId);
                    //发送短信
                    List<ProsubNoticeSupplierEntity> noticeSupplierDetail = prosubNoticeEntity.getNoticeSupplierDetail();

                    collect = noticeSupplierDetail.stream().collect(Collectors.toMap(ProsubNoticeSupplierEntity::getSupplierEmployeeMobile, ProsubNoticeSupplierEntity::getSupplierName));
                    noticeName = prosubNoticeEntity.getNoticeName();
                }
            } else if ("subdoc".equals(billFlag)) {
                //劳务分包
                SubDocumentEntity subDocumentEntity = subDocumentService.selectById(billId);
                if (subDocumentEntity.getNoticeId() != null) {
                    SubNoticeEntity subNoticeEntity = subNoticeService.selectById(billId);
                    //发送短信
                    List<SubNoticeSupplierEntity> noticeSupplierDetail = subNoticeEntity.getNoticeSupplierDetail();

                    collect = noticeSupplierDetail.stream().collect(Collectors.toMap(SubNoticeSupplierEntity::getSupplierEmployeeMobile, SubNoticeSupplierEntity::getSupplierName));
                    noticeName = subNoticeEntity.getNoticeName();
                }
            } else if ("rmatdoc".equals(billFlag)) {
                //周转才
                RmatDocumentEntity rmatDocumentEntity = rmatDocumentService.selectById(billId);
                if (rmatDocumentEntity.getNoticeId() != null) {
                    RmatNoticeEntity rmatNoticeEntity = rmatNoticeService.selectById(billId);
                    //发送短信
                    List<RmatNoticeSupplierEntity> noticeSupplierDetail = rmatNoticeEntity.getNoticeSupplierDetail();

                    collect = noticeSupplierDetail.stream().collect(Collectors.toMap(RmatNoticeSupplierEntity::getSupplierEmployeeMobile, RmatNoticeSupplierEntity::getSupplierName));
                    noticeName = rmatNoticeEntity.getNoticeName();
                }
            } else if ("rentdoc".equals(billFlag)) {
                //设备租赁
                RentDocumentEntity rentDocumentEntity = rentDocumentService.selectById(billId);
                if (rentDocumentEntity.getNoticeId() != null) {
                    RentNoticeEntity rentNoticeEntity = rentNoticeService.selectById(billId);
                    //发送短信
                    List<RentNoticeSupplierEntity> noticeSupplierDetail = rentNoticeEntity.getNoticeSupplierDetail();

                    collect = noticeSupplierDetail.stream().collect(Collectors.toMap(RentNoticeSupplierEntity::getSupplierEmployeeMobile, RentNoticeSupplierEntity::getSupplierName));
                    noticeName = rentNoticeEntity.getNoticeName();
                }
            } else if ("otherdoc".equals(billFlag)) {
                //其他
                OtherDocumentEntity otherDocumentEntity = otherDocumentService.selectById(billId);
                if (otherDocumentEntity.getNoticeId() != null) {
                    OtherNoticeEntity otherNoticeEntity = otherNoticeService.selectById(billId);
                    //发送短信
                    List<OtherNoticeSupplierEntity> noticeSupplierDetail = otherNoticeEntity.getNoticeSupplierDetail();

                    collect = noticeSupplierDetail.stream().collect(Collectors.toMap(OtherNoticeSupplierEntity::getSupplierEmployeeMobile, OtherNoticeSupplierEntity::getSupplierName));
                    noticeName = otherNoticeEntity.getNoticeName();
                }
            } else if ("equipmentdoc".equals(billFlag)) {
                //设配购置
                EquipmentDocumentEntity equipmentDocumentEntity = equipmentDocumentService.selectById(billId);
                if (equipmentDocumentEntity.getNoticeId() != null) {
                    EquipmentNoticeEntity equipmentNoticeEntity = equipmentNoticeService.selectById(billId);
                    //发送短信
                    List<EquipmentNoticeSupplierEntity> noticeSupplierDetail = equipmentNoticeEntity.getNoticeSupplierDetail();

                    collect = noticeSupplierDetail.stream().collect(Collectors.toMap(EquipmentNoticeSupplierEntity::getSupplierEmployeeMobile, EquipmentNoticeSupplierEntity::getSupplierName));
                    noticeName = equipmentNoticeEntity.getNoticeName();
                }
            }else if ("stufftalk".equals(billFlag)) {
                    //材料
                    StuffTalkVO stuffTalkVO = stuffTalkService.queryDetail(billId);
                    if (stuffTalkVO != null) {
                        //发送短信
                        List<StuffDocumentSupplierVO> stuffDocumentSupplierList = stuffTalkVO.getStuffDocumentSupplierList();
                        collect = stuffDocumentSupplierList.stream().collect(Collectors.toMap(StuffDocumentSupplierVO::getLinkMobile, StuffDocumentSupplierVO::getSupplierName));
                        noticeName = stuffTalkVO.getTalkName();
                    }
                } else if ("prosubtalk".equals(billFlag)) {
                    //专业分包
                    ProsubTalkVO prosubTalkVO = prosubTalkService.queryDetail(billId);

                    if (prosubTalkVO != null) {
                        //发送短信
                        List<ProsubDocumentSupplierVO> subDocumentSupplierList = prosubTalkVO.getSubDocumentSupplierList();

                        collect = subDocumentSupplierList.stream().collect(Collectors.toMap(ProsubDocumentSupplierVO::getLinkMobile, ProsubDocumentSupplierVO::getSupplierName));
                        noticeName = prosubTalkVO.getTalkName();
                    }
                } else if ("subtalk".equals(billFlag)) {
                    //劳务分包
                    SubTalkVO subTalkVO = subTalkService.queryDetail(billId);
                    if (subTalkVO != null) {
                        //发送短信
                        List<SubDocumentSupplierVO> subDocumentSupplierList = subTalkVO.getSubDocumentSupplierList();

                        collect = subDocumentSupplierList.stream().collect(Collectors.toMap(SubDocumentSupplierVO::getLinkMobile, SubDocumentSupplierVO::getSupplierName));
                        noticeName = subTalkVO.getTalkName();
                    }
                } else if ("rmattalk".equals(billFlag)) {
                    //周转才
                    RmatTalkVO rmatTalkVO = rmatTalkService.queryDetail(billId);
                    if (rmatTalkVO != null) {

                        //发送短信
                        List<RmatDocumentSupplierVO> rmatDocumentSupplierList = rmatTalkVO.getRmatDocumentSupplierList();

                        collect = rmatDocumentSupplierList.stream().collect(Collectors.toMap(RmatDocumentSupplierVO::getLinkMobile, RmatDocumentSupplierVO::getSupplierName));
                        noticeName = rmatTalkVO.getTalkName();
                    }
                } else if ("renttalk".equals(billFlag)) {
                    //设备租赁
                    RentTalkVO rentTalkVO = rentTalkService.queryDetail(billId);
                    if (rentTalkVO != null) {

                        //发送短信
                        List<RentDocumentSupplierVO> rentDocumentSupplierList = rentTalkVO.getRentDocumentSupplierList();

                        collect = rentDocumentSupplierList.stream().collect(Collectors.toMap(RentDocumentSupplierVO::getLinkMobile, RentDocumentSupplierVO::getSupplierName));
                        noticeName = rentTalkVO.getTalkName();
                    }
                } else if ("othertalk".equals(billFlag)) {
                    //其他
                    OtherTalkVO otherTalkVO = otherTalkService.queryDetail(billId);
                    if (otherTalkVO != null) {

                        //发送短信
                        List<OtherDocumentSupplierVO> otherDocumentSupplierList = otherTalkVO.getOtherDocumentSupplierList();

                        collect = otherDocumentSupplierList.stream().collect(Collectors.toMap(OtherDocumentSupplierVO::getLinkMobile, OtherDocumentSupplierVO::getSupplierName));
                        noticeName = otherTalkVO.getTalkName();
                    }
                } else if ("equipmenttalk".equals(billFlag)) {
                    //设配购置
                    EquipmentTalkVO equipmentTalkVO = equipmentTalkService.queryDetail(billId);
                    if (equipmentTalkVO != null) {

                        //发送短信
                        List<EquipmentDocumentSupplierVO> equipmentDocumentSupplierList = equipmentTalkVO.getEquipmentDocumentSupplierList();

                        collect = equipmentDocumentSupplierList.stream().collect(Collectors.toMap(EquipmentDocumentSupplierVO::getLinkMobile, EquipmentDocumentSupplierVO::getSupplierName));
                        noticeName = equipmentTalkVO.getTalkName();
                    }
            }else if ("stuffjz".equals(billFlag)) {
                //材料
                StuffDocumentVO stuffTalkVO = service.queryDetail(billId);
                if (stuffTalkVO != null) {
                    //发送短信
                    List<StuffDocumentSupplierVO> stuffDocumentSupplierList = stuffTalkVO.getStuffDocumentSupplierList();
                    collect = stuffDocumentSupplierList.stream().collect(Collectors.toMap(StuffDocumentSupplierVO::getLinkMobile, StuffDocumentSupplierVO::getSupplierName));
                    noticeName = stuffTalkVO.getDocumentName();
                }
            } else if ("prosubjz".equals(billFlag)) {
                //专业分包
                ProsubDocumentVO prosubTalkVO = prosubDocumentService.queryDetail(billId);

                if (prosubTalkVO != null) {
                    //发送短信
                    List<ProsubDocumentSupplierVO> subDocumentSupplierList = prosubTalkVO.getSubDocumentSupplierList();

                    collect = subDocumentSupplierList.stream().collect(Collectors.toMap(ProsubDocumentSupplierVO::getLinkMobile, ProsubDocumentSupplierVO::getSupplierName));
                    noticeName = prosubTalkVO.getDocumentName();
                }
            } else if ("subjz".equals(billFlag)) {
                //劳务分包
                SubDocumentVO subTalkVO = subDocumentService.queryDetail(billId);
                if (subTalkVO != null) {
                    //发送短信
                    List<SubDocumentSupplierVO> subDocumentSupplierList = subTalkVO.getSubDocumentSupplierList();

                    collect = subDocumentSupplierList.stream().collect(Collectors.toMap(SubDocumentSupplierVO::getLinkMobile, SubDocumentSupplierVO::getSupplierName));
                    noticeName = subTalkVO.getDocumentName();
                }
            } else if ("rmatjz".equals(billFlag)) {
                //周转才
                RmatDocumentVO rmatTalkVO = rmatDocumentService.queryDetail(billId);
                if (rmatTalkVO != null) {

                    //发送短信
                    List<RmatDocumentSupplierVO> rmatDocumentSupplierList = rmatTalkVO.getRmatDocumentSupplierList();

                    collect = rmatDocumentSupplierList.stream().collect(Collectors.toMap(RmatDocumentSupplierVO::getLinkMobile, RmatDocumentSupplierVO::getSupplierName));
                    noticeName = rmatTalkVO.getDocumentName();
                }
            } else if ("rentjz".equals(billFlag)) {
                //设备租赁
                RentDocumentVO rentTalkVO = rentDocumentService.queryDetail(billId);
                if (rentTalkVO != null) {

                    //发送短信
                    List<RentDocumentSupplierVO> rentDocumentSupplierList = rentTalkVO.getRentDocumentSupplierList();

                    collect = rentDocumentSupplierList.stream().collect(Collectors.toMap(RentDocumentSupplierVO::getLinkMobile, RentDocumentSupplierVO::getSupplierName));
                    noticeName = rentTalkVO.getDocumentName();
                }
            } else if ("otherjz".equals(billFlag)) {
                //其他
                OtherDocumentVO otherTalkVO = otherDocumentService.queryDetail(billId);
                if (otherTalkVO != null) {

                    //发送短信
                    List<OtherDocumentSupplierVO> otherDocumentSupplierList = otherTalkVO.getOtherDocumentSupplierList();

                    collect = otherDocumentSupplierList.stream().collect(Collectors.toMap(OtherDocumentSupplierVO::getLinkMobile, OtherDocumentSupplierVO::getSupplierName));
                    noticeName = otherTalkVO.getDocumentName();
                }
            } else if ("equipmentjz".equals(billFlag)) {
                //设配购置
                EquipmentDocumentVO equipmentTalkVO = equipmentDocumentService.queryDetail(billId);
                if (equipmentTalkVO != null) {

                    //发送短信
                    List<EquipmentDocumentSupplierVO> equipmentDocumentSupplierList = equipmentTalkVO.getEquipmentDocumentSupplierList();

                    collect = equipmentDocumentSupplierList.stream().collect(Collectors.toMap(EquipmentDocumentSupplierVO::getLinkMobile, EquipmentDocumentSupplierVO::getSupplierName));
                    noticeName = equipmentTalkVO.getDocumentName();
                }
            }
            for (Map.Entry<String, String> entry : collect.entrySet()) {
                String mapKey = entry.getKey();
                String mapValue = entry.getValue();
                String context = mapValue + "的负责人您好，招标‘" + noticeName +
                        "’上传了招标答疑附件,详情请登录系统进行查看" + url + " 【郑州一建】";
                //发送消息
                SMS.setSendSms(mapKey, context);
            }
        }
        /** 招标答疑附件上传后发送短信 --结束*/
        return null;
    }

    @Override
    public String deleteFileById(Long sourceId, List<String> fileNames) {
        Map<String, Object> map = new HashMap<>();
        map.put("sourceId", sourceId);
        map.put("fileNames", fileNames);
        String stringInfo = JSONObject.toJSONString(map);
        //调用供方接口
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(delFileUrl, RequestMethod.POST, stringInfo, appId, appSecret, appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("附加批量删除同步供方接口报错" + response.getMsg());
        }
        return "同步成功";
    }

    @Override
    public StuffDocumentSupplierSellVO getSupplierSchemeDetailDb(Long schemeId, Long documentId) {

        StuffDocumentEntity stuffDocumentEntity = super.selectById(documentId);
        StuffDocumentSupplierSellVO stuffDocumentSupplierSellVO = new StuffDocumentSupplierSellVO();
        StuffDocumentSchemeEntity stuffDocumentSchemeEntity = stuffDocumentSchemeService.selectById(schemeId);
        StuffDocumentSupplierEntity stuffDocumentSupplierEntity = stuffDocumentSupplierService.selectById(stuffDocumentSchemeEntity.getDocumentSupplierId());
        Long supplierDetailId = stuffDocumentSupplierEntity.getId();
        stuffDocumentSupplierSellVO.setLinkName(stuffDocumentSupplierEntity.getLinkName());
        stuffDocumentSupplierSellVO.setSupplierName(stuffDocumentSupplierEntity.getSupplierName());
        stuffDocumentSupplierSellVO.setLinkMobile(stuffDocumentSupplierEntity.getLinkMobile());
        stuffDocumentSupplierSellVO.setOfferTime(stuffDocumentSupplierEntity.getOfferTime());
        stuffDocumentSupplierSellVO.setTaxMemo(stuffDocumentSupplierEntity.getTaxMemo());
        stuffDocumentSupplierSellVO.setPurchaseType(stuffDocumentEntity.getPurchaseType());
        LambdaQueryWrapper<StuffDocumentSchemeEntity> lambdaScheme = Wrappers.<StuffDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(StuffDocumentSchemeEntity::getDocumentSupplierId, supplierDetailId);
        List<StuffDocumentSchemeEntity> stuffDocumentSchemeEntityList = stuffDocumentSchemeService.list(lambdaScheme);
        List<StuffDocumentSchemeVO> stuffDocumentSchemeVOList = BeanMapper.mapList(stuffDocumentSchemeEntityList, StuffDocumentSchemeVO.class);

        //获取报价方案详情
        LambdaQueryWrapper<StuffDocumentSellEntity> lambdaSell = Wrappers.<StuffDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(StuffDocumentSellEntity::getDocumentId, stuffDocumentSupplierEntity.getDocumentId());
        List<StuffDocumentSellEntity> stuffDocumentSellEntityList = stuffDocumentSellService.list(lambdaSell);
        List<StuffDocumentSellVO> stuffDocumentSellVOList = BeanMapper.mapList(stuffDocumentSellEntityList, StuffDocumentSellVO.class);
        Map<Long, List<StuffDocumentSellVO>> sellMap = stuffDocumentSellVOList.stream().
                collect(Collectors.groupingBy(StuffDocumentSellVO::getSchemeId));
        for (StuffDocumentSchemeVO stuffDocumentSchemeVO : stuffDocumentSchemeVOList) {
            List<StuffDocumentSellVO> stuffDocumentSellVOS = sellMap.get(stuffDocumentSchemeVO.getId());
            stuffDocumentSchemeVO.setStuffDocumentSellList(stuffDocumentSellVOS);
        }
        stuffDocumentSupplierSellVO.setStuffDocumentSchemeList(stuffDocumentSchemeVOList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                stuffDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                stuffDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }

        return stuffDocumentSupplierSellVO;
    }


    @Override
    public StuffDocumentVO queryDocDetail(Long id, Integer talkNum) {

        StuffDocumentEntity entity = super.selectById(id);
        StuffDocumentVO stuffDocumentVO = BeanMapper.map(entity, StuffDocumentVO.class);

        stuffDocumentVO.setStuffDocumentSchemeList(null);
        stuffDocumentVO.setStuffDocumentSellList(null);
        //处理报名供应商信息
        if (stuffDocumentVO.getNoticeId() != null) {
            LambdaQueryWrapper<StuffNoticeSupplierEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(StuffNoticeSupplierEntity::getNoticeId, entity.getNoticeId());
            wrapper.ne(StuffNoticeSupplierEntity::getState, 1);
            List<StuffNoticeSupplierEntity> list = stuffNoticeSupplierService.list(wrapper);//未剔除的报名供应商
            if (CollectionUtils.isNotEmpty(list)) {
                List<StuffNoticeSupplierVO> noticeSupplierVOS = BeanMapper.mapList(list, StuffNoticeSupplierVO.class);//报名供应商
                Map<Long, StuffDocumentSupplierVO> documentSupplierVOMap = new HashMap<>();
                if (CollectionUtils.isNotEmpty(stuffDocumentVO.getStuffDocumentSupplierList())) {//报价供应商
                    documentSupplierVOMap = stuffDocumentVO.getStuffDocumentSupplierList().stream().filter(t -> t.getSupplierId() != null).collect(Collectors.toMap(StuffDocumentSupplierVO::getSupplierId, item -> item, (v1, v2) -> v2));
                }
                for (StuffNoticeSupplierVO noticeSupplier : noticeSupplierVOS) {
                    if (documentSupplierVOMap.containsKey(noticeSupplier.getSupplierId())) {
                        noticeSupplier.setDocumentType(0);//已报价
                    } else {
                        noticeSupplier.setDocumentType(1);//未报价
                    }
                }
                stuffDocumentVO.setStuffDocumentSupplierDetail(noticeSupplierVOS);
            }
        }
        //处理报价信息,开标之前不能显示
        //按供应商查看报价()
        LambdaQueryWrapper<StuffDocumentSupplierEntity> lambda = Wrappers.<StuffDocumentSupplierEntity>lambdaQuery();
        lambda.eq(StuffDocumentSupplierEntity::getDocumentId, id);
        lambda.eq(StuffDocumentSupplierEntity::getTalkNum, talkNum);
        List<StuffDocumentSupplierEntity> supplierList = stuffDocumentSupplierService.list(lambda);

        if (CollectionUtils.isNotEmpty(supplierList)) {
            List<StuffDocumentSupplierVO> stuffDocumentSupplierVOS = BeanMapper.mapList(supplierList, StuffDocumentSupplierVO.class);
            LambdaQueryWrapper<StuffDocumentSchemeEntity> lambdaScheme = Wrappers.<StuffDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(StuffDocumentSchemeEntity::getDocumentId, id);
            lambdaScheme.eq(StuffDocumentSchemeEntity::getTalkNum, talkNum);
            lambdaScheme.orderByAsc(StuffDocumentSchemeEntity::getSchemeName);
            List<StuffDocumentSchemeEntity> schemeList = stuffDocumentSchemeService.list(lambdaScheme);
            Map<Long, List<StuffDocumentSchemeEntity>> schemeMap = schemeList.stream().
                    collect(Collectors.groupingBy(StuffDocumentSchemeEntity::getDocumentSupplierId));
            //是否开标,0-是,1-否
            if (entity.getBidFlag() == 0) {
                for (StuffDocumentSupplierVO stuffDocumentSupplierEntity : stuffDocumentSupplierVOS) {
                    List<StuffDocumentSchemeEntity> stuffDocumentSchemeEntities = schemeMap.get(stuffDocumentSupplierEntity.getId());
                    String schemeMoney = "";
                    for (StuffDocumentSchemeEntity stuffDocumentSchemeEntity : stuffDocumentSchemeEntities) {
                        schemeMoney = schemeMoney + stuffDocumentSchemeEntity.getSchemeName() + ":" + stuffDocumentSchemeEntity.getMoneyTax().setScale(2, BigDecimal.ROUND_HALF_DOWN) + "元" + ";";
                    }
                    int length = schemeMoney.length();
                    String schemeMoneyNew = schemeMoney.substring(0, length - 1);
                    stuffDocumentSupplierEntity.setSchemeMoney(schemeMoneyNew);
                }

                //处理供应商附件信息
                if (CollectionUtils.isNotEmpty(stuffDocumentSupplierVOS)) {
                    List<Long> attachIds = stuffDocumentSupplierVOS.stream().map(StuffDocumentSupplierVO::getId).collect(Collectors.toList());
                    Map<String, List<Long>> map = new HashMap<>();
                    map.put("sourceIds", attachIds);
                    JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
                    CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
                    if (listCommonResponse.isSuccess()) {
                        List<AttachmentVO> data = listCommonResponse.getData();
                        if (CollectionUtils.isNotEmpty(data)) {
                            Map<Long, AttachmentVO> attacMap = data.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                            for (StuffDocumentSupplierVO stuffDocumentSupplierVO : stuffDocumentSupplierVOS) {
                                AttachmentVO attachmentVO = attacMap.get(stuffDocumentSupplierVO.getId());
                                if (attachmentVO != null) {
                                    stuffDocumentSupplierVO.setAttachId(attachmentVO.getId());
                                    stuffDocumentSupplierVO.setFileName(attachmentVO.getFileName());
                                }
                            }
                        }
                    }
                }
            }

            //是否开标,0-是,1-否
//            if (entity.getBidFlag() == 1){
//                for (StuffDocumentSupplierVO stuffDocumentSupplierVO : stuffDocumentSupplierVOS){
//                    stuffDocumentSupplierVO.setRegisterDate(null);
//                }
//            }
            //按供应商查看报价
            stuffDocumentVO.setStuffDocumentSupplierList(stuffDocumentSupplierVOS);
            //前端键值重复设计
            stuffDocumentVO.setStuffDocumentSupplierSchemeList(stuffDocumentSupplierVOS);
            //按材料查看报价
            List<StuffDocumentDetailVO> stuffDocumentDetailList = stuffDocumentVO.getStuffDocumentDetailList();
            //获取材料明细报价
            LambdaQueryWrapper<StuffDocumentSellEntity> lambdaSell = Wrappers.<StuffDocumentSellEntity>lambdaQuery();
            lambdaSell.eq(StuffDocumentSellEntity::getDocumentId, id);
            lambdaSell.eq(StuffDocumentSellEntity::getTalkNum, talkNum);
            lambdaSell.orderByAsc(StuffDocumentSellEntity::getSupplierId);
            lambdaSell.orderByAsc(StuffDocumentSellEntity::getSchemeName);
            List<StuffDocumentSellEntity> sellList = stuffDocumentSellService.list(lambdaSell);
            if (CollectionUtils.isNotEmpty(sellList)) {
                List<StuffDocumentSellVO> stuffDocumentSellVOS = BeanMapper.mapList(sellList, StuffDocumentSellVO.class);
                for (StuffDocumentSellVO stuffDocumentSellVO : stuffDocumentSellVOS) {
                    //是否开标,0-是,1-否
                    if (entity.getBidFlag() == 1) {
                        stuffDocumentSellVO.setPrice(null);
                        stuffDocumentSellVO.setPriceTax(null);
                        stuffDocumentSellVO.setMoney(null);
                        stuffDocumentSellVO.setMoneyTax(null);
                        stuffDocumentSellVO.setSellTax(null);
                        stuffDocumentSellVO.setTenderNum(null);
                        stuffDocumentSellVO.setTenderMoney(null);
                        stuffDocumentSellVO.setTenderFlag(null);
                    }
                    if (entity.getBidFlag() == 0) {
                        stuffDocumentSellVO.setTenderNum(null);
                        stuffDocumentSellVO.setTenderMoney(null);
                        stuffDocumentSellVO.setTenderFlag(null);
                    }
                }
                Map<Long, List<StuffDocumentSellVO>> sellMap = stuffDocumentSellVOS.stream().
                        collect(Collectors.groupingBy(StuffDocumentSellVO::getDetailId));
                for (StuffDocumentDetailVO stuffDocumentDetailVO : stuffDocumentDetailList) {
                    List<StuffDocumentSupplierVO> documentSupplierVOS = new ArrayList<>();
                    List<StuffDocumentSellVO> stuffDocumentSellEntities = sellMap.get(stuffDocumentDetailVO.getId());
//                    Map<Long, List<StuffDocumentSellVO>> sellDetailMap = stuffDocumentSellEntities.stream().
//                            collect(Collectors.groupingBy(StuffDocumentSellVO::getSupplierId));
//                    sellDetailMap.forEach((key, value) -> {
//                        StuffDocumentSupplierVO stuffDocumentSupplierVO = new StuffDocumentSupplierVO();
//                        stuffDocumentSupplierVO.setSupplierId(key);
//                        StuffDocumentSellVO stuffDocumentSellVO = value.stream().findFirst().get();
//                        stuffDocumentSupplierVO.setSupplierName(stuffDocumentSellVO.getSupplierName());
//                        stuffDocumentSupplierVO.setStuffDocumentSellVOList(value);
//                        documentSupplierVOS.add(stuffDocumentSupplierVO);
//                    });
                    //非库供应商和在库供应商单独筛选
                    List<StuffDocumentSellVO> supplierIdVOS = stuffDocumentSellEntities.stream().filter(value -> value.getSupplierId() != null).collect(Collectors.toList());
                    Map<Long, List<StuffDocumentSellVO>> sellDetailMap = supplierIdVOS.stream().
                            collect(Collectors.groupingBy(StuffDocumentSellVO::getSupplierId));
                    sellDetailMap.forEach((key, value) -> {
                        StuffDocumentSupplierVO stuffDocumentSupplierVO = new StuffDocumentSupplierVO();
                        stuffDocumentSupplierVO.setSupplierId(key);
                        StuffDocumentSellVO stuffDocumentSellVO = value.stream().findFirst().get();
                        stuffDocumentSupplierVO.setSupplierName(stuffDocumentSellVO.getSupplierName());
                        stuffDocumentSupplierVO.setStuffDocumentSellVOList(value);
                        documentSupplierVOS.add(stuffDocumentSupplierVO);
                    });


                    List<StuffDocumentSellVO> noSupplierIdVOS = stuffDocumentSellEntities.stream().filter(value -> value.getSupplierId() == null && value.getLinkMobile() != null).collect(Collectors.toList());
                    Map<String, List<StuffDocumentSellVO>> sellDetailNoSupplierIdMap = noSupplierIdVOS.stream().
                            collect(Collectors.groupingBy(StuffDocumentSellVO::getLinkMobile));
                    sellDetailNoSupplierIdMap.forEach((key, value) -> {
                        StuffDocumentSupplierVO stuffDocumentSupplierVO = new StuffDocumentSupplierVO();
                        stuffDocumentSupplierVO.setSupplierId(Long.parseLong(key));
                        StuffDocumentSellVO stuffDocumentSellVO = value.stream().findFirst().get();
                        stuffDocumentSupplierVO.setSupplierName(stuffDocumentSellVO.getSupplierName());
                        stuffDocumentSupplierVO.setStuffDocumentSellVOList(value);
                        documentSupplierVOS.add(stuffDocumentSupplierVO);
                    });
                    stuffDocumentDetailVO.setStuffDocumentSupplierVOList(documentSupplierVOS);
                }
                //区分报价详情信息
                List<StuffDocumentDetailVO> stuffDocumentDetailSellList = stuffDocumentVO.getStuffDocumentDetailList();
                stuffDocumentVO.setStuffDocumentDetailSellList(stuffDocumentDetailSellList);
            }
        }

        return stuffDocumentVO;
    }


    @Override
    public List<StuffDocumentSellVO> getSchemeDetail(StuffDocumentSellVO stuffDocumentSellVO) {
        LambdaQueryWrapper<StuffDocumentSellEntity> lambdaSell = Wrappers.<StuffDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(StuffDocumentSellEntity::getSupplierId, stuffDocumentSellVO.getSupplierId());
        lambdaSell.eq(StuffDocumentSellEntity::getDocumentId, stuffDocumentSellVO.getDocumentId());
        lambdaSell.eq(StuffDocumentSellEntity::getSchemeId, stuffDocumentSellVO.getSchemeId());
        List<StuffDocumentSellEntity> list = stuffDocumentSellService.list(lambdaSell);
        List<StuffDocumentSellVO> stuffDocumentSellVOList = BeanMapper.mapList(list, StuffDocumentSellVO.class);
        return stuffDocumentSellVOList;
    }

    @Override
    public StuffDocumentSupplierSellVO getSupplierSchemeDetail(Long supplierDetailId, Long documentId) {
        StuffDocumentEntity stuffDocumentEntity = super.selectById(documentId);
        StuffDocumentSupplierSellVO stuffDocumentSupplierSellVO = new StuffDocumentSupplierSellVO();
        StuffDocumentSupplierEntity stuffDocumentSupplierEntity = stuffDocumentSupplierService.selectById(supplierDetailId);
        stuffDocumentSupplierSellVO.setLinkName(stuffDocumentSupplierEntity.getLinkName());
        stuffDocumentSupplierSellVO.setSupplierId(stuffDocumentSupplierEntity.getSupplierId());
        stuffDocumentSupplierSellVO.setSupplierName(stuffDocumentSupplierEntity.getSupplierName());
        stuffDocumentSupplierSellVO.setLinkMobile(stuffDocumentSupplierEntity.getLinkMobile());
        stuffDocumentSupplierSellVO.setOfferTime(stuffDocumentSupplierEntity.getOfferTime());
        stuffDocumentSupplierSellVO.setTaxMemo(stuffDocumentSupplierEntity.getTaxMemo());
        stuffDocumentSupplierSellVO.setPurchaseType(stuffDocumentEntity.getPurchaseType());
        stuffDocumentSupplierSellVO.setFloatingType(stuffDocumentEntity.getFloatingType());
        stuffDocumentSupplierSellVO.setValueType(stuffDocumentEntity.getValueType());
        LambdaQueryWrapper<StuffDocumentSchemeEntity> lambdaScheme = Wrappers.<StuffDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(StuffDocumentSchemeEntity::getDocumentSupplierId, supplierDetailId);
        List<StuffDocumentSchemeEntity> stuffDocumentSchemeEntityList = stuffDocumentSchemeService.list(lambdaScheme);
        List<StuffDocumentSchemeVO> stuffDocumentSchemeVOList = BeanMapper.mapList(stuffDocumentSchemeEntityList, StuffDocumentSchemeVO.class);

        //获取报价方案详情
        LambdaQueryWrapper<StuffDocumentSellEntity> lambdaSell = Wrappers.<StuffDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(StuffDocumentSellEntity::getDocumentId, stuffDocumentSupplierEntity.getDocumentId());
        List<StuffDocumentSellEntity> stuffDocumentSellEntityList = stuffDocumentSellService.list(lambdaSell);
        List<StuffDocumentSellVO> stuffDocumentSellVOList = BeanMapper.mapList(stuffDocumentSellEntityList, StuffDocumentSellVO.class);
        Map<Long, List<StuffDocumentSellVO>> sellMap = stuffDocumentSellVOList.stream().
                collect(Collectors.groupingBy(StuffDocumentSellVO::getSchemeId));
        for (StuffDocumentSchemeVO stuffDocumentSchemeVO : stuffDocumentSchemeVOList) {
            List<StuffDocumentSellVO> stuffDocumentSellVOS = sellMap.get(stuffDocumentSchemeVO.getId());
            stuffDocumentSchemeVO.setStuffDocumentSellList(stuffDocumentSellVOS);
        }
        stuffDocumentSupplierSellVO.setStuffDocumentSchemeList(stuffDocumentSchemeVOList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                stuffDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                stuffDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }

        return stuffDocumentSupplierSellVO;
    }

    @Transactional
    @Override
    public StuffDocumentVO extendDocument(StuffDocumentRecordVO stuffDocumentRecordVO) {
        StuffDocumentRecordEntity stuffDocumentRecordEntity = BeanMapper.map(stuffDocumentRecordVO, StuffDocumentRecordEntity.class);
        stuffDocumentRecordService.save(stuffDocumentRecordEntity);
        StuffDocumentEntity stuffDocumentEntity = super.selectById(stuffDocumentRecordVO.getDocumentId());
        stuffDocumentEntity.setOfferEndTime(stuffDocumentRecordVO.getNewTime());
        boolean b = super.updateById(stuffDocumentEntity);

        //推送供方
        SupplierSellVO supplierSellVO = new SupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(stuffDocumentEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(stuffDocumentRecordVO.getNewTime());

        String stringFb = JSONObject.toJSONString(supplierSellVO);
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(updateTimeUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("招标文件同步供方接口报错" + stringCommonResponse.getMsg());
        }

        StuffDocumentVO stuffDocumentVO = queryDetail(stuffDocumentRecordVO.getDocumentId());
        return stuffDocumentVO;
    }

    @Override
    public StuffDocumentSupplierSellVO getSupplierSchemeTalkDetail(Long supplierDetailId, Long talkId) {

        StuffTalkEntity stuffTalkEntity = stuffTalkService.selectById(talkId);
        Integer talkNum = stuffTalkEntity.getTalkNum();
        if (stuffTalkEntity.getPublishFlag() == 1) {
            talkNum = talkNum - 1;
        }
        List<StuffTalkVO> talkVOArrayList = new ArrayList<>();
        String name = null;
        for (int a = 0; a <= talkNum; a++) {
            StuffTalkVO stuffTalkVO = new StuffTalkVO();
            stuffTalkVO.setTalkNum(a);
            if (a == 0) {
                name = "首次报价";
            } else {
                name = "第" + a + "轮报价";
            }
            stuffTalkVO.setTalkNumName(name);
            talkVOArrayList.add(stuffTalkVO);
        }

        StuffDocumentSupplierSellVO stuffDocumentSupplierSellVO = new StuffDocumentSupplierSellVO();
        StuffDocumentSupplierEntity stuffDocumentSupplierEntity = stuffDocumentSupplierService.selectById(supplierDetailId);
        stuffDocumentSupplierSellVO.setLinkName(stuffDocumentSupplierEntity.getLinkName());
        stuffDocumentSupplierSellVO.setLinkMobile(stuffDocumentSupplierEntity.getLinkMobile());
        stuffDocumentSupplierSellVO.setOfferTime(stuffDocumentSupplierEntity.getOfferTime());
        stuffDocumentSupplierSellVO.setTaxMemo(stuffDocumentSupplierEntity.getTaxMemo());
        stuffDocumentSupplierSellVO.setSupplierName(stuffDocumentSupplierEntity.getSupplierName());
        stuffDocumentSupplierSellVO.setFloatingType(stuffTalkEntity.getFloatingType());

        for (StuffTalkVO stuffTalkVO : talkVOArrayList) {
            LambdaQueryWrapper<StuffDocumentSchemeEntity> lambdaScheme = Wrappers.<StuffDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(StuffDocumentSchemeEntity::getDocumentId, stuffDocumentSupplierEntity.getDocumentId());
            lambdaScheme.eq(StuffDocumentSchemeEntity::getSupplierId, stuffDocumentSupplierEntity.getSupplierId());
            lambdaScheme.eq(StuffDocumentSchemeEntity::getTalkNum, stuffTalkVO.getTalkNum());
            List<StuffDocumentSchemeEntity> stuffDocumentSchemeEntityList = stuffDocumentSchemeService.list(lambdaScheme);
            if (CollectionUtils.isEmpty(stuffDocumentSchemeEntityList)) {
                continue;
            }
            List<StuffDocumentSchemeVO> stuffDocumentSchemeVOList = BeanMapper.mapList(stuffDocumentSchemeEntityList, StuffDocumentSchemeVO.class);

            //获取报价方案详情
            List<Long> schemePkList = stuffDocumentSchemeVOList.stream().map(StuffDocumentSchemeVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper<StuffDocumentSellEntity> lambdaSell = Wrappers.<StuffDocumentSellEntity>lambdaQuery();
            lambdaSell.in(StuffDocumentSellEntity::getSchemeId, schemePkList);
            List<StuffDocumentSellEntity> stuffDocumentSellEntityList = stuffDocumentSellService.list(lambdaSell);
            List<StuffDocumentSellVO> stuffDocumentSellVOList = BeanMapper.mapList(stuffDocumentSellEntityList, StuffDocumentSellVO.class);
            Map<Long, List<StuffDocumentSellVO>> sellMap = stuffDocumentSellVOList.stream().
                    collect(Collectors.groupingBy(StuffDocumentSellVO::getSchemeId));
            for (StuffDocumentSchemeVO stuffDocumentSchemeVO : stuffDocumentSchemeVOList) {
                List<StuffDocumentSellVO> stuffDocumentSellVOS = sellMap.get(stuffDocumentSchemeVO.getId());
                stuffDocumentSchemeVO.setStuffDocumentSellList(stuffDocumentSellVOS);
            }
            stuffTalkVO.setStuffDocumentSchemeList(stuffDocumentSchemeVOList);
        }
        stuffDocumentSupplierSellVO.setStuffTalkVOList(talkVOArrayList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                stuffDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                stuffDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }


        return stuffDocumentSupplierSellVO;
    }

    private Map<String, Object> getFileInfo(Long sourceId) {
        Map<String, Object> map = new HashMap<>();
        //查询附件
        CommonResponse<List<AttachmentVO>> attachResponse = attachmentApi.queryListBySourceId(sourceId, BILL_SUPPLIER_TYPE, "supplierFileType", null);
        if (attachResponse.isSuccess()) {
            List<AttachmentVO> data = attachResponse.getData();
            if (CollectionUtils.isNotEmpty(data)) {
                AttachmentVO attachmentVO = data.stream().findFirst().get();
                if (attachmentVO != null) {
                    map.put("fileName", attachmentVO.getFileName());
                    map.put("attachId", attachmentVO.getId());
                }


            }
        }
        return map;
    }

    @Override
    public StuffDocumentVO publishManyDocument(Long id) throws InvocationTargetException, IllegalAccessException {
        //更新发布状态
        StuffDocumentEntity stuffDocumentEntity = super.selectById(id);
        stuffDocumentEntity.setPublishFlag(0);
        super.updateById(stuffDocumentEntity);


        StuffNoticeSupplierTbVO stuffNoticeSupplierTbVO = new StuffNoticeSupplierTbVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        stuffNoticeSupplierTbVO.setSourceType("郑州一建招标文件");
        stuffNoticeSupplierTbVO.setSourceId(stuffDocumentEntity.getInviteId().toString());
        StuffInviteEntity inviteEntity = stuffInviteService.selectById(stuffDocumentEntity.getInviteId());
        if (stuffDocumentEntity.getTenderType() == 2) {
            stuffNoticeSupplierTbVO.setNoticeType(2);
        } else {
            stuffNoticeSupplierTbVO.setNoticeType(3);
        }
        if (stuffDocumentEntity.getPurchaseType() == 1) {
            stuffNoticeSupplierTbVO.setSourceProjectId(null);
            stuffNoticeSupplierTbVO.setProjectName(null);
            stuffNoticeSupplierTbVO.setProjectCode(null);
        } else {
            stuffNoticeSupplierTbVO.setSourceProjectId(stuffDocumentEntity.getProjectId().toString());
            stuffNoticeSupplierTbVO.setProjectName(stuffDocumentEntity.getProjectName());
            stuffNoticeSupplierTbVO.setProjectCode(stuffDocumentEntity.getProjectCode());
        }

        stuffNoticeSupplierTbVO.setSourceOrgId(stuffDocumentEntity.getOrgId().toString());
        stuffNoticeSupplierTbVO.setOrgName(stuffDocumentEntity.getOrgName());
        stuffNoticeSupplierTbVO.setSourceUnitId(stuffDocumentEntity.getUnitId().toString());
        stuffNoticeSupplierTbVO.setUnitName(stuffDocumentEntity.getUnitName());
        stuffNoticeSupplierTbVO.setMemo(stuffDocumentEntity.getMemo());
        stuffNoticeSupplierTbVO.setType("MATERIAL");
        stuffNoticeSupplierTbVO.setTenderName(stuffDocumentEntity.getDocumentName());
        stuffNoticeSupplierTbVO.setTenderType(stuffDocumentEntity.getTenderType());
        stuffNoticeSupplierTbVO.setPurchaseType(stuffDocumentEntity.getPurchaseType().toString());
        stuffNoticeSupplierTbVO.setPurchaseName(stuffDocumentEntity.getPurchaseName());
        stuffNoticeSupplierTbVO.setSourceEmployeeId(stuffDocumentEntity.getEmployeeId().toString());
        stuffNoticeSupplierTbVO.setEmployeeName(stuffDocumentEntity.getEmployeeName());
        stuffNoticeSupplierTbVO.setEmployeeMobile(stuffDocumentEntity.getEmployeeMobile());
        stuffNoticeSupplierTbVO.setValueType(stuffDocumentEntity.getValueType());
        stuffNoticeSupplierTbVO.setContent(stuffDocumentEntity.getDocumentContent());
        stuffNoticeSupplierTbVO.setOfferStartTime(sdf.format(stuffDocumentEntity.getOfferStartTime()));
        stuffNoticeSupplierTbVO.setOfferEndTime(sdf.format(stuffDocumentEntity.getOfferEndTime()));
        stuffNoticeSupplierTbVO.setBrandFlag(stuffDocumentEntity.getBrandFlag());
        stuffNoticeSupplierTbVO.setProjectLinkName(stuffDocumentEntity.getProjectLinkName());
        stuffNoticeSupplierTbVO.setProjectLinkPhone(stuffDocumentEntity.getProjectLinkPhone());
        stuffNoticeSupplierTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        stuffNoticeSupplierTbVO.setMaterialContentId(inviteEntity.getPurchaseId());
        stuffNoticeSupplierTbVO.setMaterialContent(inviteEntity.getPurchaseName());

        stuffNoticeSupplierTbVO.setFloatingType(stuffDocumentEntity.getFloatingType());
        stuffNoticeSupplierTbVO.setSettlementClause(inviteEntity.getSettlementClause());

        //插入物资
        List<StuffNoticeDetailTbVO> stuffNoticeDetailVOS = new ArrayList<>();
        List<StuffDocumentDetailVO> documentDetailEntityList = baseMapper.selectSumDetail(stuffDocumentEntity.getId());
        for (StuffDocumentDetailVO stuffDocumentDetailEntity : documentDetailEntityList) {
            StuffNoticeDetailTbVO stuffNoticeDetailTbVO = new StuffNoticeDetailTbVO();
            BeanUtils.copyProperties(stuffNoticeDetailTbVO, stuffDocumentDetailEntity);
            stuffNoticeDetailTbVO.setMemo(stuffDocumentDetailEntity.getSumMemo());
            stuffNoticeDetailTbVO.setNum(stuffDocumentDetailEntity.getSumNum());
            stuffNoticeDetailTbVO.setMoney(stuffDocumentDetailEntity.getSumMoney());
            stuffNoticeDetailTbVO.setMoneyTax(stuffDocumentDetailEntity.getSumMoneyTax());
            stuffNoticeDetailTbVO.setSourceId(stuffDocumentEntity.getInviteId().toString());
            stuffNoticeDetailTbVO.setSourceMaterialId(stuffDocumentDetailEntity.getMaterialId() == null ? null : stuffDocumentDetailEntity.getMaterialId().toString());
            stuffNoticeDetailTbVO.setSourceMaterialTypeId(stuffDocumentDetailEntity.getMaterialTypeId().toString());
            stuffNoticeDetailVOS.add(stuffNoticeDetailTbVO);
        }
        stuffNoticeSupplierTbVO.setDetailList(stuffNoticeDetailVOS);
        //是否是邀请招标
        if (stuffDocumentEntity.getTenderType() != 2) {
            List<StuffDocumentSupplierDetailEntity> detailEntityList = supplierDetailService.list(new LambdaQueryWrapper<StuffDocumentSupplierDetailEntity>().eq(StuffDocumentSupplierDetailEntity::getInviteId, stuffDocumentEntity.getInviteId()).eq(StuffDocumentSupplierDetailEntity::getDr, 0));
            List<StuffNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
            for (StuffDocumentSupplierDetailEntity supplierDetailEntity : detailEntityList) {
                StuffNoticeSupplierDetailTbVO stuffNoticeSupplierDetailTbVO = new StuffNoticeSupplierDetailTbVO();
                stuffNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
                stuffNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
                //todo
//                HashMap<Long, Long> hashMap = new HashMap<>();
//                hashMap.put(1406947724700246112L,1471726626618441730L);
//                hashMap.put(1406947724700246113L,1471729176256151553L);
//                hashMap.put(1406947724700246114L,1471731643794554881L);
//                hashMap.put(527888337260777477L,1472852233918054402L);
//
//                //云南建设总承包公司测试用户
//                hashMap.put(528220972239556690L,1473189202070044674L);
//                hashMap.put(528222266413027386L,1473189172567310338L);
//                hashMap.put(528222429273657395L,1473189113180160002L);
//                hashMap.put(528222690796900362L,1473190529172996098L);
                stuffNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));

                supplierDetailTbVOList.add(stuffNoticeSupplierDetailTbVO);
            }
            stuffNoticeSupplierTbVO.setApplyList(supplierDetailTbVOList);
        }
        String stringFb = JSONObject.toJSONString(stuffNoticeSupplierTbVO);
        //调用第三方报名接口
//        CommonResponse<JSONObject> response = null;
//        logger.info("发布内容"+stringFb);
//        try {
//            response = new ThirdSystemUtils().sendPostReq(tokenUrl,saveOrUpdateUrl, stringFb,cacheManager);
//            if(!response.isSuccess()) {
//                throw new BusinessException("招标文件同步供方接口报错" + response.getMsg());
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            throw new BusinessException("招标文件同步供方接口报错" + response.getMsg());
//        }
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
            if (!response.isSuccess()) {
                throw new BusinessException("招标文件同步供方接口报错" + response.getMsg());
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("招标文件同步供方接口报错" + response.getMsg());
        }
        return queryDetail(id);
    }

    @Override
    public CommonResponse delSupplier(Long id) {
        StuffDocumentEntity stuffDocumentEntity = baseMapper.selectById(id);
        List<StuffDocumentSupplierEntity> stuffDocumentSupplierList = supplierMapper.selectList(new QueryWrapper<StuffDocumentSupplierEntity>().eq("document_id", stuffDocumentEntity.getId()).eq("dr", 0));
        List<StuffDocumentSupplierDetailEntity> supplierDetailList = supplierDetailMapper.selectList(new QueryWrapper<StuffDocumentSupplierDetailEntity>().eq("invite_id", stuffDocumentEntity.getInviteId()).eq("dr", 0));
        List<Long> oldIds = new ArrayList<>();
        List<Long> newIds = new ArrayList<>();
        stuffDocumentSupplierList.stream().forEach(it -> oldIds.add(it.getSupplierId()));
        supplierDetailList.stream().forEach(it -> newIds.add(it.getSupplierId()));
        List<Long> newId = newIds.stream().filter(it -> !oldIds.contains(it)).collect(Collectors.toList());
        List<StuffDocumentSupplierDetailEntity> newRequestList = supplierDetailList.stream().filter(it -> newId.contains(it.getSupplierId())).collect(Collectors.toList());
        //装填数据
        List<StuffNoticeSupplierDetailTbVO> signVOList = new ArrayList<>();
        for (StuffDocumentSupplierDetailEntity supplierDetailEntity : newRequestList) {
            StuffNoticeSupplierDetailTbVO stuffNoticeSupplierDetailTbVO = new StuffNoticeSupplierDetailTbVO();
            stuffNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
            stuffNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
            //todo
//            HashMap<Long, Long> hashMap = new HashMap<>();
//            hashMap.put(1406947724700246112L,1471726626618441730L);
//            hashMap.put(1406947724700246113L,1471729176256151553L);
//            hashMap.put(1406947724700246114L,1471731643794554881L);
//            hashMap.put(527888337260777477L,1472852233918054402L);
//
//            //云南建设总承包公司测试用户
//            hashMap.put(528220972239556690L,1473189202070044674L);
//            hashMap.put(528222266413027386L,1473189172567310338L);
//            hashMap.put(528222429273657395L,1473189113180160002L);stuffEvaluation/queryGatherList
//            hashMap.put(528222690796900362L,1473190529172996098L);
            stuffNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));

            stuffNoticeSupplierDetailTbVO.setOutReason("超时未报价");
            signVOList.add(stuffNoticeSupplierDetailTbVO);
        }
        logger.info("剔除的供应商" + JSON.toJSONString(signVOList));
        //调用第三方接口
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, JSON.toJSONString(signVOList), appId, appSecret, appHost);
            if (!response.isSuccess()) {
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        } catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        return CommonResponse.success("剔除供应商成功");
    }

    @Override
    public StuffDocumentVO saveManyDocument(Long id) {
        StuffDocumentEntity stuffDocumentEntity = new StuffDocumentEntity();
        //查询招标主表信息
        StuffInviteEntity inviteEntity = stuffInviteService.selectById(id);
        //复制主表
        stuffDocumentEntity.setInviteId(inviteEntity.getId());
        stuffDocumentEntity.setDocumentName(inviteEntity.getTenderName());
        if (inviteEntity.getPurchaseType() == 0) {
            stuffDocumentEntity.setProjectId(inviteEntity.getProjectId());
            stuffDocumentEntity.setProjectName(inviteEntity.getProjectName());
            stuffDocumentEntity.setProjectCode(inviteEntity.getProjectCode());
        }
        stuffDocumentEntity.setPurchaseId(inviteEntity.getPurchaseId());
        stuffDocumentEntity.setPurchaseName(inviteEntity.getPurchaseName());
        stuffDocumentEntity.setPurchaseType(inviteEntity.getPurchaseType());
        stuffDocumentEntity.setOrgId(inviteEntity.getOrgId());
        stuffDocumentEntity.setOrgName(inviteEntity.getOrgName());
        stuffDocumentEntity.setParentOrgId(inviteEntity.getParentOrgId());
        stuffDocumentEntity.setParentOrgName(inviteEntity.getParentOrgName());
        stuffDocumentEntity.setValueType(inviteEntity.getValueType());
        stuffDocumentEntity.setUnitId(inviteEntity.getUnitId());
        stuffDocumentEntity.setUnitName(inviteEntity.getUnitName());
        stuffDocumentEntity.setTenderType(inviteEntity.getTenderType());
        stuffDocumentEntity.setFloatingType(inviteEntity.getFloatingType());
        stuffDocumentEntity.setSettlementClause(inviteEntity.getSettlementClause());

        //设置计价方式
        stuffDocumentEntity.setBidFlag(1);
        stuffDocumentEntity.setPublishFlag(1);
        stuffDocumentEntity.setNextFlag(1);


        //复制物资详情
        List<StuffInviteDetailEntity> stuffNoticeDetailList = inviteEntity.getStuffDetail();
        List<StuffDocumentDetailEntity> stuffDocumentDetailList = BeanMapper.mapList(stuffNoticeDetailList, StuffDocumentDetailEntity.class);
        for (StuffDocumentDetailEntity stuffDocumentDetailEntity : stuffDocumentDetailList) {
            stuffDocumentDetailEntity.setId(null);
        }
        stuffDocumentEntity.setStuffDocumentDetailList(stuffDocumentDetailList);

        //复制供应商
        List<StuffInviteSupplierEntity> supplierDetailList = inviteEntity.getSupplierDetail();
        List<StuffDocumentSupplierDetailEntity> stuffDocumentSupplierDetailVOS = BeanMapper.mapList(supplierDetailList, StuffDocumentSupplierDetailEntity.class);
        for (StuffDocumentSupplierDetailEntity stuffDocumentSupplierDetailVO : stuffDocumentSupplierDetailVOS) {
            stuffDocumentSupplierDetailVO.setId(null);
            documentSupplierDetailService.saveOrUpdate(stuffDocumentSupplierDetailVO);
        }

        service.saveOrUpdate(stuffDocumentEntity, false);

        ProcessEntity processEntity = new ProcessEntity();
        //回写招标阶段
        switch (inviteEntity.getTenderType()) {
            case 3:
                inviteEntity.setTenderStage(6);
                processEntity.setBillName("竞争性谈判");
                break;
            case 4:
                inviteEntity.setTenderStage(8);
                processEntity.setBillName("单一来源");
                break;
            case 5:
                inviteEntity.setTenderStage(9);
                processEntity.setBillName("紧急招标");
                break;
            case 2:
                inviteEntity.setTenderStage(10);
                processEntity.setBillName("询价公告");
                break;
        }
        stuffInviteService.updateById(inviteEntity);
        //回写进展表
        processEntity.setBillId(stuffDocumentEntity.getId());
        processEntity.setTenderId(id);
        processEntity.setType(0);
        processEntity.setFrontendUrl("stuff/fourJzDyJjXj");
        processService.saveOrUpdate(processEntity);
        StuffDocumentVO vo = BeanMapper.map(stuffDocumentEntity, StuffDocumentVO.class);
        return vo;
    }

    @Override
    public StuffDocumentSupplierSellVO getSupplierSchemeDetailTalk(Long supplierDetailId, Long talkId) {
        //获取轮数
        StuffTalkRecordEntity stuffTalkRecordEntity = stuffTalkRecordService.selectById(talkId);
        Integer talkNum = stuffTalkRecordEntity.getTalkNum();
        if (stuffTalkRecordEntity.getPublishFlag() == 1) {
            talkNum = talkNum - 1;
        }

        //
        StuffDocumentSupplierSellVO stuffDocumentSupplierSellVO = new StuffDocumentSupplierSellVO();
        StuffDocumentSupplierEntity stuffDocumentSupplierEntity = stuffDocumentSupplierService.selectById(supplierDetailId);
        stuffDocumentSupplierSellVO.setLinkName(stuffDocumentSupplierEntity.getLinkName());
        stuffDocumentSupplierSellVO.setLinkMobile(stuffDocumentSupplierEntity.getLinkMobile());
        stuffDocumentSupplierSellVO.setOfferTime(stuffDocumentSupplierEntity.getOfferTime());
        stuffDocumentSupplierSellVO.setTaxMemo(stuffDocumentSupplierEntity.getTaxMemo());
        LambdaQueryWrapper<StuffDocumentSchemeEntity> lambdaScheme = Wrappers.<StuffDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(StuffDocumentSchemeEntity::getDocumentSupplierId, supplierDetailId);
        List<StuffDocumentSchemeEntity> stuffDocumentSchemeEntityList = stuffDocumentSchemeService.list(lambdaScheme);
        List<StuffDocumentSchemeVO> stuffDocumentSchemeVOList = BeanMapper.mapList(stuffDocumentSchemeEntityList, StuffDocumentSchemeVO.class);

        //获取报价方案详情
        LambdaQueryWrapper<StuffDocumentSellEntity> lambdaSell = Wrappers.<StuffDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(StuffDocumentSellEntity::getDocumentId, stuffDocumentSupplierEntity.getDocumentId());
        lambdaSell.eq(StuffDocumentSellEntity::getTalkNum, talkNum);
        List<StuffDocumentSellEntity> stuffDocumentSellEntityList = stuffDocumentSellService.list(lambdaSell);
        List<StuffDocumentSellVO> stuffDocumentSellVOList = BeanMapper.mapList(stuffDocumentSellEntityList, StuffDocumentSellVO.class);
        Map<Long, List<StuffDocumentSellVO>> sellMap = stuffDocumentSellVOList.stream().
                collect(Collectors.groupingBy(StuffDocumentSellVO::getSchemeId));
        for (StuffDocumentSchemeVO stuffDocumentSchemeVO : stuffDocumentSchemeVOList) {
            List<StuffDocumentSellVO> stuffDocumentSellVOS = sellMap.get(stuffDocumentSchemeVO.getId());
            stuffDocumentSchemeVO.setStuffDocumentSellList(stuffDocumentSellVOS);
        }
        stuffDocumentSupplierSellVO.setStuffDocumentSchemeList(stuffDocumentSchemeVOList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                stuffDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                stuffDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }


        return stuffDocumentSupplierSellVO;
    }

    @Override
    public StuffDocumentVO saveDocument(Long noticeId) {
        StuffDocumentEntity entity = new StuffDocumentEntity();
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //查询公告主表信息
        StuffNoticeEntity stuffNoticeEntity = stuffNoticeService.selectById(noticeId);
        //复制物资详情
        List<StuffNoticeDetailEntity> stuffNoticeDetailList = stuffNoticeEntity.getNoticeDetail();
        List<StuffDocumentDetailEntity> stuffDocumentDetailList = BeanMapper.mapList(stuffNoticeDetailList, StuffDocumentDetailEntity.class);
        for (StuffDocumentDetailEntity stuffDocumentDetailEntity : stuffDocumentDetailList) {
            stuffDocumentDetailEntity.setId(null);
        }
        entity.setStuffDocumentDetailList(stuffDocumentDetailList);

        //复制主表信息
        entity.setProjectId(stuffNoticeEntity.getProjectId());
        entity.setNoticeId(noticeId);
        entity.setProjectName(stuffNoticeEntity.getProjectName());
        entity.setOrgId(stuffNoticeEntity.getOrgId());
        entity.setOrgName(stuffNoticeEntity.getOrgName());
        entity.setParentOrgId(stuffNoticeEntity.getParentOrgId());
        entity.setParentOrgName(stuffNoticeEntity.getParentOrgName());
        entity.setProjectCode(stuffNoticeEntity.getProjectCode());
        entity.setDocumentName(stuffNoticeEntity.getNoticeName());
        entity.setEmployeeId(stuffNoticeEntity.getEmployeeId());
        entity.setEmployeeName(stuffNoticeEntity.getEmployeeName());
        entity.setEmployeeMobile(stuffNoticeEntity.getEmployeeMobile());
        entity.setInviteId(stuffNoticeEntity.getInviteId());
        entity.setPurchaseId(stuffNoticeEntity.getPurchaseId());
        entity.setPurchaseName(stuffNoticeEntity.getPurchaseName());
        entity.setPurchaseType(stuffNoticeEntity.getPurchaseType());
        entity.setTenderType(stuffNoticeEntity.getTenderType());
        entity.setFloatingType(stuffNoticeEntity.getFloatingType());
        //设置计价方式
        StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(stuffNoticeEntity.getInviteId());
        entity.setValueType(stuffInviteEntity.getValueType());
        entity.setBidFlag(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);

        service.saveOrUpdate(entity, false);

        //回写招标阶段
        stuffInviteEntity.setTenderStage(3);
        stuffInviteService.updateById(stuffInviteEntity);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("招标文件");
        processEntity.setTenderId(stuffNoticeEntity.getInviteId());
        processEntity.setType(0);
        processEntity.setFrontendUrl("stuff/document");
        processService.saveOrUpdate(processEntity);
        StuffDocumentVO vo = BeanMapper.map(entity, StuffDocumentVO.class);
        return vo;
    }

    @Override
    public SupplierDTO querySupplierIdByTaxPayerIdentifier(String taxPayerIdentifier) {
        SupplierDTO data = shareSupplierApi.selectByTaxpayerNum(taxPayerIdentifier).getData();
        return data;
    }

    @Override
    public Boolean checkDetail(Long supplierId, Long documentId, String phone) {
        List<StuffDocumentSellEntity> list = new ArrayList<>();
        if (supplierId != null) {
            list = stuffDocumentSellService.list(Wrappers.<StuffDocumentSellEntity>lambdaQuery()
                    .eq(StuffDocumentSellEntity::getDr, 0)
                    .eq(StuffDocumentSellEntity::getDocumentId, documentId)
                    .eq(StuffDocumentSellEntity::getSupplierId, supplierId)
            );
        } else {
            list = stuffDocumentSellService.list(Wrappers.<StuffDocumentSellEntity>lambdaQuery()
                    .eq(StuffDocumentSellEntity::getDr, 0)
                    .eq(StuffDocumentSellEntity::getDocumentId, documentId)
                    .eq(StuffDocumentSellEntity::getLinkMobile, phone)
            );
        }

        if (ListUtil.isNotEmpty(list)) {
            return list.size() >= 1;
        }
        return false;
    }

    @Override
    public List<StuffDocumentSellVO> queryDetailSell(Long supplierId, Long documentId, Long phone) {
        //非库供应商和在库供应商分别用手机号和supplierId去查
        List<StuffDocumentSellEntity> sellEntities = new ArrayList<>();
        if (supplierId != null) {
            sellEntities = stuffDocumentSellService.list(Wrappers.<StuffDocumentSellEntity>lambdaQuery()
                    .eq(StuffDocumentSellEntity::getDr, 0)
                    .eq(StuffDocumentSellEntity::getSupplierId, supplierId)
                    .eq(StuffDocumentSellEntity::getDocumentId, documentId)
            );
        } else {
            sellEntities = stuffDocumentSellService.list(Wrappers.<StuffDocumentSellEntity>lambdaQuery()
                    .eq(StuffDocumentSellEntity::getDr, 0)
                    .eq(StuffDocumentSellEntity::getDocumentId, documentId)
                    .eq(StuffDocumentSellEntity::getLinkMobile, phone)
            );
        }
        List<StuffDocumentSellVO> sellVOS = BeanMapper.mapList(sellEntities, StuffDocumentSellVO.class);

        if (ListUtil.isNotEmpty(sellVOS)) {
            return sellVOS;
        }
        return null;
    }

    @Override
    public CommonResponse<Boolean> checkExpertNum(Long documentId) {
        //根据documentId查询数据库中专家数量
        List<StuffDocumentExpertEntity> expertEntityList = documentExpertService.list(Wrappers.<StuffDocumentExpertEntity>lambdaQuery()
                .eq(StuffDocumentExpertEntity::getDocumentId, documentId)
                .eq(StuffDocumentExpertEntity::getDr, 0)
        );
        int totalNum = expertEntityList.size();
        if(totalNum < 3){
            return CommonResponse.error("所选专家数量至少为3人！",false);
        }
        //判断专家数量是否为单数
        if(totalNum % 2 == 0){
            return CommonResponse.error("所选专家数量必须为单数！",false);
        }

        /**
         * !!!数据量大时会损失精度，目前业务不可能超过，所以进行强制转换
         */
        //筛选出库中集团、项目专家数量
        int departmentExpertNum = (int)expertEntityList.stream().filter(entity -> "集团".equals(entity.getExpertFromName())).count();
        int projectExpertNum = (int)expertEntityList.stream().filter(entity -> "项目".equals(entity.getExpertFromName())).count();
        //实际需要的数量
        int trueDepartmentExpertNum = (int)Math.ceil(totalNum * 1.0 / 3);
        int trueProjectExpertNum = totalNum - trueDepartmentExpertNum;
        if(departmentExpertNum != trueDepartmentExpertNum || projectExpertNum != trueProjectExpertNum){
            return CommonResponse.error("所选专家数量不符合要求！" +
                    "集团专家" + trueDepartmentExpertNum + "个," +
                    "项目专家" + trueProjectExpertNum + "个！",false);
        }
        return CommonResponse.success("专家选取成功！",true);
    }


    @Override
    public CommonResponse<Boolean> synSupplier(Long documentId) {

        //从报价详情表查找supplierId为空的供应商
        List<StuffDocumentSellEntity> stuffDocumentSellEntities = stuffDocumentSellService.list(Wrappers.<StuffDocumentSellEntity>lambdaQuery()
                .eq(StuffDocumentSellEntity::getDocumentId, documentId)
                .isNull(StuffDocumentSellEntity::getSupplierId)
        );
        if(ListUtil.isNotEmpty(stuffDocumentSellEntities)){
            //查找供应商为空的手机号
            List<String> phones = stuffDocumentSellEntities.stream().map(StuffDocumentSellEntity::getLinkMobile).collect(Collectors.toList());
            Map<String, Long> stuffDocumentSchemeIdMap = stuffDocumentSellEntities.stream().collect(Collectors.toMap(StuffDocumentSellEntity::getLinkMobile, StuffDocumentSellEntity::getSchemeId));

            //根据手机号查找纳税人识别号
            List<StuffCheckEntity> list = stuffCheckService.list(Wrappers.<StuffCheckEntity>lambdaQuery()
                    .in(StuffCheckEntity::getPhone, phones)
                    .eq(StuffCheckEntity::getDocumentId,documentId)
            );
            boolean updateDocumentSell = false;
            boolean updateDocumentScheme = false;
            boolean updateDocumentSupplier = false;
            //map<手机号，纳税人识别号>转化为<手机号，供应商id>
            Map<Long, String> taxPayerIdentifierMap = list.stream().collect(Collectors.toMap(StuffCheckEntity::getPhone, StuffCheckEntity::getTaxPayerIdentifier));
            for (Map.Entry<Long, String> entry : taxPayerIdentifierMap.entrySet()) {
                CommonResponse<SupplierDTO> supplierDTOCommonResponse = shareSupplierApi.selectByTaxpayerNum(entry.getValue());
                if(supplierDTOCommonResponse.isSuccess()){
                    SupplierDTO supplierDTO = supplierDTOCommonResponse.getData();
                    if(supplierDTO.getTenant() == null){
                        return CommonResponse.error("供应商邀请准入后，请先进行供方协同！");
                    }
                    entry.setValue(supplierDTO.getId().toString());
                    updateDocumentSell = stuffDocumentSellService.update(Wrappers.<StuffDocumentSellEntity>lambdaUpdate()
                            .set(StuffDocumentSellEntity::getSupplierTenantId,supplierDTO.getTenant())
                            .set(StuffDocumentSellEntity::getSupplierId, supplierDTO.getId())
                            .eq(StuffDocumentSellEntity::getDocumentId, documentId)
                            .isNull(StuffDocumentSellEntity::getSupplierId)
                            .eq(StuffDocumentSellEntity::getLinkMobile, entry.getKey().toString())
                    );
                    logger.info("供应商id同步报价详情表{}",updateDocumentSell);

                    updateDocumentScheme = stuffDocumentSchemeService.update(Wrappers.<StuffDocumentSchemeEntity>lambdaUpdate()
                            .set(StuffDocumentSchemeEntity::getSupplierTenantId,supplierDTO.getTenant())
                            .set(StuffDocumentSchemeEntity::getSupplierId, supplierDTO.getId())
                            .eq(StuffDocumentSchemeEntity::getDocumentId, documentId)
                            .isNull(StuffDocumentSchemeEntity::getSupplierId)
                            .eq(StuffDocumentSchemeEntity::getId, stuffDocumentSchemeIdMap.get(entry.getKey().toString()))
                    );
                    logger.info("供应商id同步报价方案表{}",updateDocumentScheme);

                    updateDocumentSupplier = stuffDocumentSupplierService.update(Wrappers.<StuffDocumentSupplierEntity>lambdaUpdate()
                            .set(StuffDocumentSupplierEntity::getSupplierId, supplierDTO.getId())
                            .set(StuffDocumentSupplierEntity::getSupplierTenantId,supplierDTO.getTenant())
                            .eq(StuffDocumentSupplierEntity::getDocumentId, documentId)
                            .isNull(StuffDocumentSupplierEntity::getSupplierId)
                            .eq(StuffDocumentSupplierEntity::getLinkMobile, entry.getKey().toString())
                    );
                    logger.info("供应商id同步供应商表{}",updateDocumentSupplier);

//                    updateDocumentSupplier = stuffPicketageSupplierService.update(Wrappers.<StuffPicketageSupplierEntity>lambdaUpdate()
//                            .set(StuffPicketageSupplierEntity::getSupplierId, supplierDTO.getId())
//                            .eq(StuffPicketageSupplierEntity::getPicketageId, picketageId)
//                            .isNull(StuffPicketageSupplierEntity::getSupplierId)
//                            .eq(StuffDocumentSupplierEntity::getLinkMobile, entry.getKey().toString())
//                    );
//                    logger.info("供应商id同步供应商表{}",updateDocumentSupplier);

                }
                else {
                    return CommonResponse.error("请先进行供应商邀请进行准入！");
                }
            }
            if(updateDocumentSell && updateDocumentScheme && updateDocumentSupplier){
                return CommonResponse.success("供应商信息同步成功！");
            } else {
                return CommonResponse.error("供应商信息同步失败！");
            }
        }
        return CommonResponse.success("供应商信息完整,无需同步！");

    }
    @Override
    public CommonResponse<Boolean> synZcwSupplier(Long documentId) {

        //从报价详情表查找isZcw为1的供应商
        List<StuffDocumentSellEntity> stuffDocumentSellEntitiesZcw = stuffDocumentSellService.list(Wrappers.<StuffDocumentSellEntity>lambdaQuery()
                .eq(StuffDocumentSellEntity::getDocumentId, documentId)
                .eq(StuffDocumentSellEntity::getIsZcw,1)
        );

        if(ListUtil.isNotEmpty(stuffDocumentSellEntitiesZcw)){
            //筑材网的供应商id，筑材网的供应商id对应税号
            List<Long> supplierIds = stuffDocumentSellEntitiesZcw.stream().map(StuffDocumentSellEntity::getSupplierId).collect(Collectors.toList());
            ArrayList<StuffDocumentSellEntity> collect = stuffDocumentSellEntitiesZcw.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(
                    Comparator.comparing(StuffDocumentSellEntity::getSupplierId))), ArrayList::new));
            Map<Long, String> stuffDocumentTaxNumMap = collect.stream().collect(Collectors.toMap(StuffDocumentSellEntity::getSupplierId, StuffDocumentSellEntity::getTaxpayerNum));

            boolean updateDocumentSell = false;
            boolean updateDocumentScheme = false;
            boolean updateDocumentSupplier = false;
            boolean updateNoticeSupplier = false;

            //map<筑材网的供应商id，纳税人识别号>转化为<筑材网的供应商id，供应商id>
            for (Map.Entry<Long, String> entry : stuffDocumentTaxNumMap.entrySet()) {
                CommonResponse<SupplierDTO> supplierDTOCommonResponse = shareSupplierApi.selectByTaxpayerNum(entry.getValue());
                if(supplierDTOCommonResponse.isSuccess()){
                    SupplierDTO supplierDTO = supplierDTOCommonResponse.getData();
                    if(supplierDTO.getTenant() == null){
                        return CommonResponse.error("供应商邀请准入后，请先进行供方协同！");
                    }
                    entry.setValue(supplierDTO.getId().toString());
                    updateDocumentSell = stuffDocumentSellService.update(Wrappers.<StuffDocumentSellEntity>lambdaUpdate()
                            .set(StuffDocumentSellEntity::getSupplierTenantId,supplierDTO.getTenant())
                            .set(StuffDocumentSellEntity::getSupplierId, supplierDTO.getId())
                            .eq(StuffDocumentSellEntity::getDocumentId, documentId)
                            .eq(StuffDocumentSellEntity::getIsZcw,1)
                            .eq(StuffDocumentSellEntity::getSupplierId, entry.getKey().toString())
                    );
                    logger.info("供应商id同步报价详情表{}",updateDocumentSell);

                    updateDocumentScheme = stuffDocumentSchemeService.update(Wrappers.<StuffDocumentSchemeEntity>lambdaUpdate()
                            .set(StuffDocumentSchemeEntity::getSupplierTenantId,supplierDTO.getTenant())
                            .set(StuffDocumentSchemeEntity::getSupplierId, supplierDTO.getId())
                            .eq(StuffDocumentSchemeEntity::getDocumentId, documentId)
                            .eq(StuffDocumentSchemeEntity::getIsZcw,1)
                            .eq(StuffDocumentSchemeEntity::getSupplierId, entry.getKey().toString())
                    );
                    logger.info("供应商id同步报价方案表{}",updateDocumentScheme);

                    updateDocumentSupplier = stuffDocumentSupplierService.update(Wrappers.<StuffDocumentSupplierEntity>lambdaUpdate()
                            .set(StuffDocumentSupplierEntity::getSupplierId, supplierDTO.getId())
                            .set(StuffDocumentSupplierEntity::getSupplierTenantId,supplierDTO.getTenant())
                            .eq(StuffDocumentSupplierEntity::getDocumentId, documentId)
                            .eq(StuffDocumentSupplierEntity::getIsZcw,1)
                            .eq(StuffDocumentSupplierEntity::getSupplierId, entry.getKey().toString())
                    );
                    logger.info("供应商id同步供应商表{}",updateDocumentSupplier);

                    updateNoticeSupplier = stuffNoticeSupplierService.update(Wrappers.<StuffNoticeSupplierEntity>lambdaUpdate()
                            .set(StuffNoticeSupplierEntity::getSupplierId, supplierDTO.getId())
                            .set(StuffNoticeSupplierEntity::getSourceSupplierId, supplierDTO.getId()+"")
                            .set(StuffNoticeSupplierEntity::getSourceSupplierTenantId,supplierDTO.getTenant())
                            .eq(StuffNoticeSupplierEntity::getIsZcw,1)
                            .eq(StuffNoticeSupplierEntity::getSupplierId, entry.getKey().toString())
                    );
                    logger.info("供应商id同步公告报名供应商表{}",updateNoticeSupplier);


//                    updateDocumentSupplier = stuffPicketageSupplierService.update(Wrappers.<StuffPicketageSupplierEntity>lambdaUpdate()
//                            .set(StuffPicketageSupplierEntity::getSupplierId, supplierDTO.getId())
//                            .eq(StuffPicketageSupplierEntity::getPicketageId, picketageId)
//                            .isNull(StuffPicketageSupplierEntity::getSupplierId)
//                            .eq(StuffDocumentSupplierEntity::getLinkMobile, entry.getKey().toString())
//                    );
//                    logger.info("供应商id同步供应商表{}",updateDocumentSupplier);

                }
                else {
                    return CommonResponse.error("请先进行供应商邀请进行准入！");
                }
            }
            if(updateDocumentSell && updateDocumentScheme && updateDocumentSupplier && updateNoticeSupplier){
                return CommonResponse.success("供应商信息同步成功！");
            } else {
                return CommonResponse.error("供应商信息同步失败！");
            }
        }
        return CommonResponse.success("供应商信息完整,无需同步！");

    }

    @Override
    public void zcwDetail(StuffDocumentEntity stuffDocumentEntity){
        StuffDocumentVO stuffDocumentVO1 = queryDetail(stuffDocumentEntity.getId());
        StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(stuffDocumentEntity.getInviteId());
        List<StuffInviteDetailEntity> stuffDetail = stuffInviteEntity.getStuffDetail();
        //立项子表id对应物资id
        Map<Long, Long> collect1 = stuffDetail.stream().collect(Collectors.toMap(StuffInviteDetailEntity::getId, StuffInviteDetailEntity::getMaterialId, (value1, value2) -> value1));


        List<StuffDocumentDetailVO> stuffDocumentDetailList = stuffDocumentVO1.getStuffDocumentDetailList();
        //物资id对应
        Map<Long, StuffDocumentDetailVO> collect2 = stuffDocumentDetailList.stream().collect(Collectors.toMap(StuffDocumentDetailVO::getMaterialId, Function.identity()));

        if(stuffInviteEntity != null && stuffInviteEntity.getIsPushZcw() == 1){
            //如果已经推送筑材网，则去查询筑材网的报价详情
            JSONObject param = new JSONObject();
            param.put("bidNum",stuffInviteEntity.getZcwCode());
            String responseBody = systemRequestService.sendPostRequest("bid/detailBid", param);
            JSONObject jsonObject = JSONObject.parseObject(responseBody);
            Integer code = jsonObject.getInteger("code");
            List<DetailBidVO> detailBidVOS = null;
            List<ProductsVO> productsVOS = null;
            if (code == 0  ){
                detailBidVOS = JSONObject.parseArray(jsonObject.getJSONObject("object").getString("bidReplyList"), DetailBidVO.class);
                productsVOS = JSONObject.parseArray(jsonObject.getJSONObject("object").getString("products"), ProductsVO.class);
                Map<Integer, String> collect = new HashMap<>();
                if (ListUtil.isNotEmpty(productsVOS)) {
                    collect = productsVOS.stream().collect(Collectors.toMap(ProductsVO::getProductId, ProductsVO::getBizKey, (value1, value2) -> value1));
                }
                if (ListUtil.isNotEmpty(detailBidVOS)){
                    for (DetailBidVO detailBidVO : detailBidVOS) {
                        SupplierSellVO supplierSellVO = new SupplierSellVO();
                        List<SupplierSellSchemeVO> schemeList = new ArrayList<>();
                        SupplierSellSchemeVO supplierSellSchemeVO = new SupplierSellSchemeVO();
                        supplierSellVO.setSourceId(stuffDocumentEntity.getInviteId()+"");

                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:hh:mm");
                        try {
                            supplierSellVO.setSchemeTime(sdf.parse(detailBidVO.getReplyTime()));
                        } catch (ParseException e) {
                            e.printStackTrace();
                        }

                        supplierSellVO.setEmployeeName(detailBidVO.getSupplierUsername());
                        supplierSellVO.setEmployeeMobile(detailBidVO.getSupplierUserPhone());
                        supplierSellVO.setInvoiceNote(detailBidVO.getRemark());
                        supplierSellVO.setNoticeType(1);//类型(0-公告，1-文件

                        supplierSellSchemeVO.setSchemeName("方案一");
                        supplierSellSchemeVO.setMoneyTax(detailBidVO.getPriceTotal());
                        supplierSellSchemeVO.setMoney(detailBidVO.getPriceTotal());

                        List<SupplierSellSchemeDetailVO> schemeDetailList = new ArrayList<>();
                        List<DetailBidReplyProductsVO> replyProducts = detailBidVO.getReplyProducts();

                        //一个供应商的具体报价情况
                        if(ListUtil.isNotEmpty(replyProducts)){
                            for (DetailBidReplyProductsVO replyProduct : replyProducts) {
                                //层层查询获取对应的物资信息
                                if(collect.containsKey(replyProduct.getProductId())){
                                    String bizKey = collect.get(replyProduct.getProductId());
                                    if (collect1.containsKey(Long.parseLong(bizKey))){
                                        Long aLong = collect1.get(Long.parseLong(bizKey));
                                        if (collect2.containsKey(aLong)){
                                            StuffDocumentDetailVO stuffDocumentDetailVO = collect2.get(aLong);
                                            SupplierSellSchemeDetailVO map = BeanMapper.map(stuffDocumentDetailVO, SupplierSellSchemeDetailVO.class);
                                            map.setPriceTax(replyProduct.getProductPrice());//单价
                                            map.setPrice(replyProduct.getProductPrice());//单价
                                            map.setMoney(replyProduct.getTotalPrice());//总额
                                            map.setMoneyTax(replyProduct.getTotalPrice());//总额
                                            map.setSourceMaterialId(stuffDocumentDetailVO.getMaterialId()+"");//
                                            map.setSourceMaterialTypeId(stuffDocumentDetailVO.getMaterialTypeId()+"");//
                                            map.setDetailRate(stuffDocumentDetailVO.getRate());

                                            map.setId(null);
                                            schemeDetailList.add(map);
                                        }
                                    }
                                }
                            }
                        }
                        supplierSellSchemeVO.setSchemeDetailList(schemeDetailList);


                        schemeList.add(supplierSellSchemeVO);
                        supplierSellVO.setSchemeList(schemeList);

                        Map<String, Object> stringObjectMap = null;
                        try {
                            stringObjectMap = beanToMap(supplierSellVO);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        stringObjectMap.put("sourceSupplierName","筑材网-"+detailBidVO.getSupplierName());
                        stringObjectMap.put("signEmployeeMobile",detailBidVO.getSupplierUsername());
                        stringObjectMap.put("signEmployeeName",detailBidVO.getSupplierUserPhone());
                        stringObjectMap.put("sourceSupplierId",detailBidVO.getSupplierId());

                        stringObjectMap.put("taxpayerNum","914107117270004070");

                        zcwPushSell(stringObjectMap);
                    }
                }

            }else {
                //throw new BusinessException("返回数据异常！"+jsonObject.getString("message") );
                logger.info("查询筑材网报价详情失败，message:{}",jsonObject.getString("message"));
            }
        }
    }

    // 将对象转换成 Map
    public static Map<String, Object> beanToMap(Object bean) throws Exception {
        Map<String, Object> map = new HashMap<>();
        Field[] fields = bean.getClass().getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            String fieldName = field.getName();
            Object value = field.get(bean);
            map.put(fieldName, value);
        }
        return map;
    }


    @Transactional
    public Boolean zcwPushSell(Map<String, Object> params) {

        logger.info("进入报价接口1params-{}", params);
        String notice = JSON.toJSONString(params);
        logger.info("实体信息-{}", notice);
        SupplierSellVO pushVO = JSON.parseObject(notice, new TypeReference<SupplierSellVO>() {
        });
        JSONObject jsonObject = new JSONObject(params);
        String sourceSupplierName = jsonObject.getString("sourceSupplierName");
        String signEmployeeMobile = jsonObject.getString("signEmployeeMobile");
        String signEmployeeName = jsonObject.getString("signEmployeeName");
        Long zcwSourceSupplierId = jsonObject.getInteger("sourceSupplierId").longValue();

        String taxpayerNum = jsonObject.getString("taxpayerNum");



        //处理业务数据
        //noticeType,类型(0-公告，1-文件,2-询价,3-竞争性,4-洽商谈判
        //转换轮数
        StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(Long.parseLong(pushVO.getSourceId()));
        Integer tenderStage = stuffInviteEntity.getTenderStage();
        //招标阶段(3-招标文件,6-竞争性谈判文件,7-洽商谈判,8-单一来源文件,9-紧急文件,10-询价公告
        Integer talkNum = null;
        if (tenderStage == 3 || tenderStage == 6 || tenderStage == 8 || tenderStage == 9 || tenderStage == 10) {
            talkNum = 0;
        }
        if (tenderStage == 7) {
            //查询轮数
            LambdaQueryWrapper<StuffTalkEntity> lambdaTalk = Wrappers.<StuffTalkEntity>lambdaQuery();
            lambdaTalk.eq(StuffTalkEntity::getInviteId, Long.parseLong(pushVO.getSourceId()));
            StuffTalkEntity stuffTalkEntity = stuffTalkService.getOne(lambdaTalk);
            talkNum = stuffTalkEntity.getTalkNum();
        }


        //处理供应商信息
        Long inviteId = Long.parseLong(pushVO.getSourceId());
        LambdaQueryWrapper<StuffDocumentEntity> lambdaDocument = Wrappers.<StuffDocumentEntity>lambdaQuery();
        lambdaDocument.eq(StuffDocumentEntity::getInviteId, inviteId);
        StuffDocumentEntity stuffDocumentEntity = baseMapper.selectOne(lambdaDocument);
        //先删后增
        //根据供应商主键和招标文件主键查询供应商信息,判断新增和修改
        LambdaQueryWrapper<StuffDocumentSupplierEntity> lambdaSupplier = Wrappers.<StuffDocumentSupplierEntity>lambdaQuery();



            //新增供应商信息
            StuffDocumentSupplierEntity stuffDocumentSupplierEntityAdd = new StuffDocumentSupplierEntity();
            stuffDocumentSupplierEntityAdd.setSupplierId(zcwSourceSupplierId);
            stuffDocumentSupplierEntityAdd.setSupplierName(sourceSupplierName);
            stuffDocumentSupplierEntityAdd.setLinkName(signEmployeeName);
            stuffDocumentSupplierEntityAdd.setLinkMobile(signEmployeeMobile);
            stuffDocumentSupplierEntityAdd.setTaxMemo(pushVO.getInvoiceNote());
            stuffDocumentSupplierEntityAdd.setOfferTime(new Date());
            stuffDocumentSupplierEntityAdd.setDocumentId(stuffDocumentEntity.getId());
            stuffDocumentSupplierEntityAdd.setTalkNum(talkNum);
            stuffDocumentSupplierEntityAdd.setIsMobile(1);
            stuffDocumentSupplierEntityAdd.setIsZcw(1);
            boolean save = stuffDocumentSupplierService.save(stuffDocumentSupplierEntityAdd);

            //
            LambdaQueryWrapper<StuffNoticeEntity> lambdaDocument1 = Wrappers.<StuffNoticeEntity>lambdaQuery();
            lambdaDocument1.eq(StuffNoticeEntity::getInviteId,inviteId);
            StuffNoticeEntity stuffNoticeEntity = stuffNoticeMapper.selectOne(lambdaDocument1);

            StuffNoticeSupplierEntity stuffNoticeSupplierEntity = new StuffNoticeSupplierEntity();
            stuffNoticeSupplierEntity.setNoticeId(stuffNoticeEntity.getId());
            stuffNoticeSupplierEntity.setState(0);
            stuffNoticeSupplierEntity.setSupplierEmployeeName(signEmployeeName);
            stuffNoticeSupplierEntity.setSupplierEmployeeMobile(signEmployeeMobile);
            stuffNoticeSupplierEntity.setSupplierName(sourceSupplierName);
            stuffNoticeSupplierEntity.setIsMobile(1);
            stuffNoticeSupplierEntity.setIsZcw(1);
            stuffNoticeSupplierEntity.setSupplierId(zcwSourceSupplierId);
            stuffNoticeSupplierEntity.setSourceSupplierId(zcwSourceSupplierId+"");
            stuffNoticeSupplierService.save(stuffNoticeSupplierEntity);


            Long documentSupplierId  = stuffDocumentSupplierEntityAdd.getId();

        //处理方案信息
        List<SupplierSellSchemeVO> schemeList = pushVO.getSchemeList();
        List<StuffDocumentSchemeEntity> stuffDocumentSchemeEntityArrayList = new ArrayList<>();
        //所有报价详情信息
        List<StuffDocumentSellVO> stuffDocumentSellVOList = new ArrayList<>();
        for (SupplierSellSchemeVO supplierSellSchemeVO : schemeList) {
            StuffDocumentSchemeEntity stuffDocumentSchemeEntity = new StuffDocumentSchemeEntity();
            stuffDocumentSchemeEntity.setDocumentSupplierId(documentSupplierId);
            stuffDocumentSchemeEntity.setDocumentId(stuffDocumentEntity.getId());

            stuffDocumentSchemeEntity.setSupplierId(zcwSourceSupplierId);
            stuffDocumentSchemeEntity.setSupplierName(sourceSupplierName);
            stuffDocumentSchemeEntity.setSchemeName(supplierSellSchemeVO.getSchemeName());
            stuffDocumentSchemeEntity.setMoney(supplierSellSchemeVO.getMoney());
            stuffDocumentSchemeEntity.setMoneyTax(supplierSellSchemeVO.getMoneyTax());
            stuffDocumentSchemeEntity.setTalkNum(talkNum);
            stuffDocumentSchemeEntity.setId(IdWorker.getId());
            stuffDocumentSchemeEntity.setPassFlag(1);
            stuffDocumentSchemeEntity.setIsMobile(1);
            stuffDocumentSchemeEntity.setIsZcw(1);
            stuffDocumentSchemeEntityArrayList.add(stuffDocumentSchemeEntity);

            //处理报价详情与方案的关联关系
            List<SupplierSellSchemeDetailVO> schemeDetailList = supplierSellSchemeVO.getSchemeDetailList();
            for (SupplierSellSchemeDetailVO supplierSellSchemeDetailVO : schemeDetailList) {
                StuffDocumentSellVO stuffDocumentSellVO = new StuffDocumentSellVO();
                stuffDocumentSellVO.setSchemeId(stuffDocumentSchemeEntity.getId());
                stuffDocumentSellVO.setDocumentId(stuffDocumentEntity.getId());
                stuffDocumentSellVO.setLinkMobile(signEmployeeMobile);

                stuffDocumentSellVO.setSupplierId(zcwSourceSupplierId);
                stuffDocumentSellVO.setSupplierName(sourceSupplierName);
                stuffDocumentSellVO.setMaterialId(supplierSellSchemeDetailVO.getSourceMaterialId() != null ? Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialId()) : null);
                stuffDocumentSellVO.setMaterialName(supplierSellSchemeDetailVO.getMaterialName());
                stuffDocumentSellVO.setMaterialCode(supplierSellSchemeDetailVO.getMaterialCode());
                stuffDocumentSellVO.setMaterialTypeId(supplierSellSchemeDetailVO.getSourceMaterialTypeId() != null ? Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialTypeId()) : null);
                stuffDocumentSellVO.setMaterialTypeName(supplierSellSchemeDetailVO.getMaterialTypeName());
                stuffDocumentSellVO.setUnit(supplierSellSchemeDetailVO.getUnit());
                stuffDocumentSellVO.setSpec(supplierSellSchemeDetailVO.getSpec());
                stuffDocumentSellVO.setDetailRate(supplierSellSchemeDetailVO.getDetailRate());
                stuffDocumentSellVO.setRate(supplierSellSchemeDetailVO.getRate());
                stuffDocumentSellVO.setPrice(supplierSellSchemeDetailVO.getPrice());
                stuffDocumentSellVO.setPriceTax(supplierSellSchemeDetailVO.getPriceTax());
//                stuffDocumentSellVO.setMoney(supplierSellSchemeDetailVO.getMoney());
//                stuffDocumentSellVO.setMoneyTax(supplierSellSchemeDetailVO.getMoneyTax());
//                stuffDocumentSellVO.setSellTax(supplierSellSchemeDetailVO.getTax());
                stuffDocumentSellVO.setSchemeName(supplierSellSchemeVO.getSchemeName());
                stuffDocumentSellVO.setMaterialBrand(supplierSellSchemeDetailVO.getBrand());
                stuffDocumentSellVO.setBrand(supplierSellSchemeDetailVO.getSupplierBrand());
                stuffDocumentSellVO.setMemo(supplierSellSchemeDetailVO.getSupplierMemo());
                stuffDocumentSellVO.setMaterialMemo(supplierSellSchemeDetailVO.getMemo());
                stuffDocumentSellVO.setCalculateType(supplierSellSchemeDetailVO.getCalculateType());
                stuffDocumentSellVO.setReferFlag(2);
                stuffDocumentSellVO.setPassFlag(1);
                stuffDocumentSellVO.setTalkNum(talkNum);
                stuffDocumentSellVO.setIsMobile(1);
                stuffDocumentSellVO.setIsZcw(1);
                stuffDocumentSellVOList.add(stuffDocumentSellVO);

            }

        }
        //新增方案
        stuffDocumentSchemeService.saveBatch(stuffDocumentSchemeEntityArrayList);

        //处理报价详情信息
        //删除报价信息
        LambdaQueryWrapper<StuffDocumentSellEntity> lambdaSell = Wrappers.<StuffDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(StuffDocumentSellEntity::getLinkMobile, signEmployeeMobile);
        lambdaSell.eq(StuffDocumentSellEntity::getTalkNum, talkNum);
        lambdaSell.eq(StuffDocumentSellEntity::getDocumentId, stuffDocumentEntity.getId());
        stuffDocumentSellService.remove(lambdaSell);

        //处理报价详情信息
        LambdaQueryWrapper<StuffDocumentDetailEntity> lambdaDetail = Wrappers.<StuffDocumentDetailEntity>lambdaQuery();
        lambdaDetail.eq(StuffDocumentDetailEntity::getDocumentId, stuffDocumentEntity.getId());
        List<StuffDocumentDetailEntity> stuffDocumentDetailList = stuffDocumentDetailService.list(lambdaDetail);

        List<StuffDocumentSellEntity> stuffDocumentSellEntityArrayList = new ArrayList<>();
        for (StuffDocumentDetailEntity stuffDocumentDetailEntity : stuffDocumentDetailList) {
            for (StuffDocumentSellVO stuffDocumentSellVO : stuffDocumentSellVOList) {
                //判断是否只有分类
                if (stuffDocumentDetailEntity.getMaterialId() != null) {
                    if (stuffInviteEntity.getPurchaseType() == 1) {//单位采购
                        if (stuffDocumentDetailEntity.getMaterialTypeId().equals(stuffDocumentSellVO.getMaterialTypeId()) &&
                                stuffDocumentDetailEntity.getMaterialId().equals(stuffDocumentSellVO.getMaterialId()) &&
                                stuffDocumentDetailEntity.getRate().compareTo(stuffDocumentSellVO.getDetailRate()) == 0) {
                            StuffDocumentSellEntity stuffDocumentSellEntity = BeanMapper.map(stuffDocumentSellVO, StuffDocumentSellEntity.class);
                            stuffDocumentSellEntity.setDetailId(stuffDocumentDetailEntity.getId());
                            stuffDocumentSellEntity.setProjectId(stuffDocumentDetailEntity.getDetailProjectId());
                            stuffDocumentSellEntity.setProjectName(stuffDocumentDetailEntity.getDetailProjectName());
                            stuffDocumentSellEntity.setNum(stuffDocumentDetailEntity.getNum());
                            stuffDocumentSellEntity.setMoney(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPrice()));
                            stuffDocumentSellEntity.setMoneyTax(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPriceTax()));
                            stuffDocumentSellEntity.setSellTax(stuffDocumentSellEntity.getMoneyTax().subtract(stuffDocumentSellEntity.getMoney()));
                            // 备注拆分
                            stuffDocumentSellEntity.setMaterialMemo(stuffDocumentDetailEntity.getMemo());
                            stuffDocumentSellEntity.setIsMobile(1);
                            stuffDocumentSellEntity.setIsZcw(1);
                            stuffDocumentSellEntity.setSupplierId(zcwSourceSupplierId);
                            stuffDocumentSellEntity.setTaxpayerNum(taxpayerNum);//纳税人识别号（筑材网推送使用）

                            stuffDocumentSellEntityArrayList.add(stuffDocumentSellEntity);
                        }
                    } else {
                        if (stuffDocumentDetailEntity.getMaterialTypeId().equals(stuffDocumentSellVO.getMaterialTypeId()) &&
                                stuffDocumentDetailEntity.getMaterialId().equals(stuffDocumentSellVO.getMaterialId()) &&
                                stuffDocumentDetailEntity.getCalculateType().equals(stuffDocumentSellVO.getCalculateType()) &&
                                stuffDocumentDetailEntity.getRate().compareTo(stuffDocumentSellVO.getDetailRate()) == 0) {
                            StuffDocumentSellEntity stuffDocumentSellEntity = BeanMapper.map(stuffDocumentSellVO, StuffDocumentSellEntity.class);
                            stuffDocumentSellEntity.setDetailId(stuffDocumentDetailEntity.getId());
                            stuffDocumentSellEntity.setProjectId(stuffDocumentDetailEntity.getDetailProjectId());
                            stuffDocumentSellEntity.setProjectName(stuffDocumentDetailEntity.getDetailProjectName());
                            stuffDocumentSellEntity.setNum(stuffDocumentDetailEntity.getNum());
                            stuffDocumentSellEntity.setMoney(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPrice()));
                            stuffDocumentSellEntity.setMoneyTax(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPriceTax()));
                            stuffDocumentSellEntity.setSellTax(stuffDocumentSellEntity.getMoneyTax().subtract(stuffDocumentSellEntity.getMoney()));
                            // 备注拆分
                            stuffDocumentSellEntity.setMaterialMemo(stuffDocumentDetailEntity.getMemo());
                            stuffDocumentSellEntity.setIsMobile(1);
                            stuffDocumentSellEntity.setIsZcw(1);
                            stuffDocumentSellEntity.setSupplierId(zcwSourceSupplierId);
                            stuffDocumentSellEntity.setTaxpayerNum(taxpayerNum);//纳税人识别号（筑材网推送使用）

                            stuffDocumentSellEntityArrayList.add(stuffDocumentSellEntity);
                        }
                    }
                }
                if (stuffDocumentDetailEntity.getMaterialId() == null) {
                    if (stuffDocumentDetailEntity.getMaterialTypeId().equals(stuffDocumentSellVO.getMaterialTypeId()) &&
                            (stuffDocumentDetailEntity.getCalculateType() == null || stuffDocumentDetailEntity.getCalculateType().equals(stuffDocumentSellVO.getCalculateType())) &&
                            stuffDocumentDetailEntity.getRate().compareTo(stuffDocumentSellVO.getDetailRate()) == 0) {
                        StuffDocumentSellEntity stuffDocumentSellEntity = BeanMapper.map(stuffDocumentSellVO, StuffDocumentSellEntity.class);
                        stuffDocumentSellEntity.setDetailId(stuffDocumentDetailEntity.getId());
                        stuffDocumentSellEntity.setProjectId(stuffDocumentDetailEntity.getDetailProjectId());
                        stuffDocumentSellEntity.setProjectName(stuffDocumentDetailEntity.getDetailProjectName());
                        stuffDocumentSellEntity.setNum(stuffDocumentDetailEntity.getNum());
                        stuffDocumentSellEntity.setMoney(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPrice()));
                        stuffDocumentSellEntity.setMoneyTax(stuffDocumentDetailEntity.getNum().multiply(stuffDocumentSellEntity.getPriceTax()));
                        stuffDocumentSellEntity.setSellTax(stuffDocumentSellEntity.getMoneyTax().subtract(stuffDocumentSellEntity.getMoney()));
                        // 备注拆分
                        stuffDocumentSellEntity.setMaterialMemo(stuffDocumentDetailEntity.getMemo());
                        stuffDocumentSellEntity.setIsMobile(1);
                        stuffDocumentSellEntity.setIsZcw(1);
                        stuffDocumentSellEntity.setTaxpayerNum(taxpayerNum);//纳税人识别号（筑材网推送使用）
                        stuffDocumentSellEntity.setSupplierId(zcwSourceSupplierId);
                        stuffDocumentSellEntityArrayList.add(stuffDocumentSellEntity);
                    }
                }

            }

        }
        //新增报价信息
        stuffDocumentSellService.saveBatch(stuffDocumentSellEntityArrayList);

        //先删除附件
        if (documentSupplierId != null) {
            logger.info("删除供应商[{}]附件信息，billType[{}]，sourceType[supplierFileType]", documentSupplierId, BILL_SUPPLIER_TYPE);
//            CommonResponse<String> deleteRtn = attachmentApi.deleteFileByParam(documentSupplierId, BILL_SUPPLIER_TYPE,"supplierFileType");
            CommonResponse<List<AttachmentVO>> attachmentResponse = attachmentApi.queryListBySourceId(documentSupplierId, BILL_SUPPLIER_TYPE, "supplierFileType", null);
            List<AttachmentVO> attachmentVOList = attachmentResponse.getData();
            if (CollectionUtils.isNotEmpty(attachmentVOList)) {
                logger.info("开始删除附件信息-----");
                String ids = attachmentVOList.stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
                CommonResponse<String> deleteResponse = attachmentApi.delete(ids);
                logger.info("删除文件结束，删除结果：{}", deleteResponse.getData());
            }
        }
        //处理附件
//        if(file != null){
//            logger.info(request+"报价文件名称- {}",file.getOriginalFilename());
//            logger.info(request+"供应商表主键- {}",documentSupplierId);
//            Boolean upFlag = new ThirdSystemUtils().upFile(BASE_HOST,"supplierFileType",Long.toString(documentSupplierId),BILL_SUPPLIER_TYPE,file,request);
//            logger.info(request+"文件上传结果-{}",upFlag);
//        }
        //TODO
//        List<SupplyFileVo> pzList = pushVO.getSupplyFileList();
//        logger.info("报名文件:{}", JSONObject.toJSONString(pzList));
//        if (CollectionUtils.isNotEmpty(pzList)) {
//            List<AttachmentVO> list = new ArrayList<>();
//            for (SupplyFileVo e : pzList) {
//                AttachmentVO attachmentVO = new AttachmentVO();
//                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
//                attachmentVO.setSourceId(documentSupplierId);
//                attachmentVO.setSourceType("supplierFileType");
//                attachmentVO.setFilePath(e.getFilePath());
//                attachmentVO.setOnlinePath(e.getFilePath());
//                attachmentVO.setFileName(e.getFileName());
//                attachmentVO.setId(e.getFileId());
//                list.add(attachmentVO);
//                logger.info("保存文件信息:{}", JSONObject.toJSONString(attachmentVO));
//            }
//            CommonResponse<String> stringCommonResponse = attachmentApi.insertBatch(list);
//            logger.info(request + "报名文件上传结果-{}", JSONObject.toJSONString(stringCommonResponse));
//        }
        return true;
    }

    @Override
    public  String zcwPicket(StuffInviteEntity stuffInviteEntity,List<StuffDocumentSellEntity> stuffDocumentSellList){
        //判断是否推送到筑材网
        if(stuffInviteEntity.getIsPushZcw() == 1) {
            ArrayList<StuffDocumentSellEntity> collect = stuffDocumentSellList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(
                    Comparator.comparing(StuffDocumentSellEntity::getSupplierId))), ArrayList::new));
            List<StuffDocumentSellEntity> collect1 = collect.stream().filter(str -> str.getIsZcw() == 1).collect(Collectors.toList());

            JSONObject param = new JSONObject();
            param.put("bidNum", stuffInviteEntity.getZcwCode());
            if (ListUtil.isNotEmpty(collect1)) {
                String[] strings = new String[collect1.size()];
                if (collect1.size() == 1) {
                    param.put("bidDecisionType", 1);//	中标类型: 0 - 流标，1 - 普通单家中标（默认）2 - 候选中标，3 - 联合中标
                } else {
                    param.put("bidDecisionType", 3);
                }
                for (int i = 0; i < collect1.size(); i++) {
                    strings[i] = collect1.get(i).getTaxpayerNum();
                }
                param.put("supplierList", strings);//	中标供应商 企业名或统一社会信用编码均可
                param.put("bidNotice", "中标供应商及时联系招标负责人进行合同签署！");//
            } else {
                String[] strings = new String[0];
                param.put("bidDecisionType", 0);//	中标类型: 0 - 流标，1 - 普通单家中标（默认）2 - 候选中标，3 - 联合中标
                param.put("supplierList", strings);//	中标供应商 企业名或统一社会信用编码均可
            }

            String responseBody = systemRequestService.sendPostRequest("bid/decideBid", param);
            JSONObject jsonObject = JSONObject.parseObject(responseBody);
            logger.info("筑材网定标返回结果：{}",responseBody);
            Integer code = jsonObject.getInteger("code");
            if (code == 0) {
                return "筑材网定标调用成功！";
            }else {
                return "筑材网定标调用失败！";
            }
        }
        return  "无需推送筑材网定标！";
    }
}
