package com.ejianc.business.tender.stuff.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.stuff.mapper.StuffTalkMapper;
import com.ejianc.business.tender.stuff.service.*;
import com.ejianc.business.tender.stuff.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 洽商谈判主表
 * 
 * @author generator
 * 
 */
@Service("stuffTalkService")
public class StuffTalkServiceImpl extends BaseServiceImpl<StuffTalkMapper, StuffTalkEntity> implements IStuffTalkService{
    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;

    @Value("${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value("${gysUrl.updateSupOffer}")
    private String updateSupOffer;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-talk-code";
    @Autowired
    private IStuffTalkDetailService stuffTalkDetailService;
    @Autowired
    private IStuffTalkRecordService stuffTalkRecordService;
    @Autowired
    private IStuffTalkRecordDetailService stuffTalkRecordDetailService;
    @Autowired
    private IStuffDocumentSellService stuffDocumentSellService;
    @Autowired
    private IStuffDocumentService stuffDocumentService;
    @Autowired
    private IStuffInviteService stuffInviteService;
    @Autowired
    private IStuffDocumentSupplierService stuffDocumentSupplierService;
    @Autowired
    private IStuffDocumentSchemeService stuffDocumentSchemeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProcessService processService;
    private org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_SUPPLIER_TYPE = "BT202202000004";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Transactional
    @Override
    public StuffTalkVO publishTalk(Long id) {
        //更新发布状态
        StuffTalkEntity stuffTalkEntity = super.selectById(id);
        stuffTalkEntity.setPublishFlag(0);
        super.updateById(stuffTalkEntity);

        //推送供应商
        StuffDocumentSupplierTbVO stuffDocumentSupplierTbVO = new StuffDocumentSupplierTbVO();
        stuffDocumentSupplierTbVO.setSourceId(stuffTalkEntity.getInviteId().toString());
        stuffDocumentSupplierTbVO.setSourceType("郑州一建洽商谈判");
        stuffDocumentSupplierTbVO.setNoticeType(4);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(stuffTalkEntity.getTalkStartTime());
        stuffDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(stuffTalkEntity.getTalkEndTime());
        stuffDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        stuffDocumentSupplierTbVO.setMemo(stuffTalkEntity.getMemo());
        stuffDocumentSupplierTbVO.setTalkMoney(stuffTalkEntity.getTalkMoney());
        stuffDocumentSupplierTbVO.setTalkNum(stuffTalkEntity.getTalkNum());
        stuffDocumentSupplierTbVO.setTenderName(stuffTalkEntity.getTalkName());
        stuffDocumentSupplierTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        String stringFb = JSONObject.toJSONString(stuffDocumentSupplierTbVO);
        logger.info("洽商谈判发布" + stringFb);
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("洽商谈判同步供方接口报错" + stringCommonResponse.getMsg());
        }

        return queryDetail(id);
    }

    @Override
    public StuffTalkVO extendTalk(StuffTalkDetailVO stuffTalkDetailVO) {
        StuffTalkDetailEntity stuffDocumentRecordEntity = BeanMapper.map(stuffTalkDetailVO, StuffTalkDetailEntity.class);
        stuffTalkDetailService.save(stuffDocumentRecordEntity);
        StuffTalkEntity stuffTalkEntity = super.selectById(stuffTalkDetailVO.getTalkId());
        stuffTalkEntity.setTalkEndTime(stuffTalkDetailVO.getNewTime());
        boolean b = super.updateById(stuffTalkEntity);

        //推送供方
        SupplierSellVO supplierSellVO = new SupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(stuffTalkEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(stuffTalkDetailVO.getNewTime());

        String stringFb = JSONObject.toJSONString(supplierSellVO);

        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(updateTimeUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("洽商谈判同步供方接口报错" + stringCommonResponse.getMsg());
        }
//

        return queryDetail(stuffTalkDetailVO.getTalkId());
    }

    @Override
    public StuffTalkVO saveTalk(Long documentId) {
        StuffTalkEntity entity = new StuffTalkEntity();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        StuffDocumentEntity documentEntity = stuffDocumentService.selectById(documentId);
        documentEntity.setNextFlag(0);
        stuffDocumentService.saveOrUpdate(documentEntity);
        //查询招标立项信息
        StuffDocumentEntity stuffDocumentEntity = stuffDocumentService.selectById(documentId);
        StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(stuffDocumentEntity.getInviteId());
        entity.setProjectCode(stuffDocumentEntity.getProjectCode());
        entity.setInviteId(stuffDocumentEntity.getInviteId());
        entity.setProjectId(stuffDocumentEntity.getProjectId());
        entity.setProjectName(stuffDocumentEntity.getProjectName());
        entity.setOrgId(stuffDocumentEntity.getOrgId());
        entity.setOrgName(stuffDocumentEntity.getOrgName());
        entity.setParentOrgId(stuffDocumentEntity.getParentOrgId());
        entity.setParentOrgName(stuffDocumentEntity.getParentOrgName());
        entity.setBrandFlag(stuffDocumentEntity.getBrandFlag());
        entity.setBillId(documentId);
        entity.setTalkNum(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        String taikNumName = "第" + entity.getTalkNum() + "轮报价";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(stuffDocumentEntity.getPurchaseType());
        entity.setTalkName(stuffInviteEntity.getTenderName());
        entity.setFloatingType(stuffDocumentEntity.getFloatingType());

        super.save(entity);

        //回写招标阶段
        stuffInviteEntity.setTenderStage(7);
        stuffInviteService.updateById(stuffInviteEntity);

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("洽商谈判");
        processEntity.setTenderId(stuffDocumentEntity.getInviteId());
        processEntity.setType(0);
        processEntity.setFrontendUrl("stuff/talkNegotiate");
        processService.saveOrUpdate(processEntity);

        StuffTalkVO vo = BeanMapper.map(entity, StuffTalkVO.class);

        StuffTalkVO stuffTalkVO = queryDetail(vo.getId());
        return stuffTalkVO;
    }

    @Override
    public StuffTalkVO queryDetail(Long id) {
        StuffTalkEntity stuffTalkEntity = super.selectById(id);
        StuffTalkVO stuffTalkVO = BeanMapper.map(stuffTalkEntity, StuffTalkVO.class);

        //确认轮数
        Integer talkNum = stuffTalkEntity.getTalkNum();
        if (stuffTalkEntity.getPublishFlag() == 1){
            talkNum = talkNum - 1;
        }
        StuffDocumentVO stuffDocumentVO = stuffDocumentService.queryDocDetail(stuffTalkEntity.getBillId(), talkNum);

        //查询供应商报价方案数据


        stuffTalkVO.setStuffDocumentDetailSellList(stuffDocumentVO.getStuffDocumentDetailSellList());
        stuffTalkVO.setStuffDocumentSupplierSchemeList(stuffDocumentVO.getStuffDocumentSupplierSchemeList());

        //查询首轮报价的供应商信息
        LambdaQueryWrapper<StuffDocumentSupplierEntity> lambda = Wrappers.<StuffDocumentSupplierEntity>lambdaQuery();
        lambda.eq(StuffDocumentSupplierEntity::getDocumentId, stuffTalkEntity.getBillId());
        lambda.eq(StuffDocumentSupplierEntity::getTalkNum, 0);
        List<StuffDocumentSupplierEntity> supplierList = stuffDocumentSupplierService.list(lambda);
        List<StuffDocumentSupplierVO> documentSupplierVOList = BeanMapper.mapList(supplierList,StuffDocumentSupplierVO.class);
        stuffTalkVO.setStuffDocumentSupplierList(documentSupplierVOList);

        //查询变更历史记录
        LambdaQueryWrapper<StuffTalkRecordEntity> lambdaRecord = Wrappers.lambdaQuery();
        lambdaRecord.eq(StuffTalkRecordEntity::getBillId,stuffTalkEntity.getBillId());
        lambdaRecord.orderByAsc(StuffTalkRecordEntity::getTalkNum);
        List<StuffTalkRecordEntity> stuffTalkRecordEntityList = stuffTalkRecordService.list(lambdaRecord);
        List<StuffTalkRecordVO> stuffTalkRecordList = BeanMapper.mapList(stuffTalkRecordEntityList, StuffTalkRecordVO.class);
        stuffTalkVO.setTalkRecordEntityList(stuffTalkRecordList);
        return stuffTalkVO;
    }
    @Transactional
    @Override
    public StuffTalkVO againSaveTalk(Long id) {
        StuffTalkEntity entity = new StuffTalkEntity();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //查询招标立项信息
        StuffTalkEntity stuffTalkEntity = super.selectById(id);
        entity.setProjectCode(stuffTalkEntity.getProjectCode());
        entity.setProjectId(stuffTalkEntity.getProjectId());
        entity.setProjectName(stuffTalkEntity.getProjectName());
        entity.setOrgId(stuffTalkEntity.getOrgId());
        entity.setOrgName(stuffTalkEntity.getOrgName());
        entity.setParentOrgId(stuffTalkEntity.getParentOrgId());
        entity.setParentOrgName(stuffTalkEntity.getParentOrgName());
        entity.setBrandFlag(stuffTalkEntity.getBrandFlag());
        entity.setBillId(stuffTalkEntity.getBillId());
        entity.setInviteId(stuffTalkEntity.getInviteId());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setTalkNum(stuffTalkEntity.getTalkNum() + 1);
        String taikNumName = "第" + entity.getTalkNum() + "轮报价";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(stuffTalkEntity.getPurchaseType());
        super.save(entity);

        //保存历史记录表
        StuffTalkRecordEntity stuffTalkRecordEntity =  BeanMapper.map(stuffTalkEntity,StuffTalkRecordEntity.class);
        stuffTalkRecordEntity.setTalkId(stuffTalkEntity.getId());
        stuffTalkRecordEntity.setId(null);
        stuffTalkRecordService.save(stuffTalkRecordEntity);
        //新增历史记录子表
        List<StuffTalkDetailEntity> stuffTalkDetailList = stuffTalkEntity.getStuffTalkDetailList();
        List<StuffTalkRecordDetailEntity> stuffTalkRecordDetailEntityList = BeanMapper.mapList(stuffTalkDetailList,StuffTalkRecordDetailEntity.class);
        for (StuffTalkRecordDetailEntity stuffTalkRecordDetailEntity : stuffTalkRecordDetailEntityList){
            stuffTalkRecordDetailEntity.setId(null);
            stuffTalkRecordDetailEntity.setRecordId(stuffTalkRecordEntity.getId());
        }
        stuffTalkRecordDetailService.saveBatch(stuffTalkRecordDetailEntityList);

        //删除老数据
        super.removeById(id,false);

        //修改进展表信息
        LambdaQueryWrapper<ProcessEntity> lambdaProcess = Wrappers.<ProcessEntity>lambdaQuery();
        lambdaProcess.eq(ProcessEntity::getBillId,id);
        lambdaProcess.eq(ProcessEntity::getTenderId,stuffTalkEntity.getInviteId());
        ProcessEntity processEntity = processService.getOne(lambdaProcess);
        processEntity.setBillId(entity.getId());
        processService.updateById(processEntity);
        StuffTalkVO vo = BeanMapper.map(entity, StuffTalkVO.class);
        addLastSell(stuffTalkEntity.getTalkNum(),stuffTalkEntity.getBillId());

        return queryDetail(entity.getId());
    }

    @Override
    public StuffTalkVO replenishSell(Long id) {
        StuffTalkEntity stuffTalkEntity = super.selectById(id);

        Integer talkNum = stuffTalkEntity.getTalkNum();
        Long billId = stuffTalkEntity.getBillId();
        addLastSell(talkNum,billId);

        return new StuffTalkVO();
    }

    @Override
    public Boolean getSellFull(Long id) {
        //获取最新轮数
        StuffTalkEntity stuffTalkEntity = super.selectById(id);
        Integer talkNum = stuffTalkEntity.getTalkNum();
        LambdaQueryWrapper<StuffDocumentSupplierEntity> lambdaSupplier = Wrappers.<StuffDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(StuffDocumentSupplierEntity::getDocumentId, stuffTalkEntity.getBillId());
        lambdaSupplier.eq(StuffDocumentSupplierEntity::getTalkNum, talkNum);
        List<StuffDocumentSupplierEntity> supplierList = stuffDocumentSupplierService.list(lambdaSupplier);
        LambdaQueryWrapper<StuffDocumentSupplierEntity> lambdaSupplierFirst = Wrappers.<StuffDocumentSupplierEntity>lambdaQuery();
        lambdaSupplierFirst.eq(StuffDocumentSupplierEntity::getDocumentId, stuffTalkEntity.getBillId());
        lambdaSupplierFirst.eq(StuffDocumentSupplierEntity::getTalkNum, 0);
        List<StuffDocumentSupplierEntity> supplierListFirst = stuffDocumentSupplierService.list(lambdaSupplierFirst);
        if (supplierListFirst == null || supplierListFirst.size() == 0){
            return false;
        }
        if (supplierList.size() != supplierListFirst.size()){
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> querySupplierList(Long talkId) {
        Map<String, Object> stringListMap = new HashMap<>();
        StuffTalkEntity stuffTalkEntity = baseMapper.selectById(talkId);
        List<StuffQuotationMaterialVO> materialVOList = new ArrayList<>();
        //查询所有数据
        List<StuffDocumentSellEntity> stuffDocumentSellEntities = stuffDocumentSellService.selectMaterialType(stuffTalkEntity.getBillId());
        Integer talkNum = stuffDocumentSellEntities.get(0).getTalkNum();
        List<StuffDocumentSellVO> sellEntityList = BeanMapper.mapList(stuffDocumentSellEntities, StuffDocumentSellVO.class);
        //根据项目分组
        Map<Long, List<StuffDocumentSellVO>> collect = sellEntityList.stream().filter(map -> map.getProjectId() != null).collect(Collectors.groupingBy(StuffDocumentSellVO::getProjectId));
        for (List<StuffDocumentSellVO> sellVOS : collect.values()) {
            //根据材料分类
            Map<Long, List<StuffDocumentSellVO>> listMap = sellVOS.stream().filter(map->map.getMaterialId() != null).collect(Collectors.groupingBy(StuffDocumentSellVO::getMaterialId));
            for (Long materialTypeId : listMap.keySet()) {
                StuffQuotationMaterialVO materialVO = new StuffQuotationMaterialVO();
                //获取供应商
                List<StuffDocumentSellVO> materialTypeList = listMap.get(materialTypeId);
                for (StuffDocumentSellVO sellVO : materialTypeList) {
                    materialVO  =  BeanMapper.map(sellVO, StuffQuotationMaterialVO.class);
                }
                List<StuffQuotationSupplierVO> stuffQuotationSupplierVOS = BeanMapper.mapList(materialTypeList, StuffQuotationSupplierVO.class);
                //供应商ID去重
                List<StuffQuotationSupplierVO> supplierVOS = stuffQuotationSupplierVOS.stream()
                        .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(StuffQuotationSupplierVO::getSupplierId))), ArrayList::new));
                materialVO.setSupplierList(supplierVOS);
                //根据供应商分类
                Map<Long, List<StuffDocumentSellVO>> supplierMap = materialTypeList.stream().filter(map->map.getSupplierId() != null).collect(Collectors.groupingBy(StuffDocumentSellVO::getSupplierId));

                for (StuffQuotationSupplierVO supplierVO : materialVO.getSupplierList()) {
                    //获取方案
                    List<StuffDocumentSellVO> stuffDocumentSellVOS = supplierMap.get(supplierVO.getSupplierId());
                    for (StuffDocumentSellVO stuffDocumentSellVO : stuffDocumentSellVOS) {
                        supplierVO.setSupplierName(stuffDocumentSellVO.getSupplierName());
                    }
                    List<StuffQuotationSchemeVO> stuffQuotationSchemeVOS = BeanMapper.mapList(stuffDocumentSellVOS, StuffQuotationSchemeVO.class);
                    //根据方案名称去重
                    List<StuffQuotationSchemeVO> schemeVOS = stuffQuotationSchemeVOS.stream()
                            .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(f -> f.getSchemeName()))), ArrayList::new));
                    supplierVO.setSchemeList(schemeVOS);
                    Map<String, List<StuffDocumentSellVO>> schemeMap = stuffDocumentSellVOS.stream().filter(map->map.getSchemeName() != null).collect(Collectors.groupingBy(StuffDocumentSellVO::getSchemeName));
                    for (StuffQuotationSchemeVO stuffQuotationSchemeVO : supplierVO.getSchemeList()) {
                        List<StuffDocumentSellVO> priceList = schemeMap.get(stuffQuotationSchemeVO.getSchemeName());
                        //如果轮数小于最大轮数，添加一个空的对象
                        if (priceList.size()<talkNum+1){
                            StuffDocumentSellVO documentSellVO = new StuffDocumentSellVO();
                            documentSellVO.setPrice(BigDecimal.valueOf(-1));
                            documentSellVO.setPriceTax(BigDecimal.valueOf(-1));
                            documentSellVO.setMoney(BigDecimal.valueOf(-1));
                            documentSellVO.setMoneyTax(BigDecimal.valueOf(-1));
                            documentSellVO.setTalkNum(talkNum);
                            priceList.add(0,documentSellVO);
                        }
                        stuffQuotationSchemeVO.setPriceList(priceList);
                    }
                }
                materialVOList.add(materialVO);
            }
        }
        stringListMap.put("MaterialTypeList",materialVOList);
        stringListMap.put("offerNum",stuffDocumentSellEntities.get(0).getTalkNum());
        return stringListMap;
    }

    @Override
    public StuffTalkVO saveOrUpdates(StuffTalkVO saveorUpdateVO) {
        StuffTalkEntity entity = BeanMapper.map(saveorUpdateVO, StuffTalkEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        StuffTalkVO vo = BeanMapper.map(entity, StuffTalkVO.class);
        StuffTalkVO stuffTalkVO = queryDetail(vo.getId());
        return stuffTalkVO;
    }

    private void addLastSell(Integer talkNum, Long docId) {
        //补足未报价供应商信息
        //查询上一轮数
        //查询报价信息,判断本轮没有报价的供应商
        LambdaQueryWrapper<StuffDocumentSupplierEntity> lambdaSupplier = Wrappers.<StuffDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(StuffDocumentSupplierEntity::getDocumentId, docId);
        lambdaSupplier.eq(StuffDocumentSupplierEntity::getTalkNum, talkNum);
        List<StuffDocumentSupplierEntity> supplierList = stuffDocumentSupplierService.list(lambdaSupplier);

        //查询
        LambdaQueryWrapper<StuffDocumentSupplierEntity> lambdaSupplierLast = Wrappers.<StuffDocumentSupplierEntity>lambdaQuery();
        lambdaSupplierLast.eq(StuffDocumentSupplierEntity::getDocumentId, docId);
        lambdaSupplierLast.eq(StuffDocumentSupplierEntity::getTalkNum, talkNum - 1);
        List<StuffDocumentSupplierEntity> supplierListLast = stuffDocumentSupplierService.list(lambdaSupplierLast);
        List<Long> supplierPk = supplierList.stream().map(StuffDocumentSupplierEntity::getSupplierId).collect(Collectors.toList());
        List<StuffDocumentSupplierEntity> documentSupplierEntityDataList = supplierListLast.stream().filter(s -> !supplierPk.contains(s.getSupplierId())).collect(Collectors.toList());
        List<StuffDocumentSupplierEntity> documentSupplierEntityNewList = BeanMapper.mapList(documentSupplierEntityDataList,StuffDocumentSupplierEntity.class);
        if (documentSupplierEntityNewList.size() == 0){
            return;
        }

        //推送供应商数据提示信息
        List<SupplierReplenishVO> replenishVOArrayList = new ArrayList<>();
        StuffDocumentEntity stuffDocumentEntity = stuffDocumentService.selectById(docId);
        for (StuffDocumentSupplierEntity stuffDocumentSupplierEntity : documentSupplierEntityNewList){
            SupplierReplenishVO supplierReplenishVO = new SupplierReplenishVO();
            supplierReplenishVO.setSourceId(Long.toString(stuffDocumentEntity.getInviteId()));
            supplierReplenishVO.setTalkNum(talkNum);
            supplierReplenishVO.setTenantId(Long.toString(stuffDocumentSupplierEntity.getSupplierTenantId()));
            replenishVOArrayList.add(supplierReplenishVO);
        }
        String stringFb = JSONObject.toJSONString(replenishVOArrayList);
        logger.info("再次洽商推送供方接口数据:" + stringFb);
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(updateSupOffer, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("再次洽商推送供方接口数据response:" + stringCommonResponse.getMsg());
        }



        List<Long> supplierPkNew = documentSupplierEntityNewList.stream().map(StuffDocumentSupplierEntity::getId).collect(Collectors.toList());

        for (StuffDocumentSupplierEntity stuffDocumentSupplierEntity : documentSupplierEntityNewList){
            stuffDocumentSupplierEntity.setId(IdWorker.getId());
            stuffDocumentSupplierEntity.setTalkNum(talkNum);
        }
        stuffDocumentSupplierService.saveBatch(documentSupplierEntityNewList);

        //复制上一轮未报价的供应商的附件信息
        for (StuffDocumentSupplierEntity stuffDocumentSupplierEntity : documentSupplierEntityNewList){
            for (StuffDocumentSupplierEntity stuffDocumentSupplierLastEntity : supplierListLast){
                if (stuffDocumentSupplierEntity.getSupplierId().equals(stuffDocumentSupplierLastEntity.getSupplierId())){
                    CommonResponse<String> responseCopy = attachmentApi.copyFilesFromSourceBillToTargetBill(
                            stuffDocumentSupplierLastEntity.getId().toString(),
                            BILL_SUPPLIER_TYPE,
                            "supplierFileType",
                            stuffDocumentSupplierEntity.getId().toString(),
                            BILL_SUPPLIER_TYPE,
                            "supplierFileType"
                    );
                    if (!responseCopy.isSuccess()) {
                        throw new BusinessException("再次洽商附件复制失败:" + responseCopy.getMsg());
                    }
                }

            }
        }
        //查询上一轮未报价供应商的方案
        LambdaQueryWrapper<StuffDocumentSchemeEntity> lambdaScheme = Wrappers.<StuffDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(StuffDocumentSchemeEntity::getDocumentId, docId);
        lambdaScheme.eq(StuffDocumentSchemeEntity::getTalkNum, talkNum - 1);
        lambdaScheme.in(StuffDocumentSchemeEntity::getDocumentSupplierId, supplierPkNew);
        List<StuffDocumentSchemeEntity> schemeList = stuffDocumentSchemeService.list(lambdaScheme);
        List<Long> schemePkList = schemeList.stream().map(StuffDocumentSchemeEntity::getId).collect(Collectors.toList());
        for (StuffDocumentSchemeEntity stuffDocumentSchemeEntity : schemeList){
            stuffDocumentSchemeEntity.setId(IdWorker.getId());
            stuffDocumentSchemeEntity.setTalkNum(talkNum);
            for (StuffDocumentSupplierEntity stuffDocumentSupplierEntity : documentSupplierEntityNewList){
                if (stuffDocumentSchemeEntity.getSupplierId().equals(stuffDocumentSupplierEntity.getSupplierId())){
                    stuffDocumentSchemeEntity.setDocumentSupplierId(stuffDocumentSupplierEntity.getId());
                }
            }
        }
        stuffDocumentSchemeService.saveBatch(schemeList);

        //查询上一轮未报价供应商的方案详情
        LambdaQueryWrapper<StuffDocumentSellEntity> lambdaSell = Wrappers.<StuffDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(StuffDocumentSellEntity::getDocumentId, docId);
        lambdaSell.eq(StuffDocumentSellEntity::getTalkNum, talkNum - 1);
        lambdaSell.in(StuffDocumentSellEntity::getSchemeId, schemePkList);
        List<StuffDocumentSellEntity> sellList = stuffDocumentSellService.list(lambdaSell);
        for (StuffDocumentSellEntity stuffDocumentSellEntity : sellList){
            stuffDocumentSellEntity.setId(null);
            stuffDocumentSellEntity.setTalkNum(talkNum);
            for (StuffDocumentSchemeEntity stuffDocumentSchemeEntity : schemeList){
                if (stuffDocumentSellEntity.getSupplierId().equals(stuffDocumentSchemeEntity.getSupplierId()) &&
                        stuffDocumentSellEntity.getSchemeName().equals(stuffDocumentSchemeEntity.getSchemeName())){
                    stuffDocumentSellEntity.setSchemeId(stuffDocumentSchemeEntity.getId());
                }

            }
        }
        stuffDocumentSellService.saveBatch(sellList);
    }
}
