package com.ejianc.business.tender.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSupplierEntity;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.stuff.vo.SupplierSellVO;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.service.*;
import com.ejianc.business.tender.sub.vo.*;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.service.*;
import com.ejianc.business.tender.sub.mapper.SubTalkMapper;
import com.ejianc.business.tender.sub.service.ISubTalkRecordService;
import com.ejianc.business.tender.sub.service.ISubTalkService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 洽商谈判主表
 * 
 * @author generator
 * 
 */
@Service("subTalkService")
public class SubTalkServiceImpl extends BaseServiceImpl<SubTalkMapper, SubTalkEntity> implements ISubTalkService {
    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;

    @Value("${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value("${gysUrl.updateSupOffer}")
    private String updateSupOffer;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-talk-code";
    @Autowired
    private ISubTalkDetailService subTalkDetailService;
    @Autowired
    private ISubTalkRecordService subTalkRecordService;
    @Autowired
    private ISubTalkRecordDetailService subTalkRecordDetailService;
    @Autowired
    private ISubDocumentSellService subDocumentSellService;
    @Autowired
    private ISubDocumentService subDocumentService;
    @Autowired
    private ISubInviteService subInviteService;
    @Autowired
    private ISubDocumentSupplierService subDocumentSupplierService;
    @Autowired
    private ISubDocumentSchemeService subDocumentSchemeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProcessService processService;
    private org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000002";
    @Transactional
    @Override
    public SubTalkVO publishTalk(Long id) {
        //更新发布状态
        SubTalkEntity subTalkEntity = super.selectById(id);
        subTalkEntity.setPublishFlag(0);
        super.updateById(subTalkEntity);

        //推送供应商
        SubDocumentSupplierTbVO subDocumentSupplierTbVO = new SubDocumentSupplierTbVO();
        subDocumentSupplierTbVO.setSourceId(subTalkEntity.getInviteId().toString());
        subDocumentSupplierTbVO.setSourceType("郑州一建洽商谈判");
        subDocumentSupplierTbVO.setNoticeType(4);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(subTalkEntity.getTalkStartTime());
        subDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(subTalkEntity.getTalkEndTime());
        subDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        subDocumentSupplierTbVO.setMemo(subTalkEntity.getMemo());
        subDocumentSupplierTbVO.setTalkMoney(subTalkEntity.getTalkMoney());
        subDocumentSupplierTbVO.setTalkNum(subTalkEntity.getTalkNum());
        subDocumentSupplierTbVO.setTenderName(subTalkEntity.getTalkName());
        subDocumentSupplierTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        String stringFb = JSONObject.toJSONString(subDocumentSupplierTbVO);
        logger.info("洽商谈判发布" + stringFb);
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("洽商谈判同步供方接口报错" + stringCommonResponse.getMsg());
        }
        return queryDetail(id);
    }

    @Override
    public SubTalkVO extendTalk(SubTalkDetailVO subTalkDetailVO) {
        SubTalkDetailEntity subDocumentRecordEntity = BeanMapper.map(subTalkDetailVO, SubTalkDetailEntity.class);
        subTalkDetailService.save(subDocumentRecordEntity);
        SubTalkEntity subTalkEntity = super.selectById(subTalkDetailVO.getTalkId());
        subTalkEntity.setTalkEndTime(subTalkDetailVO.getNewTime());
        boolean b = super.updateById(subTalkEntity);

        //推送供方
        SupplierSellVO supplierSellVO = new SupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(subTalkEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(subTalkDetailVO.getNewTime());

        String stringFb = JSONObject.toJSONString(supplierSellVO);

        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(updateTimeUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("洽商谈判同步供方接口报错" + stringCommonResponse.getMsg());
        }
//        try {
//            response = new ThirdSystemUtils().sendPostReq(tokenUrl,updateTimeUrl, stringFb,cacheManager);
//            if(!response.isSuccess()) {
//                throw new BusinessException("洽商谈判同步供方接口报错" + response.getMsg());
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            throw new BusinessException("洽商谈判同步供方接口报错" + response.getMsg());
//        }

        return queryDetail(subTalkDetailVO.getTalkId());
    }

    @Override
    public SubTalkVO saveTalk(Long documentId) {
        SubTalkEntity entity = new SubTalkEntity();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        SubDocumentEntity documentEntity = subDocumentService.selectById(documentId);
        documentEntity.setNextFlag(0);
        subDocumentService.saveOrUpdate(documentEntity);
        //查询招标立项信息
        SubDocumentEntity subDocumentEntity = subDocumentService.selectById(documentId);
        SubInviteEntity subInviteEntity = subInviteService.selectById(subDocumentEntity.getInviteId());
        entity.setProjectCode(subDocumentEntity.getProjectCode());
        entity.setInviteId(subDocumentEntity.getInviteId());
        entity.setProjectId(subDocumentEntity.getProjectId());
        entity.setProjectName(subDocumentEntity.getProjectName());
        entity.setOrgId(subDocumentEntity.getOrgId());
        entity.setOrgName(subDocumentEntity.getOrgName());
        entity.setParentOrgId(subDocumentEntity.getParentOrgId());
        entity.setParentOrgName(subDocumentEntity.getParentOrgName());
        entity.setBrandFlag(subDocumentEntity.getBrandFlag());
        entity.setBillId(documentId);
        entity.setTalkNum(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        String taikNumName = "第" + entity.getTalkNum() + "轮报价";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(subDocumentEntity.getPurchaseType());
        entity.setTalkName(subInviteEntity.getTenderName());
        super.save(entity);

        //回写招标阶段

        subInviteEntity.setTenderStage(7);
        subInviteService.updateById(subInviteEntity);

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("洽商谈判");
        processEntity.setTenderId(subDocumentEntity.getInviteId());
        processEntity.setType(1);
        processEntity.setFrontendUrl("sub/talkNegotiate");
        processService.saveOrUpdate(processEntity);

        SubTalkVO vo = BeanMapper.map(entity, SubTalkVO.class);

        SubTalkVO subTalkVO = queryDetail(vo.getId());
        return subTalkVO;
    }

    @Override
    public SubTalkVO queryDetail(Long id) {
        SubTalkEntity subTalkEntity = super.selectById(id);
        SubTalkVO subTalkVO = BeanMapper.map(subTalkEntity, SubTalkVO.class);

        //确认轮数
        Integer talkNum = subTalkEntity.getTalkNum();
        if (subTalkEntity.getPublishFlag() == 1){
            talkNum = talkNum - 1;
        }
        SubDocumentVO subDocumentVO = subDocumentService.queryDocDetail(subTalkEntity.getBillId(), talkNum);

        //查询供应商报价方案数据


        subTalkVO.setSubDocumentDetailSellList(subDocumentVO.getSubDocumentDetailSellList());
        subTalkVO.setSubDocumentSupplierSchemeList(subDocumentVO.getSubDocumentSupplierSchemeList());

        //查询首轮报价的供应商信息
        LambdaQueryWrapper<SubDocumentSupplierEntity> lambda = Wrappers.<SubDocumentSupplierEntity>lambdaQuery();
        lambda.eq(SubDocumentSupplierEntity::getDocumentId, subTalkEntity.getBillId());
        lambda.eq(SubDocumentSupplierEntity::getTalkNum, 0);
        List<SubDocumentSupplierEntity> supplierList = subDocumentSupplierService.list(lambda);
        List<SubDocumentSupplierVO> documentSupplierVOList = BeanMapper.mapList(supplierList,SubDocumentSupplierVO.class);
        subTalkVO.setSubDocumentSupplierList(documentSupplierVOList);

        //查询变更历史记录
        LambdaQueryWrapper<SubTalkRecordEntity> lambdaRecord = Wrappers.lambdaQuery();
        lambdaRecord.eq(SubTalkRecordEntity::getBillId,subTalkEntity.getBillId());
        lambdaRecord.orderByAsc(SubTalkRecordEntity::getTalkNum);
        List<SubTalkRecordEntity> subTalkRecordEntityList = subTalkRecordService.list(lambdaRecord);
        List<SubTalkRecordVO> subTalkRecordList = BeanMapper.mapList(subTalkRecordEntityList, SubTalkRecordVO.class);
        subTalkVO.setTalkRecordEntityList(subTalkRecordList);
        return subTalkVO;
    }
    @Transactional
    @Override
    public SubTalkVO againSaveTalk(Long id) {
        SubTalkEntity entity = new SubTalkEntity();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //查询招标立项信息
        SubTalkEntity subTalkEntity = super.selectById(id);
        entity.setProjectCode(subTalkEntity.getProjectCode());
        entity.setProjectId(subTalkEntity.getProjectId());
        entity.setProjectName(subTalkEntity.getProjectName());
        entity.setOrgId(subTalkEntity.getOrgId());
        entity.setOrgName(subTalkEntity.getOrgName());
        entity.setParentOrgId(subTalkEntity.getParentOrgId());
        entity.setParentOrgName(subTalkEntity.getParentOrgName());
        entity.setBrandFlag(subTalkEntity.getBrandFlag());
        entity.setBillId(subTalkEntity.getBillId());
        entity.setInviteId(subTalkEntity.getInviteId());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setTalkNum(subTalkEntity.getTalkNum() + 1);
        String taikNumName = "第" + entity.getTalkNum() + "轮报价";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(subTalkEntity.getPurchaseType());
        super.save(entity);

        //保存历史记录表
        SubTalkRecordEntity subTalkRecordEntity =  BeanMapper.map(subTalkEntity, SubTalkRecordEntity.class);
        subTalkRecordEntity.setTalkId(subTalkEntity.getId());
        subTalkRecordEntity.setId(null);
        subTalkRecordService.save(subTalkRecordEntity);
        //新增历史记录子表
        List<SubTalkDetailEntity> subTalkDetailList = subTalkEntity.getSubTalkDetailList();
        List<SubTalkRecordDetailEntity> subTalkRecordDetailEntityList = BeanMapper.mapList(subTalkDetailList, SubTalkRecordDetailEntity.class);
        for (SubTalkRecordDetailEntity subTalkRecordDetailEntity : subTalkRecordDetailEntityList){
            subTalkRecordDetailEntity.setId(null);
            subTalkRecordDetailEntity.setRecordId(subTalkRecordEntity.getId());
        }
        subTalkRecordDetailService.saveBatch(subTalkRecordDetailEntityList);

        //删除老数据
        super.removeById(id,false);

        //修改进展表信息
        LambdaQueryWrapper<ProcessEntity> lambdaProcess = Wrappers.<ProcessEntity>lambdaQuery();
        lambdaProcess.eq(ProcessEntity::getBillId,id);
        lambdaProcess.eq(ProcessEntity::getTenderId,subTalkEntity.getInviteId());
        ProcessEntity processEntity = processService.getOne(lambdaProcess);
        processEntity.setBillId(entity.getId());
        processService.updateById(processEntity);
        SubTalkVO vo = BeanMapper.map(entity, SubTalkVO.class);
        addLastSell(subTalkEntity.getTalkNum(),subTalkEntity.getBillId());

        return queryDetail(entity.getId());
    }

    @Override
    public SubTalkVO replenishSell(Long id) {
        SubTalkEntity subTalkEntity = super.selectById(id);

        Integer talkNum = subTalkEntity.getTalkNum();
        Long billId = subTalkEntity.getBillId();
        addLastSell(talkNum,billId);

        return new SubTalkVO();
    }

    @Override
    public Boolean getSellFull(Long id) {
        //获取最新轮数
        SubTalkEntity subTalkEntity = super.selectById(id);
        Integer talkNum = subTalkEntity.getTalkNum();
        LambdaQueryWrapper<SubDocumentSupplierEntity> lambdaSupplier = Wrappers.<SubDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(SubDocumentSupplierEntity::getDocumentId, subTalkEntity.getBillId());
        lambdaSupplier.eq(SubDocumentSupplierEntity::getTalkNum, talkNum);
        List<SubDocumentSupplierEntity> supplierList = subDocumentSupplierService.list(lambdaSupplier);
        LambdaQueryWrapper<SubDocumentSupplierEntity> lambdaSupplierFirst = Wrappers.<SubDocumentSupplierEntity>lambdaQuery();
        lambdaSupplierFirst.eq(SubDocumentSupplierEntity::getDocumentId, subTalkEntity.getBillId());
        lambdaSupplierFirst.eq(SubDocumentSupplierEntity::getTalkNum, 0);
        List<SubDocumentSupplierEntity> supplierListFirst = subDocumentSupplierService.list(lambdaSupplierFirst);
        if (supplierListFirst == null || supplierListFirst.size() == 0){
            return false;
        }
        if (supplierList.size() != supplierListFirst.size()){
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> querySupplierList(Long talkId) {
        Map<String, Object> stringListMap = new HashMap<>();
        SubTalkEntity subTalkEntity = baseMapper.selectById(talkId);
        List<SubQuotationMaterialVO> materialVOList = new ArrayList<>();
        //查询所有数据
        List<SubDocumentSellEntity> subDocumentSellEntities = subDocumentSellService.selectMaterialType(subTalkEntity.getBillId());
        Integer talkNum = subDocumentSellEntities.get(0).getTalkNum();
        List<SubDocumentSellVO> sellEntityList = BeanMapper.mapList(subDocumentSellEntities, SubDocumentSellVO.class);
        //根据材料分类
        Map<String, List<SubDocumentSellVO>> listMap = sellEntityList.stream().filter(map->map.getMaterialCode() != null).collect(Collectors.groupingBy(SubDocumentSellVO::getMaterialCode));
            for (String materialTypeId : listMap.keySet()) {
                SubQuotationMaterialVO materialVO = new SubQuotationMaterialVO();
                //获取供应商
                List<SubDocumentSellVO> materialTypeList = listMap.get(materialTypeId);
                for (SubDocumentSellVO sellVO : materialTypeList) {
                    materialVO  =  BeanMapper.map(sellVO, SubQuotationMaterialVO.class);
                }
                List<SubQuotationSupplierVO> subQuotationSupplierVOS = BeanMapper.mapList(materialTypeList, SubQuotationSupplierVO.class);
                //供应商ID去重
                List<SubQuotationSupplierVO> supplierVOS = subQuotationSupplierVOS.stream()
                        .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(f -> f.getSupplierId()))), ArrayList::new));
                materialVO.setSupplierList(supplierVOS);
                //根据供应商分类
                Map<Long, List<SubDocumentSellVO>> supplierMap = materialTypeList.stream().filter(map->map.getSupplierId() != null).collect(Collectors.groupingBy(SubDocumentSellVO::getSupplierId));

                for (SubQuotationSupplierVO supplierVO : materialVO.getSupplierList()) {
                    //获取方案
                    List<SubDocumentSellVO> subDocumentSellVOS = supplierMap.get(supplierVO.getSupplierId());
                    for (SubDocumentSellVO subDocumentSellVO : subDocumentSellVOS) {
                        supplierVO.setSupplierName(subDocumentSellVO.getSupplierName());
                    }
                    List<SubQuotationSchemeVO> subQuotationSchemeVOS = BeanMapper.mapList(subDocumentSellVOS, SubQuotationSchemeVO.class);
                    //根据方案名称去重
                    List<SubQuotationSchemeVO> schemeVOS = subQuotationSchemeVOS.stream()
                            .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(f -> f.getSchemeName()))), ArrayList::new));
                    supplierVO.setSchemeList(schemeVOS);
                    Map<String, List<SubDocumentSellVO>> schemeMap = subDocumentSellVOS.stream().filter(map->map.getSchemeName() != null).collect(Collectors.groupingBy(SubDocumentSellVO::getSchemeName));
                    for (SubQuotationSchemeVO subQuotationSchemeVO : supplierVO.getSchemeList()) {
                        List<SubDocumentSellVO> priceList = schemeMap.get(subQuotationSchemeVO.getSchemeName());
                        //如果轮数小于最大轮数，添加一个空的对象
                        if (priceList.size()<talkNum+1){
                            SubDocumentSellVO documentSellVO = new SubDocumentSellVO();
                            documentSellVO.setPrice(BigDecimal.valueOf(-1));
                            documentSellVO.setPriceTax(BigDecimal.valueOf(-1));
                            documentSellVO.setMoney(BigDecimal.valueOf(-1));
                            documentSellVO.setMoneyTax(BigDecimal.valueOf(-1));
                            documentSellVO.setTalkNum(talkNum);
                            priceList.add(0,documentSellVO);
                        }
                        subQuotationSchemeVO.setPriceList(priceList);
                    }
                }
                materialVOList.add(materialVO);
            }
        stringListMap.put("MaterialTypeList",materialVOList);
        stringListMap.put("offerNum",subDocumentSellEntities.get(0).getTalkNum());
        return stringListMap;
    }

    @Override
    public SubTalkVO saveOrUpdates(SubTalkVO saveorUpdateVO) {
        SubTalkEntity entity = BeanMapper.map(saveorUpdateVO, SubTalkEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        SubTalkVO vo = BeanMapper.map(entity, SubTalkVO.class);
        SubTalkVO subTalkVO = queryDetail(vo.getId());
        return subTalkVO;
    }

    private void addLastSell(Integer talkNum, Long docId) {
        //补足未报价供应商信息
        //查询上一轮数
        //查询报价信息,判断本轮没有报价的供应商
        LambdaQueryWrapper<SubDocumentSupplierEntity> lambdaSupplier = Wrappers.<SubDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(SubDocumentSupplierEntity::getDocumentId, docId);
        lambdaSupplier.eq(SubDocumentSupplierEntity::getTalkNum, talkNum);
        List<SubDocumentSupplierEntity> supplierList = subDocumentSupplierService.list(lambdaSupplier);

        //查询
        LambdaQueryWrapper<SubDocumentSupplierEntity> lambdaSupplierLast = Wrappers.<SubDocumentSupplierEntity>lambdaQuery();
        lambdaSupplierLast.eq(SubDocumentSupplierEntity::getDocumentId, docId);
        lambdaSupplierLast.eq(SubDocumentSupplierEntity::getTalkNum, talkNum - 1);
        List<SubDocumentSupplierEntity> supplierListLast = subDocumentSupplierService.list(lambdaSupplierLast);
        List<Long> supplierPk = supplierList.stream().map(SubDocumentSupplierEntity::getSupplierId).collect(Collectors.toList());
        List<SubDocumentSupplierEntity> documentSupplierEntityDataList = supplierListLast.stream().filter(s -> !supplierPk.contains(s.getSupplierId())).collect(Collectors.toList());
        List<SubDocumentSupplierEntity> documentSupplierEntityNewList = BeanMapper.mapList(documentSupplierEntityDataList,SubDocumentSupplierEntity.class);
        if (documentSupplierEntityNewList.size() == 0){
            return;
        }

        //推送供应商数据提示信息
        List<SupplierReplenishVO> replenishVOArrayList = new ArrayList<>();
        SubDocumentEntity subDocumentEntity = subDocumentService.selectById(docId);
        for (SubDocumentSupplierEntity subDocumentSupplierEntity : documentSupplierEntityNewList){
            SupplierReplenishVO supplierReplenishVO = new SupplierReplenishVO();
            supplierReplenishVO.setSourceId(Long.toString(subDocumentEntity.getInviteId()));
            supplierReplenishVO.setTalkNum(talkNum);
            supplierReplenishVO.setTenantId(Long.toString(subDocumentSupplierEntity.getSupplierTenantId()));
            replenishVOArrayList.add(supplierReplenishVO);
        }
        String stringFb = JSONObject.toJSONString(replenishVOArrayList);
        logger.info("再次洽商推送供方接口数据:" + stringFb);
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(updateSupOffer, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("再次洽商推送供方接口数据response:" + stringCommonResponse.getMsg());
        }




        List<Long> supplierPkNew = documentSupplierEntityNewList.stream().map(SubDocumentSupplierEntity::getId).collect(Collectors.toList());

        for (SubDocumentSupplierEntity subDocumentSupplierEntity : documentSupplierEntityNewList){
            subDocumentSupplierEntity.setId(IdWorker.getId());
            subDocumentSupplierEntity.setTalkNum(talkNum);
        }
        subDocumentSupplierService.saveBatch(documentSupplierEntityNewList);

        //复制上一轮未报价的供应商的附件信息
        for (SubDocumentSupplierEntity subDocumentSupplierEntity : documentSupplierEntityNewList){
            for (SubDocumentSupplierEntity subDocumentSupplierLastEntity : supplierListLast){
                if (subDocumentSupplierEntity.getSupplierId().equals(subDocumentSupplierLastEntity.getSupplierId())){
                    CommonResponse<String> responseCopy = attachmentApi.copyFilesFromSourceBillToTargetBill(
                            subDocumentSupplierLastEntity.getId().toString(),
                            BILL_SUPPLIER_TYPE,
                            "supplierFileType",
                            subDocumentSupplierEntity.getId().toString(),
                            BILL_SUPPLIER_TYPE,
                            "supplierFileType"
                    );
                    if (!responseCopy.isSuccess()) {
                        throw new BusinessException("再次洽商附件复制失败:" + responseCopy.getMsg());
                    }
                }

            }
        }

        //查询上一轮未报价供应商的方案
        LambdaQueryWrapper<SubDocumentSchemeEntity> lambdaScheme = Wrappers.<SubDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(SubDocumentSchemeEntity::getDocumentId, docId);
        lambdaScheme.eq(SubDocumentSchemeEntity::getTalkNum, talkNum - 1);
        lambdaScheme.in(SubDocumentSchemeEntity::getDocumentSupplierId, supplierPkNew);
        List<SubDocumentSchemeEntity> schemeList = subDocumentSchemeService.list(lambdaScheme);
        List<Long> schemePkList = schemeList.stream().map(SubDocumentSchemeEntity::getId).collect(Collectors.toList());
        for (SubDocumentSchemeEntity subDocumentSchemeEntity : schemeList){
            subDocumentSchemeEntity.setId(IdWorker.getId());
            subDocumentSchemeEntity.setTalkNum(talkNum);
            for (SubDocumentSupplierEntity subDocumentSupplierEntity : documentSupplierEntityNewList){
                if (subDocumentSchemeEntity.getSupplierId().equals(subDocumentSupplierEntity.getSupplierId())){
                    subDocumentSchemeEntity.setDocumentSupplierId(subDocumentSupplierEntity.getId());
                }
            }
        }
        subDocumentSchemeService.saveBatch(schemeList);

        //查询上一轮未报价供应商的方案详情
        LambdaQueryWrapper<SubDocumentSellEntity> lambdaSell = Wrappers.<SubDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(SubDocumentSellEntity::getDocumentId, docId);
        lambdaSell.eq(SubDocumentSellEntity::getTalkNum, talkNum - 1);
        lambdaSell.in(SubDocumentSellEntity::getSchemeId, schemePkList);
        List<SubDocumentSellEntity> sellList = subDocumentSellService.list(lambdaSell);
        for (SubDocumentSellEntity subDocumentSellEntity : sellList){
            subDocumentSellEntity.setId(null);
            subDocumentSellEntity.setTalkNum(talkNum);
            for (SubDocumentSchemeEntity subDocumentSchemeEntity : schemeList){
                if (subDocumentSellEntity.getSupplierId().equals(subDocumentSchemeEntity.getSupplierId()) &&
                        subDocumentSellEntity.getSchemeName().equals(subDocumentSchemeEntity.getSchemeName())){
                    subDocumentSellEntity.setSchemeId(subDocumentSchemeEntity.getId());
                }

            }
        }
        subDocumentSellService.saveBatch(sellList);
    }
}
