package com.ejianc.business.tender.prosub.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.prosub.pricelib.vo.PriceContractCollectVO;
import com.ejianc.business.tender.prosub.bean.ProsubInviteDetailEntity;
import com.ejianc.business.tender.prosub.bean.ProsubInviteEntity;
import com.ejianc.business.tender.prosub.mapper.ProsubInviteMapper;
import com.ejianc.business.tender.prosub.service.IProsubInviteService;
import com.ejianc.business.tender.prosub.vo.ProsubInviteDetailBidderVO;
import com.ejianc.business.tender.prosub.vo.ProsubInviteDetailRecordVO;
import com.ejianc.business.tender.prosub.vo.ProsubInviteDetailVO;
import com.ejianc.business.tender.prosub.vo.ProsubInviteVO;
import com.ejianc.business.tender.sub.bean.SubInviteDetailEntity;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.mapper.SubInviteMapper;
import com.ejianc.business.tender.sub.vo.SubInviteDetailBidderVO;
import com.ejianc.business.tender.sub.vo.SubInviteDetailRecordVO;
import com.ejianc.business.tender.sub.vo.SubInviteDetailVO;
import com.ejianc.business.tender.sub.vo.SubInviteVO;
import com.ejianc.business.tender.util.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 材料立项主表
 * 
 * @author generator
 * 
 */
@Service("prosubInviteService")
public class ProsubInviteServiceImpl extends BaseServiceImpl<ProsubInviteMapper, ProsubInviteEntity> implements IProsubInviteService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public void updateTenderStage(String id, int tenderStage) {
        baseMapper.updateTenderStage(id, tenderStage);
    }

    @Override
    public void updateAbolishType(String id, int abolishType) {
        baseMapper.updateAbolishType(id, abolishType);
    }

    @Override
    public List<ProsubInviteDetailVO> selectSumDetail(Long inviteId) {
        return baseMapper.selectSumDetail(inviteId);
    }

    @Override
    public List<ProsubInviteDetailVO> selectOrgSumDetail(Long inviteId) {
        return baseMapper.selectOrgSumDetail(inviteId);
    }

    @Override
    public ProsubInviteVO queryDetailTree(Long id) {
        Map<String, LinkedHashMap<String, String>> orderMap = new HashMap<>();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<>();
        orderParams.put("treeIndex", QueryParam.ASC);
        orderMap.put("subDetailRecord", orderParams);


        ProsubInviteEntity subInviteEntity = super.selectById(id, orderMap);
        ProsubInviteVO subInviteVO = BeanMapper.map(subInviteEntity, ProsubInviteVO.class);

        //明细子表排序为树形
        if (CollectionUtils.isNotEmpty(subInviteVO.getSubDetailRecord())) {
            for (ProsubInviteDetailRecordVO detail : subInviteVO.getSubDetailRecord()) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            subInviteVO.setSubDetailRecord(TreeNodeBUtil.buildTree(subInviteVO.getSubDetailRecord()));
        }
        if (CollectionUtils.isNotEmpty(subInviteVO.getSubDetailBidder())) {
            for (ProsubInviteDetailBidderVO detail1 : subInviteVO.getSubDetailBidder()) {
                detail1.setTid(detail1.getId().toString());
                detail1.setTpid(detail1.getParentId() != null ? detail1.getParentId().toString() : null);
            }
            subInviteVO.setSubDetailBidder(TreeNodeBUtil.buildTree(subInviteVO.getSubDetailBidder()));
        }
        subInviteVO.setSubDetailBidder(subInviteVO.getSubDetailBidder());
        return subInviteVO;
    }

    @Override
    public List<ProsubInviteDetailBidderVO> selectDetailBidder(Long inviteId) {
        return baseMapper.selectDetailBidder(inviteId);
    }

    @Override
    public List<ProsubInviteDetailBidderVO> querySonDetail(Long inviteId) {
        return baseMapper.querySonDetail(inviteId);
    }
    @Override
    public IPage<PriceContractCollectVO> queryHistoryPrice(Map<String,Object> param) {
        logger.info("进入材料查询历史价格区间查询接口param-{}", param);


        //获取子表档案id
        List<Long> ids = JSON.parseArray(JSON.toJSONString(param.get("ids")), Long.class);
        //对子表信息按照档案id进行合并
        List<Long> docIdList = ids.stream().distinct().collect(Collectors.toList());

        /**
         * 实现分页、非分页二合一
         */
        if(param.get("pageIndex") == null || param.get("pageSize") == null){
            Page<PriceContractCollectVO> page = new Page<>();
            //调用价格库接口查询历史价格信息
            IPage<PriceContractCollectVO> priceContractCollectVOS = baseMapper.queryHistoryPrice(page,docIdList);
            page.setRecords(priceContractCollectVOS.getRecords());
            return page;

        }
        //获取分页信息
        long pageIndex = Long.parseLong(param.get("pageIndex").toString());//当前页
        long pageSize = Long.parseLong(param.get("pageSize").toString());//每页显示条数
        Page<PriceContractCollectVO> page = new Page<PriceContractCollectVO>(pageIndex,pageSize);
        //调用价格库接口查询历史价格信息
        Page<PriceContractCollectVO> priceContractCollectVOS = baseMapper.queryHistoryPrice(page,docIdList);


        return priceContractCollectVOS;
    }
}
