package com.ejianc.business.tender.report.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.cost.vo.SupbidNoticeVO;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentPicketageEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentPicketageRefsupplierEntity;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.equipment.service.IEquipmentPicketageRefsupplierService;
import com.ejianc.business.tender.equipment.service.IEquipmentPicketageService;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.bean.OtherPicketageEntity;
import com.ejianc.business.tender.other.bean.OtherPicketageRefsupplierEntity;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.service.IOtherPicketageRefsupplierService;
import com.ejianc.business.tender.other.service.IOtherPicketageService;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.bean.RentPicketageEntity;
import com.ejianc.business.tender.rent.bean.RentPicketageRefsupplierEntity;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rent.service.IRentPicketageRefsupplierService;
import com.ejianc.business.tender.rent.service.IRentPicketageService;
import com.ejianc.business.tender.report.mapper.ReportMapper;
import com.ejianc.business.tender.report.service.IReportService;
import com.ejianc.business.tender.report.vo.BidDataVO;
import com.ejianc.business.tender.report.vo.ReportVO;
import com.ejianc.business.tender.report.vo.SupplierReportVO;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.bean.RmatPicketageEntity;
import com.ejianc.business.tender.rmat.bean.RmatPicketageRefsupplierEntity;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.rmat.service.IRmatPicketageRefsupplierService;
import com.ejianc.business.tender.rmat.service.IRmatPicketageService;
import com.ejianc.business.tender.stuff.bean.StuffInviteEntity;
import com.ejianc.business.tender.stuff.bean.StuffPicketageEntity;
import com.ejianc.business.tender.stuff.bean.StuffPicketageRefsupplierEntity;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.stuff.service.IStuffPicketageRefsupplierService;
import com.ejianc.business.tender.stuff.service.IStuffPicketageService;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.bean.SubPicketageEntity;
import com.ejianc.business.tender.sub.bean.SubPicketageRefsupplierEntity;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.sub.service.ISubPicketageRefsupplierService;
import com.ejianc.business.tender.sub.service.ISubPicketageService;
import com.ejianc.business.tender.util.MathUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 材料立项主表
 *
 * @author generator
 */
@Service("reportService")
public class ReportServiceImpl implements IReportService {
    @Autowired
    private ReportMapper reportMapper;

    @Autowired
    private IStuffInviteService stuffInviteService;

    @Autowired
    private ISubInviteService subInviteService;

    @Autowired
    private IEquipmentInviteService equipmentInviteService;

    @Autowired
    private IRentInviteService rentInviteService;

    @Autowired
    private IRmatInviteService rmatInviteService;

    @Autowired
    private IOtherInviteService otherInviteService;

    @Autowired
    private IStuffPicketageService stuffPicketageService;

    @Autowired
    private ISubPicketageService subPicketageService;

    @Autowired
    private IEquipmentPicketageService equipmentPicketageService;

    @Autowired
    private IRentPicketageService rentPicketageService;

    @Autowired
    private IRmatPicketageService rmatPicketageService;

    @Autowired
    private IOtherPicketageService otherPicketageService;

    @Autowired
    private IStuffPicketageRefsupplierService stuffPicketageRefsupplierService;

    @Autowired
    private ISubPicketageRefsupplierService subPicketageRefsupplierService;

    @Autowired
    private IEquipmentPicketageRefsupplierService equipmentPicketageRefsupplierService;

    @Autowired
    private IRentPicketageRefsupplierService rentPicketageRefsupplierService;

    @Autowired
    private IRmatPicketageRefsupplierService rmatPicketageRefsupplierService;

    @Autowired
    private IOtherPicketageRefsupplierService otherPicketageRefsupplierService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi iOrgApi;
    private org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Map<String,Object> queryData(QueryParam param) {
        IPage<ReportVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<ReportVO> list = reportMapper.refPurchaseAcceptanceData(changeToQueryWrapper(param), page);
        List<ReportVO> list1 = reportMapper.refPurchaseAcceptanceAllData(changeToQueryWrapper(param));
        BigDecimal sumTaxMoney = BigDecimal.ZERO;
        //将list里的金额合并
        if (CollectionUtils.isNotEmpty(list1)) {
            logger.info("招标统计数据:{}", JSONObject.toJSONString(list1));
            for (ReportVO reportVO : list1) {
                if (reportVO.getEstablishType()==1){
                    if (reportVO.getLineTypeName().equals("分包招标")){
                        reportVO.setTaxMoney(reportVO.getTaxMoney());
                    }else {
                        reportVO.setTaxMoney(reportVO.getTaxMoney());
                    }
                }
                sumTaxMoney = MathUtil.safeAdd(sumTaxMoney, reportVO.getTaxMoney());
            }
        }
        IPage<ReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        Map<String,Object> map = new HashMap<>();
        map.put("page", pageData);
        map.put("sumTaxMoney", sumTaxMoney);
        return map;
    }

    @Override
    public IPage<SupplierReportVO> querySupplierReportData(QueryParam param, Long supplierId) {
        IPage<SupplierReportVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<SupplierReportVO> list = reportMapper.querySupplierReportData(changeToQueryWrapper(param), page, supplierId);
        IPage<SupplierReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return pageData;
    }

    @Override
    public BigDecimal queryMoney(Integer tenderType, String tenderTypeName, String firstDayOfMonth, String lastDayOfMonth) {
        //材料
        BigDecimal stuffMoney = BigDecimal.ZERO;
        LambdaQueryWrapper<StuffInviteEntity> publicStuffInviteWrapper = new LambdaQueryWrapper<>();
        publicStuffInviteWrapper.eq(StuffInviteEntity::getEstablishType, 1)
                .in(StuffInviteEntity::getBillState, 1, 3)
                .eq(StuffInviteEntity::getDr, 0)
                .in(StuffInviteEntity::getOrgId, iOrgApi.findChildrenByParentId(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()))
                .eq(StuffInviteEntity::getTenantId, InvocationInfoProxy.getTenantid())
                .eq(StuffInviteEntity::getTenderType, tenderType);

        if (StringUtils.isNotEmpty(firstDayOfMonth)) {
            publicStuffInviteWrapper.between(StuffInviteEntity::getCreateDate, firstDayOfMonth, lastDayOfMonth);
        }

        LambdaQueryWrapper<StuffPicketageEntity> publicStuffPicketageWrapper = new LambdaQueryWrapper<>();
        publicStuffPicketageWrapper.eq(StuffPicketageEntity::getTenderTypeName, tenderTypeName)
                .eq(StuffPicketageEntity::getDr, 0)
                .in(StuffPicketageEntity::getOrgId, iOrgApi.findChildrenByParentId(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()))
                .eq(StuffPicketageEntity::getTenantId, InvocationInfoProxy.getTenantid())
                .in(StuffPicketageEntity::getBillState, 1, 3);
        if (StringUtils.isNotEmpty(firstDayOfMonth)) {
            publicStuffPicketageWrapper.between(StuffPicketageEntity::getPicketageTime, firstDayOfMonth, lastDayOfMonth);
        }


        List<Long> publicStuffInviteIdList = stuffInviteService.list(publicStuffInviteWrapper).stream().map(StuffInviteEntity::getId).collect(Collectors.toList());
        List<Long> publicStuffPicketageIdList = stuffPicketageService.list(publicStuffPicketageWrapper).stream().map(StuffPicketageEntity::getId).collect(Collectors.toList());
        publicStuffInviteIdList.addAll(publicStuffPicketageIdList);

        if (CollectionUtils.isNotEmpty(publicStuffInviteIdList)) {
            LambdaQueryWrapper<StuffPicketageRefsupplierEntity> publicStuffPicketageRefSupplierWrapper = new LambdaQueryWrapper<>();
            publicStuffPicketageRefSupplierWrapper.in(StuffPicketageRefsupplierEntity::getPicketageId, publicStuffInviteIdList);
            stuffMoney = stuffPicketageRefsupplierService.list(publicStuffPicketageRefSupplierWrapper).stream().filter(e -> e.getMoneyTax() != null).map(StuffPicketageRefsupplierEntity::getMoneyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            logger.info("材料数据条数:{}", publicStuffInviteIdList.size());
        }

        //分包
        BigDecimal subMoney = BigDecimal.ZERO;
        LambdaQueryWrapper<SubInviteEntity> publicSubInviteWrapper = new LambdaQueryWrapper<>();
        publicSubInviteWrapper.eq(SubInviteEntity::getEstablishType, 1)
                .in(SubInviteEntity::getBillState, 1, 3)
                .eq(SubInviteEntity::getDr, 0)
                .in(SubInviteEntity::getOrgId, iOrgApi.findChildrenByParentId(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()))
                .eq(SubInviteEntity::getTenantId, InvocationInfoProxy.getTenantid())
                .eq(SubInviteEntity::getTenderType, tenderType);

        if (StringUtils.isNotEmpty(firstDayOfMonth)) {
            publicSubInviteWrapper.between(SubInviteEntity::getCreateDate, firstDayOfMonth, lastDayOfMonth);
        }

        LambdaQueryWrapper<SubPicketageEntity> publicSubPicketageWrapper = new LambdaQueryWrapper<>();
        publicSubPicketageWrapper.eq(SubPicketageEntity::getTenderTypeName, tenderTypeName)
                .eq(SubPicketageEntity::getDr, 0)
                .in(SubPicketageEntity::getOrgId, iOrgApi.findChildrenByParentId(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()))
                .eq(SubPicketageEntity::getTenantId, InvocationInfoProxy.getTenantid())
                .in(SubPicketageEntity::getBillState, 1, 3);

        if (StringUtils.isNotEmpty(firstDayOfMonth)) {
            publicSubPicketageWrapper.between(SubPicketageEntity::getPicketageTime, firstDayOfMonth, lastDayOfMonth);
        }

        List<Long> publicSubInviteIdList = subInviteService.list(publicSubInviteWrapper).stream().map(SubInviteEntity::getId).collect(Collectors.toList());
        List<Long> publicSubPicketageIdList = subPicketageService.list(publicSubPicketageWrapper).stream().map(SubPicketageEntity::getId).collect(Collectors.toList());
        publicSubInviteIdList.addAll(publicSubPicketageIdList);

        if (CollectionUtils.isNotEmpty(publicSubInviteIdList)) {
            LambdaQueryWrapper<SubPicketageRefsupplierEntity> publicSubPicketageRefSupplierWrapper = new LambdaQueryWrapper<>();
            publicSubPicketageRefSupplierWrapper.in(SubPicketageRefsupplierEntity::getPicketageId, publicSubInviteIdList);
            subMoney = subPicketageRefsupplierService.list(publicSubPicketageRefSupplierWrapper).stream().filter(e -> e.getMoneyTax() != null).map(SubPicketageRefsupplierEntity::getMoneyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            logger.info("分包数据条数:{}", publicSubInviteIdList.size());
        }


        //设备采购
        BigDecimal equipmentMoney = BigDecimal.ZERO;
        LambdaQueryWrapper<EquipmentInviteEntity> publicEquipmentInviteWrapper = new LambdaQueryWrapper<>();
        publicEquipmentInviteWrapper.eq(EquipmentInviteEntity::getEstablishType, 1)
                .in(EquipmentInviteEntity::getBillState, 1, 3)
                .eq(EquipmentInviteEntity::getDr, 0)
                .in(EquipmentInviteEntity::getOrgId, iOrgApi.findChildrenByParentId(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()))
                .eq(EquipmentInviteEntity::getTenantId, InvocationInfoProxy.getTenantid())
                .eq(EquipmentInviteEntity::getTenderType, tenderType);

        if (StringUtils.isNotEmpty(firstDayOfMonth)) {
            publicEquipmentInviteWrapper.between(EquipmentInviteEntity::getCreateDate, firstDayOfMonth, lastDayOfMonth);
        }

        LambdaQueryWrapper<EquipmentPicketageEntity> publicEquipmentPicketageWrapper = new LambdaQueryWrapper<>();
        publicEquipmentPicketageWrapper.eq(EquipmentPicketageEntity::getTenderTypeName, tenderTypeName)
                .eq(EquipmentPicketageEntity::getDr, 0)
                .in(EquipmentPicketageEntity::getOrgId, iOrgApi.findChildrenByParentId(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()))
                .eq(EquipmentPicketageEntity::getTenantId, InvocationInfoProxy.getTenantid())
                .in(EquipmentPicketageEntity::getBillState, 1, 3);

        if (StringUtils.isNotEmpty(firstDayOfMonth)) {
            publicEquipmentPicketageWrapper.between(EquipmentPicketageEntity::getPicketageTime, firstDayOfMonth, lastDayOfMonth);
        }

        List<Long> publicEquipmentInviteIdList = equipmentInviteService.list(publicEquipmentInviteWrapper).stream().map(EquipmentInviteEntity::getId).collect(Collectors.toList());
        List<Long> publicEquipmentPicketageIdList = equipmentPicketageService.list(publicEquipmentPicketageWrapper).stream().map(EquipmentPicketageEntity::getId).collect(Collectors.toList());
        publicEquipmentInviteIdList.addAll(publicEquipmentPicketageIdList);

        if (CollectionUtils.isNotEmpty(publicEquipmentInviteIdList)) {
            LambdaQueryWrapper<EquipmentPicketageRefsupplierEntity> publicEquipmentPicketageRefSupplierWrapper = new LambdaQueryWrapper<>();
            publicEquipmentPicketageRefSupplierWrapper.in(EquipmentPicketageRefsupplierEntity::getPicketageId, publicEquipmentInviteIdList);
            equipmentMoney = equipmentPicketageRefsupplierService.list(publicEquipmentPicketageRefSupplierWrapper).stream().filter(e -> e.getMoneyTax() != null).map(EquipmentPicketageRefsupplierEntity::getMoneyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            logger.info("设备采购数据条数:{}", publicEquipmentInviteIdList.size());
        }


        //设备租赁
        BigDecimal rentMoney = BigDecimal.ZERO;
        LambdaQueryWrapper<RentInviteEntity> publicRentInviteWrapper = new LambdaQueryWrapper<>();
        publicRentInviteWrapper.eq(RentInviteEntity::getEstablishType, 1)
                .in(RentInviteEntity::getBillState, 1, 3)
                .eq(RentInviteEntity::getDr, 0)
                .in(RentInviteEntity::getOrgId, iOrgApi.findChildrenByParentId(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()))
                .eq(RentInviteEntity::getTenantId, InvocationInfoProxy.getTenantid())
                .eq(RentInviteEntity::getTenderType, tenderType);

        if (StringUtils.isNotEmpty(firstDayOfMonth)) {
            publicRentInviteWrapper.between(RentInviteEntity::getCreateDate, firstDayOfMonth, lastDayOfMonth);
        }

        LambdaQueryWrapper<RentPicketageEntity> publicRentPicketageWrapper = new LambdaQueryWrapper<>();
        publicRentPicketageWrapper.eq(RentPicketageEntity::getTenderTypeName, tenderTypeName)
                .eq(RentPicketageEntity::getDr, 0)
                .in(RentPicketageEntity::getOrgId, iOrgApi.findChildrenByParentId(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()))
                .eq(RentPicketageEntity::getTenantId, InvocationInfoProxy.getTenantid())
                .in(RentPicketageEntity::getBillState, 1, 3);

        if (StringUtils.isNotEmpty(firstDayOfMonth)) {
            publicRentPicketageWrapper.between(RentPicketageEntity::getPicketageTime, firstDayOfMonth, lastDayOfMonth);
        }

        List<Long> publicRentInviteIdList = rentInviteService.list(publicRentInviteWrapper).stream().map(RentInviteEntity::getId).collect(Collectors.toList());
        List<Long> publicRentPicketageIdList = rentPicketageService.list(publicRentPicketageWrapper).stream().map(RentPicketageEntity::getId).collect(Collectors.toList());
        publicRentInviteIdList.addAll(publicRentPicketageIdList);

        if (CollectionUtils.isNotEmpty(publicRentInviteIdList)) {
            LambdaQueryWrapper<RentPicketageRefsupplierEntity> publicRentPicketageRefSupplierWrapper = new LambdaQueryWrapper<>();
            publicRentPicketageRefSupplierWrapper.in(RentPicketageRefsupplierEntity::getPicketageId, publicRentInviteIdList);
            rentMoney = rentPicketageRefsupplierService.list(publicRentPicketageRefSupplierWrapper).stream().filter(e -> e.getMoneyTax() != null).map(RentPicketageRefsupplierEntity::getMoneyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            logger.info("设备租赁数据条数:{}", publicRentInviteIdList.size());
        }


        //周转材租赁
        BigDecimal rmatMoney = BigDecimal.ZERO;
        LambdaQueryWrapper<RmatInviteEntity> publicRmatInviteWrapper = new LambdaQueryWrapper<>();
        publicRmatInviteWrapper.eq(RmatInviteEntity::getEstablishType, 1)
                .in(RmatInviteEntity::getBillState, 1, 3)
                .eq(RmatInviteEntity::getDr, 0)
                .in(RmatInviteEntity::getOrgId, iOrgApi.findChildrenByParentId(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()))
                .eq(RmatInviteEntity::getTenantId, InvocationInfoProxy.getTenantid())
                .eq(RmatInviteEntity::getTenderType, tenderType);

        if (StringUtils.isNotEmpty(firstDayOfMonth)) {
            publicRmatInviteWrapper.between(RmatInviteEntity::getCreateDate, firstDayOfMonth, lastDayOfMonth);
        }

        LambdaQueryWrapper<RmatPicketageEntity> publicRmatPicketageWrapper = new LambdaQueryWrapper<>();
        publicRmatPicketageWrapper.eq(RmatPicketageEntity::getTenderTypeName, tenderTypeName)
                .eq(RmatPicketageEntity::getDr, 0)
                .in(RmatPicketageEntity::getOrgId, iOrgApi.findChildrenByParentId(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()))
                .eq(RmatPicketageEntity::getTenantId, InvocationInfoProxy.getTenantid())
                .in(RmatPicketageEntity::getBillState, 1, 3);

        if (StringUtils.isNotEmpty(firstDayOfMonth)) {
            publicRmatPicketageWrapper.between(RmatPicketageEntity::getPicketageTime, firstDayOfMonth, lastDayOfMonth);
        }

        List<Long> publicRmatInviteIdList = rmatInviteService.list(publicRmatInviteWrapper).stream().map(RmatInviteEntity::getId).collect(Collectors.toList());
        List<Long> publicRmatPicketageIdList = rmatPicketageService.list(publicRmatPicketageWrapper).stream().map(RmatPicketageEntity::getId).collect(Collectors.toList());
        publicRmatInviteIdList.addAll(publicRmatPicketageIdList);

        if (CollectionUtils.isNotEmpty(publicRmatInviteIdList)) {
            LambdaQueryWrapper<RmatPicketageRefsupplierEntity> publicRmatPicketageRefSupplierWrapper = new LambdaQueryWrapper<>();
            publicRmatPicketageRefSupplierWrapper.in(RmatPicketageRefsupplierEntity::getPicketageId, publicRmatInviteIdList);
            rmatMoney = rmatPicketageRefsupplierService.list(publicRmatPicketageRefSupplierWrapper).stream().filter(e -> e.getMoneyTax() != null).map(RmatPicketageRefsupplierEntity::getMoneyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            logger.info("周转材数据条数:{}", publicRmatInviteIdList.size());
        }


        //其他
        BigDecimal otherMoney = BigDecimal.ZERO;
        LambdaQueryWrapper<OtherInviteEntity> publicOtherInviteWrapper = new LambdaQueryWrapper<>();
        publicOtherInviteWrapper.eq(OtherInviteEntity::getEstablishType, 1)
                .in(OtherInviteEntity::getBillState, 1, 3)
                .eq(OtherInviteEntity::getDr, 0)
                .in(OtherInviteEntity::getOrgId, iOrgApi.findChildrenByParentId(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()))
                .eq(OtherInviteEntity::getTenantId, InvocationInfoProxy.getTenantid())
                .eq(OtherInviteEntity::getTenderType, tenderType);

        if (StringUtils.isNotEmpty(firstDayOfMonth)) {
            publicOtherInviteWrapper.between(OtherInviteEntity::getCreateDate, firstDayOfMonth, lastDayOfMonth);
        }

        LambdaQueryWrapper<OtherPicketageEntity> publicOtherPicketageWrapper = new LambdaQueryWrapper<>();
        publicOtherPicketageWrapper.eq(OtherPicketageEntity::getTenderTypeName, tenderTypeName)
                .eq(OtherPicketageEntity::getDr, 0)
                .in(OtherPicketageEntity::getOrgId, iOrgApi.findChildrenByParentId(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()))
                .eq(OtherPicketageEntity::getTenantId, InvocationInfoProxy.getTenantid())
                .in(OtherPicketageEntity::getBillState, 1, 3);

        if (StringUtils.isNotEmpty(firstDayOfMonth)) {
            publicOtherPicketageWrapper.between(OtherPicketageEntity::getPicketageTime, firstDayOfMonth, lastDayOfMonth);
        }

        List<Long> publicOtherInviteIdList = otherInviteService.list(publicOtherInviteWrapper).stream().map(OtherInviteEntity::getId).collect(Collectors.toList());
        List<Long> publicOtherPicketageIdList = otherPicketageService.list(publicOtherPicketageWrapper).stream().map(OtherPicketageEntity::getId).collect(Collectors.toList());
        publicOtherInviteIdList.addAll(publicOtherPicketageIdList);

        if (CollectionUtils.isNotEmpty(publicOtherInviteIdList)) {
            LambdaQueryWrapper<OtherPicketageRefsupplierEntity> publicOtherPicketageRefSupplierWrapper = new LambdaQueryWrapper<>();
            publicOtherPicketageRefSupplierWrapper.in(OtherPicketageRefsupplierEntity::getPicketageId, publicOtherInviteIdList);
            otherMoney = otherPicketageRefsupplierService.list(publicOtherPicketageRefSupplierWrapper).stream().filter(e -> e.getMoneyTax() != null).map(OtherPicketageRefsupplierEntity::getMoneyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            logger.info("其他数据条数:{}", publicOtherInviteIdList.size());
        }
        logger.info("合计总金额:{}", stuffMoney.add(subMoney).add(equipmentMoney).add(rentMoney).add(rmatMoney).add(otherMoney));
        return stuffMoney.add(subMoney).add(equipmentMoney).add(rentMoney).add(rmatMoney).add(otherMoney);
    }

    /**
     * 获取当前月第一天
     *
     * @param
     * @return
     */
    public static Date getFirstDayOfMonth(boolean flag) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf1 = new SimpleDateFormat("MM");
        String format = sdf1.format(new Date());
        int month = Integer.parseInt(format);
        if (flag) {
            calendar.add(Calendar.YEAR, -1); //把日期往后增加一天,整数  往后推,负数往前移动
        }
        // 设置月份
        calendar.set(Calendar.MONTH, month - 1);
        // 获取某月最小天数
        int firstDay = calendar.getActualMinimum(Calendar.DAY_OF_MONTH);
        // 设置日历中月份的最小天数
        calendar.set(Calendar.DAY_OF_MONTH, firstDay);
        // 格式化日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String firstDayDate = sdf.format(calendar.getTime()) + " 00:00:00";
        return sdf.parse(firstDayDate);
    }


    /**
     * 获取当前月最后一天
     *
     * @param
     * @return
     */
    public static Date getLastDayOfMonth(boolean flag) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf1 = new SimpleDateFormat("MM");
        String format = sdf1.format(new Date());
        int month = Integer.parseInt(format);
        if (flag) {
            calendar.add(Calendar.YEAR, -1); //把日期往后增加一天,整数 往后推,负数往前移动
        }
        // 设置月份
        calendar.set(Calendar.MONTH, month - 1);
        // 获取某月最大天数
        int lastDay = 0;
        //2月的平年瑞年天数
        if (month == 2) {
            // 这个api在计算2020年2月的过程中有问题
            lastDay = calendar.getLeastMaximum(Calendar.DAY_OF_MONTH);
        }
        else {
            lastDay = calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
        }
        // 设置日历中月份的最大天数
        calendar.set(Calendar.DAY_OF_MONTH, lastDay);
        // 格式化日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String lastDayDate = sdf.format(calendar.getTime()) + " 23:59:59";
        return sdf.parse(lastDayDate);
    }

    @Override
    public Map queryBidData(QueryParam param) throws ParseException {
        BidDataVO bidDataVO = new BidDataVO();
        Map<String, Object> bidDataVOMap = new HashMap<>();
        List<ReportVO> list = reportMapper.refPurchaseAcceptanceAllData(changeToQueryWrapper(param));
        //平台公开招标金额
        BigDecimal publicTenderMoney = calculateMoney(list, "0",null,null);
        bidDataVO.setPublicTenderMoney(publicTenderMoney);
        bidDataVOMap.put("publicTenderMoney",publicTenderMoney);
        //邀请招标金额
        BigDecimal inviteTenderMoney = calculateMoney(list, "1",null,null);
        bidDataVO.setInviteTenderMoney(inviteTenderMoney);
        bidDataVOMap.put("inviteTenderMoney",inviteTenderMoney);
        //询价招标金额
        BigDecimal inquiryTenderMoney = calculateMoney(list, "2",null,null);
        bidDataVO.setInquiryTenderMoney(inquiryTenderMoney);
        bidDataVOMap.put("inquiryTenderMoney",inquiryTenderMoney);
        //紧急招标金额
        BigDecimal urgentTenderMoney = calculateMoney(list, "5",null,null);
        bidDataVO.setUrgentTenderMoney(urgentTenderMoney);
        bidDataVOMap.put("urgentTenderMoney",urgentTenderMoney);
        //其他招标金额
        bidDataVOMap.put("otherTenderMoney",(calculateMoney(list, "3",null,null)).add(calculateMoney(list, "4",null,null)));

        //本期
        BidDataVO nowMonth = new BidDataVO();
        Date firstDayOfMonth = getFirstDayOfMonth(false);
        Date lastDayOfMonth = getLastDayOfMonth(false);
        logger.info("本期日期开始时间-{}",firstDayOfMonth);
        logger.info("本期日期结束时间-{}",lastDayOfMonth);
        nowMonth.setPublicTenderMoney(calculateMoney(list, "0", firstDayOfMonth, lastDayOfMonth));
        nowMonth.setInviteTenderMoney(calculateMoney(list, "1", firstDayOfMonth, lastDayOfMonth));
        nowMonth.setInquiryTenderMoney(calculateMoney(list, "2", firstDayOfMonth, lastDayOfMonth));
        nowMonth.setUrgentTenderMoney(calculateMoney(list, "5", firstDayOfMonth, lastDayOfMonth));
        nowMonth.setOtherTenderMoney(calculateMoney(list, "3", firstDayOfMonth, lastDayOfMonth).add(calculateMoney(list, "4", firstDayOfMonth, lastDayOfMonth)));


        //同期
        BidDataVO oldMonth = new BidDataVO();
        Date oldFirstDayOfMonth = getFirstDayOfMonth(true);
        Date oldLastDayOfMonth = getLastDayOfMonth(true);
        logger.info("同期日期开始时间-{}",oldFirstDayOfMonth);
        logger.info("同期日期结束时间-{}",oldLastDayOfMonth);
        oldMonth.setPublicTenderMoney(calculateMoney(list, "0", oldFirstDayOfMonth, oldLastDayOfMonth));
        oldMonth.setInviteTenderMoney(calculateMoney(list, "1", oldFirstDayOfMonth, oldLastDayOfMonth));
        oldMonth.setInquiryTenderMoney(calculateMoney(list, "2", oldFirstDayOfMonth, oldLastDayOfMonth));
        oldMonth.setUrgentTenderMoney(calculateMoney(list, "5", oldFirstDayOfMonth, oldLastDayOfMonth));
        oldMonth.setOtherTenderMoney(calculateMoney(list, "3", oldFirstDayOfMonth, oldLastDayOfMonth).add(calculateMoney(list, "4", oldFirstDayOfMonth, oldLastDayOfMonth)));

        //增减率
        BidDataVO rate = new BidDataVO();
        if (oldMonth.getPublicTenderMoney().compareTo(BigDecimal.ZERO) == 0) {
            rate.setPublicTenderRate(BigDecimal.ZERO);
        }
        else {
            rate.setPublicTenderRate(nowMonth.getPublicTenderMoney().subtract(oldMonth.getPublicTenderMoney()).divide(oldMonth.getPublicTenderMoney(), 2, BigDecimal.ROUND_HALF_UP));

        }

        if (oldMonth.getPublicTenderMoney().compareTo(BigDecimal.ZERO) == 0) {
            rate.setInviteTenderRate(BigDecimal.ZERO);
        }
        else {
            rate.setInviteTenderRate(nowMonth.getInviteTenderMoney().subtract(oldMonth.getInviteTenderMoney()).divide(oldMonth.getInviteTenderMoney(), 2, BigDecimal.ROUND_HALF_UP));

        }

        if (oldMonth.getPublicTenderMoney().compareTo(BigDecimal.ZERO) == 0) {
            rate.setInquiryTenderRate(BigDecimal.ZERO);
        }
        else {
            rate.setInquiryTenderRate(nowMonth.getInquiryTenderMoney().subtract(oldMonth.getInquiryTenderMoney()).divide(oldMonth.getInquiryTenderMoney(), 2, BigDecimal.ROUND_HALF_UP));

        }

        if (oldMonth.getPublicTenderMoney().compareTo(BigDecimal.ZERO) == 0) {
            rate.setUrgentTenderRate(BigDecimal.ZERO);
        }
        else {
            rate.setUrgentTenderRate(nowMonth.getUrgentTenderMoney().subtract(oldMonth.getUrgentTenderMoney()).divide(oldMonth.getUrgentTenderMoney(), 2, BigDecimal.ROUND_HALF_UP));

        }

        if (oldMonth.getPublicTenderMoney().compareTo(BigDecimal.ZERO) == 0) {
            rate.setOtherTenderRate(BigDecimal.ZERO);
        }
        else {
            rate.setOtherTenderRate(nowMonth.getOtherTenderMoney().subtract(oldMonth.getOtherTenderMoney()).divide(oldMonth.getOtherTenderMoney(), 2, BigDecimal.ROUND_HALF_UP));

        }
        bidDataVOMap.put("nowMonth",nowMonth);
        bidDataVOMap.put("oldMonth",oldMonth);
        bidDataVOMap.put("rate",rate);

        return bidDataVOMap;
    }

    @Override
    public List<SupbidNoticeVO> queryTenderMaterialAmountProportion(Integer year) {
        return reportMapper.queryTenderMaterialAmountProportion(year);
    }
    @Override
    public List<SupbidNoticeVO> queryTenderResultTrend(Integer year) {
        return reportMapper.queryTenderResultTrend(year);
    }

    @Override
    public List<SupbidNoticeVO> queryWinbidMoneyTop6(Integer year) {
        return reportMapper.queryWinbidMoneyTop6(year);
    }

    @Override
    public List<SupbidNoticeVO> queryPicketageMoneyProportion(Integer year) {
        return reportMapper.queryPicketageMoneyProportion(year);
    }

    @Override
    public IPage<SupbidNoticeVO> tenderSupplierRank(QueryParam param) {
        IPage<SupbidNoticeVO> page = new Page<>(param.getPageIndex(), param.getPageSize());

        List<SupbidNoticeVO> supbidNoticeVOS = reportMapper.tenderSupplierRank(changeToQueryWrapper(param), page);

        IPage<SupbidNoticeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(supbidNoticeVOS);

        return pageData;
    }
    @Override
    public IPage<SupbidNoticeVO> tenderSupplierRankProsub(QueryParam param) {
        IPage<SupbidNoticeVO> page = new Page<>(param.getPageIndex(), param.getPageSize());

        List<SupbidNoticeVO> supbidNoticeVOS = reportMapper.tenderSupplierRankProsub(changeToQueryWrapper(param), page);

        IPage<SupbidNoticeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(supbidNoticeVOS);

        return pageData;
    }
    @Override
    public List<SupbidNoticeVO> queryPicketageMoneyProportionNew(String time) {
        return reportMapper.queryPicketageMoneyProportionNew(time);
    }

    public static BigDecimal calculateMoney(List<ReportVO> list, String tenderTypeName, Date firstDayOfMonth,Date lastDayOfMonth) {
        List<ReportVO> list1;
        if (firstDayOfMonth != null && lastDayOfMonth != null){
             list1 = list.stream().filter(item ->item.getTenderTypeName()!= null && item.getTenderTypeName().equals(tenderTypeName) &&  !item.getCreateDate().after(lastDayOfMonth) && !item.getCreateDate().before(firstDayOfMonth) ).collect(Collectors.toList());
        }else {
             list1 = list.stream().filter(item ->item.getTenderTypeName()!= null && item.getTenderTypeName().equals(tenderTypeName)).collect(Collectors.toList());
        }
        BigDecimal sumTaxMoney = BigDecimal.ZERO;
        //将list里的金额合并
        if (CollectionUtils.isNotEmpty(list1)) {
            for (ReportVO reportVO : list1) {
                if (reportVO.getEstablishType()==1){
                    if (reportVO.getLineTypeName().equals("分包招标")){
                        reportVO.setTaxMoney(reportVO.getTenderMoney());
                    }else {
                        reportVO.setTaxMoney(reportVO.getTaxMoney());
                    }
                }
                sumTaxMoney = MathUtil.safeAdd(sumTaxMoney, reportVO.getTaxMoney());
            }
        }
        return sumTaxMoney;
    }
}
