package com.ejianc.business.tender.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rmat.vo.*;
import com.ejianc.business.tender.rmat.bean.*;
import com.ejianc.business.tender.rmat.mapper.RmatBidMapper;
import com.ejianc.business.tender.rmat.service.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 中标主表
 * 
 * @author generator
 * 
 */
@Service("rmatBidService")
public class RmatBidServiceImpl extends BaseServiceImpl<RmatBidMapper, RmatBidEntity> implements IRmatBidService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRmatPicketageService rmatPicketageService;
    @Autowired
    private IRmatNoticeService rmatNoticeService;
    @Autowired
    private IRmatWinnoticeService rmatWinnoticeService;
    @Autowired
    private IRmatDocumentService rmatDocumentService;
    @Autowired
    private IRmatInviteService rmatInviteService;
    @Autowired
    private IRmatBidDetailService rmatBidDetailService;
    @Autowired
    private IRmatDocumentSellService rmatDocumentSellService;
    @Autowired
    private IRmatBidSupplierService rmatBidSupplierService;
    @Autowired
    private IRmatDocumentSupplierService rmatDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IRmatPicketageSupplierService rmatPicketageSupplierService;
    @Autowired
    private IOrgApi iOrgApi;
    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;

    @Value("${gysUrl.winbidSavesUrl}")
    private String winbidSavesUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    private org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-bid-code";//此处需要根据实际修改
    @Override
    public RmatBidVO saveBid(Long picketageId) {
        RmatBidEntity entity = new RmatBidEntity();
        entity.setPicketageId(picketageId);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        RmatPicketageEntity rmatPicketageEntity = rmatPicketageService.selectById(picketageId);
        RmatInviteEntity inviteEntity = rmatInviteService.selectById(rmatPicketageEntity.getInviteId());
        entity.setInviteId(rmatPicketageEntity.getInviteId());
        entity.setBidName(inviteEntity.getTenderName());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        super.saveOrUpdate(entity, false);
        RmatBidVO vo = BeanMapper.map(entity, RmatBidVO.class);

        //回写定标数据
//        rmatPicketageEntity.setBidStatus(1);
        rmatPicketageEntity.setBidId(entity.getId());
        rmatPicketageService.updateById(rmatPicketageEntity);

        //处理供应商信息
        //获取材料明细报价
        LambdaQueryWrapper<RmatDocumentSellEntity> lambdaSell = Wrappers.<RmatDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(RmatDocumentSellEntity::getDocumentId, rmatPicketageEntity.getDocumentId());
        lambdaSell.eq(RmatDocumentSellEntity::getTenderFlag, 1);
        List<RmatDocumentSellEntity> sellList = rmatDocumentSellService.list(lambdaSell);
        List<RmatDocumentSellVO> rmatDocumentSellVOS = BeanMapper.mapList(sellList, RmatDocumentSellVO.class);
        Map<Long, List<RmatDocumentSellVO>> sellMap = rmatDocumentSellVOS.stream().
                collect(Collectors.groupingBy(RmatDocumentSellVO::getSupplierId));

        //查看供应商信息
        LambdaQueryWrapper<RmatDocumentSupplierEntity> lambdaSupplier = Wrappers.<RmatDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(RmatDocumentSupplierEntity::getDocumentId, rmatPicketageEntity.getDocumentId());
        lambdaSupplier.eq(RmatDocumentSupplierEntity::getTalkNum, 0);
        List<RmatDocumentSupplierEntity> supplierList = rmatDocumentSupplierService.list(lambdaSupplier);
        Map<Long, RmatDocumentSupplierEntity> suppliermatityMap = supplierList.stream().collect(Collectors.toMap(RmatDocumentSupplierEntity::getSupplierId, Function.identity()));

        //遍历map,组合数据返回
        ArrayList<RmatBidSupplierVO> supplierVOList = new ArrayList<>();
        List<RmatBidDetailEntity> rmatBidDetailEntityList = new ArrayList<>();
        sellMap.forEach((key,value) -> {
            RmatBidSupplierVO rmatBidSupplierVO = new RmatBidSupplierVO();
            rmatBidSupplierVO.setSupplierId(key);
            rmatBidSupplierVO.setSupplierName(value.stream().findFirst().get().getSupplierName());
            RmatDocumentSupplierEntity rmatDocumentSupplierEntity = suppliermatityMap.get(key);
            rmatBidSupplierVO.setLinkName(rmatDocumentSupplierEntity.getLinkName());
            rmatBidSupplierVO.setSupplierMobile(rmatDocumentSupplierEntity.getLinkMobile());
            rmatBidSupplierVO.setId(IdWorker.getId());

            //汇总中标金额
            BigDecimal tenderMoneyTax = BigDecimal.ZERO;
            BigDecimal tenderMoney = BigDecimal.ZERO;

            for (RmatDocumentSellVO rmatDocumentSellVO : value) {
                //汇总金额
                tenderMoneyTax = tenderMoneyTax
                        .add(rmatDocumentSellVO.getTenderMoneyTax() == null ? BigDecimal.ZERO : rmatDocumentSellVO
                                .getTenderMoneyTax());
                tenderMoney = tenderMoney
                        .add(rmatDocumentSellVO.getTenderMoney() == null ? BigDecimal.ZERO : rmatDocumentSellVO
                                .getTenderMoney());
                RmatBidDetailEntity rmatBidDetailEntity = BeanMapper.map(rmatDocumentSellVO, RmatBidDetailEntity.class);
                rmatBidDetailEntity.setMoney(rmatDocumentSellVO.getTenderMoney());
                rmatBidDetailEntity.setMoneyTax(rmatDocumentSellVO.getTenderMoneyTax());
                rmatBidDetailEntity.setId(null);
                rmatBidDetailEntity.setBidSupplierId(rmatBidSupplierVO.getId());
                rmatBidDetailEntity.setBidId(entity.getId());
                rmatBidDetailEntityList.add(rmatBidDetailEntity);

            }
            rmatBidSupplierVO.setMoneyTax(tenderMoneyTax);
            rmatBidSupplierVO.setMoney(tenderMoney);
            rmatBidSupplierVO.setBidId(entity.getId());
            supplierVOList.add(rmatBidSupplierVO);
        });

        //新增供应商
        List<RmatBidSupplierEntity> rmatBidSuppliermatities = BeanMapper.mapList(supplierVOList, RmatBidSupplierEntity.class);
        rmatBidSupplierService.saveBatch(rmatBidSuppliermatities);
        rmatBidDetailService.saveBatch(rmatBidDetailEntityList);

        //回写中标供应商和数量
        String tenderUnitNum = "";
        //查询中标供应商
        List<RmatBidDetailEntity> bidDetailEntityList = baseMapper.selectBidSupplier(entity.getId());
        for (RmatBidDetailEntity rmatBidDetailEntity : bidDetailEntityList) {
            RmatBidSupplierEntity suppliermatity = rmatBidSupplierService.selectById(rmatBidDetailEntity.getBidSupplierId());
            BigDecimal sumNum = rmatBidDetailEntity.getTenderNum().setScale(4,BigDecimal.ROUND_HALF_UP);
            String name = suppliermatity.getSupplierName()+"("+sumNum+"),";
            tenderUnitNum += name;
        }

        if (tenderUnitNum.length() > 1) {
            tenderUnitNum = tenderUnitNum.substring(0,tenderUnitNum.length() -1);
        }
        inviteEntity.setTenderUnitNum(tenderUnitNum);
        rmatInviteService.saveOrUpdate(inviteEntity);

        RmatBidVO rmatBidVO = BeanMapper.map(entity, RmatBidVO.class);
        return rmatBidVO;
    }

    @Override
    public RmatBidVO queryDetail(Long bidId) {
        RmatBidEntity rmatBidEntity = super.selectById(bidId);
        RmatBidVO rmatBidVO = BeanMapper.map(rmatBidEntity, RmatBidVO.class);
        //组合数据
        List<RmatBidDetailVO> rmatBidDetailList  = rmatBidVO.getRmatBidDetailList();
        Map<Long, List<RmatBidDetailVO>> detailMap = rmatBidDetailList.stream().
                collect(Collectors.groupingBy(RmatBidDetailVO::getBidSupplierId));
        List<RmatBidSupplierVO> rmatBidSupplierList = rmatBidVO.getRmatBidSupplierList();
        for (RmatBidSupplierVO rmatBidSupplierVO : rmatBidSupplierList){
            rmatBidSupplierVO.setRmatBidDetailList(detailMap.get(rmatBidSupplierVO.getId()));
        }
        rmatBidVO.setRmatBidSupplierList(rmatBidSupplierList);
        return rmatBidVO;
//
    }
    @Transactional
    @Override
    public RmatBidVO publishBid(RmatBidVO saveorUpdateVO) {
        RmatBidEntity entity = super.selectById(saveorUpdateVO.getId());
        entity.setBidContent(saveorUpdateVO.getBidContent());
        entity.setBidName(saveorUpdateVO.getBidName());
        entity.setPublishFlag(0);
        entity.setBillState(1);
        RmatBidVO vo = BeanMapper.map(entity, RmatBidVO.class);


        //获取中标信息
        RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(entity.getInviteId());
        RmatWinbidVO winbidVO = new RmatWinbidVO();
        winbidVO.setSourceId(Long.toString(entity.getInviteId()));
        winbidVO.setBillCode(rmatInviteEntity.getBillCode());
        if (winbidVO.getPurchaseType()==null || winbidVO.getPurchaseType()==1){
            winbidVO.setSourceProjectId(null);
        }else {
            winbidVO.setSourceProjectId(Long.toString(rmatInviteEntity.getProjectId()));
        }
        winbidVO.setProjectName(rmatInviteEntity.getProjectName());
        winbidVO.setProjectCode(rmatInviteEntity.getProjectCode());
        winbidVO.setSourceOrgId(Long.toString(rmatInviteEntity.getOrgId()));
        winbidVO.setOrgName(rmatInviteEntity.getOrgName());
        winbidVO.setUnitName(rmatInviteEntity.getUnitName());
        winbidVO.setSourceUnitId(Long.toString(rmatInviteEntity.getUnitId()));
        winbidVO.setType("RMAT");
        winbidVO.setTenderName(rmatInviteEntity.getTenderName());
        winbidVO.setTenderType(rmatInviteEntity.getTenderType());
        winbidVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());

        LambdaQueryWrapper<RmatDocumentEntity> lambdaDoc = Wrappers.<RmatDocumentEntity>lambdaQuery();
        lambdaDoc.eq(RmatDocumentEntity::getInviteId, entity.getInviteId());
        RmatDocumentEntity rmatDocumentEntity = rmatDocumentService.getOne(lambdaDoc);
        winbidVO.setNoticeBidTime(rmatDocumentEntity.getBidTime());
        winbidVO.setNoticeWinbidTime(new Date());

        if (rmatInviteEntity.getTenderType()==2 || rmatInviteEntity.getTenderType()==3 ||rmatInviteEntity.getTenderType()==4 ||rmatInviteEntity.getTenderType()==5){
            winbidVO.setSourceEmployeeId(Long.toString(rmatDocumentEntity.getEmployeeId()));
            winbidVO.setEmployeeName(rmatDocumentEntity.getEmployeeName());
            winbidVO.setEmployeeMobile(rmatDocumentEntity.getEmployeeMobile());
            winbidVO.setPurchaseType(rmatDocumentEntity.getPurchaseType());
        }else {
            //查询招标公告
            LambdaQueryWrapper<RmatNoticeEntity> lambdaNotice = Wrappers.<RmatNoticeEntity>lambdaQuery();
            lambdaNotice.eq(RmatNoticeEntity::getInviteId, entity.getInviteId());
            RmatNoticeEntity noticeEntity = rmatNoticeService.getOne(lambdaNotice);
            winbidVO.setSourceEmployeeId(Long.toString(noticeEntity.getEmployeeId()));
            winbidVO.setEmployeeName(noticeEntity.getEmployeeName());
            winbidVO.setEmployeeMobile(noticeEntity.getEmployeeMobile());
            winbidVO.setPurchaseType(noticeEntity.getPurchaseType());
        }

        //处理供应商信息
        RmatBidVO rmatBidVO = queryDetail(entity.getId());
        List<RmatBidSupplierVO> rmatBidSupplierList = rmatBidVO.getRmatBidSupplierList();
        //转换数据,推送供应商中标信息
        List<RmatWinbidVO> winbidVOList = new ArrayList<>();
        for (RmatBidSupplierVO rmatBidSupplierVO : rmatBidSupplierList){
            RmatWinbidVO winbidVONew = BeanMapper.map(winbidVO,RmatWinbidVO.class);
            SupplierDTO supplierVO = shareSupplierApi.queryById(rmatBidSupplierVO.getSupplierId()).getData();
            winbidVONew.setTenantId(supplierVO.getTenant());
            winbidVONew.setWinbidMoneyTax(rmatBidSupplierVO.getMoneyTax());
            winbidVONew.setWinbidMoney(rmatBidSupplierVO.getMoney());
            winbidVONew.setContent(rmatBidVO.getBidContent());
            winbidVONew.setWinbidType(0);

            List<RmatBidDetailVO> rmatBidDetailList = rmatBidSupplierVO.getRmatBidDetailList();
            Map<String,List<RmatBidDetailVO>> map = new HashMap<>();
            for (RmatBidDetailVO rmatBidDetailVO : rmatBidDetailList){
                String s = null;
                if (rmatBidDetailVO.getMaterialId() == null){
                     s = rmatBidDetailVO.getMaterialTypeId().toString()+
                             rmatBidDetailVO.getRate() +
                             rmatBidDetailVO.getSchemeId() +
                             rmatBidDetailVO.getPlanEnterDate() +
                             rmatBidDetailVO.getPlanLeaveDate();
                }
                if (rmatBidDetailVO.getMaterialId() != null){
                     s = rmatBidDetailVO.getMaterialId().toString() +
                             rmatBidDetailVO.getMaterialTypeId().toString() +
                             rmatBidDetailVO.getRate() +
                             rmatBidDetailVO.getSchemeId() +
                             rmatBidDetailVO.getPlanEnterDate() +
                             rmatBidDetailVO.getPlanLeaveDate();
                }
                if (map.containsKey(s)){
                    List<RmatBidDetailVO> rmatBidDetailVOS = map.get(s);
                    rmatBidDetailVOS.add(rmatBidDetailVO);
                    map.put(s,rmatBidDetailVOS);
                }else {
                    List<RmatBidDetailVO> rmatBidDetailVOList = new ArrayList<>();
                    rmatBidDetailVOList.add(rmatBidDetailVO);
                    map.put(s,rmatBidDetailVOList);
                }
            }
            //处理中标详情数据
            List<RmatWinbidDetailVO> winbidDetailVOList = new ArrayList<>();
            map.forEach((key,value) ->{
                BigDecimal tenderNum = BigDecimal.ZERO;
                BigDecimal money = BigDecimal.ZERO;
                BigDecimal moneyTax = BigDecimal.ZERO;
                BigDecimal tax = BigDecimal.ZERO;
                for (RmatBidDetailVO rmatBidDetailVOLast : value){
                    tenderNum = tenderNum.add((rmatBidDetailVOLast.getTenderNum() == null) ? BigDecimal.ZERO : rmatBidDetailVOLast.getTenderNum());
                    money = money.add((rmatBidDetailVOLast.getMoney() == null) ? BigDecimal.ZERO : rmatBidDetailVOLast.getMoney());
                    moneyTax = moneyTax.add((rmatBidDetailVOLast.getMoneyTax() == null) ? BigDecimal.ZERO : rmatBidDetailVOLast.getMoneyTax());
                    tax = tax.add((rmatBidDetailVOLast.getSellTax() == null) ? BigDecimal.ZERO : rmatBidDetailVOLast.getSellTax());
                }
                RmatBidDetailVO first = value.stream().findFirst().get();
                RmatWinbidDetailVO winbidDetailVO = new RmatWinbidDetailVO();
                winbidDetailVO.setSourceId(Long.toString(entity.getInviteId()));
                winbidDetailVO.setSourceMaterialId(Long.toString(first.getMaterialId()));
                winbidDetailVO.setMaterialName(first.getMaterialName());
                winbidDetailVO.setMaterialCode(first.getMaterialCode());
                winbidDetailVO.setSourceMaterialTypeId(Long.toString(first.getMaterialTypeId()));
                winbidDetailVO.setMaterialTypeName(first.getMaterialTypeName());
                winbidDetailVO.setUnit(first.getUnit());
                winbidDetailVO.setSpec(first.getSpec());
                winbidDetailVO.setBrand(first.getMaterialBrand());
                winbidDetailVO.setSupplierBrand(first.getBrand());
                winbidDetailVO.setPrice(first.getPrice());
                winbidDetailVO.setPriceTax(first.getPriceTax());
                winbidDetailVO.setMoney(money);
                winbidDetailVO.setMoneyTax(moneyTax);
                winbidDetailVO.setTax(tax);
                winbidDetailVO.setCalculateType(first.getCalculateType());
                winbidDetailVO.setMemo(first.getMaterialMemo());
                winbidDetailVO.setSupplierMemo(first.getMemo());
                winbidDetailVO.setMoney(money);
                winbidDetailVO.setRate(first.getRate());
                winbidDetailVO.setTenderNum(tenderNum);
                winbidDetailVO.setNum(first.getNum());
                winbidDetailVOList.add(winbidDetailVO);
            });
            winbidVONew.setRmatWinbidDetailList(winbidDetailVOList);
            winbidVOList.add(winbidVONew);
        }
        String stringFb = JSONObject.toJSONString(winbidVOList);
        logger.info("推送供方中标信息:" +stringFb);
        //调用供方接口
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(winbidSavesUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("中标同步接口报错" + stringCommonResponse.getMsg());
        }

        return queryDetail(vo.getId());
    }

    @Override
    public RmatBidVO queryDbDetail(Long picketage) {

        return null;
    }

    @Override
    public RmatBidVO nextPaper(Long winnoticeId) {
        RmatBidEntity entity = new RmatBidEntity();
        RmatWinnoticeEntity rmatWinnoticeEntity = rmatWinnoticeService.selectById(winnoticeId);
        RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(rmatWinnoticeEntity.getInviteId());
        entity.setInviteId(rmatWinnoticeEntity.getInviteId());
        entity.setBidName(rmatInviteEntity.getTenderName());
        entity.setPurchaseType(rmatInviteEntity.getPurchaseType());
        entity.setWinnoticeId(winnoticeId);
        super.saveOrUpdate(entity, false);

        //回写中标公告状态
        rmatWinnoticeEntity.setNextFlag(1);
        rmatWinnoticeService.updateById(rmatWinnoticeEntity);

        //回写招标阶段
        rmatInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        rmatInviteService.updateById(rmatInviteEntity);

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(3);
        processEntity.setFrontendUrl("rmat/winLetter");
        processService.saveOrUpdate(processEntity);

        RmatBidVO rmatBidVO = BeanMapper.map(entity, RmatBidVO.class);
        return rmatBidVO;
    }

    @Override
    public List<RmatPicketageSupplierVO> querySupplierList(Long picketageId) {
        RmatBidEntity rmatBidEntity = super.selectById(picketageId);

        RmatWinnoticeEntity rmatWinnoticeEntity = rmatWinnoticeService.selectById(rmatBidEntity.getWinnoticeId());
        LambdaQueryWrapper<RmatPicketageSupplierEntity> lambdaSupplierList = Wrappers.lambdaQuery();
        lambdaSupplierList.eq(RmatPicketageSupplierEntity::getPicketageId,rmatWinnoticeEntity.getPicketageId());
        List<RmatPicketageSupplierEntity> listSupplier = rmatPicketageSupplierService.list(lambdaSupplierList);
        List<RmatPicketageSupplierVO> rmatPicketageSupplierVOS = BeanMapper.mapList(listSupplier, RmatPicketageSupplierVO.class);

        return rmatPicketageSupplierVOS;
    }
    @Transactional
    @Override
    public RmatPicketageVO insertProcess(Long picketageId) {

        RmatPicketageEntity rmatPicketageEntity = rmatPicketageService.selectById(picketageId);
        RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(rmatPicketageEntity.getInviteId());
        //回写招标阶段
        rmatInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        rmatInviteService.updateById(rmatInviteEntity);

        //回写定标数据
        rmatPicketageEntity.setBidStatus(1);
        rmatPicketageService.updateById(rmatPicketageEntity);

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(rmatPicketageEntity.getBidId());
        processEntity.setBillName(TenderStageEnum.BID_NOTICE_STATE.getDescription());
        processEntity.setTenderId(rmatInviteEntity.getId());
        processEntity.setType(3);
        processEntity.setFrontendUrl("rmat/winLetter");
        processService.saveOrUpdate(processEntity);
        RmatPicketageVO rmatPicketageVO = BeanMapper.map(rmatPicketageEntity, RmatPicketageVO.class);
        return rmatPicketageVO;
    }

    @Override
    public List<RmatPicketageSupplierVO> querySupplierDetail(Long id) {
        RmatBidEntity rmatBidEntity = super.selectById(id);
        return rmatPicketageService.querySupplierList(rmatBidEntity.getPicketageId());
    }
}
