package com.ejianc.business.tender.stuff.service.impl;

import com.ejianc.business.tender.buildmaterial.service.ISystemRequestService;
import com.ejianc.business.tender.buildmaterial.vo.PublishTenderAttachmentsVO;
import com.ejianc.business.tender.buildmaterial.vo.PublishTenderProductsVO;
import com.ejianc.business.tender.buildmaterial.vo.PublishTenderVO;
import com.ejianc.business.tender.stuff.bean.StuffDocumentEntity;
import com.ejianc.business.tender.stuff.bean.StuffInviteDetailEntity;
import com.ejianc.business.tender.stuff.bean.StuffInviteEntity;
import com.ejianc.business.tender.stuff.bean.StuffNoticeEntity;
import com.ejianc.business.tender.stuff.service.IStuffDocumentService;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.stuff.service.IStuffNoticeService;
import com.ejianc.foundation.bulidMaterialMdm.vo.UserVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;

@Service("stuffDocument") 
public class StuffDocumentBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IStuffNoticeService noticeService;

	@Autowired
	private IStuffInviteService inviteService;

	@Autowired
	private IStuffDocumentService documentService;

	@Autowired
	private ISystemRequestService systemRequestService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		//如果推送筑材网，则修改报价截止时间
		StuffDocumentEntity stuffDocumentEntity = documentService.selectById(billId);
		if (stuffDocumentEntity != null){
			StuffInviteEntity stuffInviteEntity = inviteService.selectById(stuffDocumentEntity.getInviteId());
			if (stuffInviteEntity != null && stuffInviteEntity.getIsPushZcw() == 1) {//确认推送筑材网
				StuffNoticeEntity stuffNoticeEntity = noticeService.selectById(stuffDocumentEntity.getNoticeId());
				if (stuffNoticeEntity != null) {
					//组装发送数据
					logger.info("推送筑材网修改报价时间：{}", stuffNoticeEntity.getId());
					String notice = systemRequestService.publishNotice(assemblingData(stuffNoticeEntity,stuffInviteEntity,stuffDocumentEntity));
					logger.info("推送筑材网修改报价时间返回：{}", notice);
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该功能不支持！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}


	public PublishTenderVO assemblingData(StuffNoticeEntity stuffNoticeEntity,StuffInviteEntity stuffInviteEntity,StuffDocumentEntity stuffDocumentEntity){

		PublishTenderVO publishTenderVO = new PublishTenderVO();

		/**
		 * 	预估总价: 大致的招标预算(必须为大于1000的整数，且只保留前2位有效数值，剩余位数以0代替) t
		 */
		if (stuffInviteEntity.getTenderMoney().compareTo(new BigDecimal(1000)) > 0) {
			publishTenderVO.setMoneyEstimated(stuffInviteEntity.getTenderMoney().round(
					new MathContext(2, RoundingMode.HALF_UP)).intValue());
		}else {
			publishTenderVO.setMoneyEstimated(1000);
		}

		publishTenderVO.setBizKey(stuffNoticeEntity.getId()+"");//接入业务标识--公告id
		/**
		 * 报价截止时间: 报价截止时间，精确到秒 yyyy-mm-dd HH:mm:ss t
		 */
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		publishTenderVO.setDateExpired(sdf.format(stuffDocumentEntity.getOfferEndTime()));

		return publishTenderVO;
	}
}
