package com.ejianc.business.tender.sub.controller;

import com.ejianc.business.tender.sub.service.ISubBidService;
import com.ejianc.business.tender.sub.bean.SubBidEntity;
import com.ejianc.business.tender.sub.vo.SubBidVO;
import com.ejianc.business.tender.sub.vo.SubPicketageSupplierVO;
import com.ejianc.business.tender.sub.vo.SubPicketageVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 中标主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("subBid")
@Api(value = "中标主表", tags = {"中标主表"})
public class SubBidController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "invite-bid-code";//此处需要根据实际修改

    @Autowired
    private ISubBidService service;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubBidVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody SubBidVO saveorUpdateVO) {
    	SubBidEntity entity = BeanMapper.map(saveorUpdateVO, SubBidEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	SubBidVO vo = BeanMapper.map(entity, SubBidVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @ApiOperation("生成中标通知书接口")
    @RequestMapping(value = "/saveBid", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubBidVO> saveBid(@RequestParam Long picketageId) {
        SubBidVO subBidVO = service.saveBid(picketageId);
    	return CommonResponse.success("保存或修改单据成功！",subBidVO);
    }
    @ApiOperation("新增进展接口")
    @RequestMapping(value = "/insertProcess", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubPicketageVO> insertProcess(@RequestParam Long picketageId) {
        SubPicketageVO subPicketageVO = service.insertProcess(picketageId);
    	return CommonResponse.success("保存或修改单据成功！",subPicketageVO);
    }
    @ApiOperation("中标公告下一步接口")
    @RequestMapping(value = "/nextPaper", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubBidVO> nextPaper(@RequestParam Long winnoticeId) {
        SubBidVO subBidVO = service.nextPaper(winnoticeId);
        return CommonResponse.success("初始化基础数据成功！",subBidVO);
    }


    @ApiOperation("发布接口")
    @RequestMapping(value = "/publishBid", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubBidVO> publishBid(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody SubBidVO saveorUpdateVO) {
        SubBidVO subBidVO = service.publishBid(saveorUpdateVO);
        return CommonResponse.success("发布成功！",subBidVO);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SubPicketageSupplierVO>> querySupplierDetail(@RequestParam Long id) {
        List<SubPicketageSupplierVO> list = service.querySupplierDetail(id);
        return CommonResponse.success("查询详情数据成功！",list);
    }

//    @ApiOperation("查询供应商列表详情")
//    @RequestMapping(value = "/querySupplierList", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<List<SubPicketageSupplierVO>> querySupplierList(@RequestParam Long picketageId) {
//        List<SubPicketageSupplierVO> list = service.querySupplierList(picketageId);
//        return CommonResponse.success("查询详情数据成功！",list);
//    }
    @ApiOperation("定标下一步查询详情接口")
    @RequestMapping(value = "/queryDbDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubBidVO> queryDbDetail(@RequestParam Long picketage) {
        SubBidVO subBidVO = service.queryDbDetail(picketage);
        return CommonResponse.success("查询详情数据成功！",subBidVO);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubBidVO> vos) {
        service.removeByIds(vos.stream().map(SubBidVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }




}
