/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.rmat.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rmat.bean.RmatInviteDetailEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteSupplierEntity;
import com.ejianc.business.tender.rmat.bean.RmatNoticeChangeEntity;
import com.ejianc.business.tender.rmat.bean.RmatNoticeDetailEntity;
import com.ejianc.business.tender.rmat.bean.RmatNoticeEntity;
import com.ejianc.business.tender.rmat.bean.RmatNoticeSupplierDetailEntity;
import com.ejianc.business.tender.rmat.bean.RmatNoticeSupplierEntity;
import com.ejianc.business.tender.rmat.service.IRmatInviteDetailRecordService;
import com.ejianc.business.tender.rmat.service.IRmatInviteDetailService;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.rmat.service.IRmatInviteSupplierService;
import com.ejianc.business.tender.rmat.service.IRmatNoticeChangeService;
import com.ejianc.business.tender.rmat.service.IRmatNoticeDetailService;
import com.ejianc.business.tender.rmat.service.IRmatNoticeService;
import com.ejianc.business.tender.rmat.service.IRmatNoticeSupplierDetailService;
import com.ejianc.business.tender.rmat.service.IRmatNoticeSupplierService;
import com.ejianc.business.tender.rmat.vo.RmatNoticeSupplierDetailTbVO;
import com.ejianc.business.tender.rmat.vo.RmatNoticeSupplierVO;
import com.ejianc.business.tender.rmat.vo.RmatNoticeVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"rmatNotice"})
@Api(value="\u62db\u6807\u516c\u544a\u4e3b\u8868", tags={"\u62db\u6807\u516c\u544a\u4e3b\u8868"})
public class RmatNoticeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value(value="${gysUrl.updateSupStatusUrl}")
    private String updateSupStatusUrl;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "invite-notice-code";
    @Autowired
    private IRmatNoticeService service;
    @Autowired
    private IRmatInviteService inviteService;
    @Autowired
    private IRmatInviteDetailService inviteDetailService;
    @Autowired
    private IRmatInviteDetailRecordService inviteDetailRecordService;
    @Autowired
    private IRmatNoticeDetailService noticeDetailService;
    @Autowired
    private IProcessService processSerice;
    @Autowired
    private IRmatNoticeSupplierDetailService noticeSupplierDetailService;
    @Autowired
    private IRmatInviteSupplierService inviteSupplierService;
    @Autowired
    private IRmatNoticeSupplierService noticeSupplierService;
    @Autowired
    private IRmatNoticeChangeService changeService;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private static final String BILL_SUPPLIER_TYPE = "BT211215000000005";
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IAttachmentApi attachmentApi;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RmatNoticeVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody RmatNoticeVO saveorUpdateVO) {
        RmatNoticeEntity entity = (RmatNoticeEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, RmatNoticeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        RmatNoticeVO vo = (RmatNoticeVO)BeanMapper.map((Object)((Object)entity), RmatNoticeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RmatNoticeVO> queryDetail(@RequestParam Long id) {
        RmatNoticeEntity entity = (RmatNoticeEntity)((Object)this.service.selectById(id));
        RmatNoticeVO vo = (RmatNoticeVO)BeanMapper.map((Object)((Object)entity), RmatNoticeVO.class);
        if (!this.service.selectFile(vo)) {
            CommonResponse.success((String)"\u4f9b\u5e94\u5546\u9644\u4ef6\u67e5\u8be2\u5931\u8d25\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RmatNoticeVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        this.processSerice.remove((Wrapper)new LambdaQueryWrapper().in(ProcessEntity::getBillId, (Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList())));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RmatNoticeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RmatNoticeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u624b\u673a\u53f7")
    @RequestMapping(value={"/queryPhone"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = ((EmployeeVO)this.employeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone();
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)mobilePhone);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("RmatNotice-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refRmatNoticeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RmatNoticeVO>> refRmatNoticeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RmatNoticeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u70b9\u51fb\u4e0b\u4e00\u6b65\u8fdb\u884c\u4e0b\u4e2a\u9875\u9762\u6570\u636e\u521d\u59cb\u5316")
    @RequestMapping(value={"/nextStep"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RmatNoticeEntity> nextStep(String id) throws InvocationTargetException, IllegalAccessException {
        RmatInviteEntity rmatInviteEntity = (RmatInviteEntity)((Object)this.inviteService.selectById((Serializable)((Object)id)));
        RmatNoticeEntity rmatNoticeEntity = new RmatNoticeEntity();
        BeanUtils.copyProperties((Object)((Object)rmatNoticeEntity), (Object)((Object)rmatInviteEntity));
        rmatNoticeEntity.setNoticeName(rmatInviteEntity.getTenderName());
        rmatNoticeEntity.setInviteId(rmatInviteEntity.getId());
        rmatNoticeEntity.setId(null);
        rmatNoticeEntity.setCreateTime(null);
        rmatNoticeEntity.setUpdateTime(null);
        rmatNoticeEntity.setBillCode(null);
        rmatNoticeEntity.setBillState(null);
        rmatNoticeEntity.setCreateUserCode(null);
        rmatNoticeEntity.setUpdateUserCode(null);
        rmatNoticeEntity.setSyncEsFlag(null);
        rmatNoticeEntity.setVersion(null);
        rmatNoticeEntity.setTenantId(null);
        rmatNoticeEntity.setMemo(null);
        rmatNoticeEntity.setEmployeeId(null);
        rmatNoticeEntity.setEmployeeName(null);
        this.service.saveOrUpdate((Object)rmatNoticeEntity);
        List rmatInviteDetailList = this.inviteDetailService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RmatInviteDetailEntity::getInviteId, (Object)id)).eq(BaseEntity::getDr, (Object)0));
        RmatNoticeDetailEntity rmatNoticeDetailEntity = new RmatNoticeDetailEntity();
        if (CollectionUtil.isNotEmpty((Collection)rmatInviteDetailList)) {
            for (RmatInviteDetailEntity rmatInviteDetailEntity : rmatInviteDetailList) {
                BeanUtils.copyProperties((Object)((Object)rmatNoticeDetailEntity), (Object)((Object)rmatInviteDetailEntity));
                rmatNoticeDetailEntity.setNoticeId(rmatNoticeEntity.getId());
                rmatNoticeDetailEntity.setId(null);
                rmatNoticeDetailEntity.setCreateTime(null);
                rmatNoticeDetailEntity.setUpdateTime(null);
                rmatNoticeDetailEntity.setCreateUserCode(null);
                rmatNoticeDetailEntity.setUpdateUserCode(null);
                rmatNoticeDetailEntity.setSyncEsFlag(null);
                rmatNoticeDetailEntity.setVersion(null);
                rmatNoticeDetailEntity.setTenantId(null);
                this.noticeDetailService.saveOrUpdate((Object)rmatNoticeDetailEntity);
            }
        }
        List rmatInviteSupplierList = this.inviteSupplierService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RmatInviteSupplierEntity::getInviteId, (Object)id)).eq(BaseEntity::getDr, (Object)0));
        RmatNoticeSupplierDetailEntity rmatNoticeSupplierDetailEntity = new RmatNoticeSupplierDetailEntity();
        if (CollectionUtil.isNotEmpty((Collection)rmatInviteSupplierList)) {
            for (RmatInviteSupplierEntity rmatInviteSupplierEntity : rmatInviteSupplierList) {
                BeanUtils.copyProperties((Object)((Object)rmatNoticeSupplierDetailEntity), (Object)((Object)rmatInviteSupplierEntity));
                rmatNoticeSupplierDetailEntity.setInviteId(rmatNoticeEntity.getInviteId());
                rmatNoticeSupplierDetailEntity.setId(null);
                rmatNoticeSupplierDetailEntity.setCreateTime(null);
                rmatNoticeSupplierDetailEntity.setUpdateTime(null);
                rmatNoticeSupplierDetailEntity.setCreateUserCode(null);
                rmatNoticeSupplierDetailEntity.setUpdateUserCode(null);
                rmatNoticeSupplierDetailEntity.setSyncEsFlag(null);
                rmatNoticeSupplierDetailEntity.setVersion(null);
                rmatNoticeSupplierDetailEntity.setTenantId(null);
                this.noticeSupplierDetailService.saveOrUpdate((Object)rmatNoticeSupplierDetailEntity);
            }
        }
        Integer tenderStage = 2;
        this.inviteService.updateTenderStage(id, tenderStage);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(rmatNoticeEntity.getId());
        processEntity.setBillName("\u62db\u6807\u516c\u544a");
        processEntity.setTenderId(rmatNoticeEntity.getInviteId());
        processEntity.setType(4);
        processEntity.setFrontendUrl("rmat/notice");
        this.processSerice.saveOrUpdate((Object)processEntity);
        return CommonResponse.success((String)"\u521d\u59cb\u5316\u6570\u636e\u6210\u529f", (Object)((Object)rmatNoticeEntity));
    }

    @ApiOperation(value="\u5ef6\u957f\u622a\u6b62\u65f6\u95f4")
    @RequestMapping(value={"/extend"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse extend(@RequestBody RmatNoticeChangeEntity rmatNoticeChangeEntity) {
        this.service.updateEndTime(rmatNoticeChangeEntity.getNoticeId(), rmatNoticeChangeEntity.getNewTime());
        RmatNoticeEntity rmatNoticeEntity = (RmatNoticeEntity)((Object)this.service.selectById(rmatNoticeChangeEntity.getNoticeId()));
        HashMap<String, Object> map = new HashMap<String, Object>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("sourceId", rmatNoticeEntity.getInviteId());
        map.put("noticeEndTime", sdf.format(rmatNoticeChangeEntity.getNewTime()));
        CommonResponse response = null;
        try {
            response = this.systemDataPushService.exchangeDataWithUniversal(this.updateTimeUrl, RequestMethod.POST, JSON.toJSONString(map), this.appId, this.appSecret, this.appHost);
            if (!response.isSuccess()) {
                return CommonResponse.error((String)("\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25\uff0c" + response.getMsg()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25");
        }
        this.changeService.saveOrUpdate((Object)rmatNoticeChangeEntity);
        return CommonResponse.success((String)"\u5ef6\u957f\u622a\u6b62\u65f6\u95f4\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u53d1\u5e03\u516c\u544a")
    @RequestMapping(value={"/publish"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse publish(@RequestBody RmatNoticeVO rmatNoticeVO) throws InvocationTargetException, IllegalAccessException {
        return this.service.publish(rmatNoticeVO);
    }

    @ApiOperation(value="\u62a5\u540d\u60c5\u51b5")
    @RequestMapping(value={"/signUp"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> signUp(HttpServletRequest request) {
        this.logger.info("\u8fdb\u5165\u62a5\u540d\u63a5\u53e3request-{},file-{}", (Object)request);
        String notice = request.getParameter("bmNoticeVO");
        this.logger.info("\u62a5\u540d\u5b9e\u4f53\u4fe1\u606f-{}", (Object)notice);
        RmatNoticeSupplierVO rmatNoticeSupplierVO = (RmatNoticeSupplierVO)JSON.parseObject((String)notice, (TypeReference)new TypeReference<RmatNoticeSupplierVO>(){}, (Feature[])new Feature[0]);
        RmatNoticeSupplierEntity rmatNoticeSupplierEntity = (RmatNoticeSupplierEntity)((Object)BeanMapper.map((Object)rmatNoticeSupplierVO, RmatNoticeSupplierEntity.class));
        rmatNoticeSupplierEntity.setNoticeId(this.service.selectNotice(rmatNoticeSupplierVO.getSourceId()));
        rmatNoticeSupplierEntity.setSourceSupplierTenantId(rmatNoticeSupplierVO.getTenantId().toString());
        rmatNoticeSupplierEntity.setSupplierId(Long.valueOf(rmatNoticeSupplierVO.getSourceSupplierId()));
        SupplierDTO supplierVO = (SupplierDTO)this.shareSupplierApi.queryById(Long.valueOf(rmatNoticeSupplierVO.getSourceSupplierId())).getData();
        rmatNoticeSupplierEntity.setSupplierName(supplierVO.getName());
        rmatNoticeSupplierEntity.setSupplierEmployeeId(rmatNoticeSupplierVO.getEmployeeId());
        rmatNoticeSupplierEntity.setSupplierEmployeeName(rmatNoticeSupplierVO.getEmployeeName());
        rmatNoticeSupplierEntity.setSupplierEmployeeMobile(rmatNoticeSupplierVO.getEmployeeMobile());
        rmatNoticeSupplierEntity.setId(null);
        rmatNoticeSupplierEntity.setState(0);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RmatNoticeEntity::getInviteId, (Object)rmatNoticeSupplierVO.getSourceId());
        List noticeEntityList = this.service.list((Wrapper)queryWrapper);
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(RmatNoticeSupplierEntity::getSourceSupplierId, (Object)rmatNoticeSupplierVO.getSourceSupplierId())).eq(RmatNoticeSupplierEntity::getNoticeId, (Object)((RmatNoticeEntity)((Object)noticeEntityList.get(0))).getId())).eq(BaseEntity::getDr, (Object)0);
        List supplierEntityList = this.noticeSupplierService.list((Wrapper)lambdaQueryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)supplierEntityList)) {
            this.noticeSupplierService.removeById(((RmatNoticeSupplierEntity)((Object)supplierEntityList.get(0))).getId());
        }
        boolean b = this.noticeSupplierService.saveOrUpdate((Object)rmatNoticeSupplierEntity);
        List pzList = rmatNoticeSupplierVO.getSupplyFileList();
        this.logger.info("\u62a5\u540d\u6587\u4ef6:{}", (Object)JSONObject.toJSONString((Object)pzList));
        if (CollectionUtils.isNotEmpty((Collection)pzList)) {
            ArrayList list = new ArrayList();
            pzList.forEach(e -> {
                AttachmentVO attachmentVO = new AttachmentVO();
                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
                attachmentVO.setSourceId(rmatNoticeSupplierEntity.getId());
                attachmentVO.setSourceType("BmSupplierFileType");
                attachmentVO.setFilePath(e.getFilePath());
                attachmentVO.setOnlinePath(e.getFilePath());
                attachmentVO.setFileName(e.getFileName());
                attachmentVO.setId(e.getFileId());
                list.add(attachmentVO);
                this.logger.info("\u4fdd\u5b58\u6587\u4ef6\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)attachmentVO));
            });
            CommonResponse stringCommonResponse = this.attachmentApi.insertBatch(list);
            this.logger.info(request + "\u62a5\u540d\u6587\u4ef6\u4e0a\u4f20\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
        }
        return CommonResponse.success((String)"\u62a5\u540d\u60c5\u51b5\u63a5\u53e3\u6389\u7528\u6210\u529f", (Object)b);
    }

    @ApiOperation(value="\u5254\u9664\u4f9b\u5e94\u5546")
    @RequestMapping(value={"/deleteSupplier"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse deleteSupplier(@RequestBody RmatNoticeSupplierVO rmatNoticeSupplierVO) {
        ArrayList<RmatNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<RmatNoticeSupplierDetailTbVO>();
        RmatNoticeEntity rmatNoticeEntity = (RmatNoticeEntity)((Object)this.service.selectById(rmatNoticeSupplierVO.getNoticeId()));
        RmatNoticeSupplierDetailTbVO rmatNoticeSupplierDetailTbVO = new RmatNoticeSupplierDetailTbVO();
        rmatNoticeSupplierDetailTbVO.setSourceId(rmatNoticeEntity.getInviteId().toString());
        rmatNoticeSupplierDetailTbVO.setTenantId(rmatNoticeSupplierVO.getTenantId());
        rmatNoticeSupplierDetailTbVO.setSourceSupplierId(rmatNoticeSupplierVO.getSupplierId().toString());
        rmatNoticeSupplierDetailTbVO.setOutReason(rmatNoticeSupplierVO.getOutReason() == null ? "\u8d85\u65f6\u672a\u62a5\u540d" : rmatNoticeSupplierVO.getOutReason());
        supplierDetailTbVOList.add(rmatNoticeSupplierDetailTbVO);
        CommonResponse response = null;
        try {
            response = this.systemDataPushService.exchangeDataWithUniversal(this.updateSupStatusUrl, RequestMethod.POST, JSON.toJSONString(supplierDetailTbVOList), this.appId, this.appSecret, this.appHost);
            if (!response.isSuccess()) {
                return CommonResponse.error((String)("\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25\uff0c" + response.getMsg()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25");
        }
        this.noticeSupplierService.updateState(rmatNoticeSupplierVO.getId());
        return CommonResponse.success((String)"\u5254\u9664\u4f9b\u5e94\u5546\u6210\u529f");
    }
}

