/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.equipment.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSchemeEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSellEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSupplierEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentTalkDetailEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentTalkEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentTalkRecordDetailEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentTalkRecordEntity;
import com.ejianc.business.tender.equipment.mapper.EquipmentTalkMapper;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentSchemeService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentSellService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentSupplierService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.equipment.service.IEquipmentTalkDetailService;
import com.ejianc.business.tender.equipment.service.IEquipmentTalkRecordDetailService;
import com.ejianc.business.tender.equipment.service.IEquipmentTalkRecordService;
import com.ejianc.business.tender.equipment.service.IEquipmentTalkService;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentSellVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentSupplierTbVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentSupplierVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentVO;
import com.ejianc.business.tender.equipment.vo.EquipmentQuotationMaterialVO;
import com.ejianc.business.tender.equipment.vo.EquipmentQuotationSchemeVO;
import com.ejianc.business.tender.equipment.vo.EquipmentQuotationSupplierVO;
import com.ejianc.business.tender.equipment.vo.EquipmentSupplierSellVO;
import com.ejianc.business.tender.equipment.vo.EquipmentTalkDetailVO;
import com.ejianc.business.tender.equipment.vo.EquipmentTalkRecordVO;
import com.ejianc.business.tender.equipment.vo.EquipmentTalkVO;
import com.ejianc.business.tender.equipment.vo.SupplierReplenishVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="equipmentTalkService")
public class EquipmentTalkServiceImpl
extends BaseServiceImpl<EquipmentTalkMapper, EquipmentTalkEntity>
implements IEquipmentTalkService {
    @Value(value="${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value(value="${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value(value="${gysUrl.updateSupOffer}")
    private String updateSupOffer;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-talk-code";
    @Autowired
    private IEquipmentTalkDetailService equipmentTalkDetailService;
    @Autowired
    private IEquipmentTalkRecordService equipmentTalkRecordService;
    @Autowired
    private IEquipmentTalkRecordDetailService equipmentTalkRecordDetailService;
    @Autowired
    private IEquipmentDocumentSellService equipmentDocumentSellService;
    @Autowired
    private IEquipmentDocumentService equipmentDocumentService;
    @Autowired
    private IEquipmentInviteService equipmentInviteService;
    @Autowired
    private IEquipmentDocumentSupplierService equipmentDocumentSupplierService;
    @Autowired
    private IEquipmentDocumentSchemeService equipmentDocumentSchemeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProcessService processService;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000001";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    @Transactional
    public EquipmentTalkVO publishTalk(Long id) {
        EquipmentTalkEntity equipmentTalkEntity = (EquipmentTalkEntity)((Object)super.selectById((Serializable)id));
        equipmentTalkEntity.setPublishFlag(0);
        super.updateById((Object)equipmentTalkEntity);
        EquipmentDocumentSupplierTbVO equipmentDocumentSupplierTbVO = new EquipmentDocumentSupplierTbVO();
        equipmentDocumentSupplierTbVO.setSourceId(equipmentTalkEntity.getInviteId().toString());
        equipmentDocumentSupplierTbVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u6d3d\u5546\u8c08\u5224");
        equipmentDocumentSupplierTbVO.setNoticeType(Integer.valueOf(4));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(equipmentTalkEntity.getTalkStartTime());
        equipmentDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(equipmentTalkEntity.getTalkEndTime());
        equipmentDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        equipmentDocumentSupplierTbVO.setMemo(equipmentTalkEntity.getMemo());
        equipmentDocumentSupplierTbVO.setTalkMoney(equipmentTalkEntity.getTalkMoney());
        equipmentDocumentSupplierTbVO.setTalkNum(equipmentTalkEntity.getTalkNum());
        equipmentDocumentSupplierTbVO.setTenderName(equipmentTalkEntity.getTalkName());
        equipmentDocumentSupplierTbVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        String stringFb = JSONObject.toJSONString((Object)equipmentDocumentSupplierTbVO);
        this.logger.info("\u6d3d\u5546\u8c08\u5224\u53d1\u5e03" + stringFb);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.saveOrUpdateUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u6d3d\u5546\u8c08\u5224\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(id);
    }

    @Override
    public EquipmentTalkVO extendTalk(EquipmentTalkDetailVO equipmentTalkDetailVO) {
        EquipmentTalkDetailEntity equipmentDocumentRecordEntity = (EquipmentTalkDetailEntity)((Object)BeanMapper.map((Object)equipmentTalkDetailVO, EquipmentTalkDetailEntity.class));
        this.equipmentTalkDetailService.save((Object)equipmentDocumentRecordEntity);
        EquipmentTalkEntity equipmentTalkEntity = (EquipmentTalkEntity)((Object)super.selectById((Serializable)equipmentTalkDetailVO.getTalkId()));
        equipmentTalkEntity.setTalkEndTime(equipmentTalkDetailVO.getNewTime());
        boolean b = super.updateById((Object)equipmentTalkEntity);
        EquipmentSupplierSellVO supplierSellVO = new EquipmentSupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(equipmentTalkEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(equipmentTalkDetailVO.getNewTime());
        String stringFb = JSONObject.toJSONString((Object)supplierSellVO);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.updateTimeUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u6d3d\u5546\u8c08\u5224\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(equipmentTalkDetailVO.getTalkId());
    }

    @Override
    public EquipmentTalkVO saveTalk(Long documentId) {
        EquipmentTalkEntity entity = new EquipmentTalkEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        EquipmentDocumentEntity documentEntity = (EquipmentDocumentEntity)((Object)this.equipmentDocumentService.selectById(documentId));
        documentEntity.setNextFlag(0);
        this.equipmentDocumentService.saveOrUpdate((Object)documentEntity);
        EquipmentDocumentEntity equipmentDocumentEntity = (EquipmentDocumentEntity)((Object)this.equipmentDocumentService.selectById(documentId));
        EquipmentInviteEntity equipmentInviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(equipmentDocumentEntity.getInviteId()));
        entity.setProjectCode(equipmentDocumentEntity.getProjectCode());
        entity.setInviteId(equipmentDocumentEntity.getInviteId());
        entity.setProjectId(equipmentDocumentEntity.getProjectId());
        entity.setProjectName(equipmentDocumentEntity.getProjectName());
        entity.setOrgId(equipmentDocumentEntity.getOrgId());
        entity.setOrgName(equipmentDocumentEntity.getOrgName());
        entity.setParentOrgId(equipmentDocumentEntity.getParentOrgId());
        entity.setParentOrgName(equipmentDocumentEntity.getParentOrgName());
        entity.setBrandFlag(equipmentDocumentEntity.getBrandFlag());
        entity.setBillId(documentId);
        entity.setTalkNum(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        String taikNumName = "\u7b2c" + entity.getTalkNum() + "\u8f6e\u62a5\u4ef7";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(equipmentDocumentEntity.getPurchaseType());
        entity.setTalkName(equipmentInviteEntity.getTenderName());
        super.save((Object)entity);
        equipmentInviteEntity.setTenderStage(7);
        this.equipmentInviteService.updateById((Object)equipmentInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u6d3d\u5546\u8c08\u5224");
        processEntity.setTenderId(equipmentDocumentEntity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("equipment/talkNegotiate");
        this.processService.saveOrUpdate((Object)processEntity);
        EquipmentTalkVO vo = (EquipmentTalkVO)BeanMapper.map((Object)((Object)entity), EquipmentTalkVO.class);
        EquipmentTalkVO equipmentTalkVO = this.queryDetail(vo.getId());
        return equipmentTalkVO;
    }

    @Override
    public EquipmentTalkVO queryDetail(Long id) {
        EquipmentTalkEntity equipmentTalkEntity = (EquipmentTalkEntity)((Object)super.selectById((Serializable)id));
        EquipmentTalkVO equipmentTalkVO = (EquipmentTalkVO)BeanMapper.map((Object)((Object)equipmentTalkEntity), EquipmentTalkVO.class);
        Integer talkNum = equipmentTalkEntity.getTalkNum();
        if (equipmentTalkEntity.getPublishFlag() == 1) {
            talkNum = talkNum - 1;
        }
        EquipmentDocumentVO equipmentDocumentVO = this.equipmentDocumentService.queryDocDetail(equipmentTalkEntity.getBillId(), talkNum);
        equipmentTalkVO.setEquipmentDocumentDetailSellList(equipmentDocumentVO.getEquipmentDocumentDetailSellList());
        equipmentTalkVO.setEquipmentDocumentSupplierSchemeList(equipmentDocumentVO.getEquipmentDocumentSupplierSchemeList());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(EquipmentDocumentSupplierEntity::getDocumentId, (Object)equipmentTalkEntity.getBillId());
        lambda.eq(EquipmentDocumentSupplierEntity::getTalkNum, (Object)0);
        List supplierList = this.equipmentDocumentSupplierService.list((Wrapper)lambda);
        List documentSupplierVOList = BeanMapper.mapList((Iterable)supplierList, EquipmentDocumentSupplierVO.class);
        equipmentTalkVO.setEquipmentDocumentSupplierList(documentSupplierVOList);
        LambdaQueryWrapper lambdaRecord = Wrappers.lambdaQuery();
        lambdaRecord.eq(EquipmentTalkRecordEntity::getBillId, (Object)equipmentTalkEntity.getBillId());
        lambdaRecord.orderByAsc(EquipmentTalkRecordEntity::getTalkNum);
        List equipmentTalkRecordEntityList = this.equipmentTalkRecordService.list((Wrapper)lambdaRecord);
        List equipmentTalkRecordList = BeanMapper.mapList((Iterable)equipmentTalkRecordEntityList, EquipmentTalkRecordVO.class);
        equipmentTalkVO.setTalkRecordEntityList(equipmentTalkRecordList);
        return equipmentTalkVO;
    }

    @Override
    @Transactional
    public EquipmentTalkVO againSaveTalk(Long id) {
        EquipmentTalkEntity entity = new EquipmentTalkEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        EquipmentTalkEntity equipmentTalkEntity = (EquipmentTalkEntity)((Object)super.selectById((Serializable)id));
        entity.setProjectCode(equipmentTalkEntity.getProjectCode());
        entity.setProjectId(equipmentTalkEntity.getProjectId());
        entity.setProjectName(equipmentTalkEntity.getProjectName());
        entity.setOrgId(equipmentTalkEntity.getOrgId());
        entity.setOrgName(equipmentTalkEntity.getOrgName());
        entity.setParentOrgId(equipmentTalkEntity.getParentOrgId());
        entity.setParentOrgName(equipmentTalkEntity.getParentOrgName());
        entity.setBrandFlag(equipmentTalkEntity.getBrandFlag());
        entity.setBillId(equipmentTalkEntity.getBillId());
        entity.setInviteId(equipmentTalkEntity.getInviteId());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setTalkNum(equipmentTalkEntity.getTalkNum() + 1);
        String taikNumName = "\u7b2c" + entity.getTalkNum() + "\u8f6e\u62a5\u4ef7";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(equipmentTalkEntity.getPurchaseType());
        super.save((Object)entity);
        EquipmentTalkRecordEntity equipmentTalkRecordEntity = (EquipmentTalkRecordEntity)((Object)BeanMapper.map((Object)((Object)equipmentTalkEntity), EquipmentTalkRecordEntity.class));
        equipmentTalkRecordEntity.setTalkId(equipmentTalkEntity.getId());
        equipmentTalkRecordEntity.setId(null);
        this.equipmentTalkRecordService.save((Object)equipmentTalkRecordEntity);
        List<EquipmentTalkDetailEntity> equipmentTalkDetailList = equipmentTalkEntity.getEquipmentTalkDetailList();
        List equipmentTalkRecordDetailEntityList = BeanMapper.mapList(equipmentTalkDetailList, EquipmentTalkRecordDetailEntity.class);
        for (EquipmentTalkRecordDetailEntity equipmentTalkRecordDetailEntity : equipmentTalkRecordDetailEntityList) {
            equipmentTalkRecordDetailEntity.setId(null);
            equipmentTalkRecordDetailEntity.setRecordId(equipmentTalkRecordEntity.getId());
        }
        this.equipmentTalkRecordDetailService.saveBatch(equipmentTalkRecordDetailEntityList);
        super.removeById((Serializable)id, false);
        LambdaQueryWrapper lambdaProcess = Wrappers.lambdaQuery();
        lambdaProcess.eq(ProcessEntity::getBillId, (Object)id);
        lambdaProcess.eq(ProcessEntity::getTenderId, (Object)equipmentTalkEntity.getInviteId());
        ProcessEntity processEntity = (ProcessEntity)((Object)this.processService.getOne((Wrapper)lambdaProcess));
        processEntity.setBillId(entity.getId());
        this.processService.updateById((Object)processEntity);
        EquipmentTalkVO vo = (EquipmentTalkVO)BeanMapper.map((Object)((Object)entity), EquipmentTalkVO.class);
        this.addLastSell(equipmentTalkEntity.getTalkNum(), equipmentTalkEntity.getBillId());
        return this.queryDetail(entity.getId());
    }

    @Override
    public EquipmentTalkVO replenishSell(Long id) {
        EquipmentTalkEntity equipmentTalkEntity = (EquipmentTalkEntity)((Object)super.selectById((Serializable)id));
        Integer talkNum = equipmentTalkEntity.getTalkNum();
        Long billId = equipmentTalkEntity.getBillId();
        this.addLastSell(talkNum, billId);
        return new EquipmentTalkVO();
    }

    @Override
    public Boolean getSellFull(Long id) {
        EquipmentTalkEntity equipmentTalkEntity = (EquipmentTalkEntity)((Object)super.selectById((Serializable)id));
        Integer talkNum = equipmentTalkEntity.getTalkNum();
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(EquipmentDocumentSupplierEntity::getDocumentId, (Object)equipmentTalkEntity.getBillId());
        lambdaSupplier.eq(EquipmentDocumentSupplierEntity::getTalkNum, (Object)talkNum);
        List supplierList = this.equipmentDocumentSupplierService.list((Wrapper)lambdaSupplier);
        LambdaQueryWrapper lambdaSupplierFirst = Wrappers.lambdaQuery();
        lambdaSupplierFirst.eq(EquipmentDocumentSupplierEntity::getDocumentId, (Object)equipmentTalkEntity.getBillId());
        lambdaSupplierFirst.eq(EquipmentDocumentSupplierEntity::getTalkNum, (Object)0);
        List supplierListFirst = this.equipmentDocumentSupplierService.list((Wrapper)lambdaSupplierFirst);
        if (supplierListFirst == null || supplierListFirst.size() == 0) {
            return false;
        }
        if (supplierList.size() != supplierListFirst.size()) {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> querySupplierList(Long talkId) {
        HashMap<String, Object> stringListMap = new HashMap<String, Object>();
        EquipmentTalkEntity equipmentTalkEntity = (EquipmentTalkEntity)((Object)((EquipmentTalkMapper)this.baseMapper).selectById(talkId));
        ArrayList<EquipmentQuotationMaterialVO> materialVOList = new ArrayList<EquipmentQuotationMaterialVO>();
        List<EquipmentDocumentSellEntity> equipmentDocumentSellEntities = this.equipmentDocumentSellService.selectMaterialType(equipmentTalkEntity.getBillId());
        Integer talkNum = equipmentDocumentSellEntities.get(0).getTalkNum();
        List sellEntityList = BeanMapper.mapList(equipmentDocumentSellEntities, EquipmentDocumentSellVO.class);
        Map<Long, List<EquipmentDocumentSellVO>> collect = sellEntityList.stream().filter(map -> map.getProjectId() != null).collect(Collectors.groupingBy(EquipmentDocumentSellVO::getProjectId));
        for (List<EquipmentDocumentSellVO> sellVOS : collect.values()) {
            Map<Long, List<EquipmentDocumentSellVO>> listMap = sellVOS.stream().filter(map -> map.getMaterialId() != null).collect(Collectors.groupingBy(EquipmentDocumentSellVO::getMaterialId));
            for (Long materialTypeId : listMap.keySet()) {
                EquipmentQuotationMaterialVO materialVO = new EquipmentQuotationMaterialVO();
                List<EquipmentDocumentSellVO> materialTypeList = listMap.get(materialTypeId);
                for (EquipmentDocumentSellVO sellVO : materialTypeList) {
                    materialVO = (EquipmentQuotationMaterialVO)BeanMapper.map((Object)sellVO, EquipmentQuotationMaterialVO.class);
                }
                List equipmentQuotationSupplierVOS = BeanMapper.mapList(materialTypeList, EquipmentQuotationSupplierVO.class);
                List supplierVOS = equipmentQuotationSupplierVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<EquipmentQuotationSupplierVO>(Comparator.comparing(EquipmentQuotationSupplierVO::getSupplierId))), ArrayList::new));
                materialVO.setSupplierList(supplierVOS);
                Map<Long, List<EquipmentDocumentSellVO>> supplierMap = materialTypeList.stream().filter(map -> map.getSupplierId() != null).collect(Collectors.groupingBy(EquipmentDocumentSellVO::getSupplierId));
                for (EquipmentQuotationSupplierVO supplierVO : materialVO.getSupplierList()) {
                    List<EquipmentDocumentSellVO> equipmentDocumentSellVOS = supplierMap.get(supplierVO.getSupplierId());
                    for (EquipmentDocumentSellVO equipmentDocumentSellVO : equipmentDocumentSellVOS) {
                        supplierVO.setSupplierName(equipmentDocumentSellVO.getSupplierName());
                    }
                    List equipmentQuotationSchemeVOS = BeanMapper.mapList(equipmentDocumentSellVOS, EquipmentQuotationSchemeVO.class);
                    List schemeVOS = equipmentQuotationSchemeVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<EquipmentQuotationSchemeVO>(Comparator.comparing(f -> f.getSchemeName()))), ArrayList::new));
                    supplierVO.setSchemeList(schemeVOS);
                    Map<String, List<EquipmentDocumentSellVO>> schemeMap = equipmentDocumentSellVOS.stream().filter(map -> map.getSchemeName() != null).collect(Collectors.groupingBy(EquipmentDocumentSellVO::getSchemeName));
                    for (EquipmentQuotationSchemeVO equipmentQuotationSchemeVO : supplierVO.getSchemeList()) {
                        List<EquipmentDocumentSellVO> priceList = schemeMap.get(equipmentQuotationSchemeVO.getSchemeName());
                        if (priceList.size() < talkNum + 1) {
                            EquipmentDocumentSellVO documentSellVO = new EquipmentDocumentSellVO();
                            documentSellVO.setPrice(BigDecimal.valueOf(-1L));
                            documentSellVO.setPriceTax(BigDecimal.valueOf(-1L));
                            documentSellVO.setMoney(BigDecimal.valueOf(-1L));
                            documentSellVO.setMoneyTax(BigDecimal.valueOf(-1L));
                            documentSellVO.setTalkNum(talkNum);
                            priceList.add(0, documentSellVO);
                        }
                        equipmentQuotationSchemeVO.setPriceList(priceList);
                    }
                }
                materialVOList.add(materialVO);
            }
        }
        stringListMap.put("MaterialTypeList", materialVOList);
        stringListMap.put("offerNum", equipmentDocumentSellEntities.get(0).getTalkNum());
        return stringListMap;
    }

    @Override
    public EquipmentTalkVO saveOrUpdates(EquipmentTalkVO saveorUpdateVO) {
        EquipmentTalkEntity entity = (EquipmentTalkEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, EquipmentTalkEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        EquipmentTalkVO vo = (EquipmentTalkVO)BeanMapper.map((Object)((Object)entity), EquipmentTalkVO.class);
        EquipmentTalkVO equipmentTalkVO = this.queryDetail(vo.getId());
        return equipmentTalkVO;
    }

    private void addLastSell(Integer talkNum, Long docId) {
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(EquipmentDocumentSupplierEntity::getDocumentId, (Object)docId);
        lambdaSupplier.eq(EquipmentDocumentSupplierEntity::getTalkNum, (Object)talkNum);
        List supplierList = this.equipmentDocumentSupplierService.list((Wrapper)lambdaSupplier);
        LambdaQueryWrapper lambdaSupplierLast = Wrappers.lambdaQuery();
        lambdaSupplierLast.eq(EquipmentDocumentSupplierEntity::getDocumentId, (Object)docId);
        lambdaSupplierLast.eq(EquipmentDocumentSupplierEntity::getTalkNum, (Object)(talkNum - 1));
        List supplierListLast = this.equipmentDocumentSupplierService.list((Wrapper)lambdaSupplierLast);
        List supplierPk = supplierList.stream().map(EquipmentDocumentSupplierEntity::getSupplierId).collect(Collectors.toList());
        List documentSupplierEntityDataList = supplierListLast.stream().filter(s -> !supplierPk.contains(s.getSupplierId())).collect(Collectors.toList());
        List documentSupplierEntityNewList = BeanMapper.mapList(documentSupplierEntityDataList, EquipmentDocumentSupplierEntity.class);
        if (documentSupplierEntityDataList.size() == 0) {
            return;
        }
        ArrayList<SupplierReplenishVO> replenishVOArrayList = new ArrayList<SupplierReplenishVO>();
        EquipmentDocumentEntity equipmentDocumentEntity = (EquipmentDocumentEntity)((Object)this.equipmentDocumentService.selectById(docId));
        for (EquipmentDocumentSupplierEntity equipmentDocumentSupplierEntity : documentSupplierEntityNewList) {
            SupplierReplenishVO supplierReplenishVO = new SupplierReplenishVO();
            supplierReplenishVO.setSourceId(Long.toString(equipmentDocumentEntity.getInviteId()));
            supplierReplenishVO.setTalkNum(talkNum);
            supplierReplenishVO.setTenantId(Long.toString(equipmentDocumentSupplierEntity.getSupplierTenantId()));
            replenishVOArrayList.add(supplierReplenishVO);
        }
        String stringFb = JSONObject.toJSONString(replenishVOArrayList);
        this.logger.info("\u518d\u6b21\u6d3d\u5546\u63a8\u9001\u4f9b\u65b9\u63a5\u53e3\u6570\u636e:" + stringFb);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.updateSupOffer, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u518d\u6b21\u6d3d\u5546\u63a8\u9001\u4f9b\u65b9\u63a5\u53e3\u6570\u636eresponse:" + stringCommonResponse.getMsg());
        }
        List supplierPkNew = documentSupplierEntityNewList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        for (EquipmentDocumentSupplierEntity equipmentDocumentSupplierEntity : documentSupplierEntityNewList) {
            equipmentDocumentSupplierEntity.setId(IdWorker.getId());
            equipmentDocumentSupplierEntity.setTalkNum(talkNum);
        }
        this.equipmentDocumentSupplierService.saveBatch(documentSupplierEntityNewList);
        for (EquipmentDocumentSupplierEntity equipmentDocumentSupplierEntity : documentSupplierEntityNewList) {
            for (Object equipmentDocumentSupplierLastEntity : supplierListLast) {
                CommonResponse responseCopy;
                if (!equipmentDocumentSupplierEntity.getSupplierId().equals(((EquipmentDocumentSupplierEntity)((Object)equipmentDocumentSupplierLastEntity)).getSupplierId()) || (responseCopy = this.attachmentApi.copyFilesFromSourceBillToTargetBill(equipmentDocumentSupplierLastEntity.getId().toString(), BILL_SUPPLIER_TYPE, "supplierFileType", equipmentDocumentSupplierEntity.getId().toString(), BILL_SUPPLIER_TYPE, "supplierFileType")).isSuccess()) continue;
                throw new BusinessException("\u518d\u6b21\u6d3d\u5546\u9644\u4ef6\u590d\u5236\u5931\u8d25:" + responseCopy.getMsg());
            }
        }
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(EquipmentDocumentSchemeEntity::getDocumentId, (Object)docId);
        lambdaScheme.eq(EquipmentDocumentSchemeEntity::getTalkNum, (Object)(talkNum - 1));
        lambdaScheme.in(EquipmentDocumentSchemeEntity::getDocumentSupplierId, supplierPkNew);
        List schemeList = this.equipmentDocumentSchemeService.list((Wrapper)lambdaScheme);
        List schemePkList = schemeList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        for (EquipmentDocumentSchemeEntity equipmentDocumentSchemeEntity : schemeList) {
            equipmentDocumentSchemeEntity.setId(IdWorker.getId());
            equipmentDocumentSchemeEntity.setTalkNum(talkNum);
            for (EquipmentDocumentSupplierEntity equipmentDocumentSupplierEntity : documentSupplierEntityNewList) {
                if (!equipmentDocumentSchemeEntity.getSupplierId().equals(equipmentDocumentSupplierEntity.getSupplierId())) continue;
                equipmentDocumentSchemeEntity.setDocumentSupplierId(equipmentDocumentSupplierEntity.getId());
            }
        }
        this.equipmentDocumentSchemeService.saveBatch(schemeList);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(EquipmentDocumentSellEntity::getDocumentId, (Object)docId);
        lambdaSell.eq(EquipmentDocumentSellEntity::getTalkNum, (Object)(talkNum - 1));
        lambdaSell.in(EquipmentDocumentSellEntity::getSchemeId, schemePkList);
        List sellList = this.equipmentDocumentSellService.list((Wrapper)lambdaSell);
        for (EquipmentDocumentSellEntity equipmentDocumentSellEntity : sellList) {
            equipmentDocumentSellEntity.setId(null);
            equipmentDocumentSellEntity.setTalkNum(talkNum);
            for (EquipmentDocumentSchemeEntity equipmentDocumentSchemeEntity : schemeList) {
                if (!equipmentDocumentSellEntity.getSupplierId().equals(equipmentDocumentSchemeEntity.getSupplierId()) || !equipmentDocumentSellEntity.getSchemeName().equals(equipmentDocumentSchemeEntity.getSchemeName())) continue;
                equipmentDocumentSellEntity.setSchemeId(equipmentDocumentSchemeEntity.getId());
            }
        }
        this.equipmentDocumentSellService.saveBatch(sellList);
    }
}

