package com.ejianc.business.tender.prosub.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.prosub.bean.*;
import com.ejianc.business.tender.prosub.service.*;
import com.ejianc.business.tender.prosub.vo.ProsubBidVO;
import com.ejianc.business.tender.stuff.bean.StuffInviteDetailRecordEntity;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.service.ISubInviteDetailRecordService;
import com.ejianc.business.tender.sub.vo.SubBidVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("prosubPicketage")
public class ProsubPicketageBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IProsubPicketageService subPicketageService;
	@Autowired
	private IProsubBidService subBidService;
	@Autowired
	private IProsubWinnoticeService subWinnoticeService;
	@Autowired
	private IProsubInviteService subInviteService;
	@Autowired
	private IProsubBidDetailService subBidDetailService;
	@Autowired
	private IProsubDocumentSellService subDocumentSellService;
	@Autowired
	private IProsubDocumentService subDocumentService;
	@Autowired
	private IProsubBidSupplierService subBidSupplierService;
	@Autowired
	private IProsubDocumentSupplierService subDocumentSupplierService;
	@Autowired
	private IProsubAdviceService subAdviceService;
	@Autowired
	private IProcessService processService;
	@Autowired
	private IShareSupplierApi shareSupplierApi;
	@Autowired
	private IProsubPicketageRefsupplierService subPicketageRefsupplierService;
	@Autowired
	private IProsubPicketageSupplierService subPicketageSupplierService;
	@Value("${gysUrl.updateTimeUrl}")
	private String updateTimeUrl;

	@Value("${gysUrl.winbidSavesUrl}")
	private String winbidSavesUrl;
	private static final String BILL_CODE = "invite-bid-code";//此处需要根据实际修改
	private org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IProjectPoolApi projectPoolApi;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}
	@Autowired
	private IProsubInviteDetailRecordService prosubInviteDetailRecordService;
	@Autowired
	private IProSubBatPlanService prosubBatPlanService;
	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("billId"+billId);
		ProsubBidVO subBidVO = subBidService.saveBid(billId);

		subBidService.publishBid(subBidVO);

		//处理参照表,只处理项目线的数据
		//查询出所有定标的数据
		ProsubPicketageEntity subPicketageEntity = subPicketageService.selectById(billId);
		ProsubInviteEntity subInviteEntity = subInviteService.selectById(subPicketageEntity.getInviteId());

		// 完成采购计划
		QueryParam stuffInviteDetailQueryParam = new QueryParam();
		stuffInviteDetailQueryParam.getParams()
				.put("invite_id", new Parameter(QueryParam.EQ, subInviteEntity.getId()));
		List<ProsubInviteDetailRecordEntity> stuffInviteDetailEntityList = prosubInviteDetailRecordService
				.queryList(stuffInviteDetailQueryParam);
		// 获取采购计划ID
		if (CollectionUtils.isNotEmpty(stuffInviteDetailEntityList)) {
			List<String> planIdList = stuffInviteDetailEntityList.stream()
					.map(ProsubInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct()
					.collect(Collectors.toList());
			// 释放采购计划
			//CommonResponse<String> response = batPlanApi.updateBatPlanQuote(planIdList, BatPlanEnum.PLAN_STATE_OVER.getPlanState());
			prosubBatPlanService.updateBatPlanByQuoteType(planIdList, BatPlanEnum.PLAN_STATE_OVER.getPlanState(),0);

		}

		LambdaQueryWrapper<ProsubDocumentEntity> docWrapper = Wrappers.lambdaQuery();
		docWrapper.eq(ProsubDocumentEntity::getInviteId,subPicketageEntity.getInviteId());
		ProsubDocumentEntity subDocument = subDocumentService.getOne(docWrapper);
//		if (subInviteEntity.getPurchaseType().equals(0)){
		LambdaQueryWrapper<ProsubDocumentSellEntity> sellWrapper = Wrappers.lambdaQuery();
		sellWrapper.eq(ProsubDocumentSellEntity::getDocumentId,subPicketageEntity.getDocumentId());
		sellWrapper.eq(ProsubDocumentSellEntity::getTenderFlag,1);
		List<ProsubDocumentSellEntity> ProsubDocumentSellList = subDocumentSellService.list(sellWrapper);
		//项目招标
		//改造-0905
		Map<Long, ProjectPoolSetVO> proMap = new HashMap<>();
		//if (subInviteEntity.getPurchaseType().equals(0)){
			List<Long> projectPks = ProsubDocumentSellList.stream().map(ProsubDocumentSellEntity::getProjectId).collect(Collectors.toList());
			CommonResponse<JSONArray> jsonArrayCommonResponse = projectPoolApi.queryProjectByIds(projectPks);

			if (jsonArrayCommonResponse.isSuccess()){
				JSONArray data = jsonArrayCommonResponse.getData();
				List<ProjectPoolSetVO> projectRegisterVOS = data.toJavaList(ProjectPoolSetVO.class);
				proMap = projectRegisterVOS.stream().collect(Collectors.toMap(ProjectPoolSetVO::getId, Function.identity()));
			}
		//}
		Map<String, List<ProsubDocumentSellEntity>> dataMap = new HashMap<>();
		for (ProsubDocumentSellEntity subDocumentSellEntity : ProsubDocumentSellList){
			//改造-0905
			//if (subInviteEntity.getPurchaseType().equals(0)){
				ProjectPoolSetVO projectPoolSetVO = proMap.get(subDocumentSellEntity.getProjectId());
				if (projectPoolSetVO != null){
					subDocumentSellEntity.setOrgId(projectPoolSetVO.getProjectDepartmentId());
					subDocumentSellEntity.setOrgName(projectPoolSetVO.getProjectDepartmentName());
				}
			//}
			String s = null;
			//if (subInviteEntity.getPurchaseType().equals(0)){
				s = subDocumentSellEntity.getProjectId().toString() + subDocumentSellEntity.getSupplierId()
						.toString();
//			}
//			if (subInviteEntity.getPurchaseType().equals(1)){
//				s = subDocumentSellEntity.getSupplierId()
//						.toString();
//			}
			if (dataMap.containsKey(s)){
				List<ProsubDocumentSellEntity> subDocumentSellEntityList = dataMap.get(s);
				subDocumentSellEntityList.add(subDocumentSellEntity);
				dataMap.put(s,subDocumentSellEntityList);
			}else {
				List<ProsubDocumentSellEntity> subDocumentSellEntities = new ArrayList<>();
				subDocumentSellEntities.add(subDocumentSellEntity);
				dataMap.put(s,subDocumentSellEntities);
			}
		}
		List<ProsubPicketageRefsupplierEntity> subPicketageRefsupplierEntities = new ArrayList<>();
		dataMap.forEach((key,value) -> {
			ProsubPicketageRefsupplierEntity subPicketageRefsupplierEntity = new ProsubPicketageRefsupplierEntity();
			ProsubDocumentSellEntity subSellEntity = value.stream().findFirst().get();
			subPicketageRefsupplierEntity.setSupplierId(subSellEntity.getSupplierId());
			subPicketageRefsupplierEntity.setSupplierName(subSellEntity.getSupplierName());
			subPicketageRefsupplierEntity.setProjectId(subSellEntity.getProjectId());
			subPicketageRefsupplierEntity.setProjectName(subSellEntity.getProjectName());
			subPicketageRefsupplierEntity.setProjectCode(subInviteEntity.getProjectCode());
			subPicketageRefsupplierEntity.setPicketageId(billId);
			subPicketageRefsupplierEntity.setOccupyFlag(0);
			SupplierDTO supplierVO = shareSupplierApi.queryById(subSellEntity.getSupplierId()).getData();
			subPicketageRefsupplierEntity.setSupplierTenantId(supplierVO.getTenant());
			subPicketageRefsupplierEntity.setPicketageName(subPicketageEntity.getPicketageName());
			subPicketageRefsupplierEntity.setPicketageDate(new Date());
			//改造-0905
			//if (subInviteEntity.getPurchaseType().equals(0)){
				subPicketageRefsupplierEntity.setOrgId(subSellEntity.getOrgId());
				subPicketageRefsupplierEntity.setOrgName(subSellEntity.getOrgName());
//			}
//			if (subInviteEntity.getPurchaseType().equals(1)){
//				subPicketageRefsupplierEntity.setOrgId(subInviteEntity.getOrgId());
//				subPicketageRefsupplierEntity.setOrgName(subInviteEntity.getOrgName());
//			}
			subPicketageRefsupplierEntity.setParentOrgId(subInviteEntity.getParentOrgId());
			subPicketageRefsupplierEntity.setParentOrgName(subInviteEntity.getParentOrgName());
			subPicketageRefsupplierEntity.setUnitId(subInviteEntity.getUnitId());
			subPicketageRefsupplierEntity.setUnitName(subInviteEntity.getUnitName());
			subPicketageRefsupplierEntity.setProjectQualificationId(subInviteEntity.getProjectQualificationId());
			subPicketageRefsupplierEntity.setProjectQualification(subInviteEntity.getProjectQualification());
			subPicketageRefsupplierEntity.setProjectLinkName(subDocument.getProjectLinkName());
			subPicketageRefsupplierEntity.setProjectLinkPhone(subDocument.getProjectLinkPhone());
			subPicketageRefsupplierEntity.setPicketageFlag(0);
			subPicketageRefsupplierEntity.setSignStatus(TenderSignStatusEnum.未签订.getCode());
			subPicketageRefsupplierEntity.setPurchaseType(subInviteEntity.getPurchaseType());

			BigDecimal tenderMoney = BigDecimal.ZERO;
			BigDecimal tenderMoneyTax = BigDecimal.ZERO;
			for (ProsubDocumentSellEntity subDocumentSellEntity : value){
				tenderMoney = tenderMoney.add(subDocumentSellEntity.getTenderMoney());
				tenderMoneyTax = tenderMoneyTax.add(subDocumentSellEntity.getTenderMoneyTax());
			}
			subPicketageRefsupplierEntity.setMoney(tenderMoney.setScale(2, BigDecimal.ROUND_HALF_UP));
			subPicketageRefsupplierEntity.setMoneyTax(tenderMoneyTax.setScale(2, BigDecimal.ROUND_HALF_UP));
			subPicketageRefsupplierEntities.add(subPicketageRefsupplierEntity);
		});
		subPicketageRefsupplierService.saveBatch(subPicketageRefsupplierEntities);
//		}
//生成中标通知书类表数据
		List<ProsubPicketageSupplierEntity> picketageSupplierList = subPicketageEntity.getPicketageSupplierList();
		List<ProsubAdviceEntity> subAdviceList = BeanMapper.mapList(picketageSupplierList, ProsubAdviceEntity.class);
		for (ProsubAdviceEntity subAdviceEntity : subAdviceList){
			subAdviceEntity.setTitleName(subInviteEntity.getTenderName());
			subAdviceEntity.setUnitId(subInviteEntity.getUnitId());
			subAdviceEntity.setUnitName(subInviteEntity.getUnitName());
			subAdviceEntity.setProjectId(subInviteEntity.getProjectId());
			subAdviceEntity.setProjectName(subInviteEntity.getProjectName());
			subAdviceEntity.setOrgId(subInviteEntity.getOrgId());
			subAdviceEntity.setOrgName(subInviteEntity.getOrgName());
			subAdviceEntity.setParentOrgId(subInviteEntity.getParentOrgId());
			subAdviceEntity.setParentOrgName(subInviteEntity.getParentOrgName());
			subAdviceEntity.setParentOrgName(subInviteEntity.getParentOrgName());
			subAdviceEntity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(subInviteEntity.getTenderType()).getDescription());
			subAdviceEntity.setLineTypeName(CommonUtils.getTypeName(1));
			subAdviceEntity.setPurchaseType(subInviteEntity.getPurchaseType());
			subAdviceEntity.setScFlag(1);
			subAdviceEntity.setSendFlag(1);
			subAdviceEntity.setSignFlag(0);
			subAdviceEntity.setId(null);
			subAdviceEntity.setInviteId(subInviteEntity.getId());
		}
		subAdviceService.saveBatch(subAdviceList);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该功能不支持！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
