package com.ejianc.business.tender.stuff.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.stuff.service.*;
import com.ejianc.business.tender.stuff.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.apache.xpath.operations.Bool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.multipart.MultipartFile;

/**
 * 招标文件主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("stuffDocument")
@Api(value = "招标文件主表", tags = {"招标文件主表"})
public class StuffDocumentController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "invite-document-code";//此处需要根据实际修改
    @Autowired
    private IStuffDocumentService service;
    @Autowired
    private IStuffTalkService talkService;
    @Autowired
    private IStuffDocumentSupplierService documentSupplierService;
    @Autowired
    private IStuffInviteService inviteService;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StuffDocumentVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody StuffDocumentVO saveorUpdateVO) {
    	StuffDocumentEntity entity = BeanMapper.map(saveorUpdateVO, StuffDocumentEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	StuffDocumentVO vo = BeanMapper.map(entity, StuffDocumentVO.class);

    	//显示是否推送筑材网
        StuffInviteEntity stuffInviteEntity = inviteService.selectById(vo.getInviteId());
        if (stuffInviteEntity != null && stuffInviteEntity.getIsPushZcw() != null){
            if(stuffInviteEntity.getIsPushZcw() == 1){
                vo.setIsPushZcw("已推送筑材网");
            }else {
                vo.setIsPushZcw("未推送筑材网");
            }
        }else {
            vo.setIsPushZcw("未推送筑材网");
        }
    	//service.zcwDetail(entity);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @ApiOperation("供方推送报价信息接口")
    @RequestMapping(value = "/supplierPushSell", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> supplierPushSell(HttpServletRequest request,  @RequestParam(value = "file",required = false) MultipartFile file){
        Boolean b = service.supplierPushSell(request,file);
        return CommonResponse.success("推送报价信息成功！",b);
    }
    @ApiOperation("本地推送报价信息接口")
    @RequestMapping(value = "/localPushSell", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> localPushSell(@RequestBody Map<String,Object> params,  @RequestParam(value = "file",required = false) MultipartFile file){
        Boolean b = service.localPushSell(params,file);
        return CommonResponse.success("推送报价信息成功！",null);
    }

    @ApiOperation("发布接口")
    @RequestMapping(value = "/publishDocument", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffDocumentVO> publishDocument(@RequestParam Long id) throws Exception {
    	return CommonResponse.success("发布成功！",service.publishDocument(id));
    }
    @ApiOperation("答疑附件上传同步供方新增接口")
    @RequestMapping(value = "/uploadById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> uploadById(@RequestParam Long attachId,@RequestParam Long inviteId
            , String billFlag, Long billId) throws Exception {
    	return CommonResponse.success("同步成功！",service.uploadById(attachId,inviteId,billFlag,billId));
    }
    @ApiOperation("答疑附件删除同步供方接口")
    @RequestMapping(value = "/deleteFileById", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> deleteFileById(@RequestBody StuffDocumentVO stuffDocumentVO) throws Exception {
    	return CommonResponse.success("删除成功！",service.deleteFileById(stuffDocumentVO.getSourceId(),stuffDocumentVO.getFileNames()));
    }
    @ApiOperation("竞争性谈判等发布接口")
    @RequestMapping(value = "/publishManyDocument", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffDocumentVO> publish4Document(@RequestParam Long id) throws InvocationTargetException, IllegalAccessException {
        return CommonResponse.success("发布成功！",service.publishManyDocument(id));
    }
    @ApiOperation("根据供应商主键和方案主键查询详情接口")
    @RequestMapping(value = "/getSchemeDetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<StuffDocumentSellVO>> getSchemeDetail(@RequestBody StuffDocumentSellVO stuffDocumentSellVO) {
        List<StuffDocumentSellVO> list = service.getSchemeDetail(stuffDocumentSellVO);
    	return CommonResponse.success("查询成功！",list);
    }
    @ApiOperation("开标接口")
    @RequestMapping(value = "/bidDocument", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffDocumentVO> bidDocument(@RequestParam Long id) {
        StuffDocumentVO s = service.bidDocument(id);
        StuffDocumentVO stuffDocumentVO = service.queryDetail(id);
        return CommonResponse.success("开标成功！",stuffDocumentVO);
    }
    @ApiOperation("延长截止时间接口")
    @RequestMapping(value = "/extendDocument", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StuffDocumentVO> extendDocument(@RequestBody StuffDocumentRecordVO stuffDocumentRecordVO) {
    	return CommonResponse.success("延长截止时间！",service.extendDocument(stuffDocumentRecordVO));
    }
    @ApiOperation("剔除供应商")
    @RequestMapping(value = "/delSupplier", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse delSupplier(@RequestParam Long id) {
        return service.delSupplier(id);
    }
    @ApiOperation("查询供应商方案详情接口")
    @RequestMapping(value = "/getSupplierSchemeDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffDocumentSupplierSellVO> getSupplierSchemeDetail(Long supplierDetailId,Long documentId) {
        StuffDocumentSupplierSellVO stuffDocumentSupplierSellVO = service.getSupplierSchemeDetail(supplierDetailId,documentId);
    	return CommonResponse.success("开标成功！",stuffDocumentSupplierSellVO);
    }
    @ApiOperation("定标中查询供应商方案详情接口")
    @RequestMapping(value = "/getSupplierSchemeDetailDb", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffDocumentSupplierSellVO> getSupplierSchemeDetailDb(Long schemeId,Long documentId) {
        StuffDocumentSupplierSellVO stuffDocumentSupplierSellVO = service.getSupplierSchemeDetailDb(schemeId,documentId);
    	return CommonResponse.success("开标成功！",stuffDocumentSupplierSellVO);
    }
    @ApiOperation("洽商谈判查询供应商方案详情接口")
    @RequestMapping(value = "/getSupplierSchemeDetailTalk", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffDocumentSupplierSellVO> getSupplierSchemeDetailTalk(Long supplierDetailId, Long talkId) {
        StuffDocumentSupplierSellVO stuffDocumentSupplierSellVO = service.getSupplierSchemeDetailTalk(supplierDetailId,talkId);
    	return CommonResponse.success("开标成功！",stuffDocumentSupplierSellVO);
    }
    @ApiOperation("洽商谈判供应商方案详情接口(多轮显示)")
    @RequestMapping(value = "/getSupplierSchemeTalkDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffDocumentSupplierSellVO> getSupplierSchemeTalkDetail(Long supplierDetailId,Long talkId) {
        StuffDocumentSupplierSellVO stuffDocumentSupplierSellVO = service.getSupplierSchemeTalkDetail(supplierDetailId,talkId);
    	return CommonResponse.success("开标成功！",stuffDocumentSupplierSellVO);
    }
    @ApiOperation("招标公告下一步接口")
    @RequestMapping(value = "/saveDocument", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffDocumentVO> saveDocument(@RequestParam Long noticeId) {
        StuffDocumentVO stuffDocumentVO = service.saveDocument(noticeId);
    	return CommonResponse.success("保存或修改单据成功！",stuffDocumentVO);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffDocumentVO> queryDetail(@RequestParam Long id) {
        StuffDocumentVO vo = service.queryDetail(id);


        //显示是否推送筑材网
        StuffInviteEntity stuffInviteEntity = inviteService.selectById(vo.getInviteId());
        if (stuffInviteEntity != null && stuffInviteEntity.getIsPushZcw() != null){
            if(stuffInviteEntity.getIsPushZcw() == 1){
                vo.setIsPushZcw("已推送筑材网");
            }else {
                vo.setIsPushZcw("未推送筑材网");
            }
        }else {
            vo.setIsPushZcw("未推送筑材网");
        }

        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StuffDocumentVO> vos) {
        service.removeByIds(vos.stream().map(StuffDocumentVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<StuffDocumentVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<StuffDocumentEntity> page = service.queryPage(param,false);
        IPage<StuffDocumentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), StuffDocumentVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<StuffDocumentEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("StuffDocument-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refStuffDocumentData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<StuffDocumentVO>> refStuffDocumentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<StuffDocumentEntity> page = service.queryPage(param,false);
        IPage<StuffDocumentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), StuffDocumentVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @ApiOperation("竞争性谈判等下一步接口")
    @RequestMapping(value = "/saveManyDocument", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffDocumentVO> saveManyDocument(@RequestParam Long id) {
        StuffDocumentEntity stuffDocumentEntity = new StuffDocumentEntity();
        if(stuffDocumentEntity.getId() == null || stuffDocumentEntity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                stuffDocumentEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        StuffDocumentVO vo = service.saveManyDocument(id);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @ApiOperation("查询供应商主键ID")
    @RequestMapping(value = "/querySupplierId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffDocumentSupplierEntity> querySupplierId(@RequestParam Long supplierId,@RequestParam Long talkId) {
        StuffTalkEntity stuffTalkEntity = talkService.selectById(talkId);
        List<StuffDocumentSupplierEntity> list = documentSupplierService.list(new QueryWrapper<StuffDocumentSupplierEntity>().eq("supplier_id", supplierId).eq("document_id", stuffTalkEntity.getBillId()));
        return CommonResponse.success("保存或修改单据成功！",list.get(0));
    }
    @ApiOperation("根据税号查询供应商主键ID")
    @RequestMapping(value = "/querySupplierIdByTaxPayerIdentifier", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplierDTO> querySupplierIdByTaxPayerIdentifier(@RequestParam String taxPayerIdentifier) {
        SupplierDTO supplierDTO = service.querySupplierIdByTaxPayerIdentifier(taxPayerIdentifier);
        return CommonResponse.success("查询成功！",supplierDTO);
    }

    @ApiOperation("手机端检验是否进行过报价")
    @RequestMapping(value = "/checkDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> checkDetail(@RequestParam Long supplierId,
                                               @RequestParam Long documentId,
                                               @RequestParam String phone) {
        Boolean b = service.checkDetail(supplierId, documentId,phone);
        return CommonResponse.success("查询成功！",b);
    }

    @ApiOperation("根据供应商及招标文件查询报价明细")
    @RequestMapping(value = "/queryDetailSell", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<StuffDocumentSellVO>> queryDetailSell(@RequestParam Long supplierId,
                                                                     @RequestParam Long documentId,
                                                                     @RequestParam Long phone) {
        List<StuffDocumentSellVO> stuffDocumentSellVOS = service.queryDetailSell(supplierId, documentId,phone);
        return CommonResponse.success("查询成功！",stuffDocumentSellVOS);
    }


    @ApiOperation("检查专家数量")
    @RequestMapping(value = "/checkExpertNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> checkExpertNum(@RequestParam Long documentId){
        CommonResponse<Boolean> response = service.checkExpertNum(documentId);
        return response;
    }

    @ApiOperation("手机询价同步非库供应商")
    @RequestMapping(value = "/synSupplier", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> synSupplier(@RequestParam Long documentId){
        CommonResponse<Boolean> response = service.synSupplier(documentId);
        CommonResponse<Boolean> booleanCommonResponse = service.synZcwSupplier(documentId);
        if(response.getCode() == 0 && booleanCommonResponse.getCode() == 0){
            return booleanCommonResponse;
        }else {
            if (response.getCode() == 1){
                return response;
            }else {
                return booleanCommonResponse;
            }
        }

    }
}
