package com.ejianc.business.tender.sub.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.stuff.bean.StuffDocumentSellEntity;
import com.ejianc.business.tender.stuff.bean.StuffInviteDetailRecordEntity;
import com.ejianc.business.tender.sub.bean.SubAdviceEntity;
import com.ejianc.business.tender.sub.bean.SubPicketageSupplierEntity;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.service.*;
import com.ejianc.business.tender.sub.vo.SubBidVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.SubleadersVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.IShareSubleadersApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("subPicketage")
public class SubPicketageBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private ISubPicketageService subPicketageService;
	@Autowired
	private ISubBidService subBidService;
	@Autowired
	private ISubWinnoticeService subWinnoticeService;
	@Autowired
	private ISubInviteService subInviteService;
	@Autowired
	private ISubBidDetailService subBidDetailService;
	@Autowired
	private ISubDocumentSellService subDocumentSellService;
	@Autowired
	private ISubDocumentService subDocumentService;
	@Autowired
	private ISubBidSupplierService subBidSupplierService;
	@Autowired
	private ISubDocumentSupplierService subDocumentSupplierService;
	@Autowired
	private ISubAdviceService subAdviceService;
	@Autowired
	private IProcessService processService;
	@Autowired
	private IShareSupplierApi shareSupplierApi;
	@Autowired
	private ISubPicketageRefsupplierService subPicketageRefsupplierService;
	@Autowired
	private ISubPicketageSupplierService subPicketageSupplierService;

	@Autowired
	private ISubInviteDetailRecordService subInviteDetailRecordService;

	@Autowired
	private IShareSubleadersApi shareSubleadersApi;


	@Value("${gysUrl.updateTimeUrl}")
	private String updateTimeUrl;

	@Value("${gysUrl.winbidSavesUrl}")
	private String winbidSavesUrl;
	private static final String BILL_CODE = "invite-bid-code";//此处需要根据实际修改
	private org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IProjectPoolApi projectPoolApi;
	@Autowired
	private ISubBatPlanService subBatPlanService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("billId"+billId);
		SubBidVO subBidVO = subBidService.saveBid(billId);

		subBidService.publishBid(subBidVO);

		//处理参照表,只处理项目线的数据
		//查询出所有定标的数据
		SubPicketageEntity subPicketageEntity = subPicketageService.selectById(billId);
		SubInviteEntity subInviteEntity = subInviteService.selectById(subPicketageEntity.getInviteId());



		// 完成采购计划
		QueryParam stuffInviteDetailQueryParam = new QueryParam();
		stuffInviteDetailQueryParam.getParams().put("invite_id", new Parameter(QueryParam.EQ, subInviteEntity.getId()));
		List<SubInviteDetailRecordEntity> stuffInviteDetailEntityList = subInviteDetailRecordService.queryList(stuffInviteDetailQueryParam);
		// 获取采购计划ID
		if (CollectionUtils.isNotEmpty(stuffInviteDetailEntityList)) {
			List<String> planIdList = stuffInviteDetailEntityList.stream()
					.map(SubInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct()
					.collect(Collectors.toList());
			// 释放采购计划
			//CommonResponse<String> response = batPlanApi.updateBatPlanQuote(planIdList, BatPlanEnum.PLAN_STATE_OVER.getPlanState());
			subBatPlanService.updateBatPlanByQuoteType(planIdList, BatPlanEnum.PLAN_STATE_OVER.getPlanState(),0);
		}


		/**生成中标结果参照数据===开始*/

		//获取招标文件环节数据
		LambdaQueryWrapper<SubDocumentEntity> docWrapper = Wrappers.lambdaQuery();
		docWrapper.eq(SubDocumentEntity::getInviteId,subPicketageEntity.getInviteId());
		SubDocumentEntity subDocument = subDocumentService.getOne(docWrapper);
//		if (subInviteEntity.getPurchaseType().equals(0)){

		//获取中标的供应商子表数据
		LambdaQueryWrapper<SubDocumentSellEntity> sellWrapper = Wrappers.lambdaQuery();
		sellWrapper.eq(SubDocumentSellEntity::getDocumentId,subPicketageEntity.getDocumentId());
		sellWrapper.eq(SubDocumentSellEntity::getTenderFlag,1);//是否中标,1-是
		List<SubDocumentSellEntity> SubDocumentSellList = subDocumentSellService.list(sellWrapper);
		//项目招标
		//改造-0905
		Map<Long, ProjectPoolSetVO> proMap = new HashMap<>();
		//if (subInviteEntity.getPurchaseType().equals(0)){
		//获取中标的项目信息
			List<Long> projectPks = SubDocumentSellList.stream().map(SubDocumentSellEntity::getProjectId).collect(Collectors.toList());
			CommonResponse<JSONArray> jsonArrayCommonResponse = projectPoolApi.queryProjectByIds(projectPks);

			if (jsonArrayCommonResponse.isSuccess()){
				JSONArray data = jsonArrayCommonResponse.getData();
				List<ProjectPoolSetVO> projectRegisterVOS = data.toJavaList(ProjectPoolSetVO.class);
				proMap = projectRegisterVOS.stream().collect(Collectors.toMap(ProjectPoolSetVO::getId, Function.identity()));
			}
		//}
		Map<String, List<SubDocumentSellEntity>> dataMap = new HashMap<>();
		for (SubDocumentSellEntity SubDocumentSellEntity : SubDocumentSellList){
			//改造-0905
			//if (subInviteEntity.getPurchaseType().equals(0)){
				ProjectPoolSetVO projectPoolSetVO = proMap.get(SubDocumentSellEntity.getProjectId());
				if (projectPoolSetVO != null){
					SubDocumentSellEntity.setOrgId(projectPoolSetVO.getProjectDepartmentId());
					SubDocumentSellEntity.setOrgName(projectPoolSetVO.getProjectDepartmentName());
				}
			//}
			String s = null;
			//if (subInviteEntity.getPurchaseType().equals(0)){
				s = SubDocumentSellEntity.getProjectId().toString() + SubDocumentSellEntity.getSupplierId()
						.toString();
//			}
//			if (subInviteEntity.getPurchaseType().equals(1)){
//				s = SubDocumentSellEntity.getSupplierId()
//						.toString();
//			}
			if (dataMap.containsKey(s)){
				List<SubDocumentSellEntity> SubDocumentSellEntityList = dataMap.get(s);
				SubDocumentSellEntityList.add(SubDocumentSellEntity);
				dataMap.put(s,SubDocumentSellEntityList);
			}else {
				List<SubDocumentSellEntity> SubDocumentSellEntities = new ArrayList<>();
				SubDocumentSellEntities.add(SubDocumentSellEntity);
				dataMap.put(s,SubDocumentSellEntities);
			}
		}
		//处理<ProjectId+SupplierId,中标的供应商子表数据>
		List<SubPicketageRefsupplierEntity> SubPicketageRefsupplierEntities = new ArrayList<>();
		dataMap.forEach((key,value) -> {
			SubPicketageRefsupplierEntity SubPicketageRefsupplierEntity = new SubPicketageRefsupplierEntity();
			SubDocumentSellEntity SubSellEntity = value.stream().findFirst().get();

			SubPicketageRefsupplierEntity.setSupplierId(SubSellEntity.getSupplierId());
			SubPicketageRefsupplierEntity.setSupplierName(SubSellEntity.getSupplierName());

			SubPicketageRefsupplierEntity.setProjectId(SubSellEntity.getProjectId());
			SubPicketageRefsupplierEntity.setProjectName(SubSellEntity.getProjectName());
			SubPicketageRefsupplierEntity.setProjectCode(subInviteEntity.getProjectCode());
			SubPicketageRefsupplierEntity.setPicketageId(billId);
			SubPicketageRefsupplierEntity.setOccupyFlag(0);

			SupplierDTO supplierVO = shareSupplierApi.queryById(SubSellEntity.getSupplierId()).getData();
			if (supplierVO == null){
				//分包负责人id查询详情
				CommonResponse<SubleadersVO> subleadersVOCommonResponse = shareSubleadersApi.querySupplierByLeaderId(SubSellEntity.getSupplierId());
				if (subleadersVOCommonResponse.getCode()== 0){
					//如果是分包负责人，则将供应商名称id和name字段重新赋值
					//且在temeid、teamcode、teamname字段赋值上班组的信息
					SubPicketageRefsupplierEntity.setSupplierId(subleadersVOCommonResponse.getData().getPid());
					SubPicketageRefsupplierEntity.setSupplierName(subleadersVOCommonResponse.getData().getSupplierName());
					SubPicketageRefsupplierEntity.setTeamId(SubSellEntity.getSupplierId());
					SubPicketageRefsupplierEntity.setTeamCode(subleadersVOCommonResponse.getData().getIdNum());
					SubPicketageRefsupplierEntity.setTeamName(SubSellEntity.getSupplierName());
					//供应商的租户id赋值分包负责人的租户id
					SubPicketageRefsupplierEntity.setSupplierTenantId(subleadersVOCommonResponse.getData().getEjcTenantId());
				}
			}else {
				SubPicketageRefsupplierEntity.setSupplierTenantId(supplierVO.getTenant());
			}

			SubPicketageRefsupplierEntity.setPicketageName(subPicketageEntity.getPicketageName());
			SubPicketageRefsupplierEntity.setPicketageDate(new Date());
			//改造-0905
			//if (subInviteEntity.getPurchaseType().equals(0)){
				SubPicketageRefsupplierEntity.setOrgId(SubSellEntity.getOrgId());
				SubPicketageRefsupplierEntity.setOrgName(SubSellEntity.getOrgName());
//			}
//			if (subInviteEntity.getPurchaseType().equals(1)){
//				SubPicketageRefsupplierEntity.setOrgId(subInviteEntity.getOrgId());
//				SubPicketageRefsupplierEntity.setOrgName(subInviteEntity.getOrgName());
//			}
			SubPicketageRefsupplierEntity.setParentOrgId(subInviteEntity.getParentOrgId());
			SubPicketageRefsupplierEntity.setParentOrgName(subInviteEntity.getParentOrgName());
			SubPicketageRefsupplierEntity.setUnitId(subInviteEntity.getUnitId());
			SubPicketageRefsupplierEntity.setUnitName(subInviteEntity.getUnitName());
			SubPicketageRefsupplierEntity.setProjectQualificationId(subInviteEntity.getProjectQualificationId());
			SubPicketageRefsupplierEntity.setProjectQualification(subInviteEntity.getProjectQualification());
			SubPicketageRefsupplierEntity.setProjectLinkName(subDocument.getProjectLinkName());
			SubPicketageRefsupplierEntity.setProjectLinkPhone(subDocument.getProjectLinkPhone());
			SubPicketageRefsupplierEntity.setPicketageFlag(0);
			SubPicketageRefsupplierEntity.setSignStatus(TenderSignStatusEnum.未签订.getCode());
			SubPicketageRefsupplierEntity.setPurchaseType(subInviteEntity.getPurchaseType());
			SubPicketageRefsupplierEntity.setSubContent(subInviteEntity.getSubContent());//分包类别-》合同类别
			SubPicketageRefsupplierEntity.setSubContentName(subInviteEntity.getSubContentName());//分包类别-》合同类别名称

			BigDecimal tenderMoney = BigDecimal.ZERO;
			BigDecimal tenderMoneyTax = BigDecimal.ZERO;
			for (SubDocumentSellEntity SubDocumentSellEntity : value){
				tenderMoney = tenderMoney.add(SubDocumentSellEntity.getTenderMoney());
				tenderMoneyTax = tenderMoneyTax.add(SubDocumentSellEntity.getTenderMoneyTax());
			}
			SubPicketageRefsupplierEntity.setMoney(tenderMoney.setScale(2, BigDecimal.ROUND_HALF_UP));
			SubPicketageRefsupplierEntity.setMoneyTax(tenderMoneyTax.setScale(2, BigDecimal.ROUND_HALF_UP));
			SubPicketageRefsupplierEntities.add(SubPicketageRefsupplierEntity);
		});
		subPicketageRefsupplierService.saveBatch(SubPicketageRefsupplierEntities);


		/**生成中标结果参照数据===结束*/
//		}
//生成中标通知书类表数据
		List<SubPicketageSupplierEntity> picketageSupplierList = subPicketageEntity.getPicketageSupplierList();
		List<SubAdviceEntity> subAdviceList = BeanMapper.mapList(picketageSupplierList, SubAdviceEntity.class);
		for (SubAdviceEntity subAdviceEntity : subAdviceList){
			subAdviceEntity.setTitleName(subInviteEntity.getTenderName());
			subAdviceEntity.setUnitId(subInviteEntity.getUnitId());
			subAdviceEntity.setUnitName(subInviteEntity.getUnitName());
			subAdviceEntity.setProjectId(subInviteEntity.getProjectId());
			subAdviceEntity.setProjectName(subInviteEntity.getProjectName());
			subAdviceEntity.setOrgId(subInviteEntity.getOrgId());
			subAdviceEntity.setOrgName(subInviteEntity.getOrgName());
			subAdviceEntity.setParentOrgId(subInviteEntity.getParentOrgId());
			subAdviceEntity.setParentOrgName(subInviteEntity.getParentOrgName());
			subAdviceEntity.setParentOrgName(subInviteEntity.getParentOrgName());
			subAdviceEntity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(subInviteEntity.getTenderType()).getDescription());
			subAdviceEntity.setLineTypeName(CommonUtils.getTypeName(1));
			subAdviceEntity.setPurchaseType(subInviteEntity.getPurchaseType());
			subAdviceEntity.setScFlag(1);
			subAdviceEntity.setSendFlag(1);
			subAdviceEntity.setSignFlag(0);
			subAdviceEntity.setId(null);
			subAdviceEntity.setInviteId(subInviteEntity.getId());
		}
		subAdviceService.saveBatch(subAdviceList);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该功能不支持！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
