package com.ejianc.business.tender.other.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.common.vo.SupplyFileVo;
import com.ejianc.business.tender.other.bean.*;
import com.ejianc.business.tender.other.mapper.OtherDocumentMapper;
import com.ejianc.business.tender.other.mapper.OtherDocumentSellMapper;
import com.ejianc.business.tender.other.mapper.OtherDocumentSupplierDetailMapper;
import com.ejianc.business.tender.other.mapper.OtherDocumentSupplierMapper;
import com.ejianc.business.tender.other.service.*;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.other.vo.*;
import com.ejianc.business.tender.sub.bean.SubDocumentDetailEntity;
import com.ejianc.business.tender.util.SendMsgUtils;
import com.ejianc.business.tender.util.ThirdSystemUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 招标文件主表
 *
 * @author generator
 *
 */
@Service("otherDocumentService")
public class OtherDocumentServiceImpl extends BaseServiceImpl<OtherDocumentMapper, OtherDocumentEntity> implements IOtherDocumentService {
    @Autowired
    private IOtherDocumentSupplierService otherDocumentSupplierService;
    @Autowired
    private OtherDocumentSupplierDetailMapper supplierDetailMapper;
    @Autowired
    private OtherDocumentSupplierMapper supplierMapper;
    @Autowired
    private IOtherDocumentSchemeService otherDocumentSchemeService;
    @Autowired
    private IOtherDocumentSellService otherDocumentSellService;
    @Autowired
    private OtherDocumentSellMapper otherDocumentSellMapper;
    @Autowired
    private IOtherDocumentRecordService otherDocumentRecordService;
    @Autowired
    private IOtherDocumentDetailService otherDocumentDetailService;
    @Autowired
    private IOtherTalkService otherTalkService;
    @Autowired
    private IOtherTalkRecordService otherTalkRecordService;
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private IOtherDocumentExpertService documentExpertService;
    @Autowired
    private IOtherDocumentSupplierDetailService supplierDetailService;
    @Autowired
    private IOtherDocumentSupplierDetailService documentSupplierDetailService;
    @Autowired
    private IOtherDocumentService service;
    @Autowired
    private IProcessService processService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private IOtherNoticeService otherNoticeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value("${gysUrl.delFileUrl}")
    private String delFileUrl;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Value("${gysUrl.saveWjUrl}")
    private String saveWjUrl;
    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value("${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value("${gysUrl.updateSupStatusUrl}")
    private String updateSupStatusUrl;
    @Value("${gysUrl.addFileUrl}")
    private String addFileUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000006";
    private static final String BILL_TYPE = "BT211119000000003";
    private static final String SOURCE_TYPE = "documentBill02";

    private final Logger logger = LoggerFactory.getLogger(getClass());
    private static final String BILL_CODE = "invite-document-code";//此处需要根据实际修改

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private IOtherNoticeSupplierService otherNoticeSupplierService;


    @Transactional
    @Override
    public OtherDocumentVO publishDocument(Long id) {
        //更新发布状态
        OtherDocumentEntity otherDocumentEntity = super.selectById(id);
        otherDocumentEntity.setPublishFlag(0);
        super.updateById(otherDocumentEntity);

        //推送供应商
        OtherDocumentSupplierTbVO otherDocumentSupplierTbVO = new OtherDocumentSupplierTbVO();
        otherDocumentSupplierTbVO.setSourceId(otherDocumentEntity.getInviteId().toString());
        otherDocumentSupplierTbVO.setSourceType("郑州一建招标文件");
        otherDocumentSupplierTbVO.setNoticeType(1);
        otherDocumentSupplierTbVO.setProjectLinkName(otherDocumentEntity.getProjectLinkName());
        otherDocumentSupplierTbVO.setProjectLinkPhone(otherDocumentEntity.getProjectLinkPhone());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(otherDocumentEntity.getOfferStartTime());
        otherDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(otherDocumentEntity.getOfferEndTime());
        otherDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        otherDocumentSupplierTbVO.setContent(otherDocumentEntity.getDocumentContent());
        otherDocumentSupplierTbVO.setBrandFlag(otherDocumentEntity.getBrandFlag());
        otherDocumentSupplierTbVO.setMemo(otherDocumentEntity.getMemo());
        otherDocumentSupplierTbVO.setTenderName(otherDocumentEntity.getDocumentName());
        CommonResponse<String> stringCommonResponse = proSupplierApi.getEjcCloudSystemCode();
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("招标文件获取systemId失败" + stringCommonResponse.getMsg());
        }
        otherDocumentSupplierTbVO.setSystemId(stringCommonResponse.getData());

        // 处理租赁方式
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(otherDocumentEntity.getInviteId());
        otherDocumentSupplierTbVO.setRentType(otherInviteEntity.getRentType());

        //处理附件
        //查询招标文件
        CommonResponse<List<AttachmentVO>> zbwjFile = attachmentApi.queryListBySourceId(otherDocumentEntity.getId(), BILL_TYPE, SOURCE_TYPE, null);
        String zbwjIds = null;
        List<Long> zbwjAttachIdList = new ArrayList<>();
        if(zbwjFile.isSuccess()){
            List<AttachmentVO> data = zbwjFile.getData();
            zbwjAttachIdList = data.stream().map(AttachmentVO::getId).collect(Collectors.toList());
            zbwjIds = zbwjAttachIdList.stream().map(p -> String.valueOf(p)).collect(Collectors.joining(","));
        }

        Map<String, String> fileMap = new HashMap<>();
        fileMap.put("fileIds",zbwjIds);
        String zbwjFileByte = null;
        try {
            zbwjFileByte = ReferHttpClientUtils.getAndHeader(BASE_HOST + "ejc-file-web/attachment/batchdownflow", fileMap);
        } catch (GeneralSecurityException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        //招标文件stream处理
        JSONObject jsonZbwj = JSON.parseObject(zbwjFileByte);
        Map<String, String> zbwjParam = JSONObject.parseObject(jsonZbwj.toJSONString(), new TypeReference<Map<String, String>>(){});
        String dataZbwj = zbwjParam.get("data");
        JSONObject zbwListJson = JSON.parseObject(dataZbwj);
        Map<String, byte[]> zbwjMap = JSONObject.parseObject(zbwListJson.toJSONString(), new TypeReference<Map<String, byte[]>>(){});
        Map<String, InputStream> streamMap = new HashMap<>();
        zbwjMap.forEach((key,value) ->{
            streamMap.put(key,new ByteArrayInputStream(value));
        });

        String stringFb = JSONObject.toJSONString(otherDocumentSupplierTbVO);
        Map<String,String> params = new HashMap<>();
        params.put("noticeEntity", stringFb);
        Map<String, Map<String, InputStream>> files = null;
        if (!streamMap.isEmpty()){
            files = new HashMap<>();
            files.put("file",streamMap);
        }

        //推送供方
        CommonResponse<String> stringCommonResponses = systemDataPushService.exchangeDataAndFilesWithUniversal(saveWjUrl,params,files, appId, appSecret, appHost);
        if(!stringCommonResponses.isSuccess()) {
            throw new BusinessException("招标文件发布推送供方接口报错" + stringCommonResponses.getMsg());
        }

        OtherDocumentVO otherDocumentVO = queryDetail(id);
        return otherDocumentVO;
    }




    @Override
    public OtherDocumentVO bidDocument(Long id) {
        //更新开标状态
        OtherDocumentEntity otherDocumentEntity = super.selectById(id);
        otherDocumentEntity.setBidFlag(0);
        otherDocumentEntity.setBidTime(new Date());
        super.updateById(otherDocumentEntity);
        OtherDocumentVO otherDocumentVO = queryDetail(id);
//        开标之后给专家发送微信+内部消息通知：xx专家您好，XXX（项目名称）已开标，后续的评标开始时间我们会以短信+消息
        List<OtherDocumentExpertEntity> entityList = documentExpertService.list(new QueryWrapper<OtherDocumentExpertEntity>().eq("document_id", otherDocumentVO.getId()).eq("dr", 0));
        for (OtherDocumentExpertEntity entity : entityList) {
            //审批通过给专家发内部消息
            List<String> messageType = new ArrayList<>();
            //系统消息
            messageType.add("sys");
            //微信消息
            //messageType.add("weChat");
            List<String> sender = new ArrayList<>();
            sender.add(entity.getExpertId() + "");
            String name = otherDocumentVO.getPurchaseType()==0?otherDocumentVO.getProjectName():otherDocumentVO.getOrgName();
            logger.info("发送信息给专家:>----------" + sender);
            String subject = entity.getExpertName() + "专家您好，" +name+ "已开标，后续的评标开始时间我们会以短信+消息的形式通知您，请注意查看，避免遗忘";
            String content = entity.getExpertName() + "专家您好，" +name+ "已开标，后续的评标开始时间我们会以短信+消息的形式通知您，请注意查看，避免遗忘";
            logger.info("发送信息的内容:>----------" + content);
            new SendMsgUtils().sendSysMsg(sender, subject, content, pushMessageApi);
        }
        return otherDocumentVO;
    }

    @Override
    public OtherDocumentVO queryDetail(Long id) {
        return queryDocDetail(id,0);
    }
    @Override
    public OtherDocumentVO queryDetail1(Long id, Integer num) {
        return queryDocDetail(id,num);
    }

    @Override
    public OtherDocumentVO queryDetailNum(Long id) {
        OtherDocumentSchemeEntity otherDocumentSchemeEntity = otherDocumentSchemeService.list(new QueryWrapper<OtherDocumentSchemeEntity>().eq("document_id", id).orderByDesc("talk_num")).get(0);
        return queryDocDetail(id,otherDocumentSchemeEntity.getTalkNum());
    }

    @Transactional
    @Override
    public Boolean supplierPushSell(HttpServletRequest request, MultipartFile file) {

        logger.info("进入报价接口request-{},file-{}", request, file);
        String notice = request.getParameter("bjNoticeVO");
        logger.info("实体信息-{}",notice);
        OtherSupplierSellVO pushVO = JSON.parseObject(notice, new TypeReference<OtherSupplierSellVO>() { });

        //处理业务数据
        //noticeType,类型(0-公告，1-文件,2-询价,3-竞争性,4-洽商谈判
        //转换轮数
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(Long.parseLong(pushVO.getSourceId()));
        Integer tenderStage = otherInviteEntity.getTenderStage();
        //招标阶段(3-招标文件,6-竞争性谈判文件,7-洽商谈判,8-单一来源文件,9-紧急文件,10-询价公告
        Integer talkNum = null;
        if (tenderStage == 3 || tenderStage == 6 || tenderStage == 8 || tenderStage == 9 || tenderStage == 10){
            talkNum = 0;
        }
        if (tenderStage == 7){
            //查询轮数
            LambdaQueryWrapper<OtherTalkEntity> lambdaTalk = Wrappers.<OtherTalkEntity>lambdaQuery();
            lambdaTalk.eq(OtherTalkEntity::getInviteId, Long.parseLong(pushVO.getSourceId()));
            OtherTalkEntity otherTalkEntity = otherTalkService.getOne(lambdaTalk);
            talkNum = otherTalkEntity.getTalkNum();
        }

        //转换
        long sourceSupplierId = Long.parseLong(pushVO.getSourceSupplierId());
        SupplierDTO supplierVO = shareSupplierApi.queryById(sourceSupplierId).getData();

        //处理供应商信息
        Long inviteId = Long.parseLong(pushVO.getSourceId());
        LambdaQueryWrapper<OtherDocumentEntity> lambdaDocument = Wrappers.<OtherDocumentEntity>lambdaQuery();
        lambdaDocument.eq(OtherDocumentEntity::getInviteId, inviteId);
        OtherDocumentEntity otherDocumentEntity = baseMapper.selectOne(lambdaDocument);
        //先删后增
        //根据供应商主键和招标文件主键查询供应商信息,判断新增和修改
        LambdaQueryWrapper<OtherDocumentSupplierEntity> lambdaSupplier = Wrappers.<OtherDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(OtherDocumentSupplierEntity::getSupplierId, sourceSupplierId);
        lambdaSupplier.eq(OtherDocumentSupplierEntity::getDocumentId,otherDocumentEntity.getId());
        lambdaSupplier.eq(OtherDocumentSupplierEntity::getTalkNum,talkNum);
        OtherDocumentSupplierEntity otherDocumentSupplierEntity = otherDocumentSupplierService.getOne(lambdaSupplier);

        Long documentSupplierId = null;
        if (otherDocumentSupplierEntity != null){
            //更新供应商信息
            otherDocumentSupplierEntity.setOfferTime(new Date());
            otherDocumentSupplierEntity.setLinkName(pushVO.getEmployeeName());
            otherDocumentSupplierEntity.setLinkMobile(pushVO.getEmployeeMobile());
            otherDocumentSupplierEntity.setTaxMemo(pushVO.getInvoiceNote());
            otherDocumentSupplierService.updateById(otherDocumentSupplierEntity);
            documentSupplierId = otherDocumentSupplierEntity.getId();

            //删除方案信息
            LambdaQueryWrapper<OtherDocumentSchemeEntity> lambdaScheme = Wrappers.<OtherDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(OtherDocumentSchemeEntity::getDocumentSupplierId,otherDocumentSupplierEntity.getId() );
            otherDocumentSchemeService.remove(lambdaScheme);
        }
        if (otherDocumentSupplierEntity == null){
            //新增供应商信息
            OtherDocumentSupplierEntity otherDocumentSupplierEntityAdd = new OtherDocumentSupplierEntity();
            otherDocumentSupplierEntityAdd.setSupplierName(supplierVO.getName());
            otherDocumentSupplierEntityAdd.setSupplierId(sourceSupplierId);
            otherDocumentSupplierEntityAdd.setSupplierTenantId(supplierVO.getTenant());
            otherDocumentSupplierEntityAdd.setLinkName(pushVO.getEmployeeName());
            otherDocumentSupplierEntityAdd.setLinkMobile(pushVO.getEmployeeMobile());
            otherDocumentSupplierEntityAdd.setTaxMemo(pushVO.getInvoiceNote());
            otherDocumentSupplierEntityAdd.setOfferTime(new Date());
            otherDocumentSupplierEntityAdd.setDocumentId(otherDocumentEntity.getId());
            otherDocumentSupplierEntityAdd.setTalkNum(talkNum);
            otherDocumentSupplierService.save(otherDocumentSupplierEntityAdd);
            documentSupplierId = otherDocumentSupplierEntityAdd.getId();
        }

        //处理方案信息
        List<OtherSupplierSellSchemeVO> schemeList = pushVO.getOtherSchemeList();
        List<OtherDocumentSchemeEntity> otherDocumentSchemeEntityArrayList = new ArrayList<>();
        //所有报价详情信息
        List<OtherDocumentSellVO> otherDocumentSellVOList = new ArrayList<>();
        for (OtherSupplierSellSchemeVO supplierSellSchemeVO : schemeList){
            OtherDocumentSchemeEntity otherDocumentSchemeEntity = new OtherDocumentSchemeEntity();
            otherDocumentSchemeEntity.setDocumentSupplierId(documentSupplierId);
            otherDocumentSchemeEntity.setDocumentId(otherDocumentEntity.getId());
            otherDocumentSchemeEntity.setSupplierId(sourceSupplierId);
            otherDocumentSchemeEntity.setSupplierTenantId(supplierVO.getTenant());
            otherDocumentSchemeEntity.setSupplierName(supplierVO.getName());
            otherDocumentSchemeEntity.setSchemeName(supplierSellSchemeVO.getSchemeName());
            otherDocumentSchemeEntity.setMoney(supplierSellSchemeVO.getMoney());
            otherDocumentSchemeEntity.setMoneyTax(supplierSellSchemeVO.getMoneyTax());
            otherDocumentSchemeEntity.setTalkNum(talkNum);
            otherDocumentSchemeEntity.setId(IdWorker.getId());
            otherDocumentSchemeEntity.setPassFlag(1);
            otherDocumentSchemeEntityArrayList.add(otherDocumentSchemeEntity);

            //处理报价详情与方案的关联关系
            List<OtherSupplierSellSchemeDetailVO> schemeDetailList = supplierSellSchemeVO.getOtherSchemeDetailList();
            LambdaQueryWrapper<OtherDocumentDetailEntity> lambdaDetail = Wrappers.<OtherDocumentDetailEntity>lambdaQuery();
            lambdaDetail.eq(OtherDocumentDetailEntity::getDocumentId, otherDocumentEntity.getId());

            List<OtherDocumentDetailEntity> otherDocumentDetailList = otherDocumentDetailService.list(lambdaDetail);

            for (OtherSupplierSellSchemeDetailVO supplierSellSchemeDetailVO : schemeDetailList){
                OtherDocumentSellVO otherDocumentSellVO = new OtherDocumentSellVO();
                for (OtherDocumentDetailEntity otherDocumentDetailEntity : otherDocumentDetailList) {
                    if (otherDocumentDetailEntity.getId().equals(Long.parseLong(supplierSellSchemeDetailVO.getSourceDetailId()))){
                        otherDocumentSellVO.setProjectId(otherDocumentDetailEntity.getDetailProjectId());
                        otherDocumentSellVO.setProjectName(otherDocumentDetailEntity.getDetailProjectName());
                    }

                }

                otherDocumentSellVO.setSchemeId(otherDocumentSchemeEntity.getId());
                otherDocumentSellVO.setDocumentId(otherDocumentEntity.getId());
                otherDocumentSellVO.setSupplierId(sourceSupplierId);
                otherDocumentSellVO.setSupplierTenantId(supplierVO.getTenant());
                otherDocumentSellVO.setSupplierName(supplierVO.getName());
//                otherDocumentSellVO.setMaterialId(Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialId()));
                otherDocumentSellVO.setDetailId(Long.parseLong(supplierSellSchemeDetailVO.getSourceDetailId()));
                otherDocumentSellVO.setMaterialName(supplierSellSchemeDetailVO.getMaterialName());
                otherDocumentSellVO.setMaterialCode(supplierSellSchemeDetailVO.getMaterialCode());
//                otherDocumentSellVO.setMaterialTypeId(Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialTypeId()));
                otherDocumentSellVO.setMaterialTypeName(supplierSellSchemeDetailVO.getMaterialTypeName());
                otherDocumentSellVO.setUnit(supplierSellSchemeDetailVO.getUnit());
                otherDocumentSellVO.setSpec(supplierSellSchemeDetailVO.getSpec());
                otherDocumentSellVO.setNum(supplierSellSchemeDetailVO.getNum());
                otherDocumentSellVO.setRate(supplierSellSchemeDetailVO.getRate());
                otherDocumentSellVO.setDetailRate(supplierSellSchemeDetailVO.getDetailRate());
                otherDocumentSellVO.setPrice(supplierSellSchemeDetailVO.getPrice());
                otherDocumentSellVO.setPriceTax(supplierSellSchemeDetailVO.getPriceTax());
                otherDocumentSellVO.setMoney(supplierSellSchemeDetailVO.getMoney());
                otherDocumentSellVO.setMoneyTax(supplierSellSchemeDetailVO.getMoneyTax());
                otherDocumentSellVO.setSellTax(supplierSellSchemeDetailVO.getTax());
                otherDocumentSellVO.setSchemeName(supplierSellSchemeVO.getSchemeName());
                otherDocumentSellVO.setMaterialBrand(supplierSellSchemeDetailVO.getBrand());
                otherDocumentSellVO.setBrand(supplierSellSchemeDetailVO.getSupplierBrand());
                otherDocumentSellVO.setMemo(supplierSellSchemeDetailVO.getSupplierMemo());
                otherDocumentSellVO.setMaterialMemo(supplierSellSchemeDetailVO.getMemo());
                otherDocumentSellVO.setCalculateType(supplierSellSchemeDetailVO.getCalculateType());
                otherDocumentSellVO.setPlanDay(supplierSellSchemeDetailVO.getPlanDay());
                otherDocumentSellVO.setPlanEnterDate(supplierSellSchemeDetailVO.getPlanEnterDate());
                otherDocumentSellVO.setPlanLeaveDate(supplierSellSchemeDetailVO.getPlanLeaveDate());
                otherDocumentSellVO.setReferFlag(2);
                otherDocumentSellVO.setPassFlag(1);
                otherDocumentSellVO.setTalkNum(talkNum);

                otherDocumentSellVOList.add(otherDocumentSellVO);

            }

        }
        //新增方案
        otherDocumentSchemeService.saveBatch(otherDocumentSchemeEntityArrayList);

        //处理报价详情信息
        //删除报价信息
        LambdaQueryWrapper<OtherDocumentSellEntity> lambdaSell = Wrappers.<OtherDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(OtherDocumentSellEntity::getSupplierId,sourceSupplierId);
        lambdaSell.eq(OtherDocumentSellEntity::getTalkNum,talkNum);
        lambdaSell.eq(OtherDocumentSellEntity::getDocumentId,otherDocumentEntity.getId());
        otherDocumentSellService.remove(lambdaSell);

        //处理报价详情信息
        LambdaQueryWrapper<OtherDocumentDetailEntity> lambdaDetail = Wrappers.<OtherDocumentDetailEntity>lambdaQuery();
        lambdaDetail.eq(OtherDocumentDetailEntity::getDocumentId,otherDocumentEntity.getId());
        List<OtherDocumentSellEntity> otherDocumentSellEntities = BeanMapper.mapList(otherDocumentSellVOList, OtherDocumentSellEntity.class);
        //新增报价信息
        otherDocumentSellService.saveBatch(otherDocumentSellEntities);

        //先删除附件
        if(documentSupplierId != null){
            logger.info("删除供应商[{}]附件信息，billType[{}]，sourceType[supplierFileType]",documentSupplierId, BILL_SUPPLIER_TYPE);
//            CommonResponse<String> deleteRtn = attachmentApi.deleteFileByParam(documentSupplierId, BILL_SUPPLIER_TYPE,"supplierFileType");
            CommonResponse<List<AttachmentVO>> attachmentResponse = attachmentApi.queryListBySourceId(documentSupplierId,BILL_SUPPLIER_TYPE,"supplierFileType",null);
            List<AttachmentVO> attachmentVOList = attachmentResponse.getData();
            if (CollectionUtils.isNotEmpty(attachmentVOList)){
                logger.info("开始删除附件信息-----");
                String ids = attachmentVOList.stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
                CommonResponse<String> deleteResponse = attachmentApi.delete(ids);
                logger.info("删除文件结束，删除结果：{}",deleteResponse.getData());
            }
        }
        //处理附件
//        if(file != null){
//            logger.info(request+"报价文件名称- {}",file.getOriginalFilename());
//            logger.info(request+"供应商表主键- {}",documentSupplierId);
//            Boolean upFlag = new ThirdSystemUtils().upFile(BASE_HOST,"supplierFileType",Long.toString(documentSupplierId),BILL_SUPPLIER_TYPE,file,request);
//            logger.info(request+"文件上传结果-{}",upFlag);
//        }
        List<SupplyFileVo> pzList = pushVO.getSupplyFileList();
        logger.info("报名文件:{}", JSONObject.toJSONString(pzList));
        if(CollectionUtils.isNotEmpty(pzList)){
            List<AttachmentVO> list = new ArrayList<>();
            for (SupplyFileVo e : pzList) {
                AttachmentVO attachmentVO = new AttachmentVO();
                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
                attachmentVO.setSourceId(documentSupplierId);
                attachmentVO.setSourceType("supplierFileType");
                attachmentVO.setFilePath(e.getFilePath());
                attachmentVO.setOnlinePath(e.getFilePath());
                attachmentVO.setFileName(e.getFileName());
                attachmentVO.setId(e.getFileId());
                list.add(attachmentVO);
                logger.info("保存文件信息:{}", JSONObject.toJSONString(attachmentVO));
            }
            CommonResponse<String> stringCommonResponse = attachmentApi.insertBatch(list);
            logger.info(request+"报名文件上传结果-{}",JSONObject.toJSONString(stringCommonResponse));
        }
        return true;
    }

    @Override
    public String uploadById(Long attachId,Long inviteId) {
        Map<String, String> fileMap = new HashMap<>();
        fileMap.put("fileIds",Long.toString(attachId));
        String wjFileByte = null;
        try {
            wjFileByte = ReferHttpClientUtils.getAndHeader(BASE_HOST + "ejc-file-web/attachment/batchdownflow", fileMap);
        } catch (GeneralSecurityException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        //文件stream处理
        JSONObject jsonwj = JSON.parseObject(wjFileByte);
        Map<String, String> zbwjParam = JSONObject.parseObject(jsonwj.toJSONString(), new TypeReference<Map<String, String>>(){});
        String datawj = zbwjParam.get("data");
        JSONObject wListJson = JSON.parseObject(datawj);
        Map<String, byte[]> wjMap = JSONObject.parseObject(wListJson.toJSONString(), new TypeReference<Map<String, byte[]>>(){});
        Map<String, InputStream> streamMap = new HashMap<>();
        wjMap.forEach((key,value) ->{
            streamMap.put(key,new ByteArrayInputStream(value));
        });


        Map<String,String> params = new HashMap<>();
        params.put("sourceId", Long.toString(inviteId));
        Map<String,String> headers = new HashMap<>();
        Map<String, Map<String, InputStream>> files = new HashMap<>();
        files.put("file",streamMap);

        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataAndFilesWithUniversal(addFileUrl, params, files, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("附件批量修改同步供方接口报错" + stringCommonResponse.getMsg());
        }
        return null;
    }

    @Override
    public String deleteFileById(Long sourceId, List<String> fileNames) {
        Map<String,Object> map = new HashMap<>();
        map.put("sourceId",sourceId);
        map.put("fileNames",fileNames);
        String stringInfo = JSONObject.toJSONString(map);
        //调用供方接口
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(delFileUrl, RequestMethod.POST, stringInfo, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
                throw new BusinessException("附加批量删除同步供方接口报错" + response.getMsg());
            }
        return "同步成功";
    }

    @Override
    public OtherDocumentSupplierSellVO getSupplierSchemeDetailDb(Long schemeId, Long documentId) {

        OtherDocumentEntity otherDocumentEntity = super.selectById(documentId);
        OtherDocumentSupplierSellVO otherDocumentSupplierSellVO = new OtherDocumentSupplierSellVO();
        OtherDocumentSchemeEntity otherDocumentSchemeEntity = otherDocumentSchemeService.selectById(schemeId);
        OtherDocumentSupplierEntity otherDocumentSupplierEntity = otherDocumentSupplierService.selectById(otherDocumentSchemeEntity.getDocumentSupplierId());
        Long supplierDetailId = otherDocumentSupplierEntity.getId();
        otherDocumentSupplierSellVO.setLinkName(otherDocumentSupplierEntity.getLinkName());
        otherDocumentSupplierSellVO.setSupplierName(otherDocumentSupplierEntity.getSupplierName());
        otherDocumentSupplierSellVO.setLinkMobile(otherDocumentSupplierEntity.getLinkMobile());
        otherDocumentSupplierSellVO.setOfferTime(otherDocumentSupplierEntity.getOfferTime());
        otherDocumentSupplierSellVO.setTaxMemo(otherDocumentSupplierEntity.getTaxMemo());
        otherDocumentSupplierSellVO.setPurchaseType(otherDocumentEntity.getPurchaseType());
        LambdaQueryWrapper<OtherDocumentSchemeEntity> lambdaScheme = Wrappers.<OtherDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(OtherDocumentSchemeEntity::getDocumentSupplierId,supplierDetailId);
        List<OtherDocumentSchemeEntity> otherDocumentSchemeEntityList = otherDocumentSchemeService.list(lambdaScheme);
        List<OtherDocumentSchemeVO> otherDocumentSchemeVOList = BeanMapper.mapList(otherDocumentSchemeEntityList, OtherDocumentSchemeVO.class);

        //获取报价方案详情
        LambdaQueryWrapper<OtherDocumentSellEntity> lambdaSell = Wrappers.<OtherDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(OtherDocumentSellEntity::getDocumentId,otherDocumentSupplierEntity.getDocumentId());
        List<OtherDocumentSellEntity> otherDocumentSellEntityList = otherDocumentSellService.list(lambdaSell);
        List<OtherDocumentSellVO> otherDocumentSellVOList = BeanMapper.mapList(otherDocumentSellEntityList, OtherDocumentSellVO.class);
        Map<Long, List<OtherDocumentSellVO>> sellMap = otherDocumentSellVOList.stream().
                collect(Collectors.groupingBy(OtherDocumentSellVO::getSchemeId));
        for (OtherDocumentSchemeVO otherDocumentSchemeVO : otherDocumentSchemeVOList){
            List<OtherDocumentSellVO> otherDocumentSellVOS = sellMap.get(otherDocumentSchemeVO.getId());
            otherDocumentSchemeVO.setOtherDocumentSellList(otherDocumentSellVOS);
        }
        otherDocumentSupplierSellVO.setOtherDocumentSchemeList(otherDocumentSchemeVOList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null){
            if (fileInfo.containsKey("attachId")){
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                otherDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")){
                otherDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }

        return otherDocumentSupplierSellVO;
    }

    @Override
    public OtherDocumentVO saveOrUpdates(OtherDocumentVO saveorUpdateVO) {
        OtherDocumentEntity entity = BeanMapper.map(saveorUpdateVO, OtherDocumentEntity.class);
        service.saveOrUpdate(entity, false);
        OtherDocumentVO vo = BeanMapper.map(entity, OtherDocumentVO.class);
        OtherInviteEntity subInviteEntity = otherInviteService.selectById(entity.getInviteId());
        List<OtherInviteDetailRecordVO> subInviteDetailRecordVOS = BeanMapper.mapList(subInviteEntity.getOtherDetailRecord(), OtherInviteDetailRecordVO.class);
        vo.setOtherDetailRecord(subInviteDetailRecordVOS);
        return vo;
    }


    @Override
    public OtherDocumentVO queryDocDetail(Long id,Integer talkNum) {

        OtherDocumentEntity entity = super.selectById(id);
        OtherDocumentVO otherDocumentVO = BeanMapper.map(entity, OtherDocumentVO.class);

        otherDocumentVO.setOtherDocumentSchemeList(null);
        otherDocumentVO.setOtherDocumentSellList(null);
        //处理报名供应商信息
        if(otherDocumentVO.getNoticeId()!=null){
            LambdaQueryWrapper<OtherNoticeSupplierEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(OtherNoticeSupplierEntity::getNoticeId, entity.getNoticeId());
            wrapper.ne(OtherNoticeSupplierEntity::getState, 1);
            List<OtherNoticeSupplierEntity> list = otherNoticeSupplierService.list(wrapper);//未剔除的报名供应商
            if(CollectionUtils.isNotEmpty(list)){
                List<OtherNoticeSupplierVO> noticeSupplierVOS = BeanMapper.mapList(list, OtherNoticeSupplierVO.class);
                Map<Long, OtherDocumentSupplierVO> documentSupplierVOMap = new HashMap<>();
                if(CollectionUtils.isNotEmpty(otherDocumentVO.getOtherDocumentSupplierList())){
                    documentSupplierVOMap = otherDocumentVO.getOtherDocumentSupplierList().stream().filter(t->t.getSupplierId()!=null).collect(Collectors.toMap(OtherDocumentSupplierVO::getSupplierId, item -> item, (v1, v2) -> v2));
                }
                for (OtherNoticeSupplierVO noticeSupplier :  noticeSupplierVOS) {
                    if(documentSupplierVOMap.containsKey(noticeSupplier.getSupplierId())){
                        noticeSupplier.setDocumentType(0);//已报价
                    }else {
                        noticeSupplier.setDocumentType(1);//未报价
                    }
                }
                otherDocumentVO.setOtherDocumentSupplierDetail(noticeSupplierVOS);
            }
        }
        //处理报价信息,开标之前不能显示
        //按供应商查看报价()
        LambdaQueryWrapper<OtherDocumentSupplierEntity> lambda = Wrappers.<OtherDocumentSupplierEntity>lambdaQuery();
        lambda.eq(OtherDocumentSupplierEntity::getDocumentId, id);
        lambda.eq(OtherDocumentSupplierEntity::getTalkNum, talkNum);
        List<OtherDocumentSupplierEntity> supplierList = otherDocumentSupplierService.list(lambda);

        if (CollectionUtils.isNotEmpty(supplierList)){
            List<OtherDocumentSupplierVO> otherDocumentSupplierVOS = BeanMapper.mapList(supplierList, OtherDocumentSupplierVO.class);
            LambdaQueryWrapper<OtherDocumentSchemeEntity> lambdaScheme = Wrappers.<OtherDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(OtherDocumentSchemeEntity::getDocumentId, id);
            lambdaScheme.eq(OtherDocumentSchemeEntity::getTalkNum, talkNum);
            lambdaScheme.orderByAsc(OtherDocumentSchemeEntity::getSchemeName);
            List<OtherDocumentSchemeEntity> schemeList = otherDocumentSchemeService.list(lambdaScheme);
            Map<Long, List<OtherDocumentSchemeEntity>> schemeMap = schemeList.stream().
                    collect(Collectors.groupingBy(OtherDocumentSchemeEntity::getDocumentSupplierId));
            //是否开标,0-是,1-否
            if (entity.getBidFlag() == 0){
                for (OtherDocumentSupplierVO otherDocumentSupplierEntity : otherDocumentSupplierVOS){
                    List<OtherDocumentSchemeEntity> otherDocumentSchemeEntities = schemeMap.get(otherDocumentSupplierEntity.getId());
                    String schemeMoney  = "";
                    for (OtherDocumentSchemeEntity otherDocumentSchemeEntity : otherDocumentSchemeEntities){
                        schemeMoney = schemeMoney + otherDocumentSchemeEntity.getSchemeName() + ":" + otherDocumentSchemeEntity.getMoneyTax().setScale(2,BigDecimal.ROUND_HALF_DOWN) + "元" + ";";
                    }
                    int length = schemeMoney.length();
                    String schemeMoneyNew = schemeMoney.substring(0, length - 1);
                    otherDocumentSupplierEntity.setSchemeMoney(schemeMoneyNew);
                }

                //处理供应商附件信息
                if (CollectionUtils.isNotEmpty(otherDocumentSupplierVOS)){
                    List<Long> attachIds = otherDocumentSupplierVOS.stream().map(OtherDocumentSupplierVO::getId).collect(Collectors.toList());
                    Map<String, List<Long>> map = new HashMap<>();
                    map.put("sourceIds",attachIds);
                    JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
                    CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
                    if (listCommonResponse.isSuccess()){
                        List<AttachmentVO> data = listCommonResponse.getData();
                        if (CollectionUtils.isNotEmpty(data)){
                            Map<Long, AttachmentVO> attacMap = data.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                            for (OtherDocumentSupplierVO otherDocumentSupplierVO : otherDocumentSupplierVOS){
                                AttachmentVO attachmentVO = attacMap.get(otherDocumentSupplierVO.getId());
                                if(attachmentVO != null){
                                    otherDocumentSupplierVO.setAttachId(attachmentVO.getId());
                                    otherDocumentSupplierVO.setFileName(attachmentVO.getFileName());
                                }
                            }
                        }
                    }
                }
            }

            //是否开标,0-是,1-否
//            if (entity.getBidFlag() == 1){
//                for (OtherDocumentSupplierVO otherDocumentSupplierVO : otherDocumentSupplierVOS){
//                    otherDocumentSupplierVO.setRegisterDate(null);
//                }
//            }
            //按供应商查看报价
            otherDocumentVO.setOtherDocumentSupplierList(otherDocumentSupplierVOS);
            //前端键值重复设计
            otherDocumentVO.setOtherDocumentSupplierSchemeList(otherDocumentSupplierVOS);
            //按材料查看报价
            List<OtherDocumentDetailVO> otherDocumentDetailList = otherDocumentVO.getOtherDocumentDetailList();
            //获取材料明细报价
            LambdaQueryWrapper<OtherDocumentSellEntity> lambdaSell = Wrappers.<OtherDocumentSellEntity>lambdaQuery();
            lambdaSell.eq(OtherDocumentSellEntity::getDocumentId, id);
            lambdaSell.eq(OtherDocumentSellEntity::getTalkNum, talkNum);
            lambdaSell.orderByAsc(OtherDocumentSellEntity::getSupplierId);
            lambdaSell.orderByAsc(OtherDocumentSellEntity::getSchemeName);
            List<OtherDocumentSellEntity> sellList = otherDocumentSellService.list(lambdaSell);
            if (CollectionUtils.isNotEmpty(sellList)){
                List<OtherDocumentSellVO> otherDocumentSellVOS = BeanMapper.mapList(sellList, OtherDocumentSellVO.class);
                for (OtherDocumentSellVO otherDocumentSellVO : otherDocumentSellVOS){
                    //是否开标,0-是,1-否
                    if (entity.getBidFlag() == 1){
                        otherDocumentSellVO.setPrice(null);
                        otherDocumentSellVO.setPriceTax(null);
                        otherDocumentSellVO.setMoney(null);
                        otherDocumentSellVO.setMoneyTax(null);
                        otherDocumentSellVO.setSellTax(null);
                        otherDocumentSellVO.setTenderNum(null);
                        otherDocumentSellVO.setTenderMoney(null);
                        otherDocumentSellVO.setTenderFlag(null);
                    }
                    if (entity.getBidFlag() == 0){
                        otherDocumentSellVO.setTenderNum(null);
                        otherDocumentSellVO.setTenderMoney(null);
                        otherDocumentSellVO.setTenderFlag(null);
                    }
                }
                Map<Long, List<OtherDocumentSellVO>> sellMap = otherDocumentSellVOS.stream().
                        collect(Collectors.groupingBy(OtherDocumentSellVO::getDetailId));
                for (OtherDocumentDetailVO otherDocumentDetailVO : otherDocumentDetailList){
                    List<OtherDocumentSupplierVO> documentSupplierVOS = new ArrayList<>();
                    List<OtherDocumentSellVO> otherDocumentSellEntities = sellMap.get(otherDocumentDetailVO.getId());
                    Map<Long, List<OtherDocumentSellVO>> sellDetailMap = otherDocumentSellEntities.stream().
                            collect(Collectors.groupingBy(OtherDocumentSellVO::getSupplierId));
                    sellDetailMap.forEach((key,value) ->{
                        OtherDocumentSupplierVO otherDocumentSupplierVO = new OtherDocumentSupplierVO();
                        otherDocumentSupplierVO.setSupplierId(key);
                        OtherDocumentSellVO otherDocumentSellVO = value.stream().findFirst().get();
                        otherDocumentSupplierVO.setSupplierName(otherDocumentSellVO.getSupplierName());
                        otherDocumentSupplierVO.setOtherDocumentSellVOList(value);
                        documentSupplierVOS.add(otherDocumentSupplierVO);
                    });
                    otherDocumentDetailVO.setOtherDocumentSupplierVOList(documentSupplierVOS);
                }
                //区分报价详情信息
                List<OtherDocumentDetailVO> otherDocumentDetailSellList = otherDocumentVO.getOtherDocumentDetailList();
                otherDocumentVO.setOtherDocumentDetailSellList(otherDocumentDetailSellList);
            }
        }
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(otherDocumentVO.getInviteId());
        otherDocumentVO.setOtherDetailRecord(BeanMapper.mapList(otherInviteEntity.getOtherDetailRecord(),OtherInviteDetailRecordVO.class));
        return otherDocumentVO;
    }


    @Override
    public List<OtherDocumentSellVO> getSchemeDetail(OtherDocumentSellVO otherDocumentSellVO) {
        LambdaQueryWrapper<OtherDocumentSellEntity> lambdaSell = Wrappers.<OtherDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(OtherDocumentSellEntity::getSupplierId,otherDocumentSellVO.getSupplierId() );
        lambdaSell.eq(OtherDocumentSellEntity::getDocumentId,otherDocumentSellVO.getDocumentId() );
        lambdaSell.eq(OtherDocumentSellEntity::getSchemeId,otherDocumentSellVO.getSchemeId() );
        List<OtherDocumentSellEntity> list = otherDocumentSellService.list(lambdaSell);
        List<OtherDocumentSellVO> otherDocumentSellVOList = BeanMapper.mapList(list,OtherDocumentSellVO.class);
        return otherDocumentSellVOList;
    }

    @Override
    public OtherDocumentSupplierSellVO getSupplierSchemeDetail(Long supplierDetailId, Long documentId) {
        OtherDocumentEntity otherDocumentEntity = super.selectById(documentId);
        OtherDocumentSupplierSellVO otherDocumentSupplierSellVO = new OtherDocumentSupplierSellVO();
        OtherDocumentSupplierEntity otherDocumentSupplierEntity = otherDocumentSupplierService.selectById(supplierDetailId);
        otherDocumentSupplierSellVO.setLinkName(otherDocumentSupplierEntity.getLinkName());
        otherDocumentSupplierSellVO.setSupplierId(otherDocumentSupplierEntity.getSupplierId());
        otherDocumentSupplierSellVO.setSupplierName(otherDocumentSupplierEntity.getSupplierName());
        otherDocumentSupplierSellVO.setLinkMobile(otherDocumentSupplierEntity.getLinkMobile());
        otherDocumentSupplierSellVO.setOfferTime(otherDocumentSupplierEntity.getOfferTime());
        otherDocumentSupplierSellVO.setTaxMemo(otherDocumentSupplierEntity.getTaxMemo());
        otherDocumentSupplierSellVO.setPurchaseType(otherDocumentEntity.getPurchaseType());
        LambdaQueryWrapper<OtherDocumentSchemeEntity> lambdaScheme = Wrappers.<OtherDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(OtherDocumentSchemeEntity::getDocumentSupplierId,supplierDetailId);
        List<OtherDocumentSchemeEntity> otherDocumentSchemeEntityList = otherDocumentSchemeService.list(lambdaScheme);
        List<OtherDocumentSchemeVO> otherDocumentSchemeVOList = BeanMapper.mapList(otherDocumentSchemeEntityList, OtherDocumentSchemeVO.class);

        //获取报价方案详情
        LambdaQueryWrapper<OtherDocumentSellEntity> lambdaSell = Wrappers.<OtherDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(OtherDocumentSellEntity::getDocumentId,otherDocumentSupplierEntity.getDocumentId());
        List<OtherDocumentSellEntity> otherDocumentSellEntityList = otherDocumentSellService.list(lambdaSell);
        List<OtherDocumentSellVO> otherDocumentSellVOList = BeanMapper.mapList(otherDocumentSellEntityList, OtherDocumentSellVO.class);
        Map<Long, List<OtherDocumentSellVO>> sellMap = otherDocumentSellVOList.stream().
                collect(Collectors.groupingBy(OtherDocumentSellVO::getSchemeId));
        for (OtherDocumentSchemeVO otherDocumentSchemeVO : otherDocumentSchemeVOList){
            List<OtherDocumentSellVO> otherDocumentSellVOS = sellMap.get(otherDocumentSchemeVO.getId());
            otherDocumentSchemeVO.setOtherDocumentSellList(otherDocumentSellVOS);
        }
        otherDocumentSupplierSellVO.setOtherDocumentSchemeList(otherDocumentSchemeVOList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null){
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                otherDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                otherDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }

        return otherDocumentSupplierSellVO;
    }
    @Transactional
    @Override
    public OtherDocumentVO extendDocument(OtherDocumentRecordVO otherDocumentRecordVO) {
        OtherDocumentRecordEntity otherDocumentRecordEntity = BeanMapper.map(otherDocumentRecordVO, OtherDocumentRecordEntity.class);
        otherDocumentRecordService.save(otherDocumentRecordEntity);
        OtherDocumentEntity otherDocumentEntity = super.selectById(otherDocumentRecordVO.getDocumentId());
        otherDocumentEntity.setOfferEndTime(otherDocumentRecordVO.getNewTime());
        boolean b = super.updateById(otherDocumentEntity);

        //推送供方
        OtherSupplierSellVO supplierSellVO = new OtherSupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(otherDocumentEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(otherDocumentRecordVO.getNewTime());

        String stringFb = JSONObject.toJSONString(supplierSellVO);
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(updateTimeUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("招标文件同步供方接口报错" + stringCommonResponse.getMsg());
        }

        OtherDocumentVO otherDocumentVO = queryDetail(otherDocumentRecordVO.getDocumentId());
        return otherDocumentVO;
    }

    @Override
    public OtherDocumentSupplierSellVO getSupplierSchemeTalkDetail(Long supplierDetailId, Long talkId) {

        OtherTalkEntity otherTalkEntity = otherTalkService.selectById(talkId);
        Integer talkNum = otherTalkEntity.getTalkNum();
        if(otherTalkEntity.getPublishFlag() == 1){
            talkNum = talkNum - 1;
        }
        List<OtherTalkVO> talkVOArrayList = new ArrayList<>();
        String name = null;
        for (int a = 0;a <= talkNum;a++){
            OtherTalkVO otherTalkVO = new OtherTalkVO();
            otherTalkVO.setTalkNum(a);
            if (a == 0){
                name = "首次报价";
            }else {
                name = "第" + a + "轮报价";
            }
            otherTalkVO.setTalkNumName(name);
            talkVOArrayList.add(otherTalkVO);
        }

        OtherDocumentSupplierSellVO otherDocumentSupplierSellVO = new OtherDocumentSupplierSellVO();
        OtherDocumentSupplierEntity otherDocumentSupplierEntity = otherDocumentSupplierService.selectById(supplierDetailId);
        otherDocumentSupplierSellVO.setLinkName(otherDocumentSupplierEntity.getLinkName());
        otherDocumentSupplierSellVO.setLinkMobile(otherDocumentSupplierEntity.getLinkMobile());
        otherDocumentSupplierSellVO.setOfferTime(otherDocumentSupplierEntity.getOfferTime());
        otherDocumentSupplierSellVO.setTaxMemo(otherDocumentSupplierEntity.getTaxMemo());
        otherDocumentSupplierSellVO.setSupplierName(otherDocumentSupplierEntity.getSupplierName());

        for (OtherTalkVO otherTalkVO : talkVOArrayList){
            LambdaQueryWrapper<OtherDocumentSchemeEntity> lambdaScheme = Wrappers.<OtherDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(OtherDocumentSchemeEntity::getDocumentId,otherDocumentSupplierEntity.getDocumentId());
            lambdaScheme.eq(OtherDocumentSchemeEntity::getSupplierId,otherDocumentSupplierEntity.getSupplierId());
            lambdaScheme.eq(OtherDocumentSchemeEntity::getTalkNum,otherTalkVO.getTalkNum());
            List<OtherDocumentSchemeEntity> otherDocumentSchemeEntityList = otherDocumentSchemeService.list(lambdaScheme);
            if(CollectionUtils.isEmpty(otherDocumentSchemeEntityList)){
                continue;
            }
            List<OtherDocumentSchemeVO> otherDocumentSchemeVOList = BeanMapper.mapList(otherDocumentSchemeEntityList, OtherDocumentSchemeVO.class);

            //获取报价方案详情
            List<Long> schemePkList = otherDocumentSchemeVOList.stream().map(OtherDocumentSchemeVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper<OtherDocumentSellEntity> lambdaSell = Wrappers.<OtherDocumentSellEntity>lambdaQuery();
            lambdaSell.in(OtherDocumentSellEntity::getSchemeId,schemePkList);
            List<OtherDocumentSellEntity> otherDocumentSellEntityList = otherDocumentSellService.list(lambdaSell);
            List<OtherDocumentSellVO> otherDocumentSellVOList = BeanMapper.mapList(otherDocumentSellEntityList, OtherDocumentSellVO.class);
            Map<Long, List<OtherDocumentSellVO>> sellMap = otherDocumentSellVOList.stream().
                    collect(Collectors.groupingBy(OtherDocumentSellVO::getSchemeId));
            for (OtherDocumentSchemeVO otherDocumentSchemeVO : otherDocumentSchemeVOList){
                List<OtherDocumentSellVO> otherDocumentSellVOS = sellMap.get(otherDocumentSchemeVO.getId());
                otherDocumentSchemeVO.setOtherDocumentSellList(otherDocumentSellVOS);
            }
            otherTalkVO.setOtherDocumentSchemeList(otherDocumentSchemeVOList);
        }
        otherDocumentSupplierSellVO.setOtherTalkVOList(talkVOArrayList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if(fileInfo != null){
            if (fileInfo.containsKey("attachId")){
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                otherDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")){
                otherDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }


        return otherDocumentSupplierSellVO;
    }

    private Map<String,Object> getFileInfo(Long sourceId) {
        Map<String, Object> map = new HashMap<>();
        //查询附件
        CommonResponse<List<AttachmentVO>> attachResponse = attachmentApi.queryListBySourceId(sourceId, BILL_SUPPLIER_TYPE, "supplierFileType", null);
        if (attachResponse.isSuccess()){
            List<AttachmentVO> data = attachResponse.getData();
            if(CollectionUtils.isNotEmpty(data)){
                AttachmentVO attachmentVO = data.stream().findFirst().get();
                if(attachmentVO != null){
                    map.put("fileName",attachmentVO.getFileName());
                    map.put("attachId",attachmentVO.getId());
                }


            }
        }
        return map;
    }

    @Override
    public OtherDocumentVO publishManyDocument(Long id) throws InvocationTargetException, IllegalAccessException {
        //更新发布状态
        OtherDocumentEntity otherDocumentEntity = super.selectById(id);
        otherDocumentEntity.setPublishFlag(0);
        super.updateById(otherDocumentEntity);


        OtherNoticeSupplierTbVO otherNoticeSupplierTbVO = new OtherNoticeSupplierTbVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        otherNoticeSupplierTbVO.setSourceType("郑州一建招标文件");
        otherNoticeSupplierTbVO.setSourceId(otherDocumentEntity.getInviteId().toString());
        OtherInviteEntity inviteEntity = otherInviteService.selectById(otherDocumentEntity.getInviteId());
        if (otherDocumentEntity.getTenderType()==2){
            otherNoticeSupplierTbVO.setNoticeType(2);
        }else {
            otherNoticeSupplierTbVO.setNoticeType(3);
        }
        if (otherDocumentEntity.getPurchaseType()==1){
            otherNoticeSupplierTbVO.setSourceProjectId(null);
            otherNoticeSupplierTbVO.setProjectName(null);
            otherNoticeSupplierTbVO.setProjectCode(null);
        }else {
            otherNoticeSupplierTbVO.setSourceProjectId(otherDocumentEntity.getProjectId().toString());
            otherNoticeSupplierTbVO.setProjectName(otherDocumentEntity.getProjectName());
            otherNoticeSupplierTbVO.setProjectCode(otherDocumentEntity.getProjectCode());
        }

        otherNoticeSupplierTbVO.setSourceOrgId(otherDocumentEntity.getOrgId().toString());
        otherNoticeSupplierTbVO.setOrgName(otherDocumentEntity.getOrgName());
        otherNoticeSupplierTbVO.setSourceUnitId(otherDocumentEntity.getUnitId().toString());
        otherNoticeSupplierTbVO.setUnitName(otherDocumentEntity.getUnitName());
        otherNoticeSupplierTbVO.setMemo(otherDocumentEntity.getMemo());
        otherNoticeSupplierTbVO.setType("OTHER");
        otherNoticeSupplierTbVO.setTenderName(otherDocumentEntity.getDocumentName());
        otherNoticeSupplierTbVO.setTenderType(otherDocumentEntity.getTenderType());
        otherNoticeSupplierTbVO.setPurchaseType(otherDocumentEntity.getPurchaseType().toString());
        otherNoticeSupplierTbVO.setPurchaseName(otherDocumentEntity.getPurchaseName());
        otherNoticeSupplierTbVO.setSourceEmployeeId(otherDocumentEntity.getEmployeeId().toString());
        otherNoticeSupplierTbVO.setEmployeeName(otherDocumentEntity.getEmployeeName());
        otherNoticeSupplierTbVO.setEmployeeMobile(otherDocumentEntity.getEmployeeMobile());
        otherNoticeSupplierTbVO.setValueType(otherDocumentEntity.getValueType());
        otherNoticeSupplierTbVO.setContent(otherDocumentEntity.getDocumentContent());
        otherNoticeSupplierTbVO.setOfferStartTime(sdf.format(otherDocumentEntity.getOfferStartTime()));
        otherNoticeSupplierTbVO.setOfferEndTime(sdf.format(otherDocumentEntity.getOfferEndTime()));
        otherNoticeSupplierTbVO.setBrandFlag(otherDocumentEntity.getBrandFlag());
        otherNoticeSupplierTbVO.setProjectLinkName(otherDocumentEntity.getProjectLinkName());
        otherNoticeSupplierTbVO.setProjectLinkPhone(otherDocumentEntity.getProjectLinkPhone());
        otherNoticeSupplierTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        otherNoticeSupplierTbVO.setMaterialContentId(inviteEntity.getPurchaseId());
        otherNoticeSupplierTbVO.setMaterialContent(inviteEntity.getPurchaseName());
        otherNoticeSupplierTbVO.setSettlementClause(inviteEntity.getSettlementClause());
        //插入物资
        List<OtherNoticeDetailTbVO> otherNoticeDetailVOS = new ArrayList<>();
        for (OtherDocumentDetailEntity otherDocumentDetailEntity : otherDocumentEntity.getOtherDocumentDetailList()) {
            OtherNoticeDetailTbVO otherNoticeDetailTbVO = new OtherNoticeDetailTbVO();
            BeanUtils.copyProperties(otherNoticeDetailTbVO,otherDocumentDetailEntity);
            otherNoticeDetailTbVO.setSourceId(otherDocumentEntity.getInviteId().toString());
            otherNoticeDetailTbVO.setSourceDetailId(otherDocumentDetailEntity.getId().toString());
            otherNoticeDetailTbVO.setSourceMaterialId(otherDocumentDetailEntity.getMaterialId()==null?null:otherDocumentDetailEntity.getMaterialId().toString());
//            otherNoticeDetailTbVO.setSourceMaterialTypeId(otherDocumentDetailEntity.getMaterialTypeId().toString());
            otherNoticeDetailVOS.add(otherNoticeDetailTbVO);
        }
        otherNoticeSupplierTbVO.setOtherDetailList(otherNoticeDetailVOS);
        //是否是邀请招标
        if (otherDocumentEntity.getTenderType()!=2){
            List<OtherDocumentSupplierDetailEntity> detailEntityList = supplierDetailService.list(new LambdaQueryWrapper<OtherDocumentSupplierDetailEntity>().eq(OtherDocumentSupplierDetailEntity::getInviteId, otherDocumentEntity.getInviteId()).eq(OtherDocumentSupplierDetailEntity::getDr, 0));
            List<OtherNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
            for (OtherDocumentSupplierDetailEntity supplierDetailEntity : detailEntityList) {
                OtherNoticeSupplierDetailTbVO otherNoticeSupplierDetailTbVO = new OtherNoticeSupplierDetailTbVO();
                otherNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
                otherNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
                otherNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));

                supplierDetailTbVOList.add(otherNoticeSupplierDetailTbVO);
            }
            otherNoticeSupplierTbVO.setApplyList(supplierDetailTbVOList);
        }
        String stringFb = JSONObject.toJSONString(otherNoticeSupplierTbVO);
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, stringFb, appId,appSecret,appHost);
            if (!response.isSuccess()){
                throw new BusinessException("招标文件同步供方接口报错" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            throw new BusinessException("招标文件同步供方接口报错" + response.getMsg());
        }
        return queryDetail(id);
    }
    @Override
    public CommonResponse delSupplier(Long id) {
        OtherDocumentEntity otherDocumentEntity = baseMapper.selectById(id);
        List<OtherDocumentSupplierEntity> otherDocumentSupplierList = supplierMapper.selectList(new QueryWrapper<OtherDocumentSupplierEntity>().eq("document_id", otherDocumentEntity.getId()).eq("dr", 0));
        List<OtherDocumentSupplierDetailEntity> supplierDetailList = supplierDetailMapper.selectList(new QueryWrapper<OtherDocumentSupplierDetailEntity>().eq("invite_id", otherDocumentEntity.getInviteId()).eq("dr", 0));
        List<Long> oldIds = new ArrayList<>();
        List<Long> newIds = new ArrayList<>();
        otherDocumentSupplierList.stream().forEach(it->oldIds.add(it.getSupplierId()));
        supplierDetailList.stream().forEach(it->newIds.add(it.getSupplierId()));
        List<Long> newId = newIds.stream().filter(it -> !oldIds.contains(it)).collect(Collectors.toList());
        List<OtherDocumentSupplierDetailEntity> newRequestList = supplierDetailList.stream().filter(it -> newId.contains(it.getSupplierId())).collect(Collectors.toList());
        //装填数据
        List<OtherNoticeSupplierDetailTbVO> signVOList = new ArrayList<>();
        for (OtherDocumentSupplierDetailEntity supplierDetailEntity : newRequestList) {
            OtherNoticeSupplierDetailTbVO otherNoticeSupplierDetailTbVO = new OtherNoticeSupplierDetailTbVO();
            otherNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
            otherNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
            otherNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));

            otherNoticeSupplierDetailTbVO.setOutReason("超时未报价");
            signVOList.add(otherNoticeSupplierDetailTbVO);
        }
        logger.info("剔除的供应商"+JSON.toJSONString(signVOList));
        //调用第三方接口
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, JSON.toJSONString(signVOList), appId,appSecret,appHost);
            if (!response.isSuccess()){
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        return CommonResponse.success("剔除供应商成功");
    }

    @Override
    public OtherDocumentVO saveManyDocument(Long id) {
        OtherDocumentEntity otherDocumentEntity = new OtherDocumentEntity();
        //查询招标主表信息
        OtherInviteEntity inviteEntity = otherInviteService.selectById(id);
        //复制主表
        otherDocumentEntity.setInviteId(inviteEntity.getId());
        otherDocumentEntity.setDocumentName(inviteEntity.getTenderName());
        if (inviteEntity.getPurchaseType()==0){
            otherDocumentEntity.setProjectId(inviteEntity.getProjectId());
            otherDocumentEntity.setProjectName(inviteEntity.getProjectName());
            otherDocumentEntity.setProjectCode(inviteEntity.getProjectCode());
        }
        otherDocumentEntity.setPurchaseId(inviteEntity.getPurchaseId());
        otherDocumentEntity.setPurchaseName(inviteEntity.getPurchaseName());
        otherDocumentEntity.setPurchaseType(inviteEntity.getPurchaseType());
        otherDocumentEntity.setOrgId(inviteEntity.getOrgId());
        otherDocumentEntity.setOrgName(inviteEntity.getOrgName());
        otherDocumentEntity.setParentOrgId(inviteEntity.getParentOrgId());
        otherDocumentEntity.setParentOrgName(inviteEntity.getParentOrgName());
        otherDocumentEntity.setValueType(inviteEntity.getValueType());
        otherDocumentEntity.setUnitId(inviteEntity.getUnitId());
        otherDocumentEntity.setUnitName(inviteEntity.getUnitName());
        otherDocumentEntity.setTenderType(inviteEntity.getTenderType());
        otherDocumentEntity.setSettlementClause(inviteEntity.getSettlementClause());

        //设置计价方式
        otherDocumentEntity.setBidFlag(1);
        otherDocumentEntity.setPublishFlag(1);
        otherDocumentEntity.setNextFlag(1);


        //复制物资详情
        List<OtherInviteDetailRecordEntity> otherNoticeDetailList = inviteEntity.getOtherDetailRecord();
        List<OtherDocumentDetailEntity> otherDocumentDetailList = BeanMapper.mapList(otherNoticeDetailList, OtherDocumentDetailEntity.class);
        for (OtherDocumentDetailEntity otherDocumentDetailEntity : otherDocumentDetailList){
            otherDocumentDetailEntity.setId(null);
        }
        otherDocumentEntity.setOtherDocumentDetailList(otherDocumentDetailList);

        //复制供应商
        List<OtherInviteSupplierEntity> supplierDetailList = inviteEntity.getSupplierDetail();
        List<OtherDocumentSupplierDetailEntity> otherDocumentSupplierDetailVOS = BeanMapper.mapList(supplierDetailList, OtherDocumentSupplierDetailEntity.class);
        for (OtherDocumentSupplierDetailEntity otherDocumentSupplierDetailVO : otherDocumentSupplierDetailVOS) {
            otherDocumentSupplierDetailVO.setId(null);
            documentSupplierDetailService.saveOrUpdate(otherDocumentSupplierDetailVO);
        }

        service.saveOrUpdate(otherDocumentEntity, false);

        ProcessEntity processEntity = new ProcessEntity();
        //回写招标阶段
        switch(inviteEntity.getTenderType()){
            case 3:
                inviteEntity.setTenderStage(6);
                processEntity.setBillName("竞争性谈判");
                break;
            case 4:
                inviteEntity.setTenderStage(8);
                processEntity.setBillName("单一来源");
                break;
            case 5:
                inviteEntity.setTenderStage(9);
                processEntity.setBillName("紧急招标");
                break;
            case 2:
                inviteEntity.setTenderStage(10);
                processEntity.setBillName("询价公告");
                break;
        }
        otherInviteService.updateById(inviteEntity);
        //回写进展表
        processEntity.setBillId(otherDocumentEntity.getId());
        processEntity.setTenderId(id);
        processEntity.setType(5);
        processEntity.setFrontendUrl("other/fourJzDyJjXj");
        processService.saveOrUpdate(processEntity);
        OtherDocumentVO vo = BeanMapper.map(otherDocumentEntity, OtherDocumentVO.class);
        return vo;
    }

    @Override
    public OtherDocumentSupplierSellVO getSupplierSchemeDetailTalk(Long supplierDetailId, Long talkId) {
        //获取轮数
        OtherTalkRecordEntity otherTalkRecordEntity = otherTalkRecordService.selectById(talkId);
        Integer talkNum = otherTalkRecordEntity.getTalkNum();
        if (otherTalkRecordEntity.getPublishFlag() == 1){
            talkNum = talkNum - 1;
        }

        //
        OtherDocumentSupplierSellVO otherDocumentSupplierSellVO = new OtherDocumentSupplierSellVO();
        OtherDocumentSupplierEntity otherDocumentSupplierEntity = otherDocumentSupplierService.selectById(supplierDetailId);
        otherDocumentSupplierSellVO.setLinkName(otherDocumentSupplierEntity.getLinkName());
        otherDocumentSupplierSellVO.setLinkMobile(otherDocumentSupplierEntity.getLinkMobile());
        otherDocumentSupplierSellVO.setOfferTime(otherDocumentSupplierEntity.getOfferTime());
        otherDocumentSupplierSellVO.setTaxMemo(otherDocumentSupplierEntity.getTaxMemo());
        LambdaQueryWrapper<OtherDocumentSchemeEntity> lambdaScheme = Wrappers.<OtherDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(OtherDocumentSchemeEntity::getDocumentSupplierId,supplierDetailId);
        List<OtherDocumentSchemeEntity> otherDocumentSchemeEntityList = otherDocumentSchemeService.list(lambdaScheme);
        List<OtherDocumentSchemeVO> otherDocumentSchemeVOList = BeanMapper.mapList(otherDocumentSchemeEntityList, OtherDocumentSchemeVO.class);

        //获取报价方案详情
        LambdaQueryWrapper<OtherDocumentSellEntity> lambdaSell = Wrappers.<OtherDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(OtherDocumentSellEntity::getDocumentId,otherDocumentSupplierEntity.getDocumentId());
        lambdaSell.eq(OtherDocumentSellEntity::getTalkNum,talkNum);
        List<OtherDocumentSellEntity> otherDocumentSellEntityList = otherDocumentSellService.list(lambdaSell);
        List<OtherDocumentSellVO> otherDocumentSellVOList = BeanMapper.mapList(otherDocumentSellEntityList, OtherDocumentSellVO.class);
        Map<Long, List<OtherDocumentSellVO>> sellMap = otherDocumentSellVOList.stream().
                collect(Collectors.groupingBy(OtherDocumentSellVO::getSchemeId));
        for (OtherDocumentSchemeVO otherDocumentSchemeVO : otherDocumentSchemeVOList){
            List<OtherDocumentSellVO> otherDocumentSellVOS = sellMap.get(otherDocumentSchemeVO.getId());
            otherDocumentSchemeVO.setOtherDocumentSellList(otherDocumentSellVOS);
        }
        otherDocumentSupplierSellVO.setOtherDocumentSchemeList(otherDocumentSchemeVOList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null){
            if (fileInfo.containsKey("attachId")){
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                otherDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")){
                otherDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }


        return otherDocumentSupplierSellVO;
    }

    @Override
    public OtherDocumentVO saveDocument(Long noticeId) {
        OtherDocumentEntity entity = new OtherDocumentEntity();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //查询公告主表信息
        OtherNoticeEntity otherNoticeEntity = otherNoticeService.selectById(noticeId);
        OtherInviteEntity otherInvite = otherInviteService.selectById(otherNoticeEntity.getInviteId());

        //复制物资详情
        List<OtherInviteDetailEntity> otherInviteDetailList = otherInvite.getOtherDetail();
        List<OtherDocumentDetailEntity> otherDocumentDetailList = BeanMapper.mapList(otherInviteDetailList, OtherDocumentDetailEntity.class);
        entity.setOtherDocumentDetailList(otherDocumentDetailList);

        //复制主表信息
        entity.setProjectId(otherNoticeEntity.getProjectId());
        entity.setNoticeId(noticeId);
        entity.setProjectName(otherNoticeEntity.getProjectName());
        entity.setOrgId(otherNoticeEntity.getOrgId());
        entity.setOrgName(otherNoticeEntity.getOrgName());
        entity.setParentOrgId(otherNoticeEntity.getParentOrgId());
        entity.setParentOrgName(otherNoticeEntity.getParentOrgName());
        entity.setProjectCode(otherNoticeEntity.getProjectCode());
        entity.setDocumentName(otherNoticeEntity.getNoticeName());
        entity.setEmployeeId(otherNoticeEntity.getEmployeeId());
        entity.setEmployeeName(otherNoticeEntity.getEmployeeName());
        entity.setEmployeeMobile(otherNoticeEntity.getEmployeeMobile());
        entity.setInviteId(otherNoticeEntity.getInviteId());
        entity.setPurchaseId(otherNoticeEntity.getPurchaseId());
        entity.setPurchaseName(otherNoticeEntity.getPurchaseName());
        entity.setPurchaseType(otherNoticeEntity.getPurchaseType());
        entity.setTenderType(otherNoticeEntity.getTenderType());
        //设置计价方式
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(otherNoticeEntity.getInviteId());
        entity.setValueType(otherInviteEntity.getValueType());
        entity.setBidFlag(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);

        service.saveOrUpdate(entity, false);

        //回写招标阶段
        otherInviteEntity.setTenderStage(3);
        otherInviteService.updateById(otherInviteEntity);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("招标文件");
        processEntity.setTenderId(otherNoticeEntity.getInviteId());
        processEntity.setType(5);
        processEntity.setFrontendUrl("other/document");
        processService.saveOrUpdate(processEntity);
        OtherDocumentVO vo = BeanMapper.map(entity, OtherDocumentVO.class);
        return vo;
    }


    @Override
    public CommonResponse<Boolean> checkExpertNum(Long documentId) {
        //根据documentId查询数据库中专家数量
        List<OtherDocumentExpertEntity> expertEntityList = documentExpertService.list(Wrappers.<OtherDocumentExpertEntity>lambdaQuery()
                .eq(OtherDocumentExpertEntity::getDocumentId, documentId)
                .eq(OtherDocumentExpertEntity::getDr, 0)
        );
        int totalNum = expertEntityList.size();
        if(totalNum < 3){
            return CommonResponse.error("所选专家数量至少为3人！",false);
        }
        //判断专家数量是否为单数
        if(totalNum % 2 == 0){
            return CommonResponse.error("所选专家数量必须为单数！",false);
        }

        /**
         * !!!数据量大时会损失精度，目前业务不可能超过，所以进行强制转换
         */
        //筛选出库中集团、项目专家数量
        int departmentExpertNum = (int)expertEntityList.stream().filter(entity -> "集团".equals(entity.getExpertFromName())).count();
        int projectExpertNum = (int)expertEntityList.stream().filter(entity -> "项目".equals(entity.getExpertFromName())).count();
        //实际需要的数量
        int trueDepartmentExpertNum = (int)Math.ceil(totalNum * 1.0 / 3);
        int trueProjectExpertNum = totalNum - trueDepartmentExpertNum;
        if(departmentExpertNum != trueDepartmentExpertNum || projectExpertNum != trueProjectExpertNum){
            return CommonResponse.error("所选专家数量不符合要求！" +
                    "集团专家" + trueDepartmentExpertNum + "个," +
                    "项目专家" + trueProjectExpertNum + "个！",false);
        }
        return CommonResponse.success("专家选取成功！",true);
    }



}
