package com.ejianc.business.tender.rent.service.impl;

import com.ejianc.business.tender.rent.vo.RentDocumentVO;
import com.ejianc.business.tender.rent.vo.RentTalkRecordVO;
import com.ejianc.business.tender.rent.bean.RentTalkRecordEntity;
import com.ejianc.business.tender.rent.mapper.RentTalkRecordMapper;
import com.ejianc.business.tender.rent.service.IRentDocumentService;
import com.ejianc.business.tender.rent.service.IRentTalkRecordService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 洽商谈判记录主表
 * 
 * @author generator
 * 
 */
@Service("rentTalkRecordService")
public class RentTalkRecordServiceImpl extends BaseServiceImpl<RentTalkRecordMapper, RentTalkRecordEntity> implements IRentTalkRecordService {
    @Autowired
    private IRentDocumentService rentDocumentService;
    @Override
    public RentTalkRecordVO queryDetail(Long id) {
        RentTalkRecordEntity rentTalkRecordEntity = super.selectById(id);
        RentTalkRecordVO rentTalkRecordVO = BeanMapper.map(rentTalkRecordEntity, RentTalkRecordVO.class);

        //确认轮数
        Integer talkNum = rentTalkRecordVO.getTalkNum();
        RentDocumentVO rentDocumentVO = rentDocumentService.queryDocDetail(rentTalkRecordVO.getBillId(), talkNum);
        rentTalkRecordVO.setRentDocumentDetailSellList(rentDocumentVO.getRentDocumentDetailSellList());
        rentTalkRecordVO.setRentDocumentSupplierSchemeList(rentDocumentVO.getRentDocumentSupplierSchemeList());

        return rentTalkRecordVO;
    }
}
