package com.ejianc.business.tender.stuff.mapper;

import com.ejianc.business.tender.stuff.vo.StuffInviteDetailBidderVO;
import com.ejianc.business.tender.stuff.vo.StuffInviteDetailVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.tender.stuff.bean.StuffInviteEntity;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
 * 材料立项主表
 * 
 * @author generator
 * 
 */
@Mapper
public interface StuffInviteMapper extends BaseCrudMapper<StuffInviteEntity> {
    @Update("UPDATE ejc_tender_stuff_invite SET tender_stage = #{tenderStage} WHERE id = #{id} ")
    void updateTenderStage(String id, int tenderStage);
    @Update("UPDATE ejc_tender_stuff_invite SET abolish_type = #{abolishType} WHERE id = #{id} ")
    void updateAbolishType(String id, int abolishType);
    @Select("SELECT *,sum(num) sum_num,sum(money_tax) sum_money_tax,sum(money) sum_money,SUM(plan_num) sum_plan_num,GROUP_CONCAT(memo) sum_memo  FROM `ejc_tender_stuff_invite_detail_record` " +
            "where invite_id = #{inviteId} and dr = 0 GROUP BY material_id ,material_type_id,rate,detail_project_id,calculate_type")
    List<StuffInviteDetailVO> selectSumDetail(Long inviteId);
    @Select("SELECT *,sum(num) sum_num,sum(money_tax) sum_money_tax,sum(money) sum_money,SUM(plan_num) sum_plan_num,GROUP_CONCAT(memo) sum_memo  FROM `ejc_tender_stuff_invite_detail_record` " +
            "where invite_id = #{inviteId} and dr = 0 GROUP BY material_id ,material_type_id,rate,detail_org_id,calculate_type")
    List<StuffInviteDetailVO> selectOrgSumDetail(Long inviteId);
//    @Select("SELECT c.*,sum( tax_money ) sum_tax_money,sum(money) sum_money FROM(SELECT a.price,sum( a.tax_money ) tax_money,sum(a.money) money,b.detail_project_id project_id,b.detail_project_name project_name,b.detail_org_id org_id,b.detail_org_name org_name,a.supplier_id,a.supplier_name  FROM `ejc_tender_stuff_invite_detail_bidder` a INNER JOIN ( SELECT * FROM `ejc_tender_stuff_invite_detail_record` WHERE invite_id = #{inviteId} ) b ON a.invite_detail_id = b.id  GROUP BY b.detail_project_id,a.supplier_id ) c " +
//            "GROUP BY c.project_id")
//    List<StuffInviteDetailBidderVO> selectDetailBidder(Long billId);
    @Select("SELECT c.*,sum( c.tax_money ) sum_tax_money,sum( c.money ) sum_money,sum( c.num ) sum_num FROM  (SELECT a.*,b.detail_project_id,b.detail_project_name,b.detail_org_id,b.detail_org_name FROM  `ejc_tender_stuff_invite_detail_bidder` a LEFT join ejc_tender_stuff_invite_detail_record b on a.invite_detail_id = b.id WHERE a.invite_id = #{inviteId}) c  GROUP BY c.supplier_id,c.detail_project_id")
    List<StuffInviteDetailBidderVO> selectDetailBidder(Long inviteId);

    @Update("UPDATE ejc_tender_stuff_invite SET is_push_zcw = #{tenderStage}, zcw_code = #{zcwCode} WHERE id = #{id} ")
    void updateIsPushZcw(String id, int tenderStage,String zcwCode);
}
