package com.ejianc.business.tender.report.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.consts.SpecialityIdEnum;
import com.ejianc.business.bid.vo.UndertakeApiVO;
import com.ejianc.business.tender.cost.vo.SupbidNoticeVO;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteVO;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.report.mapper.ReportMapper;
import com.ejianc.business.tender.report.service.IReportService;
import com.ejianc.business.tender.report.vo.BidDataVO;
import com.ejianc.business.tender.report.vo.ReportVO;
import com.ejianc.business.tender.report.vo.SupplierReportVO;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.stuff.vo.TenderStageEnum;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.util.MathUtil;
import com.ejianc.business.tender.util.MyDateUtil;
import com.ejianc.business.tender.util.TenderTypeUrlEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import io.swagger.models.auth.In;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;


/**
 * 流程表
 *
 * @author generator
 */
@Controller
@RequestMapping("report")
public class ReportController implements Serializable {
    private static final long serialVersionUID = 1L;

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IReportService service;

    @Autowired
    private ReportMapper reportMapper;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("tenderName");
        fuzzyFields.add("tenderUnit");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));


        if (param.getParams().containsKey("isBid")){
            String isBid = (String)param.getParams().get("isBid").getValue();
            if ("1".equals(isBid)){
                param.getParams().put("tax_money", new Parameter(QueryParam.SQL, "taxMoney is not null"));
            }
            param.getParams().remove("isBid");
        }

        Map<String, Object> map = service.queryData(param);
        IPage<ReportVO> page = (IPage<ReportVO>) map.get("page");
        BigDecimal sumTaxMoney = (BigDecimal) map.get("sumTaxMoney");

//        IPage<ReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReportVO.class));


        for (ReportVO record : page.getRecords()) {
            if(record.getTenderTypeName() != null){
                switch (record.getTenderTypeName()) {
                    case "0":
                        record.setTenderTypeName("平台公开招标");
                        break;
                    case "1":
                        record.setTenderTypeName("邀请招标");
                        break;
                    case "2":
                        record.setTenderTypeName("询价");
                        break;
                    case "3":
                        record.setTenderTypeName("竞争性谈判");
                        break;
                    case "4":
                        record.setTenderTypeName("单一来源");
                        break;
                    case "5":
                        record.setTenderTypeName("紧急招标");
                        break;
                }
            }

            record.setEstablishTypeName(record.getEstablishType() == 0 ? "招标立项" : "定标立项");
            record.setPurchaseTypeName(record.getPurchaseType() == 0 ? "项目采购" : "单位采购");
            record.setTenderStageName(TenderStageEnum.getEnumByStateCode(record.getTenderStage()).getDescription());
            String tenderUnit = record.getTenderUnit();
            if (null != tenderUnit) {
                record.setTenderUnit(ClearBracket(tenderUnit));
            }
            if (record.getEstablishType() == 1) {
                record.setPicketageTime(record.getCreateDate());
                if (record.getLineTypeName().equals("专业分包") || record.getLineTypeName().equals("劳务分包")) {
                    record.setTaxMoney(record.getTenderMoney());
                }
                else {
                    record.setTaxMoney(record.getTaxMoney());
                }
            }
        if (record.getInviteId() != null) {
            QueryParam param1 = new QueryParam();

            param1.getParams().put("invite_id", new Parameter(QueryParam.EQ, record.getInviteId()));
            BigDecimal bigDecimal = service.queryReduceCostRate(param1);
            record.setReduceCostRate(bigDecimal);
        }
        }

        com.alibaba.fastjson.JSONObject pageData = new com.alibaba.fastjson.JSONObject();
        pageData.put("records", BeanMapper.mapList(page.getRecords(), ReportVO.class));
        pageData.put("total", page.getTotal());
        pageData.put("current", page.getCurrent());
        pageData.put("size", page.getSize());
        pageData.put("pages", page.getPages());
        pageData.put("sumTaxMoney", sumTaxMoney);

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("tenderName");
        fuzzyFields.add("tenderUnit");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        Map<String, Object> map = service.queryData(param);
        IPage<ReportVO> page = (IPage<ReportVO>) map.get("page");

        IPage<ReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReportVO.class));
        for (ReportVO record : pageData.getRecords()) {
            if (record.getTenderTypeName() != null) {
                switch (record.getTenderTypeName()) {
                    case "0":
                        record.setTenderTypeName("平台公开招标");
                        break;
                    case "1":
                        record.setTenderTypeName("邀请招标");
                        break;
                    case "2":
                        record.setTenderTypeName("询价");
                        break;
                    case "3":
                        record.setTenderTypeName("竞争性谈判");
                        break;
                    case "4":
                        record.setTenderTypeName("单一来源");
                        break;
                    case "5":
                        record.setTenderTypeName("紧急招标");
                        break;
                }
            }else {
            record.setTenderTypeName("定标立项");
        }
            record.setEstablishTypeName(record.getEstablishType() == 0 ? "招标立项" : "定标立项");
            record.setPurchaseTypeName(record.getPurchaseType() == 0 ? "项目采购" : "单位采购");
            record.setTenderStageName(TenderStageEnum.getEnumByStateCode(record.getTenderStage()).getDescription());
            String tenderUnit = record.getTenderUnit();
            if (null != tenderUnit) {
                record.setTenderUnit(ClearBracket(tenderUnit));
            }
            if (record.getEstablishType() == 1) {
                record.setPicketageTime(record.getCreateDate());
                if (record.getLineTypeName().equals("分包招标")) {
                    record.setTaxMoney(record.getTenderMoney());
                }
                else {
                    record.setTaxMoney(record.getTaxMoney());
                }
            }
        }
        logger.info("招标统计导出前:{}", JSONObject.toJSONString(pageData.getRecords()));

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", pageData.getRecords());
        ExcelExport.getInstance().export("report.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description querySupplierReportList 供应商统计 投标统计列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/querySupplierReportList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SupplierReportVO>> querySupplierReportList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        List<Long> orgIdList = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());

        //IPage<SupplierReportVO> page = service.queryData(param);
        IPage<SupplierReportVO> page = new Page<>();
        if (param.getParams().containsKey("supplierId")) {
            Parameter obj = param.getParams().get("supplierId");
            Long supplierId = Long.valueOf(String.valueOf(obj.getValue())).longValue();
            param.getParams().remove("supplierId");
            page = service.querySupplierReportData(param, supplierId);
            param.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierId));
        }

        IPage<SupplierReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierReportVO.class));
        for (SupplierReportVO record : pageData.getRecords()) {
            switch (record.getTenderTypeName()) {
                case "0":
                    record.setTenderTypeName("平台公开招标");
                    break;
                case "1":
                    record.setTenderTypeName("邀请招标");
                    break;
                case "2":
                    record.setTenderTypeName("询价");
                    break;
                case "3":
                    record.setTenderTypeName("竞争性谈判");
                    break;
                case "4":
                    record.setTenderTypeName("单一来源");
                    break;
                case "5":
                    record.setTenderTypeName("紧急招标");
                    break;
            }
            //判断当前组织是否属于组织本下，否则把金额置为******
            if (!orgIdList.contains(record.getOrgId())) {
                record.setTenderMoney("******");
                record.setTaxMoney("******");
                record.setClickable(false);
            }
            else {
                record.setClickable(true);
            }
            //穿透地址
            if (!"".equals(record.getLineTypeName()) && record.getLineTypeName() != null) {
                if (record.getEstablishType() == 1) {
                    record.setUrl(TenderTypeUrlEnum.getUrl(record.getLineTypeName()) + "/dbcard?id=" + record.getInviteId());
                }
                else {
                    record.setUrl(TenderTypeUrlEnum.getUrl(record.getLineTypeName()) + "/card?id=" + record.getInviteId());
                }
            }

            record.setEstablishTypeName(record.getEstablishType() == 0 ? "招标立项" : "定标立项");
            record.setPurchaseTypeName(record.getPurchaseType() == 0 ? "项目采购" : "单位采购");
            record.setTenderStageName(TenderStageEnum.getEnumByStateCode(record.getTenderStage()).getDescription());
            String tenderUnit = record.getTenderUnit();
            if (!"".equals(tenderUnit) && tenderUnit != null && tenderUnit.indexOf("(") != -1 && tenderUnit.indexOf(")") != -1) {
                record.setTenderUnit(ClearBracket(tenderUnit));
            }
            if (record.getEstablishType() == 1) {
                record.setPicketageTime(record.getCreateDate());
                if (record.getLineTypeName().equals("分包招标")) {
                    record.setTaxMoney(record.getTenderMoney());
                }
                else {
                    record.setTaxMoney(record.getTaxMoney());
                }
            }
        }
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @ApiOperation("投标统计列表导出")
    @RequestMapping(value = "/supplierReportExport", method = RequestMethod.POST)
    @ResponseBody
    public void supplierReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        List<Long> orgIdList = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());

        IPage<SupplierReportVO> page = new Page<>();
        if (param.getParams().containsKey("supplierId")) {
            Parameter obj = param.getParams().get("supplierId");
            Long supplierId = Long.valueOf(String.valueOf(obj)).longValue();
            param.getParams().remove("supplierId");
            page = service.querySupplierReportData(param, supplierId);
            param.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierId));
        }

        IPage<SupplierReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierReportVO.class));
        for (SupplierReportVO record : pageData.getRecords()) {
            if(record.getTenderTypeName() != null) {
                switch (record.getTenderTypeName()) {
                    case "0":
                        record.setTenderTypeName("平台公开招标");
                        break;
                    case "1":
                        record.setTenderTypeName("邀请招标");
                        break;
                    case "2":
                        record.setTenderTypeName("询价");
                        break;
                    case "3":
                        record.setTenderTypeName("竞争性谈判");
                        break;
                    case "4":
                        record.setTenderTypeName("单一来源");
                        break;
                    case "5":
                        record.setTenderTypeName("紧急招标");
                        break;
                }
            }else {
                record.setTenderTypeName("定标立项");
            }
            //判断当前组织是否属于组织本下，否则把金额置为******
            if (!orgIdList.contains(record.getOrgId())) {
                record.setTenderMoney("******");
                record.setTaxMoney("******");
            }
            record.setEstablishTypeName(record.getEstablishType() == 0 ? "招标立项" : "定标立项");
            record.setPurchaseTypeName(record.getPurchaseType() == 0 ? "项目采购" : "单位采购");
            record.setTenderStageName(TenderStageEnum.getEnumByStateCode(record.getTenderStage()).getDescription());
            String tenderUnit = record.getTenderUnit();
            if (!"".equals(tenderUnit) && tenderUnit != null && tenderUnit.indexOf("(") != -1 && tenderUnit.indexOf(")") != -1) {
                record.setTenderUnit(ClearBracket(tenderUnit));
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", pageData.getRecords());
        ExcelExport.getInstance().export("report.xlsx", beans, response);
    }

    private static String ClearBracket(String context) {
        context = context.replaceAll(",", "");
        // 修改原来的逻辑，防止右括号出现在左括号前面的位置
        int head = context.indexOf('('); // 标记第一个使用左括号的位置
        if (head == -1) {
            return context; // 如果context中不存在括号，什么也不做，直接跑到函数底端返回初值str
        }
        else {
            int next = head + 1; // 从head+1起检查每个字符
            int count = 1; // 记录括号情况
            do {
                if (context.charAt(next) == '(') {
                    count++;
                }
                else if (context.charAt(next) == ')') {
                    count--;
                }
                next++; // 更新即将读取的下一个字符的位置
                if (count == 0) { // 已经找到匹配的括号
                    String temp = context.substring(head, next);
                    context = context.replace(temp, ","); // 用空内容替换，复制给context
                    head = context.indexOf('('); // 找寻下一个左括号
                    next = head + 1; // 标记下一个左括号后的字符位置
                    count = 1; // count的值还原成1
                }
            } while (head != -1); // 如果在该段落中找不到左括号了，就终止循环
        }
        return context.substring(0, context.lastIndexOf(",")); // 返回更新后的context

    }

    /**
     * 门户招标数据查询
     */
    @RequestMapping(value = "/queryBidData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map> queryBidData(Long orgId) throws ParseException {
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        if (orgId != null) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        else {
            /** 数据隔离 本下 没有组织orgId的删除下面代码 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        Map map = service.queryBidData(param);

        return CommonResponse.success("查询招标统计成功", map);
    }

    public BigDecimal queryMoney(Integer tenderType, String tenderTypeName, String firstDayOfMonth, String lastDayOfMonth) {
        return service.queryMoney(tenderType, tenderTypeName, firstDayOfMonth, lastDayOfMonth);
    }



    /**
     * @Description queryTenderMaterialAmountProportion 物资品类金额占比
     * @param
     */
    @RequestMapping(value = "/queryTenderMaterialAmountProportion", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SupbidNoticeVO>> queryTenderMaterialAmountProportion(Integer year) {
        if (year == null){
            Calendar cal = Calendar.getInstance();
            year = cal.get(Calendar.YEAR);
        }
        List<SupbidNoticeVO> supbidNoticeVOS = service.queryTenderMaterialAmountProportion(year);

        return CommonResponse.success("查询详情数据成功！",supbidNoticeVOS);
    }


    /**
     * @Description queryTenderMaterialAmountProportion 物资类招标结果趋势图
     * @param
     */
    @RequestMapping(value = "/queryTenderResultTrend", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryTenderResultTrend(Integer year) {
        if (year == null){
            Calendar cal = Calendar.getInstance();
            year = cal.get(Calendar.YEAR);
        }
        List<SupbidNoticeVO> supbidNoticeVOS = service.queryTenderResultTrend(year);

        List<String> money = supbidNoticeVOS.stream().map(SupbidNoticeVO::getMoney).collect(Collectors.toList());
        List<Integer> num = supbidNoticeVOS.stream().map(SupbidNoticeVO::getNum).collect(Collectors.toList());
        List<String> type = supbidNoticeVOS.stream().map(SupbidNoticeVO::getType).collect(Collectors.toList());

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("money",money);
        jsonObject.put("num",num);
        jsonObject.put("date",type);

        return CommonResponse.success("查询详情数据成功！",jsonObject);
    }


    /**
     * @Description queryWinbidMoneyTop6 中标金额单位排名
     * @param
     */
    @RequestMapping(value = "/queryWinbidMoneyTop6", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SupbidNoticeVO>> queryWinbidMoneyTop6(Integer year) {
        if (year == null){
            Calendar cal = Calendar.getInstance();
            year = cal.get(Calendar.YEAR);
        }
        List<SupbidNoticeVO> supbidNoticeVOS = service.queryWinbidMoneyTop6(year);

        return CommonResponse.success("查询详情数据成功！",supbidNoticeVOS);
    }

    /**
     * @Description queryPicketageMoneyProportion 招采各类定标金额占比
     * @param
     */
    @RequestMapping(value = "/queryPicketageMoneyProportion", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SupbidNoticeVO>> queryPicketageMoneyProportion(Integer year) {
        if (year == null){
            Calendar cal = Calendar.getInstance();
            year = cal.get(Calendar.YEAR);
        }
        List<SupbidNoticeVO> supbidNoticeVOS = service.queryPicketageMoneyProportion(year);

        return CommonResponse.success("查询详情数据成功！",supbidNoticeVOS);
    }


    /**
     * @param time 1：月度  2：季度  3：年度
     *      *             type 0数量纬度（不显示补充协议） 1金额维度（显示补充协议）
     * @Description queryList 工程成本门户获取饼状图
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryTenderPieChart", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<UndertakeApiVO>> queryTenderPieChart(Integer time) {
        QueryParam param = new QueryParam();
        param.setPageSize(100);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        param.getParams().put("tax_money", new Parameter(QueryParam.SQL, "taxMoney is not null"));
        /** ywDate */
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate nowDate = LocalDate.now();

        if (time != null && time == 0) {
            param.getParams().put("createDate", new Parameter(QueryParam.BETWEEN,
                    MyDateUtil.getFromThisYearStartTime(nowDate,dateTimeFormatter) +","+ MyDateUtil.getFromThisYearEndTime(nowDate,dateTimeFormatter)));
        }
        Map<String, Object> map = service.queryData(param);
        IPage<ReportVO> page = (IPage<ReportVO>) map.get("page");
        List<ReportVO> records = page.getRecords();

        ArrayList<UndertakeApiVO> undertakeApiVOS = new ArrayList<>();

        UndertakeApiVO vo1 = new UndertakeApiVO(1L,"公开招标",new BigDecimal(0.00),0);//

        UndertakeApiVO vo2 = new UndertakeApiVO(2L,"直接定标",new BigDecimal(0.00),0);//

        UndertakeApiVO vo3 = new UndertakeApiVO(3L,"其他类型",new BigDecimal(0.00),0);//

        //金额\数量
        for (ReportVO vo : records){
            if (vo.getEstablishType() == 0){//招标立项
                if ("0".equals(vo.getTenderTypeName())){
                    vo1.setSum(vo1.getSum()+1);
                    vo1.setValue(vo.getTaxMoney().add( vo1.getValue()));
                    //vo1.setValue(vo.getTaxMoney().multiply(new BigDecimal(10000)));
                }else {
                    vo3.setSum(vo3.getSum()+1);
                    vo3.setValue(vo.getTaxMoney().add( vo3.getValue()));
                }
            }else{//定标立项
                vo2.setSum(vo2.getSum()+1);
                vo2.setValue(vo.getTaxMoney().add( vo2.getValue()));
            }
        }

        undertakeApiVOS.add(vo1);
        undertakeApiVOS.add(vo2);
        undertakeApiVOS.add(vo3);
        return CommonResponse.success("查询列表数据成功！",undertakeApiVOS);
    }
    /**
     * @param
     * @Description queryList 招采平均时长
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryTenderAvgTime", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryTenderAvgTime() {
        //List<Long> orgList = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());

        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate nowDate = LocalDate.now();
        //获取年度平均时间
        BigDecimal yearAvgTime = reportMapper.queryTenderAvgTime(MyDateUtil.getFromThisYearStartTime(nowDate, dateTimeFormatter),
                MyDateUtil.getFromThisYearEndTime(nowDate, dateTimeFormatter),InvocationInfoProxy.getOrgId());
        //获取开工累计平均时间
        BigDecimal avgTime = reportMapper.queryTenderAvgTime("2022-01-01",
                MyDateUtil.getFromThisYearEndTime(nowDate, dateTimeFormatter),InvocationInfoProxy.getOrgId());

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("avgTime",avgTime);
        jsonObject.put("yearAvgTime",yearAvgTime);

        return CommonResponse.success("查询列表数据成功！",jsonObject);
    }


    /**
     * 物资供应商榜单  @RequestBody QueryParam param
     * @param param
     * @return
     */
    @RequestMapping(value = "/tenderSupplierRank", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SupbidNoticeVO>> tenderSupplierRank(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<SupbidNoticeVO> supbidNoticeVOIPage = service.tenderSupplierRank(param);

        return CommonResponse.success("查询详情数据成功！",supbidNoticeVOIPage);
    }
    /**
     * 专业分包供应商榜单  @RequestBody QueryParam param
     * @param param
     * @return
     */
    @RequestMapping(value = "/tenderSupplierRankProsub", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SupbidNoticeVO>> tenderSupplierRankProsub(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<SupbidNoticeVO> supbidNoticeVOIPage = service.tenderSupplierRankProsub(param);

        return CommonResponse.success("查询详情数据成功！",supbidNoticeVOIPage);
    }

    /**
     * @Description queryPicketageMoneyProportion 招采各类定标金额以及数量
     * @param
     */
    @RequestMapping(value = "/queryPicketageMoneyProportionNew", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SupbidNoticeVO>> queryPicketageMoneyProportionNew(@RequestParam("time") String time) {

        List<SupbidNoticeVO> supbidNoticeVOS = service.queryPicketageMoneyProportionNew(time);

        return CommonResponse.success("查询详情数据成功！",supbidNoticeVOS);
    }




    /**
     * @Description Rate of reduce the cost 项目降本率计算
     * @param
     */
    @RequestMapping(value = "/queryReduceCostRate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> queryReduceCostRate(@RequestParam(required = false) Long projectId) {
        QueryParam param = new QueryParam();
        if (projectId != null) {
            param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }
        BigDecimal bigDecimal = service.queryReduceCostRate(param);

        return CommonResponse.success("查询详情数据成功！",bigDecimal);
    }


}
