package com.ejianc.business.tender.rmat.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rmat.bean.RmatAdviceEntity;
import com.ejianc.business.tender.rmat.bean.RmatBidEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.service.IRmatBidService;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.rmat.vo.RmatAdviceSupplierPushVO;
import com.ejianc.business.tender.rmat.vo.RmatAdviceVO;
import com.ejianc.business.tender.stuff.bean.StuffAdviceEntity;
import com.ejianc.business.tender.stuff.bean.StuffBidEntity;
import com.ejianc.business.tender.stuff.service.IStuffAdviceService;
import com.ejianc.business.tender.stuff.service.IStuffBidService;
import com.ejianc.business.tender.stuff.vo.StuffAdviceVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tender.rmat.mapper.RmatAdviceMapper;
import com.ejianc.business.tender.rmat.bean.RmatAdviceEntity;
import com.ejianc.business.tender.rmat.service.IRmatAdviceService;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 周转材-中标通知书
 * 
 * @author generator
 * 
 */
@Service("rmatAdviceService")
public class RmatAdviceServiceImpl extends BaseServiceImpl<RmatAdviceMapper, RmatAdviceEntity> implements IRmatAdviceService{
    @Autowired
    private IRmatInviteService rmatInviteService;
    @Autowired
    private IStuffAdviceService stuffAdviceService;
    private final String PUSH_ADVICE_SERVER_URL = "/ejc-supbid-web/openapi/bid/saveBid";
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String BILL_TYPE = "BT220317000000005";//此处需要根据实际修改
    @Autowired
    private IRmatBidService rmatBidService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;
    @Override
    public CommonResponse<String> changeStatus(Long billId, int status, String refCode) {
        //status   发起:3,  甲方-4  已签章
        //签章状态 未签章 -0,待签章-1,已签章-2
        RmatAdviceEntity rmatAdviceEntity = super.selectById(billId);
        if(status == 5 || status == 6 || status == 7 || status == 8){
            rmatAdviceEntity.setSignFlag(0);
        }
        if(status == 2 || status == 3){
            rmatAdviceEntity.setSignFlag(1);
        }
        if(status == 4){
            rmatAdviceEntity.setSignFlag(2);
            // 先同步签章附件
            ContractVO cv = new ContractVO();
            cv.setContractId(rmatAdviceEntity.getId());
            cv.setContractName(rmatAdviceEntity.getTitleName());
            cv.setBillType(BILL_TYPE);
            cv.setSourceType("tenderAdvice");
            ArrayList<ContractVO> cvs = new ArrayList<>();
            cvs.add(cv);

            CommonResponse<List<SignMgrPreviewVO>> signResp = signatureCommonApi.fetchSignedContract(cvs);
            if(!signResp.isSuccess()){
                throw new BusinessException("同步签章附件失败!");
            }
        }
        super.updateById(rmatAdviceEntity);

        return CommonResponse.success("更新成功!");
    }

    @Override
    @Transactional
    public String sendAdvice(Long id) {
        RmatAdviceEntity rmatAdviceEntity = super.selectById(id);
        rmatAdviceEntity.setSendFlag(0);
        super.updateById(rmatAdviceEntity);
        RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(rmatAdviceEntity.getInviteId());
        RmatAdviceSupplierPushVO rmatAdviceSupplierPushVO = BeanMapper.map(rmatAdviceEntity, RmatAdviceSupplierPushVO.class);

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            throw new BusinessException("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
        }
        //设置当前系统ID
        rmatAdviceSupplierPushVO.setSystemId(ejcCloudSystemCode.getData());
        rmatAdviceSupplierPushVO.setSourceType("郑州一建材料中标通知书");
        rmatAdviceSupplierPushVO.setSourceId(rmatAdviceEntity.getId().toString());
        rmatAdviceSupplierPushVO.setBidTitle(rmatAdviceEntity.getTitleName());
        rmatAdviceSupplierPushVO.setSourceProjectId(rmatAdviceEntity.getProjectId() != null ? rmatAdviceEntity.getProjectId().toString() : null);
        rmatAdviceSupplierPushVO.setSourceOrgId(rmatAdviceEntity.getOrgId().toString());
        rmatAdviceSupplierPushVO.setSourceUnitId(rmatAdviceEntity.getUnitId().toString());
//        rmatAdviceSupplierPushVO.setType("TYPE_MATERIAL");
        rmatAdviceSupplierPushVO.setType(CommonUtils.getGysType(CommonUtils.TYPE_RMAT));
        rmatAdviceSupplierPushVO.setTenderType(rmatInviteEntity.getTenderType());
        rmatAdviceSupplierPushVO.setBidDate(rmatAdviceEntity.getNoticeDate());
        rmatAdviceSupplierPushVO.setMoney(rmatAdviceEntity.getMoney());
        rmatAdviceSupplierPushVO.setMoneyTax(rmatAdviceEntity.getMoneyTax());

        String dataInfo = JSONObject.toJSONString(rmatAdviceSupplierPushVO);

        boolean b = stuffAdviceService.pushBillToSupCenter(dataInfo, rmatAdviceEntity.getSupplierId(), rmatAdviceEntity.getId(),
                BILL_TYPE, PUSH_ADVICE_SERVER_URL,rmatAdviceEntity.getTitleName());
        if (!b){
            throw new BusinessException("推送供方失败!");
        }
        return null;
    }

    @Override
    public List<RmatAdviceVO> queryAdviceList(Long id) {
        RmatBidEntity rmatBidEntity = rmatBidService.selectById(id);
        LambdaQueryWrapper<RmatAdviceEntity> lambdaAdvice = Wrappers.<RmatAdviceEntity>lambdaQuery();
        lambdaAdvice.eq(RmatAdviceEntity::getInviteId, rmatBidEntity.getInviteId());
        List<RmatAdviceEntity> list = super.list(lambdaAdvice);
        List<RmatAdviceVO> rmatAdviceVOS = BeanMapper.mapList(list, RmatAdviceVO.class);
        //处理签章附件信息
        if (CollectionUtils.isNotEmpty(rmatAdviceVOS)) {
            List<Long> attachIds = rmatAdviceVOS.stream().map(RmatAdviceVO::getId).collect(Collectors.toList());
            Map<String, List<Long>> map = new HashMap<>();
            map.put("sourceIds", attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess()) {
                List<AttachmentVO> data = listCommonResponse.getData();
                if (CollectionUtils.isNotEmpty(data)) {
                    Map<Long, AttachmentVO> attacMap = data.stream().filter(s -> s.getSourceType().equals("tenderAdvice")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                    for (RmatAdviceVO rmatAdviceVO : rmatAdviceVOS) {
                        AttachmentVO attachmentVO = attacMap.get(rmatAdviceVO.getId());
                        if (attachmentVO != null) {
                            rmatAdviceVO.setAttachId(attachmentVO.getId());
                            rmatAdviceVO.setFileName(attachmentVO.getFileName());
                            rmatAdviceVO.setFilePath(attachmentVO.getFilePath());
                        }
                    }
                }
            }
        }
        return rmatAdviceVOS;
    }
}
