package com.ejianc.business.tender.stuff.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.rmat.bean.RmatDocumentSupplierEntity;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.stuff.service.*;
import com.ejianc.business.tender.stuff.vo.StuffDocumentSellVO;
import com.ejianc.business.tender.stuff.vo.StuffPicketageRefsupplierVO;
import com.ejianc.business.tender.stuff.service.impl.StuffPicketageBpmServiceImpl;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 定标供应商参照表(下游单据使用)
 *
 * @author generator
 */
@Controller
@RequestMapping("stuffPicketageRefsupplier")
@Api(value = "定标供应商参照表(下游单据使用)", tags = {"定标供应商参照表(下游单据使用)"})
public class StuffPicketageRefsupplierController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IStuffPicketageService stuffPicketageService;
    @Autowired
    private IStuffDocumentSellService stuffDocumentSellService;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private StuffPicketageBpmServiceImpl stuffPicketageBpmService;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IStuffInviteDetailBidderService bidderService;
    @Autowired
    private IStuffInviteDetailRecordService recordService;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IStuffPicketageRefsupplierService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StuffPicketageRefsupplierVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody StuffPicketageRefsupplierVO saveOrUpdateVO) {
        StuffPicketageRefsupplierEntity entity = BeanMapper.map(saveOrUpdateVO, StuffPicketageRefsupplierEntity.class);
        service.saveOrUpdate(entity, false);
        StuffPicketageRefsupplierVO vo = BeanMapper.map(entity, StuffPicketageRefsupplierVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffPicketageRefsupplierVO> queryDetail(@RequestParam Long id) {
        StuffPicketageRefsupplierEntity entity = service.selectById(id);
        StuffPicketageRefsupplierVO vo = BeanMapper.map(entity, StuffPicketageRefsupplierVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refStuffsupplierData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<StuffPicketageRefsupplierVO>> refStuffsupplierData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                   String condition,
                                                                                   String searchObject,
                                                                                   String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("picketageName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //未占用状态
//        param.getParams().put("occupyFlag", new Parameter(QueryParam.EQ, 0));
        param.getOrderMap().put("picketageDate", QueryParam.DESC);
        //查询本下范围内日的合同
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        if(CollectionUtils.isNotEmpty(orgVOList)) {
            List<Long> ids = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, ids));
        }
        if(StringUtils.isNotEmpty(condition)){
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("purchaseType")) {
                Integer purchaseType = Integer.parseInt(conditionMap.get("purchaseType").toString());
                param.getParams().put("purchaseType", new Parameter(QueryParam.EQ, purchaseType));
            }
        }

        List<Integer> listStatus = new ArrayList<>();
        listStatus.add(TenderSignStatusEnum.未签订.getCode());
        listStatus.add(TenderSignStatusEnum.部分签订.getCode());

        param.getParams().put("signStatus", new Parameter(QueryParam.IN, listStatus));
        IPage<StuffPicketageRefsupplierVO> page = service.picketageRef(param);
//        IPage<StuffPicketageRefsupplierEntity> page = service.queryPage(param,false);
        IPage<StuffPicketageRefsupplierVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<StuffPicketageRefsupplierVO> records = page.getRecords();
        if (CollectionUtils.isNotEmpty(records)) {
            for (StuffPicketageRefsupplierVO stuffPicketageRefsupplierVO : records) {
                if (stuffPicketageRefsupplierVO.getPurchaseType() == 0) {
//                    (0-项目采购,1-单位采购)
                    stuffPicketageRefsupplierVO.setPurchaseTypeName("项目采购");
                }
                if (stuffPicketageRefsupplierVO.getPurchaseType() == 1) {
//                    (0-项目采购,1-单位采购)
                    stuffPicketageRefsupplierVO.setPurchaseTypeName("公司采购");
                }

            }

        }
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), StuffPicketageRefsupplierVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @ApiOperation("定标子表参照")
    @RequestMapping(value = "/refStuffDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<StuffDocumentSellVO>> refStuffDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Long id = null;

        if (StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("id")) {
                id = Long.valueOf(conditionMap.get("id").toString());
            }
        }
        StuffPicketageRefsupplierEntity stuffPicketageRefsupplierEntity = service.selectById(id);
        Integer picketageFlag = stuffPicketageRefsupplierEntity.getPicketageFlag();
        //定标类型0-流程定标,1-直接定标  区分数据源
        if (picketageFlag == 0) {
            StuffPicketageEntity stuffPicketageEntity = stuffPicketageService.selectById(stuffPicketageRefsupplierEntity.getPicketageId());
            param.getParams().put("documentId", new Parameter(QueryParam.EQ, stuffPicketageEntity.getDocumentId()));
            param.getParams().put("supplierId", new Parameter(QueryParam.EQ, stuffPicketageRefsupplierEntity.getSupplierId()));
            param.getParams().put("projectId", new Parameter(QueryParam.EQ, stuffPicketageRefsupplierEntity.getProjectId()));
            param.getParams().put("tenderFlag", new Parameter(QueryParam.EQ, 1));
            param.getParams().put("nums", new Parameter(QueryParam.SQL, "ifnull(sign_num,0) < tender_num"));
            IPage<StuffDocumentSellEntity> page = stuffDocumentSellService.queryPage(param, false);
            IPage<StuffDocumentSellVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            List<StuffDocumentSellVO> stuffDocumentSellVOList = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(page.getRecords())) {
                stuffDocumentSellVOList = BeanMapper.mapList(page.getRecords(), StuffDocumentSellVO.class);
                for (StuffDocumentSellVO stuffDocumentSellVO : stuffDocumentSellVOList) {
                    BigDecimal tenderNum = stuffDocumentSellVO.getTenderNum();
                    BigDecimal signNum = stuffDocumentSellVO.getSignNum() == null ? BigDecimal.ZERO : stuffDocumentSellVO.getSignNum();
                    stuffDocumentSellVO.setSurplusNum(tenderNum.subtract(signNum));
                }

            }
            pageData.setRecords(stuffDocumentSellVOList);
            return CommonResponse.success("查询参照数据成功！", pageData);
        }

        if (picketageFlag == 1) {
            List<StuffDocumentSellVO> stuffDocumentSellVOS = new ArrayList<>();
            List<StuffInviteDetailBidderEntity> bidderEntityList1 = bidderService.list(new QueryWrapper<StuffInviteDetailBidderEntity>()
                    .eq("invite_id", stuffPicketageRefsupplierEntity.getPicketageId())
                    .eq("supplier_id", stuffPicketageRefsupplierEntity.getSupplierId())
                    .eq("dr", 0));
            List<StuffInviteDetailBidderEntity> bidderEntityList = bidderEntityList1.stream().filter(t -> t.getNum().compareTo(t.getSignNum() == null ? BigDecimal.ZERO : t.getSignNum()) > 0).collect(Collectors.toList());
            for (StuffInviteDetailBidderEntity bidderEntity : bidderEntityList) {
                StuffDocumentSellVO stuffDocumentSellVO = new StuffDocumentSellVO();
                StuffInviteDetailRecordEntity recordEntity = recordService.selectById(bidderEntity.getInviteDetailId());
                stuffDocumentSellVO.setId(bidderEntity.getId());
                stuffDocumentSellVO.setProjectId(recordEntity.getDetailProjectId());
                stuffDocumentSellVO.setProjectName(recordEntity.getDetailProjectName());
                stuffDocumentSellVO.setMaterialId(recordEntity.getMaterialId());
                stuffDocumentSellVO.setMaterialName(recordEntity.getMaterialName());
                stuffDocumentSellVO.setMaterialCode(recordEntity.getMaterialCode());
                stuffDocumentSellVO.setMaterialTypeId(recordEntity.getMaterialTypeId());
                stuffDocumentSellVO.setMaterialTypeName(recordEntity.getMaterialTypeName());
                stuffDocumentSellVO.setUnit(recordEntity.getUnit());
                stuffDocumentSellVO.setSpec(recordEntity.getSpec());
                stuffDocumentSellVO.setDetailId(bidderEntity.getId());
                stuffDocumentSellVO.setSupplierId(bidderEntity.getSupplierId());
                stuffDocumentSellVO.setSupplierName(bidderEntity.getSupplierName());
                stuffDocumentSellVO.setBrand(bidderEntity.getBrand());
                stuffDocumentSellVO.setPrice(bidderEntity.getPrice());
                stuffDocumentSellVO.setPriceTax(bidderEntity.getTaxPrice());
                stuffDocumentSellVO.setRate(bidderEntity.getTaxBidderRate());
                stuffDocumentSellVO.setTenderNum(bidderEntity.getNum());
                stuffDocumentSellVO.setTenderMoney(bidderEntity.getMoney());
                stuffDocumentSellVO.setTenderMoneyTax(bidderEntity.getTaxMoney());
                stuffDocumentSellVO.setSellTax(bidderEntity.getTaxBidder());
                stuffDocumentSellVO.setSignNum(bidderEntity.getSignNum() == null ? BigDecimal.ZERO : bidderEntity.getSignNum());
                stuffDocumentSellVO.setSurplusNum(bidderEntity.getNum().subtract(bidderEntity.getSignNum() == null ? BigDecimal.ZERO : bidderEntity.getSignNum()));
                stuffDocumentSellVOS.add(stuffDocumentSellVO);
            }
            IPage<StuffDocumentSellVO> pageDate = new Page<>(param.getPageIndex(), param.getPageSize(), stuffDocumentSellVOS.size());
            // 进行分页处理
            pageDate.setRecords(stuffDocumentSellVOS.stream().skip((long) (param.getPageIndex() - 1) * param.getPageSize())
                    .limit(param.getPageSize()).collect(Collectors.toList()));
            return CommonResponse.success("查询参照数据成功！", pageDate);
        }
        return null;
    }
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
}
