package com.ejianc.business.tender.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.mapper.ExpertRecordMapper;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rmat.bean.RmatDocumentSellEntity;
import com.ejianc.business.tender.sub.bean.SubDocumentSellEntity;
import com.ejianc.business.tender.sub.vo.SubDocumentDetailVO;
import com.ejianc.business.tender.sub.vo.SubDocumentSellVO;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.mapper.SubDocumentSchemeMapper;
import com.ejianc.business.tender.sub.mapper.SubPicketageMapper;
import com.ejianc.business.tender.sub.service.*;
import com.ejianc.business.tender.sub.vo.*;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 定标主表
 * 
 * @author generator
 * 
 */
@Service("subPicketageService")
public class SubPicketageServiceImpl extends BaseServiceImpl<SubPicketageMapper, SubPicketageEntity> implements ISubPicketageService {
    private static final String BILL_CODE = "SUB_PICKETAGE_CODE";//此处需要根据实际修改

    @Autowired
    private IExpertEvaluatingService IExpertEvaluatingService;
    @Autowired
    private ISubInviteService subInviteService;
    @Autowired
    private ISubDocumentService subDocumentService;
    @Autowired
    private ISubDocumentSellService subDocumentSellService;
    @Autowired
    private ISubDocumentSchemeService subDocumentSchemeService;
    @Autowired
    private ISubDocumentSupplierService subDocumentSupplierService;
    @Autowired
    private SubDocumentSchemeMapper schemeMapper;
    @Autowired
    private IProcessService processService;
    @Autowired
    private ISubTalkService subTalkService;
    @Autowired
    private ISubPicketageSupplierService subPicketageSupplierService;
    @Autowired
    private ExpertRecordMapper recordMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    public SubPicketageVO savePicketage(Long evaluationId) {

        SubPicketageEntity entity = new SubPicketageEntity();

        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //转换数据
        ExpertEvaluatingEntity subEvaluationEntity = IExpertEvaluatingService.selectById(evaluationId);
        SubInviteEntity inviteEntity = subInviteService.selectById(subEvaluationEntity.getInviteId());
        SubDocumentEntity subDocumentEntity = subDocumentService.selectById(subEvaluationEntity.getDocumentId());
        entity.setPicketageName(inviteEntity.getTenderName()+"定标");
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setEmployeeId(subDocumentEntity.getEmployeeId());
        entity.setEmployeeName(subDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(subDocumentEntity.getEmployeeMobile());
        entity.setValueType(subDocumentEntity.getValueType());
        SubInviteEntity subInviteEntity = subInviteService.selectById(subDocumentEntity.getInviteId());
        entity.setDocumentId(subEvaluationEntity.getDocumentId());
        entity.setEvaluationId(subEvaluationEntity.getId());
        entity.setInviteId(subEvaluationEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(sessionManager.getUserContext().getEmployeeName());
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        entity.setTrusteesPhone(mobilePhone);
//材料-0,分包-1，设备采购-2,设备租赁-3,周转材租赁-4,其他-5
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(1));

        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());

        super.saveOrUpdate(entity, false);
        SubPicketageVO vo = BeanMapper.map(entity, SubPicketageVO.class);

        //回写招标阶段
        subInviteEntity.setTenderStage(5);
        subInviteService.updateById(subInviteEntity);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("定标");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(1);
        processEntity.setFrontendUrl("sub/picketage");
        processService.saveOrUpdate(processEntity);

        //回写方案得分
        List<SubDocumentSchemeEntity> schemeList = schemeMapper.selectSupplier(subDocumentEntity.getId());
        for (SubDocumentSchemeEntity schemeEntity : schemeList) {
            BigDecimal score  = recordMapper.selectScore(schemeEntity.getId(),schemeEntity.getSupplierId(),subDocumentEntity.getId());
            Boolean scoreBoolean = schemeMapper.updateScore(schemeEntity.getId(), schemeEntity.getSupplierId(), subDocumentEntity.getId(), score);
            if (!scoreBoolean){
                throw new BusinessException("回写方案得分失败!");
            }
        }
        return vo;
    }
    @Transactional
    @Override
    public SubPicketageVO queryDetail(Long id) {
        SubPicketageEntity subPicketageEntity = super.selectById(id);
        //查询最大轮数
        LambdaQueryWrapper<SubDocumentSupplierEntity> lambdaSupplier = Wrappers.<SubDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(SubDocumentSupplierEntity::getDocumentId, subPicketageEntity.getDocumentId());
        List<SubDocumentSupplierEntity> supplierEntityList = subDocumentSupplierService.list(lambdaSupplier);
        List<Integer> talkNumList = supplierEntityList.stream().map(SubDocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
        Integer talkNumMax = talkNumList.stream().max(Integer::compareTo).get();


        SubDocumentEntity entity = subDocumentService.selectById(subPicketageEntity.getDocumentId());
        SubDocumentVO subDocumentVO = BeanMapper.map(entity, SubDocumentVO.class);
        //按材料查看报价
        List<SubDocumentDetailVO> subDocumentDetailList = subDocumentVO.getSubDocumentDetailList();
        //获取材料明细报价
        LambdaQueryWrapper<SubDocumentSellEntity> lambdaSell = Wrappers.<SubDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(SubDocumentSellEntity::getDocumentId, subPicketageEntity.getDocumentId());
        lambdaSell.eq(SubDocumentSellEntity::getTalkNum, talkNumMax);
        lambdaSell.eq(SubDocumentSellEntity::getPassFlag, 1);
        lambdaSell.orderByAsc(SubDocumentSellEntity::getSupplierId);
        lambdaSell.orderByAsc(SubDocumentSellEntity::getSchemeName);
        List<SubDocumentSellEntity> sellList = subDocumentSellService.list(lambdaSell);
        List<SubDocumentSellVO> subDocumentSellVOS = BeanMapper.mapList(sellList, SubDocumentSellVO.class);
        //查询所有方案
        LambdaQueryWrapper<SubDocumentSchemeEntity> lambdaScheme = Wrappers.<SubDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(SubDocumentSchemeEntity::getDocumentId, subPicketageEntity.getDocumentId());
        lambdaScheme.eq(SubDocumentSchemeEntity::getTalkNum, talkNumMax);
        lambdaScheme.orderByAsc(SubDocumentSchemeEntity::getSchemeName);
        List<SubDocumentSchemeEntity> schemeList = subDocumentSchemeService.list(lambdaScheme);
        for (SubDocumentSchemeEntity subDocumentSchemeEntity : schemeList){
            for (SubDocumentSellVO subDocumentSellVO : subDocumentSellVOS){
                if (subDocumentSellVO.getSchemeId().equals(subDocumentSchemeEntity.getId())){
                    subDocumentSellVO.setScore(subDocumentSchemeEntity.getScore());
                }

            }

        }

        //排序
        SubDocumentSellVO subDocumentSellFirst = subDocumentSellVOS.stream().findFirst().get();
        if (subDocumentSellFirst.getScore() == null){
            subDocumentSellVOS.sort(Comparator.comparing(SubDocumentSellVO::getCreateTime).reversed());
        }
        if (subDocumentSellFirst.getScore() != null){
            subDocumentSellVOS.sort(Comparator.comparing(SubDocumentSellVO::getScore).reversed());
        }
        //根据物料详情主键分组
        Map<Long, List<SubDocumentSellVO>> sellMap = subDocumentSellVOS.stream().
                collect(Collectors.groupingBy(SubDocumentSellVO::getDetailId));
        for (SubDocumentDetailVO subDocumentDetailVO : subDocumentDetailList){
            List<SubDocumentSellVO> subDocumentSellEntities = sellMap.get(subDocumentDetailVO.getId());
            subDocumentDetailVO.setSubDocumentSellVOList(subDocumentSellEntities);
        }

        SubPicketageVO subPicketageVO = BeanMapper.map(subPicketageEntity, SubPicketageVO.class);
        subPicketageVO.setSubDocumentDetailList(subDocumentDetailList);
        if (subDocumentSellFirst.getScore() == null) {
            subPicketageVO.setScoreStatus(1);
        }
        if (subDocumentSellFirst.getScore() != null) {
            subPicketageVO.setScoreStatus(0);
        }
        
        return subPicketageVO;

    }

    @Override
    public SubPicketageVO saveOrUpdates(SubPicketageVO saveorUpdateVO) {
        SubPicketageEntity entity = BeanMapper.map(saveorUpdateVO, SubPicketageEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        BigDecimal money = BigDecimal.ZERO;
        BigDecimal moneyTax = BigDecimal.ZERO;
        List<SubPicketageSupplierVO> picketageSupplierListMoney = saveorUpdateVO.getPicketageSupplierList();
        for(SubPicketageSupplierVO subPicketageSupplierVO : picketageSupplierListMoney){
            money = money.add(subPicketageSupplierVO.getMoney());
            moneyTax = moneyTax.add(subPicketageSupplierVO.getMoneyTax());
        }
        entity.setMoneyTax(moneyTax);
        entity.setMoney(money);
        super.saveOrUpdate(entity,false);

        //先删后增供应商定标数据
        LambdaQueryWrapper<SubPicketageSupplierEntity> lambdaSupplier = Wrappers.<SubPicketageSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(SubPicketageSupplierEntity::getPicketageId,entity.getId());
        subPicketageSupplierService.remove(lambdaSupplier);
        List<SubPicketageSupplierVO> picketageSupplierList = saveorUpdateVO.getPicketageSupplierList();

        for(SubPicketageSupplierVO subPicketageSupplierVO : picketageSupplierList){
            subPicketageSupplierVO.setTenderFlag(0);
        }

        List<SubPicketageSupplierEntity> subPicketageSupplierList = BeanMapper.mapList(picketageSupplierList, SubPicketageSupplierEntity.class);
        subPicketageSupplierService.saveBatch(subPicketageSupplierList);

        //更新中标信息
        List<SubDocumentDetailVO> subDocumentDetailList = saveorUpdateVO.getSubDocumentDetailList();
        ArrayList<SubDocumentSellVO> documentSellVOArrayList = new ArrayList<>();
//
        for (SubDocumentDetailVO subDocumentDetailVO : subDocumentDetailList){
            documentSellVOArrayList.addAll(subDocumentDetailVO.getSubDocumentSellVOList());
        }
        List<SubDocumentSellEntity> subDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList, SubDocumentSellEntity.class);
        subDocumentSellService.saveOrUpdateBatch(subDocumentSellEntityList);
        SubPicketageVO subPicketageVO = queryDetail(saveorUpdateVO.getId());
        return subPicketageVO;
    }

    @Override
    public SubPicketageVO saveManyPicketage(Long documentId) {
        SubPicketageEntity entity = new SubPicketageEntity();

        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //更新状态
        SubDocumentEntity documentEntity = subDocumentService.selectById(documentId);
        documentEntity.setNextFlag(0);
        subDocumentService.saveOrUpdate(documentEntity);

        //更新洽商谈判状态
        LambdaQueryWrapper<SubTalkEntity> lambdaTalk = Wrappers.<SubTalkEntity>lambdaQuery();
        lambdaTalk.eq(SubTalkEntity::getBillId, documentId);
        SubTalkEntity subTalkEntity = subTalkService.getOne(lambdaTalk);
        if (subTalkEntity != null){
            subTalkEntity.setNextFlag(0);
            subTalkService.updateById(subTalkEntity);
        }

        //转换数据
        SubDocumentEntity subDocumentEntity = subDocumentService.selectById(documentId);
        SubInviteEntity inviteEntity = subInviteService.selectById(subDocumentEntity.getInviteId());
        entity.setPicketageName(inviteEntity.getTenderName()+"定标");
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setEmployeeId(subDocumentEntity.getEmployeeId());
        entity.setEmployeeName(subDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(subDocumentEntity.getEmployeeMobile());
        entity.setValueType(subDocumentEntity.getValueType());
        SubInviteEntity subInviteEntity = subInviteService.selectById(subDocumentEntity.getInviteId());
        entity.setDocumentId(documentId);
        entity.setInviteId(subDocumentEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(sessionManager.getUserContext().getEmployeeName());
        //材料-0,分包-1，设备采购-2,设备租赁-3,周转材租赁-4,其他-5
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(0));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate(entity, false);
        SubPicketageVO vo = BeanMapper.map(entity, SubPicketageVO.class);

        //回写招标阶段
        subInviteEntity.setTenderStage(5);
        subInviteService.updateById(subInviteEntity);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("定标");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(1);
        processEntity.setFrontendUrl("sub/picketage");
        processService.saveOrUpdate(processEntity);
        return vo;
    }

    @Override
    public List<SubPicketageSupplierVO> querySupplierList(Long picketageId) {
        SubPicketageEntity subPicketageEntity = super.selectById(picketageId);
        List<SubPicketageSupplierEntity> picketageSupplierList = subPicketageEntity.getPicketageSupplierList();
        List<SubPicketageSupplierVO> list = BeanMapper.mapList(picketageSupplierList, SubPicketageSupplierVO.class);

        return list;
    }
    @Override
    public SubPicketageVO saveSupplierBatch(SubPicketageVO saveorUpdateVO) {
        SubPicketageEntity subPicketageEntity = super.selectById(saveorUpdateVO.getId());
        List<SubPicketageSupplierEntity> picketageSupplierList = subPicketageEntity.getPicketageSupplierList();
        if (CollectionUtils.isNotEmpty(picketageSupplierList)){
            return queryDetail(saveorUpdateVO.getId());
        }

        BigDecimal money = BigDecimal.ZERO;
        BigDecimal moneyTax = BigDecimal.ZERO;
        List<SubPicketageSupplierEntity> subPicketageSupplierEntities = BeanMapper.mapList(saveorUpdateVO.getPicketageSupplierList(), SubPicketageSupplierEntity.class);
        for (SubPicketageSupplierEntity subPicketageSupplierEntity : subPicketageSupplierEntities){
            subPicketageSupplierEntity.setTenderFlag(0);
            money = money.add(subPicketageSupplierEntity.getMoney());
            moneyTax = moneyTax.add(subPicketageSupplierEntity.getMoneyTax());
        }
        subPicketageSupplierService.saveBatch(subPicketageSupplierEntities);

        //更新主表中标总额字段
        subPicketageEntity.setMoney(money);
        subPicketageEntity.setMoneyTax(moneyTax);
        super.updateById(subPicketageEntity);

        //更新中标信息
        List<SubDocumentDetailVO> subDocumentDetailList = saveorUpdateVO.getSubDocumentDetailList();
        ArrayList<SubDocumentSellVO> documentSellVOArrayList = new ArrayList<>();
//
        for (SubDocumentDetailVO subDocumentDetailVO : subDocumentDetailList){
            documentSellVOArrayList.addAll(subDocumentDetailVO.getSubDocumentSellVOList());
        }
        List<SubDocumentSellEntity> subDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList,SubDocumentSellEntity.class);
        subDocumentSellService.saveOrUpdateBatch(subDocumentSellEntityList);
        return  queryDetail(saveorUpdateVO.getId());
    }


}
