package com.ejianc.business.tender.other.controller;

import com.ejianc.business.tender.other.bean.OtherWinnoticeEntity;
import com.ejianc.business.tender.other.service.IOtherWinnoticeService;
import com.ejianc.business.tender.other.vo.OtherWinnoticeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;

/**
 * 中标公告表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("otherWinnotice")
@Api(value = "中标公告表", tags = {"中标公告表"})
public class OtherWinnoticeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOtherWinnoticeService service;
    private static final String BILL_CODE = "other-winnotice-code";
    @Autowired
    private IBillCodeApi billCodeApi;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherWinnoticeVO> saveOrUpdates(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody OtherWinnoticeVO saveorUpdateVO) {
    	OtherWinnoticeEntity entity = BeanMapper.map(saveorUpdateVO, OtherWinnoticeEntity.class);
        if(entity.getBillCode() == null){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        OtherWinnoticeVO vo = service.saveOrUpdates(entity);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @ApiOperation("发布接口")
    @RequestMapping(value = "/publishWinnotice", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherWinnoticeVO> publishWinnotice(@RequestParam Long id) throws Exception {
        return CommonResponse.success("发布成功！",service.publishWinnotice(id));
    }
    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherWinnoticeVO> queryDetail(@RequestParam Long id) {
        OtherWinnoticeVO otherWinnoticeVO = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",otherWinnoticeVO);
    }
    @ApiOperation("生成中公告接口")
    @RequestMapping(value = "/saveWinnotice", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherWinnoticeVO> saveWinnotice(@RequestParam Long picketageId) {
        OtherWinnoticeVO otherWinnoticeVO = service.saveWinnotice(picketageId);
        return CommonResponse.success("保存或修改单据成功！",otherWinnoticeVO);
    }

}
