package com.ejianc.business.tender.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.mapper.ExpertRecordMapper;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.other.bean.*;
import com.ejianc.business.tender.other.mapper.OtherDocumentSchemeMapper;
import com.ejianc.business.tender.other.mapper.OtherPicketageMapper;
import com.ejianc.business.tender.other.service.*;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.other.vo.*;

import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.print.attribute.standard.MediaSize;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 定标主表
 *
 * @author generator
 *
 */
@Service("otherPicketageService")
public class OtherPicketageServiceImpl extends BaseServiceImpl<OtherPicketageMapper, OtherPicketageEntity> implements IOtherPicketageService {
    private static final String BILL_CODE = "invite-picketage-code";//此处需要根据实际修改

    @Autowired
    private IExpertEvaluatingService IExpertEvaluatingService;
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private IOtherDocumentService otherDocumentService;
    @Autowired
    private IOtherDocumentSellService otherDocumentSellService;
    @Autowired
    private IOtherDocumentSchemeService otherDocumentSchemeService;
    @Autowired
    private IOtherDocumentSupplierService otherDocumentSupplierService;
    @Autowired
    private OtherDocumentSchemeMapper schemeMapper;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IOtherTalkService otherTalkService;
    @Autowired
    private IOtherPicketageSupplierService otherPicketageSupplierService;
    @Autowired
    private ExpertRecordMapper recordMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;
    @Override
    public OtherPicketageVO savePicketage(Long evaluationId) {

        OtherPicketageEntity entity = new OtherPicketageEntity();

        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //转换数据
        ExpertEvaluatingEntity otherEvaluationEntity = IExpertEvaluatingService.selectById(evaluationId);
        OtherInviteEntity inviteEntity = otherInviteService.selectById(otherEvaluationEntity.getInviteId());
        OtherDocumentEntity otherDocumentEntity = otherDocumentService.selectById(otherEvaluationEntity.getDocumentId());
        entity.setPicketageName(inviteEntity.getTenderName()+"定标");
        entity.setEmployeeId(otherDocumentEntity.getEmployeeId());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setEmployeeName(otherDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(otherDocumentEntity.getEmployeeMobile());
        entity.setValueType(otherDocumentEntity.getValueType());
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(otherDocumentEntity.getInviteId());
        entity.setPurchaseId(otherInviteEntity.getPurchaseId());
        entity.setPurchaseName(otherInviteEntity.getPurchaseName());
        entity.setDocumentId(otherEvaluationEntity.getDocumentId());
        entity.setEvaluationId(otherEvaluationEntity.getId());
        entity.setInviteId(otherEvaluationEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(sessionManager.getUserContext().getEmployeeName());
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        entity.setTrusteesPhone(mobilePhone);
//材料-0,分包-1，设备采购-2,设备租赁-3,周转材租赁-4,其他-5
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(5));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate(entity, false);
        OtherPicketageVO vo = BeanMapper.map(entity, OtherPicketageVO.class);

        //回写招标阶段
        otherInviteEntity.setTenderStage(5);
        otherInviteService.updateById(otherInviteEntity);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("定标");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("other/picketage");
        processService.saveOrUpdate(processEntity);

        //回写方案得分
        List<OtherDocumentSchemeEntity> schemeList = schemeMapper.selectSupplier(otherDocumentEntity.getId());
        for (OtherDocumentSchemeEntity schemeEntity : schemeList) {
            BigDecimal score  = recordMapper.selectScore(schemeEntity.getId(),schemeEntity.getSupplierId(),otherDocumentEntity.getId());
            Boolean scoreBoolean = schemeMapper.updateScore(schemeEntity.getId(), schemeEntity.getSupplierId(), otherDocumentEntity.getId(), score);
            if (!scoreBoolean){
                throw new BusinessException("回写方案得分失败!");
            }
        }
        return vo;
    }
    @Transactional
    @Override
    public OtherPicketageVO queryDetail(Long id) {
        OtherPicketageEntity otherPicketageEntity = super.selectById(id);
        //查询最大轮数
        LambdaQueryWrapper<OtherDocumentSupplierEntity> lambdaSupplier = Wrappers.<OtherDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(OtherDocumentSupplierEntity::getDocumentId, otherPicketageEntity.getDocumentId());
        List<OtherDocumentSupplierEntity> supplieotherityList = otherDocumentSupplierService.list(lambdaSupplier);
        List<Integer> talkNumList = supplieotherityList.stream().map(OtherDocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
        Integer talkNumMax = talkNumList.stream().max(Integer::compareTo).get();


        OtherDocumentEntity entity = otherDocumentService.selectById(otherPicketageEntity.getDocumentId());
        OtherDocumentVO otherDocumentVO = BeanMapper.map(entity, OtherDocumentVO.class);
        //按材料查看报价
        List<OtherDocumentDetailVO> otherDocumentDetailList = otherDocumentVO.getOtherDocumentDetailList();
        //获取材料明细报价
        LambdaQueryWrapper<OtherDocumentSellEntity> lambdaSell = Wrappers.<OtherDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(OtherDocumentSellEntity::getDocumentId, otherPicketageEntity.getDocumentId());
        lambdaSell.eq(OtherDocumentSellEntity::getTalkNum, talkNumMax);
        lambdaSell.eq(OtherDocumentSellEntity::getPassFlag, 1);
        lambdaSell.orderByAsc(OtherDocumentSellEntity::getSupplierId);
        lambdaSell.orderByAsc(OtherDocumentSellEntity::getSchemeName);
        List<OtherDocumentSellEntity> sellList = otherDocumentSellService.list(lambdaSell);
        List<OtherDocumentSellVO> otherDocumentSellVOS = BeanMapper.mapList(sellList, OtherDocumentSellVO.class);
        //查询所有方案
        LambdaQueryWrapper<OtherDocumentSchemeEntity> lambdaScheme = Wrappers.<OtherDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(OtherDocumentSchemeEntity::getDocumentId, otherPicketageEntity.getDocumentId());
        lambdaScheme.eq(OtherDocumentSchemeEntity::getTalkNum, talkNumMax);
        lambdaScheme.orderByAsc(OtherDocumentSchemeEntity::getSchemeName);
        List<OtherDocumentSchemeEntity> schemeList = otherDocumentSchemeService.list(lambdaScheme);
        for (OtherDocumentSchemeEntity otherDocumentSchemeEntity : schemeList){
            for (OtherDocumentSellVO otherDocumentSellVO : otherDocumentSellVOS){
                if (otherDocumentSellVO.getSchemeId().equals(otherDocumentSchemeEntity.getId())){
                    otherDocumentSellVO.setScore(otherDocumentSchemeEntity.getScore());
                }

            }

        }

        //排序
        OtherDocumentSellVO otherDocumentSellFirst = otherDocumentSellVOS.stream().findFirst().get();
        if (otherDocumentSellFirst.getScore() == null){
            otherDocumentSellVOS.sort(Comparator.comparing(OtherDocumentSellVO::getCreateTime).reversed());
        }
        if (otherDocumentSellFirst.getScore() != null){
            otherDocumentSellVOS.sort(Comparator.comparing(OtherDocumentSellVO::getScore).reversed());
        }
        //根据物料详情主键分组
        Map<Long, List<OtherDocumentSellVO>> sellMap = otherDocumentSellVOS.stream().
                collect(Collectors.groupingBy(OtherDocumentSellVO::getDetailId));
        for (OtherDocumentDetailVO otherDocumentDetailVO : otherDocumentDetailList){
            List<OtherDocumentSellVO> otherDocumentSellEntities = sellMap.get(otherDocumentDetailVO.getId());
            otherDocumentDetailVO.setOtherDocumentSellVOList(otherDocumentSellEntities);
        }

        OtherPicketageVO otherPicketageVO = BeanMapper.map(otherPicketageEntity, OtherPicketageVO.class);
        otherPicketageVO.setOtherDocumentDetailList(otherDocumentDetailList);
        if (otherDocumentSellFirst.getScore() == null) {
            otherPicketageVO.setScoreStatus(1);
        }
        if (otherDocumentSellFirst.getScore() != null) {
            otherPicketageVO.setScoreStatus(0);
        }

        return otherPicketageVO;

    }

    @Override
    public OtherPicketageVO saveOrUpdates(OtherPicketageVO saveorUpdateVO) {
        OtherPicketageEntity entity = BeanMapper.map(saveorUpdateVO, OtherPicketageEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity,false);

        //先删后增供应商定标数据
        LambdaQueryWrapper<OtherPicketageSupplierEntity> lambdaSupplier = Wrappers.<OtherPicketageSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(OtherPicketageSupplierEntity::getPicketageId,entity.getId());
        otherPicketageSupplierService.remove(lambdaSupplier);
        List<OtherPicketageSupplierVO> picketageSupplierList = saveorUpdateVO.getPicketageSupplierList();
        for(OtherPicketageSupplierVO otherPicketageSupplierVO : picketageSupplierList){
            otherPicketageSupplierVO.setTenderFlag(0);
        }
        List<OtherPicketageSupplierEntity> otherPicketageSupplierList = BeanMapper.mapList(picketageSupplierList, OtherPicketageSupplierEntity.class);
        otherPicketageSupplierService.saveBatch(otherPicketageSupplierList);

        //更新中标信息
        List<OtherDocumentDetailVO> otherDocumentDetailList = saveorUpdateVO.getOtherDocumentDetailList();
        ArrayList<OtherDocumentSellVO> documentSellVOArrayList = new ArrayList<>();
//
        for (OtherDocumentDetailVO otherDocumentDetailVO : otherDocumentDetailList){
            documentSellVOArrayList.addAll(otherDocumentDetailVO.getOtherDocumentSellVOList());
        }
        List<OtherDocumentSellEntity> otherDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList, OtherDocumentSellEntity.class);
        otherDocumentSellService.saveOrUpdateBatch(otherDocumentSellEntityList);
        OtherPicketageVO otherPicketageVO = queryDetail(saveorUpdateVO.getId());
        return otherPicketageVO;
    }

    @Override
    public OtherPicketageVO saveManyPicketage(Long documentId) {
        OtherPicketageEntity entity = new OtherPicketageEntity();

        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //更新状态
        OtherDocumentEntity documentEntity = otherDocumentService.selectById(documentId);
        documentEntity.setNextFlag(0);
        otherDocumentService.saveOrUpdate(documentEntity);

        //更新洽商谈判状态
        LambdaQueryWrapper<OtherTalkEntity> lambdaTalk = Wrappers.<OtherTalkEntity>lambdaQuery();
        lambdaTalk.eq(OtherTalkEntity::getBillId, documentId);
        OtherTalkEntity otherTalkEntity = otherTalkService.getOne(lambdaTalk);
        if (otherTalkEntity != null){
            otherTalkEntity.setNextFlag(0);
            otherTalkService.updateById(otherTalkEntity);
        }

        //转换数据
        OtherDocumentEntity otherDocumentEntity = otherDocumentService.selectById(documentId);
        OtherInviteEntity inviteEntity = otherInviteService.selectById(otherDocumentEntity.getInviteId());
        entity.setPicketageName(inviteEntity.getTenderName()+"定标");
        entity.setEmployeeId(otherDocumentEntity.getEmployeeId());
        entity.setEmployeeName(otherDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(otherDocumentEntity.getEmployeeMobile());
        entity.setValueType(otherDocumentEntity.getValueType());
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(otherDocumentEntity.getInviteId());
        entity.setPurchaseId(otherInviteEntity.getPurchaseId());
        entity.setPurchaseName(otherInviteEntity.getPurchaseName());
        entity.setPurchaseType(otherInviteEntity.getPurchaseType());
        entity.setDocumentId(documentId);
        entity.setInviteId(otherDocumentEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(sessionManager.getUserContext().getEmployeeName());
        //材料-0,分包-1，设备采购-2,设备租赁-3,周转材租赁-4,其他-5
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(0));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate(entity, false);
        OtherPicketageVO vo = BeanMapper.map(entity, OtherPicketageVO.class);

        //回写招标阶段
        otherInviteEntity.setTenderStage(5);
        otherInviteService.updateById(otherInviteEntity);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("定标");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("other/picketage");
        processService.saveOrUpdate(processEntity);
        return vo;
    }

    @Override
    public List<OtherPicketageSupplierVO> querySupplierList(Long picketageId) {
        OtherPicketageEntity otherPicketageEntity = super.selectById(picketageId);
        List<OtherPicketageSupplierEntity> picketageSupplierList = otherPicketageEntity.getPicketageSupplierList();
        List<OtherPicketageSupplierVO> list = BeanMapper.mapList(picketageSupplierList, OtherPicketageSupplierVO.class);

        return list;
    }
    @Override
    public OtherPicketageVO saveSupplierBatch(OtherPicketageVO saveorUpdateVO) {
        OtherPicketageEntity stuffPicketageEntity = super.selectById(saveorUpdateVO.getId());
        List<OtherPicketageSupplierEntity> picketageSupplierList = stuffPicketageEntity.getPicketageSupplierList();
        if (CollectionUtils.isNotEmpty(picketageSupplierList)){
            return queryDetail(saveorUpdateVO.getId());
        }
        List<OtherPicketageSupplierEntity> otherPicketageSupplierEntities = BeanMapper.mapList(saveorUpdateVO.getPicketageSupplierList(), OtherPicketageSupplierEntity.class);
        for (OtherPicketageSupplierEntity otherPicketageSupplierEntity : otherPicketageSupplierEntities){
            otherPicketageSupplierEntity.setTenderFlag(0);
        }
        otherPicketageSupplierService.saveBatch(otherPicketageSupplierEntities);
        //更新中标信息
        List<OtherDocumentDetailVO> otherDocumentDetailList = saveorUpdateVO.getOtherDocumentDetailList();
        ArrayList<OtherDocumentSellVO> documentSellVOArrayList = new ArrayList<>();
//
        for (OtherDocumentDetailVO otherDocumentDetailVO : otherDocumentDetailList){
            documentSellVOArrayList.addAll(otherDocumentDetailVO.getOtherDocumentSellVOList());
        }
        List<OtherDocumentSellEntity> otherDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList,OtherDocumentSellEntity.class);
        otherDocumentSellService.saveOrUpdateBatch(otherDocumentSellEntityList);
        return queryDetail(saveorUpdateVO.getId());
    }


}
