package com.ejianc.business.tender.rent.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.rent.vo.*;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.mapper.ExpertRecordMapper;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rent.bean.*;
import com.ejianc.business.tender.rent.mapper.RentDocumentSchemeMapper;
import com.ejianc.business.tender.rent.mapper.RentPicketageMapper;
import com.ejianc.business.tender.rent.service.*;
import com.ejianc.business.tender.rent.vo.*;
import com.ejianc.business.tender.rmat.bean.RmatPicketageSupplierEntity;
import com.ejianc.business.tender.stuff.bean.StuffDocumentSellEntity;
import com.ejianc.business.tender.stuff.bean.StuffPicketageEntity;
import com.ejianc.business.tender.stuff.bean.StuffPicketageSupplierEntity;
import com.ejianc.business.tender.stuff.vo.StuffDocumentDetailVO;
import com.ejianc.business.tender.stuff.vo.StuffDocumentSellVO;
import com.ejianc.business.tender.stuff.vo.StuffPicketageVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 定标主表
 * 
 * @author generator
 * 
 */
@Service("rentPicketageService")
public class RentPicketageServiceImpl extends BaseServiceImpl<RentPicketageMapper, RentPicketageEntity> implements IRentPicketageService {
    private static final String BILL_CODE = "invite-picketage-code";//此处需要根据实际修改
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IExpertEvaluatingService IExpertEvaluatingService;
    @Autowired
    private IRentInviteService rentInviteService;
    @Autowired
    private IRentDocumentService rentDocumentService;
    @Autowired
    private IRentDocumentSellService rentDocumentSellService;
    @Autowired
    private IRentDocumentSchemeService rentDocumentSchemeService;
    @Autowired
    private IRentDocumentSupplierService rentDocumentSupplierService;
    @Autowired
    private RentDocumentSchemeMapper schemeMapper;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IRentTalkService rentTalkService;
    @Autowired
    private IRentPicketageSupplierService rentPicketageSupplierService;
    @Autowired
    private ExpertRecordMapper recordMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public RentPicketageVO savePicketage(Long evaluationId) {

        RentPicketageEntity entity = new RentPicketageEntity();

        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //转换数据
        ExpertEvaluatingEntity rentEvaluationEntity = IExpertEvaluatingService.selectById(evaluationId);
        RentInviteEntity inviteEntity = rentInviteService.selectById(rentEvaluationEntity.getInviteId());
        RentDocumentEntity rentDocumentEntity = rentDocumentService.selectById(rentEvaluationEntity.getDocumentId());
        entity.setPicketageName(inviteEntity.getTenderName()+"定标");
        entity.setEmployeeId(rentDocumentEntity.getEmployeeId());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setEmployeeName(rentDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(rentDocumentEntity.getEmployeeMobile());
        entity.setValueType(rentDocumentEntity.getValueType());
        RentInviteEntity rentInviteEntity = rentInviteService.selectById(rentDocumentEntity.getInviteId());
        entity.setPurchaseId(rentInviteEntity.getPurchaseId());
        entity.setPurchaseName(rentInviteEntity.getPurchaseName());
        entity.setDocumentId(rentEvaluationEntity.getDocumentId());
        entity.setEvaluationId(rentEvaluationEntity.getId());
        entity.setInviteId(rentEvaluationEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(sessionManager.getUserContext().getEmployeeName());
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        entity.setTrusteesPhone(mobilePhone);
//材料-0,分包-1，设备采购-2,设备租赁-3,周转材租赁-4,其他-5
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(3));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate(entity, false);
        RentPicketageVO vo = BeanMapper.map(entity, RentPicketageVO.class);

        //回写招标阶段
        rentInviteEntity.setTenderStage(5);
        rentInviteService.updateById(rentInviteEntity);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("定标");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("rent/picketage");
        processService.saveOrUpdate(processEntity);

        //回写方案得分
        List<RentDocumentSchemeEntity> schemeList = schemeMapper.selectSupplier(rentDocumentEntity.getId());
        for (RentDocumentSchemeEntity schemeEntity : schemeList) {
            BigDecimal score  = recordMapper.selectScore(schemeEntity.getId(),schemeEntity.getSupplierId(),rentDocumentEntity.getId());
            Boolean scoreBoolean = schemeMapper.updateScore(schemeEntity.getId(), schemeEntity.getSupplierId(), rentDocumentEntity.getId(), score);
            if (!scoreBoolean){
                throw new BusinessException("回写方案得分失败!");
            }
        }
        return vo;
    }
    @Override
    public RentPicketageVO queryDetail(Long id) {
        RentPicketageEntity rentPicketageEntity = super.selectById(id);
        //查询最大轮数
        LambdaQueryWrapper<RentDocumentSupplierEntity> lambdaSupplier = Wrappers.<RentDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(RentDocumentSupplierEntity::getDocumentId, rentPicketageEntity.getDocumentId());
        List<RentDocumentSupplierEntity> supplierEntityList = rentDocumentSupplierService.list(lambdaSupplier);
        List<Integer> talkNumList = supplierEntityList.stream().map(RentDocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
        Integer talkNumMax = talkNumList.stream().max(Integer::compareTo).get();


        RentDocumentEntity entity = rentDocumentService.selectById(rentPicketageEntity.getDocumentId());
        RentDocumentVO rentDocumentVO = BeanMapper.map(entity, RentDocumentVO.class);
        //按材料查看报价
        List<RentDocumentDetailVO> rentDocumentDetailList = rentDocumentVO.getRentDocumentDetailList();
        //获取材料明细报价
        LambdaQueryWrapper<RentDocumentSellEntity> lambdaSell = Wrappers.<RentDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(RentDocumentSellEntity::getDocumentId, rentPicketageEntity.getDocumentId());
        lambdaSell.eq(RentDocumentSellEntity::getTalkNum, talkNumMax);
        lambdaSell.eq(RentDocumentSellEntity::getPassFlag, 1);
        lambdaSell.orderByAsc(RentDocumentSellEntity::getSupplierId);
        lambdaSell.orderByAsc(RentDocumentSellEntity::getSchemeName);
        List<RentDocumentSellEntity> sellList = rentDocumentSellService.list(lambdaSell);
        List<RentDocumentSellVO> rentDocumentSellVOS = BeanMapper.mapList(sellList, RentDocumentSellVO.class);
        //查询所有方案
        LambdaQueryWrapper<RentDocumentSchemeEntity> lambdaScheme = Wrappers.<RentDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(RentDocumentSchemeEntity::getDocumentId, rentPicketageEntity.getDocumentId());
        lambdaScheme.eq(RentDocumentSchemeEntity::getTalkNum, talkNumMax);
        lambdaScheme.orderByAsc(RentDocumentSchemeEntity::getSchemeName);
        List<RentDocumentSchemeEntity> schemeList = rentDocumentSchemeService.list(lambdaScheme);
        for (RentDocumentSchemeEntity rentDocumentSchemeEntity : schemeList){
            for (RentDocumentSellVO rentDocumentSellVO : rentDocumentSellVOS){
                if (rentDocumentSellVO.getSchemeId().equals(rentDocumentSchemeEntity.getId())){
                    rentDocumentSellVO.setScore(rentDocumentSchemeEntity.getScore());
                }

            }

        }

        //排序
        RentDocumentSellVO rentDocumentSellFirst = rentDocumentSellVOS.stream().findFirst().get();
        if (rentDocumentSellFirst.getScore() == null){
            rentDocumentSellVOS.sort(Comparator.comparing(RentDocumentSellVO::getCreateTime).reversed());
        }
        if (rentDocumentSellFirst.getScore() != null){
            rentDocumentSellVOS.sort(Comparator.comparing(RentDocumentSellVO::getScore).reversed());
        }
        //根据物料详情主键分组
        Map<Long, List<RentDocumentSellVO>> sellMap = rentDocumentSellVOS.stream().
                collect(Collectors.groupingBy(RentDocumentSellVO::getDetailId));
        for (RentDocumentDetailVO rentDocumentDetailVO : rentDocumentDetailList){
            List<RentDocumentSellVO> rentDocumentSellEntities = sellMap.get(rentDocumentDetailVO.getId());
            rentDocumentDetailVO.setRentDocumentSellVOList(rentDocumentSellEntities);
        }

        RentPicketageVO rentPicketageVO = BeanMapper.map(rentPicketageEntity, RentPicketageVO.class);
        rentPicketageVO.setRentDocumentDetailList(rentDocumentDetailList);
        if (rentDocumentSellFirst.getScore() == null) {
            rentPicketageVO.setScoreStatus(1);
        }
        if (rentDocumentSellFirst.getScore() != null) {
            rentPicketageVO.setScoreStatus(0);
        }
        RentInviteEntity rentInviteEntity = rentInviteService.selectById(rentPicketageVO.getInviteId());
        rentPicketageVO.setRentType(rentInviteEntity.getRentType());

        return rentPicketageVO;

    }
    @Transactional
    @Override
    public RentPicketageVO saveOrUpdates(RentPicketageVO saveorUpdateVO) {
        RentPicketageEntity entity = BeanMapper.map(saveorUpdateVO, RentPicketageEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setPicketageSupplierList(null);
        super.saveOrUpdate(entity,false);

        //先删后增供应商定标数据
        LambdaQueryWrapper<RentPicketageSupplierEntity> lambdaSupplier = Wrappers.<RentPicketageSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(RentPicketageSupplierEntity::getPicketageId,entity.getId());
        rentPicketageSupplierService.remove(lambdaSupplier);
        List<RentPicketageSupplierVO> picketageSupplierList = saveorUpdateVO.getPicketageSupplierList();
        for(RentPicketageSupplierVO rentPicketageSupplierVO : picketageSupplierList){
            rentPicketageSupplierVO.setTenderFlag(0);
        }
        List<RentPicketageSupplierEntity> rentPicketageSupplierList = BeanMapper.mapList(picketageSupplierList, RentPicketageSupplierEntity.class);
        rentPicketageSupplierService.saveBatch(rentPicketageSupplierList);

        //更新中标信息
        List<RentDocumentDetailVO> rentDocumentDetailList = saveorUpdateVO.getRentDocumentDetailList();
        ArrayList<RentDocumentSellVO> documentSellVOArrayList = new ArrayList<>();
//
        for (RentDocumentDetailVO rentDocumentDetailVO : rentDocumentDetailList){
            documentSellVOArrayList.addAll(rentDocumentDetailVO.getRentDocumentSellVOList());
        }
        List<RentDocumentSellEntity> rentDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList, RentDocumentSellEntity.class);
        boolean saveOrUpdateBatch = rentDocumentSellService.updateBatchById(rentDocumentSellEntityList);
        RentPicketageVO rentPicketageVO = queryDetail(saveorUpdateVO.getId());
        return rentPicketageVO;
    }

    @Override
    public RentPicketageVO saveManyPicketage(Long documentId) {
        RentPicketageEntity entity = new RentPicketageEntity();

        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //更新状态
        RentDocumentEntity documentEntity = rentDocumentService.selectById(documentId);
        documentEntity.setNextFlag(0);
        rentDocumentService.saveOrUpdate(documentEntity);

        //更新洽商谈判状态
        LambdaQueryWrapper<RentTalkEntity> lambdaTalk = Wrappers.<RentTalkEntity>lambdaQuery();
        lambdaTalk.eq(RentTalkEntity::getBillId, documentId);
        RentTalkEntity rentTalkEntity = rentTalkService.getOne(lambdaTalk);
        if (rentTalkEntity != null){
            rentTalkEntity.setNextFlag(0);
            rentTalkService.updateById(rentTalkEntity);
        }

        //转换数据
        RentDocumentEntity rentDocumentEntity = rentDocumentService.selectById(documentId);
        RentInviteEntity inviteEntity = rentInviteService.selectById(rentDocumentEntity.getInviteId());
        entity.setPicketageName(inviteEntity.getTenderName()+"定标");
        entity.setEmployeeId(rentDocumentEntity.getEmployeeId());
        entity.setEmployeeName(rentDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(rentDocumentEntity.getEmployeeMobile());
        entity.setValueType(rentDocumentEntity.getValueType());
        RentInviteEntity rentInviteEntity = rentInviteService.selectById(rentDocumentEntity.getInviteId());
        entity.setPurchaseId(rentInviteEntity.getPurchaseId());
        entity.setPurchaseName(rentInviteEntity.getPurchaseName());
        entity.setPurchaseType(rentInviteEntity.getPurchaseType());
        entity.setDocumentId(documentId);
        entity.setInviteId(rentDocumentEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(sessionManager.getUserContext().getEmployeeName());
        //材料-0,分包-1，设备采购-2,设备租赁-3,周转材租赁-4,其他-5
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(0));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate(entity, false);
        RentPicketageVO vo = BeanMapper.map(entity, RentPicketageVO.class);

        //回写招标阶段
        rentInviteEntity.setTenderStage(5);
        rentInviteService.updateById(rentInviteEntity);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("定标");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("rent/picketage");
        processService.saveOrUpdate(processEntity);
        return vo;
    }

    @Override
    public List<RentPicketageSupplierVO> querySupplierList(Long picketageId) {
        RentPicketageEntity rentPicketageEntity = super.selectById(picketageId);
        List<RentPicketageSupplierEntity> picketageSupplierList = rentPicketageEntity.getPicketageSupplierList();
        List<RentPicketageSupplierVO> list = BeanMapper.mapList(picketageSupplierList, RentPicketageSupplierVO.class);

        return list;
    }

    @Override
    public RentPicketageVO saveSupplierBatch(RentPicketageVO saveorUpdateVO) {
        RentPicketageEntity stuffPicketageEntity = super.selectById(saveorUpdateVO.getId());
        List<RentPicketageSupplierEntity> picketageSupplierList = stuffPicketageEntity.getPicketageSupplierList();
        if (CollectionUtils.isNotEmpty(picketageSupplierList)){
            return queryDetail(saveorUpdateVO.getId());
        }
        List<RentPicketageSupplierEntity> rentPicketageSupplierEntities = BeanMapper.mapList(saveorUpdateVO.getPicketageSupplierList(), RentPicketageSupplierEntity.class);
        for (RentPicketageSupplierEntity rentPicketageSupplierEntity : rentPicketageSupplierEntities){
            rentPicketageSupplierEntity.setTenderFlag(0);
        }
        rentPicketageSupplierService.saveBatch(rentPicketageSupplierEntities);

        //更新中标信息
        List<RentDocumentDetailVO> rentDocumentDetailList = saveorUpdateVO.getRentDocumentDetailList();
        ArrayList<RentDocumentSellVO> documentSellVOArrayList = new ArrayList<>();
//
        for (RentDocumentDetailVO rentDocumentDetailVO : rentDocumentDetailList){
            documentSellVOArrayList.addAll(rentDocumentDetailVO.getRentDocumentSellVOList());
        }
        List<RentDocumentSellEntity> rentDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList,RentDocumentSellEntity.class);
        rentDocumentSellService.saveOrUpdateBatch(rentDocumentSellEntityList);
        return queryDetail(saveorUpdateVO.getId());
    }

}
