package com.ejianc.business.tender.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.sub.bean.SubDocumentExpertEntity;
import com.ejianc.business.tender.sub.mapper.SubDocumentExpertMapper;
import com.ejianc.business.tender.sub.service.ISubDocumentExpertService;
import com.ejianc.business.tender.sub.vo.SubDocumentExpertVO;
import com.ejianc.business.tender.sub.vo.SubDocumentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 招标文件专家表
 * 
 * @author generator
 * 
 */
@Service("subDocumentExpertService")
public class SubDocumentExpertServiceImpl extends BaseServiceImpl<SubDocumentExpertMapper, SubDocumentExpertEntity> implements ISubDocumentExpertService{

    @Override
    public List<SubDocumentExpertEntity> addBatch(SubDocumentVO subDocumentVO) {

        //先删后增
        LambdaQueryWrapper<SubDocumentExpertEntity> expertWrapper = Wrappers.lambdaQuery();
        expertWrapper.eq(SubDocumentExpertEntity::getDocumentId,subDocumentVO.getId());
        super.remove(expertWrapper);

        //新增
        List<SubDocumentExpertVO> expertVOList = subDocumentVO.getExpertVOList();
        if(CollectionUtils.isNotEmpty(expertVOList)){
            for (SubDocumentExpertVO subDocument: expertVOList){
                subDocument.setDocumentId(subDocumentVO.getId());
                subDocument.setId(null);
            }
            List<SubDocumentExpertEntity> subDocumentExpertEntities = BeanMapper.mapList(expertVOList, SubDocumentExpertEntity.class);
            super.saveBatch(subDocumentExpertEntities);
            return subDocumentExpertEntities;
        }

        return null;
    }

    @Override
    public List<SubDocumentExpertEntity> deleteByIds(List<Long> vos) {
        Long pk = vos.stream().findFirst().get();
        SubDocumentExpertEntity subDocumentExpertEntity = super.selectById(pk);
        Long documentId = subDocumentExpertEntity.getDocumentId();
        super.removeByIds(vos,true);
        LambdaQueryWrapper<SubDocumentExpertEntity> expertWrapper = Wrappers.lambdaQuery();
        expertWrapper.eq(SubDocumentExpertEntity::getDocumentId,documentId);
        List<SubDocumentExpertEntity> list = super.list(expertWrapper);
        return list;
    }
}
