/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.equipment.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteDetailEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteSupplierEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentNoticeChangeEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentNoticeDetailEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentNoticeEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentNoticeSupplierDetailEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentNoticeSupplierEntity;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteDetailRecordService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteDetailService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteSupplierService;
import com.ejianc.business.tender.equipment.service.IEquipmentNoticeChangeService;
import com.ejianc.business.tender.equipment.service.IEquipmentNoticeDetailService;
import com.ejianc.business.tender.equipment.service.IEquipmentNoticeService;
import com.ejianc.business.tender.equipment.service.IEquipmentNoticeSupplierDetailService;
import com.ejianc.business.tender.equipment.service.IEquipmentNoticeSupplierService;
import com.ejianc.business.tender.equipment.vo.EquipmentNoticeSupplierDetailTbVO;
import com.ejianc.business.tender.equipment.vo.EquipmentNoticeSupplierVO;
import com.ejianc.business.tender.equipment.vo.EquipmentNoticeVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"equipmentNotice"})
@Api(value="\u62db\u6807\u516c\u544a\u4e3b\u8868", tags={"\u62db\u6807\u516c\u544a\u4e3b\u8868"})
public class EquipmentNoticeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value(value="${gysUrl.updateSupStatusUrl}")
    private String updateSupStatusUrl;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "invite-notice-code";
    @Autowired
    private IEquipmentNoticeService service;
    @Autowired
    private IEquipmentInviteService inviteService;
    @Autowired
    private IEquipmentInviteDetailService inviteDetailService;
    @Autowired
    private IEquipmentInviteDetailRecordService inviteDetailRecordService;
    @Autowired
    private IEquipmentNoticeDetailService noticeDetailService;
    @Autowired
    private IProcessService processSerice;
    @Autowired
    private IEquipmentNoticeSupplierDetailService noticeSupplierDetailService;
    @Autowired
    private IEquipmentInviteSupplierService inviteSupplierService;
    @Autowired
    private IEquipmentNoticeSupplierService noticeSupplierService;
    @Autowired
    private IEquipmentNoticeChangeService changeService;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private static final String BILL_SUPPLIER_TYPE = "BT211215000000005";
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IAttachmentApi attachmentApi;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<EquipmentNoticeVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody EquipmentNoticeVO saveorUpdateVO) {
        EquipmentNoticeEntity entity = (EquipmentNoticeEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, EquipmentNoticeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        EquipmentNoticeVO vo = (EquipmentNoticeVO)BeanMapper.map((Object)((Object)entity), EquipmentNoticeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EquipmentNoticeVO> queryDetail(@RequestParam Long id) {
        EquipmentNoticeEntity entity = (EquipmentNoticeEntity)((Object)this.service.selectById(id));
        EquipmentNoticeVO vo = (EquipmentNoticeVO)BeanMapper.map((Object)((Object)entity), EquipmentNoticeVO.class);
        if (!this.service.selectFile(vo)) {
            CommonResponse.success((String)"\u4f9b\u5e94\u5546\u9644\u4ef6\u67e5\u8be2\u5931\u8d25\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EquipmentNoticeVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        this.processSerice.remove((Wrapper)new LambdaQueryWrapper().in(ProcessEntity::getBillId, (Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList())));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<EquipmentNoticeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), EquipmentNoticeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u624b\u673a\u53f7")
    @RequestMapping(value={"/queryPhone"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = ((EmployeeVO)this.employeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone();
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)mobilePhone);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("EquipmentNotice-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refEquipmentNoticeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<EquipmentNoticeVO>> refEquipmentNoticeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), EquipmentNoticeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u70b9\u51fb\u4e0b\u4e00\u6b65\u8fdb\u884c\u4e0b\u4e2a\u9875\u9762\u6570\u636e\u521d\u59cb\u5316")
    @RequestMapping(value={"/nextStep"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EquipmentNoticeEntity> nextStep(String id) throws InvocationTargetException, IllegalAccessException {
        EquipmentInviteEntity equipmentInviteEntity = (EquipmentInviteEntity)((Object)this.inviteService.selectById((Serializable)((Object)id)));
        EquipmentNoticeEntity equipmentNoticeEntity = new EquipmentNoticeEntity();
        BeanUtils.copyProperties((Object)((Object)equipmentNoticeEntity), (Object)((Object)equipmentInviteEntity));
        equipmentNoticeEntity.setNoticeName(equipmentInviteEntity.getTenderName());
        equipmentNoticeEntity.setInviteId(equipmentInviteEntity.getId());
        equipmentNoticeEntity.setId(null);
        equipmentNoticeEntity.setCreateTime(null);
        equipmentNoticeEntity.setUpdateTime(null);
        equipmentNoticeEntity.setBillCode(null);
        equipmentNoticeEntity.setBillState(null);
        equipmentNoticeEntity.setCreateUserCode(null);
        equipmentNoticeEntity.setUpdateUserCode(null);
        equipmentNoticeEntity.setSyncEsFlag(null);
        equipmentNoticeEntity.setVersion(null);
        equipmentNoticeEntity.setTenantId(null);
        equipmentNoticeEntity.setMemo(null);
        equipmentNoticeEntity.setEmployeeId(null);
        equipmentNoticeEntity.setEmployeeName(null);
        this.service.saveOrUpdate((Object)equipmentNoticeEntity);
        List equipmentInviteDetailList = this.inviteDetailService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EquipmentInviteDetailEntity::getInviteId, (Object)id)).eq(BaseEntity::getDr, (Object)0));
        EquipmentNoticeDetailEntity equipmentNoticeDetailEntity = new EquipmentNoticeDetailEntity();
        if (CollectionUtil.isNotEmpty((Collection)equipmentInviteDetailList)) {
            for (EquipmentInviteDetailEntity equipmentInviteDetailEntity : equipmentInviteDetailList) {
                BeanUtils.copyProperties((Object)((Object)equipmentNoticeDetailEntity), (Object)((Object)equipmentInviteDetailEntity));
                equipmentNoticeDetailEntity.setNoticeId(equipmentNoticeEntity.getId());
                equipmentNoticeDetailEntity.setId(null);
                equipmentNoticeDetailEntity.setCreateTime(null);
                equipmentNoticeDetailEntity.setUpdateTime(null);
                equipmentNoticeDetailEntity.setCreateUserCode(null);
                equipmentNoticeDetailEntity.setUpdateUserCode(null);
                equipmentNoticeDetailEntity.setSyncEsFlag(null);
                equipmentNoticeDetailEntity.setVersion(null);
                equipmentNoticeDetailEntity.setTenantId(null);
                this.noticeDetailService.saveOrUpdate((Object)equipmentNoticeDetailEntity);
            }
        }
        List equipmentInviteSupplierList = this.inviteSupplierService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EquipmentInviteSupplierEntity::getInviteId, (Object)id)).eq(BaseEntity::getDr, (Object)0));
        EquipmentNoticeSupplierDetailEntity equipmentNoticeSupplierDetailEntity = new EquipmentNoticeSupplierDetailEntity();
        if (CollectionUtil.isNotEmpty((Collection)equipmentInviteSupplierList)) {
            for (EquipmentInviteSupplierEntity equipmentInviteSupplierEntity : equipmentInviteSupplierList) {
                BeanUtils.copyProperties((Object)((Object)equipmentNoticeSupplierDetailEntity), (Object)((Object)equipmentInviteSupplierEntity));
                equipmentNoticeSupplierDetailEntity.setInviteId(equipmentNoticeEntity.getInviteId());
                equipmentNoticeSupplierDetailEntity.setId(null);
                equipmentNoticeSupplierDetailEntity.setCreateTime(null);
                equipmentNoticeSupplierDetailEntity.setUpdateTime(null);
                equipmentNoticeSupplierDetailEntity.setCreateUserCode(null);
                equipmentNoticeSupplierDetailEntity.setUpdateUserCode(null);
                equipmentNoticeSupplierDetailEntity.setSyncEsFlag(null);
                equipmentNoticeSupplierDetailEntity.setVersion(null);
                equipmentNoticeSupplierDetailEntity.setTenantId(null);
                this.noticeSupplierDetailService.saveOrUpdate((Object)equipmentNoticeSupplierDetailEntity);
            }
        }
        Integer tenderStage = 2;
        this.inviteService.updateTenderStage(id, tenderStage);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(equipmentNoticeEntity.getId());
        processEntity.setBillName("\u62db\u6807\u516c\u544a");
        processEntity.setTenderId(equipmentNoticeEntity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("equipment/notice");
        this.processSerice.saveOrUpdate((Object)processEntity);
        return CommonResponse.success((String)"\u521d\u59cb\u5316\u6570\u636e\u6210\u529f", (Object)((Object)equipmentNoticeEntity));
    }

    @ApiOperation(value="\u5ef6\u957f\u622a\u6b62\u65f6\u95f4")
    @RequestMapping(value={"/extend"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse extend(@RequestBody EquipmentNoticeChangeEntity equipmentNoticeChangeEntity) {
        this.service.updateEndTime(equipmentNoticeChangeEntity.getNoticeId(), equipmentNoticeChangeEntity.getNewTime());
        EquipmentNoticeEntity equipmentNoticeEntity = (EquipmentNoticeEntity)((Object)this.service.selectById(equipmentNoticeChangeEntity.getNoticeId()));
        HashMap<String, Object> map = new HashMap<String, Object>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("sourceId", equipmentNoticeEntity.getInviteId());
        map.put("noticeEndTime", sdf.format(equipmentNoticeChangeEntity.getNewTime()));
        CommonResponse response = null;
        try {
            response = this.systemDataPushService.exchangeDataWithUniversal(this.updateTimeUrl, RequestMethod.POST, JSON.toJSONString(map), this.appId, this.appSecret, this.appHost);
            if (!response.isSuccess()) {
                return CommonResponse.error((String)("\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25\uff0c" + response.getMsg()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25");
        }
        this.changeService.saveOrUpdate((Object)equipmentNoticeChangeEntity);
        return CommonResponse.success((String)"\u5ef6\u957f\u622a\u6b62\u65f6\u95f4\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u53d1\u5e03\u516c\u544a")
    @RequestMapping(value={"/publish"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse publish(@RequestBody EquipmentNoticeVO equipmentNoticeVO) throws InvocationTargetException, IllegalAccessException {
        return this.service.publish(equipmentNoticeVO);
    }

    @ApiOperation(value="\u62a5\u540d\u60c5\u51b5")
    @RequestMapping(value={"/signUp"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> signUp(HttpServletRequest request) {
        this.logger.info("\u8fdb\u5165\u62a5\u540d\u63a5\u53e3request-{},file-{}", (Object)request);
        String notice = request.getParameter("bmNoticeVO");
        this.logger.info("\u62a5\u540d\u5b9e\u4f53\u4fe1\u606f-{}", (Object)notice);
        EquipmentNoticeSupplierVO equipmentNoticeSupplierVO = (EquipmentNoticeSupplierVO)JSON.parseObject((String)notice, (TypeReference)new TypeReference<EquipmentNoticeSupplierVO>(){}, (Feature[])new Feature[0]);
        EquipmentNoticeSupplierEntity equipmentNoticeSupplierEntity = (EquipmentNoticeSupplierEntity)((Object)BeanMapper.map((Object)equipmentNoticeSupplierVO, EquipmentNoticeSupplierEntity.class));
        equipmentNoticeSupplierEntity.setNoticeId(this.service.selectNotice(equipmentNoticeSupplierVO.getSourceId()));
        equipmentNoticeSupplierEntity.setSourceSupplierTenantId(equipmentNoticeSupplierVO.getTenantId().toString());
        equipmentNoticeSupplierEntity.setSupplierId(Long.valueOf(equipmentNoticeSupplierVO.getSourceSupplierId()));
        SupplierDTO supplierVO = (SupplierDTO)this.shareSupplierApi.queryById(Long.valueOf(equipmentNoticeSupplierVO.getSourceSupplierId())).getData();
        equipmentNoticeSupplierEntity.setSupplierName(supplierVO.getName());
        equipmentNoticeSupplierEntity.setSupplierEmployeeId(equipmentNoticeSupplierVO.getEmployeeId());
        equipmentNoticeSupplierEntity.setSupplierEmployeeName(equipmentNoticeSupplierVO.getEmployeeName());
        equipmentNoticeSupplierEntity.setSupplierEmployeeMobile(equipmentNoticeSupplierVO.getEmployeeMobile());
        equipmentNoticeSupplierEntity.setId(null);
        equipmentNoticeSupplierEntity.setState(0);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(EquipmentNoticeEntity::getInviteId, (Object)equipmentNoticeSupplierVO.getSourceId());
        List noticeEntityList = this.service.list((Wrapper)queryWrapper);
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(EquipmentNoticeSupplierEntity::getSourceSupplierId, (Object)equipmentNoticeSupplierVO.getSourceSupplierId())).eq(EquipmentNoticeSupplierEntity::getNoticeId, (Object)((EquipmentNoticeEntity)((Object)noticeEntityList.get(0))).getId())).eq(BaseEntity::getDr, (Object)0);
        List supplierEntityList = this.noticeSupplierService.list((Wrapper)lambdaQueryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)supplierEntityList)) {
            this.noticeSupplierService.removeById(((EquipmentNoticeSupplierEntity)((Object)supplierEntityList.get(0))).getId());
        }
        boolean b = this.noticeSupplierService.saveOrUpdate((Object)equipmentNoticeSupplierEntity);
        List pzList = equipmentNoticeSupplierVO.getSupplyFileList();
        this.logger.info("\u62a5\u540d\u6587\u4ef6:{}", (Object)JSONObject.toJSONString((Object)pzList));
        if (CollectionUtils.isNotEmpty((Collection)pzList)) {
            ArrayList list = new ArrayList();
            pzList.forEach(e -> {
                AttachmentVO attachmentVO = new AttachmentVO();
                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
                attachmentVO.setSourceId(equipmentNoticeSupplierEntity.getId());
                attachmentVO.setSourceType("BmSupplierFileType");
                attachmentVO.setFilePath(e.getFilePath());
                attachmentVO.setOnlinePath(e.getFilePath());
                attachmentVO.setFileName(e.getFileName());
                attachmentVO.setId(e.getFileId());
                list.add(attachmentVO);
                this.logger.info("\u4fdd\u5b58\u6587\u4ef6\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)attachmentVO));
            });
            CommonResponse stringCommonResponse = this.attachmentApi.insertBatch(list);
            this.logger.info(request + "\u62a5\u540d\u6587\u4ef6\u4e0a\u4f20\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
        }
        return CommonResponse.success((String)"\u62a5\u540d\u60c5\u51b5\u63a5\u53e3\u6389\u7528\u6210\u529f", (Object)b);
    }

    @ApiOperation(value="\u5254\u9664\u4f9b\u5e94\u5546")
    @RequestMapping(value={"/deleteSupplier"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse deleteSupplier(@RequestBody EquipmentNoticeSupplierVO equipmentNoticeSupplierVO) {
        ArrayList<EquipmentNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<EquipmentNoticeSupplierDetailTbVO>();
        EquipmentNoticeEntity equipmentNoticeEntity = (EquipmentNoticeEntity)((Object)this.service.selectById(equipmentNoticeSupplierVO.getNoticeId()));
        EquipmentNoticeSupplierDetailTbVO equipmentNoticeSupplierDetailTbVO = new EquipmentNoticeSupplierDetailTbVO();
        equipmentNoticeSupplierDetailTbVO.setSourceId(equipmentNoticeEntity.getInviteId().toString());
        equipmentNoticeSupplierDetailTbVO.setTenantId(equipmentNoticeSupplierVO.getTenantId());
        equipmentNoticeSupplierDetailTbVO.setSourceSupplierId(equipmentNoticeSupplierVO.getSupplierId().toString());
        equipmentNoticeSupplierDetailTbVO.setOutReason(equipmentNoticeSupplierVO.getOutReason() == null ? "\u8d85\u65f6\u672a\u62a5\u540d" : equipmentNoticeSupplierVO.getOutReason());
        supplierDetailTbVOList.add(equipmentNoticeSupplierDetailTbVO);
        CommonResponse response = null;
        try {
            response = this.systemDataPushService.exchangeDataWithUniversal(this.updateSupStatusUrl, RequestMethod.POST, JSON.toJSONString(supplierDetailTbVOList), this.appId, this.appSecret, this.appHost);
            if (!response.isSuccess()) {
                return CommonResponse.error((String)("\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25\uff0c" + response.getMsg()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25");
        }
        this.noticeSupplierService.updateState(equipmentNoticeSupplierVO.getId());
        return CommonResponse.success((String)"\u5254\u9664\u4f9b\u5e94\u5546\u6210\u529f");
    }
}

