package com.ejianc.business.tender.equipment.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;

/**
 * 招标公告主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tender_equipment_notice")
public class EquipmentNoticeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="invite_id")
    private Long inviteId; // 招标ID
    @TableField(value="purchase_type")
    private Integer purchaseType; // 采购方式(0-项目采购,1-单位采购)
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="unit_id")
    private Long unitId; // 招标单位ID
    @TableField(value="unit_name")
    private String unitName; // 招标单位名称
    @TableField(value="notice_name")
    private String noticeName; // 公告名称
    @TableField(value="employee_id")
    private Long employeeId; // 招标联系人
    @TableField(value="employee_name")
    private String employeeName; // 招标联系人名称
    @TableField(value="employee_mobile")
    private String employeeMobile; // 招标联系人电话
    @TableField(value="notice_start_time")
    private java.util.Date noticeStartTime; // 报名开始时间
    @TableField(value="notice_end_time")
    private java.util.Date noticeEndTime; // 报名截止时间
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="notice_content")
    private String noticeContent; // 公告内容
    @TableField(value="tender_type")
    private Integer tenderType; // 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="publish_flag")
    private Integer publishFlag; // 是否发布,0-是,1-否
    @TableField(value="purchase_id")
    private String purchaseId; // 采购方式ID
    @TableField(value="purchase_name")
    private String purchaseName; // 采购方式名称
    @TableField(value="value_type")
    private Integer valueType; // 计价方式(0-固定单价,1-浮动单价,2-固定总额)


    @TableField(exist=false)
    @SubEntity(serviceName="equipmentNoticeDetailService", pidName= "noticeId")
    private List<EquipmentNoticeDetailEntity> noticeDetail = new ArrayList<>(); // 材料招标公告采购清单表
    @TableField(exist=false)
    @SubEntity(serviceName="equipmentNoticeChangeService", pidName= "noticeId")
    private List<EquipmentNoticeChangeEntity> noticeChangeDetail = new ArrayList<>(); // 材料招标公告变更记录表
    @TableField(exist=false)
    @SubEntity(serviceName="equipmentNoticeSupplierService", pidName= "noticeId")
    private List<EquipmentNoticeSupplierEntity> noticeSupplierDetail = new ArrayList<>(); // 材料招标立项供应商表
    @TableField(value="settlement_clause")
    private String settlementClause; // 结算条款

    public String getSettlementClause() {
        return settlementClause;
    }

    public void setSettlementClause(String settlementClause) {
        this.settlementClause = settlementClause;
    }
    public Integer getPublishFlag() {
        return publishFlag;
    }

    public void setPublishFlag(Integer publishFlag) {
        this.publishFlag = publishFlag;
    }

    public Integer getValueType() {
        return valueType;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }

    /**
     * 招标ID
     */
    public Long getInviteId() {
        return inviteId;
    }

    /**
     * 招标ID
     */
    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }
    /**
     * 采购方式(0-项目采购,1-单位采购)
     */
    public Integer getPurchaseType() {
        return purchaseType;
    }

    /**
     * 采购方式(0-项目采购,1-单位采购)
     */
    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }
    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 招标单位ID
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 招标单位ID
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 招标单位名称
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 招标单位名称
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 公告名称
     */
    public String getNoticeName() {
        return noticeName;
    }

    /**
     * 公告名称
     */
    public void setNoticeName(String noticeName) {
        this.noticeName = noticeName;
    }
    /**
     * 招标联系人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 招标联系人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 招标联系人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 招标联系人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 招标联系人电话
     */
    public String getEmployeeMobile() {
        return employeeMobile;
    }

    /**
     * 招标联系人电话
     */
    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }
    /**
     * 报名开始时间
     */
    public java.util.Date getNoticeStartTime() {
        return noticeStartTime;
    }

    /**
     * 报名开始时间
     */
    public void setNoticeStartTime(java.util.Date noticeStartTime) {
        this.noticeStartTime = noticeStartTime;
    }
    /**
     * 报名截止时间
     */
    public java.util.Date getNoticeEndTime() {
        return noticeEndTime;
    }

    /**
     * 报名截止时间
     */
    public void setNoticeEndTime(java.util.Date noticeEndTime) {
        this.noticeEndTime = noticeEndTime;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 公告内容
     */
    public String getNoticeContent() {
        return noticeContent;
    }

    /**
     * 公告内容
     */
    public void setNoticeContent(String noticeContent) {
        this.noticeContent = noticeContent;
    }
    /**
     * 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public Integer getTenderType() {
        return tenderType;
    }

    /**
     * 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public void setTenderType(Integer tenderType) {
        this.tenderType = tenderType;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public List<EquipmentNoticeDetailEntity> getNoticeDetail() {
        return noticeDetail;
    }

    public void setNoticeDetail(List<EquipmentNoticeDetailEntity> noticeDetail) {
        this.noticeDetail = noticeDetail;
    }

    public List<EquipmentNoticeChangeEntity> getNoticeChangeDetail() {
        return noticeChangeDetail;
    }

    public void setNoticeChangeDetail(List<EquipmentNoticeChangeEntity> noticeChangeDetail) {
        this.noticeChangeDetail = noticeChangeDetail;
    }

    public List<EquipmentNoticeSupplierEntity> getNoticeSupplierDetail() {
        return noticeSupplierDetail;
    }

    public void setNoticeSupplierDetail(List<EquipmentNoticeSupplierEntity> noticeSupplierDetail) {
        this.noticeSupplierDetail = noticeSupplierDetail;
    }

    public String getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }
}
