package com.ejianc.business.tender.expert.bean;

import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 评标模板主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tender_expert_template")
public class TemplateEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    

    @TableField(value="template_name")
    private String templateName; // 模板名称
    @TableField(value="template_type")
    private Integer templateType; // 模板类型(0-材料评标模板,1- 劳务评标模板 ,2-专业评标模板设备,3-采购模板,4-设备租聘模板,5-周转才租凭模板,6-其他模板)
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="state")
    private Integer state; // 起停用（0：停用，1：启用）
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    
    @TableField(exist=false)
    @SubEntity(serviceName="templateDetailService",pidName = "templateId")
    private List<TemplateDetailEntity> templateDetailEntities = new ArrayList<>(); // 评标模板指标表
    


    /**
     * 模板名称
     */
    public String getTemplateName() {
        return templateName;
    }

    /**
     * 模板名称
     */
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }
    /**
     * 模板类型(0-材料评标模板,1- 劳务评标模板 ,2-专业评标模板设备,3-采购模板,4-设备租聘模板,5-周转才租凭模板,6-其他模板)
     */
    public Integer getTemplateType() {
        return templateType;
    }

    /**
     * 模板类型(0-材料评标模板,1- 劳务评标模板 ,2-专业评标模板设备,3-采购模板,4-设备租聘模板,5-周转才租凭模板,6-其他模板)
     */
    public void setTemplateType(Integer templateType) {
        this.templateType = templateType;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 起停用（0：启用，1：停用）
     */
    public Integer getState() {
        return state;
    }

    /**
     * 起停用（0：启用，1：停用）
     */
    public void setState(Integer state) {
        this.state = state;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
    /**
     * 评标模板指标表
     */
    public List<TemplateDetailEntity> getTemplateDetailEntities() {
        return templateDetailEntities;
    }

    /**
     * 评标模板指标表
     */
    public void setTemplateDetailEntities(List<TemplateDetailEntity> templateDetailEntities) {
        this.templateDetailEntities = templateDetailEntities;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
}
