package com.ejianc.business.tender.rent.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.rent.bean.RentAdviceEntity;
import com.ejianc.business.tender.rent.bean.RentBidEntity;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.service.IRentBidService;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rent.vo.RentAdviceSupplierPushVO;
import com.ejianc.business.tender.rent.vo.RentAdviceVO;
import com.ejianc.business.tender.stuff.bean.StuffAdviceEntity;
import com.ejianc.business.tender.stuff.bean.StuffBidEntity;
import com.ejianc.business.tender.stuff.service.IStuffAdviceService;
import com.ejianc.business.tender.stuff.service.IStuffBidService;
import com.ejianc.business.tender.stuff.vo.StuffAdviceVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tender.rent.mapper.RentAdviceMapper;
import com.ejianc.business.tender.rent.bean.RentAdviceEntity;
import com.ejianc.business.tender.rent.service.IRentAdviceService;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 设备租赁-中标通知书
 * 
 * @author generator
 * 
 */
@Service("rentAdviceService")
public class RentAdviceServiceImpl extends BaseServiceImpl<RentAdviceMapper, RentAdviceEntity> implements IRentAdviceService{
    @Autowired
    private IRentInviteService rentInviteService;
    @Autowired
    private IStuffAdviceService stuffAdviceService;
    private final String PUSH_ADVICE_SERVER_URL = "/ejc-supbid-web/openapi/bid/saveBid";
    @Autowired
    private IRentBidService rentBidService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String BILL_TYPE = "BT220317000000003";//此处需要根据实际修改
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;
    @Override
    public CommonResponse<String> changeStatus(Long billId, int status, String refCode) {
        //status   发起:3,  甲方-4  已签章
        //签章状态 未签章 -0,待签章-1,已签章-2
        RentAdviceEntity rentAdviceEntity = super.selectById(billId);
        if(status == 5 || status == 6 || status == 7 || status == 8){
            rentAdviceEntity.setSignFlag(0);
        }
        if(status == 2 || status == 3){
            rentAdviceEntity.setSignFlag(1);
        }
        if(status == 4){
            rentAdviceEntity.setSignFlag(2);
            // 先同步签章附件
            ContractVO cv = new ContractVO();
            cv.setContractId(rentAdviceEntity.getId());
            cv.setContractName(rentAdviceEntity.getTitleName());
            cv.setBillType(BILL_TYPE);
            cv.setSourceType("tenderAdvice");
            ArrayList<ContractVO> cvs = new ArrayList<>();
            cvs.add(cv);

            CommonResponse<List<SignMgrPreviewVO>> signResp = signatureCommonApi.fetchSignedContract(cvs);
            if(!signResp.isSuccess()){
                throw new BusinessException("同步签章附件失败!");
            }
        }
        super.updateById(rentAdviceEntity);

        return CommonResponse.success("更新成功!");
    }

    @Override
    @Transactional
    public String sendAdvice(Long id) {
        RentAdviceEntity rentAdviceEntity = super.selectById(id);
        rentAdviceEntity.setSendFlag(0);
        super.updateById(rentAdviceEntity);
        RentInviteEntity rentInviteEntity = rentInviteService.selectById(rentAdviceEntity.getInviteId());
        RentAdviceSupplierPushVO rentAdviceSupplierPushVO = BeanMapper.map(rentAdviceEntity, RentAdviceSupplierPushVO.class);

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            throw new BusinessException("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
        }
        //设置当前系统ID
        rentAdviceSupplierPushVO.setSystemId(ejcCloudSystemCode.getData());
        rentAdviceSupplierPushVO.setSourceType("郑州一建材料中标通知书");
        rentAdviceSupplierPushVO.setSourceId(rentAdviceEntity.getId().toString());
        rentAdviceSupplierPushVO.setBidTitle(rentAdviceEntity.getTitleName());
        rentAdviceSupplierPushVO.setSourceProjectId(rentAdviceEntity.getProjectId() != null ? rentAdviceEntity.getProjectId().toString() : null);
        rentAdviceSupplierPushVO.setSourceOrgId(rentAdviceEntity.getOrgId().toString());
        rentAdviceSupplierPushVO.setSourceUnitId(rentAdviceEntity.getUnitId().toString());
//        rentAdviceSupplierPushVO.setType("TYPE_MATERIAL");
        rentAdviceSupplierPushVO.setType(CommonUtils.getGysType(CommonUtils.TYPE_RENT));
        rentAdviceSupplierPushVO.setTenderType(rentInviteEntity.getTenderType());
        rentAdviceSupplierPushVO.setBidDate(rentAdviceEntity.getNoticeDate());
        rentAdviceSupplierPushVO.setMoney(rentAdviceEntity.getMoney());
        rentAdviceSupplierPushVO.setMoneyTax(rentAdviceEntity.getMoneyTax());

        String dataInfo = JSONObject.toJSONString(rentAdviceSupplierPushVO);

        boolean b = stuffAdviceService.pushBillToSupCenter(dataInfo, rentAdviceEntity.getSupplierId(), rentAdviceEntity.getId(),
                BILL_TYPE, PUSH_ADVICE_SERVER_URL, rentAdviceEntity.getTitleName());
        if (!b){
            throw new BusinessException("推送供方失败!");
        }
        return null;
    }

    @Override
    public List<RentAdviceVO> queryAdviceList(Long id) {
        RentBidEntity rentBidEntity = rentBidService.selectById(id);
        LambdaQueryWrapper<RentAdviceEntity> lambdaAdvice = Wrappers.<RentAdviceEntity>lambdaQuery();
        lambdaAdvice.eq(RentAdviceEntity::getInviteId, rentBidEntity.getInviteId());
        List<RentAdviceEntity> list = super.list(lambdaAdvice);
        List<RentAdviceVO> rentAdviceVOS = BeanMapper.mapList(list, RentAdviceVO.class);
        //处理签章附件信息
        if (CollectionUtils.isNotEmpty(rentAdviceVOS)) {
            List<Long> attachIds = rentAdviceVOS.stream().map(RentAdviceVO::getId).collect(Collectors.toList());
            Map<String, List<Long>> map = new HashMap<>();
            map.put("sourceIds", attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess()) {
                List<AttachmentVO> data = listCommonResponse.getData();
                if (CollectionUtils.isNotEmpty(data)) {
                    Map<Long, AttachmentVO> attacMap = data.stream().filter(s -> s.getSourceType().equals("tenderAdvice")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                    for (RentAdviceVO rentAdviceVO : rentAdviceVOS) {
                        AttachmentVO attachmentVO = attacMap.get(rentAdviceVO.getId());
                        if (attachmentVO != null) {
                            rentAdviceVO.setAttachId(attachmentVO.getId());
                            rentAdviceVO.setFileName(attachmentVO.getFileName());
                            rentAdviceVO.setFilePath(attachmentVO.getFilePath());
                        }
                    }
                }
            }
        }
        return rentAdviceVOS;
    }
}
