package com.ejianc.business.tender.equipment.service;

import com.ejianc.business.tender.equipment.bean.EquipmentDocumentEntity;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentRecordVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentSellVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentSupplierSellVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

/**
 * 招标文件主表
 * 
 * @author generator
 * 
 */
public interface IEquipmentDocumentService extends IBaseService<EquipmentDocumentEntity> {

    EquipmentDocumentVO publishDocument(Long id) throws Exception;

    EquipmentDocumentVO bidDocument(Long id);

    EquipmentDocumentVO queryDetail(Long id);

    EquipmentDocumentVO queryDetail1(Long id, Integer num);

    EquipmentDocumentVO queryDocDetail(Long id,Integer talkNum);


    List<EquipmentDocumentSellVO> getSchemeDetail(EquipmentDocumentSellVO equipmentDocumentSellVO);

    EquipmentDocumentSupplierSellVO getSupplierSchemeDetail(Long supplierDetailId, Long documentId);

    EquipmentDocumentVO extendDocument(EquipmentDocumentRecordVO equipmentDocumentRecordVO);

    EquipmentDocumentSupplierSellVO getSupplierSchemeTalkDetail(Long supplierDetailId, Long talkId);

    EquipmentDocumentVO publishManyDocument(Long id) throws InvocationTargetException, IllegalAccessException;

    CommonResponse delSupplier(Long id);

    EquipmentDocumentVO saveManyDocument(Long id);

    EquipmentDocumentSupplierSellVO getSupplierSchemeDetailTalk(Long supplierDetailId, Long talkId);

    EquipmentDocumentVO saveDocument(Long noticeId);

    EquipmentDocumentVO queryDetailNum(Long documentId);

    Boolean supplierPushSell(HttpServletRequest request, MultipartFile file);

    String uploadById(Long attachId,Long inviteId);

    String deleteFileById(Long sourceId, List<String> fileNames);

    EquipmentDocumentSupplierSellVO getSupplierSchemeDetailDb(Long schemeId, Long documentId);

    EquipmentDocumentVO saveOrUpdates(EquipmentDocumentVO saveorUpdateVO);


    /**
     * 检查所选专家数量
     * 规则：
     *      1.集团专家、项目专家比例1:2，集团专家向上取整
     *      2.评标专家数必须为单数
     * @param documentId
     * @return
     */
    CommonResponse<Boolean> checkExpertNum(Long documentId);

}
