package com.ejianc.business.tender.other.controller;

import com.ejianc.business.tender.other.bean.OtherDocumentExpertEntity;
import com.ejianc.business.tender.other.service.IOtherDocumentExpertService;
import com.ejianc.business.tender.other.vo.OtherDocumentExpertVO;
import com.ejianc.business.tender.other.vo.OtherDocumentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;

/**
 * 招标文件专家表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("otherDocumentExpert")
@Api(value = "招标文件专家表", tags = {"招标文件专家表"})
public class OtherDocumentExpertController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IOtherDocumentExpertService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherDocumentExpertVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody OtherDocumentExpertVO saveOrUpdateVO) {
    	OtherDocumentExpertEntity entity = BeanMapper.map(saveOrUpdateVO, OtherDocumentExpertEntity.class);
    	service.saveOrUpdate(entity, false);
    	OtherDocumentExpertVO vo = BeanMapper.map(entity, OtherDocumentExpertVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherDocumentExpertVO> queryDetail(@RequestParam Long id) {
    	OtherDocumentExpertEntity entity = service.selectById(id);
    	OtherDocumentExpertVO vo = BeanMapper.map(entity, OtherDocumentExpertVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量新增")
    @RequestMapping(value = "/addBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<OtherDocumentExpertEntity>> addBatch(@RequestBody OtherDocumentVO otherDocumentVO) {
        List<OtherDocumentExpertEntity> list = service.addBatch(otherDocumentVO);
        return CommonResponse.success("新增成功！",list);
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/deleteByIds", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<OtherDocumentExpertEntity>> deleteByIds(@RequestBody List<Long> vos) {
        List<OtherDocumentExpertEntity> list = service.deleteByIds(vos);

        return CommonResponse.success("删除成功！",list);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }




}
