package com.ejianc.business.tender.prosub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.prosub.bean.*;
import com.ejianc.business.tender.prosub.mapper.ProsubBidMapper;
import com.ejianc.business.tender.prosub.service.*;
import com.ejianc.business.tender.prosub.vo.*;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.mapper.SubBidMapper;
import com.ejianc.business.tender.sub.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 中标主表
 * 
 * @author generator
 * 
 */
@Service("prosubBidService")
public class ProsubBidServiceImpl extends BaseServiceImpl<ProsubBidMapper, ProsubBidEntity> implements IProsubBidService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProsubPicketageService subPicketageService;
    @Autowired
    private IProsubNoticeService subNoticeService;
    @Autowired
    private IProsubWinnoticeService subWinnoticeService;
    @Autowired
    private IProsubDocumentService subDocumentService;
    @Autowired
    private IProsubInviteService subInviteService;
    @Autowired
    private IProsubBidDetailService subBidDetailService;
    @Autowired
    private IProsubDocumentSellService subDocumentSellService;
    @Autowired
    private IProsubBidSupplierService subBidSupplierService;
    @Autowired
    private IProsubDocumentSupplierService subDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IProsubPicketageSupplierService subPicketageSupplierService;
    @Autowired
    private IOrgApi iOrgApi;
    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;

    @Value("${gysUrl.winbidSavesUrl}")
    private String winbidSavesUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    private org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-bid-code";//此处需要根据实际修改
    @Override
    public ProsubBidVO saveBid(Long picketageId) {
        ProsubBidEntity entity = new ProsubBidEntity();
        entity.setPicketageId(picketageId);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        ProsubPicketageEntity subPicketageEntity = subPicketageService.selectById(picketageId);
        ProsubInviteEntity inviteEntity = subInviteService.selectById(subPicketageEntity.getInviteId());
        entity.setInviteId(subPicketageEntity.getInviteId());
        entity.setBidName(inviteEntity.getTenderName());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        boolean b = super.saveOrUpdate(entity, false);
        logger.info("bidSave"+b);
        ProsubBidVO vo = BeanMapper.map(entity, ProsubBidVO.class);

        //回写定标数据
//        subPicketageEntity.setBidStatus(1);
        subPicketageEntity.setBidId(entity.getId());
        subPicketageService.updateById(subPicketageEntity);

        //处理供应商信息
        //获取材料明细报价
        LambdaQueryWrapper<ProsubDocumentSellEntity> lambdaSell = Wrappers.<ProsubDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(ProsubDocumentSellEntity::getDocumentId, subPicketageEntity.getDocumentId());
        lambdaSell.eq(ProsubDocumentSellEntity::getTenderFlag, 1);
        List<ProsubDocumentSellEntity> sellList = subDocumentSellService.list(lambdaSell);
        List<ProsubDocumentSellVO> subDocumentSellVOS = BeanMapper.mapList(sellList, ProsubDocumentSellVO.class);
        Map<Long, List<ProsubDocumentSellVO>> sellMap = subDocumentSellVOS.stream().
                collect(Collectors.groupingBy(ProsubDocumentSellVO::getSupplierId));

        //查看供应商信息
        LambdaQueryWrapper<ProsubDocumentSupplierEntity> lambdaSupplier = Wrappers.<ProsubDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(ProsubDocumentSupplierEntity::getDocumentId, subPicketageEntity.getDocumentId());
        lambdaSupplier.eq(ProsubDocumentSupplierEntity::getTalkNum, 0);
        List<ProsubDocumentSupplierEntity> supplierList = subDocumentSupplierService.list(lambdaSupplier);
        Map<Long, ProsubDocumentSupplierEntity> supplierEntityMap = supplierList.stream().collect(Collectors.toMap(ProsubDocumentSupplierEntity::getSupplierId, Function.identity()));

        //遍历map,组合数据返回
        ArrayList<ProsubBidSupplierVO> supplierVOList = new ArrayList<>();
        List<ProsubBidDetailEntity> subBidDetailEntityList = new ArrayList<>();
        sellMap.forEach((key,value) -> {
            ProsubBidSupplierVO subBidSupplierVO = new ProsubBidSupplierVO();
            subBidSupplierVO.setSupplierId(key);
            subBidSupplierVO.setSupplierName(value.stream().findFirst().get().getSupplierName());
            ProsubDocumentSupplierEntity subDocumentSupplierEntity = supplierEntityMap.get(key);
            subBidSupplierVO.setLinkName(subDocumentSupplierEntity.getLinkName());
            subBidSupplierVO.setSupplierMobile(subDocumentSupplierEntity.getLinkMobile());
            subBidSupplierVO.setId(IdWorker.getId());

            //汇总中标金额
            BigDecimal tenderMoneyTax = BigDecimal.ZERO;
            BigDecimal tenderMoney = BigDecimal.ZERO;

            for (ProsubDocumentSellVO subDocumentSellVO : value) {
                //汇总金额
                tenderMoneyTax = tenderMoneyTax
                        .add(subDocumentSellVO.getTenderMoneyTax() == null ? BigDecimal.ZERO : subDocumentSellVO
                                .getTenderMoneyTax());
                tenderMoney = tenderMoney
                        .add(subDocumentSellVO.getTenderMoney() == null ? BigDecimal.ZERO : subDocumentSellVO
                                .getTenderMoney());
                ProsubBidDetailEntity subBidDetailEntity = BeanMapper.map(subDocumentSellVO, ProsubBidDetailEntity.class);
                subBidDetailEntity.setMoney(subDocumentSellVO.getTenderMoney());
                subBidDetailEntity.setMoneyTax(subDocumentSellVO.getTenderMoneyTax());
                subBidDetailEntity.setId(null);
                subBidDetailEntity.setBidSupplierId(subBidSupplierVO.getId());
                subBidDetailEntity.setBidId(entity.getId());
                subBidDetailEntityList.add(subBidDetailEntity);

            }
            subBidSupplierVO.setMoneyTax(tenderMoneyTax);
            subBidSupplierVO.setMoney(tenderMoney);
            subBidSupplierVO.setBidId(entity.getId());
            supplierVOList.add(subBidSupplierVO);
        });

        //新增供应商
        List<ProsubBidSupplierEntity> subBidSupplierEntities = BeanMapper.mapList(supplierVOList, ProsubBidSupplierEntity.class);
        subBidSupplierService.saveBatch(subBidSupplierEntities);
        subBidDetailService.saveBatch(subBidDetailEntityList);

        //回写中标供应商和数量
        String tenderUnitNum = new String();
        //查询中标供应商
        List<ProsubBidDetailEntity> bidDetailEntityList = baseMapper.selectBidSupplier(entity.getId());
        for (ProsubBidDetailEntity subBidDetailEntity : bidDetailEntityList) {
            ProsubBidSupplierEntity supplierEntity = subBidSupplierService.selectById(subBidDetailEntity.getBidSupplierId());
            BigDecimal sumNum = subBidDetailEntity.getTenderNum().setScale(4,BigDecimal.ROUND_HALF_UP);
            String name = supplierEntity.getSupplierName()+"("+sumNum+"),";
            tenderUnitNum += name;
        }
        if (tenderUnitNum.length() > 1) {
            tenderUnitNum = tenderUnitNum.substring(0,tenderUnitNum.length() -1);
        }
        inviteEntity.setTenderUnitNum(tenderUnitNum);
        subInviteService.saveOrUpdate(inviteEntity);

        ProsubBidVO subBidVO = BeanMapper.map(entity, ProsubBidVO.class);
        return subBidVO;
    }

    @Override
    public ProsubBidVO queryDetail(Long bidId) {
        ProsubBidEntity subBidEntity = super.selectById(bidId);
        ProsubBidVO subBidVO = BeanMapper.map(subBidEntity, ProsubBidVO.class);
        //组合数据
        List<ProsubBidDetailVO> subBidDetailList  = subBidVO.getSubBidDetailList();
        Map<Long, List<ProsubBidDetailVO>> detailMap = subBidDetailList.stream().
                collect(Collectors.groupingBy(ProsubBidDetailVO::getBidSupplierId));
        List<ProsubBidSupplierVO> subBidSupplierList = subBidVO.getSubBidSupplierList();
        for (ProsubBidSupplierVO subBidSupplierVO : subBidSupplierList){
            subBidSupplierVO.setSubBidDetailList(detailMap.get(subBidSupplierVO.getId()));
        }
        subBidVO.setSubBidSupplierList(subBidSupplierList);
        return subBidVO;
    }
    @Transactional
    @Override
    public ProsubBidVO publishBid(ProsubBidVO saveorUpdateVO) {
        ProsubBidEntity entity = super.selectById(saveorUpdateVO.getId());
        entity.setBidContent(saveorUpdateVO.getBidContent());
        entity.setBidName(saveorUpdateVO.getBidName());
        entity.setPublishFlag(0);
        entity.setBillState(1);
        SubBidVO vo = BeanMapper.map(entity, SubBidVO.class);

        //获取中标信息
        ProsubInviteEntity subInviteEntity = subInviteService.selectById(entity.getInviteId());
        ProsubWinbidVO subWinbidVO = new ProsubWinbidVO();
        subWinbidVO.setSourceId(Long.toString(entity.getInviteId()));
        subWinbidVO.setBillCode(subInviteEntity.getBillCode());
        if (subWinbidVO.getPurchaseType()==null || subWinbidVO.getPurchaseType()==1){
            subWinbidVO.setSourceProjectId(null);
        }else {
            subWinbidVO.setSourceProjectId(Long.toString(subInviteEntity.getProjectId()));
        }
        subWinbidVO.setProjectName(subInviteEntity.getProjectName());
        subWinbidVO.setProjectCode(subInviteEntity.getProjectCode());
        subWinbidVO.setSourceOrgId(Long.toString(subInviteEntity.getOrgId()));
        subWinbidVO.setOrgName(subInviteEntity.getOrgName());
        subWinbidVO.setUnitName(subInviteEntity.getUnitName());
        subWinbidVO.setSourceUnitId(Long.toString(subInviteEntity.getUnitId()));
        subWinbidVO.setType("MATERIAL");
        subWinbidVO.setTenderName(subInviteEntity.getTenderName());
        subWinbidVO.setTenderType(subInviteEntity.getTenderType());
        subWinbidVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());

        LambdaQueryWrapper<ProsubDocumentEntity> lambdaDoc = Wrappers.<ProsubDocumentEntity>lambdaQuery();
        lambdaDoc.eq(ProsubDocumentEntity::getInviteId, entity.getInviteId());
        ProsubDocumentEntity subDocumentEntity = subDocumentService.getOne(lambdaDoc);
        subWinbidVO.setNoticeBidTime(subDocumentEntity.getBidTime());
        subWinbidVO.setNoticeWinbidTime(new Date());

        if (subInviteEntity.getTenderType()==2 || subInviteEntity.getTenderType()==3 || subInviteEntity.getTenderType()==4 || subInviteEntity.getTenderType()==5){
            subWinbidVO.setSourceEmployeeId(Long.toString(subDocumentEntity.getEmployeeId()));
            subWinbidVO.setEmployeeName(subDocumentEntity.getEmployeeName());
            subWinbidVO.setEmployeeMobile(subDocumentEntity.getEmployeeMobile());
            subWinbidVO.setPurchaseType(subDocumentEntity.getPurchaseType());
        }else {
            //查询招标公告
            LambdaQueryWrapper<ProsubNoticeEntity> lambdaNotice = Wrappers.<ProsubNoticeEntity>lambdaQuery();
            lambdaNotice.eq(ProsubNoticeEntity::getInviteId, entity.getInviteId());
            ProsubNoticeEntity noticeEntity = subNoticeService.getOne(lambdaNotice);
            subWinbidVO.setSourceEmployeeId(Long.toString(noticeEntity.getEmployeeId()));
            subWinbidVO.setEmployeeName(noticeEntity.getEmployeeName());
            subWinbidVO.setEmployeeMobile(noticeEntity.getEmployeeMobile());
            subWinbidVO.setPurchaseType(noticeEntity.getPurchaseType());
        }

        //处理供应商信息
        ProsubBidVO subBidVO = queryDetail(entity.getId());
        List<ProsubBidSupplierVO> subBidSupplierList = subBidVO.getSubBidSupplierList();
        //转换数据,推送供应商中标信息
        List<ProsubWinbidVO> subWinbidVOList = new ArrayList<>();
        for (ProsubBidSupplierVO subBidSupplierVO : subBidSupplierList){
            ProsubWinbidVO subWinbidVONew = BeanMapper.map(subWinbidVO,ProsubWinbidVO.class);
            SupplierDTO supplierVO = shareSupplierApi.queryById(subBidSupplierVO.getSupplierId()).getData();
            subWinbidVONew.setTenantId(supplierVO.getTenant());
            subWinbidVONew.setWinbidMoneyTax(subBidSupplierVO.getMoneyTax());
            subWinbidVONew.setWinbidMoney(subBidSupplierVO.getMoney());
            subWinbidVONew.setContent(subBidVO.getBidContent());
            subWinbidVONew.setWinbidType(0);

            List<ProsubBidDetailVO> subBidDetailList = subBidSupplierVO.getSubBidDetailList();
            //处理中标详情数据
            List<ProsubWinbidDetailVO> subWinbidDetailVOList = new ArrayList<>();
            for (ProsubBidDetailVO subBidDetailVO : subBidDetailList){
                ProsubWinbidDetailVO subWinbidDetailVO = new ProsubWinbidDetailVO();
                subWinbidDetailVO.setSourceId(Long.toString(entity.getInviteId()));
                subWinbidDetailVO.setRule(subBidDetailVO.getRule());
                subWinbidDetailVO.setContent(subBidDetailVO.getContent());
                subWinbidDetailVO.setDetailName(subBidDetailVO.getMaterialName());
                subWinbidDetailVO.setDetailCode(subBidDetailVO.getMaterialCode());
                subWinbidDetailVO.setUnit(subBidDetailVO.getUnit());
                subWinbidDetailVO.setSpec(subBidDetailVO.getSpec());
                subWinbidDetailVO.setBrand(subBidDetailVO.getMaterialBrand());
                subWinbidDetailVO.setSupplierBrand(subBidDetailVO.getBrand());
                subWinbidDetailVO.setPrice(subBidDetailVO.getPrice());
                subWinbidDetailVO.setPriceTax(subBidDetailVO.getPriceTax());
                subWinbidDetailVO.setMoney(subBidDetailVO.getMoney());
                subWinbidDetailVO.setMoneyTax(subBidDetailVO.getMoneyTax());
                subWinbidDetailVO.setTax(subBidDetailVO.getSellTax());
                subWinbidDetailVO.setCalculateType(subBidDetailVO.getCalculateType());
                subWinbidDetailVO.setMemo(subBidDetailVO.getMaterialMemo());
                subWinbidDetailVO.setSupplierMemo(subBidDetailVO.getMemo());
                subWinbidDetailVO.setMoney(subBidDetailVO.getMoney());
                subWinbidDetailVO.setRate(subBidDetailVO.getRate());
                subWinbidDetailVO.setTenderNum(subBidDetailVO.getTenderNum());
                subWinbidDetailVO.setNum(subBidDetailVO.getNum());
                subWinbidDetailVOList.add(subWinbidDetailVO);
            }
            subWinbidVONew.setSubWinbidDetailList(subWinbidDetailVOList);
            subWinbidVOList.add(subWinbidVONew);
        }
        String stringFb = JSONObject.toJSONString(subWinbidVOList);
        logger.info("推送供方中标信息:" +stringFb);
        //调用供方接口
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(winbidSavesUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("中标同步接口报错" + stringCommonResponse.getMsg());
        }
        return queryDetail(vo.getId());
    }

    @Override
    public ProsubBidVO queryDbDetail(Long picketage) {

        return null;
    }

    @Override
    public ProsubBidVO nextPaper(Long winnoticeId) {
        ProsubBidEntity entity = new ProsubBidEntity();
        ProsubWinnoticeEntity subWinnoticeEntity = subWinnoticeService.selectById(winnoticeId);
        ProsubInviteEntity subInviteEntity = subInviteService.selectById(subWinnoticeEntity.getInviteId());
        entity.setInviteId(subWinnoticeEntity.getInviteId());
        entity.setBidName(subInviteEntity.getTenderName());
        entity.setPurchaseType(subInviteEntity.getPurchaseType());
        entity.setWinnoticeId(winnoticeId);
        super.saveOrUpdate(entity, false);

        //回写中标公告状态
        subWinnoticeEntity.setNextFlag(1);
        subWinnoticeService.updateById(subWinnoticeEntity);

        //回写招标阶段
        subInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        subInviteService.updateById(subInviteEntity);

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(6);
        processEntity.setFrontendUrl("prosub/winLetter");
        processService.saveOrUpdate(processEntity);

        ProsubBidVO subBidVO = BeanMapper.map(entity, ProsubBidVO.class);
        return subBidVO;
    }

    @Override
    public List<ProsubPicketageSupplierVO> querySupplierList(Long picketageId) {
        ProsubBidEntity subBidEntity = super.selectById(picketageId);

        ProsubWinnoticeEntity subWinnoticeEntity = subWinnoticeService.selectById(subBidEntity.getWinnoticeId());
        LambdaQueryWrapper<ProsubPicketageSupplierEntity> lambdaSupplierList = Wrappers.lambdaQuery();
        lambdaSupplierList.eq(ProsubPicketageSupplierEntity::getPicketageId,subWinnoticeEntity.getPicketageId());
        List<ProsubPicketageSupplierEntity> listSupplier = subPicketageSupplierService.list(lambdaSupplierList);
        List<ProsubPicketageSupplierVO> subPicketageSupplierVOS = BeanMapper.mapList(listSupplier, ProsubPicketageSupplierVO.class);

        return subPicketageSupplierVOS;
    }
    @Transactional
    @Override
    public ProsubPicketageVO insertProcess(Long picketageId) {

        ProsubPicketageEntity subPicketageEntity = subPicketageService.selectById(picketageId);
        ProsubInviteEntity subInviteEntity = subInviteService.selectById(subPicketageEntity.getInviteId());
        //回写招标阶段
        subInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        subInviteService.updateById(subInviteEntity);

        //回写定标数据
        subPicketageEntity.setBidStatus(1);
        subPicketageService.updateById(subPicketageEntity);

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(subPicketageEntity.getBidId());
        processEntity.setBillName(TenderStageEnum.BID_NOTICE_STATE.getDescription());
        processEntity.setTenderId(subInviteEntity.getId());
        processEntity.setType(6);
        processEntity.setFrontendUrl("prosub/winLetter");
        processService.saveOrUpdate(processEntity);
        ProsubPicketageVO subPicketageVO = BeanMapper.map(subPicketageEntity, ProsubPicketageVO.class);
        return subPicketageVO;
    }

    @Override
    public List<ProsubPicketageSupplierVO> querySupplierDetail(Long id) {
        ProsubBidEntity subBidEntity = super.selectById(id);
        return subPicketageService.querySupplierList(subBidEntity.getPicketageId());
    }
}
