package com.ejianc.business.tender.stuff.controller;

import java.io.Serializable;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.util.SMS;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.tender.stuff.bean.StuffCheckEntity;
import com.ejianc.business.tender.stuff.service.IStuffCheckService;
import com.ejianc.business.tender.stuff.vo.StuffCheckVO;

/**
 * 材料手机端询价校验
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("stuffCheck")
public class StuffCheckController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IStuffCheckService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StuffCheckVO> saveOrUpdate(@RequestBody StuffCheckVO saveOrUpdateVO) {
        StuffCheckEntity entity = BeanMapper.map(saveOrUpdateVO, StuffCheckEntity.class);

        if (saveOrUpdateVO.getPhone() != null) {//手机号不为空
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("phone", new Parameter(QueryParam.EQ, saveOrUpdateVO.getPhone()));
            queryParam.getParams().put("yxzt", new Parameter(QueryParam.EQ, 1));
            List<StuffCheckEntity> checkEntities = service.queryList(queryParam);
            if(ListUtil.isNotEmpty(checkEntities)){
                StuffCheckEntity checkEntity = checkEntities.get(0);
                Date startDate = checkEntity.getCreateTime();
                long l = DateUtil.betweenMs(new Date(), startDate);
                if(l>300000){
                    //过期进行标识
                    checkEntity.setYxzt(3);
                    service.saveOrUpdate(checkEntity);
                } else {
                    return CommonResponse.error("请勿重复获取验证码！");
                }
            }
            QueryParam queryParam1 = new QueryParam();
            queryParam1.getParams().put("taxPayerIdentifier", new Parameter(QueryParam.EQ, saveOrUpdateVO.getTaxPayerIdentifier()));
            queryParam1.getParams().put("documentId", new Parameter(QueryParam.EQ, saveOrUpdateVO.getDocumentId()));
            queryParam1.getParams().put("yxzt", new Parameter(QueryParam.EQ, 2));

            List<StuffCheckEntity> checkEntities1 = service.queryList(queryParam1);
            if (CollectionUtils.isNotEmpty(checkEntities1) && (!saveOrUpdateVO.getPhone().equals(checkEntities1.get(0).getPhone()))){
                return CommonResponse.error("该供应商已使用其他手机号报价！");
            }
        }else {
            return CommonResponse.error("请输入手机号！");
        }

        int yzm = (int)((Math.random()*9+1)*100000);//6位随机验证码
        entity.setYzm(yzm);
        entity.setYxzt(1);

        service.saveOrUpdate(entity, false);

        //短信内容
        String context="您的验证码为："+yzm+"有效期为5分钟。【郑州一建】";
        //发送验证码
        SMS.setSendSms(saveOrUpdateVO.getPhone()+"",context);

        StuffCheckVO vo = BeanMapper.map(entity, StuffCheckVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * 1.验证码校验
     * 2.同一手机号不允许多个供应商报价校验
     * @Description
     * @param
     */
    @RequestMapping(value = "/checkYzm", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> queryDetail(@RequestBody StuffCheckVO stuffCheckVO) {

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("phone", new Parameter(QueryParam.EQ, stuffCheckVO.getPhone()));
        queryParam.getParams().put("yxzt", new Parameter(QueryParam.EQ, 1));
        queryParam.getParams().put("documentId", new Parameter(QueryParam.EQ, stuffCheckVO.getDocumentId()));
        List<StuffCheckEntity> checkEntities = service.queryList(queryParam);
        if (checkEntities.size()>0){
            StuffCheckEntity checkEntity = checkEntities.get(0);
            Date startDate = checkEntity.getCreateTime();
            long l = DateUtil.betweenMs(new Date(), startDate);
            if(l > 300000){
                return CommonResponse.error("验证码已过期，请重新获取验证码！");
            } else {
                if (checkEntity.getYzm().equals(stuffCheckVO.getYzm())){
                    checkEntity.setYxzt(2);
                    service.saveOrUpdate(checkEntity);
                    StuffCheckEntity entity = BeanMapper.map(stuffCheckVO, StuffCheckEntity.class);
                    List<StuffCheckEntity> stuffCheckEntities = service.list(Wrappers.<StuffCheckEntity>lambdaQuery()
                            .eq(StuffCheckEntity::getDocumentId, entity.getDocumentId())
                            .eq(StuffCheckEntity::getDr, 0)
                            .eq(StuffCheckEntity::getPhone,entity.getPhone())
                            .eq(StuffCheckEntity::getYxzt,2)
                            .eq(StuffCheckEntity::getDocumentId,stuffCheckVO.getDocumentId())
                    );
                    if(ListUtil.isNotEmpty(stuffCheckEntities)){
                        String taxPayerIdentifier = stuffCheckEntities.get(0).getTaxPayerIdentifier();
                        if(!entity.getTaxPayerIdentifier().equals(taxPayerIdentifier)){
                            return CommonResponse.error("该手机号已经绑定【纳税人识别号】"+taxPayerIdentifier+",禁止更改绑定供应商！");
                        }
                        //service.removeById(checkEntity.getId());
                    }
                    return CommonResponse.success("验证码校验成功！");
                }else {
                    return CommonResponse.error("验证码输入错误！");
                }
            }

        }else {
            return CommonResponse.error("未获取验证码或验证码已失效！");
        }
    }

}
