package com.ejianc.business.tender.stuff.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.tender.buildmaterial.service.ISystemRequestService;
import com.ejianc.business.tender.buildmaterial.vo.PublishTenderAttachmentsVO;
import com.ejianc.business.tender.buildmaterial.vo.PublishTenderProductsVO;
import com.ejianc.business.tender.buildmaterial.vo.PublishTenderVO;
import com.ejianc.business.tender.common.vo.SupplyFileVo;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.stuff.service.*;
import com.ejianc.business.tender.stuff.service.impl.StuffNoticeBpmServiceImpl;
import com.ejianc.business.tender.stuff.vo.*;
import com.ejianc.business.tender.util.ThirdSystemUtils;
import com.ejianc.foundation.bulidMaterialMdm.api.IBulidMaterialUserApi;
import com.ejianc.foundation.bulidMaterialMdm.vo.UserVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import static org.apache.commons.jexl2.parser.ParserConstants.eq;

/**
 * 招标公告主表
 *
 * @author generator
 */
@Controller
@RequestMapping("stuffNotice")
@Api(value = "招标公告主表", tags = {"招标公告主表"})
public class StuffNoticeController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;

    @Value("${gysUrl.updateSupStatusUrl}")
    private String updateSupStatusUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;


    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "invite-notice-code";
    ;//此处需要根据实际修改

    @Autowired
    private IStuffNoticeService service;

    @Autowired
    private IStuffInviteService inviteService;

    @Autowired
    private IStuffInviteDetailService inviteDetailService;

    @Autowired
    private IStuffNoticeDetailService noticeDetailService;

    @Autowired
    private IProcessService processSerice;

    @Autowired
    private IStuffNoticeSupplierDetailService noticeSupplierDetailService;

    @Autowired
    private IStuffInviteSupplierService inviteSupplierService;

    @Autowired
    private IStuffNoticeSupplierService noticeSupplierService;

    @Autowired
    private IStuffNoticeChangeService changeService;

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IShareSupplierApi shareSupplierApi;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    private static final String BILL_SUPPLIER_TYPE = "BT211215000000005";
    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBulidMaterialUserApi bulidMaterialUserApi;
    @Autowired
    private ISystemRequestService systemRequestService;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StuffNoticeVO> saveOrUpdate(@ApiParam(name = "saveorUpdateVO", required = true) @RequestBody StuffNoticeVO saveorUpdateVO) {
        StuffNoticeEntity entity = BeanMapper.map(saveorUpdateVO, StuffNoticeEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        StuffNoticeVO vo = BeanMapper.map(entity, StuffNoticeVO.class);
//        PublishTenderVO publishTenderVO = assemblingData(entity);
//        String notice = systemRequestService.publishNotice(publishTenderVO);
//        logger.info(notice);
        //保存招标过程记录表
//        ProcessEntity processEntity = new ProcessEntity();
//        processEntity.setBillId(entity.getId());
//        processEntity.setBillName(entity.getNoticeName());
//        processEntity.setTenderId(entity.getId());
//        processEntity.setType(0);
//        processEntity.setFrontendUrl("stuff/invite/card");
//        processSerice.saveOrUpdate(processEntity);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffNoticeVO> queryDetail(@RequestParam Long id) {
        StuffNoticeEntity entity = service.selectById(id);
        StuffNoticeVO vo = BeanMapper.map(entity, StuffNoticeVO.class);
        //处理供应商附件信息
        if (!service.selectFile(vo)) {
            CommonResponse.success("供应商附件查询失败！");
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StuffNoticeVO> vos) {
        service.removeByIds(vos.stream().map(StuffNoticeVO::getId).collect(Collectors.toList()), true);
        processSerice.remove(new LambdaQueryWrapper<ProcessEntity>().in(ProcessEntity::getBillId, vos.stream().map(StuffNoticeVO::getId).collect(Collectors.toList())));
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<StuffNoticeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<StuffNoticeEntity> page = service.queryPage(param, false);
        IPage<StuffNoticeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), StuffNoticeVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @ApiOperation("获取当前登录人手机号")
    @RequestMapping(value = "/queryPhone", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        return CommonResponse.success("查询列表数据成功！", mobilePhone);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<StuffNoticeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("StuffNotice-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refStuffNoticeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<StuffNoticeVO>> refStuffNoticeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                   String condition,
                                                                   String searchObject,
                                                                   String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<StuffNoticeEntity> page = service.queryPage(param, false);
        IPage<StuffNoticeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), StuffNoticeVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @ApiOperation("点击下一步进行下个页面数据初始化")
    @RequestMapping(value = "/nextStep", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffNoticeEntity> nextStep(String id) throws InvocationTargetException, IllegalAccessException {
        //主表赋值
        StuffInviteEntity stuffInviteEntity = inviteService.selectById(id);
        StuffNoticeEntity stuffNoticeEntity = new StuffNoticeEntity();
        BeanUtils.copyProperties(stuffNoticeEntity, stuffInviteEntity);
        stuffNoticeEntity.setNoticeName(stuffInviteEntity.getTenderName());
        stuffNoticeEntity.setInviteId(stuffInviteEntity.getId());
        stuffNoticeEntity.setId(null);
        stuffNoticeEntity.setCreateTime(null);
        stuffNoticeEntity.setUpdateTime(null);
        stuffNoticeEntity.setBillCode(null);
        stuffNoticeEntity.setBillState(null);
        stuffNoticeEntity.setCreateUserCode(null);
        stuffNoticeEntity.setUpdateUserCode(null);
        stuffNoticeEntity.setSyncEsFlag(null);
        stuffNoticeEntity.setVersion(null);
        stuffNoticeEntity.setTenantId(null);
        stuffNoticeEntity.setMemo(null);
        stuffNoticeEntity.setEmployeeId(null);
        stuffNoticeEntity.setEmployeeName(null);
        service.saveOrUpdate(stuffNoticeEntity);
        //子表赋值
        List<StuffInviteDetailEntity> stuffInviteDetailList = inviteDetailService.list(new LambdaQueryWrapper<StuffInviteDetailEntity>().eq(StuffInviteDetailEntity::getInviteId, id).eq(StuffInviteDetailEntity::getDr, 0));
        StuffNoticeDetailEntity stuffNoticeDetailEntity = new StuffNoticeDetailEntity();
        if (CollectionUtil.isNotEmpty(stuffInviteDetailList)) {
            for (StuffInviteDetailEntity stuffInviteDetailEntity : stuffInviteDetailList) {
                BeanUtils.copyProperties(stuffNoticeDetailEntity, stuffInviteDetailEntity);
                stuffNoticeDetailEntity.setNoticeId(stuffNoticeEntity.getId());
                stuffNoticeDetailEntity.setId(null);
                stuffNoticeDetailEntity.setCreateTime(null);
                stuffNoticeDetailEntity.setUpdateTime(null);
                stuffNoticeDetailEntity.setCreateUserCode(null);
                stuffNoticeDetailEntity.setUpdateUserCode(null);
                stuffNoticeDetailEntity.setSyncEsFlag(null);
                stuffNoticeDetailEntity.setVersion(null);
                stuffNoticeDetailEntity.setTenantId(null);
                noticeDetailService.saveOrUpdate(stuffNoticeDetailEntity);
            }
        }
        //供应商
        List<StuffInviteSupplierEntity> stuffInviteSupplierList = inviteSupplierService.list(new LambdaQueryWrapper<StuffInviteSupplierEntity>().eq(StuffInviteSupplierEntity::getInviteId, id).eq(StuffInviteSupplierEntity::getDr, 0));
        StuffNoticeSupplierDetailEntity stuffNoticeSupplierDetailEntity = new StuffNoticeSupplierDetailEntity();
        if (CollectionUtil.isNotEmpty(stuffInviteSupplierList)) {
            for (StuffInviteSupplierEntity stuffInviteSupplierEntity : stuffInviteSupplierList) {
                BeanUtils.copyProperties(stuffNoticeSupplierDetailEntity, stuffInviteSupplierEntity);
                stuffNoticeSupplierDetailEntity.setInviteId(stuffNoticeEntity.getInviteId());
                stuffNoticeSupplierDetailEntity.setId(null);
                stuffNoticeSupplierDetailEntity.setCreateTime(null);
                stuffNoticeSupplierDetailEntity.setUpdateTime(null);
                stuffNoticeSupplierDetailEntity.setCreateUserCode(null);
                stuffNoticeSupplierDetailEntity.setUpdateUserCode(null);
                stuffNoticeSupplierDetailEntity.setSyncEsFlag(null);
                stuffNoticeSupplierDetailEntity.setVersion(null);
                stuffNoticeSupplierDetailEntity.setTenantId(null);
                noticeSupplierDetailService.saveOrUpdate(stuffNoticeSupplierDetailEntity);
            }
        }
        //回写招标阶段
        Integer tenderStage = 2;
        inviteService.updateTenderStage(id, tenderStage);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(stuffNoticeEntity.getId());
        processEntity.setBillName("招标公告");
        processEntity.setTenderId(stuffNoticeEntity.getInviteId());
        processEntity.setType(0);
        processEntity.setFrontendUrl("stuff/notice");
        processSerice.saveOrUpdate(processEntity);
        return CommonResponse.success("初始化数据成功", stuffNoticeEntity);
    }

    @ApiOperation("延长截止时间")
    @RequestMapping(value = "/extend", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse extend(@RequestBody StuffNoticeChangeEntity stuffNoticeChangeEntity) {
        service.updateEndTime(stuffNoticeChangeEntity.getNoticeId(), stuffNoticeChangeEntity.getNewTime());
        StuffNoticeEntity stuffNoticeEntity = service.selectById(stuffNoticeChangeEntity.getNoticeId());
        //调用第三方报名接口
        Map<String, Object> map = new HashMap<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("sourceId", stuffNoticeEntity.getInviteId());
        map.put("noticeEndTime", sdf.format(stuffNoticeChangeEntity.getNewTime()));
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(updateTimeUrl, RequestMethod.POST, JSON.toJSONString(map), appId, appSecret, appHost);
            if (!response.isSuccess()) {
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        } catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        changeService.saveOrUpdate(stuffNoticeChangeEntity);
        return CommonResponse.success("延长截止时间成功！");
    }

    @ApiOperation("发布公告")
    @RequestMapping(value = "/publish", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse publish(@RequestBody StuffNoticeVO stuffNoticeVO) throws InvocationTargetException, IllegalAccessException {
        return service.publish(stuffNoticeVO);
    }

    @ApiOperation("报名情况")
    @RequestMapping(value = "/signUp", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> signUp(HttpServletRequest request) {
        logger.info("进入报名接口request-{}", JSONObject.toJSONString(request.getHeaderNames()));
        String notice = request.getParameter("bmNoticeVO");
        logger.info("报名实体信息-{}", notice);
        StuffNoticeSupplierVO stuffNoticeSupplierVO = JSON.parseObject(notice, new TypeReference<StuffNoticeSupplierVO>() {
        });

        StuffNoticeSupplierEntity stuffNoticeSupplierEntity = BeanMapper.map(stuffNoticeSupplierVO, StuffNoticeSupplierEntity.class);
        stuffNoticeSupplierEntity.setNoticeId(service.selectNotice(stuffNoticeSupplierVO.getSourceId()));
        stuffNoticeSupplierEntity.setSourceSupplierTenantId(stuffNoticeSupplierVO.getTenantId().toString());
        stuffNoticeSupplierEntity.setSupplierId(Long.valueOf(stuffNoticeSupplierVO.getSourceSupplierId()));
        SupplierDTO supplierVO = shareSupplierApi.queryById(Long.valueOf(stuffNoticeSupplierVO.getSourceSupplierId())).getData();
        stuffNoticeSupplierEntity.setSupplierName(supplierVO.getName());
        stuffNoticeSupplierEntity.setSupplierEmployeeId(stuffNoticeSupplierVO.getEmployeeId());
        stuffNoticeSupplierEntity.setSupplierEmployeeName(stuffNoticeSupplierVO.getEmployeeName());
        stuffNoticeSupplierEntity.setSupplierEmployeeMobile(stuffNoticeSupplierVO.getEmployeeMobile());
        stuffNoticeSupplierEntity.setId(null);
        stuffNoticeSupplierEntity.setState(0);
        //查询是否已经报名
        LambdaQueryWrapper<StuffNoticeEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(StuffNoticeEntity::getInviteId, stuffNoticeSupplierVO.getSourceId());
        List<StuffNoticeEntity> noticeEntityList = service.list(queryWrapper);
        LambdaQueryWrapper<StuffNoticeSupplierEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(StuffNoticeSupplierEntity::getSourceSupplierId, stuffNoticeSupplierVO.getSourceSupplierId())
                .eq(StuffNoticeSupplierEntity::getNoticeId, noticeEntityList.get(0).getId())
                .eq(StuffNoticeSupplierEntity::getDr, 0);
        List<StuffNoticeSupplierEntity> supplierEntityList = noticeSupplierService.list(lambdaQueryWrapper);
        if (CollectionUtil.isNotEmpty(supplierEntityList)) {
            noticeSupplierService.removeById(supplierEntityList.get(0).getId());
        }
        boolean b = noticeSupplierService.saveOrUpdate(stuffNoticeSupplierEntity);
        //处理附件
        List<SupplyFileVo> pzList = stuffNoticeSupplierVO.getSupplyFileList();
        logger.info("报名文件:{}", JSONObject.toJSONString(pzList));
        if(CollectionUtils.isNotEmpty(pzList)){
            List<AttachmentVO> list = new ArrayList<>();
            pzList.forEach(e->{
                AttachmentVO attachmentVO = new AttachmentVO();
                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
                attachmentVO.setSourceId(stuffNoticeSupplierEntity.getId());
                attachmentVO.setSourceType("BmSupplierFileType");
                attachmentVO.setFilePath(e.getFilePath());
                attachmentVO.setOnlinePath(e.getFilePath());
                attachmentVO.setFileName(e.getFileName());
                attachmentVO.setId(e.getFileId());
                list.add(attachmentVO);
                logger.info("保存文件信息:{}", JSONObject.toJSONString(attachmentVO));
            });
            CommonResponse<String> stringCommonResponse = attachmentApi.insertBatch(list);
            logger.info(request+"报名文件上传结果-{}",JSONObject.toJSONString(stringCommonResponse));
        }
//        //删除之前附件
//        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi
//                .queryListBySourceId(stuffNoticeSupplierEntity.getId(), BILL_SUPPLIER_TYPE, "BmSupplierFileType", null);
//        // 查询成功并有相应的文件
//        if (fileResp.isSuccess() && CollectionUtils.isNotEmpty(fileResp.getData())) {
//            logger.info("删除文件信息：{}", JSONObject.toJSONString(fileResp.getData()));
//            String ids = fileResp.getData().stream().map(AttachmentVO::getId).map(String::valueOf)
//                    .collect(Collectors.joining(","));
//            attachmentApi.delete(ids);
//        }
////        logger.info(request + "报名文件名称- {}" + file.getOriginalFilename());
////        Boolean upFlag = new ThirdSystemUtils().upFile(BASE_HOST,"BmSupplierFileType",Long.toString(stuffNoticeSupplierEntity.getId()),BILL_SUPPLIER_TYPE,file,request);
////        logger.info(request+"报名文件上传结果-{}",upFlag);
//        String authority = request.getHeader("authority");
//        String nameSourceTypeMapping = request.getParameter("fileSourceType");
//        Map mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);
//        FileUtil.getInstance()
//                .handleReqFile((MultipartHttpServletRequest) request, mp, BILL_SUPPLIER_TYPE, authority, Long.toString(stuffNoticeSupplierEntity.getId()));

        return CommonResponse.success("报名情况接口掉用成功", b);
    }

    @ApiOperation("剔除供应商")
    @RequestMapping(value = "/deleteSupplier", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse deleteSupplier(@RequestBody StuffNoticeSupplierVO stuffNoticeSupplierVO) {
        List<StuffNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
        StuffNoticeEntity stuffNoticeEntity = service.selectById(stuffNoticeSupplierVO.getNoticeId());
        StuffNoticeSupplierDetailTbVO stuffNoticeSupplierDetailTbVO = new StuffNoticeSupplierDetailTbVO();
        stuffNoticeSupplierDetailTbVO.setSourceId(stuffNoticeEntity.getInviteId().toString());
        stuffNoticeSupplierDetailTbVO.setTenantId(stuffNoticeSupplierVO.getTenantId());
        stuffNoticeSupplierDetailTbVO.setSourceSupplierId(stuffNoticeSupplierVO.getSupplierId().toString());
        stuffNoticeSupplierDetailTbVO.setOutReason(stuffNoticeSupplierVO.getOutReason() == null ? "超时未报名" : stuffNoticeSupplierVO.getOutReason());
        supplierDetailTbVOList.add(stuffNoticeSupplierDetailTbVO);

        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(updateSupStatusUrl, RequestMethod.POST, JSON.toJSONString(supplierDetailTbVOList), appId, appSecret, appHost);
            if (!response.isSuccess()) {
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        } catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        //更新供应商状态
        noticeSupplierService.updateState(stuffNoticeSupplierVO.getId());
        return CommonResponse.success("剔除供应商成功");
    }


    public PublishTenderVO assemblingData(StuffNoticeEntity stuffNoticeEntity){

        PublishTenderVO publishTenderVO = new PublishTenderVO();

        StuffInviteEntity stuffInviteEntity = inviteService.selectById(stuffNoticeEntity.getInviteId());

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");

        publishTenderVO.setBizKey(stuffNoticeEntity.getId()+"");//接入业务标识--公告id

        publishTenderVO.setBidWay(1);//招标方式: 1.公开、2，邀请（定向）
        publishTenderVO.setBidType(1);//
        publishTenderVO.setAdditionalRemarks(stuffNoticeEntity.getMemo()+"(交付日期待定！)"); // 补充说明,f

        /**
         * 招标联系人: 招标联系人和联系方式，如：[’张三’,’13999999999’] t
         */
//		stuffNoticeEntity.getEmployeeName();
//		stuffNoticeEntity.getEmployeeMobile();
        publishTenderVO.setContactPerson(new String[]{stuffNoticeEntity.getEmployeeName(), stuffNoticeEntity.getEmployeeMobile()});


        /**
         * 报价截止时间: 报价截止时间，精确到秒 yyyy-mm-dd HH:mm:ss t
         */
        publishTenderVO.setDateExpired(sdf.format(stuffNoticeEntity.getNoticeEndTime()));


        /**
         * 	交付地点: 采购标的的交付地址，需要按筑材网的省市区三级行政单位按数组形式提交，如：[”江苏”,”南通市”,”通州区”,”川姜镇菜市场”] t
         */
        String[] split = stuffInviteEntity.getAreaName().split("/");
        if (split.length == 3){
            publishTenderVO.setDeliveryAddress(new String[]{split[0],split[1],split[2],stuffInviteEntity.getAreaDetail()});
        }else {
            publishTenderVO.setDeliveryAddress(new String[]{split[0],split[1],"",stuffInviteEntity.getAreaDetail()});
        }


        /**
         * 	邀请供应商: 指定邀请投标的供应商名,如：[”上海申捷管业科技有限公司”,”上海久源经贸发展有限公司”] f
         */
        publishTenderVO.setInviteSuppliers(null);

        publishTenderVO.setInvoiceRequire(null); // 发票要求: 1.增值税专用发票、2.增值税普通发票、3.普通发票，默认为1.增值税专用发票 f


        /**
         * 	预估总价: 大致的招标预算(必须为大于1000的整数，且只保留前2位有效数值，剩余位数以0代替) t
         */
        if (stuffInviteEntity.getTenderMoney().compareTo(new BigDecimal(1000)) > 0) {
            publishTenderVO.setMoneyEstimated(stuffInviteEntity.getTenderMoney().round(
                    new MathContext(2, RoundingMode.HALF_UP)).intValue());
        }else {
            publishTenderVO.setMoneyEstimated(1000);
        }
        /**
         * 	付款约定: 文字表述结算方式和支付方式等信息 f
         */
        publishTenderVO.setPaymentAgreement(stuffInviteEntity.getSettlementClause());



        /**
         * 	项目名称: 招标项目，必须和筑材网存在的项目名一致	t
         */
        publishTenderVO.setProjectName(stuffNoticeEntity.getProjectName());

        /**
         * 	期望交付日期: 交付日期，精确到日 yyyy-mm-dd t   加一天
         */
        publishTenderVO.setReceivingDateExpect(sdf1.format(addOneDay(stuffNoticeEntity.getNoticeEndTime())));


        /**
         * 招标发起人: 筑材网账号名 t
         */
        CommonResponse<UserVO> userInfoByMdmId = bulidMaterialUserApi.getUserInfoByMdmId(stuffNoticeEntity.getEmployeeId());
        if (userInfoByMdmId.getCode() == 0){
            publishTenderVO.setUsername("zzyj_"+userInfoByMdmId.getData().getUsername());
        }else {
            throw new BusinessException("获取筑材网账号失败，请联系系统管理员！");
        }



        /**
         * 	招标技术联系人: 如：[’张三’,’13999999999’] f
         */
        publishTenderVO.setTechContactPerson(new String[]{stuffNoticeEntity.getEmployeeName(), stuffNoticeEntity.getEmployeeMobile()});

        /**
         *是否含税: 默认为“是”，表含税 f
         */
        publishTenderVO.setTaxInclude(null);

        List<PublishTenderProductsVO> products = new ArrayList<>();
        //物资子表
        if (stuffNoticeEntity.getNoticeDetail() != null){
            for (StuffNoticeDetailEntity stuffNoticeDetailEntity : stuffNoticeEntity.getNoticeDetail()) {
                PublishTenderProductsVO publishTenderProductsVO = new PublishTenderProductsVO();

                publishTenderProductsVO.setBizKey(stuffNoticeDetailEntity.getId()+""); // 接入业务标识  t
                publishTenderProductsVO.setCategoryCode(null); //采购品类: 筑材网三级品类code f

                publishTenderProductsVO.setCategoryName(stuffNoticeDetailEntity.getMaterialTypeName()); //采购品类: 以接入方PM系统的品类为准 f


                /**
                 *租赁时长: 租赁类型招标需要提交，如：[”100”,”DAY”]，支持的时间单位有YEAR,MONTH,DAY f
                 */
                publishTenderProductsVO.setLeaseDuration(null);

                publishTenderProductsVO.setProductName(stuffNoticeDetailEntity.getMaterialName()); //商品名称 t


                publishTenderProductsVO.setProductParameter(null); //	参数指标 f


                publishTenderProductsVO.setProductPlace(null); //品牌产地 f


                publishTenderProductsVO.setProductQuantity(stuffNoticeDetailEntity.getNum().floatValue()); //数量: 采购数量 t


                publishTenderProductsVO.setProductUnit(stuffNoticeDetailEntity.getUnit()); //单位 t



                publishTenderProductsVO.setProductSize(stuffNoticeDetailEntity.getSpec()); //规格型号 f


                publishTenderProductsVO.setRemark(stuffNoticeDetailEntity.getMemo()); //备注: 其他需求和说明 f

                products.add(publishTenderProductsVO);
            }
        }
        publishTenderVO.setProducts(products);

        //附件
        ArrayList<PublishTenderAttachmentsVO> publishTenderAttachmentsVOS = new ArrayList<>();

        PublishTenderAttachmentsVO publishTenderAttachmentsVO1 = new PublishTenderAttachmentsVO();
        publishTenderAttachmentsVO1.setBizKey(new Date().getTime()+""+new Random().nextInt(10000));
        publishTenderAttachmentsVO1.setFileName("招标说明.docx");
        publishTenderAttachmentsVO1.setFileUrl("http://csqlh.zzyjjt.com/group1/M00/00/86/rBABl2WFMVGAOurvAAAo4w5Eydo01.docx");
        publishTenderAttachmentsVOS.add(publishTenderAttachmentsVO1);

        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryListBySourceId(stuffNoticeEntity.getId(), "BT211110000000002", "zcwfile", null);
        if (listCommonResponse.getCode() == 0){
            List<AttachmentVO> data = listCommonResponse.getData();
            if (data != null && data.size()>0){
                for (AttachmentVO datum : data) {
                    PublishTenderAttachmentsVO publishTenderAttachmentsVO = new PublishTenderAttachmentsVO();
                    publishTenderAttachmentsVO.setBizKey(datum.getId()+"");
                    publishTenderAttachmentsVO.setFileName(datum.getFileName());
                    publishTenderAttachmentsVO.setFileUrl(datum.getTruePath());
                    publishTenderAttachmentsVOS.add(publishTenderAttachmentsVO);
                }
            }else {

            }
        }
        publishTenderVO.setAttachments(publishTenderAttachmentsVOS);
        return publishTenderVO;
    }


    public Date addOneDay(Date date)
    {
        Calendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.add(calendar.DATE,1);
        return calendar.getTime();
    }
}
