package com.ejianc.business.tender.stuff.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.tender.buildmaterial.service.ISystemRequestService;
import com.ejianc.business.tender.buildmaterial.vo.PublishTenderAttachmentsVO;
import com.ejianc.business.tender.buildmaterial.vo.PublishTenderProductsVO;
import com.ejianc.business.tender.buildmaterial.vo.PublishTenderVO;
import com.ejianc.business.tender.stuff.bean.StuffDocumentEntity;
import com.ejianc.business.tender.stuff.bean.StuffInviteDetailEntity;
import com.ejianc.business.tender.stuff.bean.StuffInviteEntity;
import com.ejianc.business.tender.stuff.bean.StuffNoticeEntity;
import com.ejianc.business.tender.stuff.service.IStuffDocumentService;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.stuff.service.IStuffNoticeService;
import com.ejianc.foundation.bulidMaterialMdm.api.IBulidMaterialUserApi;
import com.ejianc.foundation.bulidMaterialMdm.vo.UserVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.*;

@Service("stuffDocument") 
public class StuffDocumentBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IStuffNoticeService noticeService;

	@Autowired
	private IStuffInviteService inviteService;

	@Autowired
	private IStuffDocumentService documentService;

	@Autowired
	private ISystemRequestService systemRequestService;

	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IBulidMaterialUserApi bulidMaterialUserApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		//如果推送筑材网，则修改报价截止时间
//		StuffDocumentEntity stuffDocumentEntity = documentService.selectById(billId);
//
//		if(stuffDocumentEntity != null && stuffDocumentEntity.getNoticeId() != null) {
//			StuffNoticeEntity stuffNoticeEntity = noticeService.selectById(stuffDocumentEntity.getNoticeId());
//			//公开招标推送筑材网，邀请和询价后续探讨是否推送;不是浮动单价，浮动单价不支持
//			if (stuffNoticeEntity.getTenderType() == 0 && stuffNoticeEntity.getValueType() != 1) {
//				//组装发送数据
//				logger.info("推送筑材网发布招标信息：{}", stuffNoticeEntity.getId());
//				String notice = systemRequestService.publishNotice(assemblingData(stuffNoticeEntity,stuffDocumentEntity));
//				logger.info("推送筑材网发布招标信息返回：{}", notice);
//				JSONObject jsonObject = JSONObject.parseObject(notice);
//				Integer code = jsonObject.getInteger("code");
//				if (code == 0) {
//					String zcwCode = jsonObject.getString("object");
//
//					//招标立项页面回写 是否推送筑材网
//					inviteService.updateIsPushZcw(stuffNoticeEntity.getInviteId().toString(), 1, zcwCode);
//					logger.info("招标立项页面回写推送筑材网");
//				}
//
//			}else if (stuffNoticeEntity.getTenderType() == 0 && stuffNoticeEntity.getValueType() == 1){
//				//公开招标+浮动单价
//				//组装发送数据
//				logger.info("推送筑材网发布招标信息：{}", stuffNoticeEntity.getId());
//				String notice = systemRequestService.publishNotice(assemblingDataFolat(stuffNoticeEntity,stuffDocumentEntity));
//				logger.info("推送筑材网发布招标信息返回：{}", notice);
//				JSONObject jsonObject = JSONObject.parseObject(notice);
//				Integer code = jsonObject.getInteger("code");
//				if (code == 0) {
//					String zcwCode = jsonObject.getString("object");
//
//					//招标立项页面回写 是否推送筑材网
//					inviteService.updateIsPushZcw(stuffNoticeEntity.getInviteId().toString(), 1, zcwCode);
//					logger.info("招标立项页面回写推送筑材网");
//				}
//			}
//		}
//		if (stuffDocumentEntity != null){
//			StuffInviteEntity stuffInviteEntity = inviteService.selectById(stuffDocumentEntity.getInviteId());
//			if (stuffInviteEntity != null && stuffInviteEntity.getIsPushZcw() == 1) {//确认推送筑材网
//				StuffNoticeEntity stuffNoticeEntity = noticeService.selectById(stuffDocumentEntity.getNoticeId());
//				if (stuffNoticeEntity != null) {
//					//组装发送数据
//					logger.info("推送筑材网修改报价时间：{}", stuffNoticeEntity.getId());
//					String notice = systemRequestService.publishNoticeUpdate(assemblingData(stuffNoticeEntity,stuffInviteEntity,stuffDocumentEntity));
//					logger.info("推送筑材网修改报价时间返回：{}", notice);
//				}
//			}
//		}


		//新增逻辑：询价招标审批通过自动触发发布逻辑
//		StuffDocumentEntity stuffDocumentEntity = documentService.selectById(billId);
//		if (stuffDocumentEntity != null && stuffDocumentEntity.getTenderType() == 2){
//            try {
//                documentService.publishDocument(billId);
//            } catch (Exception e) {
//                //throw new RuntimeException(e);
//				return CommonResponse.error(e.getMessage());
//            }
//        }
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该功能不支持！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 拼装推送筑材网数据--固定单价
	 * @param stuffNoticeEntity
	 * @return
	 */
	public PublishTenderVO assemblingData(StuffNoticeEntity stuffNoticeEntity,StuffDocumentEntity stuffDocumentEntity){

		PublishTenderVO publishTenderVO = new PublishTenderVO();

		StuffInviteEntity stuffInviteEntity = inviteService.selectById(stuffNoticeEntity.getInviteId());

		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");

		publishTenderVO.setBizKey(stuffNoticeEntity.getId()+"");//接入业务标识--公告id

		publishTenderVO.setBidWay(1);//招标方式: 1.公开、2，邀请（定向）
		publishTenderVO.setBidType(1);//
		if (stuffNoticeEntity.getMemo() == null){
			stuffNoticeEntity.setMemo("");
		}
		publishTenderVO.setAdditionalRemarks(stuffNoticeEntity.getMemo()+"(交付日期待定！)"); // 补充说明,f

		/**
		 * 招标联系人: 招标联系人和联系方式，如：[’张三’,’13999999999’] t
		 */
//		stuffNoticeEntity.getEmployeeName();
//		stuffNoticeEntity.getEmployeeMobile();
		publishTenderVO.setContactPerson(new String[]{stuffNoticeEntity.getEmployeeName(), stuffNoticeEntity.getEmployeeMobile()});


		/**
		 * 报价截止时间: 报价截止时间，精确到秒 yyyy-mm-dd HH:mm:ss t
		 */
		publishTenderVO.setDateExpired(sdf.format(stuffDocumentEntity.getOfferEndTime()));


		/**
		 * 	交付地点: 采购标的的交付地址，需要按筑材网的省市区三级行政单位按数组形式提交，如：[”江苏”,”南通市”,”通州区”,”川姜镇菜市场”] t
		 */
		String[] split = stuffInviteEntity.getAreaName().split("/");
		if (split.length == 3){
			publishTenderVO.setDeliveryAddress(new String[]{split[0],split[1],split[2],stuffInviteEntity.getAreaDetail()});
		}else {
			publishTenderVO.setDeliveryAddress(new String[]{split[0],split[1],"",stuffInviteEntity.getAreaDetail()});
		}


		/**
		 * 	邀请供应商: 指定邀请投标的供应商名,如：[”上海申捷管业科技有限公司”,”上海久源经贸发展有限公司”] f
		 */
		publishTenderVO.setInviteSuppliers(null);

		publishTenderVO.setInvoiceRequire(null); // 发票要求: 1.增值税专用发票、2.增值税普通发票、3.普通发票，默认为1.增值税专用发票 f


		/**
		 * 	预估总价: 大致的招标预算(必须为大于1000的整数，且只保留前2位有效数值，剩余位数以0代替) t
		 */
		if (stuffInviteEntity.getTenderMoney().compareTo(new BigDecimal(1000)) > 0) {
			publishTenderVO.setMoneyEstimated(stuffInviteEntity.getTenderMoney().round(
					new MathContext(2, RoundingMode.HALF_UP)).intValue());
		}else {
			publishTenderVO.setMoneyEstimated(1000);
		}
		/**
		 * 	付款约定: 文字表述结算方式和支付方式等信息 f
		 */
		publishTenderVO.setPaymentAgreement(stuffInviteEntity.getSettlementClause());



		/**
		 * 	项目名称: 招标项目，必须和筑材网存在的项目名一致	t
		 */
		publishTenderVO.setProjectName(stuffNoticeEntity.getProjectName());

		/**
		 * 	期望交付日期: 交付日期，精确到日 yyyy-mm-dd t   加一天
		 */
		publishTenderVO.setReceivingDateExpect(sdf1.format(addOneDay(stuffDocumentEntity.getOfferEndTime())));




		/**
		 * 招标发起人: 筑材网账号名 t     zzyj_+手机号
		 */
		CommonResponse<UserVO> userInfoByMdmId = bulidMaterialUserApi.getUserInfoByMdmId(stuffNoticeEntity.getEmployeeId());
		if (userInfoByMdmId.getCode() == 0){
			publishTenderVO.setUsername("zzyj_"+userInfoByMdmId.getData().getUsername());
		}else {
			// throw new BusinessException("获取筑材网账号失败，请联系系统管理员！");
			logger.info("获取筑材网账号失败！：{}", JSONObject.toJSONString(userInfoByMdmId));
		}

		/**
		 * 	招标技术联系人: 如：[’张三’,’13999999999’] f
		 */
		publishTenderVO.setTechContactPerson(new String[]{stuffNoticeEntity.getEmployeeName(), stuffNoticeEntity.getEmployeeMobile()});

		/**
		 *是否含税: 默认为“是”，表含税 f
		 */
		publishTenderVO.setTaxInclude(null);

		List<PublishTenderProductsVO> products = new ArrayList<>();
		//物资子表
		if (stuffNoticeEntity.getNoticeDetail() != null){
			for (StuffInviteDetailEntity stuffNoticeDetailEntity : stuffInviteEntity.getStuffDetail()) {
				PublishTenderProductsVO publishTenderProductsVO = new PublishTenderProductsVO();

				publishTenderProductsVO.setBizKey(stuffNoticeDetailEntity.getId()+""); // 接入业务标识  t
				publishTenderProductsVO.setCategoryCode(null); //采购品类: 筑材网三级品类code f

				publishTenderProductsVO.setCategoryName(stuffNoticeDetailEntity.getMaterialTypeName()); //采购品类: 以接入方PM系统的品类为准 f


				/**
				 *租赁时长: 租赁类型招标需要提交，如：[”100”,”DAY”]，支持的时间单位有YEAR,MONTH,DAY f
				 */
				publishTenderProductsVO.setLeaseDuration(null);

				publishTenderProductsVO.setProductName(stuffNoticeDetailEntity.getMaterialName()); //商品名称 t


				publishTenderProductsVO.setProductParameter(null); //	参数指标 f


				publishTenderProductsVO.setProductPlace(null); //品牌产地 f


				publishTenderProductsVO.setProductQuantity(stuffNoticeDetailEntity.getNum().floatValue()); //数量: 采购数量 t


				publishTenderProductsVO.setProductUnit(stuffNoticeDetailEntity.getUnit()); //单位 t



				publishTenderProductsVO.setProductSize(stuffNoticeDetailEntity.getSpec()); //规格型号 f


				publishTenderProductsVO.setRemark(stuffNoticeDetailEntity.getMemo()); //备注: 其他需求和说明 f

				products.add(publishTenderProductsVO);
			}
		}
		publishTenderVO.setProducts(products);

		//附件
		ArrayList<PublishTenderAttachmentsVO> publishTenderAttachmentsVOS = new ArrayList<>();

		PublishTenderAttachmentsVO publishTenderAttachmentsVO1 = new PublishTenderAttachmentsVO();
		publishTenderAttachmentsVO1.setBizKey(new Date().getTime()+""+new Random().nextInt(10000));
		publishTenderAttachmentsVO1.setFileName("招标说明.docx");
		publishTenderAttachmentsVO1.setFileUrl("http://csqlh.zzyjjt.com/group1/M00/00/86/rBABl2WFMVGAOurvAAAo4w5Eydo01.docx");
		publishTenderAttachmentsVOS.add(publishTenderAttachmentsVO1);

		CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryListBySourceId(stuffDocumentEntity.getId(), "BT211119000000003", "documentBill02", null);
		if (listCommonResponse.getCode() == 0){
			List<AttachmentVO> data = listCommonResponse.getData();
			if (data != null && data.size()>0){
				for (AttachmentVO datum : data) {
					PublishTenderAttachmentsVO publishTenderAttachmentsVO = new PublishTenderAttachmentsVO();
					publishTenderAttachmentsVO.setBizKey(datum.getId()+"");
					publishTenderAttachmentsVO.setFileName(datum.getFileName());
					publishTenderAttachmentsVO.setFileUrl(datum.getTruePath());
					publishTenderAttachmentsVOS.add(publishTenderAttachmentsVO);
				}
			}
		}
		publishTenderVO.setAttachments(publishTenderAttachmentsVOS);

		return publishTenderVO;
	}

	/**
	 * 拼装推送筑材网数据--浮动单价
	 * @param stuffNoticeEntity
	 * @return
	 */
	public PublishTenderVO assemblingDataFolat(StuffNoticeEntity stuffNoticeEntity,StuffDocumentEntity stuffDocumentEntity){

		PublishTenderVO publishTenderVO = new PublishTenderVO();

		StuffInviteEntity stuffInviteEntity = inviteService.selectById(stuffNoticeEntity.getInviteId());

		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");

		publishTenderVO.setBizKey(stuffNoticeEntity.getId()+"");//接入业务标识--公告id

		publishTenderVO.setBidWay(1);//招标方式: 1.公开、2，邀请（定向）
		publishTenderVO.setBidType(2);// 2就是浮动单价
		if (stuffNoticeEntity.getMemo() == null){
			stuffNoticeEntity.setMemo("");
		}
		publishTenderVO.setAdditionalRemarks(stuffNoticeEntity.getMemo()+"(交付日期待定！)"); // 补充说明,f

		/**
		 * 招标联系人: 招标联系人和联系方式，如：[’张三’,’13999999999’] t
		 */
//		stuffNoticeEntity.getEmployeeName();
//		stuffNoticeEntity.getEmployeeMobile();
		publishTenderVO.setContactPerson(new String[]{stuffNoticeEntity.getEmployeeName(), stuffNoticeEntity.getEmployeeMobile()});


		/**
		 * 报价截止时间: 报价截止时间，精确到秒 yyyy-mm-dd HH:mm:ss t
		 */
		publishTenderVO.setDateExpired(sdf.format(stuffDocumentEntity.getOfferEndTime()));


		/**
		 * 	交付地点: 采购标的的交付地址，需要按筑材网的省市区三级行政单位按数组形式提交，如：[”江苏”,”南通市”,”通州区”,”川姜镇菜市场”] t
		 */
		String[] split = stuffInviteEntity.getAreaName().split("/");
		if (split.length == 3){
			publishTenderVO.setDeliveryAddress(new String[]{split[0],split[1],split[2],stuffInviteEntity.getAreaDetail()});
		}else {
			publishTenderVO.setDeliveryAddress(new String[]{split[0],split[1],"",stuffInviteEntity.getAreaDetail()});
		}


		/**
		 * 	邀请供应商: 指定邀请投标的供应商名,如：[”上海申捷管业科技有限公司”,”上海久源经贸发展有限公司”] f
		 */
		publishTenderVO.setInviteSuppliers(null);

		publishTenderVO.setInvoiceRequire(null); // 发票要求: 1.增值税专用发票、2.增值税普通发票、3.普通发票，默认为1.增值税专用发票 f


		/**
		 * 	预估总价: 大致的招标预算(必须为大于1000的整数，且只保留前2位有效数值，剩余位数以0代替) t
		 */
		if (stuffInviteEntity.getTenderMoney().compareTo(new BigDecimal(1000)) > 0) {
			publishTenderVO.setMoneyEstimated(stuffInviteEntity.getTenderMoney().round(
					new MathContext(2, RoundingMode.HALF_UP)).intValue());
		}else {
			publishTenderVO.setMoneyEstimated(1000);
		}
		/**
		 * 	付款约定: 文字表述结算方式和支付方式等信息 f
		 */
		publishTenderVO.setPaymentAgreement(stuffInviteEntity.getSettlementClause());



		/**
		 * 	项目名称: 招标项目，必须和筑材网存在的项目名一致	t
		 */
		publishTenderVO.setProjectName(stuffNoticeEntity.getProjectName());

		/**
		 * 	期望交付日期: 交付日期，精确到日 yyyy-mm-dd t   加一天
		 */
		publishTenderVO.setReceivingDateExpect(sdf1.format(addOneDay(stuffDocumentEntity.getOfferEndTime())));




		/**
		 * 招标发起人: 筑材网账号名 t     zzyj_+手机号
		 */
		CommonResponse<UserVO> userInfoByMdmId = bulidMaterialUserApi.getUserInfoByMdmId(stuffNoticeEntity.getEmployeeId());
		if (userInfoByMdmId.getCode() == 0){
			publishTenderVO.setUsername("zzyj_"+userInfoByMdmId.getData().getUsername());
		}else {
			// throw new BusinessException("获取筑材网账号失败，请联系系统管理员！");
			logger.info("获取筑材网账号失败！：{}", JSONObject.toJSONString(userInfoByMdmId));
		}

		/**
		 * 	招标技术联系人: 如：[’张三’,’13999999999’] f
		 */
		publishTenderVO.setTechContactPerson(new String[]{stuffNoticeEntity.getEmployeeName(), stuffNoticeEntity.getEmployeeMobile()});

		/**
		 *是否含税: 默认为“是”，表含税 f
		 */
		publishTenderVO.setTaxInclude(null);

		List<PublishTenderProductsVO> products = new ArrayList<>();
		//物资子表
		if (stuffNoticeEntity.getNoticeDetail() != null){
			for (StuffInviteDetailEntity stuffNoticeDetailEntity : stuffInviteEntity.getStuffDetail()) {
				PublishTenderProductsVO publishTenderProductsVO = new PublishTenderProductsVO();

				publishTenderProductsVO.setBizKey(stuffNoticeDetailEntity.getId()+""); // 接入业务标识  t
				publishTenderProductsVO.setCategoryCode(null); //采购品类: 筑材网三级品类code f

				publishTenderProductsVO.setCategoryName(stuffNoticeDetailEntity.getMaterialTypeName()); //采购品类: 以接入方PM系统的品类为准 f


				/**
				 *租赁时长: 租赁类型招标需要提交，如：[”100”,”DAY”]，支持的时间单位有YEAR,MONTH,DAY f
				 */
				publishTenderProductsVO.setLeaseDuration(null);

				publishTenderProductsVO.setProductName(stuffNoticeDetailEntity.getMaterialName()); //商品名称 t


				publishTenderProductsVO.setProductParameter(null); //	参数指标 f


				publishTenderProductsVO.setProductPlace(null); //品牌产地 f


				publishTenderProductsVO.setProductQuantity(stuffNoticeDetailEntity.getNum().floatValue()); //数量: 采购数量 t


				publishTenderProductsVO.setProductUnit(stuffNoticeDetailEntity.getUnit()); //单位 t



				publishTenderProductsVO.setProductSize(stuffNoticeDetailEntity.getSpec()); //规格型号 f


				publishTenderProductsVO.setRemark(stuffNoticeDetailEntity.getMemo()); //备注: 其他需求和说明 f

				publishTenderProductsVO.setEsPrice(stuffNoticeDetailEntity.getInfoPrice().longValue());//浮动单价参考价格

				products.add(publishTenderProductsVO);
			}
		}
		publishTenderVO.setProducts(products);

		//附件
		ArrayList<PublishTenderAttachmentsVO> publishTenderAttachmentsVOS = new ArrayList<>();

		PublishTenderAttachmentsVO publishTenderAttachmentsVO1 = new PublishTenderAttachmentsVO();
		publishTenderAttachmentsVO1.setBizKey(new Date().getTime()+""+new Random().nextInt(10000));
		publishTenderAttachmentsVO1.setFileName("招标说明.docx");
		publishTenderAttachmentsVO1.setFileUrl("http://csqlh.zzyjjt.com/group1/M00/00/86/rBABl2WFMVGAOurvAAAo4w5Eydo01.docx");
		publishTenderAttachmentsVOS.add(publishTenderAttachmentsVO1);

		CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryListBySourceId(stuffDocumentEntity.getId(), "BT211119000000003", "documentBill02", null);
		if (listCommonResponse.getCode() == 0){
			List<AttachmentVO> data = listCommonResponse.getData();
			if (data != null && data.size()>0){
				for (AttachmentVO datum : data) {
					PublishTenderAttachmentsVO publishTenderAttachmentsVO = new PublishTenderAttachmentsVO();
					publishTenderAttachmentsVO.setBizKey(datum.getId()+"");
					publishTenderAttachmentsVO.setFileName(datum.getFileName());
					publishTenderAttachmentsVO.setFileUrl(datum.getTruePath());
					publishTenderAttachmentsVOS.add(publishTenderAttachmentsVO);
				}
			}
		}
		publishTenderVO.setAttachments(publishTenderAttachmentsVOS);

		return publishTenderVO;
	}

	public Date addOneDay(Date date) {
		Calendar calendar = new GregorianCalendar();
		calendar.setTime(date);
		calendar.add(calendar.DATE,1);
		return calendar.getTime();
	}
//	/**
//	 * 拼装修改筑材网报价时间的数据
//	 * @param stuffNoticeEntity
//	 * @return
//	 */
//	public PublishTenderVO assemblingData(StuffNoticeEntity stuffNoticeEntity,StuffInviteEntity stuffInviteEntity,StuffDocumentEntity stuffDocumentEntity){
//
//		PublishTenderVO publishTenderVO = new PublishTenderVO();
//
//		/**
//		 * 	预估总价: 大致的招标预算(必须为大于1000的整数，且只保留前2位有效数值，剩余位数以0代替) t
//		 */
//		if (stuffInviteEntity.getTenderMoney().compareTo(new BigDecimal(1000)) > 0) {
//			publishTenderVO.setMoneyEstimated(stuffInviteEntity.getTenderMoney().round(
//					new MathContext(2, RoundingMode.HALF_UP)).intValue());
//		}else {
//			publishTenderVO.setMoneyEstimated(1000);
//		}
//
//		publishTenderVO.setBizKey(stuffNoticeEntity.getId()+"");//接入业务标识--公告id
//		/**
//		 * 报价截止时间: 报价截止时间，精确到秒 yyyy-mm-dd HH:mm:ss t
//		 */
//		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//		publishTenderVO.setDateExpired(sdf.format(stuffDocumentEntity.getOfferEndTime()));
//
//		return publishTenderVO;
//	}

}
