/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.prosub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentEntity;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentSchemeEntity;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentSellEntity;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentSupplierEntity;
import com.ejianc.business.tender.prosub.bean.ProsubInviteEntity;
import com.ejianc.business.tender.prosub.bean.ProsubTalkDetailEntity;
import com.ejianc.business.tender.prosub.bean.ProsubTalkEntity;
import com.ejianc.business.tender.prosub.bean.ProsubTalkRecordDetailEntity;
import com.ejianc.business.tender.prosub.bean.ProsubTalkRecordEntity;
import com.ejianc.business.tender.prosub.mapper.ProsubTalkMapper;
import com.ejianc.business.tender.prosub.service.IProsubDocumentSchemeService;
import com.ejianc.business.tender.prosub.service.IProsubDocumentSellService;
import com.ejianc.business.tender.prosub.service.IProsubDocumentService;
import com.ejianc.business.tender.prosub.service.IProsubDocumentSupplierService;
import com.ejianc.business.tender.prosub.service.IProsubInviteService;
import com.ejianc.business.tender.prosub.service.IProsubTalkDetailService;
import com.ejianc.business.tender.prosub.service.IProsubTalkRecordDetailService;
import com.ejianc.business.tender.prosub.service.IProsubTalkRecordService;
import com.ejianc.business.tender.prosub.service.IProsubTalkService;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentSellVO;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentSupplierTbVO;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentSupplierVO;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentVO;
import com.ejianc.business.tender.prosub.vo.ProsubQuotationMaterialVO;
import com.ejianc.business.tender.prosub.vo.ProsubQuotationSchemeVO;
import com.ejianc.business.tender.prosub.vo.ProsubQuotationSupplierVO;
import com.ejianc.business.tender.prosub.vo.ProsubTalkDetailVO;
import com.ejianc.business.tender.prosub.vo.ProsubTalkRecordVO;
import com.ejianc.business.tender.prosub.vo.ProsubTalkVO;
import com.ejianc.business.tender.stuff.vo.SupplierSellVO;
import com.ejianc.business.tender.sub.vo.SupplierReplenishVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="prosubTalkService")
public class ProsubTalkServiceImpl
extends BaseServiceImpl<ProsubTalkMapper, ProsubTalkEntity>
implements IProsubTalkService {
    @Value(value="${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value(value="${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value(value="${gysUrl.updateSupOffer}")
    private String updateSupOffer;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-talk-code";
    @Autowired
    private IProsubTalkDetailService subTalkDetailService;
    @Autowired
    private IProsubTalkRecordService subTalkRecordService;
    @Autowired
    private IProsubTalkRecordDetailService subTalkRecordDetailService;
    @Autowired
    private IProsubDocumentSellService subDocumentSellService;
    @Autowired
    private IProsubDocumentService subDocumentService;
    @Autowired
    private IProsubInviteService subInviteService;
    @Autowired
    private IProsubDocumentSupplierService subDocumentSupplierService;
    @Autowired
    private IProsubDocumentSchemeService subDocumentSchemeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProcessService processService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000002";

    @Override
    @Transactional
    public ProsubTalkVO publishTalk(Long id) {
        ProsubTalkEntity subTalkEntity = (ProsubTalkEntity)((Object)super.selectById((Serializable)id));
        subTalkEntity.setPublishFlag(0);
        super.updateById((Object)subTalkEntity);
        ProsubDocumentSupplierTbVO subDocumentSupplierTbVO = new ProsubDocumentSupplierTbVO();
        subDocumentSupplierTbVO.setSourceId(subTalkEntity.getInviteId().toString());
        subDocumentSupplierTbVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u6d3d\u5546\u8c08\u5224");
        subDocumentSupplierTbVO.setNoticeType(Integer.valueOf(4));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(subTalkEntity.getTalkStartTime());
        subDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(subTalkEntity.getTalkEndTime());
        subDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        subDocumentSupplierTbVO.setMemo(subTalkEntity.getMemo());
        subDocumentSupplierTbVO.setTalkMoney(subTalkEntity.getTalkMoney());
        subDocumentSupplierTbVO.setTalkNum(subTalkEntity.getTalkNum());
        subDocumentSupplierTbVO.setTenderName(subTalkEntity.getTalkName());
        subDocumentSupplierTbVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        String stringFb = JSONObject.toJSONString((Object)subDocumentSupplierTbVO);
        this.logger.info("\u6d3d\u5546\u8c08\u5224\u53d1\u5e03" + stringFb);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.saveOrUpdateUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u6d3d\u5546\u8c08\u5224\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(id);
    }

    @Override
    public ProsubTalkVO extendTalk(ProsubTalkDetailVO subTalkDetailVO) {
        ProsubTalkDetailEntity subDocumentRecordEntity = (ProsubTalkDetailEntity)((Object)BeanMapper.map((Object)subTalkDetailVO, ProsubTalkDetailEntity.class));
        this.subTalkDetailService.save((Object)subDocumentRecordEntity);
        ProsubTalkEntity subTalkEntity = (ProsubTalkEntity)((Object)super.selectById((Serializable)subTalkDetailVO.getTalkId()));
        subTalkEntity.setTalkEndTime(subTalkDetailVO.getNewTime());
        boolean b = super.updateById((Object)subTalkEntity);
        SupplierSellVO supplierSellVO = new SupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(subTalkEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(subTalkDetailVO.getNewTime());
        String stringFb = JSONObject.toJSONString((Object)supplierSellVO);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.updateTimeUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u6d3d\u5546\u8c08\u5224\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(subTalkDetailVO.getTalkId());
    }

    @Override
    public ProsubTalkVO saveTalk(Long documentId) {
        ProsubTalkEntity entity = new ProsubTalkEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        ProsubDocumentEntity documentEntity = (ProsubDocumentEntity)((Object)this.subDocumentService.selectById(documentId));
        documentEntity.setNextFlag(0);
        this.subDocumentService.saveOrUpdate((Object)documentEntity);
        ProsubDocumentEntity subDocumentEntity = (ProsubDocumentEntity)((Object)this.subDocumentService.selectById(documentId));
        ProsubInviteEntity subInviteEntity = (ProsubInviteEntity)((Object)this.subInviteService.selectById(subDocumentEntity.getInviteId()));
        entity.setProjectCode(subDocumentEntity.getProjectCode());
        entity.setInviteId(subDocumentEntity.getInviteId());
        entity.setProjectId(subDocumentEntity.getProjectId());
        entity.setProjectName(subDocumentEntity.getProjectName());
        entity.setOrgId(subDocumentEntity.getOrgId());
        entity.setOrgName(subDocumentEntity.getOrgName());
        entity.setParentOrgId(subDocumentEntity.getParentOrgId());
        entity.setParentOrgName(subDocumentEntity.getParentOrgName());
        entity.setBrandFlag(subDocumentEntity.getBrandFlag());
        entity.setBillId(documentId);
        entity.setTalkNum(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        String taikNumName = "\u7b2c" + entity.getTalkNum() + "\u8f6e\u62a5\u4ef7";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(subDocumentEntity.getPurchaseType());
        entity.setTalkName(subInviteEntity.getTenderName());
        super.save((Object)entity);
        subInviteEntity.setTenderStage(7);
        this.subInviteService.updateById((Object)subInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u6d3d\u5546\u8c08\u5224");
        processEntity.setTenderId(subDocumentEntity.getInviteId());
        processEntity.setType(6);
        processEntity.setFrontendUrl("prosub/talkNegotiate");
        this.processService.saveOrUpdate((Object)processEntity);
        ProsubTalkVO vo = (ProsubTalkVO)BeanMapper.map((Object)((Object)entity), ProsubTalkVO.class);
        ProsubTalkVO subTalkVO = this.queryDetail(vo.getId());
        return subTalkVO;
    }

    @Override
    public ProsubTalkVO queryDetail(Long id) {
        ProsubTalkEntity subTalkEntity = (ProsubTalkEntity)((Object)super.selectById((Serializable)id));
        ProsubTalkVO subTalkVO = (ProsubTalkVO)BeanMapper.map((Object)((Object)subTalkEntity), ProsubTalkVO.class);
        Integer talkNum = subTalkEntity.getTalkNum();
        if (subTalkEntity.getPublishFlag() == 1) {
            talkNum = talkNum - 1;
        }
        ProsubDocumentVO subDocumentVO = this.subDocumentService.queryDocDetailTalk(subTalkEntity.getBillId(), talkNum);
        subTalkVO.setSubDocumentDetailSellList(subDocumentVO.getSubDocumentDetailSellList());
        subTalkVO.setSubDocumentSupplierSchemeList(subDocumentVO.getSubDocumentSupplierSchemeList());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ProsubDocumentSupplierEntity::getDocumentId, (Object)subTalkEntity.getBillId());
        lambda.eq(ProsubDocumentSupplierEntity::getTalkNum, (Object)0);
        List supplierList = this.subDocumentSupplierService.list((Wrapper)lambda);
        List documentSupplierVOList = BeanMapper.mapList((Iterable)supplierList, ProsubDocumentSupplierVO.class);
        subTalkVO.setSubDocumentSupplierList(documentSupplierVOList);
        LambdaQueryWrapper lambdaRecord = Wrappers.lambdaQuery();
        lambdaRecord.eq(ProsubTalkRecordEntity::getBillId, (Object)subTalkEntity.getBillId());
        lambdaRecord.orderByAsc(ProsubTalkRecordEntity::getTalkNum);
        List subTalkRecordEntityList = this.subTalkRecordService.list((Wrapper)lambdaRecord);
        List subTalkRecordList = BeanMapper.mapList((Iterable)subTalkRecordEntityList, ProsubTalkRecordVO.class);
        subTalkVO.setTalkRecordEntityList(subTalkRecordList);
        return subTalkVO;
    }

    @Override
    @Transactional
    public ProsubTalkVO againSaveTalk(Long id) {
        ProsubTalkEntity entity = new ProsubTalkEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        ProsubTalkEntity subTalkEntity = (ProsubTalkEntity)((Object)super.selectById((Serializable)id));
        entity.setProjectCode(subTalkEntity.getProjectCode());
        entity.setProjectId(subTalkEntity.getProjectId());
        entity.setProjectName(subTalkEntity.getProjectName());
        entity.setOrgId(subTalkEntity.getOrgId());
        entity.setOrgName(subTalkEntity.getOrgName());
        entity.setParentOrgId(subTalkEntity.getParentOrgId());
        entity.setParentOrgName(subTalkEntity.getParentOrgName());
        entity.setBrandFlag(subTalkEntity.getBrandFlag());
        entity.setBillId(subTalkEntity.getBillId());
        entity.setInviteId(subTalkEntity.getInviteId());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setTalkNum(subTalkEntity.getTalkNum() + 1);
        String taikNumName = "\u7b2c" + entity.getTalkNum() + "\u8f6e\u62a5\u4ef7";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(subTalkEntity.getPurchaseType());
        super.save((Object)entity);
        ProsubTalkRecordEntity subTalkRecordEntity = (ProsubTalkRecordEntity)((Object)BeanMapper.map((Object)((Object)subTalkEntity), ProsubTalkRecordEntity.class));
        subTalkRecordEntity.setTalkId(subTalkEntity.getId());
        subTalkRecordEntity.setId(null);
        this.subTalkRecordService.save((Object)subTalkRecordEntity);
        List<ProsubTalkDetailEntity> subTalkDetailList = subTalkEntity.getSubTalkDetailList();
        List subTalkRecordDetailEntityList = BeanMapper.mapList(subTalkDetailList, ProsubTalkRecordDetailEntity.class);
        for (ProsubTalkRecordDetailEntity subTalkRecordDetailEntity : subTalkRecordDetailEntityList) {
            subTalkRecordDetailEntity.setId(null);
            subTalkRecordDetailEntity.setRecordId(subTalkRecordEntity.getId());
        }
        this.subTalkRecordDetailService.saveBatch(subTalkRecordDetailEntityList);
        super.removeById((Serializable)id, false);
        LambdaQueryWrapper lambdaProcess = Wrappers.lambdaQuery();
        lambdaProcess.eq(ProcessEntity::getBillId, (Object)id);
        lambdaProcess.eq(ProcessEntity::getTenderId, (Object)subTalkEntity.getInviteId());
        ProcessEntity processEntity = (ProcessEntity)((Object)this.processService.getOne((Wrapper)lambdaProcess));
        processEntity.setBillId(entity.getId());
        this.processService.updateById((Object)processEntity);
        ProsubTalkVO vo = (ProsubTalkVO)BeanMapper.map((Object)((Object)entity), ProsubTalkVO.class);
        this.addLastSell(subTalkEntity.getTalkNum(), subTalkEntity.getBillId());
        return this.queryDetail(entity.getId());
    }

    @Override
    public ProsubTalkVO replenishSell(Long id) {
        ProsubTalkEntity subTalkEntity = (ProsubTalkEntity)((Object)super.selectById((Serializable)id));
        Integer talkNum = subTalkEntity.getTalkNum();
        Long billId = subTalkEntity.getBillId();
        this.addLastSell(talkNum, billId);
        return new ProsubTalkVO();
    }

    @Override
    public Boolean getSellFull(Long id) {
        ProsubTalkEntity subTalkEntity = (ProsubTalkEntity)((Object)super.selectById((Serializable)id));
        Integer talkNum = subTalkEntity.getTalkNum();
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(ProsubDocumentSupplierEntity::getDocumentId, (Object)subTalkEntity.getBillId());
        lambdaSupplier.eq(ProsubDocumentSupplierEntity::getTalkNum, (Object)talkNum);
        List supplierList = this.subDocumentSupplierService.list((Wrapper)lambdaSupplier);
        LambdaQueryWrapper lambdaSupplierFirst = Wrappers.lambdaQuery();
        lambdaSupplierFirst.eq(ProsubDocumentSupplierEntity::getDocumentId, (Object)subTalkEntity.getBillId());
        lambdaSupplierFirst.eq(ProsubDocumentSupplierEntity::getTalkNum, (Object)0);
        List supplierListFirst = this.subDocumentSupplierService.list((Wrapper)lambdaSupplierFirst);
        if (supplierListFirst == null || supplierListFirst.size() == 0) {
            return false;
        }
        if (supplierList.size() != supplierListFirst.size()) {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> querySupplierList(Long talkId) {
        HashMap<String, Object> stringListMap = new HashMap<String, Object>();
        ProsubTalkEntity subTalkEntity = (ProsubTalkEntity)((Object)((ProsubTalkMapper)this.baseMapper).selectById(talkId));
        ArrayList<ProsubQuotationMaterialVO> materialVOList = new ArrayList<ProsubQuotationMaterialVO>();
        List<ProsubDocumentSellEntity> subDocumentSellEntities = this.subDocumentSellService.selectMaterialType(subTalkEntity.getBillId());
        Integer talkNum = subDocumentSellEntities.get(0).getTalkNum();
        List sellEntityList = BeanMapper.mapList(subDocumentSellEntities, ProsubDocumentSellVO.class);
        Map<String, List<ProsubDocumentSellVO>> listMap = sellEntityList.stream().filter(map -> map.getMaterialCode() != null).collect(Collectors.groupingBy(ProsubDocumentSellVO::getMaterialCode));
        for (String materialTypeId : listMap.keySet()) {
            ProsubQuotationMaterialVO materialVO = new ProsubQuotationMaterialVO();
            List<ProsubDocumentSellVO> materialTypeList = listMap.get(materialTypeId);
            for (ProsubDocumentSellVO sellVO : materialTypeList) {
                materialVO = (ProsubQuotationMaterialVO)BeanMapper.map((Object)sellVO, ProsubQuotationMaterialVO.class);
            }
            List subQuotationSupplierVOS = BeanMapper.mapList(materialTypeList, ProsubQuotationSupplierVO.class);
            List supplierVOS = subQuotationSupplierVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ProsubQuotationSupplierVO>(Comparator.comparing(f -> f.getSupplierId()))), ArrayList::new));
            materialVO.setSupplierList(supplierVOS);
            Map<Long, List<ProsubDocumentSellVO>> supplierMap = materialTypeList.stream().filter(map -> map.getSupplierId() != null).collect(Collectors.groupingBy(ProsubDocumentSellVO::getSupplierId));
            for (ProsubQuotationSupplierVO supplierVO : materialVO.getSupplierList()) {
                List<ProsubDocumentSellVO> subDocumentSellVOS = supplierMap.get(supplierVO.getSupplierId());
                for (ProsubDocumentSellVO subDocumentSellVO : subDocumentSellVOS) {
                    supplierVO.setSupplierName(subDocumentSellVO.getSupplierName());
                }
                List subQuotationSchemeVOS = BeanMapper.mapList(subDocumentSellVOS, ProsubQuotationSchemeVO.class);
                List schemeVOS = subQuotationSchemeVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ProsubQuotationSchemeVO>(Comparator.comparing(f -> f.getSchemeName()))), ArrayList::new));
                supplierVO.setSchemeList(schemeVOS);
                Map<String, List<ProsubDocumentSellVO>> schemeMap = subDocumentSellVOS.stream().filter(map -> map.getSchemeName() != null).collect(Collectors.groupingBy(ProsubDocumentSellVO::getSchemeName));
                for (ProsubQuotationSchemeVO subQuotationSchemeVO : supplierVO.getSchemeList()) {
                    List<ProsubDocumentSellVO> priceList = schemeMap.get(subQuotationSchemeVO.getSchemeName());
                    if (priceList.size() < talkNum + 1) {
                        ProsubDocumentSellVO documentSellVO = new ProsubDocumentSellVO();
                        documentSellVO.setPrice(BigDecimal.valueOf(-1L));
                        documentSellVO.setPriceTax(BigDecimal.valueOf(-1L));
                        documentSellVO.setMoney(BigDecimal.valueOf(-1L));
                        documentSellVO.setMoneyTax(BigDecimal.valueOf(-1L));
                        documentSellVO.setTalkNum(talkNum);
                        priceList.add(0, documentSellVO);
                    }
                    subQuotationSchemeVO.setPriceList(priceList);
                }
            }
            materialVOList.add(materialVO);
        }
        stringListMap.put("MaterialTypeList", materialVOList);
        stringListMap.put("offerNum", subDocumentSellEntities.get(0).getTalkNum());
        return stringListMap;
    }

    @Override
    public ProsubTalkVO saveOrUpdates(ProsubTalkVO saveorUpdateVO) {
        ProsubTalkEntity entity = (ProsubTalkEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ProsubTalkEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        ProsubTalkVO vo = (ProsubTalkVO)BeanMapper.map((Object)((Object)entity), ProsubTalkVO.class);
        ProsubTalkVO subTalkVO = this.queryDetail(vo.getId());
        return subTalkVO;
    }

    private void addLastSell(Integer talkNum, Long docId) {
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(ProsubDocumentSupplierEntity::getDocumentId, (Object)docId);
        lambdaSupplier.eq(ProsubDocumentSupplierEntity::getTalkNum, (Object)talkNum);
        List supplierList = this.subDocumentSupplierService.list((Wrapper)lambdaSupplier);
        LambdaQueryWrapper lambdaSupplierLast = Wrappers.lambdaQuery();
        lambdaSupplierLast.eq(ProsubDocumentSupplierEntity::getDocumentId, (Object)docId);
        lambdaSupplierLast.eq(ProsubDocumentSupplierEntity::getTalkNum, (Object)(talkNum - 1));
        List supplierListLast = this.subDocumentSupplierService.list((Wrapper)lambdaSupplierLast);
        List supplierPk = supplierList.stream().map(ProsubDocumentSupplierEntity::getSupplierId).collect(Collectors.toList());
        List documentSupplierEntityDataList = supplierListLast.stream().filter(s -> !supplierPk.contains(s.getSupplierId())).collect(Collectors.toList());
        List documentSupplierEntityNewList = BeanMapper.mapList(documentSupplierEntityDataList, ProsubDocumentSupplierEntity.class);
        if (documentSupplierEntityNewList.size() == 0) {
            return;
        }
        ArrayList<SupplierReplenishVO> replenishVOArrayList = new ArrayList<SupplierReplenishVO>();
        ProsubDocumentEntity subDocumentEntity = (ProsubDocumentEntity)((Object)this.subDocumentService.selectById(docId));
        for (ProsubDocumentSupplierEntity subDocumentSupplierEntity : documentSupplierEntityNewList) {
            SupplierReplenishVO supplierReplenishVO = new SupplierReplenishVO();
            supplierReplenishVO.setSourceId(Long.toString(subDocumentEntity.getInviteId()));
            supplierReplenishVO.setTalkNum(talkNum);
            if (subDocumentSupplierEntity.getSupplierTenantId() != null) {
                supplierReplenishVO.setTenantId(Long.toString(subDocumentSupplierEntity.getSupplierTenantId()));
            }
            replenishVOArrayList.add(supplierReplenishVO);
        }
        String stringFb = JSONObject.toJSONString(replenishVOArrayList);
        this.logger.info("\u518d\u6b21\u6d3d\u5546\u63a8\u9001\u4f9b\u65b9\u63a5\u53e3\u6570\u636e:" + stringFb);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.updateSupOffer, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u518d\u6b21\u6d3d\u5546\u63a8\u9001\u4f9b\u65b9\u63a5\u53e3\u6570\u636eresponse:" + stringCommonResponse.getMsg());
        }
        List supplierPkNew = documentSupplierEntityNewList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        for (ProsubDocumentSupplierEntity subDocumentSupplierEntity : documentSupplierEntityNewList) {
            subDocumentSupplierEntity.setId(IdWorker.getId());
            subDocumentSupplierEntity.setTalkNum(talkNum);
        }
        this.subDocumentSupplierService.saveBatch(documentSupplierEntityNewList);
        for (ProsubDocumentSupplierEntity subDocumentSupplierEntity : documentSupplierEntityNewList) {
            for (Object subDocumentSupplierLastEntity : supplierListLast) {
                CommonResponse responseCopy;
                if (!(subDocumentSupplierEntity.getSupplierId() != null ? subDocumentSupplierEntity.getSupplierId().equals(((ProsubDocumentSupplierEntity)((Object)subDocumentSupplierLastEntity)).getSupplierId()) && !(responseCopy = this.attachmentApi.copyFilesFromSourceBillToTargetBill(subDocumentSupplierLastEntity.getId().toString(), BILL_SUPPLIER_TYPE, "supplierFileType", subDocumentSupplierEntity.getId().toString(), BILL_SUPPLIER_TYPE, "supplierFileType")).isSuccess() : subDocumentSupplierEntity.getLinkMobile().equals(subDocumentSupplierEntity.getLinkMobile()) && !(responseCopy = this.attachmentApi.copyFilesFromSourceBillToTargetBill(subDocumentSupplierEntity.getId().toString(), BILL_SUPPLIER_TYPE, "supplierFileType", subDocumentSupplierEntity.getId().toString(), BILL_SUPPLIER_TYPE, "supplierFileType")).isSuccess())) continue;
                throw new BusinessException("\u518d\u6b21\u6d3d\u5546\u9644\u4ef6\u590d\u5236\u5931\u8d25:" + responseCopy.getMsg());
            }
        }
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(ProsubDocumentSchemeEntity::getDocumentId, (Object)docId);
        lambdaScheme.eq(ProsubDocumentSchemeEntity::getTalkNum, (Object)(talkNum - 1));
        lambdaScheme.in(ProsubDocumentSchemeEntity::getDocumentSupplierId, supplierPkNew);
        List schemeList = this.subDocumentSchemeService.list((Wrapper)lambdaScheme);
        List schemePkList = schemeList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        for (ProsubDocumentSchemeEntity subDocumentSchemeEntity : schemeList) {
            subDocumentSchemeEntity.setId(IdWorker.getId());
            subDocumentSchemeEntity.setTalkNum(talkNum);
            for (ProsubDocumentSupplierEntity subDocumentSupplierEntity : documentSupplierEntityNewList) {
                if (subDocumentSchemeEntity.getIsMobile() != 1) {
                    if (!subDocumentSchemeEntity.getSupplierId().equals(subDocumentSupplierEntity.getSupplierId())) continue;
                    subDocumentSchemeEntity.setDocumentSupplierId(subDocumentSupplierEntity.getId());
                    continue;
                }
                if (!subDocumentSchemeEntity.getSupplierName().equals(subDocumentSupplierEntity.getSupplierName())) continue;
                subDocumentSchemeEntity.setDocumentSupplierId(subDocumentSupplierEntity.getId());
            }
        }
        this.subDocumentSchemeService.saveBatch(schemeList);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(ProsubDocumentSellEntity::getDocumentId, (Object)docId);
        lambdaSell.eq(ProsubDocumentSellEntity::getTalkNum, (Object)(talkNum - 1));
        lambdaSell.in(ProsubDocumentSellEntity::getSchemeId, schemePkList);
        List sellList = this.subDocumentSellService.list((Wrapper)lambdaSell);
        for (ProsubDocumentSellEntity subDocumentSellEntity : sellList) {
            subDocumentSellEntity.setId(null);
            subDocumentSellEntity.setTalkNum(talkNum);
            for (ProsubDocumentSchemeEntity subDocumentSchemeEntity : schemeList) {
                if (subDocumentSellEntity.getIsMobile() != null) {
                    if (!subDocumentSellEntity.getSupplierId().equals(subDocumentSchemeEntity.getSupplierId()) || !subDocumentSellEntity.getSchemeName().equals(subDocumentSchemeEntity.getSchemeName())) continue;
                    subDocumentSellEntity.setSchemeId(subDocumentSchemeEntity.getId());
                    continue;
                }
                if (!subDocumentSellEntity.getSupplierName().equals(subDocumentSchemeEntity.getSupplierName()) || !subDocumentSellEntity.getSchemeName().equals(subDocumentSchemeEntity.getSchemeName())) continue;
                subDocumentSellEntity.setSchemeId(subDocumentSchemeEntity.getId());
            }
        }
        this.subDocumentSellService.saveBatch(sellList);
    }
}

