/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.mapper.ExpertRecordMapper;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rmat.bean.RmatDocumentEntity;
import com.ejianc.business.tender.rmat.bean.RmatDocumentSchemeEntity;
import com.ejianc.business.tender.rmat.bean.RmatDocumentSellEntity;
import com.ejianc.business.tender.rmat.bean.RmatDocumentSupplierEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.bean.RmatPicketageEntity;
import com.ejianc.business.tender.rmat.bean.RmatPicketageSupplierEntity;
import com.ejianc.business.tender.rmat.bean.RmatTalkEntity;
import com.ejianc.business.tender.rmat.mapper.RmatDocumentSchemeMapper;
import com.ejianc.business.tender.rmat.mapper.RmatPicketageMapper;
import com.ejianc.business.tender.rmat.service.IRmatDocumentSchemeService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentSellService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentSupplierService;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.rmat.service.IRmatPicketageService;
import com.ejianc.business.tender.rmat.service.IRmatPicketageSupplierService;
import com.ejianc.business.tender.rmat.service.IRmatTalkService;
import com.ejianc.business.tender.rmat.vo.RmatDocumentDetailVO;
import com.ejianc.business.tender.rmat.vo.RmatDocumentSellVO;
import com.ejianc.business.tender.rmat.vo.RmatDocumentVO;
import com.ejianc.business.tender.rmat.vo.RmatPicketageSupplierVO;
import com.ejianc.business.tender.rmat.vo.RmatPicketageVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="rmatPicketageService")
public class RmatPicketageServiceImpl
extends BaseServiceImpl<RmatPicketageMapper, RmatPicketageEntity>
implements IRmatPicketageService {
    private static final String BILL_CODE = "invite-picketage-code";
    @Autowired
    private IExpertEvaluatingService IExpertEvaluatingService;
    @Autowired
    private IRmatInviteService rmatInviteService;
    @Autowired
    private IRmatDocumentService rmatDocumentService;
    @Autowired
    private IRmatDocumentSellService rmatDocumentSellService;
    @Autowired
    private IRmatDocumentSchemeService rmatDocumentSchemeService;
    @Autowired
    private IRmatDocumentSupplierService rmatDocumentSupplierService;
    @Autowired
    private RmatDocumentSchemeMapper schemeMapper;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IRmatTalkService rmatTalkService;
    @Autowired
    private IRmatPicketageSupplierService rmatPicketageSupplierService;
    @Autowired
    private ExpertRecordMapper recordMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    public RmatPicketageVO savePicketage(Long evaluationId) {
        RmatPicketageEntity entity = new RmatPicketageEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        ExpertEvaluatingEntity rmatEvaluationEntity = (ExpertEvaluatingEntity)((Object)this.IExpertEvaluatingService.selectById(evaluationId));
        RmatInviteEntity inviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(rmatEvaluationEntity.getInviteId()));
        RmatDocumentEntity rmatDocumentEntity = (RmatDocumentEntity)((Object)this.rmatDocumentService.selectById(rmatEvaluationEntity.getDocumentId()));
        entity.setPicketageName(inviteEntity.getTenderName() + "\u5b9a\u6807");
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setEmployeeId(rmatDocumentEntity.getEmployeeId());
        entity.setEmployeeName(rmatDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(rmatDocumentEntity.getEmployeeMobile());
        entity.setValueType(rmatDocumentEntity.getValueType());
        RmatInviteEntity rmatInviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(rmatDocumentEntity.getInviteId()));
        entity.setPurchaseId(rmatInviteEntity.getPurchaseId());
        entity.setPurchaseName(rmatInviteEntity.getPurchaseName());
        entity.setDocumentId(rmatEvaluationEntity.getDocumentId());
        entity.setEvaluationId(rmatEvaluationEntity.getId());
        entity.setInviteId(rmatEvaluationEntity.getInviteId());
        entity.setGatherReason(rmatEvaluationEntity.getGatherReason());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(this.sessionManager.getUserContext().getEmployeeName());
        String mobilePhone = ((EmployeeVO)this.employeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone();
        entity.setTrusteesPhone(mobilePhone);
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode((Integer)inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(4));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate((Object)entity, false);
        RmatPicketageVO vo = (RmatPicketageVO)BeanMapper.map((Object)((Object)entity), RmatPicketageVO.class);
        rmatInviteEntity.setTenderStage(5);
        this.rmatInviteService.updateById((Object)rmatInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u5b9a\u6807");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("rmat/picketage");
        this.processService.saveOrUpdate((Object)processEntity);
        List<RmatDocumentSchemeEntity> schemeList = this.schemeMapper.selectSupplier(rmatDocumentEntity.getId());
        for (RmatDocumentSchemeEntity schemeEntity : schemeList) {
            BigDecimal score = this.recordMapper.selectScore(schemeEntity.getId(), schemeEntity.getSupplierId(), rmatDocumentEntity.getId());
            Boolean scoreBoolean = this.schemeMapper.updateScore(schemeEntity.getId(), schemeEntity.getSupplierId(), rmatDocumentEntity.getId(), score);
            if (scoreBoolean.booleanValue()) continue;
            throw new BusinessException("\u56de\u5199\u65b9\u6848\u5f97\u5206\u5931\u8d25!");
        }
        return vo;
    }

    @Override
    @Transactional
    public RmatPicketageVO queryDetail(Long id) {
        RmatPicketageEntity rmatPicketageEntity = (RmatPicketageEntity)((Object)super.selectById((Serializable)id));
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(RmatDocumentSupplierEntity::getDocumentId, (Object)rmatPicketageEntity.getDocumentId());
        List suppliermatityList = this.rmatDocumentSupplierService.list((Wrapper)lambdaSupplier);
        List talkNumList = suppliermatityList.stream().map(RmatDocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
        Integer talkNumMax = (Integer)talkNumList.stream().max(Integer::compareTo).get();
        RmatDocumentEntity entity = (RmatDocumentEntity)((Object)this.rmatDocumentService.selectById(rmatPicketageEntity.getDocumentId()));
        RmatDocumentVO rmatDocumentVO = (RmatDocumentVO)BeanMapper.map((Object)((Object)entity), RmatDocumentVO.class);
        List rmatDocumentDetailList = rmatDocumentVO.getRmatDocumentDetailList();
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(RmatDocumentSellEntity::getDocumentId, (Object)rmatPicketageEntity.getDocumentId());
        lambdaSell.eq(RmatDocumentSellEntity::getTalkNum, (Object)talkNumMax);
        lambdaSell.eq(RmatDocumentSellEntity::getPassFlag, (Object)1);
        lambdaSell.orderByAsc(RmatDocumentSellEntity::getSupplierId);
        lambdaSell.orderByAsc(RmatDocumentSellEntity::getSchemeName);
        List sellList = this.rmatDocumentSellService.list((Wrapper)lambdaSell);
        List rmatDocumentSellVOS = BeanMapper.mapList((Iterable)sellList, RmatDocumentSellVO.class);
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(RmatDocumentSchemeEntity::getDocumentId, (Object)rmatPicketageEntity.getDocumentId());
        lambdaScheme.eq(RmatDocumentSchemeEntity::getTalkNum, (Object)talkNumMax);
        lambdaScheme.orderByAsc(RmatDocumentSchemeEntity::getSchemeName);
        List schemeList = this.rmatDocumentSchemeService.list((Wrapper)lambdaScheme);
        for (RmatDocumentSchemeEntity rmatDocumentSchemeEntity : schemeList) {
            for (RmatDocumentSellVO rmatDocumentSellVO : rmatDocumentSellVOS) {
                if (!rmatDocumentSellVO.getSchemeId().equals(rmatDocumentSchemeEntity.getId())) continue;
                rmatDocumentSellVO.setScore(rmatDocumentSchemeEntity.getScore());
            }
        }
        RmatDocumentSellVO rmatDocumentSellFirst = (RmatDocumentSellVO)rmatDocumentSellVOS.stream().findFirst().get();
        if (rmatDocumentSellFirst.getScore() == null) {
            rmatDocumentSellVOS.sort(Comparator.comparing(BaseVO::getCreateTime).reversed());
        }
        if (rmatDocumentSellFirst.getScore() != null) {
            rmatDocumentSellVOS.sort(Comparator.comparing(RmatDocumentSellVO::getScore).reversed());
        }
        Map<Long, List<RmatDocumentSellVO>> sellMap = rmatDocumentSellVOS.stream().collect(Collectors.groupingBy(RmatDocumentSellVO::getDetailId));
        for (RmatDocumentDetailVO rmatDocumentDetailVO : rmatDocumentDetailList) {
            List<RmatDocumentSellVO> rmatDocumentSellEntities = sellMap.get(rmatDocumentDetailVO.getId());
            rmatDocumentDetailVO.setRmatDocumentSellVOList(rmatDocumentSellEntities);
        }
        RmatPicketageVO rmatPicketageVO = (RmatPicketageVO)BeanMapper.map((Object)((Object)rmatPicketageEntity), RmatPicketageVO.class);
        rmatPicketageVO.setRmatDocumentDetailList(rmatDocumentDetailList);
        if (rmatDocumentSellFirst.getScore() == null) {
            rmatPicketageVO.setScoreStatus(Integer.valueOf(1));
        }
        if (rmatDocumentSellFirst.getScore() != null) {
            rmatPicketageVO.setScoreStatus(Integer.valueOf(0));
        }
        RmatInviteEntity rmatInviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(rmatPicketageVO.getInviteId()));
        rmatPicketageVO.setRentType(rmatInviteEntity.getRentType());
        return rmatPicketageVO;
    }

    @Override
    public RmatPicketageVO saveOrUpdates(RmatPicketageVO saveorUpdateVO) {
        RmatPicketageEntity entity = (RmatPicketageEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, RmatPicketageEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(RmatPicketageSupplierEntity::getPicketageId, (Object)entity.getId());
        this.rmatPicketageSupplierService.remove((Wrapper)lambdaSupplier);
        List picketageSupplierList = saveorUpdateVO.getPicketageSupplierList();
        for (RmatPicketageSupplierVO rmatPicketageSupplierVO : picketageSupplierList) {
            rmatPicketageSupplierVO.setTenderFlag(Integer.valueOf(0));
        }
        List rmatPicketageSupplierList = BeanMapper.mapList((Iterable)picketageSupplierList, RmatPicketageSupplierEntity.class);
        this.rmatPicketageSupplierService.saveBatch(rmatPicketageSupplierList);
        List rmatDocumentDetailList = saveorUpdateVO.getRmatDocumentDetailList();
        ArrayList documentSellVOArrayList = new ArrayList();
        for (RmatDocumentDetailVO rmatDocumentDetailVO : rmatDocumentDetailList) {
            documentSellVOArrayList.addAll(rmatDocumentDetailVO.getRmatDocumentSellVOList());
        }
        List rmatDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList, RmatDocumentSellEntity.class);
        this.rmatDocumentSellService.saveOrUpdateBatch(rmatDocumentSellEntityList);
        RmatPicketageVO rmatPicketageVO = this.queryDetail(saveorUpdateVO.getId());
        return rmatPicketageVO;
    }

    @Override
    public RmatPicketageVO saveManyPicketage(Long documentId) {
        RmatPicketageEntity entity = new RmatPicketageEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        RmatDocumentEntity documentEntity = (RmatDocumentEntity)((Object)this.rmatDocumentService.selectById(documentId));
        documentEntity.setNextFlag(0);
        this.rmatDocumentService.saveOrUpdate((Object)documentEntity);
        LambdaQueryWrapper lambdaTalk = Wrappers.lambdaQuery();
        lambdaTalk.eq(RmatTalkEntity::getBillId, (Object)documentId);
        RmatTalkEntity rmatTalkEntity = (RmatTalkEntity)((Object)this.rmatTalkService.getOne((Wrapper)lambdaTalk));
        if (rmatTalkEntity != null) {
            rmatTalkEntity.setNextFlag(0);
            this.rmatTalkService.updateById((Object)rmatTalkEntity);
        }
        RmatDocumentEntity rmatDocumentEntity = (RmatDocumentEntity)((Object)this.rmatDocumentService.selectById(documentId));
        RmatInviteEntity inviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(rmatDocumentEntity.getInviteId()));
        entity.setPicketageName(inviteEntity.getTenderName() + "\u5b9a\u6807");
        entity.setEmployeeId(rmatDocumentEntity.getEmployeeId());
        entity.setEmployeeName(rmatDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(rmatDocumentEntity.getEmployeeMobile());
        entity.setValueType(rmatDocumentEntity.getValueType());
        RmatInviteEntity rmatInviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(rmatDocumentEntity.getInviteId()));
        entity.setPurchaseId(rmatInviteEntity.getPurchaseId());
        entity.setPurchaseName(rmatInviteEntity.getPurchaseName());
        entity.setPurchaseType(rmatInviteEntity.getPurchaseType());
        entity.setDocumentId(documentId);
        entity.setInviteId(rmatDocumentEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(this.sessionManager.getUserContext().getEmployeeName());
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode((Integer)inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(0));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate((Object)entity, false);
        RmatPicketageVO vo = (RmatPicketageVO)BeanMapper.map((Object)((Object)entity), RmatPicketageVO.class);
        rmatInviteEntity.setTenderStage(5);
        this.rmatInviteService.updateById((Object)rmatInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u5b9a\u6807");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("rmat/picketage");
        this.processService.saveOrUpdate((Object)processEntity);
        return vo;
    }

    @Override
    public List<RmatPicketageSupplierVO> querySupplierList(Long picketageId) {
        RmatPicketageEntity rmatPicketageEntity = (RmatPicketageEntity)((Object)super.selectById((Serializable)picketageId));
        List<RmatPicketageSupplierEntity> picketageSupplierList = rmatPicketageEntity.getPicketageSupplierList();
        List list = BeanMapper.mapList(picketageSupplierList, RmatPicketageSupplierVO.class);
        return list;
    }

    @Override
    public RmatPicketageVO saveSupplierBatch(RmatPicketageVO saveorUpdateVO) {
        RmatPicketageEntity rmatPicketageEntity = (RmatPicketageEntity)((Object)super.selectById((Serializable)saveorUpdateVO.getId()));
        List<RmatPicketageSupplierEntity> picketageSupplierList = rmatPicketageEntity.getPicketageSupplierList();
        if (CollectionUtils.isNotEmpty(picketageSupplierList)) {
            return this.queryDetail(saveorUpdateVO.getId());
        }
        List rmatPicketageSupplierEntities = BeanMapper.mapList((Iterable)saveorUpdateVO.getPicketageSupplierList(), RmatPicketageSupplierEntity.class);
        for (RmatPicketageSupplierEntity rmatPicketageSupplierEntity : rmatPicketageSupplierEntities) {
            rmatPicketageSupplierEntity.setTenderFlag(0);
        }
        this.rmatPicketageSupplierService.saveBatch(rmatPicketageSupplierEntities);
        List rmatDocumentDetailList = saveorUpdateVO.getRmatDocumentDetailList();
        ArrayList documentSellVOArrayList = new ArrayList();
        for (RmatDocumentDetailVO rmatDocumentDetailVO : rmatDocumentDetailList) {
            documentSellVOArrayList.addAll(rmatDocumentDetailVO.getRmatDocumentSellVOList());
        }
        List rmatDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList, RmatDocumentSellEntity.class);
        this.rmatDocumentSellService.saveOrUpdateBatch(rmatDocumentSellEntityList);
        return this.queryDetail(saveorUpdateVO.getId());
    }
}

