/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.stuff.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.stuff.bean.StuffDocumentEntity;
import com.ejianc.business.tender.stuff.bean.StuffInviteEntity;
import com.ejianc.business.tender.stuff.bean.StuffPicketageEntity;
import com.ejianc.business.tender.stuff.bean.StuffPicketageSupplierEntity;
import com.ejianc.business.tender.stuff.bean.StuffWinnoticeEntity;
import com.ejianc.business.tender.stuff.mapper.StuffWinnoticeMapper;
import com.ejianc.business.tender.stuff.service.IStuffBidDetailService;
import com.ejianc.business.tender.stuff.service.IStuffBidSupplierService;
import com.ejianc.business.tender.stuff.service.IStuffDocumentSellService;
import com.ejianc.business.tender.stuff.service.IStuffDocumentService;
import com.ejianc.business.tender.stuff.service.IStuffDocumentSupplierService;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.stuff.service.IStuffNoticeService;
import com.ejianc.business.tender.stuff.service.IStuffPicketageService;
import com.ejianc.business.tender.stuff.service.IStuffPicketageSupplierService;
import com.ejianc.business.tender.stuff.service.IStuffWinnoticeService;
import com.ejianc.business.tender.stuff.vo.StuffPicketageSupplierVO;
import com.ejianc.business.tender.stuff.vo.StuffWinnoticeVO;
import com.ejianc.business.tender.stuff.vo.TenderStageEnum;
import com.ejianc.business.tender.stuff.vo.WinDetailVO;
import com.ejianc.business.tender.stuff.vo.WinVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="stuffWinnoticeService")
public class StuffWinnoticeServiceImpl
extends BaseServiceImpl<StuffWinnoticeMapper, StuffWinnoticeEntity>
implements IStuffWinnoticeService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IStuffPicketageService stuffPicketageService;
    @Autowired
    private IStuffPicketageSupplierService stuffPicketageSupplierService;
    @Autowired
    private IStuffNoticeService stuffNoticeService;
    @Autowired
    private IStuffDocumentService stuffDocumentService;
    @Autowired
    private IStuffInviteService stuffInviteService;
    @Autowired
    private IStuffBidDetailService stuffBidDetailService;
    @Autowired
    private IStuffDocumentSellService stuffDocumentSellService;
    @Autowired
    private IStuffBidSupplierService stuffBidSupplierService;
    @Autowired
    private IStuffDocumentSupplierService stuffDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private CacheManager cacheManager;
    @Value(value="${gysUrl.winSaveOrUpdateUrl}")
    private String winSaveOrUpdateUrl;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String BILL_TYPE = "BT211228000000001";
    @Autowired
    private ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    @Transactional
    public StuffWinnoticeVO saveWinnotice(Long picketageId) {
        StuffWinnoticeEntity entity = new StuffWinnoticeEntity();
        entity.setPicketageId(picketageId);
        StuffPicketageEntity stuffPicketageEntity = (StuffPicketageEntity)((Object)this.stuffPicketageService.selectById(picketageId));
        StuffInviteEntity inviteEntity = (StuffInviteEntity)((Object)this.stuffInviteService.selectById(stuffPicketageEntity.getInviteId()));
        entity.setInviteId(stuffPicketageEntity.getInviteId());
        entity.setTitleName(inviteEntity.getTenderName() + "\u4e2d\u6807\u516c\u544a");
        entity.setInviteName(inviteEntity.getTenderName());
        entity.setLineTypeName(CommonUtils.getTypeName(0));
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode((Integer)inviteEntity.getTenderType()).getDescription());
        entity.setUnitId(inviteEntity.getUnitId());
        entity.setUnitName(inviteEntity.getUnitName());
        if (inviteEntity.getPurchaseType().equals(0)) {
            entity.setOrgId(inviteEntity.getOrgId());
            entity.setOrgName(inviteEntity.getOrgName());
            entity.setProjectId(inviteEntity.getProjectId());
            entity.setProjectName(inviteEntity.getProjectName());
            entity.setProjectCode(inviteEntity.getProjectCode());
            entity.setParentOrgId(inviteEntity.getParentOrgId());
            entity.setParentOrgName(inviteEntity.getParentOrgName());
        }
        if (inviteEntity.getPurchaseType().equals(1)) {
            entity.setOrgId(inviteEntity.getOrgId());
            entity.setOrgName(inviteEntity.getOrgName());
        }
        StuffDocumentEntity stuffDocumentEntity = (StuffDocumentEntity)((Object)this.stuffDocumentService.selectById(stuffPicketageEntity.getDocumentId()));
        entity.setEmployeeId(stuffDocumentEntity.getEmployeeId());
        entity.setEmployeeName(stuffDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(stuffDocumentEntity.getEmployeeMobile());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setSignFlag(0);
        super.saveOrUpdate((Object)entity, false);
        stuffPicketageEntity.setWinnoticeStatus(1);
        stuffPicketageEntity.setWinnoticeId(entity.getId());
        this.stuffPicketageService.updateById((Object)stuffPicketageEntity);
        List<StuffPicketageSupplierEntity> picketageSupplierList = stuffPicketageEntity.getPicketageSupplierList();
        for (StuffPicketageSupplierEntity stuffPicketageSupplierEntity : picketageSupplierList) {
            stuffPicketageSupplierEntity.setWinnoticeId(entity.getId());
        }
        this.stuffPicketageSupplierService.updateBatchById(picketageSupplierList);
        inviteEntity.setTenderStage(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getTenderTypeCode());
        this.stuffInviteService.updateById((Object)inviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(0);
        processEntity.setFrontendUrl("stuff/winnotice");
        this.processService.saveOrUpdate((Object)processEntity);
        StuffWinnoticeVO stuffWinnoticeVO = (StuffWinnoticeVO)BeanMapper.map((Object)((Object)entity), StuffWinnoticeVO.class);
        return stuffWinnoticeVO;
    }

    @Override
    public StuffWinnoticeVO queryDetail(Long id) {
        Map attacMap;
        AttachmentVO attachmentVO;
        List data;
        Long id1;
        CommonResponse listCommonResponse;
        StuffWinnoticeEntity stuffWinnoticeEntity = (StuffWinnoticeEntity)((Object)super.selectById((Serializable)id));
        StuffWinnoticeVO stuffWinnoticeVO = (StuffWinnoticeVO)BeanMapper.map((Object)((Object)stuffWinnoticeEntity), StuffWinnoticeVO.class);
        StuffPicketageEntity stuffPicketageEntity = (StuffPicketageEntity)((Object)this.stuffPicketageService.selectById(stuffWinnoticeEntity.getPicketageId()));
        List<StuffPicketageSupplierEntity> picketageSupplierList = stuffPicketageEntity.getPicketageSupplierList();
        List stuffPicketageSupplierList = BeanMapper.mapList(picketageSupplierList, StuffPicketageSupplierVO.class);
        stuffWinnoticeVO.setPicketageSupplierList(stuffPicketageSupplierList);
        if (stuffWinnoticeVO != null && (listCommonResponse = this.attachmentApi.queryListBySourceId(id1 = stuffWinnoticeVO.getId(), BILL_TYPE, "tenderWinnotice", "")).isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)listCommonResponse.getData())) && (attachmentVO = (AttachmentVO)(attacMap = data.stream().filter(s -> s.getSourceType().equals("tenderWinnotice")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()))).get(stuffWinnoticeVO.getId())) != null) {
            stuffWinnoticeVO.setAttachId(attachmentVO.getId());
            stuffWinnoticeVO.setFileName(attachmentVO.getFileName());
            stuffWinnoticeVO.setFilePath(attachmentVO.getFilePath());
        }
        return stuffWinnoticeVO;
    }

    @Override
    public StuffWinnoticeVO publishWinnotice(Long id) {
        StuffWinnoticeEntity stuffWinnoticeEntity = (StuffWinnoticeEntity)((Object)super.selectById((Serializable)id));
        stuffWinnoticeEntity.setPublishFlag(0);
        super.updateById((Object)stuffWinnoticeEntity);
        StuffPicketageEntity stuffPicketageEntity = (StuffPicketageEntity)((Object)this.stuffPicketageService.selectById(stuffWinnoticeEntity.getPicketageId()));
        stuffPicketageEntity.setWinnoticeStatus(2);
        this.stuffPicketageService.updateById((Object)stuffPicketageEntity);
        StuffInviteEntity stuffInviteEntity = (StuffInviteEntity)((Object)this.stuffInviteService.selectById(stuffPicketageEntity.getInviteId()));
        WinVO winVO = new WinVO();
        winVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u4e2d\u6807\u516c\u544a");
        winVO.setSourceId(Long.toString(stuffWinnoticeEntity.getInviteId()));
        winVO.setBillCode(stuffInviteEntity.getBillCode());
        if (stuffInviteEntity.getPurchaseType() == 0) {
            winVO.setSourceProjectId(Long.toString(stuffInviteEntity.getProjectId()));
            winVO.setProjectName(stuffInviteEntity.getProjectName());
            winVO.setProjectCode(stuffInviteEntity.getProjectCode());
        }
        if (stuffInviteEntity.getPurchaseType() == 1) {
            winVO.setOrgName(stuffInviteEntity.getOrgName());
            winVO.setSourceOrgId(Long.toString(stuffInviteEntity.getOrgId()));
        }
        winVO.setSourceUnitId(Long.toString(stuffInviteEntity.getUnitId()));
        winVO.setUnitName(stuffInviteEntity.getUnitName());
        winVO.setType("MATERIAL");
        winVO.setTenderName(stuffInviteEntity.getTenderName());
        winVO.setTenderType(stuffInviteEntity.getTenderType());
        winVO.setSourceEmployeeId(Long.toString(stuffWinnoticeEntity.getEmployeeId()));
        winVO.setEmployeeName(stuffWinnoticeEntity.getEmployeeName());
        winVO.setEmployeeMobile(stuffWinnoticeEntity.getEmployeeMobile());
        winVO.setPurchaseType(stuffInviteEntity.getPurchaseType());
        winVO.setWinDate(stuffWinnoticeEntity.getWinDate());
        winVO.setStopDate(stuffWinnoticeEntity.getStopDate());
        winVO.setWinTitle(stuffWinnoticeEntity.getTitleName());
        winVO.setMemo(stuffWinnoticeEntity.getMemo());
        winVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        List<StuffPicketageSupplierEntity> picketageSupplierList = stuffPicketageEntity.getPicketageSupplierList();
        ArrayList<WinDetailVO> winDetailVOS = new ArrayList<WinDetailVO>();
        for (StuffPicketageSupplierEntity stuffPicketageSupplierEntity : picketageSupplierList) {
            WinDetailVO winDetailVO = new WinDetailVO();
            winDetailVO.setWinId(stuffWinnoticeEntity.getId());
            winDetailVO.setSupplierName(stuffPicketageSupplierEntity.getSupplierName());
            winDetailVO.setTenderFlag(stuffPicketageSupplierEntity.getTenderFlag());
            SupplierDTO supplierVO = (SupplierDTO)this.shareSupplierApi.queryById(stuffPicketageSupplierEntity.getSupplierId()).getData();
            winDetailVO.setTenantId(supplierVO.getTenant());
            winDetailVO.setMoney(stuffPicketageSupplierEntity.getMoneyTax());
            winDetailVOS.add(winDetailVO);
        }
        winVO.setWinDetailList(winDetailVOS);
        String stringFb = JSONObject.toJSONString((Object)winVO);
        this.logger.info("\u4e2d\u6807\u516c\u544a\u53d1\u5e03" + stringFb);
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.winSaveOrUpdateUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u4e2d\u6807\u516c\u544a\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(id);
    }

    @Override
    public StuffWinnoticeVO saveOrUpdates(StuffWinnoticeEntity entity) {
        super.saveOrUpdate((Object)entity, false);
        return this.queryDetail(entity.getId());
    }

    @Override
    public CommonResponse<String> changeStatus(Long billId, int status, String refCode) {
        StuffWinnoticeEntity stuffWinnoticeEntity = (StuffWinnoticeEntity)((Object)super.selectById((Serializable)billId));
        if (status == 5 || status == 6 || status == 7 || status == 8) {
            stuffWinnoticeEntity.setSignFlag(0);
        }
        if (status == 2 || status == 3) {
            stuffWinnoticeEntity.setSignFlag(1);
        }
        if (status == 4) {
            stuffWinnoticeEntity.setSignFlag(2);
            ContractVO cv = new ContractVO();
            cv.setContractId(stuffWinnoticeEntity.getId());
            cv.setContractName(stuffWinnoticeEntity.getTitleName());
            cv.setBillType(BILL_TYPE);
            cv.setSourceType("tenderWinnotice");
            ArrayList<ContractVO> cvs = new ArrayList<ContractVO>();
            cvs.add(cv);
            CommonResponse signResp = this.signatureCommonApi.fetchSignedContract(cvs);
            if (!signResp.isSuccess()) {
                throw new BusinessException("\u540c\u6b65\u7b7e\u7ae0\u9644\u4ef6\u5931\u8d25!");
            }
        }
        super.updateById((Object)stuffWinnoticeEntity);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f!");
    }
}

