package com.ejianc.business.tender.equipment.controller;

import com.ejianc.business.tender.equipment.bean.EquipmentBidEntity;
import com.ejianc.business.tender.equipment.service.IEquipmentBidService;
import com.ejianc.business.tender.equipment.vo.EquipmentBidVO;
import com.ejianc.business.tender.equipment.vo.EquipmentPicketageSupplierVO;
import com.ejianc.business.tender.equipment.vo.EquipmentPicketageVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 中标主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("equipmentBid")
@Api(value = "中标主表", tags = {"中标主表"})
public class EquipmentBidController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "invite-bid-code";//此处需要根据实际修改

    @Autowired
    private IEquipmentBidService service;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<EquipmentBidVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody EquipmentBidVO saveorUpdateVO) {
    	EquipmentBidEntity entity = BeanMapper.map(saveorUpdateVO, EquipmentBidEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	EquipmentBidVO vo = BeanMapper.map(entity, EquipmentBidVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @ApiOperation("生成中标通知书接口")
    @RequestMapping(value = "/saveBid", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EquipmentBidVO> saveBid(@RequestParam Long picketageId) {
        EquipmentBidVO equipmentBidVO = service.saveBid(picketageId);
    	return CommonResponse.success("保存或修改单据成功！",equipmentBidVO);
    }
    @ApiOperation("新增进展接口")
    @RequestMapping(value = "/insertProcess", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EquipmentPicketageVO> insertProcess(@RequestParam Long picketageId) {
        EquipmentPicketageVO equipmentPicketageVO = service.insertProcess(picketageId);
    	return CommonResponse.success("保存或修改单据成功！",equipmentPicketageVO);
    }
    @ApiOperation("中标公告下一步接口")
    @RequestMapping(value = "/nextPaper", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EquipmentBidVO> nextPaper(@RequestParam Long winnoticeId) {
        EquipmentBidVO equipmentBidVO = service.nextPaper(winnoticeId);
        return CommonResponse.success("初始化基础数据成功！",equipmentBidVO);
    }


    @ApiOperation("发布接口")
    @RequestMapping(value = "/publishBid", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<EquipmentBidVO> publishBid(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody EquipmentBidVO saveorUpdateVO) {
        EquipmentBidVO equipmentBidVO = service.publishBid(saveorUpdateVO);
        return CommonResponse.success("发布成功！",equipmentBidVO);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<EquipmentPicketageSupplierVO>> querySupplierDetail(@RequestParam Long id) {
        List<EquipmentPicketageSupplierVO> list = service.querySupplierDetail(id);
        return CommonResponse.success("查询详情数据成功！",list);
    }

//    @ApiOperation("查询供应商列表详情")
//    @RequestMapping(value = "/querySupplierList", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<List<EquipmentPicketageSupplierVO>> querySupplierList(@RequestParam Long picketageId) {
//        List<EquipmentPicketageSupplierVO> list = service.querySupplierList(picketageId);
//        return CommonResponse.success("查询详情数据成功！",list);
//    }
    @ApiOperation("定标下一步查询详情接口")
    @RequestMapping(value = "/queryDbDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EquipmentBidVO> queryDbDetail(@RequestParam Long picketage) {
        EquipmentBidVO equipmentBidVO = service.queryDbDetail(picketage);
        return CommonResponse.success("查询详情数据成功！",equipmentBidVO);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EquipmentBidVO> vos) {
        service.removeByIds(vos.stream().map(EquipmentBidVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }




}
