package com.ejianc.business.tender.equipment.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.material.vo.MaterialBatchPlanEnum;
import com.ejianc.business.pro.rmat.vo.BatchPlanEnum;
import com.ejianc.business.purchase.api.IProequipmentpContractApi;
import com.ejianc.business.purchaseplan.vo.PurchasePlanEnum;
import com.ejianc.business.purchaseplan.vo.api.IPurchasePlanApi;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.equipment.bean.*;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteDetailRecordService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.equipment.service.IEquipmentPicketageRefsupplierService;
import com.ejianc.business.tender.equipment.service.IEquipmentPicketageService;
import com.ejianc.business.tender.equipment.service.impl.EquipmentInviteBpmServiceImpl;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteDetailBidderVO;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteDetailRecordVO;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteVO;
import com.ejianc.business.tender.equipment.vo.TenderStageEnum;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteDetailRecordEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 材料立项主表
 *
 * @author generator
 */
@Controller
@RequestMapping("equipmentInvite")
public class EquipmentInviteController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "TENDER_EQUIPMENT";//此处需要根据实际修改

    /**
     * 参照查询：项目ID
     */
    private static final String CONDITION_PROJECT_ID = "projectId";
    /**
     * 参照查询：组织ID
     */
    private static final String CONDITION_ORG_ID = "orgId";

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IEquipmentInviteService service;

    @Autowired
    private IEquipmentInviteDetailRecordService detailRecordService;

    @Autowired
    private IProcessService processService;

    @Autowired
    private IPurchasePlanApi batPlanApi;

    @Autowired
    private IEquipmentPicketageService picketageService;

    @Autowired
    private IEquipmentPicketageRefsupplierService refsupplierService;

    @Autowired
    private IProequipmentpContractApi contractApi;

    @Autowired
    private SessionManager sessionManager;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<EquipmentInviteVO> saveOrUpdate(@RequestBody EquipmentInviteVO saveorUpdateVO) {
        //处理子表供应商中标信息
        List<EquipmentInviteDetailRecordVO> equipmentInviteDetailList = saveorUpdateVO.getEquipmentDetailRecord();
        List<EquipmentInviteDetailBidderEntity> bidderEntityList = new ArrayList<EquipmentInviteDetailBidderEntity>();
        if (CollectionUtils.isNotEmpty(equipmentInviteDetailList)) {
            for (EquipmentInviteDetailRecordVO equipmentInviteDetailVO : equipmentInviteDetailList) {
                if (equipmentInviteDetailVO.getId() == null) {
                    long id = IdWorker.getId();
                    equipmentInviteDetailVO.setId(id);
                }
                List<EquipmentInviteDetailBidderVO> bidderList = equipmentInviteDetailVO.getEquipmentDetailBidder();
                if (CollectionUtils.isNotEmpty(bidderList)) {
                    for (EquipmentInviteDetailBidderVO bidderVO : bidderList) {
                        bidderVO.setInviteDetailId(equipmentInviteDetailVO.getId());
                        EquipmentInviteDetailBidderEntity bidderEntity = BeanMapper.map(bidderVO, EquipmentInviteDetailBidderEntity.class);
                        bidderEntityList.add(bidderEntity);
                    }
                }
            }
        }

        EquipmentInviteEntity entity = BeanMapper.map(saveorUpdateVO, EquipmentInviteEntity.class);
        if (CollectionUtils.isNotEmpty(bidderEntityList)) {
            entity.setEquipmentDetailBidder(bidderEntityList);
        }
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveorUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        EquipmentInviteEntity equipmentInviteEntity = service.selectById(saveorUpdateVO.getId());
        if (null != equipmentInviteEntity) {
            service.updateApiState(equipmentInviteEntity, PurchasePlanEnum.PLAN_STATE_WAIT.getPlanState(), PurchasePlanEnum.PLAN_STATE_WAIT.getPlanState());
        }

        entity.setSignStatus(TenderSignStatusEnum.未签订.getCode());
        service.saveOrUpdate(entity, false);
        EquipmentInviteVO vo = BeanMapper.map(entity, EquipmentInviteVO.class);

        //处理供应商子表信息
        List<EquipmentInviteDetailRecordVO> equipmentInviteDetailVOList = vo.getEquipmentDetailRecord();
        List<EquipmentInviteDetailBidderVO> equipmentInviteDetailBidderVOList = vo.getEquipmentDetailBidder();
        if (CollectionUtils.isNotEmpty(equipmentInviteDetailBidderVOList)) {
            Map<Long, List<EquipmentInviteDetailBidderVO>> bidderMap = equipmentInviteDetailBidderVOList.stream().
                    collect(Collectors.groupingBy(EquipmentInviteDetailBidderVO::getInviteDetailId));
            if (CollectionUtils.isNotEmpty(equipmentInviteDetailVOList)) {
                for (EquipmentInviteDetailRecordVO equipmentInviteDetailVO : equipmentInviteDetailVOList) {
                    List<EquipmentInviteDetailBidderVO> equipmentInviteDetailBidderVOS = bidderMap.get(equipmentInviteDetailVO.getId());
                    if (CollectionUtils.isNotEmpty(equipmentInviteDetailBidderVOS)) {
                        equipmentInviteDetailVO.setEquipmentDetailBidder(equipmentInviteDetailBidderVOS);
                    }
                }
            }
        }
        //修改计划状态
        service.updateApiState(entity, PurchasePlanEnum.PLAN_STATE_EXEC.getPlanState(), PurchasePlanEnum.PLAN_STATE_EXEC.getPlanState());

        if (entity.getEstablishType() == 1) {
            //修改招标状态
            List<Long> inviteIdList = entity.getEquipmentDetailRecord().stream().map(EquipmentInviteDetailRecordEntity::getPlanId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(inviteIdList)) {
                UpdateWrapper<EquipmentInviteEntity> wrapper = new UpdateWrapper<>();
                wrapper.set("occupy_state", 1).in("id", inviteIdList);
                service.update(wrapper);
            }
        }
        //保存招标过程记录表
        if (!processService.selectByBillId(entity.getId())) {
            ProcessEntity processEntity = new ProcessEntity();
            processEntity.setBillId(entity.getId());
            if (vo.getEstablishType() == 1) {
                processEntity.setBillName("定标立项");
            }
            else {
                processEntity.setBillName("招标立项");
            }
            processEntity.setTenderId(entity.getId());
            processEntity.setType(2);
            processEntity.setFrontendUrl("equipment/invite/card");
            processService.saveOrUpdate(processEntity);
        }
        return CommonResponse.success("保存或修改单据成功！", vo);
    }
    @Autowired
    private EquipmentInviteBpmServiceImpl bpmService;
    @RequestMapping(value = "/test", method = RequestMethod.GET)
    @ResponseBody
    public void test() {
        bpmService.afterApprovalProcessor(
                Long.parseLong("685154414419296308"),
                1,
                "BT220317000000010");
    }
    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EquipmentInviteVO> queryDetail(Long id) {
        EquipmentInviteEntity entity = service.selectById(id);
        EquipmentInviteVO vo = BeanMapper.map(entity, EquipmentInviteVO.class);
        //处理供应商子表信息
        List<EquipmentInviteDetailRecordVO> equipmentInviteDetailVOList = vo.getEquipmentDetailRecord();
        List<EquipmentInviteDetailBidderVO> equipmentInviteDetailBidderVOList = vo.getEquipmentDetailBidder();
        if (CollectionUtils.isNotEmpty(equipmentInviteDetailBidderVOList)) {
            Map<Long, List<EquipmentInviteDetailBidderVO>> bidderMap = equipmentInviteDetailBidderVOList.stream().
                    collect(Collectors.groupingBy(EquipmentInviteDetailBidderVO::getInviteDetailId));
            if (CollectionUtils.isNotEmpty(equipmentInviteDetailVOList)) {
                for (EquipmentInviteDetailRecordVO equipmentInviteDetailVO : equipmentInviteDetailVOList) {
                    List<EquipmentInviteDetailBidderVO> equipmentInviteDetailBidderVOS = bidderMap.get(equipmentInviteDetailVO.getId());
                    if (CollectionUtils.isNotEmpty(equipmentInviteDetailBidderVOS)) {
                        equipmentInviteDetailVO.setEquipmentDetailBidder(equipmentInviteDetailBidderVOS);
                    }
                }
            }
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EquipmentInviteVO> vos) {
        List<Long> idList = vos.stream().map(EquipmentInviteVO::getId).collect(Collectors.toList());
        for (Long inviteId : idList) {
            service.updateApiState(service.selectById(inviteId), PurchasePlanEnum.PLAN_STATE_WAIT.getPlanState(), PurchasePlanEnum.PLAN_STATE_WAIT.getPlanState());
//            List<String> planIdList = detailRecordService.list(new LambdaQueryWrapper<EquipmentInviteDetailRecordEntity>()
//                    .eq(EquipmentInviteDetailRecordEntity::getInviteId, inviteId))
//                    .stream().map(EquipmentInviteDetailRecordEntity::getPlanId)
//                    .map(String::valueOf).distinct().collect(Collectors.toList());
//            batPlanApi.updateBatPlanQuote(planIdList, PurchasePlanEnum.PLAN_STATE_WAIT.getPlanState());

            //修改招标状态
            EquipmentInviteEntity inviteEntity = service.selectById(inviteId);
            if (inviteEntity.getEstablishType() == 1) {
                List<String> inviteIdList = detailRecordService.list(new LambdaQueryWrapper<EquipmentInviteDetailRecordEntity>()
                        .eq(EquipmentInviteDetailRecordEntity::getInviteId, inviteId))
                        .stream().map(EquipmentInviteDetailRecordEntity::getPlanId)
                        .map(String::valueOf).distinct().collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(inviteIdList)) {
                    UpdateWrapper<EquipmentInviteEntity> wrapper = new UpdateWrapper<>();
                    wrapper.set("occupy_state", 0).in("id", inviteIdList);
                    service.update(wrapper);
                }
            }
        }
        service.removeByIds(vos.stream().map(EquipmentInviteVO::getId).collect(Collectors.toList()), true);
        processService.remove(new LambdaQueryWrapper<ProcessEntity>().in(ProcessEntity::getBillId, vos.stream().map(EquipmentInviteVO::getId).collect(Collectors.toList())));
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EquipmentInviteVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("tenderName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("purchaseTypeName");
        fuzzyFields.add("tenderStage");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Parameter isMyOrder = param.getParams().get("isMyOrder");
        if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")&&isMyOrder.getValue().toString().contains("1")){
            param.getParams().remove("employeeId");
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")){
            param.getParams().put("employeeId", new Parameter(QueryParam.EQ, Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("1")){
            param.getParams().put("employeeId", new Parameter(QueryParam.NE, Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        }
        param.getParams().remove("isMyOrder");

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<EquipmentInviteEntity> page = service.queryPage(param, false);
        IPage<EquipmentInviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EquipmentInviteVO.class));
        for (EquipmentInviteVO record : pageData.getRecords()) {
            if(record.getTenderType() != null){
                switch (record.getTenderType()) {
                    case 0:
                        record.setTenderTypeName("平台公开招标");
                        break;
                    case 1:
                        record.setTenderTypeName("邀请招标");
                        break;
                    case 2:
                        record.setTenderTypeName("询价");
                        break;
                    case 3:
                        record.setTenderTypeName("竞争性谈判");
                        break;
                    case 4:
                        record.setTenderTypeName("单一来源");
                        break;
                    case 5:
                        record.setTenderTypeName("紧急招标");
                        break;
                }
                switch (record.getSignStatus()) {
                    case 0:
                        record.setSignStatusName("未签订");
                        break;
                    case 1:
                        record.setSignStatusName("部分签订");
                        break;
                    case 2:
                        record.setSignStatusName("全部已签");
                        break;
                    case 3:
                        record.setSignStatusName("已关闭");
                        break;
                }
            }

            record.setEstablishTypeName(record.getEstablishType() == 0 ? "招标立项" : "定标立项");
            record.setPurchaseTypeName(record.getPurchaseType() == 0 ? "项目采购" : "单位采购");
            record.setTenderStageName(TenderStageEnum.getEnumByStateCode(record.getTenderStage()).getDescription());
        }
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        fuzzyFields.add("tenderName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("employeeName");
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<EquipmentInviteEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<EquipmentInviteVO> voList = JSON.parseArray(JSON.toJSONString(list), EquipmentInviteVO.class);
        for (EquipmentInviteVO equipmentInviteVO : voList) {
            switch (equipmentInviteVO.getTenderType()) {
                case 0:
                    equipmentInviteVO.setTenderTypeName("平台公开招标");
                    break;
                case 1:
                    equipmentInviteVO.setTenderTypeName("邀请招标");
                    break;
                case 2:
                    equipmentInviteVO.setTenderTypeName("询价");
                    break;
                case 3:
                    equipmentInviteVO.setTenderTypeName("竞争性谈判");
                    break;
                case 4:
                    equipmentInviteVO.setTenderTypeName("单一来源");
                    break;
                case 5:
                    equipmentInviteVO.setTenderTypeName("紧急招标");
                    break;
            }
            equipmentInviteVO.setEstablishTypeName(equipmentInviteVO.getEstablishType() == 0 ? "招标立项" : "定标立项");
            equipmentInviteVO.setPurchaseTypeName(equipmentInviteVO.getPurchaseType() == 0 ? "项目采购" : "单位采购");
            equipmentInviteVO.setBillStateName(BillStateEnum.getEnumByStateCode(equipmentInviteVO.getBillState()).getDescription());
            equipmentInviteVO.setTenderStageName(TenderStageEnum.getEnumByStateCode(equipmentInviteVO.getTenderStage()).getDescription());
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("材料立项.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refEquipmentInviteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<EquipmentInviteVO>> refEquipmentInviteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                           String condition,
                                                                           String searchObject,
                                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("tenderPlatform", new Parameter(QueryParam.EQ, 2));
        param.getParams().put("occupyState", new Parameter(QueryParam.EQ, 0));

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("tenderName");

        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            // 项目id
            if (_con.containsKey(CONDITION_PROJECT_ID)) {
                Long projectId = Long.parseLong(_con.get(CONDITION_PROJECT_ID).toString());
                CommonResponse<List<Long>> projectResponse = projectPoolApi.queryProjectIdsByParentProjectId(projectId);
                if (!projectResponse.isSuccess()) {
                    throw new BusinessException("查询项目信息失败！");
                }
                param.getParams().put("projectId", new Parameter(QueryParam.IN, projectResponse.getData()));
            }
            // 组织id
            if (_con.containsKey(CONDITION_ORG_ID)) {
                Long orgId = Long.valueOf(_con.get(CONDITION_ORG_ID).toString());
                CommonResponse<OrgVO> orgResp = iOrgApi.getOneById(orgId);
                OrgVO orgVO = orgResp.getData();
                /** 数据隔离，如果查询组织为项目部，查询orgId，否则查询parentOrgId本下 */
                if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgVO.getOrgType())) {
                    param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
                }
                else {
                    param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi
                            .findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId)
                            .collect(Collectors.toList())));
                }
            }
            if(_con.containsKey("purchaseType")){
                Integer purchaseType = _con.getInteger("purchaseType");
                param.getParams().put("purchaseType", new Parameter(QueryParam.EQ,purchaseType));
            }
        }
        IPage<EquipmentInviteEntity> page = service.queryPage(param, false);
        IPage<EquipmentInviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EquipmentInviteVO.class));

        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<EquipmentInviteVO> equipmentInviteVOList = pageData.getRecords();
            List<String> idList = equipmentInviteVOList.stream().map(EquipmentInviteVO::getId).map(String::valueOf)
                    .collect(Collectors.toList());
            // 查询子表
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("inviteId", new Parameter(QueryParam.IN, idList));
            List<EquipmentInviteDetailRecordEntity> detailEntityList = detailRecordService.queryList(detailParam);
            List<EquipmentInviteDetailRecordVO> detailVOList = BeanMapper.mapList(detailEntityList, EquipmentInviteDetailRecordVO.class);
            Map<Long, List<EquipmentInviteDetailRecordVO>> detailMap = new HashMap<>();
            List<EquipmentInviteDetailRecordVO> mapList;
            // 按照planID对子表结果分组
            for (EquipmentInviteDetailRecordVO vo : detailVOList) {
                if (detailMap.containsKey(vo.getInviteId())) {
                    detailMap.get(vo.getInviteId()).add(vo);
                }
                else {
                    mapList = new ArrayList<>();
                    mapList.add(vo);
                    detailMap.put(vo.getInviteId(), mapList);
                }
            }
            // 将清单添加到主表中
            equipmentInviteVOList.forEach(t -> {
                t.setEquipmentDetailRecord(detailMap.get(t.getId()));
            });
        }
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @Description saveOrUpdate 获取流/废标状态
     */
    @RequestMapping(value = "/getAType", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, Object>> getAType(Long tenderId) {
        Map<String, Object> map = service.getAbolishType(tenderId);
        return CommonResponse.success("查询流/废标状态成功！", map);
    }

    /**
     * @param
     * @Description 子表导出
     * @Return void
     */
    @RequestMapping(value = "/detailExcelExport", method = RequestMethod.GET)
    @ResponseBody
    public void detailExcelExport(Long id, HttpServletResponse response) {
        EquipmentInviteVO equipmentInviteVO = queryDetail(id).getData();
        List<EquipmentInviteDetailRecordVO> detailList = equipmentInviteVO.getEquipmentDetailRecord();
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", detailList);
        ExcelExport.getInstance().export("equipmentInviteDetail.xlsx", beans, response);
    }

    @RequestMapping(value = "/queryContract", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SignContractVo>> queryContract(@RequestBody EquipmentInviteVO inviteVO) {
        Long refId;
        //招标立项
        if (inviteVO.getEstablishType() == 0) {
            EquipmentPicketageEntity picketageEntity = picketageService.list(new QueryWrapper<EquipmentPicketageEntity>().eq("invite_id", inviteVO.getId())).get(0);
            refId = picketageEntity.getId();
        }
        else {
            refId = inviteVO.getId();
        }
        logger.info("定标ID" + refId);
        List<EquipmentPicketageRefsupplierEntity> refsupplierList = refsupplierService.list(new QueryWrapper<EquipmentPicketageRefsupplierEntity>().eq("picketage_id", refId));
        List<String> idList = refsupplierList.stream().map(EquipmentPicketageRefsupplierEntity::getId).map(String::valueOf).collect(Collectors.toList());
        logger.info("定标参照ID" + JSONObject.toJSONString(idList));
        CommonResponse<List<SignContractVo>> response = contractApi.queryContractByTargetResultId(idList);
        if (!response.isSuccess()) {
            throw new BusinessException("查询合同失败" + response.getMsg());
        }
        response.getData().forEach(t -> t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription()));
        return CommonResponse.success(response.getData());
    }

    @RequestMapping(value = "/closeSignStatus", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse closeSignStatus(Long id) {
        EquipmentInviteEntity entity = service.selectById(id);
        Long refId = null;
        Integer tenderStage = entity.getTenderStage();
        Integer establishType = entity.getEstablishType();
        if (sessionManager.getUserContext().getEmployeeId().equals(entity.getEmployeeId())) {
            //处于未签订、部分签订
            if (entity.getSignStatus() == 0 || entity.getSignStatus() == 1) {
                //招标立项
                if (establishType == 0) {
                    if (tenderStage == 5 || tenderStage == 13 || tenderStage == 14) {
                        EquipmentPicketageEntity picketageEntity = picketageService.list(new QueryWrapper<EquipmentPicketageEntity>().eq("invite_id", id)).get(0);
                        refId = picketageEntity.getId();
                    }
                }
                //定标立项
                else {
                    if (entity.getBillState() == 1 || entity.getBillState() == 3) {
                        refId = id;
                    }
                }
            }
            else {
                throw new BusinessException("不符合关闭条件");
            }
            if (refId != null) {
                logger.info("定标ID" + refId);
                List<EquipmentPicketageRefsupplierEntity> refsupplierList = refsupplierService.list(new QueryWrapper<EquipmentPicketageRefsupplierEntity>().eq("picketage_id", refId));
                if (CollectionUtils.isNotEmpty(refsupplierList)) {
                    refsupplierList.forEach(t -> t.setSignStatus(TenderSignStatusEnum.已关闭.getCode()));
                    refsupplierService.saveOrUpdateBatch(refsupplierList);
                    entity.setSignStatus(TenderSignStatusEnum.已关闭.getCode());
                    service.saveOrUpdate(entity);
                }
                else {
                    throw new BusinessException("不符合关闭条件");
                }
            }
            else {
                throw new BusinessException("不符合关闭条件");
            }
        }
        else {
            throw new BusinessException("只有招标经办人才能关闭");
        }
        return CommonResponse.success("关闭成功！");
    }
    /**
     * @Description  判断当前登录人和招标经办人是否相同
     */
    @RequestMapping(value = "/judgeEmployee", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> judgeEmployee (Long inviteId) {
        boolean flag = false;
        EquipmentInviteEntity entity = service.selectById(inviteId);
        if (sessionManager.getUserContext().getEmployeeId().equals(entity.getEmployeeId())) {
            flag = true;
        }
        return CommonResponse.success("查询数据成功！", flag);
    }
}
